@ECHO OFF
CLS
IF EXIST heresy.wad GOTO fail
IF NOT EXIST heretic.wad GOTO noher
IF NOT EXIST doom2.wad GOTO nodm2
IF NOT EXIST deutex.exe GOTO nodeu
echo Heretic found.
echo Doom2 found.
echo Deutex found.
set heresydc=0
IF EXIST doom.wad set heresydc=1
if %heresydc%==1 echo Doom found.
echo DOOM: THE HERESY v0.11 ALPHA INSTALLATION
echo You must install from a new separate folder for THE HERESY.
echo You need at least 35 MB of free disk space to install the game.
if %heresydc%==1 echo DOOM textures support enabled. This will build an IWAD.
echo Hit CTRL+C now to abort installation. Then answer 'y'.
pause
goto install

:noher
echo Could not find your registered version of HERETIC. 
goto abort

:nodm2
echo Could not find your DOOM2 iwad.
goto abort

:nodeu
echo Could not find DEUTEX. Installation aborted.
goto end

:abort
echo Installation aborted. Both DOOM2 and HERETIC iwads must be present in
echo the installation folder.

goto end

:fail
echo Installation failed. May be THE HERESY is already installed or
echo may be you're using DEUTEX 4.4 under pure DOS and you have not
echo installed CWSDPMI.
goto end

:fail2
echo Installation failed. May be you are using an older HERETIC version.
goto end

:install
echo This will take some time depending on your computer.
echo Extracting resources from HERETIC...
deutex -rgb 0 255 255 -textures -patches -flats -sounds -musics -levels -xtract heretic.wad > install.log
IF NOT EXIST wadinfo.txt GOTO fail
echo Extracting resources from INSTALL.WAD...
del wadinfo.txt
deutex -rgb 0 255 255 -lumps -sprites -sounds -musics -xtract install.wad >> install.log
echo Extracting resources from DOOM2...
del wadinfo.txt
deutex -rgb 0 255 255 -patches -flats -graphics -sprites -xtract doom2.wad >> install.log
IF %heresydc%==1 del wadinfo.txt
IF %heresydc%==1 deutex -sounds -musics -xtract doom2.wad >> install.log
IF %heresydc%==1 echo Extracting resources from DOOM...
IF %heresydc%==1 del wadinfo.txt
IF %heresydc%==1 deutex -rgb 0 255 255 -patches -musics -xtract doom.wad >> install.log
echo Applying custom palette...
move .\lumps\palette.lmp playpal.wad >> install.log
del wadinfo.txt
deutex -xtract playpal.wad >> install.log
deutex -doom . -join doom2.wad playpal.wad >> install.log
IF %heresydc%==1 deutex -doom . -join doom.wad playpal.wad >> install.log
echo Extracting skies and graphics from INSTALL.WAD...
del .\graphics\titlepic.bmp
del .\graphics\bossback.bmp
del .\graphics\interpic.bmp
del .\graphics\m_doom.bmp
del .\graphics\help.bmp
del .\flats\ceil4_1.bmp
IF %heresydc%==1 del.\patches\sky4.bmp
del wadinfo.txt
deutex -doom . -rgb 0 255 255 -patches -graphics -flats -xtract install.wad >> install.log
echo Creating HERESY.WAD with HERETIC and DOOM2 resources.
echo Converting DOOM2 graphics to custom palette...
move .\lumps\herspl.lmp herspl.wad >> install.log
del wadinfo.txt
deutex -doom . -rgb 0 255 255 -xtract herspl.wad >> install.log
move .\lumps\herdat.lmp heresy.dat >> install.log
move .\lumps\hertext1.lmp .\textures\hertext1.txt >> install.log
move .\lumps\herdatd.lmp heresyd.dat >> install.log
move .\lumps\hertexd1.lmp .\textures\hertexd1.txt >> install.log
rem DOOM.WAD is used to build the iwad.
IF %heresydc%==1 echo Converting DOOM textures to custom palette. Building IWAD...
IF %heresydc%==1 deutex -doom . -rgb 0 255 255 -iwad -make heresyd.dat heresy.wad >> install.log
deutex -doom . -rgb 0 255 255 -make heresy.dat heresy.wad >> install.log
echo Converting levels to DOOM2...
move .\lumps\herlev.lmp herlev.dat >> install.log
move .\lumps\shadlev.lmp shadlev.dat >> install.log
deutex -make herlev.dat herlev.wad >> install.log
deutex -make shadlev.dat shadlev.wad >> install.log
move .\lumps\response.lmp heresy.rsp >> install.log
move .\lumps\dm2conv.lmp dm2conv.exe >> install.log
dm2conv herlev.wad @heresy >> install.log
dm2conv shadlev.wad @heresy >> install.log
echo Applying critical and miscellaneous patches...
move .\lumps\miscpat.lmp miscpat.bat >> install.log
move .\lumps\cled.lmp cled.exe >> install.log
call miscpat
echo Appending levels to HERESY.WAD...
dm2conv shadlev.wad /remap=28 >> install.log
deutex -join heresy.wad herlev.wad >> install.log
deutex -join heresy.wad shadlev.wad >> install.log
echo Extracting elf skin...
move .\lumps\hskin.lmp hskin.wad >> install.log
echo Working on RISEN3D hack...
move .\lumps\r3dhdat.lmp r3dhack.dat >> install.log
move .\lumps\r3dhdeh.lmp r3dhack.deh >> install.log
move .\lumps\r3dfonts.lmp r3dfonts.wad >> install.log
deutex -doom . -rgb 0 255 255 -make r3dhack.dat r3dhack.wad >> install.log
deutex -join r3dhack.wad r3dfonts.wad >> install.log
echo Working on ZDAEMON fix...
move .\lumps\zdaemonf.lmp zdaemonf.dat >> install.log
deutex -rgb 0 255 255 -make zdaemonf.dat zdaemonf.wad >> install.log
echo Restoring your DOOM2 iwad...
deutex -doom . -res doom2.wad >> install.log
IF %heresydc%==1 echo Restoring your DOOM iwad...
IF %heresydc%==1 deutex -doom . -res doom.wad >> install.log
move .\lumps\comweap.lmp comweap.bex >> install.log
move .\lumps\herbex.lmp heresy.bex >> install.log
move .\lumps\herbat.lmp heresy.bat >> install.log
echo Working on external resources...
echo Creating external weapons patch...
move .\lumps\cweapdat.lmp cweap.dat >> install.log
move .\lumps\cweapbex.lmp cweap.bex >> install.log
deutex -rgb 0 255 255 -make cweap.dat cweap.wad >> install.log
echo Creating external splashes wad...
move .\lumps\spldat.lmp splash.dat >> install.log
deutex -rgb 0 255 255 -make splash.dat splash.wad >> install.log
move .\lumps\cldm2rsp.lmp clasdm2.rsp >> install.log
echo Cleaning up (answer 'y')...
deltree sounds
deltree textures 
deltree musics
deltree flats 
deltree patches
deltree levels 
deltree sprites
deltree graphics
deltree lumps
del heresy.dat
del heresyd.dat
del herlev.dat
del shadlev.dat
del r3dhack.dat
del r3dfonts.wad
del zdaemonf.dat
del herspl.wad
del install.wad
del herlev.wad
del shadlev.wad
del playpal.wad
del wadinfo.txt
del heresy.rsp
del dm2conv.exe
del cled.exe
del deutex.exe
del license
del miscpat.bat
del cweap.dat
del splash.dat
ren heretic.wad heretic.bak
echo Your HERETIC.WAD has been renamed to HERETIC.BAK.
IF %heresydc%==1 ren doom.wad doom.bak
IF %heresydc%==1 echo Your DOOM.WAD has been renamed to DOOM.BAK.
IF NOT EXIST heresy.wad GOTO fail2
echo Done!
echo Installation seems successful.
IF %heresydc%==0 echo HERESY.WAD should be 17.7 mb in size.
IF %heresydc%==1 echo HERESY.WAD should be 20.7 mb in size.
set heresydc=
echo It is recommended to install ZDOOM in your HERESY directory.
echo To play you can run HERESY.BAT.
echo Read the help file!

:end

