#define ParseServerCommand ParseServerCommand2
#include "../../doom/client/effects.c"
#undef ParseServerCommand

void ParseRail()
{
	TVec org, dest, step, x_offs, y_offs, temp;
	TAVec angles;
	angle_t angle = 0;
	int i, steps;
	particle_t *p;
	dlight_t *dl;

	org.x = itof(MSG_ReadShort());
	org.y = itof(MSG_ReadShort());
	org.z = itof(MSG_ReadShort());

	dest.x = itof(MSG_ReadShort());
	dest.y = itof(MSG_ReadShort());
	dest.z = itof(MSG_ReadShort());

	step = dest - org;
	steps = ftoi(Length(step) / 5.0);
	step = Normalize(step) * 5.0;

	VectorAngles(&step, &angles);
	AngleVectors(&angles, &temp, &x_offs, &y_offs);
	x_offs = x_offs * 5.0;
	y_offs = y_offs * 5.0;

	for (i = 0; i < steps; i++)
	{
		p = NewParticle();
		if (!p)
			return;
		p->org = org;
		p->color = RGB(255, 255, 255);
		p->die = cl->time + 0.5;
		p->vel = vector(0.0, 0.0, 0.0);
		p->type = pt_static;

		p = NewParticle();
		if (!p)
			return;
		p->org = org + x_offs * cos(angle) + y_offs * sin(angle);
		p->color = RGB(0, 0, 255);
		p->die = cl->time + 0.5;
		p->vel = vector(0.0, 0.0, 0.0);
		p->type = pt_static;

		p = NewParticle();
		if (!p)
			return;
		p->org = org - x_offs * cos(angle) - y_offs * sin(angle);
		p->color = RGB(0, 0, 255);
		p->die = cl->time + 0.5;
		p->vel = vector(0.0, 0.0, 0.0);
		p->type = pt_static;

		if (!(i % 60))
		{
			dl = AllocDlight(0);
			dl->origin = org;
			dl->radius = 350.0;
			dl->color = RGB(0, 0, 255);
			dl->die = cl->time + 0.5;
			dl->decay = 300.0;
		}
			
		org = org + step;
		angle += (ANG1 * 10);
	}
}

boolean ParseServerCommand(int cmd_type)
{
	switch (cmd_type)
	{
	case svc_rail:
		ParseRail();
		break;
	default:
		return ParseServerCommand2(cmd_type);
	}

	return true;
}

