' britemap -- make a new file britemap.lmp which replaces colormap
' banged together by Matthew W. Miller <mattm@infinet.com>

' do dimensions, read data
DIM r(255), g(255), b(255), c(255)
FOR i = 0 TO 255
  READ r(i), g(i), b(i)
  c(i) = 0
  IF r(i) > g(i) AND g(i) = b(i) THEN c(i) = 1: GOTO duh
  IF g(i) > r(i) AND g(i) > b(i) THEN c(i) = 2: GOTO duh
  IF b(i) > r(i) AND b(i) > g(i) THEN c(i) = 4: GOTO duh
  IF r(i) > b(i) AND g(i) > b(i) THEN c(i) = 3: GOTO duh
  IF b(i) > g(i) AND r(i) > g(i) THEN c(i) = 5: GOTO duh
  IF g(i) > r(i) AND b(i) > r(i) THEN c(i) = 6
duh:
NEXT i

' start writing britemap.lmp
SHELL "del britemap.lmp"
SHELL "del britemap.wad"
OPEN "britemap.lmp" FOR OUTPUT AS 1

' do light -> dark maps
FOR p = 32 TO 1 STEP -1
  PRINT p,
  FOR i = 0 TO 255
    r = r(i) * p / 32
    g = g(i) * p / 32
    b = b(i) * p / 32
    ch = 0: df = r + g + b
    GOSUB chooser
    PRINT #1, CHR$(ch);
  NEXT
NEXT

' do invulnerability (mono inverse) map
FOR i = 0 TO 255: c(i) = 0: NEXT
FOR i = 0 TO 255
  r = 255 - (r(i) + g(i) + b(i)) / 3
  g = r: b = r
  ch = 0: df = 765
  GOSUB chooser
  PRINT #1, CHR$(ch);
NEXT

' do ??? (all black) map
FOR i = 0 TO 255: PRINT #1, CHR$(0); : NEXT

' close and exit
CLOSE : SYSTEM

chooser:
FOR j = 0 TO 255
IF c(i) <> c(j) THEN GOTO nah
dt = ABS(r(j) - r) + ABS(g(j) - g) + ABS(b(j) - b)
IF dt < df THEN
  df = dt: ch = j
END IF
nah:
NEXT
RETURN

' palette data
DATA 0,0,0
DATA 31,23,11
DATA 23,15,7
DATA 75,75,75
DATA 255,255,255
DATA 27,27,27
DATA 19,19,19
DATA 11,11,11
DATA 7,7,7
DATA 47,55,31
DATA 35,43,15
DATA 23,31,7
DATA 15,23,0
DATA 79,59,43
DATA 71,51,35
DATA 63,43,27
DATA 255,183,183
DATA 247,171,171
DATA 243,163,163
DATA 235,151,151
DATA 231,143,143
DATA 223,135,135
DATA 219,123,123
DATA 211,115,115
DATA 203,107,107
DATA 199,99,99
DATA 191,91,91
DATA 187,87,87
DATA 179,79,79
DATA 175,71,71
DATA 167,63,63
DATA 163,59,59
DATA 155,51,51
DATA 151,47,47
DATA 143,43,43
DATA 139,35,35
DATA 131,31,31
DATA 127,27,27
DATA 119,23,23
DATA 115,19,19
DATA 107,15,15
DATA 103,11,11
DATA 95,7,7
DATA 91,7,7
DATA 83,7,7
DATA 79,0,0
DATA 71,0,0
DATA 67,0,0
DATA 255,235,223
DATA 255,227,211
DATA 255,219,199
DATA 255,211,187
DATA 255,207,179
DATA 255,199,167
DATA 255,191,155
DATA 255,187,147
DATA 255,179,131
DATA 247,171,123
DATA 239,163,115
DATA 231,155,107
DATA 223,147,99
DATA 215,139,91
DATA 207,131,83
DATA 203,127,79
DATA 191,123,75
DATA 179,115,71
DATA 171,111,67
DATA 163,107,63
DATA 155,99,59
DATA 143,95,55
DATA 135,87,51
DATA 127,83,47
DATA 119,79,43
DATA 107,71,39
DATA 95,67,35
DATA 83,63,31
DATA 75,55,27
DATA 63,47,23
DATA 51,43,19
DATA 43,35,15
DATA 239,239,239
DATA 231,231,231
DATA 223,223,223
DATA 219,219,219
DATA 211,211,211
DATA 203,203,203
DATA 199,199,199
DATA 191,191,191
DATA 183,183,183
DATA 179,179,179
DATA 171,171,171
DATA 167,167,167
DATA 159,159,159
DATA 151,151,151
DATA 147,147,147
DATA 139,139,139
DATA 131,131,131
DATA 127,127,127
DATA 119,119,119
DATA 111,111,111
DATA 107,107,107
DATA 99,99,99
DATA 91,91,91
DATA 87,87,87
DATA 79,79,79
DATA 71,71,71
DATA 67,67,67
DATA 59,59,59
DATA 55,55,55
DATA 47,47,47
DATA 39,39,39
DATA 35,35,35
DATA 119,255,111
DATA 111,239,103
DATA 103,223,95
DATA 95,207,87
DATA 91,191,79
DATA 83,175,71
DATA 75,159,63
DATA 67,147,55
DATA 63,131,47
DATA 55,115,43
DATA 47,99,35
DATA 39,83,27
DATA 31,67,23
DATA 23,51,15
DATA 19,35,11
DATA 11,23,7
DATA 191,167,143
DATA 183,159,135
DATA 175,151,127
DATA 167,143,119
DATA 159,135,111
DATA 155,127,107
DATA 147,123,99
DATA 139,115,91
DATA 131,107,87
DATA 123,99,79
DATA 119,95,75
DATA 111,87,67
DATA 103,83,63
DATA 95,75,55
DATA 87,67,51
DATA 83,63,47
DATA 159,131,99
DATA 143,119,83
DATA 131,107,75
DATA 119,95,63
DATA 103,83,51
DATA 91,71,43
DATA 79,59,35
DATA 67,51,27
DATA 123,127,99
DATA 111,115,87
DATA 103,107,79
DATA 91,99,71
DATA 83,87,59
DATA 71,79,51
DATA 63,71,43
DATA 55,63,39
DATA 255,255,115
DATA 235,219,87
DATA 215,187,67
DATA 195,155,47
DATA 175,123,31
DATA 155,91,19
DATA 135,67,7
DATA 115,43,0
DATA 255,255,255
DATA 255,219,219
DATA 255,187,187
DATA 255,155,155
DATA 255,123,123
DATA 255,95,95
DATA 255,63,63
DATA 255,31,31
DATA 255,0,0
DATA 239,0,0
DATA 227,0,0
DATA 215,0,0
DATA 203,0,0
DATA 191,0,0
DATA 179,0,0
DATA 167,0,0
DATA 155,0,0
DATA 139,0,0
DATA 127,0,0
DATA 115,0,0
DATA 103,0,0
DATA 91,0,0
DATA 79,0,0
DATA 67,0,0
DATA 231,231,255
DATA 199,199,255
DATA 171,171,255
DATA 143,143,255
DATA 115,115,255
DATA 83,83,255
DATA 55,55,255
DATA 27,27,255
DATA 0,0,255
DATA 0,0,227
DATA 0,0,203
DATA 0,0,179
DATA 0,0,155
DATA 0,0,131
DATA 0,0,107
DATA 0,0,83
DATA 255,255,255
DATA 255,235,219
DATA 255,215,187
DATA 255,199,155
DATA 255,179,123
DATA 255,163,91
DATA 255,143,59
DATA 255,127,27
DATA 243,115,23
DATA 235,111,15
DATA 223,103,15
DATA 215,95,11
DATA 203,87,7
DATA 195,79,0
DATA 183,71,0
DATA 175,67,0
DATA 255,255,255
DATA 255,255,215
DATA 255,255,179
DATA 255,255,143
DATA 255,255,107
DATA 255,255,71
DATA 255,255,35
DATA 255,255,0
DATA 167,63,0
DATA 159,55,0
DATA 147,47,0
DATA 135,35,0
DATA 79,59,39
DATA 67,47,27
DATA 55,35,19
DATA 47,27,11
DATA 0,0,83
DATA 0,0,71
DATA 0,0,59
DATA 0,0,47
DATA 0,0,35
DATA 0,0,23
DATA 0,0,11
DATA 0,0,0
DATA 255,159,67
DATA 255,231,75
DATA 255,123,255
DATA 255,0,255
DATA 207,0,207
DATA 159,0,155
DATA 111,0,107
DATA 167,107,107

