// PlugInTest.cpp : Defines the initialization routines for the DLL.
//

#include "stdafx.h"
#include "PlugInTest.h"
#include "..\Public Radiant\qerplugin.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//
//	Note!
//
//		If this DLL is dynamically linked against the MFC
//		DLLs, any functions exported from this DLL which
//		call into MFC must have the AFX_MANAGE_STATE macro
//		added at the very beginning of the function.
//
//		For example:
//
//		extern "C" BOOL PASCAL EXPORT ExportedFunction()
//		{
//			AFX_MANAGE_STATE(AfxGetStaticModuleState());
//			// normal function body here
//		}
//
//		It is very important that this macro appear in each
//		function, prior to any calls into MFC.  This means that
//		it must appear as the first statement within the 
//		function, even before any object variable declarations
//		as their constructors may generate calls into the MFC
//		DLL.
//
//		Please see MFC Technical Notes 33 and 58 for additional
//		details.
//

/////////////////////////////////////////////////////////////////////////////
// CPlugInTestApp

BEGIN_MESSAGE_MAP(CPlugInTestApp, CWinApp)
	//{{AFX_MSG_MAP(CPlugInTestApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPlugInTestApp construction

_QERFuncTable_1 g_FuncTable;


CPlugInTestApp::CPlugInTestApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CPlugInTestApp object

CPlugInTestApp theApp;


// plugin stuff
//
const char *PLUGIN_NAME = "TestPlug";
// separate commands with ;
const char *PLUGIN_COMMANDS = "Create a brush;Brush handle test;Delete first two brushes";

void _QERDeleteSelection()
{
  if (g_FuncTable.m_pfnDeleteSelection)
    (*g_FuncTable.m_pfnDeleteSelection)();
}

void _QERCreateBrush(vec3_t vMin, vec3_t vMax)
{
  if (g_FuncTable.m_pfnCreateBrush)
    (*g_FuncTable.m_pfnCreateBrush)(vMin, vMax);
}

LPVOID _QERCreateBrushHandle()
{
  if (g_FuncTable.m_pfnCreateBrushHandle)
    return (*g_FuncTable.m_pfnCreateBrushHandle)();
  else
    return NULL;
}

void _QERDeleteBrushHandle(LPVOID vp)
{
  if (g_FuncTable.m_pfnDeleteBrushHandle)
    (*g_FuncTable.m_pfnDeleteBrushHandle)(vp);
}

void _QERCommitBrushHandleToMap(LPVOID vp)
{
  if (g_FuncTable.m_pfnCommitBrushHandle)
    (*g_FuncTable.m_pfnCommitBrushHandle)(vp);
}

void _QERAddFace(LPVOID vp, vec3_t v1, vec3_t v2, vec3_t v3)
{
  if (g_FuncTable.m_pfnAddFace)
    (*g_FuncTable.m_pfnAddFace)(vp, v1, v2, v3);
}

LPVOID WINAPI QERPlug_GetFuncTable()
{
  return &g_FuncTable;
}

LPCSTR WINAPI QERPlug_Init(HMODULE hApp, HWND hwndMain)
{
   AFX_MANAGE_STATE(AfxGetStaticModuleState());
   memset(&g_FuncTable, 0, sizeof(_QERFuncTable_1));
   g_FuncTable.m_fVersion = 1.00;
   return "Test Plugin v1.0";
}

LPCSTR WINAPI QERPlug_GetName()
{
  return PLUGIN_NAME;
}

LPCSTR WINAPI QERPlug_GetCommandList()
{
  return PLUGIN_COMMANDS;
}

bool HasVolume(vec3_t vMin, vec3_t vMax)
{
  for (int i = 0; i < 3; i++)
  {
    if (vMax[i] - vMin[i] > 0)
      return true;
  }
  return false;
}

//FIXME: remove the above wrapper calls to the table funcs as they 
// were mainly for old style.. once this is valid, can safely direct
// call through table without sanity checks
bool TableIsValid()
{
  return ( (g_FuncTable.m_pfnActiveBrushCount != NULL) &&
           (g_FuncTable.m_pfnAddFace != NULL) &&
           (g_FuncTable.m_pfnAddFaceData != NULL) &&
           (g_FuncTable.m_pfnAllocateActiveBrushHandles != NULL) &&
           (g_FuncTable.m_pfnAllocateSelectedBrushHandles != NULL) &&
           (g_FuncTable.m_pfnCommitBrushHandle != NULL) &&
           (g_FuncTable.m_pfnCreateBrush != NULL) &&
           (g_FuncTable.m_pfnCreateBrushHandle != NULL) &&
           (g_FuncTable.m_pfnDeleteBrushHandle != NULL) &&
           (g_FuncTable.m_pfnDeleteSelection != NULL) &&
           (g_FuncTable.m_pfnGetActiveBrushHandle != NULL) &&
           (g_FuncTable.m_pfnGetCurrentTexture != NULL) &&
           (g_FuncTable.m_pfnGetFaceCount != NULL) &&
           (g_FuncTable.m_pfnGetFaceData != NULL) &&
           (g_FuncTable.m_pfnGetPoints != NULL) &&
           (g_FuncTable.m_pfnGetSelectedBrushHandle != NULL) &&
           (g_FuncTable.m_pfnGetTexture != NULL) &&
           (g_FuncTable.m_pfnHideInfoMsg != NULL) &&
           (g_FuncTable.m_pfnInfoMsg != NULL) &&
           (g_FuncTable.m_pfnReleaseActiveBrushHandles != NULL) &&
           (g_FuncTable.m_pfnReleaseSelectedBrushHandles != NULL) &&
           (g_FuncTable.m_pfnSelectedBrushCount != NULL) &&
           (g_FuncTable.m_pfnSetCurrentTexture != NULL) &&
           (g_FuncTable.m_pfnSetFaceData != NULL) &&
           (g_FuncTable.m_pfnSysMsg != NULL) &&
           (g_FuncTable.m_pfnTextureBrush != NULL) &&
           (g_FuncTable.m_pfnTextureCount != NULL) );
}

// vMin/vMax provide the bounds of the selection, they are zero if there is no selection
// if there is a selection, bSingleBrush will be true if a single brush is selected
// if so, typical plugin behaviour (such as primitive creation) would use the bounds as
// a rule to create the primitive, then delete the selection
// FIXME: pretty lame ass.. fixup before releasing.. 
void WINAPI QERPlug_Dispatch(LPCSTR p, vec3_t vMin, vec3_t vMax, BOOL bSingleBrush)
{
  vec3_t mins, maxs;

  if (HasVolume(vMin, vMax))
  {
    for (int i = 0; i < 3; i++)
    {
      mins[i] = vMin[i] + 8;
      maxs[i] = vMax[i] + 8;
    }
  }
  else
  {
    mins[0] = mins[1] = mins[2] = 0;
    maxs[0] = maxs[1] = maxs[2] = 128;
  }


  ASSERT(TableIsValid());
  CString str = p;
  if (str.Find("Create") >= 0)
  {
    _QERDeleteSelection();
    _QERCreateBrush(mins, maxs);
  }
  else if (str.Find("Delete") >= 0)
  {
    int nCount = (*g_FuncTable.m_pfnAllocateActiveBrushHandles)();
    // deletes first two brushes
    if (nCount > 0)
    {
      for (int i = 0; i < 2; i++)
      {
        void* vp = (*g_FuncTable.m_pfnGetActiveBrushHandle)(i);
        if (vp != NULL)
        {
          (*g_FuncTable.m_pfnDeleteBrushHandle)(vp);
        }
      }
    }
    (*g_FuncTable.m_pfnReleaseActiveBrushHandles)();
  }
  else
  {
    _QERDeleteSelection();
    void *vp = _QERCreateBrushHandle();
    if (vp != NULL)
    {
	    vec3_t	pts[4][2];
	    pts[0][0][0] = mins[0];
	    pts[0][0][1] = mins[1];
	    
	    pts[1][0][0] = mins[0];
	    pts[1][0][1] = maxs[1];
	    
	    pts[2][0][0] = maxs[0];
	    pts[2][0][1] = maxs[1];
	    
	    pts[3][0][0] = maxs[0];
	    pts[3][0][1] = mins[1];
	
      int i,j;
	    for (i = 0 ; i < 4 ; i++)
	    {
		    pts[i][0][2] = mins[2];
		    pts[i][1][0] = pts[i][0][0];
		    pts[i][1][1] = pts[i][0][1];
		    pts[i][1][2] = maxs[2];
      }
	    for (i = 0 ; i < 4 ; i++)
      {
		    j = (i+1)%4;
        _QERAddFace(vp, pts[j][1], pts[i][1], pts[i][0]);
      }
      _QERAddFace(vp, pts[0][1], pts[1][1], pts[2][1]);
      _QERAddFace(vp, pts[2][0], pts[1][0], pts[0][0]);
      _QERCommitBrushHandleToMap(vp);
    }
  }
}
