@ECHO OFF
CLS

REM Check to see if the proper files exist

IF NOT EXIST DMADDS11.EXE GOTO error1
IF NOT EXIST RESORT0.WAD GOTO error1
IF NOT EXIST DOOM.WAD GOTO error2

ECHO Installing THE LAST RESORT DEATHMATCH EPISODE.
ECHO.
ECHO This install program will run DMADDS11.EXE to create RESORT.WAD, which 
ECHO contains the new sprite graphics. This will NOT modify your DOOM.WAD. 
ECHO RESORT.WAD will be about 2.5 megabytes in size, so make sure you have 
ECHO the free disk space before continuing.
ECHO.
ECHO WARNING: This will only work for Doom version 1.666
ECHO.
CHOICE /c:yn /n Continue? 
If errorlevel 2 GOTO end

IF EXIST RESORT.WAD GOTO error3

:part2
dmadds11 RESORT0.WAD RESORT.WAD
CLS
ECHO.
ECHO DMADDS11 operation complete. You should now have a new sprite wad called
ECHO RESORT.WAD. You may also delete RESORT0.WAD to save disk space. For more
ECHO information on playing TLR, please refer to the file TLR_INFO.TXT
ECHO.
ECHO To play right this minute (but, alas, not in Deathmatch), type:
ECHO.
ECHO doom -file last.wad resort.wad
ECHO.
goto end

:error1
ECHO.
ECHO ERROR: Install file not found.
ECHO.
ECHO        One or more of the install files needed to install TLR
ECHO        Could not be found. Please make sure both DMADDS11.EXE and
ECHO        RESORT0.WAD are in the same directory as your DOOM.WAD.
ECHO.
goto errend

:error2
ECHO.
ECHO ERROR: DOOM.WAD not found.
ECHO.
ECHO        I could not find your DOOM.WAD. Please make sure the
ECHO        files DMADDS11.EXE, RESORT0.WAD and TLR_INST.BAT are in
ECHO        the same directory as your DOOM.WAD
goto errend

:error3
ECHO.
ECHO Um, you already have RESORT.WAD created in your DOOM directory.
ECHO I will need to delete it before I continue.
ECHO.
CHOICE /c:yn /n Shall I delete it?
If errorlevel 2 GOTO errend
del RESORT.WAD
GOTO part2

:errend
ECHO.
ECHO TLR installation aborted.
ECHO.
goto end

:end
