@echo OFF
cls
echo.
echo.           *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*
echo.           \    I, ANUBIS Doom2 Conversion   /
echo.           \                                 /
echo.           \         by Glen Payne           /
echo.           \      and Marshal Bostwick       /
echo.           *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*
echo.
echo.        ...Full props to the AliensTC gang for the inspiration
echo.        and to Olivier Montanuy for the installation batch guidelines,
echo.        from which this install is shamelessly plagiarized.
echo.
echo.        ************ Good News *************
echo.        You won't need to uninstall I, ANUBIS
echo.        (Your regular DOOM2 game won't be messed with)
echo.        For convenience, I've included both DEHACKED by Greg Lewis and	
echo.        DEUSF by Olivier Montanuy. 
echo.
echo.        ************ Bad News ****************
echo.        Installation still requires about 2.5 additional megs
echo.        for the new sprites, monsters, etc...
pause

echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo This batch is for Registered version:
echo.   *** DOOM II ver. 1.9 ***
echo. hit CTRL-C now  if this is incorrect.
echo.
echo. Warning: The dehacked patch may not work with
echo. DOOM II versions previous to 1.9
echo. Warning: for DOOM II versions previous to 1.9
echo. you might need a proper dehacked.ini file.
pause

rem
rem Check the DOOM2 files
rem
echo. DOOM2.EXE and DOOM2.WAD must be in that directory
if not exist DOOM2.EXE goto fail
if not exist DOOM2.WAD goto fail
goto checkthem
rem

:fail
echo.
echo. ERROR:
echo.   Can't Find DOOM II files DOOM2.WAD or DOOM2.EXE
echo.   please move all I, ANUBIS files to your Doom2 directory. 
pause
exit

rem
rem Check the archive contents
rem 

:checkthem
echo Checking anub_tex.WAD
if not exist anub_tex.WAD goto missfile
echo Checking anub_gra.WAD
if not exist anub_gra.WAD goto missfile
echo Checking anub_spr.WAD
if not exist anub_spr.WAD goto missfile
echo Checking anub_lev.WAD
if not exist anub_lev.WAD goto missfile
echo Checking DEHACKED.EXE
if not exist DEHACKED.EXE goto missfile
echo Checking anub_8.DEH
if not exist anub_8.DEH goto missfile
echo Checking DEUSF.EXE
if not exist DEUSF.EXE goto missfile
echo Checking ANUBIS.BAT
if not exist ANUBIS.BAT goto missfile
goto checkok
rem
rem

:missfile
echo.
echo. ERROR: Can't find that file.  It's not in your Doom2 directory.
echo.  It should have been included in the zip file you acquired.
echo. You can find Dehacked at FTP.CDROM.COM in /pub/doom2/exe_edit/,
echo. 
echo. . . .and DeuSF at the same place in /pub/doom2/graphics_edit/.
echo.    However, for the moment I've included both in this archive.
pause
exit

rem
rem Check if dehacked.ini exists, and complain
rem 

:checkok
if not exist DEHACKED.INI goto saveexe
echo.
echo. WARNING: 
echo. A dehacked.ini file exists here. That could compromise this 
echo. installation if you have a DOOM II version previous to 1.9.
echo. Please hit CTRL-C and delete or rename dehacked.ini if you're not
echo. sure you really need it.
echo.
echo. If you use a DOOM II version previous to 1.9, you might
echo. need a dehacked.ini file so that dehacked can locate 
echo. the object and frame table in your executable.
echo. However, the dehacked patch may not work.  We can't test everything... 
pause
goto saveexe

rem
rem Save executable only if doomhack.EXE does not 
rem already exist to prevent overwriting.
rem

:saveexe
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo. Saving DOOM2.EXE as doomhack.EXE
echo. This uses about 700K of disk space
echo. (doomhack.EXE is not overwritten if it already exists).
echo.
if not exist doomhack.exe copy DOOM2.EXE doomhack.exe

rem
rem APPLY DEHACKED
rem
echo Applying Dehacked patch for DOOM II version 1.9
echo for earlier versions of DOOM2, you might need another
echo Dehacked patch or a proper dehacked.ini.   Sorry.
pause
dehacked -load anub_8.DEH
if ERRORLEVEL 0             goto rename
echo. *********
echo. * ERROR *
echo. *********
echo. An error occured while applying Dehacked.
echo.  Did you use the right DOOM II version?
echo. 
echo. restoring DOOM2.EXE from doomhack.EXE...
copy  doomhack.EXE DOOM2.EXE
echo.  Installation was unsuccessful...Check your doom2 version.
pause
exit

rem
rem Renaming executable
rem

:rename
cls
echo.
echo Changing DOOM2.EXE to IANUBIS.EXE...
if exist IANUBIS.EXE del IANUBIS.EXE
ren DOOMHACK.EXE IANUBIS.EXE
rem
echo.
echo. Modified DOOM2.EXE is now IANUBIS.EXE
echo. Original DOOM2.EXE has not been modified.
echo.  (In other words, you've still got your original doom2.exe UNCHANGED)
pause

rem
rem  APPLY DEUSF
rem
rem deusf.exe defaults to doom.wad: avoid this
rem
if exist doom.wad ren doom.wad doom1.wad >nul
echo.
echo. We're about to create a new sprite PWAD with DeuSF
echo. This requires about 2.5 more meg of disk space
echo. and takes a minute or so.  Hit a key, then hang on....
echo. 
echo. 
echo.
pause >nul
echo. Please wait.....
DeuSF -sprites -app anub_spr.wad > anub_spr.log
if ERRORLEVEL 0             goto restore
echo.  *********
echo.  * ERROR *
echo.  *********
echo. Installation was unsuccessful...
echo. An error occured during sprite and flat generation.
echo. Did you have enough disk space?
pause
exit

:restore
rem
rem Restoration
rem
echo. 
echo. ************ INSTALL IS COMPLETE ***************
echo.
echo. If you want to redistribute the I, ANUBIS files
echo  you will need to restore anub_spr.wad. 
echo. To do that, type:  DeuSF -res anub_spr.wad
echo.  (this is to avoid violating id's copyrights)
echo.
echo. Have fun with this version of I, ANUBIS....
echo. If something goes wrong during the game, please report to Glen
echo. Payne or Marshall Bostwick (glenifer@delphi.com or mab@pip.net).
echo. Send also the log file and if possible a demo of the game that crashed 
echo. (if it can be repeated).
echo.
echo. To play network games:
echo.   Save doom2.exe somewhere safe and rename ianubis.exe to
echo.   doom2.exe before using ipxsetup or your favourite shell.)
echo. 
echo. For a quick uninstall, just type "uninstal".
echo. 
echo. 
echo. To play a single-player game now, type ANUBIS.
echo. 
echo.   

                                                
