@ECHO OFF

REM FrontEnd for "Mordeth", an edited DOOM2 game by Gaston Lahaut
REM Version FEB'97

REM This batch file should be located within your DOOM2 directory. All
REM other files should be located within a directory called MORDETH within
REM this DOOM2 directory. First time users have to build the files
REM MORGRAPH.WAD and MORD.EXE from MORGRAP0.WAD and MORDETH.DEH, resp.
REM This can be done from within this FrontEnd.

ECHO Checking for Mordeth files...

IF NOT EXIST doom2.wad GOTO error1
IF EXIST doom2org.exe GOTO mcrash
IF EXIST cnfrm.bat GOTO crash 
IF NOT EXIST mordeth\mordeth.wad GOTO error2
IF NOT EXIST mordeth\cnfrm.bat GOTO error2
IF NOT EXIST mordeth\morgraph.wad GOTO build
goto DSG

:crash
ECHO    ==================================================================
ECHO                               WARNING!
ECHO                CNFRM.BAT detected in DOOM2 directory
ECHO    ==================================================================
ECHO            Something happened the previous time you used this 
ECHO            FrontEnd, most probably a crash or a hang-up of
ECHO            DOOM2. This COULD mean that your normal DOOM2 savegames
ECHO            have now the extension XXX instead of DSG, and that
ECHO            the Mordeth savegames are present in the DOOM2
ECHO            directory, since this FrontEnd hasn't been closed
ECHO            properly.
ECHO            Leave now, and 1) delete CNFRM.BAT from the DOOM2
ECHO            directory, 2) move *.DSG to the MORDETH directory,
ECHO            3) rename *.XXX to *.DSG.
ECHO.
ECHO                     (Press any key to exit to DOS)
ECHO    ==================================================================
pause >nul
goto fini

:mcrash
ECHO    ==================================================================
ECHO                               WARNING!
ECHO                DOOM2ORG.EXE detected in DOOM2 directory
ECHO    ==================================================================
ECHO            You have used the Mordeth FrontEnd to start a
ECHO            multi-player session, but something has gone amiss.
ECHO            It can be that this session has crashed, or that the
ECHO            setup itself went wrong. Check your setup before you
ECHO            run a multi-player session from within the Mordeth
ECHO            Menu again. Make also sure every player has the same
ECHO            Mordeth FEB'97 version (!).
ECHO            Meanwhile, your original DOOM2.EXE is still named
ECHO            DOOM2ORG.EXE (its Mordeth back-up name) and MORD.EXE
ECHO            (the hacked exe) is named DOOM2.EXE. Also, the *.dsg
ECHO            files have been renamed.
ECHO            
ECHO            So, leave now, and 
ECHO             1) rename DOOM2.EXE to MORD.EXE;
ECHO             2) rename DOOM2ORG.EXE to DOOM2.EXE;   
ECHO             3) delete CNFRM.BAT from the DOOM2 directory
ECHO             4) move *.DSG to the MORDETH directory;
ECHO             5) rename *.XXX to *.DSG;
ECHO.
ECHO                     (Press any key to exit to DOS)
ECHO    ==================================================================
pause >nul
goto fini

:error1
ECHO    =================================================================
ECHO                      ERROR: Couldn't detect DOOM2.WAD.
ECHO        This batch file has to be located and started within your
ECHO        DOOM2 directory. All other Mordeth files should be present
ECHO        in a subdirectory of your Doom2 directory called "MORDETH".
ECHO.
ECHO                         (Press any key to exit)
ECHO    ================================================================
pause >nul
goto fini

:error2
ECHO    ================================================================
ECHO            ERROR: Couldn't detect MORDETH.WAD or CNFRM.BAT
ECHO                      in the Mordeth directory.
ECHO       These files have to be placed in a special directory called
ECHO               MORDETH, located within the DOOM2 directory.
ECHO.
ECHO                          (Press any key to exit)
ECHO    ===============================================================
pause >nul
goto fini

:build
ECHO    ===============================================================
ECHO                     YOUR FIRST MORDETH EXPERIENCE
ECHO                           is about to begin!
ECHO.
ECHO    But first you need to build the functional S&P file MORGRAPH.WAD
ECHO    from the unbuild MORGRAP0.WAD, and to create a dehacked copy of
ECHO    DOOM2.EXE, called MORD.EXE.
ECHO    This can be done manually (See MORDETH.TXT) or by using this
ECHO    FrontEnd. Your original doom2 files will not be comprised in 
ECHO    any way, not even temporarily. Choose your option:
ECHO.
ECHO                        M = Manually: goto DOS
ECHO                        F = FrontEnd: continue
ECHO.
ECHO    ==============================================================
choice /c:MF /N         Your choice:
if errorlevel 2 goto fbuild
if errorlevel 1 goto fini

:fbuild
if not exist mordeth\morgrap0.wad goto error3
if not exist mordeth\nwt.exe goto error3
if not exist mordeth\mordeth.deh goto error3
if not exist mordeth\dehacked.exe goto error3
ECHO.
ECHO    =============================================================
ECHO.
ECHO    = ABOUT TO COPY FILES FROM THE MORDETH DIRECTORY...
ECHO.
ECHO    = IF YOU ALREADY HAVE A COPY OF NWT v1.2a AND DEHACKED v3.0
ECHO      (mind the correct versions!) IN YOUR DOOM2 DIRECTORY, DON'T
ECHO      BOTHER TO OVERWRITE YOUR EXISTING ONES.
ECHO.
ECHO    = PLEASE WAIT WHILE COPYING FILES...
ECHO.
if exist doomhack.exe ren doomhack.exe doomhack.bak
copy doom2.exe mordeth\..\doomhack.exe
if exist dehacked.ini ren dehacked.ini dehacked.bak
cd mordeth
copy morgrap0.wad .. 
copy mordeth.deh .. 
copy nwt.exe ..
copy dehacked.exe ..
cd..
ECHO.
ECHO    = ABOUT TO CREATE THE FUNCTIONAL SPRITES AND FLATS WAD FILE...
ECHO.
ECHO    = NOW BUILDING SPRITES... PLEASE WAIT (1-2 MIN)...
ECHO.
nwt -as morgrap0.wad
ECHO.
ECHO    = IF NO ERROR MESSAGE APPEARED, YOU NOW HAVE ADDED THE SPRITES.
ECHO      NOW BUILDING FLATS... PLEASE WAIT (1-2 MIN)...
ECHO.
nwt -af morgrap0.wad
ren morgrap0.wad morgraph.wad
move morgraph.wad mordeth
ECHO.
ECHO    = IF NO ERROR MESSAGE APPEARED, YOU NOW HAVE A FUNCTIONAL
ECHO      SPRITES & FLATS FILE CALLED MORGRAPH.WAD INSIDE YOUR
ECHO      MORDETH DIRECTORY.
ECHO.
ECHO    = IF AN ERROR MESSAGE -DID- APPEAR, CHECK THE ERROR AND TRY
ECHO      AGAIN.
ECHO.
ECHO    = ABOUT TO CREATE THE HACKED EXE FILE CALLED MORD.EXE. IF YOU
ECHO      HAVE DEHACKED FILES INSIDE YOUR DOOM2 DIRECTORY, THEN THEY
ECHO      ARE SAVED WITH EXTENSION '.BAK'.
ECHO.
ECHO    = CREATING MORD.EXE... IGNORE ERROR MESSAGES STATING DOOM I FILES
ECHO      DOOM.WAD, DOOM.EXE AND DEHACKED.INI COULDN'T BE FOUND...
ECHO.
dehacked -load mordeth.deh
ren doomhack.exe mord.exe
del mordeth.deh
ECHO.
ECHO    = IF YOU HAVE SEEN THE MESSAGE 'patch file mordeth.deh read' 
ECHO      THEN YOU HAVE SUCCESFULLY CREATED THE HACKED MORD.EXE.
ECHO.
ECHO    ============================================================
ECHO    If MORGRAPH.WAD and MORD.EXE have been created, then you are
ECHO    now the proud owner of a functional MORDETH FEB'97 version !
ECHO    ============================================================
ECHO.
ECHO     PLAY MORDETH BY TYPING 'MORDETH' AT THE DOS DOOM2 PROMPT !
ECHO               YEAH ! LET THE FRAGGIN' BEGIN, HERO !
ECHO.
ECHO    ============================================================
ECHO    NOTE:  You still have a copy of NWT.EXE and DEHACKED.EXE in
ECHO    your DOOM2 directory. If you don't want them, you may delete
ECHO    them manually. You will now exit to DOS. Play Mordeth by
ECHO    typing 'mordeth' at the dos doom2 prompt. See ya, hero !
ECHO    ============================================================
goto fini

:error3
ECHO    ============================================================
ECHO            ERROR: Couldn't detect NWT.EXE, DEHACKED.EXE,
ECHO                    MORDETH.DEH or MORGRAP0.WAD.
ECHO.
ECHO    THESE FILES SHOULD HAVE BEEN PRESENT IN THE MORDETH SUBDIR
ECHO    OF YOUR DOOM2 DIRECTORY. READ THE TXT FILE ACCOMPANYING THE
ECHO       ARCHIVE FOR INSTRUCTION ABOUT HOW TO INSTALL MORDETH.
ECHO.
ECHO                       (Press any key to exit)
ECHO    ===========================================================
pause >nul
goto fini

:dsg
if exist *.dsg ren *.dsg *.xxx
cd mordeth
if exist *.dsg move *.dsg .. >nul
cd..
goto front

:front
if not exist cnfrm.bat copy mordeth\cnfrm.bat >nul
CLS
ECHO.
ECHO    *********************************************************************
ECHO    *                     Welcome to the Main Menu of                   * 
ECHO    *                               MORDETH                             *
ECHO    *                                                                   *
ECHO    *                      An Edited DOOM ][ Game by:                   *
ECHO    *                             Gaston Lahaut                         *
ECHO    *********************************************************************
ECHO    *                          Your options are:                        *
ECHO    *                                                                   *
ECHO    *                 1 = Play Mordeth, single player game              *
ECHO    *                 2 = Add/Create RSP's, single player game          *
ECHO    *                                                                   *
ECHO    *                 3 = Multi-player Game Menu                        *
ECHO    *                 4 = DOOM2 Setup                                   *
ECHO    *                                                                   *
ECHO    *                 5 = View "The Story"                              *
ECHO    *                 6 = Read MORDETH.TXT                              *
ECHO    *                 7 = Read DOOM2 Manual                             *
ECHO    *                                                                   *
ECHO    *                     U = Read UNINSTAL.TXT                         *
ECHO    *                        Q = Quit to DOS                            *
ECHO    *                                                                   *
ECHO    *********************************************************************
ECHO.
choice /c:1234567UQ /n Your choice ?
if errorlevel 255 goto end0
if errorlevel 9 goto end1
if errorlevel 8 goto unins?
if errorlevel 7 goto readme
if errorlevel 6 goto view
if errorlevel 5 goto story
if errorlevel 4 goto setup
if errorlevel 3 goto multi
if errorlevel 2 goto runparm
if errorlevel 1 goto runnorm
if errorlevel 0 goto end0          

:runnorm
mord -file mordeth\MORDETH.WAD mordeth\MORGRAPH.WAD <cnfrm.bat
pause >nul
goto front

:runparm
CLS
ECHO.
ECHO    *********************************************************************
ECHO    *                    Single-player Game Menu of                     *
ECHO    *                             MORDETH                               *
ECHO    * ----------------------------------------------------------------- *
ECHO    *                Run Mordeth with an available RSP file             *
ECHO    *                     View an available RSP file                    *
ECHO    *                      Edit/Create any RSP file                     *
ECHO    *********************************************************************
ECHO    *                                                                   *
ECHO    *                 The following options are available:              *
ECHO    *                                                                   *
if exist mordeth\mordsp1.rsp ECHO    *  1 = add mordsp1.rsp  F = view mordsp1.rsp  K = edit mordsp1.rsp  *
if not exist mordeth\mordsp1.rsp ECHO    *                                             K = edit mordsp1.rsp  *
if exist mordeth\mordsp2.rsp ECHO    *  2 = add mordsp2.rsp  G = view mordsp2.rsp  L = edit mordsp2.rsp  *  
if not exist mordeth\mordsp2.rsp ECHO    *                                             L = edit mordsp2.rsp  *
if exist mordeth\mordsp.rsp ECHO    *  3 = add mordsp3.rsp  H = view mordsp3.rsp  M = edit mordsp3.rsp  *  
if not exist mordeth\mordsp3.rsp ECHO    *                                             M = edit mordsp3.rsp  *
if exist mordeth\mordsp4.rsp ECHO    *  4 = add mordsp4.rsp  I = view mordsp4.rsp  N = edit mordsp4.rsp  *   
if not exist mordeth\mordsp4.rsp ECHO    *                                             N = edit mordsp4.rsp  *
if exist mordeth\mordsp5.rsp ECHO    *  5 = add mordsp5.rsp  J = view mordsp5.rsp  O = edit mordsp5.rsp  *   
if not exist mordeth\mordsp5.rsp ECHO    *                                             O = edit mordsp5.rsp  *
ECHO    *                                                                   *
ECHO    *                                                                   *
ECHO    *                      Q =  Back to the Main Menu                   *
ECHO    *********************************************************************
ECHO.
choice /c:12345FGHIJKLMNOQ /n Your choice:
if errorlevel 255 goto end0
if errorlevel 16 goto front
if errorlevel 15 goto edit5
if errorlevel 14 goto edit4
if errorlevel 13 goto edit3
if errorlevel 12 goto edit2
if errorlevel 11 goto edit1
if errorlevel 10 goto viewprm5
if errorlevel 9 goto viewprm4
if errorlevel 8 goto viewprm3
if errorlevel 7 goto viewprm2
if errorlevel 6 goto viewprm1
if errorlevel 5 goto parm5
if errorlevel 4 goto parm4
if errorlevel 3 goto parm3
if errorlevel 2 goto parm2
if errorlevel 1 goto parm1
if errorlevel 0 goto end0

:parm5
if not exist mordeth\mordsp5.rsp goto noparm
mord @mordeth\mordsp5.rsp -file mordeth\MORDETH.WAD mordeth\MORGRAPH.WAD <cnfrm.bat  
pause >nul
goto front

:parm4
if not exist mordeth\mordsp4.rsp goto noparm
mord @mordeth\mordsp4.rsp -file mordeth\MORDETH.WAD mordeth\MORGRAPH.WAD <cnfrm.bat  
pause >nul
goto front

:parm3
if not exist mordeth\mordsp3.rsp goto noparm
mord @mordeth\mordsp3.rsp -file mordeth\MORDETH.WAD mordeth\MORGRAPH.WAD <cnfrm.bat  
pause >nul
goto front

:parm2
if not exist mordeth\mordsp2.rsp goto noparm
mord @mordeth\mordsp2.rsp -file mordeth\MORDETH.WAD mordeth\MORGRAPH.WAD <cnfrm.bat  
pause >nul
goto front

:parm1
if not exist mordeth\mordsp1.rsp goto noparm
mord @mordeth\mordsp1.rsp -file mordeth\MORDETH.WAD mordeth\MORGRAPH.WAD <cnfrm.bat  
pause >nul
goto front

:noparm
cls
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO    *********************************************************************
ECHO    *                   THAT OPTION DOESN'T EXIST !                     *
ECHO    *********************************************************************
ECHO.
ECHO                 Press any key to return to the Parameter Menu
pause >nul
goto runparm

:viewprm1
if not exist mordeth\mordsp1.rsp goto noparm
ECHO.
ECHO Contents of mordsp1.rsp:
ECHO.
type mordeth\mordsp1.rsp
ECHO.
pause
goto runparm

:viewprm2
if not exist mordeth\mordsp2.rsp goto noparm
ECHO.
ECHO Contents of mordsp2.rsp:
ECHO.
type mordeth\mordsp2.rsp
ECHO.
pause
goto runparm

:viewprm3
if not exist mordeth\mordsp3.rsp goto noparm
ECHO.
ECHO Contents of mordsp3.rsp:
ECHO.
type mordeth\mordsp3.rsp
ECHO.
pause
goto runparm

:viewprm4
if not exist mordeth\mordsp4.rsp goto noparm
ECHO.
ECHO Contents of mordsp4.rsp:
ECHO.
type mordeth\mordsp4.rsp
ECHO.
pause
goto runparm

:viewprm5
if not exist mordeth\mordsp5.rsp goto noparm
ECHO.
ECHO Contents of mordsp5.rsp:
ECHO.
type mordeth\mordsp5.rsp 
ECHO.
pause
goto runparm

:edit5
cd mordeth
edit mordsp5.rsp
cd..
goto runparm

:edit4
cd mordeth
edit mordsp4.rsp
cd..
goto runparm

:edit3
cd mordeth
edit mordsp3.rsp
cd..
goto runparm

:edit2
cd mordeth
edit mordsp2.rsp
cd..
goto runparm

:edit1
cd mordeth
edit mordsp1.rsp
cd..
goto runparm

:setup
setup
goto front

:multi
CLS
ECHO.
ECHO    ********************************************************************
ECHO    *                      Multi-Player Game Menu of                   *
ECHO    *                              MORDETH                             *
ECHO    * ---------------------------------------------------------------- *
ECHO    *               Start a multi-player Mordeth session               *
ECHO    *          Create/Edit RSP files with connection parameters        *
ECHO    ********************************************************************
ECHO    *                                                                  *
ECHO    *                        IPX CONNECTION:                           *
ECHO    *                        ---------------                           *
if exist mordeth\mormpi1.rsp ECHO    *         A = Add mormpi1.rsp   1 = Create/Edit mormpi1.rsp        *
if not exist mordeth\mormpi1.rsp ECHO    *                               1 = Create/Edit mormpi1.rsp        *
if exist mordeth\mormpi2.rsp ECHO    *         B = Add mormpi2.rsp   2 = Create/Edit mormpi2.bat        *
if not exist mordeth\mormpi2.rsp ECHO    *                               2 = Create/Edit mormpi2.rsp        *
if exist mordeth\mormpi3.rsp ECHO    *         C = Add mormpi3.rsp   3 = Create/Edit mormpi3.rsp        *
if not exist mordeth\mormpi3.rsp ECHO    *                               3 = Create/Edit mormpi3.rsp        *
ECHO    *                                                                  *
ECHO    *                        SER CONNECTION:                           *
ECHO    *                        ---------------                           *
if exist mordeth\mormps1.rsp ECHO    *         D = Add mormps1.rsp   4 = Create/Edit mormps1.rsp        *
if not exist mordeth\mormps1.rsp ECHO    *                               4 = Create/Edit mormps1.rsp        * 
if exist mordeth\mormps2.rsp ECHO    *         E = Add mormps1.rsp   5 = Create/Edit mormps2.rsp        *
if not exist mordeth\mormps2.rsp ECHO    *                               5 = Create/Edit mormps2.rsp        *
if exist mordeth\mormps3.rsp ECHO    *         F = Add mormps1.rsp   6 = Create/Edit mormps3.rsp        *
if not exist mordeth\mormps3.rsp ECHO    *                               6 = Create/Edit mormps3.rsp        *
ECHO    *                                                                  *
ECHO    *                  Q = Go back to the Main Menu                    *
ECHO    ********************************************************************
choice /c:ABCDEF123456Q /n Your choice:
if errorlevel 255 goto end0
if errorlevel 13 goto front
if errorlevel 12 goto edits3
if errorlevel 11 goto edits2
if errorlevel 10 goto edits1
if errorlevel 9 goto editi3
if errorlevel 8 goto editi2
if errorlevel 7 goto editi1
if errorlevel 6 goto adds3
if errorlevel 5 goto adds2
if errorlevel 4 goto adds1
if errorlevel 3 goto addi3
if errorlevel 2 goto addi2
if errorlevel 1 goto addi1
if errorlevel 0 goto end0

:editi1
cd mordeth
edit mormpi1.rsp
cd..
goto multi

:editi2
cd mordeth
edit mormpi2.rsp
cd..
goto multi

:editi3
cd mordeth
edit mormpi3.rsp
cd..
goto multi

:edits1
cd mordeth
edit mormps1.rsp
cd..
goto multi

:edits2
cd mordeth
edit mormps2.rsp
cd..
goto multi

:edits3
cd mordeth
edit mormps3.rsp
cd..
goto multi

:addi1
if not exist mordeth\mormpi1.rsp goto nomulti
ren doom2.exe doom2org.exe
ren mord.exe doom2.exe
ipxsetup @mordeth\mormpi1.rsp -file mordeth\mordeth.wad mordeth\morgraph.wad
ren doom2.exe mord.exe
ren doom2org.exe doom2.exe
goto multi

:addi2
if not exist mordeth\mormpi2.rsp goto nomulti
ren doom2.exe doom2org.exe
ren mord.exe doom2.exe
ipxsetup @mordeth\mormpi2.rsp -file mordeth\mordeth.wad mordeth\morgraph.wad 
ren doom2.exe mord.exe
ren doom2org.exe doom2.exe
goto multi

:addi3
if not exist mordeth\mormpi3.rsp goto nomulti
ren doom2.exe doom2org.exe
ren mord.exe doom2.exe
ipxsetup @mordeth\mormpi3.rsp -file mordeth\mordeth.wad mordeth\morgraph.wad 
ren doom2.exe mord.exe
ren doom2org.exe doom2.exe
goto multi

:adds1
if not exist mordeth\mormps1.rsp goto nomulti
ren doom2.exe doom2org.exe
ren mord.exe doom2.exe
sersetup @mordeth\mormps1.rsp -file mordeth\mordeth.wad mordeth\morgraph.wad 
ren doom2.exe mord.exe
ren doom2org.exe doom2.exe
goto multi

:adds2
if not exist mordeth\mormps2.rsp goto nomulti
ren doom2.exe doom2org.exe
ren mord.exe doom2.exe
sersetup @mordeth\mormps2.rsp -file mordeth\mordeth.wad mordeth\morgraph.wad 
ren doom2.exe mord.exe
ren doom2org.exe doom2.exe
goto multi

:adds3
if not exist mordeth\mormps3.rsp goto nomulti
ren doom2.exe doom2org.exe
ren mord.exe doom2.exe
sersetup @mordeth\mormps3.rsp -file mordeth\mordeth.wad mordeth\morgraph.wad 
ren doom2.exe mord.exe
ren doom2org.exe doom2.exe
goto multi

:nomulti
CLS
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO    ********************************************************************
ECHO    *                 THAT OPTION DOESN'T EXIST, DUDE!                 *
ECHO    *                                                                  *
ECHO    *        Press any key to return to the Multi-player Game Menu     *
ECHO    ********************************************************************
pause >nul
goto multi

:story
cd mordeth
pcxview.exe story00.pcx
pcxview.exe story01.pcx
pcxview.exe story02.pcx
pcxview.exe story03.pcx 
pcxview.exe story04.pcx 
cd..
goto front

:view
cls
if not exist mordeth\mordeth.txt goto readmenot
type mordeth\mordeth.txt |more
pause >nul
goto front

:readme
if exist readme.exe goto readexe
if exist readme.txt goto readtxt
goto readmenot
:readexe
readme
goto front
:readtxt
type readme.txt |more
goto front

:readmenot
cls
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO    *********************************************************************
ECHO    *                  This text file has not been found.               *
ECHO    *                  Desperate for disc space, or what?               *
ECHO    *********************************************************************
ECHO    *        Press any key to return to the Mordeth FrontEnd Menu.      *
ECHO    *********************************************************************
ECHO.
pause >nul
goto front

:unins?
CLS
ECHO    =====================================================================
ECHO                                  How to
ECHO                             UNINSTALL MORDETH
ECHO.
ECHO        1) go to the DOS DOOM2 prompt ("C:\DOOM2\>")
ECHO        2) type: deltree mordeth and push ENTER. Confirm by pressing: Y
ECHO        3) type: del mordeth.bat and push ENTER.
ECHO        4) type: del mord.exe and push ENTER.
ECHO        5) if you don't want them: delete also nwt.exe and dehacked.exe
ECHO.
ECHO        After this, all Mordeth files and directries are deleted.
ECHO.
ECHO                 (Press any key to return to DOS DOOM2 prompt)
ECHO    ====================================================================
pause >nul
goto fini

:end1
cls
ECHO.
ECHO    *********************************************************************
ECHO    *                 YOU HAVE LEFT THE MORDETH FRONTEND                *
ECHO    *********************************************************************
ECHO    *                                                                   *
ECHO    *     Thanks for playing Mordeth !!  Hopefully you have found it    *
ECHO    *     worthwhile, maybe even enjoyable. Remarks/Praise/Criticism    *
ECHO    *     or plain questions about Mordeth are always welcome, maybe    *
ECHO    *     even replied, so write me, anytime. Well, maybe better not    *
ECHO    *     wait until Doomsday, 'cos then I have some demons to roast!   *
ECHO    *                                                                   *
ECHO    *********************************************************************
ECHO    *     Mordeth, v1.2, is an edited DOOM ][ game by Gaston Lahaut     *
ECHO    *      Mordeth HomePage: http://www.warande.ruu.nl/mordeth.htm      *
ECHO    *          My HomePage: http://www.warande.ruu.nl/glahaut/          *
ECHO    *          Original DOOM ][ is created by Id Software, Inc.         *
ECHO    *    HEXEN is created by Id Software, Inc and Raven Software, Inc.  *
ECHO    *              HERETIC is created by Raven Software, Inc.           *
ECHO    *                             EDITORS USED:                         *
ECHO    *   EDMAP v1.31 by Jeff Rabenhorst  NewWadTool v1.2 1/95 by Denis   *
ECHO    *  Moeller, TiC, NeoPaint v3.2 by NeoSoft, Inc. and DeHackEd v3.0a  *
ECHO    *                by Greg Lewis. See Mordeth HomePage.               *
ECHO    *********************************************************************
ECHO.
goto end0

:end0
if exist cnfrm.bat del cnfrm.bat
if exist *.dsg move *.dsg mordeth >nul
if exist *.xxx ren *.xxx *.dsg
goto fini

:fini
