#ifndef __D_STATE__
#define __D_STATE__

#include "doomdata.h"
#include "d_player.h"
#define DOOMCOM_ID              0x12345678l
#define MAXNETNODES             8
#define BACKUPTICS              12

typedef enum { CMD_SEND = 1, CMD_GET = 2 } command_t;

typedef struct { unsigned checksum;
  byte retransmitfrom,starttic,player,numtics;
  ticcmd_t cmds[BACKUPTICS];
} doomdata_t;

#define STARTUPLEN 12
typedef struct { 
  byte monsters_remember,variable_friction,allow_pushers,fastparm;
  unsigned long rngseed; char filler[sizeof(ticcmd_t)*BACKUPTICS-STARTUPLEN];
} startup_t;

typedef struct { long id;
short intnum,command,remotenode,datalength,numnodes,ticdup,extratics,deathmatch;
short savegame,episode,map,skill,consoleplayer,numplayers,angleoffset,drone;
doomdata_t data;
} doomcom_t;
void D_QuitNetGame (void);

extern  boolean nomonsters;
extern  boolean respawnparm; 
extern  boolean fastparm;
extern  boolean devparm;
extern  int screenblocks;

extern GameMode_t gamemode;
extern GameMission_t  gamemission;
extern  boolean modifiedgame;
extern int compatibility, default_compatibility;
extern int demo_version;
int use_true3d, same_specie_infight;

#define demo_compatibility (demo_version < 200)
int bodyqueslot;
extern int monster_infighting, default_monster_infighting;
extern int monkeys, default_monkeys;

enum {
  comp_telefrag,
  comp_dropoff,
  comp_vile,
  comp_pain,
  comp_skull,
  comp_blazing,
  comp_doorlight,
  comp_model,
  comp_god,
  comp_falloff,
  comp_floors,
  comp_skymap,
  comp_pursuit,
  comp_doorstuck,
  comp_staylift,
  comp_zombie,
  comp_stairs,
  comp_infcheat,
  comp_zerotags,
  COMP_TOTAL=32
};

extern int comp[COMP_TOTAL], default_comp[COMP_TOTAL];
extern  skill_t   startskill;
extern  int   startepisode;
extern  int   startmap;
extern  boolean   autostart;
extern  skill_t         gameskill;
extern  int   gameepisode;
extern  int   gamemap;
extern  boolean         respawnmonsters;
extern  boolean netgame;
extern  boolean deathmatch;

extern int snd_SfxVolume,snd_MusicVolume;

extern  boolean statusbaractive,automapactive;
extern  boolean menuactive;
extern  boolean paused,viewactive;
extern  boolean nodrawers,noblit;
extern  int     viewwindowx,viewwindowy;
extern  int     viewheight,viewwidth,scaledviewwidth,scaledviewheight;
extern  int viewangleoffset, consoleplayer, displayplayer;
extern  int totalkills, totalitems, totalsecret;
extern  int levelstarttic;
extern  int basetic;
extern  int leveltime;
extern  boolean usergame;
extern  boolean demoplayback, demorecording;
extern  boolean   singledemo, timingdemo, fastdemo;
extern  gamestate_t  gamestate;
extern  int   gametic;
extern  player_t  players[MAXPLAYERS];
extern  boolean    playeringame[];
extern  mapthing_t *deathmatchstarts;
extern  size_t     num_deathmatchstarts;
extern  mapthing_t *deathmatch_p;
extern  mapthing_t playerstarts[];
extern wbstartstruct_t wminfo;
extern int maxammo[];
extern  char    basedefault[];
extern  gamestate_t     wipegamestate;
extern  int        mouseSensitivity_horiz, mouseSensitivity_vert;
extern  boolean    singletics;
extern int    skyflatnum;
extern  doomcom_t  *doomcom;
extern  doomdata_t *netbuffer;
extern  ticcmd_t   localcmds[];
extern  int        rndindex, maketic, nettics[];
extern  ticcmd_t   netcmds[][BACKUPTICS];
extern  int        ticdup;
extern thinker_t thinkercap;
extern int tran_filter_pct;
extern int allow_pushers, default_allow_pushers;
extern int variable_friction, default_variable_friction;
extern int monsters_remember, default_monsters_remember;
extern int monster_backing, default_monster_backing;
extern int monster_avoid_hazards, default_monster_avoid_hazards;
extern int monster_friction, default_monster_friction;

#endif