/*
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation. NO WARRANTY.
*/

#include "doomstat.h"
#include "m_menu.h"
#include "m_argv.h"
#include <go32.h>
#include <dpmi.h>

int real_doomcom;

void PacketSend (void)
{ __dpmi_regs r;
 movedata(_my_ds(), (int) doomcom, _dos_ds, real_doomcom, sizeof(*doomcom));
 __dpmi_int(doomcom->intnum,&r);
 movedata(_dos_ds, real_doomcom, _my_ds(), (int) doomcom, sizeof(*doomcom));
}
void PacketGet (void)
{ __dpmi_regs r;
 movedata(_my_ds(), (int) doomcom, _dos_ds, real_doomcom, sizeof(*doomcom));
 __dpmi_int(doomcom->intnum,&r);
 movedata(_dos_ds, real_doomcom, _my_ds(), (int) doomcom, sizeof(*doomcom));
}

void I_InitNetwork (void)
{
  int i;
  i = M_CheckParm ("-net");
  if (!i) {
    doomcom = malloc (sizeof (*doomcom) );
    memset (doomcom, 0, sizeof(*doomcom) );
    netgame = false;
    doomcom->id = DOOMCOM_ID;
    doomcom->numplayers = doomcom->numnodes = 1;
    doomcom->deathmatch = false;
    doomcom->consoleplayer = 0;
    return;
  }
  doomcom = (doomcom_t *) malloc(sizeof(*doomcom));
  real_doomcom = atoi(myargv[i+1]);
  movedata(_dos_ds, real_doomcom, _my_ds(), (int) doomcom, sizeof(*doomcom));
  netgame = true;    
}

void I_NetCmd (void)
{
 if (doomcom->command == CMD_SEND) PacketSend ();
 else if (doomcom->command == CMD_GET) PacketGet ();
 else I_Error ("mauvais net cmd: %i",doomcom->command);
}

#define NCMD_EXIT       0x80000000
#define NCMD_RETRANSMIT 0x40000000
#define NCMD_SETUP      0x20000000
#define NCMD_KILL       0x10000000
#define NCMD_CHECKSUM   0x0fffffff

doomcom_t*  doomcom;        
doomdata_t* netbuffer;

#define RESENDCOUNT     10
#define PL_DRONE        0x80

ticcmd_t localcmds[BACKUPTICS];
ticcmd_t netcmds[MAXPLAYERS][BACKUPTICS];
int      nettics[MAXNETNODES];
boolean  nodeingame[MAXNETNODES];
boolean  remoteresend[MAXNETNODES];
int      resendto[MAXNETNODES];
int      resendcount[MAXNETNODES];
int      nodeforplayer[MAXPLAYERS];

int maketic,lastnettic,skiptics,maxsend;

void D_ProcessEvents (void); 
void G_BuildTiccmd (ticcmd_t *cmd); 
void D_DoAdvanceDemo (void);
 
boolean         reboundpacket;
doomdata_t      reboundstore;

int NetbufferSize (void)
{
  return (int)&(((doomdata_t *)0)->cmds[netbuffer->numtics]); 
}

unsigned NetbufferChecksum (void)
{
  unsigned c;
  int i,l;

  c = 0x1234567;

  l = (NetbufferSize () - (int)&(((doomdata_t *)0)->retransmitfrom))/4;
  for (i=0 ; i<l ; i++)
    c += ((unsigned *)&netbuffer->retransmitfrom)[i] * (i+1);

  return c & NCMD_CHECKSUM;
}

int ExpandTics (int low)
{
  int delta;

  delta = low - (maketic&0xff);

  if (delta >= -64 && delta <= 64)
    return (maketic&~0xff) + low;
  if (delta > 64)
    return (maketic&~0xff) - 256 + low;
  if (delta < -64)
    return (maketic&~0xff) + 256 + low;
      
  I_Error ("ExpandTics: erre value %i en maketic %i",low,maketic);
    return 0;
}

void HSendPacket
(int   node,
 int   flags)
{
  netbuffer->checksum = NetbufferChecksum () | flags;

  if (!node)
  {
    reboundstore = *netbuffer;
    reboundpacket = true;
    return;
  }

  if (demoplayback)
    return;

  if (!netgame)
    I_Error ("transmite a autre node");

  doomcom->command = CMD_SEND;
  doomcom->remotenode = node;
  doomcom->datalength = NetbufferSize ();

  I_NetCmd ();
}

boolean HGetPacket (void)
{       
  if (reboundpacket)
  {
    *netbuffer = reboundstore;
    doomcom->remotenode = 0;
    reboundpacket = false;
    return true;
  }

  if (!netgame)
    return false;

  if (demoplayback)
    return false;
  
  doomcom->command = CMD_GET;
  I_NetCmd ();

  if (doomcom->remotenode == -1)
    return false;

  if (doomcom->datalength != NetbufferSize ())
    return false;

  if (NetbufferChecksum () != (netbuffer->checksum&NCMD_CHECKSUM) )
    return false;
  
  return true;        
}


char    exitmsg[80];

void GetPackets (void)
{
  int         netconsole;
  int         netnode;
  ticcmd_t    *src, *dest;
  int         realend;
  int         realstart;
                        
  while ( HGetPacket() )
  {
    if (netbuffer->checksum & NCMD_SETUP)
      continue;
              
    netconsole = netbuffer->player & ~PL_DRONE;
    netnode = doomcom->remotenode;

    realstart = ExpandTics (netbuffer->starttic);           
    realend = (realstart+netbuffer->numtics);

    if (netbuffer->checksum & NCMD_EXIT)
    {
      if (!nodeingame[netnode])
        continue;
      nodeingame[netnode] = false;
      playeringame[netconsole] = false;
      strcpy (exitmsg, "Player 1 left the game");
      exitmsg[7] += netconsole;
      players[consoleplayer].message = exitmsg;
      if (demorecording)
        G_CheckDemoStatus ();
      continue;
    }

    if (netbuffer->checksum & NCMD_KILL)
      I_Error ("Tue pour network driver");

    nodeforplayer[netconsole] = netnode;

    if ( resendcount[netnode] <= 0 
         && (netbuffer->checksum & NCMD_RETRANSMIT) )
    {
      resendto[netnode] = ExpandTics(netbuffer->retransmitfrom);
      resendcount[netnode] = RESENDCOUNT;
    }
    else
      resendcount[netnode]--;

    if (realend <= nettics[netnode])
      continue;

    if (realstart > nettics[netnode])
    {
      remoteresend[netnode] = true;
      continue;
    }

    {
      int start;

      remoteresend[netnode] = false;
      
      start = nettics[netnode] - realstart;               
      src = &netbuffer->cmds[start];

      while (nettics[netnode] < realend)
      {
        dest = &netcmds[netconsole][nettics[netnode]%BACKUPTICS];
        nettics[netnode]++;
        *dest = *src;
        src++;
      }
    }
  }
}

int gametime;

void NetUpdate (void)
{
  int nowtime,newtics,i,j,realstart,gameticdiv;
  if (singletics) return;
  nowtime = I_GetTime ();
  newtics = nowtime - gametime;
  gametime = nowtime;
  if (newtics <= 0) goto listen;
  if (skiptics <= newtics)
  {
    newtics -= skiptics;
    skiptics = 0;
  }
  else
  {
    skiptics -= newtics;
    newtics = 0;
  }
              
  netbuffer->player = consoleplayer;
  
  gameticdiv = gametic;
  for (i=0 ; i<newtics ; i++)
  {
    I_StartTic ();
    D_ProcessEvents ();
    if (maketic - gameticdiv >= BACKUPTICS/2-1)
      break;
    
    G_BuildTiccmd (&localcmds[maketic%BACKUPTICS]);
    maketic++;
  }
  
  for (i=0 ; i<doomcom->numnodes ; i++)
    if (nodeingame[i])
    {
      netbuffer->starttic = realstart = resendto[i];
      netbuffer->numtics = maketic - realstart;
      if (netbuffer->numtics > BACKUPTICS)
        I_Error ("NetUpdate: netbuffer->numtics > BACKUPTICS");

      resendto[i] = maketic;

      for (j=0 ; j< netbuffer->numtics ; j++)
        netbuffer->cmds[j] = localcmds[(realstart+j)%BACKUPTICS];
                                  
      if (remoteresend[i])
      {
        netbuffer->retransmitfrom = nettics[i];
        HSendPacket (i, NCMD_RETRANSMIT);
      }
      else
      {
        netbuffer->retransmitfrom = 0;
        HSendPacket (i, 0);
      }
    }
  
listen:
  GetPackets ();
}

void CheckAbort (void)
{
  event_t *ev;
  int stoptic;
      
  stoptic = I_GetTime () + 2; 
  while (I_GetTime() < stoptic) 
    I_StartTic (); 
      
  I_StartTic ();
  for ( ; eventtail != eventhead ; eventtail = (++eventtail)&(MAXEVENTS-1) ) 
  { 
    ev = &events[eventtail]; 
    if (ev->type == ev_keydown && ev->data1 == KEYD_ESCAPE)
      I_Error ("Network jeux synchronization sortie");
  } 
}

void D_ArbitrateNetStart (void)
{
  int     i;
  boolean gotinfo[MAXNETNODES];

  autostart = true;
  memset (gotinfo,0,sizeof(gotinfo));
      
  if (doomcom->consoleplayer)
  {
    printf("listening for network start info...\n");
    while (1)
    {
      CheckAbort ();
      if (!HGetPacket ())
          continue;
      if (netbuffer->checksum & NCMD_SETUP)
      {
        printf("Received %d %d\n",
	       netbuffer->retransmitfrom,netbuffer->starttic);
        startskill = netbuffer->retransmitfrom & 15;
        deathmatch = (netbuffer->retransmitfrom & 0xc0) >> 6;
        nomonsters = (netbuffer->retransmitfrom & 0x20) > 0;
        respawnparm = (netbuffer->retransmitfrom & 0x10) > 0;
        startmap = netbuffer->starttic & 0x3f;
        startepisode = 1 + (netbuffer->starttic >> 6);

        G_ReadOptions((char *) netbuffer->cmds);

        return;
      }
    }
  }
  else
  {
    printf("sending network start info\n");

    do
    {
      CheckAbort ();
      for (i=0 ; i<doomcom->numnodes ; i++)
      {
        netbuffer->retransmitfrom = startskill;
        if (deathmatch)
          netbuffer->retransmitfrom |= (deathmatch<<6);
        if (nomonsters)
          netbuffer->retransmitfrom |= 0x20;
        if (respawnparm)
          netbuffer->retransmitfrom |= 0x10;
        netbuffer->starttic = (startepisode-1) * 64 + startmap;
        netbuffer->player = VERSION;

        if (64 > sizeof netbuffer->cmds)
          I_Error("D_ArbitrateNetStart: GAME_OPTION_SIZE"
                  " beaucoup grand w.r.t. BACKUPTICS");

        G_WriteOptions((char *) netbuffer->cmds);

        netbuffer->numtics = BACKUPTICS;

        HSendPacket (i, NCMD_SETUP);
      }

      for(i = 10 ; i  &&  HGetPacket(); --i)
      {
        if((netbuffer->player&0x7f) < MAXNETNODES)
          gotinfo[netbuffer->player&0x7f] = true;
      }

      for (i=1 ; i<doomcom->numnodes ; i++)
        if (!gotinfo[i])
          break;
    } while (i < doomcom->numnodes);
  }
}

extern int viewangleoffset;

void D_CheckNetGame (void)
{
  int i;
      
  for (i=0 ; i<MAXNETNODES ; i++)
  {
    nodeingame[i] = false;
    nettics[i] = 0;
    remoteresend[i] = false;
    resendto[i] = 0;
  }
      
  I_InitNetwork ();
  if (doomcom->id != DOOMCOM_ID)
    I_Error ("Doomcom buffer invalide!");
  
  netbuffer = &doomcom->data;
  consoleplayer = displayplayer = doomcom->consoleplayer;
  if (netgame)
    D_ArbitrateNetStart ();

  printf ("startskill %i  deathmatch: %i  startmap: %i  startepisode: %i\n",
           startskill, deathmatch, startmap, startepisode);

  maxsend = BACKUPTICS/2-1;
  if (maxsend<1)
    maxsend = 1;
                      
  for (i=0 ; i<doomcom->numplayers ; i++)
    playeringame[i] = true;
  for (i=0 ; i<doomcom->numnodes ; i++)
    nodeingame[i] = true;
      
  printf ("player %i of %i (%i nodes)\n",
           consoleplayer+1, doomcom->numplayers, doomcom->numnodes);
}

void D_QuitNetGame (void)
{
  int             i, j;
              
  if (!netgame || !usergame || consoleplayer == -1 || demoplayback)
      return;
      
  netbuffer->player = consoleplayer;
  netbuffer->numtics = 0;
  for (i=0 ; i<4 ; i++)
  {
    for (j=1 ; j<doomcom->numnodes ; j++)
      if (nodeingame[j])
         HSendPacket (j, NCMD_EXIT);
  }
}

int frametics[4],frameon,frameskip[4],oldnettics;

extern boolean advancedemo;

void TryRunTics (void)
{
  int         i;
  int         lowtic;
  int         entertic;
  static int  oldentertics;
  int         realtics;
  int         availabletics;
  int         counts;
  int         numplaying;
  
  entertic = I_GetTime ();
  realtics = entertic - oldentertics;
  oldentertics = entertic;
  
  NetUpdate ();
      
  lowtic = MAXINT;
  numplaying = 0;
  for (i=0 ; i<doomcom->numnodes ; i++)
  {
    if (nodeingame[i])
    {
      numplaying++;
      if (nettics[i] < lowtic)
        lowtic = nettics[i];
    }
  }
  availabletics = lowtic - gametic;
  
  if (realtics < availabletics-1)
    counts = realtics+1;
  else if (realtics < availabletics)
    counts = realtics;
  else
    counts = availabletics;
  
  if (counts < 1)
    counts = 1;
              
  frameon++;

  if (!demoplayback)
  {   
    for (i=0 ; i<MAXPLAYERS ; i++)
        if (playeringame[i])
            break;
    if (consoleplayer == i)
    {
    }
    else
    {
      if (nettics[0] <= nettics[nodeforplayer[i]])
      {
        gametime--;
      }
      frameskip[frameon&3] = (oldnettics > nettics[nodeforplayer[i]]);
      oldnettics = nettics[0];
      if (frameskip[0] && frameskip[1] && frameskip[2] && frameskip[3])
      {
        skiptics = 1;
      }
    }
  }
      
  while (lowtic < gametic + counts)    
  {
    NetUpdate ();   
    lowtic = MAXINT;
    
    for (i=0 ; i<doomcom->numnodes ; i++)
      if (nodeingame[i] && nettics[i] < lowtic)
        lowtic = nettics[i];
    
    if (lowtic < gametic)
      I_Error ("TryRunTics: lowtic < gametic");
                            
    if (I_GetTime () - entertic >= 20)
    {
      M_Ticker ();
      return;
    } 
  }
  
  while (counts--)
  {
    {
      if (gametic > lowtic)
        I_Error ("gametic>lowtic");
      if (advancedemo)
        D_DoAdvanceDemo ();
      M_Ticker ();
      G_Ticker ();
      gametic++;
    }
    NetUpdate ();
  }
}