/*
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation. NO WARRANTY.
*/

#include "doomstat.h"
#include "m_bbox.h"
#include "i_system.h"
#include "r_main.h"
#include "r_plane.h"

seg_t     *curline;
side_t    *sidedef;
line_t    *linedef;
sector_t  *frontsector;
sector_t  *backsector;
drawseg_t *ds_p;

int      doorclosed;
drawseg_t *drawsegs;
unsigned  maxdrawsegs;

void R_ClearDrawSegs(void)
{
  ds_p = drawsegs;
}

typedef struct {
  short first, last;
} cliprange_t;

cliprange_t *newend;
cliprange_t solidsegs[161];

void R_ClipSolidWallSegment(int first, int last)
{
  cliprange_t *next, *start;

  start = solidsegs;
  while (start->last < first-1)
    start++;

  if (first < start->first)
    {
      if (last < start->first-1)
        {
          R_StoreWallRange (first, last);

          memmove(start+1,start,(++newend-start)*sizeof(*start));
          start->first = first;
          start->last = last;
          return;
        }

      R_StoreWallRange (first, start->first - 1);

      start->first = first;
    }

  if (last <= start->last)
    return;

  next = start;
  while (last >= (next+1)->first-1)
    {
      R_StoreWallRange (next->last+1, (next+1)->first-1);
      next++;
      if (last <= next->last)
        {
          start->last = next->last;
          goto crunch;
        }
    }

  R_StoreWallRange(next->last+1, last);
  start->last = last;

crunch:

  if (next == start)
    return;
  while (next++ != newend)
    *++start = *next;
  newend = start+1;
}

void R_ClipPassWallSegment(int first, int last)
{
  cliprange_t *start = solidsegs;

  while (start->last < first-1)
    start++;

  if (first < start->first)
    {
      if (last < start->first-1)
        {
          R_StoreWallRange(first, last);
          return;
        }

      R_StoreWallRange(first, start->first-1);
    }

  if (last <= start->last)
    return;

  while (last >= (start+1)->first-1)
    {
      R_StoreWallRange(start->last+1, (start+1)->first-1);
      start++;

      if (last <= start->last)
        return;
    }
  R_StoreWallRange(start->last+1, last);
}

void R_ClearClipSegs (void)
{
  solidsegs[0].first = -0x7fff;
  solidsegs[0].last = -1;
  solidsegs[1].first = viewwidth;
  solidsegs[1].last = 0x7fff;
  newend = solidsegs+2;
}

int R_DoorClosed(void)
{
  return

    backsector->ceilingheight <= backsector->floorheight
    && (backsector->ceilingheight >= frontsector->ceilingheight ||
     curline->sidedef->toptexture)
    && (backsector->floorheight <= frontsector->floorheight ||
     curline->sidedef->bottomtexture)
    && (backsector->ceilingpic !=skyflatnum ||
        frontsector->ceilingpic!=skyflatnum);
}

sector_t *R_FakeFlat(sector_t *sec, sector_t *tempsec,
                     int *floorlightlevel, int *ceilinglightlevel,
                     boolean back)
{
  if (floorlightlevel)
    *floorlightlevel = sec->floorlightsec == -1 ?
      sec->lightlevel : sectors[sec->floorlightsec].lightlevel;
  if (ceilinglightlevel)
    *ceilinglightlevel = sec->ceilinglightsec == -1 ?
      sec->lightlevel : sectors[sec->ceilinglightsec].lightlevel;
  if (sec->heightsec != -1)
    {
      const sector_t *s = &sectors[sec->heightsec];
      int heightsec = viewplayer->mo->subsector->sector->heightsec;
      int underwater = heightsec!=-1 && viewz<=sectors[heightsec].floorheight;
      *tempsec = *sec;
      tempsec->floorheight   = s->floorheight;
      tempsec->ceilingheight = s->ceilingheight;
      if (underwater && (tempsec->  floorheight = sec->floorheight,
			 tempsec->ceilingheight = s->floorheight-1, !back))
        {
          tempsec->floorpic    = s->floorpic;
          tempsec->floor_xoffs = s->floor_xoffs;
          tempsec->floor_yoffs = s->floor_yoffs;

          if (underwater)
            if (s->ceilingpic == skyflatnum)
              {
                tempsec->floorheight   = tempsec->ceilingheight+1;
                tempsec->ceilingpic    = tempsec->floorpic;
                tempsec->ceiling_xoffs = tempsec->floor_xoffs;
                tempsec->ceiling_yoffs = tempsec->floor_yoffs;
              }
            else
              {
                tempsec->ceilingpic    = s->ceilingpic;
                tempsec->ceiling_xoffs = s->ceiling_xoffs;
                tempsec->ceiling_yoffs = s->ceiling_yoffs;
              }

          tempsec->lightlevel  = s->lightlevel;

          if (floorlightlevel)
            *floorlightlevel = s->floorlightsec == -1 ? s->lightlevel :
            sectors[s->floorlightsec].lightlevel;

          if (ceilinglightlevel)
            *ceilinglightlevel = s->ceilinglightsec == -1 ? s->lightlevel :
            sectors[s->ceilinglightsec].lightlevel;
        }
      else
        if (heightsec != -1 && viewz >= sectors[heightsec].ceilingheight &&
            sec->ceilingheight > s->ceilingheight)
          {
            tempsec->ceilingheight = s->ceilingheight;
            tempsec->floorheight   = s->ceilingheight + 1;

            tempsec->floorpic    = tempsec->ceilingpic    = s->ceilingpic;
            tempsec->floor_xoffs = tempsec->ceiling_xoffs = s->ceiling_xoffs;
            tempsec->floor_yoffs = tempsec->ceiling_yoffs = s->ceiling_yoffs;

            if (s->floorpic != skyflatnum)
              {
                tempsec->ceilingheight = sec->ceilingheight;
                tempsec->floorpic      = s->floorpic;
                tempsec->floor_xoffs   = s->floor_xoffs;
                tempsec->floor_yoffs   = s->floor_yoffs;
              }

            tempsec->lightlevel  = s->lightlevel;

            if (floorlightlevel)
              *floorlightlevel = s->floorlightsec == -1 ? s->lightlevel :
              sectors[s->floorlightsec].lightlevel;

            if (ceilinglightlevel)
              *ceilinglightlevel = s->ceilinglightsec == -1 ? s->lightlevel :
              sectors[s->ceilinglightsec].lightlevel;
          }
      sec = tempsec;
    }
  return sec;
}

void R_AddLine (seg_t *line)
{
  int      x1;
  int      x2;
  angle_t  angle1;
  angle_t  angle2;
  angle_t  span;
  angle_t  tspan;
  static sector_t tempsec;
  curline = line;

  angle1 = R_PointToAngle ((long long)line->v1->x, (long long)line->v1->y);
  angle2 = R_PointToAngle ((long long)line->v2->x, (long long)line->v2->y);

  span = angle1 - angle2;

  if (span >= ANG180) return;

  rw_angle1 = angle1;
  angle1 -= viewangle;
  angle2 -= viewangle;

  tspan = angle1 + clipangle;
  if (tspan > 2*clipangle)
    {
      tspan -= 2*clipangle;

      if (tspan >= span) return;

      angle1 = clipangle;
    }

  tspan = clipangle - angle2;
  if (tspan > 2*clipangle)
    {
      tspan -= 2*clipangle;

      if (tspan >= span) return;

      angle2 = -clipangle;
    }

  angle1 = (angle1+ANG90)>>ANGLETOFINESHIFT;
  angle2 = (angle2+ANG90)>>ANGLETOFINESHIFT;

  x1 = viewangletox[angle1];
  x2 = viewangletox[angle2];

  if (x1 >= x2) return;

  backsector = line->backsector;

  if (!backsector)
    goto clipsolid;

  backsector = R_FakeFlat(backsector, &tempsec, NULL, NULL, true);

  doorclosed = 0;

  if (backsector->ceilingheight <= frontsector->floorheight
      || backsector->floorheight >= frontsector->ceilingheight)
    goto clipsolid;

  if ((doorclosed = R_DoorClosed()))
    goto clipsolid;

  if (backsector->ceilingheight != frontsector->ceilingheight
      || backsector->floorheight != frontsector->floorheight)
    goto clippass;

  if (backsector->ceilingpic == frontsector->ceilingpic
      && backsector->floorpic == frontsector->floorpic
      && backsector->lightlevel == frontsector->lightlevel
      && curline->sidedef->midtexture == 0

      && backsector->floor_xoffs == frontsector->floor_xoffs
      && backsector->floor_yoffs == frontsector->floor_yoffs
      && backsector->ceiling_xoffs == frontsector->ceiling_xoffs
      && backsector->ceiling_yoffs == frontsector->ceiling_yoffs

      && backsector->floorlightsec == frontsector->floorlightsec
      && backsector->ceilinglightsec == frontsector->ceilinglightsec
      && frontsector->ffloors == backsector->ffloors)
    return;

clippass:
  R_ClipPassWallSegment (x1, x2-1);
  return;

clipsolid:
  R_ClipSolidWallSegment (x1, x2-1);
}

const int checkcoord[12][4] =
{
  {3,0,2,1},
  {3,0,2,0},
  {3,1,2,0},
  {0},
  {2,0,2,1},
  {0,0,0,0},
  {3,1,3,0},
  {0},
  {2,0,3,1},
  {2,1,3,1},
  {2,1,3,0}
};

boolean R_CheckBBox(fixed_t *bspcoord)
{
  int     boxpos, boxx, boxy;
  fixed_t x1, x2, y1, y2;
  angle_t angle1, angle2, span, tspan;
  int     sx1, sx2;
  cliprange_t *start;

  boxx = viewx <= bspcoord[BOXLEFT] ? 0 : viewx < bspcoord[BOXRIGHT ] ? 1 : 2;
  boxy = viewy >= bspcoord[BOXTOP ] ? 0 : viewy > bspcoord[BOXBOTTOM] ? 1 : 2;

  boxpos = (boxy<<2)+boxx;
  if (boxpos == 5)
    return true;

  x1 = bspcoord[checkcoord[boxpos][0]];
  y1 = bspcoord[checkcoord[boxpos][1]];
  x2 = bspcoord[checkcoord[boxpos][2]];
  y2 = bspcoord[checkcoord[boxpos][3]];

  angle1 = R_PointToAngle ((long long)x1,(long long)y1) - viewangle;
  angle2 = R_PointToAngle ((long long)x2,(long long)y2) - viewangle;

  span = angle1 - angle2;

  if (span >= ANG180)
    return true;

  tspan = angle1 + clipangle;
  if (tspan > 2*clipangle)
    {
      tspan -= 2*clipangle;

      if (tspan >= span)
        return false;

      angle1 = clipangle;
    }

  tspan = clipangle - angle2;
  if (tspan > 2*clipangle)
    {
      tspan -= 2*clipangle;

      if (tspan >= span)
        return false;

      angle2 = -clipangle;
    }

  angle1 = (angle1+ANG90)>>ANGLETOFINESHIFT;
  angle2 = (angle2+ANG90)>>ANGLETOFINESHIFT;
  sx1 = viewangletox[angle1];
  sx2 = viewangletox[angle2];

  if (sx1 == sx2)
    return false;
  sx2--;

  start = solidsegs;
  while (start->last < sx2)
    start++;

  if (sx1 >= start->first && sx2 <= start->last)
    return false;

  return true;
}
subsector_t *sub;
int Extrafloors;
void R_Subsector(int num)
{
  int         count;
  seg_t       *line;
  sector_t    tempsec;
  int floorlightlevel,ceilinglightlevel;
  sub = &subsectors[num];
  frontsector = sub->sector;
  count = sub->numlines;
  line = &segs[sub->firstline];

  frontsector = R_FakeFlat(frontsector, &tempsec, &floorlightlevel,
                           &ceilinglightlevel, false);
  numffloors=0;
  if(frontsector->ffloors)
  { ffloor_t *rover=frontsector->ffloors;
    ffloors[numffloors].plane=NULL;
   for (;rover;rover=rover->next)
   { 
    if(*rover->bottomheight>viewz){
    ffloors[numffloors].plane = R_FindPlane(*rover->bottomheight,*rover->bottompic,
    *rover->toplightlevel,*rover->topxoffs,*rover->topyoffs,rover);
    ffloors[numffloors].height=*rover->bottomheight;
    ffloors[numffloors].ffloor=rover;
    numffloors++;
    }
    if(*rover->topheight<viewz){
    ffloors[numffloors].plane = R_FindPlane(*rover->topheight,*rover->toppic,
    rover->next ? *rover->next->toplightlevel :
    floorlightlevel,*rover->bottomxoffs,*rover->bottomyoffs,rover);
    ffloors[numffloors].height=*rover->topheight;
    ffloors[numffloors].ffloor=rover;
    numffloors++;
    }
   }
   floorlightlevel=*frontsector->ffloors->toplightlevel;
  }
  floorplane = frontsector->floorheight < viewz ||
    (frontsector->heightsec != -1 &&
     sectors[frontsector->heightsec].ceilingpic == skyflatnum) ?
    R_FindPlane(frontsector->floorheight,
                frontsector->floorpic == skyflatnum &&
		frontsector->sky & PL_SKYFLAT ? frontsector->sky :
                frontsector->floorpic,
                floorlightlevel,
                frontsector->floor_xoffs,
                frontsector->floor_yoffs,NULL) : NULL;

  ceilingplane = frontsector->ceilingheight > viewz ||
    frontsector->ceilingpic == skyflatnum ||
    (frontsector->heightsec != -1 &&
     sectors[frontsector->heightsec].floorpic == skyflatnum) ?
    R_FindPlane(frontsector->ceilingheight,
		frontsector->ceilingpic == skyflatnum &&
		frontsector->sky & PL_SKYFLAT ? frontsector->sky :
                frontsector->ceilingpic,
                ceilinglightlevel,
                frontsector->ceiling_xoffs,
                frontsector->ceiling_yoffs,NULL) : NULL;
  floorlightlevel=ceilinglightlevel;
  if(!Extrafloors)
  R_AddSprites(sub, (floorlightlevel+ceilinglightlevel)/2);
  while (count--) R_AddLine (line++);
}

void R_RenderBSPNode(int bspnum)
{
  while (!(bspnum & NF_SUBSECTOR))
    {
      node_t *bsp = &nodes[bspnum];

      int side = R_PointOnSide(viewx, viewy, bsp);

      R_RenderBSPNode(bsp->children[side]);

      if (!R_CheckBBox(bsp->bbox[side^=1]))
        return;

      bspnum = bsp->children[side];
    }
  R_Subsector(bspnum == -1 ? 0 : bspnum & ~NF_SUBSECTOR);
}