#ifndef __R_DEFS__
#define __R_DEFS__

#include <math.h>
#include "doomdef.h"
#include "m_fixed.h"
#include "d_think.h"
#include "p_mobj.h"

#define SIL_NONE    0
#define SIL_BOTTOM  1
#define SIL_TOP     2
#define SIL_BOTH    3

#define MAXDRAWSEGS   256

typedef struct
{
  fixed_t x, y;
} vertex_t;

typedef struct
{
  thinker_t thinker;
  fixed_t x, y, z;
} degenmobj_t;

typedef byte lighttable_t;

typedef struct ffloor_s
{
  fixed_t          *topheight;
  short            *toppic;
  short            *toplightlevel;
  fixed_t          *topxoffs;
  fixed_t          *topyoffs;
  fixed_t          *bottomheight;
  short            *bottompic;
  fixed_t          *bottomxoffs;
  fixed_t          *bottomyoffs;
  int              liquid;
  struct line_s*   master;
  struct ffloor_s* next;
} ffloor_t;

typedef struct sector_s
{
  fixed_t floorheight;
  fixed_t ceilingheight;
  short floorpic;
  short ceilingpic;
  short lightlevel;
  short special;
  short oldspecial;
  short tag;
  int nexttag,firsttag;
  int soundtraversed;
  mobj_t *soundtarget;
  int blockbox[4];
  degenmobj_t soundorg;
  int validcount;
  mobj_t *thinglist;
  int friction,movefactor;
  void *floordata;
  void *ceilingdata;
  void *lightingdata;
  int stairlock;
  int prevsec;
  int nextsec;
  
  fixed_t floor_xoffs, floor_yoffs, ceiling_xoffs, ceiling_yoffs;

  int heightsec;
  int floorlightsec, ceilinglightsec;
  int bottommap, midmap, topmap;
  int sky;
  struct msecnode_s *touching_thinglist;
  int linecount;
  struct line_s **lines;
  ffloor_t* ffloors;
} sector_t;

typedef struct
{
  fixed_t textureoffset, rowoffset;
  short toptexture, bottomtexture, midtexture;
  sector_t* sector;
  int special;
} side_t;

typedef enum
{
  ST_HORIZONTAL,
  ST_VERTICAL,
  ST_POSITIVE,
  ST_NEGATIVE
} slopetype_t;

typedef struct line_s
{
  vertex_t *v1, *v2;
  fixed_t dx, dy;
  short flags;
  short special;         
  short tag;
  short sidenum[2];
  fixed_t bbox[4];
  slopetype_t slopetype;
  sector_t *frontsector;
  sector_t *backsector; 
  int validcount;
  void *specialdata;
  int tranlump;
  int firsttag,nexttag;
} line_t;

typedef struct subsector_s
{
  sector_t *sector;
  short numlines, firstline;
} subsector_t;

typedef struct msecnode_s
{
  sector_t          *m_sector;
  struct mobj_s     *m_thing;
  struct msecnode_s *m_tprev;
  struct msecnode_s *m_tnext;
  struct msecnode_s *m_sprev;
  struct msecnode_s *m_snext;
  boolean visited;
} msecnode_t;

typedef struct
{
  vertex_t *v1, *v2;
  fixed_t offset;
  angle_t angle;
  side_t* sidedef;
  line_t* linedef;

  sector_t *frontsector, *backsector;
} seg_t;

typedef struct
{
  fixed_t  x,  y, dx, dy;
  fixed_t bbox[2][4];
  unsigned short children[2];
} node_t;

typedef struct
{
  byte topdelta;
  byte length;
} post_t;

typedef post_t column_t; 

typedef struct drawseg_s
{
  seg_t *curline;
  int x1, x2;
  fixed_t scale1, scale2, scalestep;
  int silhouette;
  fixed_t bsilheight;
  fixed_t tsilheight;
  short *sprtopclip, *sprbottomclip, *maskedtexturecol;
  struct visplane* ffloorplanes[99];
  int numffloorplanes;
  struct ffloor_s* thicksides[99];
  short* thicksidecol;
  int numthicksides;
  subsector_t* sub;
} drawseg_t;

typedef struct 
{ 
  short width, height;
  short leftoffset;
  short topoffset;
  int columnofs[8];
} patch_t;

typedef struct vissprite_s
{
  int x1, x2;
  fixed_t gx, gy, gz, gzt;
  fixed_t startfrac, scale, xiscale, texturemid;
  int patch, mobjflags;
  lighttable_t *colormap;
  int heightsec;
} vissprite_t;

typedef struct
{
  boolean rotate;
  short lump[8];
  byte  flip[8];
} spriteframe_t;

typedef struct
{
  int numframes;
  spriteframe_t *spriteframes;
} spritedef_t;

typedef struct planemgr_s
{
 struct visplane *plane;
 fixed_t height,f_pos,b_pos,f_frac,f_step,b_frac,b_step;
 short f_clip[320],c_clip[320];
 struct ffloor_s *ffloor;
} planemgr_t;

typedef struct visplane
{
  struct visplane *next;
  int picnum, lightlevel, minx, maxx;
  fixed_t height;
  fixed_t xoffs, yoffs;
  unsigned short pad1;
  unsigned short top[320];
  unsigned short pad2, pad3;
  unsigned short bottom[320];
  unsigned short pad4;
  ffloor_t *ffloor;
  int high,low;
} visplane_t;

planemgr_t ffloors[99];
int numffloors;

#endif