/*
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation. NO WARRANTY.
*/

#include "doomstat.h"
#include "r_main.h"
#include "r_bsp.h"
#include "r_plane.h"
#include "r_draw.h"
#include "w_wad.h"

static boolean segtextured,markfloor,markceiling,maskedtexture;
static int     toptexture,bottomtexture,midtexture,numthicksides;
angle_t rw_normalangle;
int     rw_angle1,rw_distance,sprtopscreen;
lighttable_t **walllights,**extrawalllights;
int     rw_x,rw_stopx;
angle_t rw_centerangle;
fixed_t rw_offset,rw_scale,rw_scalestep;
fixed_t rw_midtexturemid,rw_toptexturemid,rw_bottomtexturemid;
int     worldtop,worldbottom,worldhigh,worldlow;
static fixed_t pixhigh,pixlow,pixhighstep,pixlowstep;
static fixed_t topfrac,topstep,bottomfrac,bottomstep;
short   *maskedtexturecol;
short negonearray[320],screenheightarray[320],*mfloorclip,*mceilingclip;
int spryscale;

void R_RenderThickSideRange(drawseg_t *ds,int x1,int x2,ffloor_t *extrafloor)
{
  int lightnum,texnum;
  sector_t tempsec;
  int roverheight;

  if(!(texnum=texturetranslation[sides[extrafloor->master
  ->sidenum[0]].midtexture])) return;
  maskedtexturecol = ds->thicksidecol;
  dc_texturemid = *extrafloor->topheight - viewz +
  sides[extrafloor->master->sidenum[0]].rowoffset;
  roverheight = (*extrafloor->topheight-*extrafloor->bottomheight)>>16;

  rw_scalestep = ds->scalestep;
  spryscale = ds->scale1 + (x1 - ds->x1)*rw_scalestep;
  mfloorclip = ds->sprbottomclip;
  mceilingclip = ds->sprtopclip;

  if (fixedcolormap)
    dc_colormap = fixedcolormap;
  else
  {
  if(ds->curline->frontsector->ffloors)
  { ffloor_t *rover=ds->curline->frontsector->ffloors;
    for(;rover;rover=rover->next)
    { if(dc_texturemid+viewz<=*rover->topheight)
      { lightnum = (*rover->toplightlevel>>LIGHTSEGSHIFT)+extralight; break; }
      else if (!rover->next) goto normallight;
    }
  } else
normallight:
  lightnum = (R_FakeFlat(ds->curline->frontsector,&tempsec,NULL,NULL,0)
  ->lightlevel>>LIGHTSEGSHIFT)+extralight;
  if (ds->curline->v1->y == ds->curline->v2->y) lightnum--;
  else
  if (ds->curline->v1->x == ds->curline->v2->x) lightnum++;
  walllights = lightnum >= LIGHTLEVELS ? scalelight[LIGHTLEVELS-1] :
    lightnum < 0 ? scalelight[0] : scalelight[lightnum];
  }
  dc_texheight=textureheight[texnum]>>FRACBITS;

  for (dc_x=x1;dc_x<=x2;dc_x++,spryscale+=rw_scalestep)
      {
        if (!fixedcolormap)
          {
	unsigned index = spryscale>>LIGHTSCALESHIFT;
	if (index >= MAXLIGHTSCALE)
	index = MAXLIGHTSCALE-1;
	dc_colormap = walllights[index];
          }
	sprtopscreen = (((long long)centeryfrac<<FRACBITS)-
	(long long)dc_texturemid*spryscale)>>FRACBITS;
	dc_iscale = 0xffffffffu / (unsigned) spryscale;
	dc_source=(byte*)R_GetColumn(texnum,maskedtexturecol[dc_x]);
	dc_yl=(sprtopscreen+FRACUNIT)>>FRACBITS;
	dc_yh=(sprtopscreen+roverheight*spryscale)>>FRACBITS;
	if(dc_yh>=mfloorclip[dc_x]) dc_yh=mfloorclip[dc_x]-1;
	if(dc_yl<=mceilingclip[dc_x]) dc_yl=mceilingclip[dc_x]+1;
	R_DrawColumn ();
      }
}

void R_RenderMaskedSegRange(drawseg_t *ds,int x1,int x2)
{
  column_t *col;
  int lightnum,texnum;
  sector_t tempsec;

  curline = ds->curline;
  colfunc = R_DrawColumn;
  if (curline->linedef->tranlump >= 0 && tran_filter_pct<100)
    {
      colfunc = R_DrawTLColumn;
      tranmap = main_tranmap;
      if (curline->linedef->tranlump > 0)
        tranmap = W_CacheLumpNum(curline->linedef->tranlump-1, PU_STATIC);
    }
  backsector = curline->backsector;
  frontsector = curline->frontsector;
  texnum = texturetranslation[curline->sidedef->midtexture];
  maskedtexturecol = ds->maskedtexturecol;
  if (curline->linedef->flags & ML_DONTPEGBOTTOM)
     dc_texturemid = (frontsector->floorheight > backsector->floorheight
     ? frontsector->floorheight : backsector->floorheight)
     + textureheight[texnum];
  else
     dc_texturemid =frontsector->ceilingheight<backsector->ceilingheight
     ? frontsector->ceilingheight : backsector->ceilingheight;
  dc_texturemid += curline->sidedef->rowoffset - viewz;

  rw_scalestep = ds->scalestep;
  spryscale = ds->scale1 + (x1 - ds->x1)*rw_scalestep;
  mfloorclip = ds->sprbottomclip;
  mceilingclip = ds->sprtopclip;

  if (fixedcolormap)
    dc_colormap = fixedcolormap;
  else
  {
  if(frontsector->ffloors)
  { ffloor_t *rover=frontsector->ffloors;
    for(;rover;rover=rover->next)
    { if(dc_texturemid+viewz<=*rover->topheight)
      { lightnum = (*rover->toplightlevel>>LIGHTSEGSHIFT)+extralight; break; }
      else if (!rover->next) goto normallight;
    }
  } else
normallight:
  lightnum = (R_FakeFlat(frontsector, &tempsec, NULL, NULL, false)
  ->lightlevel>>LIGHTSEGSHIFT)+extralight;
  if (curline->v1->y == curline->v2->y)
    lightnum--;
  else
    if (curline->v1->x == curline->v2->x)
    lightnum++;
  walllights = lightnum >= LIGHTLEVELS ? scalelight[LIGHTLEVELS-1] :
    lightnum < 0 ? scalelight[0] : scalelight[lightnum];
  }

  for (dc_x = x1 ; dc_x <= x2 ; dc_x++, spryscale += rw_scalestep)
    if (maskedtexturecol[dc_x] != MAXSHORT)
      {
        if (!fixedcolormap)
          {
            unsigned index = spryscale>>(LIGHTSCALESHIFT);

            if (index >=  MAXLIGHTSCALE )
              index = MAXLIGHTSCALE-1;

            dc_colormap = walllights[index];
          }

        {
	long long t = ((long long) centeryfrac << FRACBITS) -
	(long long) dc_texturemid * spryscale;
	if (t + (long long) textureheight[texnum] * spryscale < 0 ||
	t > (long long) 320 << FRACBITS*2)
	continue;
	sprtopscreen = (long)(t >> FRACBITS);
        }

        dc_iscale = 0xffffffffu / (unsigned) spryscale;
        col = (column_t *)((byte *)
                           R_GetColumn(texnum,maskedtexturecol[dc_x]) - 3);
        R_DrawMaskedColumn (col);
        maskedtexturecol[dc_x] = MAXSHORT;
      }

  if (curline->linedef->tranlump > 0 && tran_filter_pct<100)
    Z_ChangeTag(tranmap, PU_CACHE);
}

#define HEIGHTBITS 12
#define HEIGHTUNIT (1<<HEIGHTBITS)
int f,maxf;

void R_RenderSegLoop (void)
{
  fixed_t texturecolumn=0;
  int i,top_w,bottom_w;
  for ( ; rw_x < rw_stopx ; rw_x++)
    {
      int yh, yl = (topfrac+HEIGHTUNIT-1)>>HEIGHTBITS;
      int bottom, top = ceilingclip[rw_x]+1;

      if (yl < top)
        yl = top;

      if (markceiling)
        {
          bottom = yl-1;

          if (bottom >= floorclip[rw_x])
            bottom = floorclip[rw_x]-1;

          if (top <= bottom)
            {
              ceilingplane->top[rw_x] = top;
              ceilingplane->bottom[rw_x] = bottom;
            }
        }

      yh = bottomfrac>>HEIGHTBITS;

      bottom = floorclip[rw_x]-1;
      if (yh > bottom)
        yh = bottom;

      if (markfloor)
        {
          top  = yh < ceilingclip[rw_x] ? ceilingclip[rw_x] : yh;
          if (++top <= bottom)
            {
              floorplane->top[rw_x] = top;
              floorplane->bottom[rw_x] = bottom;
            }
        }

           for (i=0;i<numffloors;i++)
            {
                if (ffloors[i].height <= viewz)
                {
                  top_w = (ffloors[i].f_frac >> HEIGHTBITS) + 1;
                  bottom_w = ffloors[i].f_clip[rw_x];
                }
                else
                {
                  top_w = ffloors[i].c_clip[rw_x];
                  bottom_w = (ffloors[i].f_frac >> HEIGHTBITS);
                }
		if (top_w<=ceilingclip[rw_x]) top_w=ceilingclip[rw_x]+1;
		if (bottom_w>=floorclip[rw_x]) bottom_w=floorclip[rw_x]-1;
                if (top_w<=bottom_w)
                {
                  ffloors[i].plane->top[rw_x]=top_w;
                  ffloors[i].plane->bottom[rw_x]=bottom_w;
                }
            }

      if (segtextured)
        {
          unsigned index;
          angle_t angle =(rw_centerangle+xtoviewangle[rw_x])>>ANGLETOFINESHIFT;
          texturecolumn = rw_offset-FixedMul(finetangent[angle],rw_distance);
          texturecolumn >>= FRACBITS;
          index = rw_scale>>(LIGHTSCALESHIFT);
          if (index >= MAXLIGHTSCALE)
            index = MAXLIGHTSCALE-1;
          dc_colormap = walllights[index];
          dc_x = rw_x;
          dc_iscale = 0xffffffffu / (unsigned)rw_scale;
        }

      if (midtexture)
        {
          dc_texturemid = rw_midtexturemid;
          dc_source = R_GetColumn(midtexture, texturecolumn);
          dc_texheight = textureheight[midtexture]>>FRACBITS;
          dc_yl = yl;
          dc_yh = yh;
        if(frontsector->ffloors&&!fixedcolormap)
          { ffloor_t *rover=frontsector->ffloors;
            unsigned index;
            int lightnum;
            for(;rover;rover=rover->next)
            { if(dc_yl<top_w)dc_yl=top_w;
	      if(dc_yl>floorclip[rw_x])dc_yl=floorclip[rw_x];
              if(viewz>=*rover->bottomheight&&viewz<=*rover->topheight
              &&dc_yl>viewheight/2) dc_yl=viewheight/2;
	      lightnum = (*rover->toplightlevel>>LIGHTSEGSHIFT)+extralight;
          if (curline->v1->y == curline->v2->y) lightnum--;
          else if (curline->v1->x == curline->v2->x) lightnum++;
         extrawalllights = lightnum >= LIGHTLEVELS ? scalelight[LIGHTLEVELS-1] :
         lightnum < 0 ? scalelight[0] : scalelight[lightnum];
              index=rw_scale>>(LIGHTSCALESHIFT);
              if (index >= MAXLIGHTSCALE)
              index = MAXLIGHTSCALE-1;
              dc_colormap = extrawalllights[index];
            colfunc ();
            dc_yh = dc_yl-1;
            }
          dc_yl = yl;
          dc_colormap = walllights[index];
          }
          colfunc ();
          ceilingclip[rw_x] = viewheight;
          floorclip[rw_x] = -1;
        }
      else
        {
          if (toptexture)
            {
              int mid = pixhigh>>HEIGHTBITS;
              pixhigh += pixhighstep;

              if (mid >= floorclip[rw_x])
                mid = floorclip[rw_x]-1;

              if (mid >= yl)
                {
                  dc_texturemid = rw_toptexturemid;
                  dc_source = R_GetColumn(toptexture,texturecolumn);
                  dc_texheight = textureheight[toptexture]>>FRACBITS;
                  dc_yl = yl;
                  dc_yh = mid;
        if(frontsector->ffloors&&!fixedcolormap)
          { ffloor_t *rover=frontsector->ffloors;
            unsigned index;
            int lightnum;
            for(;rover;rover=rover->next)
            { if(*rover->bottomheight>backsector->ceilingheight)
              {
              if(dc_yl<bottom_w)dc_yl=bottom_w;
              if(viewz>=*rover->bottomheight&&viewz<=*rover->topheight
              &&dc_yl>viewheight/2) dc_yl=viewheight/2;
              lightnum = (*rover->toplightlevel>>LIGHTSEGSHIFT)+extralight;
          if (curline->v1->y == curline->v2->y) lightnum--;
          else if (curline->v1->x == curline->v2->x) lightnum++;
         extrawalllights = lightnum >= LIGHTLEVELS ? scalelight[LIGHTLEVELS-1] :
         lightnum < 0 ? scalelight[0] : scalelight[lightnum];
              index=rw_scale>>(LIGHTSCALESHIFT);
              if (index >= MAXLIGHTSCALE)
              index = MAXLIGHTSCALE-1;
              dc_colormap = extrawalllights[index];
              }
            colfunc ();
          dc_yh = dc_yl-1;
            }
          dc_yl = yl;
          dc_colormap = walllights[index];
          }
                  colfunc ();
                  ceilingclip[rw_x] = mid;
                }
              else
                ceilingclip[rw_x] = yl-1;
            }
          else
            if (markceiling)
              ceilingclip[rw_x] = yl-1;

          if (bottomtexture)
            {
              int mid = (pixlow+HEIGHTUNIT-1)>>HEIGHTBITS;
              pixlow += pixlowstep;

              if (mid <= ceilingclip[rw_x])
                mid = ceilingclip[rw_x]+1;

              if (mid <= yh)
                {
                  dc_texturemid = rw_bottomtexturemid;
                  dc_source = R_GetColumn(bottomtexture,texturecolumn);
                  dc_texheight = textureheight[bottomtexture]>>FRACBITS;
                  dc_yl = mid;
                  dc_yh = yh;
        if(frontsector->ffloors&&!fixedcolormap)
          { ffloor_t *rover=frontsector->ffloors;
            unsigned index;
            int lightnum;
            for(;rover;rover=rover->next)
            {
              if(dc_yl<bottom_w)dc_yl=bottom_w;
              if(viewz>=*rover->bottomheight&&viewz<=*rover->topheight
              &&dc_yl>viewheight/2) dc_yl=viewheight/2;
              lightnum = (*rover->toplightlevel>>LIGHTSEGSHIFT)+extralight;
          if (curline->v1->y == curline->v2->y) lightnum--;
          else if (curline->v1->x == curline->v2->x) lightnum++;
         extrawalllights = lightnum >= LIGHTLEVELS ? scalelight[LIGHTLEVELS-1] :
         lightnum < 0 ? scalelight[0] : scalelight[lightnum];
              index=rw_scale>>(LIGHTSCALESHIFT);
              if (index >= MAXLIGHTSCALE)
              index = MAXLIGHTSCALE-1;
              dc_colormap = extrawalllights[index];
            colfunc ();
            dc_yh = dc_yl-1;
            if(*rover->topheight>=backsector->floorheight) break;
            }
          dc_yl = mid;
          dc_colormap = walllights[index];
          }
                  colfunc ();
                  floorclip[rw_x] = mid;
                }
              else
                floorclip[rw_x] = yh+1;
            }
          else
            if (markfloor)
              floorclip[rw_x] = yh+1;

          if (maskedtexture)
            maskedtexturecol[rw_x] = texturecolumn;
          if (numthicksides)
            ds_p->thicksidecol[rw_x] = texturecolumn;
        }
	for (i=f;i--;)
	{
          ffloors[i].f_clip[rw_x]=ffloors[i].c_clip[rw_x]=ffloors[i].b_frac>>HEIGHTBITS;
          ffloors[i].b_frac+=ffloors[i].b_step;
	  ffloors[i].f_frac+=ffloors[i].f_step;
        }
      rw_scale += rw_scalestep;
      topfrac += topstep;
      bottomfrac += bottomstep;
    }
}

fixed_t R_PointToDist(fixed_t x, fixed_t y)
{
  fixed_t dx = abs(x - viewx);
  fixed_t dy = abs(y - viewy);
  if (dy > dx)
    {
      fixed_t t = dx;
      dx = dy;
      dy = t;
    }
  return dx ? FixedDiv(dx, finesine[(tantoangle[SlopeDiv(dy,dx)]
				     + ANG90) >> ANGLETOFINESHIFT]) : 0;
}
visplane_t* Extraf(visplane_t *pl, int start, int stop) { if(start<pl->minx)
pl->minx=start; if(stop>pl->maxx)pl->maxx=stop; return pl; }
subsector_t* sub;
void R_StoreWallRange(const int start, const int stop)
{
  fixed_t hyp;
  angle_t distangle, offsetangle;
  int i;
  if (ds_p == drawsegs+maxdrawsegs)
    {
      unsigned newmax = maxdrawsegs ? maxdrawsegs*2 : 128;
      drawsegs = realloc(drawsegs,newmax*sizeof(*drawsegs));
      ds_p = drawsegs+maxdrawsegs;
      maxdrawsegs = newmax;
    }
ds_p->sub=sub;
  sidedef = curline->sidedef;
  linedef = curline->linedef;
  linedef->flags |= ML_MAPPED;
  rw_normalangle = curline->angle + ANG90;
  offsetangle = abs(rw_normalangle-rw_angle1);

  if (offsetangle > ANG90)
    offsetangle = ANG90;

  distangle = ANG90 - offsetangle;
  hyp = R_PointToDist (curline->v1->x, curline->v1->y);
  rw_distance = FixedMul(hyp,finesine[distangle>>ANGLETOFINESHIFT]);

  ds_p->x1 = rw_x = start;
  ds_p->x2 = stop;
  ds_p->curline = curline;
  rw_stopx = stop+1;

  ds_p->scale1 = rw_scale =
    R_ScaleFromGlobalAngle (viewangle + xtoviewangle[start]);

  if (stop > start)
    {
      ds_p->scale2 = R_ScaleFromGlobalAngle (viewangle + xtoviewangle[stop]);
      ds_p->scalestep = rw_scalestep = (ds_p->scale2-rw_scale) / (stop-start);
    }
  else
    ds_p->scale2 = ds_p->scale1;

  worldtop = frontsector->ceilingheight - viewz;
  worldbottom = frontsector->floorheight - viewz;

  midtexture = toptexture = bottomtexture = maskedtexture = 0;
  ds_p->maskedtexturecol = NULL;
  ds_p->numthicksides = numthicksides = 0;
  ds_p->thicksidecol = NULL;

  *ds_p->thicksides = NULL;
  for (i=numffloors;i--;)
  {
  ffloors[i].f_pos = (ffloors[i].height - viewz)>>4;
  ffloors[i].f_step = FixedMul(-rw_scalestep, ffloors[i].f_pos);
  ffloors[i].f_frac = (centeryfrac >> 4) - FixedMul(ffloors[i].f_pos, rw_scale);
  }

  if (!backsector)
    {
      midtexture = texturetranslation[sidedef->midtexture];
      markfloor = markceiling = true;
      rw_midtexturemid = linedef->flags & ML_DONTPEGBOTTOM ?
      frontsector->floorheight
      + textureheight[sidedef->midtexture] - viewz : worldtop;
      rw_midtexturemid += sidedef->rowoffset;
      ds_p->silhouette = SIL_BOTH;
      ds_p->sprtopclip = screenheightarray;
      ds_p->sprbottomclip = negonearray;
      ds_p->bsilheight = MAXINT;
      ds_p->tsilheight = MININT;
    }
  else
    {
      ds_p->sprtopclip = ds_p->sprbottomclip = NULL;
      ds_p->silhouette = 0;

      if (frontsector->floorheight > backsector->floorheight)
        {
          ds_p->silhouette = SIL_BOTTOM;
          ds_p->bsilheight = frontsector->floorheight;
        }
      else
        if (backsector->floorheight > viewz)
          {
            ds_p->silhouette = SIL_BOTTOM;
            ds_p->bsilheight = MAXINT;
          }

      if (frontsector->ceilingheight < backsector->ceilingheight)
        {
          ds_p->silhouette |= SIL_TOP;
          ds_p->tsilheight = frontsector->ceilingheight;
        }
      else
        if (backsector->ceilingheight < viewz)
          {
            ds_p->silhouette |= SIL_TOP;
            ds_p->tsilheight = MININT;
          }

      {
        extern int doorclosed;
        if (doorclosed || backsector->ceilingheight<=frontsector->floorheight)
          {
            ds_p->sprbottomclip = negonearray;
            ds_p->bsilheight = MAXINT;
            ds_p->silhouette |= SIL_BOTTOM;
          }
        if (doorclosed || backsector->floorheight>=frontsector->ceilingheight)
          {
            ds_p->sprtopclip = screenheightarray;
            ds_p->tsilheight = MININT;
            ds_p->silhouette |= SIL_TOP;
          }
      }

      worldhigh = backsector->ceilingheight - viewz;
      worldlow = backsector->floorheight - viewz;

      if (frontsector->ceilingpic == skyflatnum
          && backsector->ceilingpic == skyflatnum)
        worldtop = worldhigh;

      markfloor = worldlow != worldbottom
        || backsector->floorpic != frontsector->floorpic
        || backsector->floor_xoffs != frontsector->floor_xoffs
        || backsector->floor_yoffs != frontsector->floor_yoffs
        || frontsector->heightsec != -1
        || backsector->floorlightsec != frontsector->floorlightsec
	|| (frontsector->ffloors?
*frontsector->ffloors->toplightlevel:frontsector->lightlevel)
!= (backsector->ffloors?
*backsector->ffloors->toplightlevel:backsector->lightlevel);

      markceiling = worldhigh != worldtop
        || backsector->ceilingpic != frontsector->ceilingpic
        || backsector->lightlevel != frontsector->lightlevel
        || backsector->ceiling_xoffs != frontsector->ceiling_xoffs
        || backsector->ceiling_yoffs != frontsector->ceiling_yoffs
        || (frontsector->heightsec != -1 &&
            frontsector->ceilingpic!=skyflatnum)
        || backsector->ceilinglightsec != frontsector->ceilinglightsec;

      if (backsector->ceilingheight <= frontsector->floorheight
          || backsector->floorheight >= frontsector->ceilingheight)
        markceiling = markfloor = true;

      if (worldhigh < worldtop)
        {
          toptexture = texturetranslation[sidedef->toptexture];
          rw_toptexturemid = linedef->flags & ML_DONTPEGTOP ? worldtop :
            backsector->ceilingheight+textureheight[sidedef->toptexture]-viewz;
        }

      if (worldlow > worldbottom)
        {
          bottomtexture = texturetranslation[sidedef->bottomtexture];
          rw_bottomtexturemid = linedef->flags & ML_DONTPEGBOTTOM ? worldtop :
            worldlow;
        }
      rw_toptexturemid += sidedef->rowoffset;
      rw_bottomtexturemid += sidedef->rowoffset;

        if (backsector->ffloors != frontsector->ffloors)
        {
            ffloor_t *rover, *r2;
            fixed_t lowcut, highcut;

            maskedtexture = true;

            ds_p->thicksidecol = maskedtexturecol = lastopening - rw_x;
            lastopening += rw_stopx - rw_x;

            lowcut = frontsector->floorheight > backsector->floorheight ? frontsector->floorheight : backsector->floorheight;
            highcut = frontsector->ceilingheight < backsector->ceilingheight ? frontsector->ceilingheight : backsector->ceilingheight;

            if (frontsector->ffloors && backsector->ffloors)
            {
                i = 0;
                for (rover = backsector->ffloors; rover; rover = rover->next)
                {
                    if (*rover->topheight < lowcut || *rover->bottomheight > highcut)
                        continue;
                    for (r2 = frontsector->ffloors; r2; r2 = r2->next)
                    {
                      if (*r2->topheight < lowcut || *r2->bottomheight > highcut)
                       continue;
                      if (*rover->topheight > *r2->topheight || *rover->bottomheight < *r2->bottomheight)
                       continue;
                      break;
                    }
                    if (r2) continue;
                    ds_p->thicksides[i] = rover;
                    i++;
                }
             ds_p->numthicksides = numthicksides = i;
            }
            else if (backsector->ffloors)
            {
                for (rover = backsector->ffloors, i = 0; rover; rover = rover->next)
                {
                    if (*rover->topheight <= frontsector->floorheight || *rover->bottomheight >= frontsector->ceilingheight)
                     continue;
                    ds_p->thicksides[i] = rover;
                    i++;
                }
             ds_p->numthicksides = numthicksides = i;
            }
        }

      if (sidedef->midtexture)
        {
          maskedtexture = true;
          ds_p->maskedtexturecol = maskedtexturecol = lastopening - rw_x;
          lastopening += rw_stopx - rw_x;
        }
    }

  segtextured = midtexture | toptexture | bottomtexture | maskedtexture;

  if (segtextured)
    {
      offsetangle = rw_normalangle-rw_angle1;

      if (offsetangle > ANG180)
        offsetangle = -offsetangle;

      if (offsetangle > ANG90)
        offsetangle = ANG90;

      rw_offset = FixedMul(hyp,finesine[offsetangle >>ANGLETOFINESHIFT]);

      if (rw_normalangle-rw_angle1 < ANG180)
        rw_offset = -rw_offset;

      rw_offset += sidedef->textureoffset + curline->offset;

      rw_centerangle = ANG90 + viewangle - rw_normalangle;

      if (!fixedcolormap)
        {
          int lightnum = (frontsector->lightlevel>>LIGHTSEGSHIFT)+extralight;
          if (curline->v1->y == curline->v2->y)
            lightnum--;
          else if (curline->v1->x == curline->v2->x)
            lightnum++;
  walllights = lightnum >= LIGHTLEVELS ? scalelight[LIGHTLEVELS-1] :
  lightnum < 0 ? scalelight[0] : scalelight[lightnum];
        }
    }

  if (frontsector->heightsec == -1)
    {
      if (frontsector->floorheight >= viewz)
        markfloor = false;
      if (frontsector->ceilingheight <= viewz &&
          frontsector->ceilingpic != skyflatnum)
        markceiling = false;
    }

  worldtop >>= 4;
  worldbottom >>= 4;

  topstep = -FixedMul (rw_scalestep, worldtop);
  topfrac = (centeryfrac>>4) - FixedMul (worldtop, rw_scale);

  bottomstep = -FixedMul (rw_scalestep,worldbottom);
  bottomfrac = (centeryfrac>>4) - FixedMul (worldbottom, rw_scale);

  if (backsector)
    {
      worldhigh >>= 4;
      worldlow >>= 4;

      if (worldhigh < worldtop)
        {
          pixhigh = (centeryfrac>>4) - FixedMul (worldhigh, rw_scale);
          pixhighstep = -FixedMul (rw_scalestep,worldhigh);
        }
      if (worldlow > worldbottom)
        {
          pixlow = (centeryfrac>>4) - FixedMul (worldlow, rw_scale);
          pixlowstep = -FixedMul (rw_scalestep,worldlow);
        }

        {
          ffloor_t *rover=backsector->ffloors;
          i = f = 0;
          for (;rover;rover=rover->next)
            {
             if (viewz<*rover->bottomheight)
              {
              ffloors[i].b_pos = (*rover->bottomheight - viewz)>>4;
              ffloors[i].b_step = FixedMul(-rw_scalestep, ffloors[i].b_pos);
              ffloors[i].b_frac = (centeryfrac >> 4) - FixedMul(ffloors[i].b_pos, rw_scale);
              i++;
              } else
              if (viewz>*rover->topheight)
              {
              ffloors[i].b_pos = (*rover->topheight - viewz)>>4;
              ffloors[i].b_step = FixedMul(-rw_scalestep, ffloors[i].b_pos);
              ffloors[i].b_frac = (centeryfrac >> 4) - FixedMul(ffloors[i].b_pos, rw_scale);
              i++;
              }
            }
	rover=frontsector->ffloors; f=i; i=0;
	for (;rover;rover=rover->next) i++;
	if(i>f)f=i; if(f>maxf)maxf=f;
        }
    }

    ds_p->numffloorplanes = 0;
    if (numffloors)
    { int j=numffloors;
      for (i=numffloors;i--;)
      if(ffloors[i].plane->height>viewz)
      ds_p->ffloorplanes[--j] = Extraf(ffloors[i].plane, rw_x, rw_stopx - 1);
      j=-1;
      for (i=numffloors;i--;)
      if(ffloors[i].plane->height<viewz)
      ds_p->ffloorplanes[++j] = Extraf(ffloors[i].plane, rw_x, rw_stopx - 1);
      ds_p->numffloorplanes = numffloors;
    }
  if (markceiling)
    if (ceilingplane)
      ceilingplane = R_CheckPlane (ceilingplane, rw_x, rw_stopx-1);
    else
      markceiling = 0;

  if (markfloor)
    if (floorplane)
      floorplane = R_CheckPlane (floorplane, rw_x, rw_stopx-1);
    else
      markfloor = 0;

  R_RenderSegLoop();

  if ((ds_p->silhouette & SIL_TOP || maskedtexture) && !ds_p->sprtopclip)
    {
      memcpy (lastopening, ceilingclip+start, 2*(rw_stopx-start));
      ds_p->sprtopclip = lastopening - start;
      lastopening += rw_stopx - start;
    }
  if ((ds_p->silhouette & SIL_BOTTOM || maskedtexture) && !ds_p->sprbottomclip)
    {
      memcpy (lastopening, floorclip+start, 2*(rw_stopx-start));
      ds_p->sprbottomclip = lastopening - start;
      lastopening += rw_stopx - start;
    }
  if (maskedtexture && !(ds_p->silhouette & SIL_TOP))
    {
      ds_p->silhouette |= SIL_TOP;
      ds_p->tsilheight = MININT;
    }
  if (maskedtexture && !(ds_p->silhouette & SIL_BOTTOM))
    {
      ds_p->silhouette |= SIL_BOTTOM;
      ds_p->bsilheight = MAXINT;
    }
  ds_p++;
}