/*
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation. NO WARRANTY.
*/

#include "doomdef.h"
#include "r_main.h"
#include "m_bbox.h"
#include "w_wad.h"
#include "v_video.h"

byte *screens[5];

char *cr_green,*cr_yellow,*cr_red;
char *colrngs[10];

byte gammatable[5][256] =
{
  {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,
   17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
   33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,
   49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
   65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,
   81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,
   97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,
   113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,
   128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
   144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
   160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
   176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
   192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
   208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
   224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
   240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255},

  {2,4,5,7,8,10,11,12,14,15,16,18,19,20,21,23,24,25,26,27,29,30,31,
   32,33,34,36,37,38,39,40,41,42,44,45,46,47,48,49,50,51,52,54,55,
   56,57,58,59,60,61,62,63,64,65,66,67,69,70,71,72,73,74,75,76,77,
   78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,
   99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,
   115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,129,
   130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,
   146,147,148,148,149,150,151,152,153,154,155,156,157,158,159,160,
   161,162,163,163,164,165,166,167,168,169,170,171,172,173,174,175,
   175,176,177,178,179,180,181,182,183,184,185,186,186,187,188,189,
   190,191,192,193,194,195,196,196,197,198,199,200,201,202,203,204,
   205,205,206,207,208,209,210,211,212,213,214,214,215,216,217,218,
   219,220,221,222,222,223,224,225,226,227,228,229,230,230,231,232,
   233,234,235,236,237,237,238,239,240,241,242,243,244,245,245,246,
   247,248,249,250,251,252,252,253,254,255},

  {4,7,9,11,13,15,17,19,21,22,24,26,27,29,30,32,33,35,36,38,39,40,42,
   43,45,46,47,48,50,51,52,54,55,56,57,59,60,61,62,63,65,66,67,68,69,
   70,72,73,74,75,76,77,78,79,80,82,83,84,85,86,87,88,89,90,91,92,93,
   94,95,96,97,98,100,101,102,103,104,105,106,107,108,109,110,111,112,
   113,114,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,
   129,130,131,132,133,133,134,135,136,137,138,139,140,141,142,143,144,
   144,145,146,147,148,149,150,151,152,153,153,154,155,156,157,158,159,
   160,160,161,162,163,164,165,166,166,167,168,169,170,171,172,172,173,
   174,175,176,177,178,178,179,180,181,182,183,183,184,185,186,187,188,
   188,189,190,191,192,193,193,194,195,196,197,197,198,199,200,201,201,
   202,203,204,205,206,206,207,208,209,210,210,211,212,213,213,214,215,
   216,217,217,218,219,220,221,221,222,223,224,224,225,226,227,228,228,
   229,230,231,231,232,233,234,235,235,236,237,238,238,239,240,241,241,
   242,243,244,244,245,246,247,247,248,249,250,251,251,252,253,254,254,
   255},

  {8,12,16,19,22,24,27,29,31,34,36,38,40,41,43,45,47,49,50,52,53,55,
   57,58,60,61,63,64,65,67,68,70,71,72,74,75,76,77,79,80,81,82,84,85,
   86,87,88,90,91,92,93,94,95,96,98,99,100,101,102,103,104,105,106,107,
   108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,
   125,126,127,128,129,130,131,132,133,134,135,135,136,137,138,139,140,
   141,142,143,143,144,145,146,147,148,149,150,150,151,152,153,154,155,
   155,156,157,158,159,160,160,161,162,163,164,165,165,166,167,168,169,
   169,170,171,172,173,173,174,175,176,176,177,178,179,180,180,181,182,
   183,183,184,185,186,186,187,188,189,189,190,191,192,192,193,194,195,
   195,196,197,197,198,199,200,200,201,202,202,203,204,205,205,206,207,
   207,208,209,210,210,211,212,212,213,214,214,215,216,216,217,218,219,
   219,220,221,221,222,223,223,224,225,225,226,227,227,228,229,229,230,
   231,231,232,233,233,234,235,235,236,237,237,238,238,239,240,240,241,
   242,242,243,244,244,245,246,246,247,247,248,249,249,250,251,251,252,
   253,253,254,254,255},

  {16,23,28,32,36,39,42,45,48,50,53,55,57,60,62,64,66,68,69,71,73,75,76,
   78,80,81,83,84,86,87,89,90,92,93,94,96,97,98,100,101,102,103,105,106,
   107,108,109,110,112,113,114,115,116,117,118,119,120,121,122,123,124,
   125,126,128,128,129,130,131,132,133,134,135,136,137,138,139,140,141,
   142,143,143,144,145,146,147,148,149,150,150,151,152,153,154,155,155,
   156,157,158,159,159,160,161,162,163,163,164,165,166,166,167,168,169,
   169,170,171,172,172,173,174,175,175,176,177,177,178,179,180,180,181,
   182,182,183,184,184,185,186,187,187,188,189,189,190,191,191,192,193,
   193,194,195,195,196,196,197,198,198,199,200,200,201,202,202,203,203,
   204,205,205,206,207,207,208,208,209,210,210,211,211,212,213,213,214,
   214,215,216,216,217,217,218,219,219,220,220,221,221,222,223,223,224,
   224,225,225,226,227,227,228,228,229,229,230,230,231,232,232,233,233,
   234,234,235,235,236,236,237,237,238,239,239,240,240,241,241,242,242,
   243,243,244,244,245,245,246,246,247,247,248,248,249,249,250,250,251,
   251,252,252,253,254,254,255,255}
};

int usegamma;

typedef struct {
  const char *name;
  char **map1, **map2;
} crdef_t;

static const crdef_t crdefs[] = {
  {"CRGREEN",&cr_green,&colrngs[CR_GREEN]},
  {"CRYELLOW",&cr_yellow,&colrngs[CR_YELLOW]},
  {NULL}
};

void V_InitColorTranslation(void)
{
  register const crdef_t *p;
  for (p=crdefs; p->name; p++)
    *p->map1 = *p->map2 = W_CacheLumpName(p->name, PU_STATIC);
}

void V_CopyRect(int srcx, int srcy, int srcscrn, int width,
		int height, int destx, int desty, int destscrn )
{
  byte *src;
  byte *dest;

    {
      src = screens[srcscrn]+SCREENWIDTH*srcy+srcx;
      dest = screens[destscrn]+SCREENWIDTH*desty+destx;

      for ( ; height>0 ; height--)
	{
	  memcpy (dest, src, width);
	  src += SCREENWIDTH;
	  dest += SCREENWIDTH;
	}
    }
}

void V_DrawPatch(int x, int y, int scrn, patch_t *patch,
			boolean flipped)
{
  int  w = SHORT(patch->width), col = w-1, colstop = -1, colstep = -1;
  
  if (!flipped)
    col = 0, colstop = w, colstep = 1;

  y -= SHORT(patch->topoffset);
  x -= SHORT(patch->leftoffset);

    {
      byte *desttop = screens[scrn]+y*SCREENWIDTH+x;

      for ( ; col != colstop ; col += colstep, desttop++)
	{
	  const column_t *column = 
	    (const column_t *)((byte *)patch + LONG(patch->columnofs[col]));
	  while (column->topdelta != 0xff)
	    { register const byte *source = (byte *) column + 3;
	      register byte *dest = desttop + column->topdelta*SCREENWIDTH;
	      register int count = column->length;

	      if ((count-=4)>=0)
		do
		  {
		    register byte s0,s1;
		    s0 = source[0];
		    s1 = source[1];
		    dest[0] = s0;
                    dest[320] = s1;
		    dest += SCREENWIDTH*2;
		    s0 = source[2];
		    s1 = source[3];
		    source += 4;
		    dest[0] = s0;
                    dest[320] = s1;
		    dest += SCREENWIDTH*2;
		  }
		while ((count-=4)>=0);
	      if (count+=4)
		do
		  {
		    *dest = *source++;
		    dest += SCREENWIDTH;
		  }
		while (--count);
	      column = (column_t *)(source+1);
	    }
	}
    }
}

void V_DrawPatchTranslated(int x, int y, int scrn, patch_t *patch,
                           char *outr, int cm)
{
  int col, w;
  if (outr==cr_red)
    { V_DrawPatch(x,y,scrn,patch,0); return; }

  y -= SHORT(patch->topoffset);
  x -= SHORT(patch->leftoffset);

  col = 0;
  w = SHORT(patch->width);

    {
      byte *desttop = screens[scrn]+y*SCREENWIDTH+x;

      for ( ; col<w ; col++, desttop++)
	{
	  const column_t *column =
	    (const column_t *)((byte *)patch + LONG(patch->columnofs[col]));
	  while (column->topdelta != 0xff)
	    { register const byte *source = (byte *) column + 3;
	      register byte *dest = desttop + column->topdelta*SCREENWIDTH;
	      register int count = column->length;

	      if ((count-=4)>=0)
		do
		  {
		    register byte s0,s1;
		    s0 = source[0];
		    s1 = source[1];

		    s0 = outr[s0];
		    s1 = outr[s1];
		    dest[0] = s0;
                    dest[320] = s1;
		    dest += SCREENWIDTH*2;
		    s0 = source[2];
		    s1 = source[3];
		    s0 = outr[s0];
		    s1 = outr[s1];
		    source += 4;
		    dest[0] = s0;
                    dest[320] = s1;
		    dest += SCREENWIDTH*2;
		  }
		while ((count-=4)>=0);
	      if (count+=4)
		do
		  {
		    *dest = outr[*source++];
		    dest += SCREENWIDTH;
		  }
		while (--count);
	      column = (column_t *)(source+1);
	    }
	}

    }
}

void V_DrawBlock(int x, int y, int scrn, int width, int height, byte *src)
{
    {
      byte *dest = screens[scrn] + y*SCREENWIDTH+x;

      while (height--)
	{
	  memcpy (dest, src, width);
	  src += width;
	  dest += SCREENWIDTH;
	}
    }
}

void V_Init(void)
{
  screens[0] = calloc(64000,1);
  if (!screens[0]) return;
  screens[3] = (screens[2] = (screens[1] = calloc(64000,3)) + 64000) + 64000;
}