/*
 *	Name:		Memory access routines
 *	Project:	MUS File Player Library
 *	Version:	1.20
 *	Author:		Vladimir Arnost (QA-Software)
 *	Last revision:	Sep-4-1995
 *	Compiler:	Borland C++ 3.1, Watcom C/C++ 10.0
 *
 */

#include <dos.h>
#include <mem.h>
#include <stdlib.h>
#include "muslib.h"

#define CONV_MEM(mem)	((BYTE *)(mem))

static DWORD allocConv(ulong size)
{
 void *ptr = malloc(size);
 return ptr ? (DWORD)ptr : -1LU;
}

static int freeConv(DWORD handle)
{
 if (handle != -1LU)
	free((void *)handle);
 return 0;
}

static int loadtoConv(int fd, ulong length, struct memoryBlock *block)
{
 DWORD handle;
 if ( (handle = allocConv(length)) != (DWORD)-1 )
 {
	uint sizeread;

	block->bufferType = BT_CONV;
	block->handle = handle;
	block->buffer = CONV_MEM(handle);
	block->size = length;
        if (_dos_read(fd, CONV_MEM(handle), length,&sizeread) ||
 sizeread != length)
	{
 freeConv(handle);
 return -1;
	}
 } else
	return -1;

 block->bufAt = 0;
 block->bufLen = block->size;
 return block->bufPos = 0;
}

static int getbufConv(struct memoryBlock *block)
{
 block->buffer = CONV_MEM(block->handle);
 block->bufLen = block->size;
 return block->bufPos = 0;
}

int MEMload(int fd, ulong length, struct memoryBlock *block, uint memory)
{
 memset(block, 0, sizeof *block);
 if (memory & 1)
 if (!loadtoConv(fd, length, block))
 return 0;
 return -1;
}

int MEMfree(struct memoryBlock *block)
{
 switch (block->bufferType) {
 case BT_CONV:
 return freeConv(block->handle);
 default:
 return -1;
 }
}

int MEMgetchar(struct memoryBlock *block)
{
 if (!block->buffer || block->bufPos >= block->bufLen)
 if ( (block->bufAt += block->bufPos) < block->size )
 {
 switch (block->bufferType) {
 case BT_CONV:
 getbufConv(block);
 break;
 default:
 return -1;
 }
 } else
 return -1;
 return block->buffer[block->bufPos++];
}

int MEMrewind(struct memoryBlock *block)
{
 if (block->bufAt)
 {
 block->bufAt = 0;
 switch (block->bufferType) {
 case BT_CONV:
 getbufConv(block);
 break;
 default:
 return -1;
 }
 }
 return block->bufPos = 0;
}
