/*
 *	Name:		MPU-401 (UART mode) General MIDI music driver
 *	Project:	MUS File Player Library
 *	Version:	1.10
 *	Author:		Vladimir Arnost (QA-Software)
 *	Last revision:	Mar-08-1996
 *	Compiler:	Borland C++ 3.1, Watcom C/C++ 10.0
 *
 */

#include <dos.h>
#include <conio.h>
#include "muslib.h"

static char MPU401name[] = "MPU-401 MIDI";

struct driverBlock MPU401driver = {
	0L,
	DRV_MPU401,
	MPU401name,
	sizeof(struct MIDIdata),
	MIDIinitDriver,
	MIDIdeinitDriver,
	MPU401driverParam,
	MPU401loadBank,
	0L,
	MPU401initHardware,
	MPU401deinitHardware,

	MIDIplayNote,
	MIDIreleaseNote,
	MIDIpitchWheel,
	MIDIchangeControl,
	MIDIplayMusic,
	MIDIstopMusic,
	MIDIchangeVolume,
	MIDIpauseMusic,
	MIDIunpauseMusic,
	MPU401sendMIDI};


static uint MPU401port = MPU401PORT;
static uint runningStatus = 0;

#define MPU401_SET_UART	(uchar)0x3F
#define MPU401_RESET	(uchar)0xFF
#define MPU401_BUSY	(uchar)0x40
#define MPU401_EMPTY	(uchar)0x80
#define MPU401_ACK	(uchar)0xFE

static int MPU401sendByte(uchar value)
{
 register uint timeout = 10000;
 register uint statusport = MPU401port + 1;

 for(;;)
 {
	uint delay;
	uchar status = inportb(statusport);
	if ((status & MPU401_BUSY) == 0)
 break;
	if (status & MPU401_EMPTY)
 continue;
	enable();
	for (delay = 100; delay; delay--);
	inportb(MPU401port);
	if (--timeout == 0)
 return -1;
 }

 outportb(MPU401port, value);
 return 0;
}

static int MPU401sendBlock(uchar *block, uint length)
{
 runningStatus = 0;

 disable();
 while (length--)
	MPU401sendByte(*block++);
 enable();
 return 0;
}

static int MPU401sendCommand(uchar value)
{
 register uint timeout, statusport = MPU401port + 1;

 runningStatus = 0;

 for(timeout = 0xFFFF;;)
 {
	if ((inportb(statusport) & MPU401_BUSY) == 0)
 break;
	if (--timeout == 0)
 return -1;
 }

 outportb(statusport, value);

 for(timeout = 0xFFFF;;)
 {
	if ((inportb(statusport) & MPU401_EMPTY) == 0)
 if (inportb(MPU401port) == MPU401_ACK)
		break;
	if (--timeout == 0)
 return -1;
 }

 return 0;
}

static int MPU401reset(void)
{
 runningStatus = 0;
 if (!MPU401sendCommand(MPU401_RESET))
	return 0;
 return MPU401sendCommand(MPU401_RESET);
}

int MPU401sendMIDI(uint command, uint par1, uint par2)
{
 register uint event = command & MIDI_EVENT_MASK;

 if (event == MIDI_NOTE_ON)
	playingChannels++;
 else if (event == MIDI_NOTE_OFF)
 {
	playingChannels--;
	command = (command & 0x0F) | MIDI_NOTE_ON;
	par2 = 0;
 }

 disable();
 if (runningStatus != command)
	MPU401sendByte(runningStatus = command);
 MPU401sendByte(par1);
 if (event != MIDI_PATCH && event != MIDI_CHAN_TOUCH)
	MPU401sendByte(par2);
 enable();
 return 0;
}

int MPU401driverParam(uint message, uint param1, void *param2)
{
 switch (message) {
	case DP_SYSEX:
 MPU401sendBlock((uchar *)param2, param1);
 break;
 }
 return 0;
}

int MPU401loadBank(int fd)
{
 return 0;
}

int MPU401initHardware(uint port)
{
 MPU401port = port;
 if (MPU401reset())
	return -1;
 return MPU401sendCommand(MPU401_SET_UART);
}

int MPU401deinitHardware(void)
{
 return MPU401sendCommand(MPU401_RESET);
}
