#ifndef __DOOMDEF__
#define __DOOMDEF__

#include "z_zone.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>

short SHORT(short x);
long LONG(long x);

#define VERSION 206
typedef enum {
  shareware,
  registered,
  commercial,
  retail,
  indetermined
} GameMode_t;

typedef enum {
  doom,
  doom2,
  pack_tnt,
  pack_plut,
  none
} GameMission_t;

#define SCREENWIDTH  320
#define SCREENHEIGHT 200
#define MAXPLAYERS 4
#define TICRATE    35

typedef enum {
  GS_LEVEL,
  GS_INTERMISSION,
  GS_FINALE,
  GS_DEMOSCREEN
} gamestate_t;

#define MTF_EASY       1
#define MTF_NORMAL     2
#define MTF_HARD       4
#define MTF_AMBUSH     8
#define MTF_NOTSINGLE 16
#define MTF_NOTDM     32
#define MTF_NOTCOOP   64
#define MTF_FRIEND   128
#define MTF_RESERVED 256

typedef enum {
  sk_baby=0,
  sk_easy,
  sk_medium,
  sk_hard,
  sk_nightmare
} skill_t;

typedef enum {
  it_bluecard,
  it_yellowcard,
  it_redcard,
  it_blueskull,
  it_yellowskull,
  it_redskull,
  NUMCARDS
} card_t;

typedef enum {
  wp_fist,
  wp_pistol,
  wp_shotgun,
  wp_chaingun,
  wp_missile,
  wp_plasma,
  wp_bfg,
  wp_chainsaw,
  wp_supershotgun,

  NUMWEAPONS,
  wp_nochange
} weapontype_t;

typedef enum {
  am_clip,
  am_shell,
  am_cell,
  am_misl,
  NUMAMMO,
  am_noammo
} ammotype_t;

typedef enum {
  pw_invulnerability,
  pw_strength,
  pw_invisibility,
  pw_ironfeet,
  pw_allmap,
  pw_infrared,
  NUMPOWERS
} powertype_t;

typedef enum {
  INVULNTICS  = (30*TICRATE),
  INVISTICS   = (60*TICRATE),
  INFRATICS   = (120*TICRATE),
  IRONTICS    = (60*TICRATE)
} powerduration_t;

#define KEYD_RIGHTARROW 0xae
#define KEYD_LEFTARROW  0xac
#define KEYD_UPARROW    0xad
#define KEYD_DOWNARROW  0xaf
#define KEYD_ESCAPE     27
#define KEYD_ENTER      13
#define KEYD_TAB        9
#define KEYD_F1         (0x80+0x3b)
#define KEYD_F2         (0x80+0x3c)
#define KEYD_F3         (0x80+0x3d)
#define KEYD_F4         (0x80+0x3e)
#define KEYD_F5         (0x80+0x3f)
#define KEYD_F6         (0x80+0x40)
#define KEYD_F7         (0x80+0x41)
#define KEYD_F8         (0x80+0x42)
#define KEYD_F9         (0x80+0x43)
#define KEYD_F10        (0x80+0x44)
#define KEYD_F11        (0x80+0x57)
#define KEYD_F12        (0x80+0x58)
#define KEYD_BACKSPACE  127
#define KEYD_PAUSE      0xff
#define KEYD_EQUALS     0x3d
#define KEYD_MINUS      0x2d
#define KEYD_RSHIFT     (0x80+0x36)
#define KEYD_RCTRL      (0x80+0x1d)
#define KEYD_RALT       (0x80+0x38)
#define KEYD_LALT       KEYD_RALT
#define KEYD_CAPSLOCK   0xba
#define KEYD_INSERT     0xd2
#define KEYD_HOME       0xc7
#define KEYD_PAGEUP     0xc9
#define KEYD_PAGEDOWN   0xd1
#define KEYD_DEL        KEYD_BACKSPACE
#define KEYD_END        0xcf
#define KEYD_SPACEBAR   0x20

#define MORE_FRICTION_MOMENTUM 15000
#define ORIG_FRICTION          0xE800
#define ORIG_FRICTION_FACTOR   2048

#endif