#include "doomdef.h"
#include "doomstat.h"
#include "sounds.h"
#include "info.h"
#include "m_cheat.h"
#include "p_inter.h"
#include "g_game.h"
#include "d_think.h"
#include "w_wad.h"
#include "d_englsh.h"

typedef struct {
 byte *inp, *lump;
 long size;
} DEHFILE;

#define fgets(buf,n,fp) dehfgets(buf,n,fp)
#define feof(buf) dehfeof(buf)
#define fgetc(buf) dehfgetc(buf)

char *dehfgets(char *buf, size_t n, DEHFILE *fp)
{
 if (!fp->lump)
 return (fgets)(buf, n, (FILE *) fp->inp);
 if (!n || !*fp->inp || fp->size<=0)
 return NULL;
 if (n==1)
 fp->size--, *buf = *fp->inp++;
 else
 {
 char *p = buf;
 while (n>1 && *fp->inp && fp->size &&
 (n--, fp->size--, *p++ = *fp->inp++) != '\n')
 ;
 *p = 0;
 }
 return buf;
}

int dehfeof(DEHFILE *fp)
{
 return !fp->lump ? (feof)((FILE *) fp->inp) : !*fp->inp || fp->size<=0;
}

int dehfgetc(DEHFILE *fp)
{
 return !fp->lump ? (fgetc)((FILE *) fp->inp) : fp->size > 0 ?
 fp->size--, *fp->inp++ : EOF;
}

char *s_LOADNET = LOADNET,*s_QLOADNET = QLOADNET,*s_QSAVESPOT = QSAVESPOT,
*s_SAVEDEAD = SAVEDEAD,*s_QSPROMPT = QSPROMPT,*s_QLPROMPT = QLPROMPT,*s_NEWGAME = NEWGAME,
*s_NIGHTMARE = NIGHTMARE,*s_SWSTRING = SWSTRING,*s_MSGOFF = MSGOFF,
*s_MSGON = MSGON,*s_NETEND = NETEND,*s_ENDGAME = ENDGAME,*s_DOSY = DOSY,
*s_GAMMALVL0 = GAMMALVL0,*s_GAMMALVL1 = GAMMALVL1,*s_GAMMALVL2 = GAMMALVL2,
*s_GAMMALVL3 = GAMMALVL3,*s_GAMMALVL4 = GAMMALVL4,*s_EMPTYSTRING = EMPTYSTRING,
*s_GOTARMOR = GOTARMOR,*s_GOTMEGA = GOTMEGA,*s_GOTHTHBONUS = GOTHTHBONUS,
*s_GOTARMBONUS = GOTARMBONUS,*s_GOTSTIM = GOTSTIM,*s_GOTMEDIKIT = GOTMEDIKIT,
*s_GOTSUPER = GOTSUPER,*s_GOTBLUECARD = GOTBLUECARD,*s_GOTYELWCARD = GOTYELWCARD,
*s_GOTREDCARD = GOTREDCARD,*s_GOTBLUESKUL = GOTBLUESKUL,*s_GOTYELWSKUL = GOTYELWSKUL,
*s_GOTREDSKULL = GOTREDSKULL,*s_GOTINVUL = GOTINVUL,*s_GOTBERSERK = GOTBERSERK,
*s_GOTINVIS = GOTINVIS,*s_GOTSUIT = GOTSUIT,*s_GOTMAP = GOTMAP,*s_GOTVISOR = GOTVISOR,
*s_GOTMSPHERE = GOTMSPHERE,*s_GOTCLIP = GOTCLIP,*s_GOTCLIPBOX = GOTCLIPBOX,
*s_GOTROCKET = GOTROCKET,*s_GOTROCKBOX = GOTROCKBOX,*s_GOTCELL = GOTCELL,
*s_GOTCELLBOX = GOTCELLBOX,*s_GOTSHELLS = GOTSHELLS,*s_GOTSHELLBOX = GOTSHELLBOX,
*s_GOTBACKPACK = GOTBACKPACK,*s_GOTBFG9000 = GOTBFG9000,*s_GOTCHAINGUN = GOTCHAINGUN,
*s_GOTCHAINSAW = GOTCHAINSAW,*s_GOTLAUNCHER = GOTLAUNCHER,*s_GOTPLASMA = GOTPLASMA,
*s_GOTSHOTGUN = GOTSHOTGUN,*s_GOTSHOTGUN2 = GOTSHOTGUN2,*s_PD_BLUEO = PD_BLUEO,
*s_PD_REDO = PD_REDO,*s_PD_YELLOWO = PD_YELLOWO,*s_PD_BLUEK = PD_BLUEK,
*s_PD_REDK = PD_REDK,*s_PD_YELLOWK = PD_YELLOWK,*s_GGSAVED = GGSAVED,
*s_HUSTR_MSGU = HUSTR_MSGU,*s_HUSTR_E1M1 = HUSTR_E1M1,*s_HUSTR_E1M2 = HUSTR_E1M2,
*s_HUSTR_E1M3 = HUSTR_E1M3,*s_HUSTR_E1M4 = HUSTR_E1M4,*s_HUSTR_E1M5 = HUSTR_E1M5,
*s_HUSTR_E1M6 = HUSTR_E1M6,*s_HUSTR_E1M7 = HUSTR_E1M7,*s_HUSTR_E1M8 = HUSTR_E1M8,
*s_HUSTR_E1M9 = HUSTR_E1M9,*s_HUSTR_E2M1 = HUSTR_E2M1,*s_HUSTR_E2M2 = HUSTR_E2M2,
*s_HUSTR_E2M3 = HUSTR_E2M3,*s_HUSTR_E2M4 = HUSTR_E2M4,*s_HUSTR_E2M5 = HUSTR_E2M5,
*s_HUSTR_E2M6 = HUSTR_E2M6,*s_HUSTR_E2M7 = HUSTR_E2M7,*s_HUSTR_E2M8 = HUSTR_E2M8,
*s_HUSTR_E2M9 = HUSTR_E2M9,*s_HUSTR_E3M1 = HUSTR_E3M1,*s_HUSTR_E3M2 = HUSTR_E3M2,
*s_HUSTR_E3M3 = HUSTR_E3M3,*s_HUSTR_E3M4 = HUSTR_E3M4,*s_HUSTR_E3M5 = HUSTR_E3M5,
*s_HUSTR_E3M6 = HUSTR_E3M6,*s_HUSTR_E3M7 = HUSTR_E3M7,*s_HUSTR_E3M8 = HUSTR_E3M8,
*s_HUSTR_E3M9 = HUSTR_E3M9,*s_HUSTR_1 = HUSTR_1,*s_HUSTR_2 = HUSTR_2,
*s_HUSTR_3 = HUSTR_3,*s_HUSTR_4 = HUSTR_4,*s_HUSTR_5 = HUSTR_5,
*s_HUSTR_6 = HUSTR_6,*s_HUSTR_7 = HUSTR_7,*s_HUSTR_8 = HUSTR_8,
*s_HUSTR_9 = HUSTR_9,*s_HUSTR_10 = HUSTR_10,*s_HUSTR_11 = HUSTR_11,
*s_HUSTR_12 = HUSTR_12,*s_HUSTR_13 = HUSTR_13,*s_HUSTR_14 = HUSTR_14,
*s_HUSTR_15 = HUSTR_15,*s_HUSTR_16 = HUSTR_16,*s_HUSTR_17 = HUSTR_17,
*s_HUSTR_18 = HUSTR_18,*s_HUSTR_19 = HUSTR_19,*s_HUSTR_20 = HUSTR_20,
*s_HUSTR_21 = HUSTR_21,*s_HUSTR_22 = HUSTR_22,*s_HUSTR_23 = HUSTR_23,
*s_HUSTR_24 = HUSTR_24,*s_HUSTR_25 = HUSTR_25,*s_HUSTR_26 = HUSTR_26,
*s_HUSTR_27 = HUSTR_27,*s_HUSTR_28 = HUSTR_28,*s_HUSTR_29 = HUSTR_29,
*s_HUSTR_30 = HUSTR_30,*s_HUSTR_31 = HUSTR_31,*s_HUSTR_32 = HUSTR_32,
*s_HUSTR_PLRGREEN = HUSTR_PLRGREEN,*s_HUSTR_PLRINDIGO = HUSTR_PLRINDIGO,
*s_HUSTR_PLRBROWN = HUSTR_PLRBROWN,*s_HUSTR_PLRRED = HUSTR_PLRRED,*s_AMSTR_FOLLOWON = AMSTR_FOLLOWON,
*s_AMSTR_FOLLOWOFF = AMSTR_FOLLOWOFF,*s_AMSTR_GRIDON = AMSTR_GRIDON,*s_AMSTR_GRIDOFF = AMSTR_GRIDOFF,
*s_AMSTR_MARKEDSPOT = AMSTR_MARKEDSPOT,*s_AMSTR_MARKSCLEARED = AMSTR_MARKSCLEARED,
*s_STSTR_MUS = STSTR_MUS,*s_STSTR_NOMUS = STSTR_NOMUS,*s_STSTR_DQDON = STSTR_DQDON,
*s_STSTR_DQDOFF = STSTR_DQDOFF,*s_STSTR_KFAADDED = STSTR_KFAADDED,*s_STSTR_FAADDED = STSTR_FAADDED,
*s_STSTR_NCON = STSTR_NCON,*s_STSTR_NCOFF = STSTR_NCOFF,*s_STSTR_BEHOLD = STSTR_BEHOLD,
*s_STSTR_BEHOLDX = STSTR_BEHOLDX,*s_STSTR_CHOPPERS = STSTR_CHOPPERS,
*s_E1TEXT = E1TEXT,*s_E2TEXT = E2TEXT,*s_E3TEXT = E3TEXT,
*s_C1TEXT = C1TEXT,*s_C2TEXT = C2TEXT,*s_C3TEXT = C3TEXT,*s_C4TEXT = C4TEXT,
*s_C5TEXT = C5TEXT,*s_C6TEXT = C6TEXT,*s_CC_ZOMBIE = CC_ZOMBIE,
*s_CC_SHOTGUN = CC_SHOTGUN,*s_CC_HEAVY = CC_HEAVY,*s_CC_IMP = CC_IMP,
*s_CC_DEMON = CC_DEMON,*s_CC_LOST = CC_LOST,*s_CC_CACO = CC_CACO,
*s_CC_HELL = CC_HELL,*s_CC_BARON = CC_BARON,*s_CC_ARACH = CC_ARACH,
*s_CC_PAIN = CC_PAIN,*s_CC_REVEN = CC_REVEN,*s_CC_MANCU = CC_MANCU,
*s_CC_ARCH = CC_ARCH,*s_CC_SPIDER = CC_SPIDER,*s_CC_CYBER = CC_CYBER,
*s_CC_HERO = CC_HERO,*bgflatE1 = "FLOOR4_8",*bgflatE2 = "SFLR6_1",
*bgflatE3 = "MFLR8_4",*bgflatE4 = "MFLR8_3",*bgflat06 = "SLIME16",
*bgflat11 = "RROCK14",*bgflat20 = "RROCK07",*bgflat30 = "RROCK17",
*bgflat15 = "RROCK13",*bgflat31 = "RROCK19",*bgcastcall = "BOSSBACK";

typedef struct {char **ppstr; char *lookup; } deh_strs;

deh_strs deh_strlookup[] = {
 {&s_LOADNET,"LOADNET"},
 {&s_QLOADNET,"QLOADNET"},
 {&s_QSAVESPOT,"QSAVESPOT"},
 {&s_SAVEDEAD,"SAVEDEAD"},
 {&s_QSPROMPT,"QSPROMPT"},
 {&s_QLPROMPT,"QLPROMPT"},
 {&s_NEWGAME,"NEWGAME"},
 {&s_NIGHTMARE,"NIGHTMARE"},
 {&s_SWSTRING,"SWSTRING"},
 {&s_MSGOFF,"MSGOFF"},
 {&s_MSGON,"MSGON"},
 {&s_NETEND,"NETEND"},
 {&s_ENDGAME,"ENDGAME"},
 {&s_DOSY,"DOSY"},
 {&s_GAMMALVL0,"GAMMALVL0"},
 {&s_GAMMALVL1,"GAMMALVL1"},
 {&s_GAMMALVL2,"GAMMALVL2"},
 {&s_GAMMALVL3,"GAMMALVL3"},
 {&s_GAMMALVL4,"GAMMALVL4"},
 {&s_EMPTYSTRING,"EMPTYSTRING"},
 {&s_GOTARMOR,"GOTARMOR"},
 {&s_GOTMEGA,"GOTMEGA"},
 {&s_GOTHTHBONUS,"GOTHTHBONUS"},
 {&s_GOTARMBONUS,"GOTARMBONUS"},
 {&s_GOTSTIM,"GOTSTIM"},
 {&s_GOTMEDIKIT,"GOTMEDIKIT"},
 {&s_GOTSUPER,"GOTSUPER"},
 {&s_GOTBLUECARD,"GOTBLUECARD"},
 {&s_GOTYELWCARD,"GOTYELWCARD"},
 {&s_GOTREDCARD,"GOTREDCARD"},
 {&s_GOTBLUESKUL,"GOTBLUESKUL"},
 {&s_GOTYELWSKUL,"GOTYELWSKUL"},
 {&s_GOTREDSKULL,"GOTREDSKULL"},
 {&s_GOTINVUL,"GOTINVUL"},
 {&s_GOTBERSERK,"GOTBERSERK"},
 {&s_GOTINVIS,"GOTINVIS"},
 {&s_GOTSUIT,"GOTSUIT"},
 {&s_GOTMAP,"GOTMAP"},
 {&s_GOTVISOR,"GOTVISOR"},
 {&s_GOTMSPHERE,"GOTMSPHERE"},
 {&s_GOTCLIP,"GOTCLIP"},
 {&s_GOTCLIPBOX,"GOTCLIPBOX"},
 {&s_GOTROCKET,"GOTROCKET"},
 {&s_GOTROCKBOX,"GOTROCKBOX"},
 {&s_GOTCELL,"GOTCELL"},
 {&s_GOTCELLBOX,"GOTCELLBOX"},
 {&s_GOTSHELLS,"GOTSHELLS"},
 {&s_GOTSHELLBOX,"GOTSHELLBOX"},
 {&s_GOTBACKPACK,"GOTBACKPACK"},
 {&s_GOTBFG9000,"GOTBFG9000"},
 {&s_GOTCHAINGUN,"GOTCHAINGUN"},
 {&s_GOTCHAINSAW,"GOTCHAINSAW"},
 {&s_GOTLAUNCHER,"GOTLAUNCHER"},
 {&s_GOTPLASMA,"GOTPLASMA"},
 {&s_GOTSHOTGUN,"GOTSHOTGUN"},
 {&s_GOTSHOTGUN2,"GOTSHOTGUN2"},
 {&s_PD_BLUEO,"PD_BLUEO"},
 {&s_PD_REDO,"PD_REDO"},
 {&s_PD_YELLOWO,"PD_YELLOWO"},
 {&s_PD_BLUEK,"PD_BLUEK"},
 {&s_PD_REDK,"PD_REDK"},
 {&s_PD_YELLOWK,"PD_YELLOWK"},
 {&s_GGSAVED,"GGSAVED"},
 {&s_HUSTR_MSGU,"HUSTR_MSGU"},
 {&s_HUSTR_E1M1,"HUSTR_E1M1"},
 {&s_HUSTR_E1M2,"HUSTR_E1M2"},
 {&s_HUSTR_E1M3,"HUSTR_E1M3"},
 {&s_HUSTR_E1M4,"HUSTR_E1M4"},
 {&s_HUSTR_E1M5,"HUSTR_E1M5"},
 {&s_HUSTR_E1M6,"HUSTR_E1M6"},
 {&s_HUSTR_E1M7,"HUSTR_E1M7"},
 {&s_HUSTR_E1M8,"HUSTR_E1M8"},
 {&s_HUSTR_E1M9,"HUSTR_E1M9"},
 {&s_HUSTR_E2M1,"HUSTR_E2M1"},
 {&s_HUSTR_E2M2,"HUSTR_E2M2"},
 {&s_HUSTR_E2M3,"HUSTR_E2M3"},
 {&s_HUSTR_E2M4,"HUSTR_E2M4"},
 {&s_HUSTR_E2M5,"HUSTR_E2M5"},
 {&s_HUSTR_E2M6,"HUSTR_E2M6"},
 {&s_HUSTR_E2M7,"HUSTR_E2M7"},
 {&s_HUSTR_E2M8,"HUSTR_E2M8"},
 {&s_HUSTR_E2M9,"HUSTR_E2M9"},
 {&s_HUSTR_E3M1,"HUSTR_E3M1"},
 {&s_HUSTR_E3M2,"HUSTR_E3M2"},
 {&s_HUSTR_E3M3,"HUSTR_E3M3"},
 {&s_HUSTR_E3M4,"HUSTR_E3M4"},
 {&s_HUSTR_E3M5,"HUSTR_E3M5"},
 {&s_HUSTR_E3M6,"HUSTR_E3M6"},
 {&s_HUSTR_E3M7,"HUSTR_E3M7"},
 {&s_HUSTR_E3M8,"HUSTR_E3M8"},
 {&s_HUSTR_E3M9,"HUSTR_E3M9"},
 {&s_HUSTR_1,"HUSTR_1"},
 {&s_HUSTR_2,"HUSTR_2"},
 {&s_HUSTR_3,"HUSTR_3"},
 {&s_HUSTR_4,"HUSTR_4"},
 {&s_HUSTR_5,"HUSTR_5"},
 {&s_HUSTR_6,"HUSTR_6"},
 {&s_HUSTR_7,"HUSTR_7"},
 {&s_HUSTR_8,"HUSTR_8"},
 {&s_HUSTR_9,"HUSTR_9"},
 {&s_HUSTR_10,"HUSTR_10"},
 {&s_HUSTR_11,"HUSTR_11"},
 {&s_HUSTR_12,"HUSTR_12"},
 {&s_HUSTR_13,"HUSTR_13"},
 {&s_HUSTR_14,"HUSTR_14"},
 {&s_HUSTR_15,"HUSTR_15"},
 {&s_HUSTR_16,"HUSTR_16"},
 {&s_HUSTR_17,"HUSTR_17"},
 {&s_HUSTR_18,"HUSTR_18"},
 {&s_HUSTR_19,"HUSTR_19"},
 {&s_HUSTR_20,"HUSTR_20"},
 {&s_HUSTR_21,"HUSTR_21"},
 {&s_HUSTR_22,"HUSTR_22"},
 {&s_HUSTR_23,"HUSTR_23"},
 {&s_HUSTR_24,"HUSTR_24"},
 {&s_HUSTR_25,"HUSTR_25"},
 {&s_HUSTR_26,"HUSTR_26"},
 {&s_HUSTR_27,"HUSTR_27"},
 {&s_HUSTR_28,"HUSTR_28"},
 {&s_HUSTR_29,"HUSTR_29"},
 {&s_HUSTR_30,"HUSTR_30"},
 {&s_HUSTR_31,"HUSTR_31"},
 {&s_HUSTR_32,"HUSTR_32"},
 {&s_HUSTR_PLRGREEN,"HUSTR_PLRGREEN"},
 {&s_HUSTR_PLRINDIGO,"HUSTR_PLRINDIGO"},
 {&s_HUSTR_PLRBROWN,"HUSTR_PLRBROWN"},
 {&s_HUSTR_PLRRED,"HUSTR_PLRRED"},
 {&s_AMSTR_FOLLOWON,"AMSTR_FOLLOWON"},
 {&s_AMSTR_FOLLOWOFF,"AMSTR_FOLLOWOFF"},
 {&s_AMSTR_GRIDON,"AMSTR_GRIDON"},
 {&s_AMSTR_GRIDOFF,"AMSTR_GRIDOFF"},
 {&s_AMSTR_MARKEDSPOT,"AMSTR_MARKEDSPOT"},
 {&s_AMSTR_MARKSCLEARED,"AMSTR_MARKSCLEARED"},
 {&s_STSTR_MUS,"STSTR_MUS"},
 {&s_STSTR_NOMUS,"STSTR_NOMUS"},
 {&s_STSTR_DQDON,"STSTR_DQDON"},
 {&s_STSTR_DQDOFF,"STSTR_DQDOFF"},
 {&s_STSTR_KFAADDED,"STSTR_KFAADDED"},
 {&s_STSTR_FAADDED,"STSTR_FAADDED"},
 {&s_STSTR_NCON,"STSTR_NCON"},
 {&s_STSTR_NCOFF,"STSTR_NCOFF"},
 {&s_STSTR_BEHOLD,"STSTR_BEHOLD"},
 {&s_STSTR_BEHOLDX,"STSTR_BEHOLDX"},
 {&s_STSTR_CHOPPERS,"STSTR_CHOPPERS"},
 {&s_E1TEXT,"E1TEXT"},
 {&s_E2TEXT,"E2TEXT"},
 {&s_E3TEXT,"E3TEXT"},
 {&s_C1TEXT,"C1TEXT"},
 {&s_C2TEXT,"C2TEXT"},
 {&s_C3TEXT,"C3TEXT"},
 {&s_C4TEXT,"C4TEXT"},
 {&s_C5TEXT,"C5TEXT"},
 {&s_C6TEXT,"C6TEXT"},
 {&s_CC_ZOMBIE,"CC_ZOMBIE"},
 {&s_CC_SHOTGUN,"CC_SHOTGUN"},
 {&s_CC_HEAVY,"CC_HEAVY"},
 {&s_CC_IMP,"CC_IMP"},
 {&s_CC_DEMON,"CC_DEMON"},
 {&s_CC_LOST,"CC_LOST"},
 {&s_CC_CACO,"CC_CACO"},
 {&s_CC_HELL,"CC_HELL"},
 {&s_CC_BARON,"CC_BARON"},
 {&s_CC_ARACH,"CC_ARACH"},
 {&s_CC_PAIN,"CC_PAIN"},
 {&s_CC_REVEN,"CC_REVEN"},
 {&s_CC_MANCU,"CC_MANCU"},
 {&s_CC_ARCH,"CC_ARCH"},
 {&s_CC_SPIDER,"CC_SPIDER"},
 {&s_CC_CYBER,"CC_CYBER"},
 {&s_CC_HERO,"CC_HERO"},
 {&bgflatE1,"BGFLATE1"},
 {&bgflatE2,"BGFLATE2"},
 {&bgflatE3,"BGFLATE3"},
 {&bgflatE4,"BGFLATE4"},
 {&bgflat06,"BGFLAT06"},
 {&bgflat11,"BGFLAT11"},
 {&bgflat20,"BGFLAT20"},
 {&bgflat30,"BGFLAT30"},
 {&bgflat15,"BGFLAT15"},
 {&bgflat31,"BGFLAT31"},
 {&bgcastcall,"BGCASTCALL"},
};

static int deh_numstrlookup =
sizeof(deh_strlookup)/sizeof(deh_strlookup[0]);

char **mapnames[] =
{
 &s_HUSTR_E1M1,
 &s_HUSTR_E1M2,
 &s_HUSTR_E1M3,
 &s_HUSTR_E1M4,
 &s_HUSTR_E1M5,
 &s_HUSTR_E1M6,
 &s_HUSTR_E1M7,
 &s_HUSTR_E1M8,
 &s_HUSTR_E1M9,

 &s_HUSTR_E2M1,
 &s_HUSTR_E2M2,
 &s_HUSTR_E2M3,
 &s_HUSTR_E2M4,
 &s_HUSTR_E2M5,
 &s_HUSTR_E2M6,
 &s_HUSTR_E2M7,
 &s_HUSTR_E2M8,
 &s_HUSTR_E2M9,

 &s_HUSTR_E3M1,
 &s_HUSTR_E3M2,
 &s_HUSTR_E3M3,
 &s_HUSTR_E3M4,
 &s_HUSTR_E3M5,
 &s_HUSTR_E3M6,
 &s_HUSTR_E3M7,
 &s_HUSTR_E3M8,
 &s_HUSTR_E3M9
};

char **mapnames2[] =
{
 &s_HUSTR_1,
 &s_HUSTR_2,
 &s_HUSTR_3,
 &s_HUSTR_4,
 &s_HUSTR_5,
 &s_HUSTR_6,
 &s_HUSTR_7,
 &s_HUSTR_8,
 &s_HUSTR_9,
 &s_HUSTR_10,
 &s_HUSTR_11,

 &s_HUSTR_12,
 &s_HUSTR_13,
 &s_HUSTR_14,
 &s_HUSTR_15,
 &s_HUSTR_16,
 &s_HUSTR_17,
 &s_HUSTR_18,
 &s_HUSTR_19,
 &s_HUSTR_20,

 &s_HUSTR_21,
 &s_HUSTR_22,
 &s_HUSTR_23,
 &s_HUSTR_24,
 &s_HUSTR_25,
 &s_HUSTR_26,
 &s_HUSTR_27,
 &s_HUSTR_28,
 &s_HUSTR_29,
 &s_HUSTR_30,
 &s_HUSTR_31,
 &s_HUSTR_32,
};

void lfstrip(char *);
void rstrip(char *);
char * ptr_lstrip(char *);
boolean deh_GetData(char *, char *, long *, char **);
void deh_procStringSub(char *, char *, char *);

typedef struct
{
 char *key;
 void (*const fptr)(DEHFILE *, char *);
} deh_block;

#define DEH_BUFFERMAX 1024
#define DEH_BLOCKMAX (sizeof deh_blocks/sizeof*deh_blocks)
#define DEH_MAXKEYLEN 32
#define DEH_MOBJINFOMAX 23

static boolean includenotext = 0;

char *deh_mobjinfo[DEH_MOBJINFOMAX] =
{
 "ID #",
 "Initial frame",
 "Hit points",
 "First moving frame",
 "Alert sound",
 "Reaction time",
 "Attack sound",
 "Injury frame",
 "Pain chance",
 "Pain sound",
 "Close attack frame",
 "Far attack frame",
 "Death frame",
 "Exploding frame",
 "Death sound",
 "Speed",
 "Width",
 "Height",
 "Mass",
 "Missile damage",
 "Action sound",
 "Bits",
 "Respawn frame"
};

#define DEH_MOBJFLAGMAX (sizeof deh_mobjflags/sizeof*deh_mobjflags)

struct { 
 char *name;
 long value;
} deh_mobjflags[] = {
 {"SPECIAL", 0x00000001},
 {"SOLID", 0x00000002},
 {"SHOOTABLE", 0x00000004},
 {"NOSECTOR", 0x00000008},
 {"NOBLOCKMAP", 0x00000010},
 {"AMBUSH", 0x00000020},
 {"JUSTHIT", 0x00000040},
 {"JUSTATTACKED", 0x00000080},
 {"SPAWNCEILING", 0x00000100},
 {"NOGRAVITY", 0x00000200},
 {"DROPOFF", 0x00000400},
 {"PICKUP", 0x00000800},
 {"NOCLIP", 0x00001000},
 {"SLIDE", 0x00002000},
 {"FLOAT", 0x00004000},
 {"TELEPORT", 0x00008000},
 {"MISSILE", 0x00010000},
 {"DROPPED", 0x00020000},
 {"SHADOW", 0x00040000},
 {"NOBLOOD", 0x00080000},
 {"CORPSE", 0x00100000},
 {"INFLOAT", 0x00200000},
 {"COUNTKILL", 0x00400000},
 {"COUNTITEM", 0x00800000},
 {"SKULLFLY", 0x01000000},
 {"NOTDMATCH", 0x02000000},
 {"TRANSLATION1", 0x04000000},
 {"TRANSLATION2", 0x08000000},
 {"TOUCHY", 0x10000000},
 {"BOUNCES", 0x20000000},
 {"FRIEND", 0x40000000},
 {"TRANSLUCENT", 0x80000000},
};

char *deh_state[] =
{
 "Sprite number",
 "Sprite subnumber",
 "Duration",
 "Next frame",
 "Codep frame",
 "Unknown 1",
 "Unknown 2"
};

char *deh_sfxinfo[] =
{
 "Zero/One",
 "Value",
 "Zero 4"
};

char *deh_ammo[] =
{
 "Max ammo",
 "Per ammo"
};

char *deh_weapon[] =
{
 "Ammo type",
 "Deselect frame",
 "Select frame",
 "Bobbing frame",
 "Shooting frame",
 "Firing frame"
};

char *deh_misc[] =
{
 "Initial Health",
 "Initial Bullets",
 "Max Health",
 "Max Armor",
 "Green Armor Class",
 "Blue Armor Class",
 "Max Soulsphere",
 "Soulsphere Health",
 "Megasphere Health",
 "God Mode Health",
 "IDFA Armor",
 "IDFA Armor Class",
 "IDKFA Armor",
 "IDKFA Armor Class",
 "BFG Cells/Shot",
 "Monsters Infight"
};

void A_Light0(),A_WeaponReady(),A_Lower(),A_Raise(),A_Punch(),A_ReFire(),
A_FirePistol(),A_Light1(),A_FireShotgun(),A_Light2(),A_FireShotgun2(),
A_CheckReload(),A_OpenShotgun2(),A_LoadShotgun2(),A_CloseShotgun2(),
A_FireCGun(),A_GunFlash(),A_FireMissile(),A_Saw(),A_FirePlasma(),
A_BFGsound(),A_FireBFG(),A_BFGSpray(),A_Explode(),A_Pain(),A_PlayerScream(),
A_Fall(),A_XScream(),A_Look(),A_Chase(),A_FaceTarget(),A_PosAttack(),
A_Scream(),A_SPosAttack(),A_VileChase(),A_VileStart(),A_VileTarget(),
A_VileAttack(),A_StartFire(),A_Fire(),A_FireCrackle(),A_Tracer(),
A_SkelWhoosh(),A_SkelFist(),A_SkelMissile(),A_FatRaise(),A_FatAttack1(),
A_FatAttack2(),A_FatAttack3(),A_BossDeath(),A_CPosAttack(),A_CPosRefire(),
A_TroopAttack(),A_SargAttack(),A_HeadAttack(),A_BruisAttack(),
A_SkullAttack(),A_Metal(),A_SpidRefire(),A_BabyMetal(),A_BspiAttack(),
A_Hoof(),A_CyberAttack(),A_PainAttack(),A_PainDie(),A_KeenDie(),
A_BrainPain(),A_BrainScream(),A_BrainDie(),A_BrainAwake(),A_BrainSpit(),
A_SpawnSound(),A_SpawnFly(),A_BrainExplode(),A_Die(),A_LineEffect();

typedef struct {
 actionf_t cptr;
 char *lookup;
} deh_bexptr;

deh_bexptr deh_bexptrs[] =
{
 {A_Light0, "A_Light0"},
 {A_WeaponReady, "A_WeaponReady"},
 {A_Lower, "A_Lower"},
 {A_Raise, "A_Raise"},
 {A_Punch, "A_Punch"},
 {A_ReFire, "A_ReFire"},
 {A_FirePistol, "A_FirePistol"},
 {A_Light1, "A_Light1"},
 {A_FireShotgun, "A_FireShotgun"},
 {A_Light2, "A_Light2"},
 {A_FireShotgun2, "A_FireShotgun2"},
 {A_CheckReload, "A_CheckReload"},
 {A_OpenShotgun2, "A_OpenShotgun2"},
 {A_LoadShotgun2, "A_LoadShotgun2"},
 {A_CloseShotgun2, "A_CloseShotgun2"},
 {A_FireCGun, "A_FireCGun"},
 {A_GunFlash, "A_GunFlash"},
 {A_FireMissile, "A_FireMissile"},
 {A_Saw, "A_Saw"},
 {A_FirePlasma, "A_FirePlasma"},
 {A_BFGsound, "A_BFGsound"},
 {A_FireBFG, "A_FireBFG"},
 {A_BFGSpray, "A_BFGSpray"},
 {A_Explode, "A_Explode"},
 {A_Pain, "A_Pain"},
 {A_PlayerScream, "A_PlayerScream"},
 {A_Fall, "A_Fall"},
 {A_XScream, "A_XScream"},
 {A_Look, "A_Look"},
 {A_Chase, "A_Chase"},
 {A_FaceTarget, "A_FaceTarget"},
 {A_PosAttack, "A_PosAttack"},
 {A_Scream, "A_Scream"},
 {A_SPosAttack, "A_SPosAttack"},
 {A_VileChase, "A_VileChase"},
 {A_VileStart, "A_VileStart"},
 {A_VileTarget, "A_VileTarget"},
 {A_VileAttack, "A_VileAttack"},
 {A_StartFire, "A_StartFire"},
 {A_Fire, "A_Fire"},
 {A_FireCrackle, "A_FireCrackle"},
 {A_Tracer, "A_Tracer"},
 {A_SkelWhoosh, "A_SkelWhoosh"},
 {A_SkelFist, "A_SkelFist"},
 {A_SkelMissile, "A_SkelMissile"},
 {A_FatRaise, "A_FatRaise"},
 {A_FatAttack1, "A_FatAttack1"},
 {A_FatAttack2, "A_FatAttack2"},
 {A_FatAttack3, "A_FatAttack3"},
 {A_BossDeath, "A_BossDeath"},
 {A_CPosAttack, "A_CPosAttack"},
 {A_CPosRefire, "A_CPosRefire"},
 {A_TroopAttack, "A_TroopAttack"},
 {A_SargAttack, "A_SargAttack"},
 {A_HeadAttack, "A_HeadAttack"},
 {A_BruisAttack, "A_BruisAttack"},
 {A_SkullAttack, "A_SkullAttack"},
 {A_Metal, "A_Metal"},
 {A_SpidRefire, "A_SpidRefire"},
 {A_BabyMetal, "A_BabyMetal"},
 {A_BspiAttack, "A_BspiAttack"},
 {A_Hoof, "A_Hoof"},
 {A_CyberAttack, "A_CyberAttack"},
 {A_PainAttack, "A_PainAttack"},
 {A_PainDie, "A_PainDie"},
 {A_KeenDie, "A_KeenDie"},
 {A_BrainPain, "A_BrainPain"},
 {A_BrainScream, "A_BrainScream"},
 {A_BrainDie, "A_BrainDie"},
 {A_BrainAwake, "A_BrainAwake"},
 {A_BrainSpit, "A_BrainSpit"},
 {A_SpawnSound, "A_SpawnSound"},
 {A_SpawnFly, "A_SpawnFly"},
 {A_BrainExplode, "A_BrainExplode"},
 {A_Die, "A_Die"},
 {A_LineEffect, "A_LineEffect"},

 {NULL, "A_NULL"},
};

actionf_t deh_codeptr[NUMSTATES];

void deh_procBexCodePointers(DEHFILE *fpin, char *line)
{
 char key[DEH_MAXKEYLEN];
 char inbuffer[DEH_BUFFERMAX];
 int indexnum;
 char mnemonic[DEH_MAXKEYLEN];
 int i;
 boolean found;

 strncpy(inbuffer,line,DEH_BUFFERMAX);

 while (!feof(fpin) && *inbuffer && (*inbuffer != ' '))
 {
 if (!fgets(inbuffer, sizeof(inbuffer), fpin)) break;
 lfstrip(inbuffer);
 if (!*inbuffer) break;

 if ( (3 != sscanf(inbuffer,"%s %i = %s", key, &indexnum, mnemonic))
 || (stricmp(key,"FRAME")) )
 return;
 if (indexnum < 0 || indexnum >= NUMSTATES) return;
 strcpy(key,"A_");
 strcat(key,ptr_lstrip(mnemonic));

 found = 0;
 i= -1;
 do
 {
 ++i;
 if (!stricmp(key,deh_bexptrs[i].lookup))
 {
 states[indexnum].action = deh_bexptrs[i].cptr;
 found = 1;
 }
 } while (!found && (deh_bexptrs[i].lookup != NULL));
 }
 return;
}

void deh_procThing(DEHFILE *fpin, char *line)
{
 char key[DEH_MAXKEYLEN];
 char inbuffer[DEH_BUFFERMAX];
 long value;
 int indexnum;
 int ix;
 int *pix;
 char *strval;

 strncpy(inbuffer,line,DEH_BUFFERMAX);

 ix = sscanf(inbuffer,"%s %i",key, &indexnum);

 --indexnum;

 while (!feof(fpin) && *inbuffer && (*inbuffer != ' '))
 {
 if (!fgets(inbuffer, sizeof(inbuffer), fpin)) break;
 lfstrip(inbuffer);

 if (!*inbuffer) break;
 if (!deh_GetData(inbuffer,key,&value,&strval))
 continue;
 for (ix=0; ix < DEH_MOBJINFOMAX; ix++)
 {
 if (!strcasecmp(key,deh_mobjinfo[ix]))
 {
 if (!strcasecmp(key,"bits") && !value)
 {
 value = 0;

 for (;(strval = strtok(strval,",+| \t\f\r")); strval = NULL)
 {
 int iy;
 for (iy=0; iy < DEH_MOBJFLAGMAX; iy++)
 if (!strcasecmp(strval,deh_mobjflags[iy].name))
 {
 value |= deh_mobjflags[iy].value;
 break;
 }
 }
 }
 pix = (int *)&mobjinfo[indexnum];
 pix[ix] = (int)value;
 }
 }
 }
 return;
}

void deh_procFrame(DEHFILE *fpin, char *line)
{
 char key[DEH_MAXKEYLEN];
 char inbuffer[DEH_BUFFERMAX];
 long value;
 int indexnum;

 strncpy(inbuffer,line,DEH_BUFFERMAX);

 sscanf(inbuffer,"%s %i",key, &indexnum);

 while (!feof(fpin) && *inbuffer && (*inbuffer != ' '))
 {
 if (!fgets(inbuffer, sizeof(inbuffer), fpin)) break;
 lfstrip(inbuffer);
 if (!*inbuffer) break;
 if (!deh_GetData(inbuffer,key,&value,NULL))
 continue;

 if (!strcasecmp(key,deh_state[0]))
 states[indexnum].sprite = (spritenum_t)value;
 else
 if (!strcasecmp(key,deh_state[1]))
 states[indexnum].frame = value;
 else
 if (!strcasecmp(key,deh_state[2]))
 states[indexnum].tics = value;
 else
 if (!strcasecmp(key,deh_state[3]))
 states[indexnum].nextstate = (statenum_t)value;
 else
 if (!strcasecmp(key,deh_state[5]))
 states[indexnum].misc1 = value;
 else
 if (!strcasecmp(key,deh_state[6]))
 states[indexnum].misc2 = value;
 }
 return;
}

void deh_procPointer(DEHFILE *fpin, char *line)
{
 char key[DEH_MAXKEYLEN];
 char inbuffer[DEH_BUFFERMAX];
 long value;
 int indexnum;
 int i;

 strncpy(inbuffer,line,DEH_BUFFERMAX);
 if (sscanf(inbuffer,"%*s %*i (%s %i)",key, &indexnum) != 2)
 return;

 if (indexnum < 0 || indexnum >= NUMSTATES) return;

 while (!feof(fpin) && *inbuffer && (*inbuffer != ' '))
 {
 if (!fgets(inbuffer, sizeof(inbuffer), fpin)) break;
 lfstrip(inbuffer);
 if (!*inbuffer) break;
 if (!deh_GetData(inbuffer,key,&value,NULL))
 continue;

 if (value < 0 || value >= NUMSTATES)
 return;

 if (!strcasecmp(key,deh_state[4]))
 {
 states[indexnum].action = deh_codeptr[value];
 for (i=0;i<NUMSTATES;i++)
 {
 if (deh_bexptrs[i].cptr == deh_codeptr[value])
 break;
 }
 }
 }
 return;
}

void deh_procSounds(DEHFILE *fpin, char *line)
{
 char key[DEH_MAXKEYLEN];
 char inbuffer[DEH_BUFFERMAX];
 long value;
 int indexnum;
 strncpy(inbuffer,line,DEH_BUFFERMAX);
 sscanf(inbuffer,"%s %i",key, &indexnum);
 while (!feof(fpin) && *inbuffer && (*inbuffer != ' '))
 {
 if (!fgets(inbuffer, sizeof(inbuffer), fpin)) break;
 lfstrip(inbuffer);
 if (!*inbuffer) break;
 if (!deh_GetData(inbuffer,key,&value,NULL)) continue;
 if (!strcasecmp(key,deh_sfxinfo[0])) S_sfx[indexnum].singularity = value;
 else
 if (!strcasecmp(key,deh_sfxinfo[1])) S_sfx[indexnum].priority = value;
 else
 if (!strcasecmp(key,deh_sfxinfo[2])) S_sfx[indexnum].data = (void*)value;
 }
 return;
}

void deh_procAmmo(DEHFILE *fpin, char *line)
{
 char key[DEH_MAXKEYLEN];
 char inbuffer[DEH_BUFFERMAX];
 long value;
 int indexnum;
 strncpy(inbuffer,line,DEH_BUFFERMAX);
 sscanf(inbuffer,"%s %i",key, &indexnum);
 while (!feof(fpin) && *inbuffer && (*inbuffer != ' '))
 {
 if (!fgets(inbuffer, sizeof(inbuffer), fpin)) break;
 lfstrip(inbuffer);
 if (!*inbuffer) break;
 if (!deh_GetData(inbuffer,key,&value,NULL)) continue;
 if (!strcasecmp(key,deh_ammo[0])) maxammo[indexnum] = value;
 else
 if (!strcasecmp(key,deh_ammo[1])) clipammo[indexnum] = value;
 }
 return;
}

void deh_procWeapon(DEHFILE *fpin, char *line)
{
 char key[DEH_MAXKEYLEN];
 char inbuffer[DEH_BUFFERMAX];
 long value;
 int indexnum;
 strncpy(inbuffer,line,DEH_BUFFERMAX);
 sscanf(inbuffer,"%s %i",key, &indexnum);
 while (!feof(fpin) && *inbuffer && (*inbuffer != ' '))
 {
 if (!fgets(inbuffer, sizeof(inbuffer), fpin)) break;
 lfstrip(inbuffer); if (!*inbuffer) break;
 if (!deh_GetData(inbuffer,key,&value,NULL)) continue;
 if (!strcasecmp(key,deh_weapon[0])) weaponinfo[indexnum].ammo = value;
 else
 if (!strcasecmp(key,deh_weapon[1])) weaponinfo[indexnum].upstate = value;
 else
 if (!strcasecmp(key,deh_weapon[2])) weaponinfo[indexnum].downstate = value;
 else
 if (!strcasecmp(key,deh_weapon[3])) weaponinfo[indexnum].readystate = value;
 else
 if (!strcasecmp(key,deh_weapon[4])) weaponinfo[indexnum].atkstate = value;
 else
 if (!strcasecmp(key,deh_weapon[5])) weaponinfo[indexnum].flashstate = value;
 }
 return;
}

void deh_procCheat(DEHFILE *fpin, char *line)
{
 char key[DEH_MAXKEYLEN];
 char inbuffer[DEH_BUFFERMAX];
 long value;
 char *strval = "";
 int ix, iy;
 char *p;

 strncpy(inbuffer,line,DEH_BUFFERMAX);
 while (!feof(fpin) && *inbuffer && (*inbuffer != ' '))
 {
 if (!fgets(inbuffer, sizeof(inbuffer), fpin)) break;
 lfstrip(inbuffer);
 if (!*inbuffer) break;
 if (!deh_GetData(inbuffer,key,&value,&strval)) continue;
 for (ix=0; cheat[ix].cheat; ix++)
 if (cheat[ix].deh_cheat)
 {
 if (!stricmp(key,cheat[ix].deh_cheat))
 {
 for (iy=0; strval[iy]; iy++)
 strval[iy] = (strval[iy]==(char)0xff) ? '\0' : strval[iy];
 iy = ix;
 p = strval;
 while (*p == ' ') ++p;
 cheat[iy].cheat = strdup(p);
 }
 }
 }
 return;
}

void deh_procMisc(DEHFILE *fpin, char *line)
{
 char key[DEH_MAXKEYLEN];
 char inbuffer[DEH_BUFFERMAX];
 long value;

 strncpy(inbuffer,line,DEH_BUFFERMAX);
 while (!feof(fpin) && *inbuffer && (*inbuffer != ' '))
 {
 if (!fgets(inbuffer, sizeof(inbuffer), fpin)) break;
 lfstrip(inbuffer);
 if (!*inbuffer) break;
 if (!deh_GetData(inbuffer,key,&value,NULL))
 continue;
 if (!strcasecmp(key,deh_misc[0])) initial_health = value; else
 if (!strcasecmp(key,deh_misc[1])) initial_bullets = value; else
 if (!strcasecmp(key,deh_misc[2])) maxhealth = value; else
 if (!strcasecmp(key,deh_misc[3])) max_armor = value; else
 if (!strcasecmp(key,deh_misc[4])) green_armor_class = value; else
 if (!strcasecmp(key,deh_misc[5])) blue_armor_class = value; else
 if (!strcasecmp(key,deh_misc[6])) max_soul = value; else
 if (!strcasecmp(key,deh_misc[7])) soul_health = value; else
 if (!strcasecmp(key,deh_misc[8])) mega_health = value; else
 if (!strcasecmp(key,deh_misc[9])) god_health = value; else
 if (!strcasecmp(key,deh_misc[10])) idfa_armor = value; else
 if (!strcasecmp(key,deh_misc[11])) idfa_armor_class = value; else
 if (!strcasecmp(key,deh_misc[12])) idkfa_armor = value; else
 if (!strcasecmp(key,deh_misc[13])) idkfa_armor_class = value; else
 if (!strcasecmp(key,deh_misc[14])) bfgcells = value; else
 if (!strcasecmp(key,deh_misc[15])) same_specie_infight=1;
 }
 return;
}

void deh_procText(DEHFILE *fpin, char *line)
{
 char key[DEH_MAXKEYLEN];
 char inbuffer[DEH_BUFFERMAX*2];
 int i;
 int fromlen, tolen;
 int usedlen;
 boolean found = 0;
 char* line2 = NULL;
 if (includenotext)
 { while (!feof(fpin) && *inbuffer && (*inbuffer != ' '))
 fgets(inbuffer, sizeof(inbuffer), fpin);
 return; }
 sscanf(line,"%s %i %i",key,&fromlen,&tolen);
 { int c, totlen = 0;
 while (totlen < fromlen + tolen && (c = fgetc(fpin)) != EOF)
 inbuffer[totlen++] = c;
 inbuffer[totlen]='\0'; }
 if (fromlen==4 && tolen==4) { i=0;
 while (sprnames[i])
 { if (!strnicmp(sprnames[i],inbuffer,fromlen))
 { sprnames[i]=strdup(sprnames[i]);
 strncpy(sprnames[i],&inbuffer[fromlen],tolen);
 found = 1; break; } ++i; } }
 else
 if (fromlen < 7 && tolen < 7)
 { usedlen = (fromlen < tolen) ? fromlen : tolen;
 for (i=1; i<NUMSFX; i++)
 { if (strlen(S_sfx[i].name) != fromlen) continue;
 if (!strnicmp(S_sfx[i].name,inbuffer,fromlen))
 { S_sfx[i].name = strdup(&inbuffer[fromlen]);
 found = 1;
 break; } }
 if (!found)
 { for (i=1; i<NUMMUSIC; i++)
 { if (strlen(S_music[i].name) != fromlen) continue;
 if (!strnicmp(S_music[i].name,inbuffer,fromlen))
 { S_music[i].name = strdup(&inbuffer[fromlen]);
 found = 1; break; } } } }
 if (!found)
 { if (fromlen <= strlen(inbuffer))
 { line2 = strdup(&inbuffer[fromlen]);
 inbuffer[fromlen] = '\0'; }
 deh_procStringSub(NULL, inbuffer, line2); }
 free(line2);
 return;
}

void deh_procStrings(DEHFILE *fpin, char *line)
{
 char key[DEH_MAXKEYLEN];
 char inbuffer[DEH_BUFFERMAX];
 long value;
 char *strval;
 static int maxstrlen = 128;
 static char *holdstring = NULL;
 if (!holdstring) holdstring = malloc(maxstrlen*sizeof(*holdstring));
 *holdstring = '\0';
 strncpy(inbuffer,line,DEH_BUFFERMAX);
 while (!feof(fpin) && *inbuffer)
 {
 if (!fgets(inbuffer, sizeof(inbuffer), fpin)) break;
 if (*inbuffer == '#') continue; lfstrip(inbuffer);
 if (!*inbuffer) break;
 if (!*holdstring) if (!deh_GetData(inbuffer,key,&value,&strval)) continue;
 while (strlen(holdstring) + strlen(inbuffer) > maxstrlen)
 {
 maxstrlen += strlen(holdstring) + strlen(inbuffer) - maxstrlen;
 holdstring = realloc(holdstring,maxstrlen*sizeof(*holdstring));
 }
 strcat(holdstring,ptr_lstrip(((*holdstring) ? inbuffer : strval)));
 rstrip(holdstring);
 if (holdstring[strlen(holdstring)-1] == '\\')
 { holdstring[strlen(holdstring)-1] = '\0';
 continue; }
 if (*holdstring)
 { deh_procStringSub(key, NULL, holdstring);
 *holdstring = '\0'; }
 }
 return;
}

void deh_procStringSub(char *key, char *lookfor, char *newstring)
{
 boolean found=0;
 int i;
 for (i=0;i<deh_numstrlookup;i++)
 {
 found = lookfor ?
 !stricmp(*deh_strlookup[i].ppstr,lookfor) :
 !stricmp(deh_strlookup[i].lookup,key);
 if (found)
 { *deh_strlookup[i].ppstr = strdup(newstring); found = 1;
 { char *s, *t;
 for (s=t=*deh_strlookup[i].ppstr; *s; ++s, ++t)
 { if (*s == '\\' && (s[1] == 'n' || s[1] == 'N')) ++s, *t = '\n';
 else *t = *s; }
 *t = '\0'; }
 break; }
 }
}

void lfstrip(char *s)
{
 char *p = s+strlen(s);
 while (p > s && (*--p=='\r' || *p=='\n')) *p = 0;
}

void rstrip(char *s)
{
 char *p = s+strlen(s);
 while (p > s && isspace(*--p)) *p='\0';
}
char *ptr_lstrip(char *p)
{
 while (isspace(*p)) p++;
 return p;
}

boolean deh_GetData(char *s, char *k, long *l, char **strval)
{
 char *t;
 long val;
 char buffer[DEH_MAXKEYLEN];
 boolean okrc = 1;
 int i;
 *buffer = '\0'; val = 0;
 for (i=0, t=s; *t && i < DEH_MAXKEYLEN; t++, i++)
 {  if (*t == '=') break; buffer[i] = *t; }
 buffer[--i] = '\0';
 if (!*t) okrc = 0; else
 { if (!*++t) val = okrc = 0; val = strtol(t,NULL,0); }
 *l = val;
 strcpy(k,ptr_lstrip(buffer));
 if (strval != NULL) *strval = t;
 return(okrc);
}

deh_block deh_blocks[] = {
 {"Thing",deh_procThing},
 {"Frame",deh_procFrame},
 {"Pointer",deh_procPointer},
 {"Sound",deh_procSounds},
 {"Ammo",deh_procAmmo},
 {"Weapon",deh_procWeapon},
 {"Cheat",deh_procCheat},
 {"Misc",deh_procMisc},
 {"Text",deh_procText},
 {"[STRINGS]",deh_procStrings},
 {"[CODEPTR]",deh_procBexCodePointers}
};

void ProcessDehFile(char *filename, int lumpnum)
{
 DEHFILE infile, *filein = &infile;
 char inbuffer[DEH_BUFFERMAX];
 if (filename)
 {
 if (!(infile.inp = (void *) fopen(filename,"rt")))
 {
 printf("-deh file %s not found\n",filename);
 return;
 }
 infile.lump = NULL;
 }
 else
 {
 infile.size = W_LumpLength(lumpnum);
 infile.inp = infile.lump = W_CacheLumpNum(lumpnum, PU_STATIC);
 filename = "(WAD)";
 }
 printf("Ajoutant DEH %s\n",filename);
 {
 static int i;
 for (; i<NUMSTATES; i++)
 deh_codeptr[i] = states[i].action;
 }
 while (fgets(inbuffer,sizeof(inbuffer),filein))
 {
 int i;
 lfstrip(inbuffer);
 if (!*inbuffer || *inbuffer == '#' || *inbuffer == ' ')
 continue;
 if (!strnicmp(inbuffer,"INCLUDE",7))
 {
 char *nextfile;
 boolean oldnotext = includenotext;
 if (infile.lump) continue;
 if (!strnicmp(nextfile = ptr_lstrip(inbuffer+7),"NOTEXT",6))
 includenotext = 1, nextfile = ptr_lstrip(nextfile+6);
 ProcessDehFile(nextfile,0);
 includenotext = oldnotext;
 continue;
 }
 for (i=0; i<DEH_BLOCKMAX; i++)
 if (!strncasecmp(inbuffer,deh_blocks[i].key,strlen(deh_blocks[i].key)))
 {
 deh_blocks[i].fptr(filein,inbuffer);
 break;
 }
 }
 if (infile.lump)
 Z_ChangeTag(infile.lump, PU_CACHE);
 else
 fclose((FILE *) infile.inp);
}