#ifndef __D_EVENT__
#define __D_EVENT__

#include "doomtype.h"

typedef enum
{
 ev_keydown,
 ev_keyup,
 ev_mouse,
 ev_joystick
} evtype_t;

typedef struct
{
 evtype_t type;
 int data1,data2,data3;
} event_t;
 
typedef enum
{
 ga_nothing,
 ga_loadlevel,
 ga_newgame,
 ga_loadgame,
 ga_savegame,
 ga_playdemo,
 ga_completed,
 ga_victory,
 ga_worlddone,
 ga_screenshot
} gameaction_t;

typedef enum
{
 BT_ATTACK       = 1,
 BT_USE          = 2,
 BT_SPECIAL      = 128,
 BT_CHANGE       = 4,
 BT_WEAPONMASK   = (8+16+32+64),
 BT_WEAPONSHIFT  = 3,
 BTS_PAUSE       = 1,
 BTS_SAVEGAME    = 2,   
 BTS_SAVEMASK    = (4+8+16),
 BTS_SAVESHIFT   = 2,
 BT2_JUMP = 1
} buttoncode_t;

#define MAXEVENTS               64

extern event_t   events[MAXEVENTS];
extern int       eventhead;
extern int       eventtail;
extern gameaction_t gameaction;

#endif