/*
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation. NO WARRANTY.
*/

#include "doomstat.h"
#include "d_event.h"
#include "v_video.h"
#include "w_wad.h"
#include "sounds.h"
#include "d_englsh.h"
#include "m_menu.h"
#include "d_deh.h"

int finalestage, finalecount;

#define TEXTSPEED    3
#define TEXTWAIT     250
#define NEWTEXTSPEED 0.01
#define NEWTEXTWAIT  1000

char* finaletext;
char* finaleflat;

void    F_StartCast (void);
void    F_CastTicker (void);
boolean F_CastResponder (event_t *ev);
void    F_CastDrawer (void);

void WI_checkForAccelerate(void);
extern int acceleratestage;
static int midstage;

void F_StartFinale (void)
{
  gameaction = ga_nothing;
  gamestate = GS_FINALE;
  viewactive = false;
  automapactive = false;
  acceleratestage = midstage = 0;
  switch ( gamemode )
  {
    case shareware:
    case registered:
    case retail:
    {
      S_ChangeMusic(mus_victor, true);
      
      switch (gameepisode)
      {
        case 1:
             finaleflat = bgflatE1;
             finaletext = s_E1TEXT;
             break;
        case 2:
             finaleflat = bgflatE2;
             finaletext = s_E2TEXT; 
             break;
        case 3:
             finaleflat = bgflatE3;
             finaletext = s_E3TEXT;
             break;
        case 4:
             finaleflat = bgflatE4;
             break;
        default:
             break;
      }
      break;
    }
    
    case commercial:
    {
      S_ChangeMusic(mus_read_m, true);

      switch (gamemap)
      {
        case 6:
             finaleflat = bgflat06;
             finaletext = s_C1TEXT;
             break;
        case 11:
             finaleflat = bgflat11;
             finaletext = s_C2TEXT;
             break;
        case 20:
             finaleflat = bgflat20;
             finaletext = s_C3TEXT;
             break;
        case 30:
             finaleflat = bgflat30;
             finaletext = s_C4TEXT;
             break;
        case 15:
             finaleflat = bgflat15;
             finaletext = s_C5TEXT;
             break;
        case 31:
             finaleflat = bgflat31;
             finaletext = s_C6TEXT;
             break;
        default:
             break;
      }

      break;
    } 
  }
  
  finalestage = 0;
  finalecount = 0;
}



boolean F_Responder (event_t *event)
{
  if (finalestage == 2)
    return F_CastResponder (event);
        
  return false;
}

static float Get_TextSpeed(void)
{
  return midstage ? NEWTEXTSPEED : (midstage=acceleratestage) ? 
    acceleratestage=0, NEWTEXTSPEED : TEXTSPEED;
}

void F_Ticker(void)
{
  int i;
  if (!demo_compatibility)
    WI_checkForAccelerate();
  else
    if (gamemode == commercial && finalecount > 50)
      for (i=0; i<MAXPLAYERS; i++)
        if (players[i].cmd.buttons)
          goto next_level;

  finalecount++;
 
  if (finalestage == 2)
    F_CastTicker();

  if (!finalestage)
    {
      float speed = demo_compatibility ? TEXTSPEED : Get_TextSpeed();
      if (finalecount > strlen(finaletext)*speed +
          (midstage ? NEWTEXTWAIT : TEXTWAIT) ||
          (midstage && acceleratestage))
          if (gamemode != commercial)
          {
            finalecount = 0;
            finalestage = 1;
            wipegamestate = -1;
            if (gameepisode == 3)
              S_StartMusic(mus_bunny);
          }
        else
          if (!demo_compatibility && midstage)
            {
            next_level:
              if (gamemap == 30)
                F_StartCast();
              else
                gameaction = ga_worlddone;
            }
    }
}

extern  patch_t *hu_font[(128 - '!')];

void F_TextWrite (void)
{
  int         w;
  int         count;
  char*       ch;
  int         c;
  int         cx;
  int         cy;
  
  M_DrawBackground(finaleflat, screens[0]);

  cx = 10;
  cy = 10;
  ch = finaletext;
      
  count = (finalecount - 10)/Get_TextSpeed();
  if (count < 0)
    count = 0;

  for ( ; count ; count-- )
  {
    c = *ch++;
    if (!c)
      break;
    if (c == '\n')
    {
      cx = 10;
      cy += 11;
      continue;
    }
              
    c = toupper(c) - '!';
    if (c < 0 || c> (128 - '!'))
    {
      cx += 4;
      continue;
    }
              
    w = SHORT (hu_font[c]->width);
    if (cx+w > SCREENWIDTH)
      break;
    V_DrawPatch(cx, cy, 0, hu_font[c],0);
    cx+=w;
  }
}

typedef struct
{
  char       *name;
  mobjtype_t  type;
} castinfo_t;

#define MAX_CASTORDER 18
castinfo_t      castorder[MAX_CASTORDER];

int             castnum;
int             casttics;
state_t*        caststate;
boolean         castdeath;
int             castframes;
int             castonmelee;
boolean         castattacking;

extern  gamestate_t     wipegamestate;

void F_StartCast (void)
{
  castorder[0].name = s_CC_ZOMBIE,  castorder[0].type = MT_POSSESSED;
  castorder[1].name = s_CC_SHOTGUN, castorder[1].type = MT_SHOTGUY;
  castorder[2].name = s_CC_HEAVY,   castorder[2].type = MT_CHAINGUY;
  castorder[3].name = s_CC_IMP,     castorder[3].type = MT_TROOP;
  castorder[4].name = s_CC_DEMON,   castorder[4].type = MT_SERGEANT;
  castorder[5].name = s_CC_LOST,    castorder[5].type = MT_SKULL;
  castorder[6].name = s_CC_CACO,    castorder[6].type = MT_HEAD;
  castorder[7].name = s_CC_HELL,    castorder[7].type = MT_KNIGHT;
  castorder[8].name = s_CC_BARON,   castorder[8].type = MT_BRUISER;
  castorder[9].name = s_CC_ARACH,   castorder[9].type = MT_BABY;
  castorder[10].name = s_CC_PAIN,   castorder[10].type = MT_PAIN;
  castorder[11].name = s_CC_REVEN,  castorder[11].type = MT_UNDEAD;
  castorder[12].name = s_CC_MANCU,  castorder[12].type = MT_FATSO;
  castorder[13].name = s_CC_ARCH,   castorder[13].type = MT_VILE;
  castorder[14].name = s_CC_SPIDER, castorder[14].type = MT_SPIDER;
  castorder[15].name = s_CC_CYBER,  castorder[15].type = MT_CYBORG;
  castorder[16].name = s_CC_HERO,   castorder[16].type = MT_PLAYER;
  castorder[17].name = NULL,        castorder[17].type = 0;

  wipegamestate = -1;
  castnum = 0;
  caststate = &states[mobjinfo[castorder[castnum].type].seestate];
  casttics = caststate->tics;
  castdeath = false;
  finalestage = 2;    
  castframes = 0;
  castonmelee = 0;
  castattacking = false;
  S_ChangeMusic(mus_evil, true);
}

void F_CastTicker (void)
{
  int st;
  int sfx;
      
  if (--casttics > 0)
    return;
              
  if (caststate->tics == -1 || caststate->nextstate == S_NULL)
  {
    castnum++;
    castdeath = false;
    if (castorder[castnum].name == NULL)
      castnum = 0;
    if (mobjinfo[castorder[castnum].type].seesound)
      S_StartSound (NULL, mobjinfo[castorder[castnum].type].seesound);
    caststate = &states[mobjinfo[castorder[castnum].type].seestate];
    castframes = 0;
  }
  else
  {
    if (caststate == &states[S_PLAY_ATK1])
      goto stopattack;
    st = caststate->nextstate;
    caststate = &states[st];
    castframes++;

    switch (st)
    {
      case S_PLAY_ATK1:     sfx = sfx_dshtgn; break;
      case S_POSS_ATK2:     sfx = sfx_pistol; break;
      case S_SPOS_ATK2:     sfx = sfx_shotgn; break;
      case S_VILE_ATK2:     sfx = sfx_vilatk; break;
      case S_SKEL_FIST2:    sfx = sfx_skeswg; break;
      case S_SKEL_FIST4:    sfx = sfx_skepch; break;
      case S_SKEL_MISS2:    sfx = sfx_skeatk; break;
      case S_FATT_ATK8:
      case S_FATT_ATK5:
      case S_FATT_ATK2:     sfx = sfx_firsht; break;
      case S_CPOS_ATK2:
      case S_CPOS_ATK3:
      case S_CPOS_ATK4:     sfx = sfx_shotgn; break;
      case S_TROO_ATK3:     sfx = sfx_claw; break;
      case S_SARG_ATK2:     sfx = sfx_sgtatk; break;
      case S_BOSS_ATK2:
      case S_BOS2_ATK2:
      case S_HEAD_ATK2:     sfx = sfx_firsht; break;
      case S_SKULL_ATK2:    sfx = sfx_sklatk; break;
      case S_SPID_ATK2:
      case S_SPID_ATK3:     sfx = sfx_shotgn; break;
      case S_BSPI_ATK2:     sfx = sfx_plasma; break;
      case S_CYBER_ATK2:
      case S_CYBER_ATK4:
      case S_CYBER_ATK6:    sfx = sfx_rlaunc; break;
      case S_PAIN_ATK3:     sfx = sfx_sklatk; break;
      default: sfx = 0; break;
    }
            
    if (sfx)
      S_StartSound (NULL, sfx);
  }
      
  if (castframes == 12)
  {
    castattacking = true;
    if (castonmelee)
      caststate=&states[mobjinfo[castorder[castnum].type].meleestate];
    else
      caststate=&states[mobjinfo[castorder[castnum].type].missilestate];
    castonmelee ^= 1;
    if (caststate == &states[S_NULL])
    {
      if (castonmelee)
        caststate=
          &states[mobjinfo[castorder[castnum].type].meleestate];
      else
        caststate=
          &states[mobjinfo[castorder[castnum].type].missilestate];
    }
  }
      
  if (castattacking)
  {
    if (castframes == 24
       ||  caststate == &states[mobjinfo[castorder[castnum].type].seestate] )
    {
      stopattack:
      castattacking = false;
      castframes = 0;
      caststate = &states[mobjinfo[castorder[castnum].type].seestate];
    }
  }
      
  casttics = caststate->tics;
  if (casttics == -1)
      casttics = 15;
}


boolean F_CastResponder (event_t* ev)
{
  if (ev->type != ev_keydown)
    return false;
                
  if (castdeath)
    return true;
                
  castdeath = true;
  caststate = &states[mobjinfo[castorder[castnum].type].deathstate];
  casttics = caststate->tics;
  castframes = 0;
  castattacking = false;
  if (mobjinfo[castorder[castnum].type].deathsound)
    S_StartSound (NULL, mobjinfo[castorder[castnum].type].deathsound);
        
  return true;
}

void F_CastPrint (char* text)
{
  char* ch;
  int c,cx,w,width;

  ch = text;
  width = 0;
      
  while (ch)
  {
    c = *ch++;
    if (!c)
      break;
    c = toupper(c) - '!';
    if (c < 0 || c> (128 - '!'))
    {
      width += 4;
      continue;
    }
            
    w = SHORT (hu_font[c]->width);
    width += w;
  }

  cx = 160-width/2;
  ch = text;
  while (ch)
  {
    c = *ch++;
    if (!c)
      break;
    c = toupper(c) - '!';
    if (c < 0 || c> (128 - '!'))
    {
      cx += 4;
      continue;
    }
              
    w = SHORT (hu_font[c]->width);
    V_DrawPatch(cx, 180, 0, hu_font[c],0);
    cx+=w;
  }
}

void F_CastDrawer (void)
{
  spritedef_t*        sprdef;
  spriteframe_t*      sprframe;
  int                 lump;
  patch_t*            patch;
    
  V_DrawPatch(0,0,0, W_CacheLumpName (bgcastcall, PU_CACHE),0);
  F_CastPrint (castorder[castnum].name);
  sprdef = &sprites[caststate->sprite];
  sprframe = &sprdef->spriteframes[ caststate->frame & FF_FRAMEMASK];
  lump = sprframe->lump[0];
                        
  patch = W_CacheLumpNum (lump+firstspritelump, PU_CACHE);
    V_DrawPatch(160,170,0,patch,(boolean)sprframe->flip[0]);
}

static void F_DrawPatchCol(int x, patch_t *patch, int col)
{
  const column_t *column = 
    (const column_t *)((byte *) patch + LONG(patch->columnofs[col]));

    while (column->topdelta != 0xff)
      {
	byte *desttop = screens[0] + x;
	const byte *source = (byte *) column + 3;
	byte *dest = desttop + column->topdelta*SCREENWIDTH;
	int count = column->length;
	for (;count--; dest += SCREENWIDTH)
	  *dest = *source++;
	column = (column_t *)(source+1);
      }
}

void F_BunnyScroll (void)
{
  int         scrolled;
  int         x;
  patch_t*    p1;
  patch_t*    p2;
  char        name[10];
  int         stage;
  static int  laststage;
              
  p1 = W_CacheLumpName ("PFUB2", PU_LEVEL);
  p2 = W_CacheLumpName ("PFUB1", PU_LEVEL);
      
  scrolled = 320 - (finalecount-230)/2;
  if (scrolled > 320)
      scrolled = 320;
  if (scrolled < 0)
      scrolled = 0;
              
  for ( x=0 ; x<SCREENWIDTH ; x++)
  {
    if (x+scrolled < 320)
      F_DrawPatchCol (x, p1, x+scrolled);
    else
      F_DrawPatchCol (x, p2, x+scrolled - 320);           
  }
      
  if (finalecount < 1130)
    return;
  if (finalecount < 1180)
  {
    V_DrawPatch ((SCREENWIDTH-13*8)/2,
                 (SCREENHEIGHT-8*8)/2,0, 
                 W_CacheLumpName ("END0",PU_CACHE),0);
    laststage = 0;
    return;
  }
      
  stage = (finalecount-1180) / 5;
  if (stage > 6)
    stage = 6;
  if (stage > laststage)
  {
    S_StartSound (NULL, sfx_pistol);
    laststage = stage;
  }
      
  sprintf (name,"END%i",stage);
  V_DrawPatch ((SCREENWIDTH-13*8)/2, 
               (SCREENHEIGHT-8*8)/2,0, 
               W_CacheLumpName (name,PU_CACHE),0);
}

void F_Drawer (void)
{
  if (finalestage == 2)
  {
    F_CastDrawer ();
    return;
  }

  if (!finalestage)
    F_TextWrite ();
  else
  {
    switch (gameepisode)
    {
      case 1:
           if ( gamemode == retail )
             V_DrawPatch (0,0,0,
               W_CacheLumpName("CREDIT",PU_CACHE),0);
           else
             V_DrawPatch (0,0,0,
               W_CacheLumpName("HELP2",PU_CACHE),0);
           break;
      case 2:
           V_DrawPatch(0,0,0,
             W_CacheLumpName("VICTORY2",PU_CACHE),0);
           break;
      case 3:
           F_BunnyScroll ();
           break;
      case 4:
           V_DrawPatch (0,0,0,
             W_CacheLumpName("ENDPIC",PU_CACHE),0);
           break;
    }
  }
}