/*
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation. NO WARRANTY.
*/

#include <fcntl.h>
#include <unistd.h>

#include "doomdef.h"
#include "doomstat.h"
#include "d_englsh.h"
#include "i_system.h"
#include "v_video.h"
#include "w_wad.h"
#include "r_main.h"
#include "d_event.h"
#include "g_game.h"
#include "sounds.h"
#include "m_menu.h"
#include "d_deh.h"
#include "m_misc.h"

extern patch_t* hu_font[(128 - '!')];
boolean message_dontdamnme;
int mouseSensitivity_horiz,mouseSensitivity_vert;
int showMessages;
int screenblocks,screenSize; 
int quickSaveSlot,messageToPrint;
char* messageString;
int messageLastMenuActive;
boolean messageNeedsInput; 

void (*messageRoutine)(int response);

#define SAVESTRINGSIZE 24

int saveStringEnter, saveSlot, saveCharIndex;
char saveOldString[SAVESTRINGSIZE]; 
boolean inhelpscreens,menuactive;

#define SKULLXOFF -32
#define LINEHEIGHT 16

char savegamestrings[10][SAVESTRINGSIZE];
typedef struct { short status; char name[10]; void (*routine)(int choice);
char alphaKey; } menuitem_t;
typedef struct menu_s { short numitems; struct menu_s* prevMenu;
menuitem_t* menuitems; void (*routine)(); short x,y,lastOn; } menu_t;

short itemOn;
short skullAnimCounter;
short whichSkull;
char skullName[2][9] = {"M_SKULL1","M_SKULL2"};
menu_t* currentMenu;

extern int autorun;
extern int key_right; 
extern int key_left;
extern int key_up;
extern int key_down;
extern int key_strafeleft; 
extern int key_straferight;
extern int key_fire;
extern int key_use;
extern int key_strafe;
extern int key_speed;
extern int key_autorun;
extern int key_reverse;
extern int key_map;

extern int destination_keys[MAXPLAYERS];
extern int mousebfire; 
extern int mousebstrafe; 
extern int mousebforward;
extern int joybfire;
extern int joybstrafe; 
extern int joybuse; 
extern int joybspeed;
extern char *wad_files[], *deh_files[];
extern default_t defaults[];

void M_NewGame(int choice);
void M_Episode(int choice);
void M_ChooseSkill(int choice);
void M_LoadGame(int choice);
void M_SaveGame(int choice);
void M_Options(int choice);
void M_EndGame(int choice);
void M_ReadThis(int choice);
void M_ReadThis2(int choice);
void M_QuitDOOM(int choice);
void M_ChangeMessages(int choice);
void M_SfxVol(int choice);
void M_MusicVol(int choice);
void M_SizeDisplay(int choice);
void M_StartGame(int choice);
void M_Sound(int choice);
void M_ChangeSensitivity(int choice);
void M_DrawMouse(void);
void M_FinishReadThis(int choice);
void M_FinishHelp(int choice);
void M_LoadSelect(int choice);
void M_SaveSelect(int choice);
void M_ReadSaveStrings(void);
void M_QuickSave(void);
void M_QuickLoad(void);
void M_DrawMainMenu(void);
void M_DrawReadThis1(void);
void M_DrawReadThis2(void);
void M_DrawNewGame(void);
void M_DrawEpisode(void);
void M_DrawOptions(void);
void M_DrawSound(void);
void M_DrawLoad(void);
void M_DrawSave(void);
void M_DrawSetup(void);
void M_DrawHelp (void);
void M_DrawCredits(void);
void M_DrawSaveLoadBorder(int x,int y);
void M_SetupNextMenu(menu_t *menudef);
void M_DrawThermo(int x,int y,int thermWidth,int thermDot);
void M_WriteText(int x, int y, char *string);
int M_StringWidth(char *string);
int M_StringHeight(char *string);
void M_StartControlPanel(void);
void M_StartMessage(char *string,void *routine,boolean input);
void M_ClearMenus (void);
int M_GetKeyString(int,int);
int M_GetPixelWidth(char*);
void M_DrawMenuString(int,int,int); 
void M_General(int);
void M_DrawGeneral(void);
void M_Trans(void);

menu_t NewDef;
char menu_buffer[64];
enum{newgame=0,options,loadgame,savegame,readthis,quitdoom,main_end}main_e;

menuitem_t MainMenu[]=
{
 {1,"M_NGAME", M_NewGame, 'n'}, {1,"M_OPTION",M_Options, 'o'},
 {1,"M_LOADG", M_LoadGame,'l'}, {1,"M_SAVEG", M_SaveGame,'s'},
 {1,"M_RDTHIS",M_ReadThis,'r'}, {1,"M_QUITG", M_QuitDOOM,'q'}
};

menu_t MainDef={main_end,NULL,MainMenu,M_DrawMainMenu,97,64,0};

void M_DrawMainMenu(void)
{ V_DrawPatch(94,2,0,W_CacheLumpName("M_DOOM",PU_CACHE),0); }

enum{ rdthsempty1, read1_end} read_e;
enum{ rdthsempty2, read2_end} read_e2;
enum{ helpempty, help_end} help_e;
menuitem_t ReadMenu1[]={{1,"",M_ReadThis2,0}};
menuitem_t ReadMenu2[]={{1,"",M_FinishReadThis,0}};
menuitem_t HelpMenu[]={{1,"",M_FinishHelp,0}};
menu_t ReadDef1={read1_end,&MainDef,ReadMenu1,M_DrawReadThis1,330,175,0};
menu_t ReadDef2={read2_end, &ReadDef1, ReadMenu2, M_DrawReadThis2,330,175,0};
menu_t HelpDef={help_end,&HelpDef,HelpMenu,M_DrawHelp,330,175,0};
void M_ReadThis(int choice){M_SetupNextMenu(&ReadDef1);}
void M_ReadThis2(int choice){M_SetupNextMenu(&ReadDef2);}
void M_FinishReadThis(int choice){M_SetupNextMenu(&MainDef);}
void M_FinishHelp(int choice){M_SetupNextMenu(&MainDef);}

void M_DrawReadThis1(void)
{
 inhelpscreens = true; if (gamemode == shareware)
 V_DrawPatch(0,0,0,W_CacheLumpName("HELP2",PU_CACHE),0);
 else M_DrawCredits();
}
void M_DrawReadThis2(void)
{
 inhelpscreens = true; if (gamemode == shareware)
 M_DrawCredits(); else V_DrawPatch(0,0,0,W_CacheLumpName("CREDIT",PU_CACHE),0);
}

enum{ep1,ep2,ep3,ep4,ep_end}episodes_e;

menuitem_t EpisodeMenu[]=
{
 {1,"M_EPI1", M_Episode,'k'}, {1,"M_EPI2", M_Episode,'t'},
 {1,"M_EPI3", M_Episode,'i'}, {1,"M_EPI4", M_Episode,'t'}
};

menu_t EpiDef={ep_end,&MainDef,EpisodeMenu,M_DrawEpisode,48,63,ep1};

int epi;

void M_DrawEpisode(void)
{
 V_DrawPatch(54,38,0,W_CacheLumpName("M_EPISOD",PU_CACHE),0);
}

void M_Episode(int choice)
{
 if ( (gamemode == shareware) && choice) {
 M_StartMessage(s_SWSTRING,NULL,false); M_SetupNextMenu(&ReadDef1);
 return; }
 if (gamemode == registered && choice > 2) choice = 0;
 epi = choice; M_SetupNextMenu(&NewDef);
}

enum{killthings,toorough,hurtme,violence,nightmare,newg_end} newgame_e;

menuitem_t NewGameMenu[]=
{
 {1,"M_JKILL", M_ChooseSkill, 'i'}, {1,"M_ROUGH", M_ChooseSkill, 'h'},
 {1,"M_HURT", M_ChooseSkill, 'h'}, {1,"M_ULTRA", M_ChooseSkill, 'u'},
 {1,"M_NMARE", M_ChooseSkill, 'n'}
};

menu_t NewDef={newg_end, &EpiDef, NewGameMenu, M_DrawNewGame,48,63,violence};

void M_DrawNewGame(void)
{
 V_DrawPatch(96,14,0,W_CacheLumpName("M_NEWG",PU_CACHE),0);
 V_DrawPatch(54,38,0,W_CacheLumpName("M_SKILL",PU_CACHE),0);
}

void M_NewGame(int choice)
{
 if (netgame && !demoplayback) { M_StartMessage(s_NEWGAME,NULL,false);
 return; }
 if (demorecording) { M_StartMessage("vous ne pouvez commence nouveau\n"
 "jeux quand enregistrement une demo!\n\n"PRESSKEY, NULL, false);
 return; }
 if ( gamemode == commercial ) M_SetupNextMenu(&NewDef);
 else M_SetupNextMenu(&EpiDef);
}

void M_VerifyNightmare(int ch)
{
 if (ch != 'y') return;
 G_DeferedInitNew(nightmare,epi+1,1); M_ClearMenus ();
}

void M_ChooseSkill(int choice)
{
 if (choice == nightmare) { M_StartMessage(s_NIGHTMARE,M_VerifyNightmare,1);
 return; }
 G_DeferedInitNew(choice,epi+1,1); M_ClearMenus ();
}

enum{load1,load2,load3,load4,load5,load6,load7,load8,load_end}load_e;

menuitem_t LoadMenu[]=
{
 {1,"", M_LoadSelect,'1'}, {1,"", M_LoadSelect,'2'}, {1,"", M_LoadSelect,'3'},
 {1,"", M_LoadSelect,'4'}, {1,"", M_LoadSelect,'5'}, {1,"", M_LoadSelect,'6'},
 {1,"", M_LoadSelect,'7'}, {1,"", M_LoadSelect,'8'},
};

menu_t LoadDef ={load_end, &MainDef, LoadMenu, M_DrawLoad,80,34,0};

void M_DrawLoad(void)
{
 int i;
 V_DrawPatch(72,8,0,W_CacheLumpName("M_LOADG",PU_CACHE),0);
 for (i = 0 ; i < load_end ; i++) {
 M_DrawSaveLoadBorder(LoadDef.x,LoadDef.y+LINEHEIGHT*i);
 M_WriteText(LoadDef.x,LoadDef.y+LINEHEIGHT*i,savegamestrings[i]); }
}

void M_DrawSaveLoadBorder(int x,int y)
{
 int i;
 V_DrawPatch(x-8,y+7,0,W_CacheLumpName("M_LSLEFT",PU_CACHE),0);
 for (i=0 ; i<24 ;i++)
 { V_DrawPatch(x,y+7,0,W_CacheLumpName("M_LSCNTR",PU_CACHE),0); x += 8; }
 V_DrawPatch(x,y+7,0,W_CacheLumpName("M_LSRGHT",PU_CACHE),0);
}

void M_LoadSelect(int choice)
{
 char name[PATH_MAX+1];
 G_SaveGameName(name,choice);
 G_LoadGame(name, choice, false);
 M_ClearMenus ();
}

void M_LoadGame (int choice)
{
 if (netgame&&!demoplayback) { M_StartMessage(s_LOADNET,NULL,false); return; }
 if (demorecording) { M_StartMessage("vous ne pouvez charger jeux\n"
 "quand enregistrement une demo!\n\n"PRESSKEY, NULL, false); return; }
 M_SetupNextMenu(&LoadDef); M_ReadSaveStrings();
}

menuitem_t SaveMenu[]={
 {1,"", M_SaveSelect,'1'}, {1,"", M_SaveSelect,'2'}, {1,"", M_SaveSelect,'3'},
 {1,"", M_SaveSelect,'4'}, {1,"", M_SaveSelect,'5'}, {1,"", M_SaveSelect,'6'},
 {1,"", M_SaveSelect,'7'}, {1,"", M_SaveSelect,'8'},};

menu_t SaveDef ={load_end, &MainDef, SaveMenu, M_DrawSave, 80,34,0};

void M_ReadSaveStrings(void)
{
 int i;
 for (i = 0 ; i < load_end ; i++) {
 char name[PATH_MAX+1]; FILE *fp;
 G_SaveGameName(name,i); fp = fopen(name,"rb");
 if (!fp) { strcpy(&savegamestrings[i][0],s_EMPTYSTRING);
 LoadMenu[i].status = 0; continue; }
 fread(&savegamestrings[i], SAVESTRINGSIZE, 1, fp);
 fclose(fp); LoadMenu[i].status = 1; }
}

void M_DrawSave(void)
{
 int i;
 V_DrawPatch(72,8,0,W_CacheLumpName("M_SAVEG",PU_CACHE),0);
 for (i = 0 ; i < load_end ; i++) {
 M_DrawSaveLoadBorder(LoadDef.x,LoadDef.y+LINEHEIGHT*i);
 M_WriteText(LoadDef.x,LoadDef.y+LINEHEIGHT*i,savegamestrings[i]); }
 if (saveStringEnter) { i = M_StringWidth(savegamestrings[saveSlot]);
 M_WriteText(LoadDef.x + i,LoadDef.y+LINEHEIGHT*saveSlot,"_"); }
}

void M_DoSave(int slot)
{
 G_SaveGame (slot,savegamestrings[slot]); M_ClearMenus ();
 if (quickSaveSlot == -2) quickSaveSlot = slot;
}

void M_SaveSelect(int choice)
{
 saveStringEnter = 1; saveSlot = choice;
 strcpy(saveOldString,savegamestrings[choice]);
 if (!strcmp(savegamestrings[choice],s_EMPTYSTRING))
 savegamestrings[choice][0] = 0;
 saveCharIndex = strlen(savegamestrings[choice]);
}

void M_SaveGame (int choice)
{
 if (!usergame && (!demoplayback || netgame)) {
 M_StartMessage(s_SAVEDEAD,NULL,false); return; }
 if (gamestate != GS_LEVEL) return;
 M_SetupNextMenu(&SaveDef); M_ReadSaveStrings();
}

enum { general, endgame, messages, scrnsize,
mousesens, soundvol, opt_end } options_e;

menuitem_t OptionsMenu[]=
{
 {1,"M_SETUP", M_General,'s'}, {1,"M_ENDGAM", M_EndGame,'e'},
 {1,"M_MESSG", M_ChangeMessages,'m'},
 {2,"M_SCRNSZ", M_SizeDisplay,'s'}, {-1,"",0},
 {2,"M_MSENS", M_ChangeSensitivity,'m'}, {-1,"",0}, 
 {1,"M_SVOL", M_Sound,'s'}
};

void M_ChangeSensitivity(int choice)
{
 switch(choice) {
 case 0: if (mouseSensitivity_horiz) mouseSensitivity_horiz--; break;
 case 1: if (mouseSensitivity_horiz < 9) mouseSensitivity_horiz++; break;
 }
}

menu_t OptionsDef={opt_end, &MainDef, OptionsMenu, M_DrawOptions, 60,37,0};

char msgNames[2][9] = {"M_MSGOFF","M_MSGON"};

void M_DrawOptions(void)
{
 V_DrawPatch(108,15,0,W_CacheLumpName("M_OPTTTL",PU_CACHE),0);
 V_DrawPatch(OptionsDef.x + 120,OptionsDef.y+LINEHEIGHT*messages,0,
 W_CacheLumpName(msgNames[showMessages],PU_CACHE),0);
 M_DrawThermo(OptionsDef.x,OptionsDef.y+96,10,mouseSensitivity_horiz);
 M_DrawThermo(OptionsDef.x,OptionsDef.y+LINEHEIGHT*(scrnsize+1),
 9,screenSize);
}

void M_Options(int choice)
{
 M_SetupNextMenu(&OptionsDef);
}

int quitsounds[8] =
{
 sfx_pldeth, sfx_dmpain, sfx_popain, sfx_slop, sfx_telept, sfx_posit1,
 sfx_posit3, sfx_sgtatk
};

int quitsounds2[8] =
{
 sfx_vilact, sfx_getpow, sfx_boscub, sfx_slop, sfx_skeswg, sfx_kntdth,
 sfx_bspact, sfx_sgtatk
};
boolean nosfxparm;
void M_QuitResponse(int ch)
{
 if (ch != 'y') return;
 S_StartSound(NULL,gamemode == commercial ?
 quitsounds2[(gametic>>2)&7] : quitsounds[(gametic>>2)&7]);
 if(!nosfxparm) I_WaitVBL(105); exit(0);
}

const char *const endmsg[]={
"Voullez vous sortir de\nce grand jeux?",
"s'il vous plait, ne laissez pas,\nil y a plus demons to tue!",
"vons tue il!",
"je prefera continuer.\ndos is plus pis.",
"vous dit que vous gout dos\nmeilleur que me, sur?",
"ne laissez pas -- il y a un\ndemon pour tue!",
"vous savoir, prochain foi vous jeuer\nvous serai tue",
"sortir ce jeux.",
"voulez vous sortir?\nvous est le huitieme!",
"ne allez pas, il y a \nun monster en prompt du dos!",
"allez d'ici et return\npour su facheux programes.",
"se je suis su chef, \n je aurai deathmatch avec vous en un minute!",
"allez. quand vous retourner\n il y a un monster attendrant pour vous.",
"au revoir!"
};
void M_QuitDOOM(int choice)
{
 static char endstring[160];
 sprintf(endstring,"%s\n\n%s",endmsg[gametic%14],s_DOSY);
 M_StartMessage(endstring,M_QuitResponse,true);
}

enum { sfx_vol, sfx_empty1, music_vol, sfx_empty2, sound_end} sound_e;

menuitem_t SoundMenu[]=
{
 {2,"M_SFXVOL",M_SfxVol,'s'}, {-1,"",0},
 {2,"M_MUSVOL",M_MusicVol,'m'}, {-1,"",0}
};

menu_t SoundDef = {sound_end, &OptionsDef, SoundMenu, M_DrawSound,80,64,0};

void M_DrawSound(void)
{
 V_DrawPatch(60,38,0,W_CacheLumpName("M_SVOL",PU_CACHE),0);
 M_DrawThermo(SoundDef.x,SoundDef.y+LINEHEIGHT*(sfx_vol+1),16,snd_SfxVolume);
 M_DrawThermo(SoundDef.x,SoundDef.y+LINEHEIGHT*(music_vol+1),16,snd_MusicVolume);
}

void M_Sound(int choice)
{
 M_SetupNextMenu(&SoundDef);
}

void M_SfxVol(int choice)
{
 switch(choice) {
 case 0: if (snd_SfxVolume) snd_SfxVolume--; break;
 case 1: if (snd_SfxVolume < 15) snd_SfxVolume++; break;
 } S_SetSfxVolume(snd_SfxVolume);
}

void M_MusicVol(int choice)
{
 switch(choice) {
 case 0: if (snd_MusicVolume) snd_MusicVolume--; break;
 case 1: if (snd_MusicVolume < 15) snd_MusicVolume++; break;
 } S_SetMusicVolume(snd_MusicVolume);
}

char tempstring[80];

void M_QuickSaveResponse(int ch)
{
 if (ch == 'y') { M_DoSave(quickSaveSlot); S_StartSound(NULL,sfx_swtchx); }
}

void M_QuickSave(void)
{
 if (!usergame&&(!demoplayback||netgame)){S_StartSound(NULL,sfx_oof);return;}
 if (gamestate != GS_LEVEL) return;
 if (quickSaveSlot < 0) { M_StartControlPanel(); M_ReadSaveStrings();
 M_SetupNextMenu(&SaveDef); quickSaveSlot = -2; return; }
 sprintf(tempstring,s_QSPROMPT,savegamestrings[quickSaveSlot]);
 M_StartMessage(tempstring,M_QuickSaveResponse,true);
}

void M_QuickLoadResponse(int ch)
{
 if (ch=='y') { M_LoadSelect(quickSaveSlot); S_StartSound(NULL,sfx_swtchx); }
}

void M_QuickLoad(void)
{
 if (netgame && !demoplayback) { M_StartMessage(s_QLOADNET,NULL,false); return; }
 if (demorecording) { M_StartMessage("vous ne pouvez rapid charger\n"
 "quand enregiistrement une demo!\n\n"PRESSKEY, NULL, false); return; }
 if (quickSaveSlot < 0) { M_StartMessage(s_QSAVESPOT,NULL,false); return; }
 sprintf(tempstring,s_QLPROMPT,savegamestrings[quickSaveSlot]);
 M_StartMessage(tempstring,M_QuickLoadResponse,true);
}

void M_EndGameResponse(int ch)
{
 if (ch != 'y') return;
 if (demorecording || singledemo) G_CheckDemoStatus();
 currentMenu->lastOn = itemOn;
 M_ClearMenus (); D_StartTitle ();
}

void M_EndGame(int choice)
{
 if (netgame) { M_StartMessage(s_NETEND,NULL,false); return; }
 M_StartMessage(s_ENDGAME,M_EndGameResponse,true);
}

void M_ChangeMessages(int choice)
{
 choice = 0; showMessages = 1 - showMessages;
 if (!showMessages) players[consoleplayer].message = s_MSGOFF;
 else players[consoleplayer].message = s_MSGON ;
 message_dontdamnme = 1;
}

void M_SizeDisplay(int choice)
{
 switch(choice) {
 case 0: if (screenSize>0) { screenblocks--; screenSize--; } break;
 case 1: if (screenSize<8) { screenblocks++; screenSize++; } break;
 } R_SetViewSize (screenblocks);
}

boolean setup_active = false;
boolean setup_select = false;
boolean setup_gather = false;
boolean set_general_active = false;

int set_menu_itemon;
setup_menu_t* current_setup_menu;
char menu_buffer[64]; 

enum { generic_setupempty1, generic_setup_end } generic_setup_e;

menuitem_t Generic_Setup[] = { {1,"",NULL,0} };

menu_t GeneralDef={generic_setup_end,&OptionsDef,Generic_Setup,M_DrawGeneral,34,5,0};

void M_DrawBackground(char* patchname, byte *back_dest)
{
 int x,y;
 byte *back_src, *src;
 src=back_src=W_CacheLumpNum(firstflat+R_FlatNumForName(patchname),PU_CACHE);
 for (y = 0 ; y < SCREENHEIGHT ; src = ((++y & 63)<<6) + back_src)
 for (x = 0 ; x < SCREENWIDTH/64 ; x++)	{
 memcpy (back_dest,back_src+((y & 63)<<6),64); back_dest += 64;	}
}

byte colorblock[121];
#define MAXCHATWIDTH 272
int chat_index;
char* chat_string_buffer;

void M_DrawItem(setup_menu_t* s)
{
 int x = s->m_x, y = s->m_y, flags = s->m_flags;
 char *p, *t; int w = 0;
 {int color=flags&(S_SELECT|S_HILITE|S_TITLE|S_NEXT|S_PREV)?CR_YELLOW:CR_RED;
 for (p = t = strdup(s->m_text); (p = strtok(p,"\n")); y += 8, p = NULL)
 { strcpy(menu_buffer,p);
 if (!(flags & S_LEFTJUST)) w = M_GetPixelWidth(menu_buffer) + 4;
 M_DrawMenuString(x - w, y ,color); } free(t); }
}

int gather_count;
char gather_buffer[6];

void M_DrawSetting(setup_menu_t* s)
{
 int x = s->m_x, y = s->m_y, flags = s->m_flags, color;
 color = flags & (S_SELECT|S_HILITE) ? CR_YELLOW : CR_GREEN;
 if (flags&S_YESNO) { strcpy(menu_buffer,*s->var.def->location?"YES":"NO");
 M_DrawMenuString(x,y,color); return; }
 if (flags & S_NUM) { if (flags & (S_HILITE|S_SELECT) && setup_gather) {
 gather_buffer[gather_count] = 0; strcpy(menu_buffer, gather_buffer); }
 else sprintf(menu_buffer,"%d",*s->var.def->location);
 M_DrawMenuString(x,y,color); return; }
 if (flags & S_KEY) { int *key = s->var.m_key;
 if (key){ M_GetKeyString(*key,0); if (key == &key_use) {
 if (s->m_mouse) sprintf(menu_buffer+strlen(menu_buffer), "/MB%d",*s->m_mouse+1);
 if(s->m_joy) sprintf(menu_buffer+strlen(menu_buffer), "/JB%d",*s->m_joy+1);
 } else
 if (key==&key_up || key==&key_speed || key==&key_fire || key==&key_strafe) {
 if(s->m_mouse) sprintf(menu_buffer+strlen(menu_buffer), "/MB%d",*s->m_mouse+1);
 if(s->m_joy) sprintf(menu_buffer+strlen(menu_buffer), "/JB%d",*s->m_joy+1);
 } M_DrawMenuString(x,y,color); } return; }
 if (flags & S_CRITEM) { sprintf(menu_buffer,"%d", *s->var.def->location);
 M_DrawMenuString(x,y, flags & S_CRITEM ? *s->var.def->location : color);
 return; }
 if (flags & S_STRING) { char *text = *(char **) s->var.def->location;
 if (setup_select && (s->m_flags & (S_HILITE|S_SELECT))) {
 int cursor_start, char_width, i; char c[2];
 while (M_GetPixelWidth(text) >= MAXCHATWIDTH)
 { int len = strlen(text); text[--len] = 0;
 if (chat_index > len) chat_index--; }
 *c = text[chat_index]; c[1] = 0;
 char_width = M_GetPixelWidth(c);
 if (char_width == 1) char_width = 7;
 text[chat_index] = 0; cursor_start = M_GetPixelWidth(text);
 text[chat_index] = *c;
 for (i = 0 ; i < char_width ; i++) colorblock[i] = 0;
 V_DrawBlock(x+cursor_start-1,y+7,0,char_width,1,colorblock); }
 strcpy(menu_buffer,text);
 M_DrawMenuString(x,y,color);
 return;
 }
}

void M_DrawScreenItems(setup_menu_t* src)
{
 while (!(src->m_flags & S_END)) {
 if (src->m_flags & S_SHOWDESC)	M_DrawItem(src);
 if (src->m_flags & S_SHOWSET) M_DrawSetting(src);
 src++; }
}

void M_DrawInstructions()
{
 int flags = current_setup_menu[set_menu_itemon].m_flags;
 const char *s = "";
 int color = CR_YELLOW,x = setup_select ? color = CR_YELLOW, flags & S_KEY ?
 (s = "appuyez une tecle pour cette action", 84) :
 flags & S_YESNO ? (s = "ENTER tecle pour changer", 78) :
 flags & S_NUM || flags & S_CRITEM ? (s = "change", 125) :
 flags & S_FILE ? (s = "change nom et appuyez ENTER", 52) :
 0 : (s = "Appuyez Enter pour Change", 91);
 strcpy(menu_buffer, s);
 M_DrawMenuString(x,20,color);
}

extern int tran_filter_pct;
setup_menu_t gen_settings1[], gen_settings2[];

setup_menu_t* gen_settings[] =
{
 gen_settings1, gen_settings2, NULL
};

setup_menu_t gen_settings1[] = {
 {"General" ,S_SKIP|S_TITLE, 250, 32},
 {"Transparency percent",S_NUM,250,44,{"tran_filter_pct"},0,0,M_Trans},
 {"PCX en lieu de BMP en screenshots",S_YESNO,250,52,{"screenshot_pcx"}},
 {"Use Mouse", S_YESNO, 250, 60, {"use_mouse"}},
 {"Use Joystick", S_YESNO, 250, 68, {"use_joystick"}},
 {"Mouse sens. vertical", S_NUM, 250, 76, {"mouse_sens_vert"}},
 {"pass sur objets", S_YESNO, 250, 84, {"true3d"}},
 {"Charge archives en commence",S_SKIP|S_TITLE, 250, 112},
 {"WAD # 1",S_FILE, 76, 124, {"wad_1"}},
 {"WAD #2",S_FILE, 76, 132, {"wad_2"}},
 {"DEH # 1",S_FILE, 76, 140, {"deh_1"}},
 {"DEH #2",S_FILE, 76, 148, {"deh_2"}},
 {"prochain ->",S_SKIP|S_NEXT,280,160, {gen_settings2}},
 {0,S_SKIP|S_END}
};

setup_menu_t gen_settings2[] = {
 {"CONTROLLER" ,S_SKIP|S_TITLE,160,32},
 {"front" ,S_KEY ,160,40,{&key_up},&mousebforward},
 {"derriere" ,S_KEY ,160,48,{&key_down}},
 {"gauche" ,S_KEY ,160,56,{&key_left}},
 {"droit" ,S_KEY ,160,64,{&key_right}},
 {"courir" ,S_KEY ,160,72,{&key_speed},0,&joybspeed},
 {"STRAFE gauche" ,S_KEY ,160,80,{&key_strafeleft}},
 {"STRAFE droit",S_KEY ,160,88,{&key_straferight}},
 {"STRAFE" ,S_KEY ,160,96,{&key_strafe},&mousebstrafe,&joybstrafe},
 {"AUTOcourir" ,S_KEY ,160,104,{&key_autorun}},
 {"180 tourner" ,S_KEY ,160,112,{&key_reverse}},
 {"USE" ,S_KEY ,160,120,{&key_use},&mousebforward,&joybuse},
 {"tirer" ,S_KEY ,160,128,{&key_fire},&mousebfire,&joybfire},
 {"sauter" ,S_KEY ,160,136,{&key_jump}},
 {"<- retourne",S_SKIP|S_PREV, 280, 160, {gen_settings1}},
 {0,S_SKIP|S_END}
};

void M_Trans(void) { if (tran_filter_pct<100) R_InitTranMap(0); }

void M_General(int choice)
{
 M_SetupNextMenu(&GeneralDef);
 setup_active = true;
 set_general_active = true;
 setup_select = false;
 setup_gather = false;
 current_setup_menu = gen_settings[0];
 set_menu_itemon = 0;
 while (current_setup_menu[set_menu_itemon++].m_flags & S_SKIP);
 current_setup_menu[--set_menu_itemon].m_flags |= S_HILITE;
}

void M_DrawGeneral(void)
{
 inhelpscreens = true;
 M_DrawBackground("FLOOR4_6", screens[0]);
 V_DrawPatch(114,2,0,W_CacheLumpName("M_SETUP",PU_CACHE),0);
 M_DrawInstructions();
 M_DrawScreenItems(current_setup_menu);
}

void M_SelectDone(setup_menu_t* ptr)
{
 ptr->m_flags &= ~S_SELECT; ptr->m_flags |= S_HILITE;
 S_StartSound(NULL,sfx_itemup); setup_select = false;
}

void M_InitDefaults(void)
{
 setup_menu_t *const *p=gen_settings, *t; default_t *dp;
 for (t = *p; !(t->m_flags & S_END); t++) if (t->m_flags & S_HASDEFPTR)
 if(dp=M_LookupDefault(t->var.name))
 (t->var.def = dp)->setup_menu = t; else
 I_Error("Variable %s ne find",t->var.name); 
}

int M_GetKeyString(int c,int offset)
{
 char* s;
 if (c >= 33 && c <= 126) { if (c == '=')c = '+';
 else if (c == ',') c = '<'; else if (c == '.') c = '>';
 menu_buffer[offset++] = c; menu_buffer[offset] = 0; }
 else { switch(c) {
 case KEYD_TAB: s = "TAB"; break;
 case KEYD_ENTER: s = "ENTR"; break;
 case KEYD_ESCAPE: s = "ESC"; break;
 case KEYD_SPACEBAR: s = "SPAC"; break;
 case KEYD_BACKSPACE: s = "BACK"; break;
 case KEYD_RCTRL: s = "CTRL"; break;
 case KEYD_LEFTARROW: s = "LARR"; break;
 case KEYD_UPARROW: s = "UARR"; break;
 case KEYD_RIGHTARROW: s = "RARR"; break;
 case KEYD_DOWNARROW: s = "DARR"; break;
 case KEYD_RSHIFT: s = "SHFT"; break;
 case KEYD_RALT: s = "ALT"; break;
 case KEYD_CAPSLOCK: s = "CAPS"; break;
 default: break; }
 strcpy(&menu_buffer[offset],s); offset += strlen(s); }
 return offset;
}

setup_menu_t helpstrings[] = 
{
{"toile",S_TITLE,283,2},
{"aide",S_KEY,283,10,"F1"},
{"MENU",S_KEY,283,18,"ESC"},
{"PAUSE" ,S_KEY,283,26,"PAUSE"},
{"AUTOMAPE" ,S_KEY,283,34,{&key_map}},
{"SON VOLUME",S_KEY,283,42,"F4"},
{"MESSAGES",S_KEY,283,50,"F8"},
{"GAMMA" ,S_KEY,283,58,"F11"},
{"voir autre jeuer en net" ,S_KEY,283,66,"F12"},
{"plus grand VU" ,S_KEY,283,74,"="},
{"plus petit VU",S_KEY,283,82,"-"},
{"SCREENSHOT",S_KEY,283,90,"*"},
{"AUTOMAPE" ,S_TITLE,283,118},
{"pursuit MODE" ,S_KEY,283,126,"f"},
{"augmenter" ,S_KEY,283,134,"="},
{"reducer",S_KEY,283,142,"-"},
{"MARQUER PLACE",S_SKIP|S_KEY,283,150,"m"},
{"eliminer MARQUES" ,S_KEY,283,158,"c"},
{"grand/petit" ,S_KEY,283,166,"0"},
{"GRID",S_KEY,283,174,"g"},
{"ARMES" ,S_TITLE,87,2},
{"MAIN",S_KEY,87,10,"1"},
{"PISTOLET",S_KEY,87,18,"2"},
{"FUSIL" ,S_KEY,87,26,"3"},
{"mitralieuse",S_KEY,87,34,"4"},
{"ROQUETE",S_KEY,87,42,"5"},
{"PLASMA",S_KEY,87,50,"6"},
{"BFG 9000",S_KEY,87,58,"7"},
{"CHAINSAW",S_KEY,87,66,"8"},
{"super fusil" ,S_KEY,87,74,"9"},
{"tirer",S_KEY,87,82,{&key_fire},&mousebfire,&joybfire},
{"MOVEMENT",S_TITLE,87,102},
{"front" ,S_KEY,87,110,{&key_up},&mousebforward},
{"derriere",S_KEY,87,118,{&key_down}},
{"gauche" ,S_KEY,87,126,{&key_left}},
{"droit",S_KEY,87,134,{&key_right}},
{"courir" ,S_KEY,87,142,{&key_speed},0,&joybspeed},
{"STRAFE gauche" ,S_KEY,87,150,{&key_strafeleft}},
{"STRAFE droit",S_KEY,87,158,{&key_straferight}},
{"STRAFE",S_KEY,87,166,{&key_strafe},&mousebstrafe,&joybstrafe},
{"AUTOcourir" ,S_KEY,87,174,{&key_autorun}},
{"180 tourner",S_KEY,87,182,{&key_reverse}},
{"USE" ,S_KEY,87,190,{&key_use},&mousebforward,&joybuse},
{"jeux",S_TITLE,172,2},
{"sauver",S_KEY,172,10,"F2"},
{"charger",S_KEY,172,18,"F3"},
{"rapid sauver" ,S_KEY,172,26,"F6"},
{"find jeux",S_KEY,172,34,"F7"},
{"rapid charger" ,S_KEY,172,42,"F9"},
{"sortir",S_KEY,172,50,"F10"},
{0,S_END}
};

#define SPACEWIDTH 4

void M_DrawMenuString(int cx, int cy, int color)
{
 int w, c;
 char* ch = menu_buffer;
 while (*ch) { c = *ch++; c = toupper(c) - '!';
 if (c < 0 || c> (128 - '!')) { cx += SPACEWIDTH; continue; }
 w = SHORT (hu_font[c]->width); if (cx + w > SCREENWIDTH) break;
 V_DrawPatchTranslated(cx,cy,0,hu_font[c],colrngs[color],0);
 cx += w - 1; }
}

int M_GetPixelWidth(char* ch)
{
 int len=0, c;
 while (*ch) { c = *ch++; c = toupper(c) - '!';
 if (c < 0 || c > (128 - '!')) { len += SPACEWIDTH; continue; }
 len += SHORT (hu_font[c]->width); len--; } len++;
 return len;
}

void M_DrawHelp (void)
{
 inhelpscreens = true;
 M_DrawBackground("FLOOR4_6", screens[0]);
 M_DrawScreenItems(helpstrings);
}

void M_DrawCredits(void)
{
 inhelpscreens = true;
 M_DrawBackground(gamemode==shareware ? "CEIL5_1" : "MFLR8_4", screens[0]);
 V_DrawPatch(0,0,0,W_CacheLumpName("CREDIT",PU_CACHE),0);
}

boolean M_Responder (event_t* ev)
{
 int ch,i;
 int joywait = 0;
 int mousewait = 0;
 int mousey = 0;
 int lasty = 0;
 int mousex = 0;
 int lastx = 0;
 ch = -1;
 if (ev->type == ev_joystick && joywait < I_GetTime()) {
 if (ev->data3 == -1) { ch = KEYD_UPARROW;
 joywait = I_GetTime() + 5; }
 else if (ev->data3 == 1) { ch = KEYD_DOWNARROW;
 joywait = I_GetTime() + 5; }
 if (ev->data2 == -1) { ch = KEYD_LEFTARROW;
 joywait = I_GetTime() + 2; }
 else if (ev->data2 == 1) { ch = KEYD_RIGHTARROW;
 joywait = I_GetTime() + 2; }
 if (ev->data1&1) { ch = KEYD_ENTER;
 joywait = I_GetTime() + 5; }
 if (ev->data1&2) { ch = KEYD_BACKSPACE;
 joywait = I_GetTime() + 5; }
 if (setup_active) { if (ev->data1&4) {
 ch = 0; joywait = I_GetTime() + 5; }
 if (ev->data1&8) { ch = 0; joywait = I_GetTime() + 5; } }
 } else { if (ev->type == ev_mouse && mousewait < I_GetTime())
 { mousey += ev->data3; if (mousey < lasty-30) { ch = KEYD_DOWNARROW;
 mousewait = I_GetTime() + 5; mousey = lasty -= 30; }
 else if (mousey > lasty+30) { ch = KEYD_UPARROW;
 mousewait = I_GetTime() + 5; mousey = lasty += 30; }
 mousex += ev->data2; if (mousex < lastx-30) { ch = KEYD_LEFTARROW;
 mousewait = I_GetTime() + 5; mousex = lastx -= 30; }
 else if (mousex > lastx+30) { ch = KEYD_RIGHTARROW;
 mousewait = I_GetTime() + 5; mousex = lastx += 30; }
 if (ev->data1&1) { ch = KEYD_ENTER; mousewait = I_GetTime() + 15; }
if (ev->data1&2) { ch = KEYD_BACKSPACE; mousewait = I_GetTime() + 15; }
 if (setup_active) if (ev->data1&4)
 { ch = 0; mousewait = I_GetTime() + 15; } } else
 if (ev->type == ev_keydown) { ch = ev->data1; } }
 if (ch == -1) return false;
 if (saveStringEnter) { if (ch == KEYD_BACKSPACE) {
 if (saveCharIndex > 0) { saveCharIndex--;
 savegamestrings[saveSlot][saveCharIndex] = 0; } }
 else if (ch == KEYD_ESCAPE) { saveStringEnter = 0;
 strcpy(&savegamestrings[saveSlot][0],saveOldString);
 } else if (ch == KEYD_ENTER) {
 saveStringEnter = 0; if (savegamestrings[saveSlot][0])
 M_DoSave(saveSlot); } else { ch = toupper(ch);
 if (ch >= 32 && ch <= 127 && saveCharIndex < SAVESTRINGSIZE-1 &&
 M_StringWidth(savegamestrings[saveSlot]) < (SAVESTRINGSIZE-2)*8)
 { savegamestrings[saveSlot][saveCharIndex++] = ch;
 savegamestrings[saveSlot][saveCharIndex] = 0;
 } } return true; }
 if (messageToPrint) {
 if (messageNeedsInput==true&&!(ch==' '||ch=='n'||ch=='y'||ch==KEYD_ESCAPE))
 return false;
 menuactive = messageLastMenuActive; messageToPrint = 0;
 if (messageRoutine) messageRoutine(ch); menuactive = false;
 S_StartSound(NULL,sfx_swtchx); return true; }
 if ((devparm&&ch==KEYD_F1)||ch=='*') { G_ScreenShot (); return true; }
 if (!menuactive) { if (ch == key_autorun)
 { autorun = !autorun; return true; }
 if (ch == KEYD_F1) { M_StartControlPanel (); currentMenu = &HelpDef;
 itemOn = 0; S_StartSound(NULL,sfx_swtchn); return true; }
 if (ch == KEYD_F2) {M_StartControlPanel(); S_StartSound(NULL,sfx_swtchn);
 M_SaveGame(0); return true; }
 if (ch == KEYD_F3) { M_StartControlPanel(); S_StartSound(NULL,sfx_swtchn);
 M_LoadGame(0); return true; }
 if (ch == KEYD_F4) { M_StartControlPanel (); currentMenu = &SoundDef;
 itemOn = sfx_vol; S_StartSound(NULL,sfx_swtchn); return true; }
 if (ch == KEYD_F6) { S_StartSound(NULL,sfx_swtchn);
 M_QuickSave(); return true; }
 if (ch == KEYD_F7) { S_StartSound(NULL,sfx_swtchn);
 M_EndGame(0); return true; }
 if (ch == KEYD_F8) { M_ChangeMessages(0);
 S_StartSound(NULL,sfx_swtchn); return true; }
 if (ch == KEYD_F9)
 { S_StartSound(NULL,sfx_swtchn); M_QuickLoad(); return true; }
 if (ch == KEYD_F10) { S_StartSound(NULL,sfx_swtchn);
 M_QuitDOOM(0); return true; }
 if (ch == KEYD_F11)
 { usegamma++; if (usegamma > 4) usegamma = 0;
 players[consoleplayer].message =
 usegamma == 0 ? s_GAMMALVL0 : usegamma == 1 ? s_GAMMALVL1 :
 usegamma == 2 ? s_GAMMALVL2 : usegamma == 3 ? s_GAMMALVL3 : s_GAMMALVL4;
 I_SetPalette (W_CacheLumpName ("PLAYPAL",PU_CACHE));
 return true; }
 if (ch == '-')	{
 if (automapactive) return false;
 M_SizeDisplay(0); S_StartSound(NULL,sfx_stnmov);
 return true; }
 if (ch == '='){ 
 if (automapactive)return false;M_SizeDisplay(1); 
 S_StartSound(NULL,sfx_stnmov); return true; } }
 if (!menuactive) { if (ch == KEYD_ESCAPE) {
 M_StartControlPanel (); S_StartSound(NULL,sfx_swtchn);
 return true; } return false; }
 if (setup_active) {
 setup_menu_t* ptr1= current_setup_menu + set_menu_itemon;
 setup_menu_t* ptr2 = NULL;
 if (setup_select) { if (ch == KEYD_ESCAPE) {
 M_SelectDone(ptr1); setup_gather = false; return true; }
 if (ptr1->m_flags & S_YESNO) { if (ch == KEYD_ENTER)
 *ptr1->var.def->location = !*ptr1->var.def->location;
 M_SelectDone(ptr1); return true; }
 if (ptr1->m_flags & S_CRITEM) { if (ch != KEYD_ENTER) { ch -= 0x30;
 if (ch < 0 || ch > 9) return true; *ptr1->var.def->location = ch; }
 if (ptr1->action) ptr1->action(); M_SelectDone(ptr1); return true; }
 if (ptr1->m_flags & S_NUM) { if (setup_gather) {
 if (ch == KEYD_ENTER) { if (gather_count) { int value;
 gather_buffer[gather_count] = 0; value = atoi(gather_buffer);
 if (value >= ptr1->var.def->limit.min && value <= ptr1->var.def->limit.max)
 *ptr1->var.def->location = value;
 if (ptr1->action) ptr1->action(); 
 } M_SelectDone(ptr1); setup_gather = false;
 return true; }
 if (ch == KEYD_BACKSPACE && gather_count)
 { gather_count--; return true; }
 if (gather_count >= 5) return true;
 if (!isdigit(ch) && ch != '-') return true;
 gather_buffer[gather_count++] = ch; } return true; } }
 if (setup_select && set_general_active && (ptr1->m_flags & S_STRING)) {
 if (ptr1->m_flags & S_STRING) { if (ch == KEYD_BACKSPACE) {
 if (chat_string_buffer[chat_index] == 0) {
 if (chat_index > 0) chat_string_buffer[--chat_index] = 0; } else
 strcpy(&chat_string_buffer[chat_index], &chat_string_buffer[chat_index+1]);
 } else if (ch == KEYD_LEFTARROW) {
 if (chat_index > 0) chat_index--; } else if (ch == KEYD_RIGHTARROW)
 { if (chat_string_buffer[chat_index] != 0) chat_index++; }
 else if ((ch == KEYD_ENTER)||(ch == KEYD_ESCAPE))
 { *(char **) ptr1->var.def->location = chat_string_buffer;
 M_SelectDone(ptr1); }
 else if ((ch >= 32) && (ch <= 126)) if ((chat_index+1) < 128) {
 if (chat_string_buffer[chat_index] == 0) 
 { chat_string_buffer[chat_index++] = ch;
 chat_string_buffer[chat_index] = 0; }
 else chat_string_buffer[chat_index++] = ch; } return true;
 } M_SelectDone(ptr1); return true; }
 if (set_general_active) if (setup_select) {
 if (ev->type == ev_joystick) { int i,oldbutton;
 boolean search = true; if (!ptr1->m_joy) return true;
 oldbutton = *ptr1->m_joy;
 if (ev->data1 & 1) ch = 0; else if (ev->data1 & 2) ch = 1;
 else if (ev->data1 & 4) ch = 2; else if (ev->data1 & 8) ch = 3;
 else return true;
 for (i = 0 ; gen_settings[i] && search ; i++)
 for (ptr2 = gen_settings[i] ; !(ptr2->m_flags & S_END) ; ptr2++)
 *ptr1->m_joy = ch; }
 else if (ev->type == ev_mouse) {
 int i,oldbutton;
 boolean search = true; if (!ptr1->m_mouse) return true;
 oldbutton = *ptr1->m_mouse;
 if (ev->data1 & 1) ch = 0; else if (ev->data1 & 2) ch = 1;
 else if (ev->data1 & 4) ch = 2; else return true;
 for (i = 0 ; gen_settings[i] && search ; i++)
 for (ptr2 = gen_settings[i] ; !(ptr2->m_flags & S_END) ; ptr2++)
 *ptr1->m_mouse = ch; } else {
 int i,oldkey;
 boolean search = true; oldkey = *ptr1->var.m_key;
 for (i = 0 ; gen_settings[i] && search ; i++)
 for (ptr2 = gen_settings[i] ; !(ptr2->m_flags & S_END) ; ptr2++)
 if (ptr2->m_flags & (S_KEY|S_KEEP) && 
 ptr1 != ptr2) if (*ptr2->var.m_key == ch) {
 if (ptr2->m_flags & S_KEEP) return true; *ptr2->var.m_key = oldkey;
 search = false; break; } *ptr1->var.m_key = ch;
 } M_SelectDone(ptr1); return true; }
 if (ch == KEYD_DOWNARROW) {
 ptr1->m_flags &= ~S_HILITE; do if (ptr1->m_flags & S_END)
 { set_menu_itemon = 0; ptr1 = current_setup_menu; }
 else { set_menu_itemon++; ptr1++; } while (ptr1->m_flags & S_SKIP);
 M_SelectDone(ptr1); return true; }
 if (ch == KEYD_UPARROW) { ptr1->m_flags &= ~S_HILITE; do
 { if (set_menu_itemon == 0) do set_menu_itemon++;
 while(!((current_setup_menu + set_menu_itemon)->m_flags & S_END));
 set_menu_itemon--; }
 while((current_setup_menu + set_menu_itemon)->m_flags & S_SKIP);
 M_SelectDone(current_setup_menu + set_menu_itemon);
 return true; }
 if (ch == KEYD_ENTER) { int flags = ptr1->m_flags;
 if (flags & S_NUM) { setup_gather = true; gather_count = 0; }
 else if (flags & S_STRING) {
 chat_string_buffer = malloc(128); strncpy(chat_string_buffer,
 *(char **) ptr1->var.def->location, 128);
 chat_string_buffer[127] = 0;
 free(*(char **) ptr1->var.def->location);
 *(char **) ptr1->var.def->location = chat_string_buffer;
 chat_index = 0; }
 ptr1->m_flags |= S_SELECT; setup_select = true;
 S_StartSound(NULL,sfx_itemup); return true; }
 if ((ch == KEYD_ESCAPE) || (ch == KEYD_BACKSPACE)) {
 if (ch == KEYD_ESCAPE) M_ClearMenus(); else
 if (currentMenu->prevMenu) { currentMenu = currentMenu->prevMenu;
 itemOn = currentMenu->lastOn; S_StartSound(NULL,sfx_swtchn); }
 ptr1->m_flags &= ~(S_HILITE|S_SELECT); setup_active = false;
 set_general_active = false; HU_Start();
 S_StartSound(NULL,sfx_swtchx); return true; }
 if (ch == KEYD_LEFTARROW) { ptr2 = ptr1; do { ptr2++;
 if (ptr2->m_flags & S_PREV) { ptr1->m_flags &= ~S_HILITE;
 current_setup_menu = ptr2->var.menu; set_menu_itemon = 0;
 while (current_setup_menu[set_menu_itemon++].m_flags&S_SKIP);
 current_setup_menu[--set_menu_itemon].m_flags |= S_HILITE;
 S_StartSound(NULL,sfx_pstop); return true; }
 } while (!(ptr2->m_flags & S_END)); }
 if (ch == KEYD_RIGHTARROW) { ptr2 = ptr1; do { ptr2++;
 if (ptr2->m_flags & S_NEXT) { ptr1->m_flags &= ~S_HILITE;
 current_setup_menu = ptr2->var.menu; set_menu_itemon = 0;
 while (current_setup_menu[set_menu_itemon++].m_flags&S_SKIP);
 current_setup_menu[--set_menu_itemon].m_flags |= S_HILITE;
 S_StartSound(NULL,sfx_pstop); return true; } }
 while (!(ptr2->m_flags & S_END)); } }
 if (ch == KEYD_DOWNARROW) { do {
 if (itemOn+1 > currentMenu->numitems-1) itemOn = 0;
 else itemOn++; S_StartSound(NULL,sfx_pstop);
 } while(currentMenu->menuitems[itemOn].status==-1);
 return true; }
 if (ch == KEYD_UPARROW) { do {
 if (!itemOn) itemOn = currentMenu->numitems-1;
 else itemOn--; S_StartSound(NULL,sfx_pstop);
 } while(currentMenu->menuitems[itemOn].status==-1);
 return true; }
 if (ch == KEYD_LEFTARROW) {
 if (currentMenu->menuitems[itemOn].routine &&
 currentMenu->menuitems[itemOn].status == 2) {
 S_StartSound(NULL,sfx_stnmov); currentMenu->menuitems[itemOn].routine(0);
 } return true; }
 if (ch == KEYD_RIGHTARROW) {
 if (currentMenu->menuitems[itemOn].routine &&
 currentMenu->menuitems[itemOn].status == 2) {
 S_StartSound(NULL,sfx_stnmov); currentMenu->menuitems[itemOn].routine(1);
 } return true; }
 if (ch == KEYD_ENTER) {
 if (currentMenu->menuitems[itemOn].routine &&
 currentMenu->menuitems[itemOn].status)
 { currentMenu->lastOn = itemOn;
 if (currentMenu->menuitems[itemOn].status == 2)
 { currentMenu->menuitems[itemOn].routine(1);
 S_StartSound(NULL,sfx_stnmov); } else
 { currentMenu->menuitems[itemOn].routine(itemOn);
 S_StartSound(NULL,sfx_pistol); } } return true; }
 if (ch == KEYD_ESCAPE) { currentMenu->lastOn = itemOn;
 M_ClearMenus (); S_StartSound(NULL,sfx_swtchx);
 return true; }
 if (ch == KEYD_BACKSPACE) { currentMenu->lastOn = itemOn;
 if (currentMenu->prevMenu) { currentMenu = currentMenu->prevMenu;
 itemOn = currentMenu->lastOn; S_StartSound(NULL,sfx_swtchn);
 } return true; }
 else { for (i = itemOn+1;i < currentMenu->numitems;i++)
 if (currentMenu->menuitems[i].alphaKey == ch)
 { itemOn = i; S_StartSound(NULL,sfx_pstop); return true; }
 for (i = 0;i <= itemOn;i++) if (currentMenu->menuitems[i].alphaKey == ch)
 { itemOn = i; S_StartSound(NULL,sfx_pstop); return true;
 } } return false;
}
void M_StartControlPanel (void)
{
 if (menuactive) return;
 menuactive = 1; currentMenu = &MainDef;
 itemOn = currentMenu->lastOn;
}
void M_Drawer (void)
{
 inhelpscreens = false;
 if (messageToPrint) { char *p = messageString;
 int y = 100 - M_StringHeight(messageString)/2;
 while (*p) { char *string = p, c;
 while ((c = *p) && *p != '\n') p++; *p = 0;
 M_WriteText(160 - M_StringWidth(string)/2, y, string);
 y += SHORT(hu_font[0]->height);
 if ((*p = c)) p++; } } else
 if (menuactive){ int x,y,max,i;
if (currentMenu->routine) currentMenu->routine();
x = currentMenu->x; y = currentMenu->y;
max = currentMenu->numitems;
for (i=0;i<max;i++)
{ if (currentMenu->menuitems[i].name[0])
V_DrawPatch(x,y,0,W_CacheLumpName(currentMenu->menuitems[i].name,PU_CACHE),0);
y += LINEHEIGHT; }
V_DrawPatch(x + SKULLXOFF,currentMenu->y - 5 + itemOn*LINEHEIGHT,0,
W_CacheLumpName(skullName[whichSkull],PU_CACHE),0); }
}
void M_ClearMenus (void)
{ menuactive = 0; }
void M_SetupNextMenu(menu_t *menudef)
{ currentMenu = menudef; itemOn = currentMenu->lastOn; }
void M_Ticker (void)
{ if (--skullAnimCounter <= 0) { whichSkull ^= 1; skullAnimCounter = 8; } }
void M_StartMessage (char* string,void* routine,boolean input)
{
 messageLastMenuActive = menuactive; messageToPrint = 1;
 messageString = string; messageRoutine = routine;
 messageNeedsInput = input; menuactive = true;
 return;
}
void M_DrawThermo(int x,int y,int thermWidth,int thermDot )
{
 int xx,i;
 xx = x;
 V_DrawPatch(xx,y,0,W_CacheLumpName("M_THERML",PU_CACHE),0);
 xx += 8;
 for (i=0;i<thermWidth;i++)
 { V_DrawPatch(xx,y,0,W_CacheLumpName("M_THERMM",PU_CACHE),0); xx += 8; }
 V_DrawPatch(xx,y,0,W_CacheLumpName("M_THERMR",PU_CACHE),0);
 V_DrawPatch((x+8) + thermDot*8,y,0,W_CacheLumpName("M_THERMO",PU_CACHE),0);
}
int M_StringWidth(char* string)
{
 int i, c, w = 0;
 for (i = 0;i < strlen(string);i++)
 w += (c = toupper(string[i]) - '!') < 0 || c >= (128 - '!') ?
 4 : SHORT(hu_font[c]->width);
 return w;
}
int M_StringHeight(char* string)
{
 int i, h, height = h = SHORT(hu_font[0]->height);
 for (i = 0;string[i];i++) if (string[i] == '\n') h += height;
 return h;
}
void M_WriteText (int x,int y,char* string)
{
 int w;
 char* ch;
 int c,cx,cy;
 ch = string; cx = x; cy = y;
while(1)
{ c = *ch++;
if (!c) break; if (c == '\n')
{ cx = x; cy += 12; continue; }
 c = toupper(c) - '!';
 if (c < 0 || c>= (128 - '!')) { cx += 4; continue; } 
 w = SHORT (hu_font[c]->width);
 if (cx+w > SCREENWIDTH) break;
 V_DrawPatch(cx,cy,0,hu_font[c],0); cx+=w; }
}

void M_Init(void)
{
 M_InitDefaults();
 currentMenu = &MainDef; menuactive = 0;
 itemOn = currentMenu->lastOn; whichSkull = 0;
 skullAnimCounter = 10; screenSize = screenblocks - 3;
 messageToPrint = 0; messageString = NULL;
 messageLastMenuActive = menuactive; quickSaveSlot = -1;
 switch(gamemode)
 {
 case commercial:
 MainMenu[readthis] = MainMenu[quitdoom];
 MainDef.numitems--;
 MainDef.y += 8;
 NewDef.prevMenu = &MainDef;
 ReadDef1.routine = M_DrawReadThis1;
 ReadDef1.x = 330;
 ReadDef1.y = 165;
 ReadMenu1[0].routine = M_FinishReadThis;
 break;
 case registered:
 ReadDef2.y = 15;
 case shareware:
 EpiDef.numitems--;
 break;
 case retail:
 default:
 break;
 }
}