/*
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation. NO WARRANTY.
*/

#include "doomstat.h"
#include "p_spec.h"
#include "p_tick.h"

int leveltime;
thinker_t thinkercap;
thinker_t thinkerclasscap[NUMTHCLASS];

void P_InitThinkers(void)
{
  int i;

  for (i=0; i<NUMTHCLASS; i++)
    thinkerclasscap[i].cprev = thinkerclasscap[i].cnext = &thinkerclasscap[i];

  thinkercap.prev = thinkercap.next  = &thinkercap;
}

void P_UpdateThinker(thinker_t *thinker)
{
  int class = thinker->function == P_MobjThinker && 
    ((mobj_t *) thinker)->health > 0 && 
    (((mobj_t *) thinker)->flags & MF_COUNTKILL ||
     ((mobj_t *) thinker)->type == MT_SKULL) ?
    ((mobj_t *) thinker)->flags & MF_FRIEND ?
    th_friends : th_enemies : th_misc;
  thinker_t *th = thinker->cnext;
  (th->cprev = thinker->cprev)->cnext = th;
  th = &thinkerclasscap[class];
  th->cprev->cnext = thinker;
  thinker->cnext = th;
  thinker->cprev = th->cprev;
  th->cprev = thinker;
}

void P_AddThinker(thinker_t* thinker)
{
  thinkercap.prev->next = thinker;
  thinker->next = &thinkercap;
  thinker->prev = thinkercap.prev;
  thinkercap.prev = thinker;
  thinker->references = 0;
  thinker->cnext = thinker->cprev = thinker;
  P_UpdateThinker(thinker);
}

static thinker_t *currentthinker;

void P_RemoveThinkerDelayed(thinker_t *thinker)
{
  if (!thinker->references)
    {
      thinker_t *next = thinker->next;
      (next->prev = currentthinker = thinker->prev)->next = next;
      Z_Free(thinker);
    }
}

void P_RemoveThinker(thinker_t *thinker)
{
  thinker->function = P_RemoveThinkerDelayed;
  (thinker->cnext->cprev = thinker->cprev)->cnext = thinker->cnext;
}

void P_SetTarget(mobj_t **mop, mobj_t *targ)
{
  if (*mop) (*mop)->thinker.references--;
  if ((*mop = targ)) targ->thinker.references++;
}

static void P_RunThinkers (void)
{
  for (currentthinker = thinkercap.next;
       currentthinker != &thinkercap;
       currentthinker = currentthinker->next)
    if (currentthinker->function)
      currentthinker->function(currentthinker);
}

void P_Ticker (void)
{
  int i;

  if (paused || (menuactive && !demoplayback && !netgame &&
		 players[consoleplayer].viewz != 1))
    return;

  for (i=0; i<MAXPLAYERS; i++)
    if (playeringame[i])
      P_PlayerThink(&players[i]);

  P_RunThinkers();
  P_UpdateSpecials();
  P_RespawnSpecials();
  leveltime++;
}