/*
 *	Name:		Low-level OPL2/OPL3 I/O interface
 *	Project:	MUS File Player Library
 *	Version:	1.65
 *	Author:		Vladimir Arnost (QA-Software)
 *	Last revision:	Nov-24-1996
 *	Compiler:	Borland C++ 3.1, Watcom C/C++ 10.0
 *
 */

#include <dos.h>
#include <conio.h>
#include "muslib.h"

uint OPLport = ADLIBPORT;
uint OPLchannels = OPL2CHANNELS;
uint OPL3mode = 0;

uint OPLwriteReg(uint reg, uchar data)
{
 if (OPL3mode)
 {
 register uint port = OPLport;
 if (reg & 0xFF00)
 port += 2;

 outportb(port, reg);
 inportb(port);
 outportb(port + 1, data);
 return inportb(port);
 } else {
 register uint port = OPLport;
 register uint cnt;

 outportb(port, reg);
 cnt = 6;
 do { inportb(port); } while (--cnt);

 outportb(port + 1, data);
 cnt = 35;
 do { inportb(port); } while (--cnt);
 return inportb(port);
 }
}

void OPLwriteChannel(uint regbase, uint channel, uchar data1, uchar data2)
{
 static uint op_num[] = {
 0x000, 0x001, 0x002, 0x008, 0x009, 0x00A, 0x010, 0x011, 0x012,
 0x100, 0x101, 0x102, 0x108, 0x109, 0x10A, 0x110, 0x111, 0x112};

 register uint reg = regbase+op_num[channel];
 OPLwriteReg(reg, data1);
 OPLwriteReg(reg+3, data2);
}

void OPLwriteValue(uint regbase, uint channel, uchar value)
{
 static uint reg_num[] = {
 0x000, 0x001, 0x002, 0x003, 0x004, 0x005, 0x006, 0x007, 0x008,
 0x100, 0x101, 0x102, 0x103, 0x104, 0x105, 0x106, 0x107, 0x108};

 OPLwriteReg(regbase + reg_num[channel], value);
}

void OPLwriteFreq(uint channel, uint freq, uint octave, uint keyon)
{
 OPLwriteValue(0xA0, channel, (BYTE)freq);
 OPLwriteValue(0xB0, channel, (freq >> 8) | (octave << 2) | (keyon << 5));
}

uint OPLconvertVolume(uint data, uint volume)
{
 static uchar volumetable[128] = {
 0, 1, 3, 5, 6, 8, 10, 11,
 13, 14, 16, 17, 19, 20, 22, 23,
 25, 26, 27, 29, 30, 32, 33, 34,
 36, 37, 39, 41, 43, 45, 47, 49,
 50, 52, 54, 55, 57, 59, 60, 61,
 63, 64, 66, 67, 68, 69, 71, 72,
 73, 74, 75, 76, 77, 79, 80, 81,
 82, 83, 84, 84, 85, 86, 87, 88,
 89, 90, 91, 92, 92, 93, 94, 95,
 96, 96, 97, 98, 99, 99, 100, 101,
 101, 102, 103, 103, 104, 105, 105, 106,
 107, 107, 108, 109, 109, 110, 110, 111,
 112, 112, 113, 113, 114, 114, 115, 115,
 116, 117, 117, 118, 118, 119, 119, 120,
 120, 121, 121, 122, 122, 123, 123, 123,
 124, 124, 125, 125, 126, 126, 127, 127};

 return 0x3F - (((0x3F - data) *
	(uint)volumetable[volume <= 127 ? volume : 127]) >> 7);
}

uint OPLpanVolume(uint volume, int pan)
{
 if (pan >= 0)
	return volume;
 else
	return (volume * (pan + 64)) / 64;
}

void OPLwriteVolume(uint channel, struct OPL2instrument *instr, uint volume)
{
 OPLwriteChannel(0x40, channel, ((instr->feedback & 1) ?
	OPLconvertVolume(instr->level_1, volume) : instr->level_1) | instr->scale_1,
	OPLconvertVolume(instr->level_2, volume) | instr->scale_2);
}

void OPLwritePan(uint channel, struct OPL2instrument *instr, int pan)
{
 uchar bits;
 if (pan < -36) bits = 0x10;
 else if (pan > 36) bits = 0x20;
 else bits = 0x30;
 OPLwriteValue(0xC0, channel, instr->feedback | bits);
}

void OPLwriteInstrument(uint channel, struct OPL2instrument *instr)
{
 OPLwriteChannel(0x40, channel, 0x3F, 0x3F);
 OPLwriteChannel(0x20, channel, instr->trem_vibr_1, instr->trem_vibr_2);
 OPLwriteChannel(0x60, channel, instr->att_dec_1, instr->att_dec_2);
 OPLwriteChannel(0x80, channel, instr->sust_rel_1, instr->sust_rel_2);
 OPLwriteChannel(0xE0, channel, instr->wave_1, instr->wave_2);
 OPLwriteValue (0xC0, channel, instr->feedback | 0x30);
}

void OPLshutup(void)
{
 uint i;

 for(i = 0; i < OPLchannels; i++)
 {
	OPLwriteChannel(0x40, i, 0x3F, 0x3F);
	OPLwriteChannel(0x60, i, 0xFF, 0xFF);
	OPLwriteChannel(0x80, i, 0x0F, 0x0F);
	OPLwriteValue(0xB0, i, 0);
 }
}

void OPLinit(uint port, uint OPL3)
{
 OPLport = port;
 if ( (OPL3mode = OPL3) != 0)
 {
	OPLchannels = OPL3CHANNELS;
	OPLwriteReg(0x105, 0x01);
	OPLwriteReg(0x104, 0x00);
 } else
	OPLchannels = OPL2CHANNELS;
 OPLwriteReg(0x01, 0x20);
 OPLwriteReg(0x08, 0x40);
 OPLwriteReg(0xBD, 0x00);

 OPLshutup();
}

void OPLdeinit(void)
{
 OPLshutup();
 if (OPL3mode)
 {
	OPLwriteReg(0x105, 0x00);
	OPLwriteReg(0x104, 0x00);
 }
 OPLwriteReg(0x01, 0x20);
 OPLwriteReg(0x08, 0x00);
 OPLwriteReg(0xBD, 0x00);
}

int OPL2detect(uint port)
{
 uint origPort = OPLport;
 uint stat1, stat2, i;

 OPLport = port;
 OPLwriteReg(0x04, 0x60);
 OPLwriteReg(0x04, 0x80);
 stat1 = inp(port) & 0xE0;
 OPLwriteReg(0x02, 0xFF);
 OPLwriteReg(0x04, 0x21);
 for (i = 512; --i; )
	inp(port);
 stat2 = inp(port) & 0xE0;
 OPLwriteReg(0x04, 0x60);
 OPLwriteReg(0x04, 0x80);
 OPLport = origPort;

 return (stat1 == 0 && stat2 == 0xC0);
}

int OPL3detect(uint port)
{
 if (!OPL2detect(port))
	return 0;
 if (inp(port) & 4)
	return 0;
 return 1;
}
