#include <malloc.h>
#include <unistd.h>

typedef unsigned char  BYTE;
typedef unsigned short WORD;
typedef unsigned int   DWORD;
typedef unsigned char uchar;
typedef unsigned short ushort;
typedef unsigned int  uint;
typedef unsigned long ulong;
typedef signed char schar;
typedef signed short sshort;
typedef signed int sint;
#define CHANNELS 16
#define PERCUSSION 15
extern long musposition, bankposition, fdmus, fdbank, handlemus;
struct MUSheader {
 char ID[4];
 WORD scoreLen,scoreStart,channels,sec_channels,instrCnt,dummy;
};

struct OPL2instrument {
BYTE trem_vibr_1,att_dec_1,sust_rel_1,wave_1,scale_1,level_1,feedback; 
BYTE trem_vibr_2,att_dec_2,sust_rel_2,wave_2,scale_2,level_2,unused;
sshort basenote;
};

struct OP2instrEntry {
WORD flags;
BYTE finetune,note;
struct OPL2instrument instr[2];
};

#define FL_FIXED_PITCH 0x0001
#define FL_DOUBLE_VOICE 0x0004
#define OP2INSTRSIZE sizeof(struct OP2instrEntry)
#define OP2INSTRCOUNT 175

struct memoryBlock {
 uint bufferType;
 ulong handle;
 BYTE *buffer;
 ulong size,bufAt;
 uint bufLen,bufPos;
};

#define BT_CONV 1

void MLplayerInterrupt(void);
extern volatile ulong MLtime;
extern volatile uint playingChannels;

#define MAXMUSBLOCK 4

struct musicBlock {
 uint state,number,volume,loopcount,channelMask,percussMask;
 ulong time,ticks;
 uint playingcount,channelcount;
 struct memoryBlock score;
 struct driverBlock *driver;
 void *driverdata;
};

#define ST_EMPTY 0
#define ST_STOPPED 1
#define ST_PLAYING 2
#define ST_PAUSED 3

struct driverBlock {
 struct driverBlock *next;
 uint driverID;
 char *name;
 uint datasize;
 int (*initDriver)(void);
 int (*deinitDriver)(void);
 int (*driverParam)(uint message, uint param1, void *param2);
 int (*loadBank)(int fd);
 int (*detectHardware)(uint port);
 int (*initHardware)(uint port);
 int (*deinitHardware)();
 void (*playNote)(struct musicBlock *mus, uint channel, uchar note, int volume);
 void (*releaseNote)(struct musicBlock *mus, uint channel, uchar note);
 void (*pitchWheel)(struct musicBlock *mus, uint channel, int pitch);
 void (*changeControl)(struct musicBlock *mus, uint channel, uchar controller, int value);
 void (*playMusic)(struct musicBlock *mus);
 void (*stopMusic)(struct musicBlock *mus);
 void (*changeVolume)(struct musicBlock *mus, uint volume);
 void (*pauseMusic)(struct musicBlock *mus);
 void (*unpauseMusic)(struct musicBlock *mus);
 int (*sendMIDI)(uint command, uint par1, uint par2);
 uint state;
};

#define DP_SYSEX 0x0001
#define DP_SINGLE_VOICE 0x0002

extern struct musicBlock *MLmusicBlocks[];
extern struct driverBlock *MLdriverList;

void MLinit();
void MLdeinit(void);
struct driverBlock *MLfindDriver(uint driverID);
int MLaddDriver(struct driverBlock *newDriver);
int MLinitDriver(uint driverID);
int MLdeinitDriver(uint driverID);
int MLdriverParam(uint message, uint param1,void* param2);
int MLloadBank(int fd);
int MLdetectHardware(uint driverID, short port);
int MLinitHardware(uint driverID, short port);
int MLdeinitHardware(uint driverID);
int MLallocHandle(uint driverID);
int MLfreeHandle(uint musHandle);
int MLloadMUS(uint musHandle, int fd, uint memoryFlags);
int MLfreeMUS(uint musHandle);
int MLplay(uint musHandle);
int MLstop(uint musHandle);
int MLsetVolume(uint musHandle, uint volume);
int MLgetVolume(uint musHandle);
int MLpause(uint musHandle);
int MLunpause(uint musHandle);
int MLgetState(uint musHandle);
struct musicBlock *MLgetBlock(uint musHandle);
int MLsetLoopCount(uint musHandle, int count);

#define DRV_OPL2 1
#define DRV_OPL3 2

extern struct driverBlock OPL2driver;
extern struct driverBlock OPL3driver;

void OPLplayNote(struct musicBlock *mus, uint channel, uchar note, int volume);
void OPLreleaseNote(struct musicBlock *mus, uint channel, uchar note);
void OPLpitchWheel(struct musicBlock *mus, uint channel, int pitch);
void OPLchangeControl(struct musicBlock *mus, uint channel, uchar controller, int value);
void OPLplayMusic(struct musicBlock *mus);
void OPLstopMusic(struct musicBlock *mus);
void OPLchangeVolume(struct musicBlock *mus, uint volume);
void OPLpauseMusic(struct musicBlock *mus);
void OPLunpauseMusic(struct musicBlock *mus);
int OPLsendMIDI();
int OPLinitDriver(void);
int OPLdeinitDriver(void);
int OPLdriverParam(uint message, uint param1,void *param2);
int OPLloadBank(int fd);
int OPL2detectHardware(uint port);
int OPL2initHardware(uint port);
int OPL2deinitHardware();
int OPL3detectHardware(uint port);
int OPL3initHardware(uint port);
int OPL3deinitHardware();

#define ADLIBPORT 0x388
#define SBPROPORT 0x220
#define OPL2PORT 0x388
#define OPL3PORT 0x388
#define OPL2CHANNELS 9
#define OPL3CHANNELS 18
#define MAXCHANNELS 18

extern uint OPLport,OPLchannels,OPL3mode;

uint OPLwriteReg(uint reg, uchar data);
void OPLwriteChannel(uint regbase, uint channel, uchar data1, uchar data2);
void OPLwriteValue(uint regbase, uint channel, uchar value);
void OPLwriteFreq(uint channel, uint freq, uint octave, uint keyon);
uint OPLconvertVolume(uint data, uint volume);
uint OPLpanVolume(uint volume, int pan);
void OPLwriteVolume(uint channel, struct OPL2instrument *instr, uint volume);
void OPLwritePan(uint channel, struct OPL2instrument *instr, int pan);
void OPLwriteInstrument(uint channel, struct OPL2instrument *instr);
void OPLshutup(void);
void OPLinit(uint port, uint OPL3);
void OPLdeinit(void);
int OPL2detect(uint port);
int OPL3detect(uint port);

#define MIDI_NOTE_OFF 0x80
#define MIDI_NOTE_ON 0x90
#define MIDI_CONTROL 0xB0
#define MIDI_PATCH 0xC0
#define MIDI_CHAN_TOUCH 0xD0
#define MIDI_PITCH_WHEEL 0xE0
#define MIDI_EVENT_MASK 0xF0

enum MUSctrl {
 ctrlPatch = 0,
 ctrlBank,
 ctrlModulation,
 ctrlVolume,
 ctrlPan,
 ctrlExpression,
 ctrlReverb,
 ctrlChorus,
 ctrlSustainPedal,
 ctrlSoftPedal,
 _ctrlCount_,
 ctrlSoundsOff = _ctrlCount_,
 ctrlNotesOff,
 ctrlMono,
 ctrlPoly,
 ctrlResetCtrls
};

struct MIDIdata {
 uchar controllers[_ctrlCount_][CHANNELS];
 uchar channelLastVolume[CHANNELS];
 schar pitchWheel[CHANNELS];
 schar realChannels[CHANNELS];
 uchar percussions[16];
};

void MIDIplayNote(struct musicBlock *mus, uint channel, uchar note, int volume);
void MIDIreleaseNote(struct musicBlock *mus, uint channel, uchar note);
void MIDIpitchWheel(struct musicBlock *mus, uint channel, int pitch);
void MIDIchangeControl(struct musicBlock *mus, uint channel, uchar controller, int value);
void MIDIplayMusic(struct musicBlock *mus);
void MIDIstopMusic(struct musicBlock *mus);
void MIDIchangeVolume(struct musicBlock *mus, uint volume);
void MIDIpauseMusic(struct musicBlock *mus);
void MIDIunpauseMusic(struct musicBlock *mus);
int MIDIinitDriver(void);
int MIDIdeinitDriver(void);
#define DRV_MPU401 4
#define MPU401PORT 0x330
extern struct driverBlock MPU401driver;
int MPU401sendMIDI(uint command, uint par1, uint par2);
int MPU401driverParam(uint message, uint param1, void *param2);
int MPU401loadBank(int fd);
int MPU401detectHardware(uint port, uchar irq, uchar dma);
int MPU401initHardware(uint port);
int MPU401deinitHardware(void);