#ifndef __GLBSP_GLBSP_H__
#define __GLBSP_GLBSP_H__

typedef char  sint8_g;
typedef short sint16_g;
typedef int   sint32_g;
   
typedef unsigned char  uint8_g;
typedef unsigned short uint16_g;
typedef unsigned int   uint32_g;

typedef double float_g;
typedef double angle_g;
typedef int boolean_g;

#ifndef FALSE
#define FALSE  0
#endif
#ifndef TRUE
#define TRUE   1
#endif

typedef struct nodebuildinfo_s
{
  const char *input_file;
  const char *output_file;
  int factor;
  boolean_g load_all;
  boolean_g force_normal;
  boolean_g missing_output;
  boolean_g same_filenames;
}
nodebuildinfo_t;

typedef struct nodebuildcomms_s
{
  const char *message;
  boolean_g cancelled;
}
nodebuildcomms_t;

typedef struct nodebuildfuncs_s
{
  void (* fatal_error)(const char *str, ...);
  void (* print_msg)(const char *str, ...);
}
nodebuildfuncs_t;

extern const nodebuildinfo_t default_buildinfo;
extern const nodebuildcomms_t default_buildcomms;

typedef enum
{
  GLBSP_E_OK = 0,
  GLBSP_E_Unknown,
  GLBSP_E_BadArgs,
  GLBSP_E_BadInfoFixed,
  GLBSP_E_ReadError,
  GLBSP_E_WriteError,
  GLBSP_E_Cancelled
} glbsp_ret_e;

glbsp_ret_e GlbspParseArgs(nodebuildinfo_t *info,
    volatile nodebuildcomms_t *comms,
    const char ** argv, int argc);
glbsp_ret_e GlbspCheckInfo(nodebuildinfo_t *info,
    volatile nodebuildcomms_t *comms);
glbsp_ret_e GlbspBuildNodes(const nodebuildinfo_t *info,
    const nodebuildfuncs_t *funcs, 
    volatile nodebuildcomms_t *comms);
const char *GlbspStrDup(const char *str);
void GlbspFree(const char *str);

#endif
