#ifndef __GLBSP_SEG_H__
#define __GLBSP_SEG_H__

#include "structs.h"
#include "level.h"

#define DEFAULT_FACTOR 27
#define DIST_EPSILON 2.999999
#define ANG_EPSILON (1.0/1024)

typedef struct intersect_tip_s
{
  int open;
  sector_t left,right;
}
intersect_tip_t;

typedef struct intersection_s
{
  struct intersection_s *next;
  struct intersection_s *prev;
  vertex_t vertex;
  float_g along_dist;
  intersect_tip_t l;
  intersect_tip_t r;
}
intersection_t;

seg_t *PickNode(superblock_t *seg_list);
angle_g ComputeAngle(float_g dx, float_g dy);
#define ComputeDist(dx,dy)  sqrt((dx) * (dx) + (dy) * (dy))
#define ComputeParallelDist(part,x,y)  \
    (((x) * (part)->pdx + (y) * (part)->pdy + (part)->p_para)  \
     / (part)->p_length)
#define ComputePerpDist(part,x,y)  \
    (((x) * (part)->pdy - (y) * (part)->pdx + (part)->p_perp)  \
     / (part)->p_length)

#endif
