#ifndef __GLBSP_STRUCTS_H__
#define __GLBSP_STRUCTS_H__

#include "system.h"

typedef struct raw_wad_header_s
{
  char type[4];

  uint32_g num_entries;
  uint32_g dir_start;
}
raw_wad_header_t;

typedef struct raw_wad_entry_s
{
  uint32_g start;
  uint32_g length;

  char name[8];
}
raw_wad_entry_t;

typedef struct raw_blockmap_header_s
{
  sint16_g x_origin, y_origin;
  sint16_g x_blocks, y_blocks;
}
raw_blockmap_header_t;

typedef struct raw_vertex_s
{
  sint16_g x, y;
}
raw_vertex_t;

typedef struct raw_linedef_s
{
  uint16_g start;
  uint16_g end;
  uint16_g flags;
  uint16_g type;
  sint16_g tag;
  uint16_g sidedef1;
  uint16_g sidedef2;
}
raw_linedef_t;

#define LINEFLAG_TWO_SIDED  4

typedef struct raw_sidedef_s
{
  sint16_g x_offset;
  sint16_g y_offset;

  char upper_tex[8];
  char lower_tex[8];
  char mid_tex[8];

  uint16_g sector;
}
raw_sidedef_t;


typedef struct raw_sector_s
{
  sint16_g floor_h;
  sint16_g ceil_h;

  char floor_tex[8];
  char ceil_tex[8];

  uint16_g light;
  uint16_g special;
  sint16_g tag;
}
raw_sector_t;


typedef struct raw_thing_s
{
  sint16_g x, y;
  sint16_g angle;
  uint16_g type;
  uint16_g options;
}
raw_thing_t;

typedef struct raw_seg_s
{
  uint16_g start;
  uint16_g end;
  uint16_g angle;
  uint16_g linedef;
  uint16_g flip;
  uint16_g dist;
}
raw_seg_t;

typedef struct raw_bbox_s
{
  sint16_g maxy, miny;
  sint16_g minx, maxx;
}
raw_bbox_t;

typedef struct raw_node_s
{
  sint16_g x, y;
  sint16_g dx, dy;
  raw_bbox_t b1, b2;
  uint16_g right, left;
}
raw_node_t;


typedef struct raw_subsec_s
{
  uint16_g num;
  uint16_g first;
}
raw_subsec_t;

#endif
