#include "deu.h"

WadPtr WadList=0L;
MDirPtr MasterDir=0L;
int firsttime=1;

void ProgError(char *errstr)
{
 closegraph(); printf(errstr);
 ForgetLevelData(); ForgetTextures();
 exit(5);
}
WadPtr BasicOpen(char *name)
{
   WadPtr curw, prevw;
   prevw=WadList;
   if (prevw)
   {
      curw=prevw->next;
      while (curw && strcmp(name, curw->name))
      { prevw=curw; curw=prevw->next; }
   }
   else curw=0L;
   if (curw==0L)
   {
      curw=Memory(sizeof(struct WadInfo));
      if (prevw==0L) WadList=curw;
      else prevw->next=curw;
      curw->next=0L;
      curw->name=name;
   }
   if ((curw->fileinfo=fopen(name, "rb"))==0L)
      ProgError("open error");
   BasicWadRead(curw, curw->type, 4);
   if (strncmp(curw->type, "IWAD", 4) && strncmp(curw->type, "PWAD", 4))
      ProgError("open error");
   BasicWadRead(curw, &curw->dirsize, sizeof(curw->dirsize));
   BasicWadRead(curw, &curw->dirstart, sizeof(curw->dirstart));
   curw->directory=Memory(sizeof(struct Directory) * curw->dirsize);
   BasicWadSeek(curw, curw->dirstart);
   BasicWadRead(curw, curw->directory, sizeof(struct Directory) * curw->dirsize);
   return curw;
}
void OpenWad(char *name)
{
   WadPtr wad;
   MDirPtr mdir,lastp=0L;
   int n, l;
   char entryname[9], *outfile;
   FILE *test;
   if ((test=fopen(name, "rb"))==0L)
   {
      printf("%s no exist\n", name);
      return;
   }
   fclose(test);
   printf("Open %s\n", name);
   wad=BasicOpen(name);

   l=0;
   for (n=0; n < wad->dirsize; n++) if(firsttime)
   {
      mdir=Memory(sizeof(struct MasterDirectory));
      mdir->next=0L;
      mdir->wad=wad;
      memcpy(&(mdir->dir), &(wad->directory[n]), sizeof(struct Directory));
      if (MasterDir) lastp->next=mdir;
      else MasterDir=mdir;
      lastp=mdir;
   } else
   { static int map=0;
      strncpy(entryname, wad->directory[n].name, 8);
      entryname[8]='\0';
      if (l==0&&!map)
      {  mdir=FindMasterDir(MasterDir, wad->directory[n].name);
            if(mdir==0)
            {
            printf("   Add %s\n", entryname);
            mdir=MasterDir;
            while (mdir->next) mdir=mdir->next;
            mdir->next=Memory(sizeof(struct MasterDirectory));
            mdir=mdir->next; mdir->next=0L;
            } else { printf("   Update %s\n", entryname);
            if(entryname[0]==(doom1?'E':'M')&&entryname[2]==(doom1?'M':'P')) map=10;
            }
      }
      else
      {
         mdir=mdir->next;
         if (mdir==0L || strncmp(mdir->dir.name, wad->directory[n].name, 8))
            mdir=0,mdir->next=0;
         l--;map--;
      }
         mdir->wad=wad;
         memcpy(&(mdir->dir), &(wad->directory[n]), sizeof(struct Directory));
   }
   doom1=(FindMasterDir(MasterDir,"E3M1")!=0); firsttime=0;
}

void CloseUnusedWads()
{
   WadPtr curw, prevw;
   MDirPtr mdir;

   prevw=0L;
   curw=WadList;
   while (curw)
   {
      mdir=MasterDir;
      while (mdir && mdir->wad != curw)
         mdir=mdir->next;
      if (mdir)
         prevw=curw;
      else
      {
         if (prevw)
            prevw->next=curw->next;
         else
            WadList=curw->next;
         fclose(curw->fileinfo);
         free(curw->directory);
         free(curw);
      }
      curw=prevw->next;
   }
}

void BasicWadRead(WadPtr wad, void *addr, long size)
{ fread(addr, 1, size, wad->fileinfo); }
void BasicWadSeek(WadPtr wad, long offset)
{ fseek(wad->fileinfo, offset, 0); }

MDirPtr FindMasterDir(MDirPtr from, char *name)
{
   while (from)
   {
      if (!strncmp(from->dir.name, name, 8))
         break;
      from=from->next;
   }
   return from;
}

void BuildNewWad(char *name)
{
   FILE *file;
   MDirPtr cur;
   long size, dirstart, dirnum, counter=12;

   printf("Build WAD %s\n", name);
   if ((file=fopen(name, "wb"))==0L)
      ProgError("open error");
   WriteBytes(file, "IWAD", 4);
   WriteBytes(file, &counter, 4L);
   WriteBytes(file, &counter, 4L);

   for (cur=MasterDir; cur; cur=cur->next)
   {
      if (cur->wad==WadList) continue;
      size=cur->dir.size;
      counter += size;
      BasicWadSeek(cur->wad, cur->dir.start);
      CopyBytes(file, cur->wad->fileinfo, size);
   }
   dirstart=counter;
   counter=12;
   dirnum=0;
   for (cur=MasterDir; cur; cur=cur->next)
   {
      if (cur->wad==WadList) continue;
      if (cur->dir.start) WriteBytes(file, &counter, 4L);
      else WriteBytes(file, &(cur->dir.start), 4L);
      WriteBytes(file, &(cur->dir.size), 4L);
      WriteBytes(file, &(cur->dir.name), 8L);
      counter += cur->dir.size;
      dirnum++;
   }
   fseek(file, 4L, 0);
   WriteBytes(file, &dirnum, 4L);
   WriteBytes(file, &dirstart, 4L);
   fclose(file);
}
void WriteBytes(FILE *file, void *addr, long size)
{
   while (size > 0x8000)
   {
      fwrite(addr,1,0x8000,file);
      addr=(char*)addr+0x8000;
      size -= 0x8000;
   }
   fwrite(addr,1,size,file);
}
void CopyBytes(FILE *dest, FILE *source, long size)
{
   void *data;
   data=Memory(0x8000 + 2);
   while (size > 0x8000)
   {
      fread(data,1,0x8000,source); fwrite(data,1,0x8000,dest);
      size -= 0x8000;
   }
   fread(data,1,size,source); fwrite(data,1,size,dest);
   free(data);
}

int Node=1, FakeCursor=0;
char *MidTexture="GRAYBIG";
char *UpTexture="GRAYBIG", *LowTexture="GRAYBIG";
char *FloorTexture="FLAT19", *CeilTexture="F_SKY1";
int FloorHeight=0, CeilHeight=256;
char *MainWad="doom2.wad", **PatchWads=0;
OptDesc options[]=
{
 { "Node",OPT_INTEGER,&Node},
 { "main",OPT_STRING,&MainWad},
 { "file",OPT_STRINGACC,&PatchWads},
 { "midtex",OPT_STRING,&MidTexture},
 { "lowtex",OPT_STRING,&LowTexture},
 { "uptex",OPT_STRING,&UpTexture},
 { "floortex",OPT_STRING,&FloorTexture},
 { "ceiltex",OPT_STRING,&CeilTexture},
 { "ceilheight",OPT_INTEGER,&CeilHeight},
 { "floorheight",OPT_INTEGER,&FloorHeight},
 { 0,OPT_END,0}
};
void AppendItemToList(char ***list, char *item)
{
   int i=0;
   if (*list != 0) { while ((*list)[i] != 0) i++;
   *list=ResizeMemory(*list, (i + 2) * sizeof(char **));
   }
   else *list=Memory(2 * sizeof(char **));
   (*list)[i]=item; (*list)[i + 1]=0;
}
void ParseCommandLine(int argc, char *argv[])
{
   int optnum;
   while (argc > 0)
   {
   if (argv[0][0]!='-'||argc<1)
   { printf("Use: CDoomedt -main wad -file wad\n"); exit(0); }
      for (optnum=0; options[optnum].opt_type != OPT_END; optnum++)
      {
         if (!stricmp(&(argv[0][1]), options[optnum].long_name))
         {
            switch (options[optnum].opt_type)
            {
            case OPT_STRING:
               argv++; argc--;
               *((char **) (options[optnum].data_ptr))=argv[0];
               break;
            case OPT_STRINGACC:
               argv++; argc--;
               AppendItemToList((char ***) options[optnum].data_ptr, argv[0]);
               break;
            }
            break;
         }
      }
      argv++; argc--;
   }
}
void ParseConfigFile()
{
   FILE *cfgfile;
   char  line[1024], *value, *option, *p;
   int   optnum;

   if ((cfgfile=fopen("CDoomedt.inf", "r"))==0)  return;
   while (fgets (line, 1024, cfgfile) != 0)
   {
      if (line[0]=='#' || strlen(line) < 2) continue;
      if (line[strlen(line)-1]=='\n') line[strlen(line)-1]='\0';
      option=line;
      while (isspace(option[0]))  option++;
      value=option;
      while (value[0] && value[0] != '=' && !isspace(value[0]))  value++;
      if (value[0]=='=') value[0]='\0'; value++;
      while (isspace(value[0])) value++;
      for (optnum=0; options[optnum].opt_type != OPT_END; optnum++)
      {
         if (!stricmp(option, options[optnum].long_name))
         {
            switch (options[optnum].opt_type)
            {
            case OPT_INTEGER:
               *((int *) (options[optnum].data_ptr))=atoi(value);
               break;
            case OPT_STRING:
               p=Memory((strlen(value) + 1) * sizeof(char));
               strcpy(p, value);
               *((char **) (options[optnum].data_ptr))=p;
               break;
            case OPT_STRINGACC:
               p=Memory((strlen(value) + 1) * sizeof(char));
               strcpy(p, value);
               AppendItemToList((char ***) options[optnum].data_ptr, p);
               break;
            }
            break;
         }
      }
   }
   fclose(cfgfile);
}
int main(int argc,char *argv[])
{
   char input[120], *com="C", *out;
   FILE *file; WadPtr wad; int p;
   argv++; argc--;
   ParseConfigFile(); ParseCommandLine(argc, argv);
   OpenWad(MainWad);
   if (PatchWads) while (PatchWads[0])
      { OpenWad(strupr(PatchWads[0])); PatchWads++; }
   for (;;)
   {
      if (!strcmp(com, "W"))
      {
         printf("%s\n", WadList->name);
         for (wad=WadList->next; wad; wad=wad->next) printf("%s\n",wad->name);
      }
      else if (!strcmp(com, "Q")) break;
      else if (!strcmp(com, "E") || !strcmp(com, "C"))
      {
         com=strtok(0, " "); p=atoi(com);
         episode=p/10;if(episode<1&&doom1)episode++;
         mission=p%10;if(mission<1&&(doom1||episode<1))mission++;
         com=strtok(input, " ");
         EditLevel(!strcmp(com, "C"));
      }

      else if (!strcmp(com, "G")||!strcmp(com,"L"))
      {p=!strcmp(com, "L");
         com=strtok(0, " ");
         if (com==0) { printf("need wad name\n"); continue; }
         if(p) { out=strtok(0," "); if (out) *out='\0';
         out=Memory((strlen(com) + 1) * sizeof(char));
         strcpy(out, com); OpenWad(out);
         CloseUnusedWads(); goto final;
         }
         for (wad=WadList; wad; wad=wad->next)
            if (!stricmp(com, wad->name)) break;
         BuildNewWad(com);
      }
      else
printf("G/L/W Group/Load/show wads\nC/E Create/Edit map\nQ   Quit\n");
final:
      printf("\n>>"); gets(input); printf("\n");
      strupr(input); com=strtok(input, " ");
   }
}