#include "deu.h"

int episode,mission,doom1;

void EditLevel(int newlevel)
{
   ReadTextures();
   InitGfx();
   CheckMouseDriver();
   if (!newlevel) ReadLevelData();
   EditorLoop();
   closegraph();
   ForgetTextures();
}

void SelectLevel()
{
   MDirPtr dir; char name[7], **levels; int n=0,epis[1],miss[1];
   dir=MasterDir;
   while (dir)
   {
      if (dir->dir.size==0 && dir->dir.name[0]==(doom1?'E':'M') && dir->dir.name[doom1?2:1]==(doom1?'M':'A') && dir->dir.name[doom1?4:5]=='\0')
      {
         if (n==0) levels=Memory(sizeof(char *));
         else levels=ResizeMemory(levels, (n+1)*sizeof(char *));
         levels[n]=dir->dir.name; n++;
      }
      dir=dir->next;
   }
   sprintf(name,doom1?"E%dM%d":"MAP%d%d",episode,mission);
   InputNameFromList(-1, -1, "Open map:", n, levels,5,name,0,0,0L);
   free(levels);
   if (*name) sscanf(name,doom1?"E%dM%d":"MAP%d%d",epis,miss);else return;
   episode=doom1?*epis:(*epis/10);if(episode<1&&doom1)episode++;
   mission=doom1?*miss:(*epis%10);if(mission<1&&(doom1||episode<1))mission++;
}
char *GetWadName()
{
   char *outfile=Memory(80), *dotp;
   WadPtr wad;

   if (! strcmp(Level->wad->name, MainWad))
   sprintf(outfile,doom1?"E%dM%d.WAD":"MAP%d%d.WAD",episode,mission);
   else strcpy(outfile, Level->wad->name);
   do InputNameFromList(-1, -1, "Save to:", 0, outfile,0,outfile,0,0,0L);
   while (!strcmp(outfile, MainWad));
   if (outfile[0]=='\0') { free(outfile); return 0L; }
   for (wad=WadList; wad; wad=wad->next)
      if (!stricmp(outfile, wad->name))
      {
         dotp=strrchr(wad->name, '.');
         if (dotp==0L) strcat(wad->name, ".BAK");
         else strcpy(dotp, ".BAK"); fclose(wad->fileinfo);
         unlink(wad->name); rename(outfile, wad->name);
         wad->fileinfo=fopen(wad->name, "rb");
         break;
      }
   return outfile;
}

void DisplayHelp()
{
   DrawScreenBox3D(228,150,405,328);
   DrawScreenText(238, 160, "Esc  Quit");
   DrawScreenText(-1, -1, "F2   Save");
   DrawScreenText(-1, -1, "E    Choose map");
   DrawScreenText(-1, -1, "F9   Insert Sectors");
   DrawScreenText(-1, -1, "F10  Check map");
   DrawScreenText(-1, -1, "Tab  Edit mode");
   DrawScreenText(-1, -1, "+/-  Scale map");
   DrawScreenText(-1, -1, "G    Scale grid");
   DrawScreenText(-1, -1, "R    Search");
   DrawScreenText(-1, -1, "C    Clear select");
   DrawScreenText(-1, -1, "O    Copy");
   DrawScreenText(-1, -1, "Ins  Insert");
   DrawScreenText(-1, -1, "Del  Delete");
   DrawScreenText(-1, -1, "Enter Edit");
   DrawScreenText(-1, -1, "M/Mouse left  Select");
   DrawScreenText(-1, -1, "D/Mouse right Drag");
   bioskey(0);
}
void DrawMap(int,int);
int MAPX(x) { return (OrigX+(int)((x-ScrCenterX)/Scale)); }
int MAPY(y) { return (OrigY+(int)((ScrCenterY-y)/Scale)); }
int SCREENX(x) { return (ScrCenterX+(int)((x-OrigX)*Scale)); }
int SCREENY(y) { return (ScrCenterY+(int)((OrigY-y)*Scale)); }
void EditorLoop()
{
  int EditMode=OBJ_THING,CurObject=-1,OldObject=-1,key,altkey,buttons,oldbuttons=0,GridScale=0;
  int DragObject=0,StretchSelBox=0,SelBoxX=0,SelBoxY=0,OldPointerX=0,OldPointerY=0,RedrawMap=1,scrlock;
  SelPtr Selected=0L;
  char keychar,*outfile;

  Changed=0; MapChanged=0; Scale=0.125;
  CenterCoords((MapMinX+MapMaxX)/2,(MapMinY+MapMaxY)/2);
  if (!UseMouse) FakeCursor=1;

   for (;;)
   {
      key=0; altkey=0;
      if (UseMouse)
      {
         if (FakeCursor) DrawPointer();
         GetMouseCoords(&PointerX, &PointerY, &buttons);
         if (FakeCursor) DrawPointer();
         if (buttons==1 && PointerY<17)
         { altkey=8;
	if (PointerX<60) key=0x2100;
	else if (PointerX<108) key=0x1200;
	else if (PointerX<172) key=0x3200;
	else if (PointerX<228) key=0x1700;
	else if (PointerX<276) key=0x1800;
	else if (PointerX<348) key=0x2E00;
	else key=0x2300;
         }
         else
         {
            if (buttons!=oldbuttons)
            {
               switch (buttons)
               {
	case 1: key='m'; break;
	case 2: key='d'; break;
	default: if (StretchSelBox) key='m'; if (DragObject) key='d';
	}
	altkey=bioskey(2);
            }
         }
         oldbuttons=buttons;
      }

      if (DragObject)
      {
         int forgetit=0;
         if (IsSelected(Selected, CurObject)==0)
	ForgetSelection(&Selected);
         else if (Selected->objnum!=CurObject)
         {
            UnSelectObject(&Selected, CurObject);
            SelectObject(&Selected, CurObject);
         }
         if (Selected==0L && CurObject>=0)
         { SelectObject(&Selected, CurObject); forgetit=1; }
         if (Selected)
         {
            if (MoveObjectsToCoords(EditMode,Selected,MAPX(PointerX),MAPY(PointerY),GridScale))
	RedrawMap=1;
            if (forgetit) ForgetSelection(&Selected);
         } else DragObject=0;
      }
      else if (StretchSelBox)
      {
	int x=MAPX(PointerX), y=MAPY(PointerY),n=0;
	setcolor(CYAN); setwritemode(XOR_PUT);
	ShowMousePointer(1);
	for(;++n<3;){
	DrawMapLine(SelBoxX, SelBoxY, SelBoxX, y);
	DrawMapLine(SelBoxX, y, x, y);
	DrawMapLine(x, y, x, SelBoxY);
	DrawMapLine(x, SelBoxY, SelBoxX, SelBoxY);
	} setwritemode(COPY_PUT);
      }
      else {	OldObject=CurObject;
	CurObject=GetCurObject(EditMode,MAPX(PointerX-4),MAPY(PointerY-4),MAPX(PointerX+4),MAPY(PointerY+4));
	if (CurObject<0) CurObject=OldObject; }

      if (RedrawMap)
      { ShowMousePointer(1);
         DrawMap(EditMode,GridScale);
         HighlightSelection(EditMode, Selected);
      }

      if (RedrawMap || CurObject!=OldObject)
      {
         ShowMousePointer(1);
         if (!RedrawMap && OldObject>=0) HighlightObject(EditMode, OldObject, YELLOW);
         if (CurObject!=OldObject) OldObject=CurObject;
         if (CurObject>=0) HighlightObject(EditMode, CurObject, YELLOW);
         DisplayObjectInfo(EditMode, CurObject);
      }

      if (RedrawMap && FakeCursor) DrawPointer();
      if (RedrawMap || PointerX!=OldPointerX || PointerY!=OldPointerY)
      {
         setcolor(LIGHTGRAY);
         DrawScreenBox(ScrMaxX-170, 4, ScrMaxX-50, 12);
         setcolor(BLUE);
         DrawScreenText(ScrMaxX-170, 4, "%d, %d", MAPX(PointerX), MAPY(PointerY));
         OldPointerX=PointerX;
         OldPointerY=PointerY;
      }

      RedrawMap=0;
      if (bioskey(1)||key)
      {
         if (!key) { key=bioskey(0); altkey=bioskey(2); }
         if (altkey&8)
         {
	if ((key & 0xFF00)==0x2100)
	key=PullDownMenu(18, 19,
		"Save  F2", 0x3C00, (int) 'S', 1,
		"Quit  Esc", 0x001B, (int) 'Q', 1,
		0L);
	else if ((key & 0xFF00)==0x1200)
	key=PullDownMenu(66, 19,
		"Copy        O", (int) 'o', (int) 'C', 1,
		"Insert    Ins", 0x5200, (int) 'I', 1,
		"Delete    Del", 0x5300, (int) 'D', 1,
		"Search      R", (int) 'r', (int) 'S', 1,
		"Choose map  E", (int) 'e', (int) 'M', 1,
		0L);
	else if ((key & 0xFF00)==0x3200)
	key=PullDownMenu(114, 19,
		((EditMode==OBJ_THING) ?
		" Things    T" :
		"  Things    T"), (int) 't', (int) 'T', 3,
		((EditMode==OBJ_LINE) ?
		" Lines     L" :
		"  Lines     L"), (int) 'l', (int) 'L', 3,
		((EditMode==OBJ_VERTEX) ?
		" Vertexes  V" :
		"  Vertexes  V"), (int) 'v', (int) 'V', 3,
		((EditMode==OBJ_SECTOR) ?
		" Sectors   S" :
		"  Sectors   S"), (int) 's', (int) 'S', 3,
		0L);
	else if ((key & 0xFF00)==0x1700)
	MiscOperations(178, 19, EditMode, &Selected);
	else if ((key & 0xFF00)==0x1800)
	InsertStandardObject(220,19,MAPX(PointerX),MAPY(PointerY));
	else if ((key & 0xFF00)==0x2E00)
	CheckLevel(282, 19);
	else if ((key & 0xFF00)==0x2300)
	key=PullDownMenu(340, 19,
		"Keys F1",  0x3B00, (int) 'C', 3,
		0L);
	else key=0; RedrawMap=1;
         }
         keychar=key;
         if (FakeCursor) DrawPointer();
         if ((key & 0x00FF)==0x001B || keychar=='e')
         {
            if (DragObject) DragObject=0;
            else if (StretchSelBox) StretchSelBox=0;
            else
            {
	ForgetSelection(&Selected);
	if (!Changed|| Notify(1, "Quit without save?"))
	{ ForgetLevelData(); if(keychar!='e') break; else SelectLevel();
	ReadLevelData(); Changed=0; CenterCoords((MapMinX+MapMaxX)/2,(MapMinY+MapMaxY)/2);
	} RedrawMap=1;
            }
         }
         else if ((key & 0xFF00)==0x3B00) DisplayHelp(), RedrawMap=1;
         else if ((key&0xFF00)==0x3C00) { if (CheckStartingPos())
	if(outfile=GetWadName()) { SaveLevelData(outfile);
	ForgetLevelData(); ReadLevelData(); } RedrawMap=1; }
         else if ((key & 0xFF00)==0x4200) MiscOperations(-1, -1, EditMode, &Selected),RedrawMap=1;
         else if ((key & 0xFF00)==0x4300) InsertStandardObject(-1,-1,MAPX(PointerX), MAPY(PointerY)),RedrawMap=1;
         else if ((key & 0xFF00)==0x4400) CheckLevel(-1, -1), RedrawMap=1;
         else if (keychar=='-' || keychar=='=' || (keychar>= '0' && keychar<= '9'))
         {
            OrigX += (int) ((PointerX-ScrCenterX)/Scale);
            OrigY += (int) ((ScrCenterY-PointerY)/Scale);
            if(keychar>='0'&&keychar<='9') { if(keychar=='0') Scale=0.1; else Scale=1.0/(keychar-'0'); } else
            if (Scale<0.9) Scale=1.0/(1.0/Scale+(keychar=='='?-1.0:Scale<0.006?0:1.0));
            else Scale=Scale*(keychar=='-'?0.5:Scale>3?1:2);
            OrigX -= (int) ((PointerX-ScrCenterX)/Scale);
            OrigY -= (int) ((ScrCenterY-PointerY)/Scale);
            RedrawMap=1;
         }
         else if ((key & 0xFF00)==0x4800) PointerY -= 7;
         else if ((key & 0xFF00)==0x5000) PointerY += 7;
         else if ((key & 0xFF00)==0x4B00) PointerX -= 7;
         else if ((key & 0xFF00)==0x4D00) PointerX += 7;
         else if ((key & 0xFF00)==0x4900 && MAPY(ScrCenterY)<MapMaxY)
            OrigY += (int) (ScrCenterY/Scale), RedrawMap=1;
         else if ((key & 0xFF00)==0x5100 && MAPY(ScrCenterY)>MapMinY)
            OrigY -= (int) (ScrCenterY/Scale), RedrawMap=1;
         else if ((key & 0xFF00)==0x4700 && MAPX(ScrCenterX)>MapMinX)
            OrigX -= (int) (ScrCenterX/Scale), RedrawMap=1;
         else if ((key & 0xFF00)==0x4F00 && MAPX(ScrCenterX)<MapMaxX)
            OrigX += (int) (ScrCenterX/Scale), RedrawMap=1;
         else if ((key&0xFF00)==0x0F00 || keychar=='t' || keychar=='v' || keychar=='l' || keychar=='s' || keychar=='c')
         {
	if ((key & 0x00FF)==9)
	{
	switch (EditMode)
	{
	case OBJ_THING: EditMode=OBJ_VERTEX; break;
	case OBJ_VERTEX: EditMode=OBJ_LINE; break;
	case OBJ_LINE: EditMode=OBJ_SECTOR; break;
	case OBJ_SECTOR: EditMode=OBJ_THING;
	}
	}
	else
	{
	if (keychar=='t') EditMode=OBJ_THING;
	else if (keychar=='v') EditMode=OBJ_VERTEX;
	else if (keychar=='l') EditMode=OBJ_LINE;
	else if (keychar=='s') EditMode=OBJ_SECTOR;
	}
	ForgetSelection(&Selected);
	CurObject=-1; OldObject=-1; DragObject=0; StretchSelBox=0; RedrawMap=1;
         }
         else if (keychar=='g') { if (GridScale==0) GridScale=256; else
	if (GridScale>8) GridScale /= 2; else GridScale=0; RedrawMap=1;
         }
         else if (keychar=='d')
         {
            StretchSelBox=0;
            if (DragObject) { DragObject=0;
	if (EditMode==OBJ_VERTEX) { if (Selected==0L) SelectObject(&Selected, CurObject);
	AutoDivLine(&Selected); } }
            else
            {
	DragObject=1;
	if (EditMode==OBJ_THING && CurObject>=0)
	MoveObjectsToCoords(EditMode, 0L, Things[CurObject].xpos, Things[CurObject].ypos, 0);
	else if (EditMode==OBJ_VERTEX && CurObject>=0)
	MoveObjectsToCoords(EditMode, 0L, Vertexes[CurObject].x, Vertexes[CurObject].y, 0);
	else MoveObjectsToCoords(EditMode, 0L, MAPX(PointerX), MAPY(PointerY), GridScale);
            }
         }
         else if (keychar=='r')
         {
            OldObject=InputIntegerValue(-1, -1, 0, GetMaxObjectNum(EditMode),CurObject);
            if (OldObject>=0)
            {
	CurObject=OldObject;
	GoToObject(EditMode, CurObject);
            }
            else
	OldObject=CurObject;
            RedrawMap=1;
         }
         else if (keychar=='m')
         {
            if (StretchSelBox)
            {
	SelPtr oldsel; StretchSelBox=0;
	RedrawMap=1; oldsel=Selected;
	Selected=SelectObjectsInBox(EditMode, SelBoxX, SelBoxY, MAPX(PointerX), MAPY(PointerY));
	   while (oldsel!=0L)
	   {
	      if (! IsSelected(Selected, oldsel->objnum))
	         SelectObject(&Selected, oldsel->objnum);
	      UnSelectObject(&oldsel, oldsel->objnum);
	   }
	if (Selected) CurObject=Selected->objnum;
	else CurObject=-1;
            }
            else
            {
              if (IsSelected(Selected,CurObject))
              UnSelectObject(&Selected,CurObject);
              else SelectObject(&Selected,CurObject);
              SelBoxX=MAPX(PointerX); SelBoxY=MAPY(PointerY);
              StretchSelBox=1; DragObject=0;
            }
         }
         else if (keychar=='o' && CurObject>=0)
         {
            if (Selected==0L) SelectObject(&Selected, CurObject);
            CopyObjects(EditMode, Selected);
            DragObject=1;
            CurObject=Selected->objnum;
            if (EditMode==OBJ_THING)
	MoveObjectsToCoords(EditMode, 0L, Things[CurObject].xpos, Things[CurObject].ypos, 0);
            else if (EditMode==OBJ_VERTEX)
	MoveObjectsToCoords(EditMode, 0L, Vertexes[CurObject].x, Vertexes[CurObject].y, 0);
            else
	MoveObjectsToCoords(EditMode, 0L, MAPX(PointerX), MAPY(PointerY), GridScale);
            RedrawMap=1; StretchSelBox=0;
         }
         else if ((key & 0x00FF)==0x000D && CurObject>=0)
         {
            if (Selected) EditObjectsInfo(0, 30, EditMode, Selected);
            else
            {
	SelectObject(&Selected, CurObject);
	EditObjectsInfo(0, 30, EditMode, Selected);
	UnSelectObject(&Selected, CurObject);
            }
            DragObject=0; StretchSelBox=0; RedrawMap=1;
         }
         else if ((key & 0xFF00)==0x5300 && CurObject>=0)
         {
	if (Selected) DeleteObjects(EditMode, &Selected);
	else DeleteObject(EditMode, CurObject);
	CurObject=-1; DragObject=0; StretchSelBox=0; RedrawMap=1;
         }
         else if ((key & 0xFF00)==0x5200)
         {
            SelPtr cur;
            if (EditMode==OBJ_LINE && Selected!=0L)
            {
	   EditMode=OBJ_SECTOR;
	   InsertObject(OBJ_SECTOR, -1, 0, 0);
	   CurObject=NumSectors-1;
	   for (cur=Selected; cur; cur=cur->next)
	   {
	      InsertObject(OBJ_SIDE, -1, 0, 0);
	      Sides[NumSides-1].sector=CurObject;
	      if (Lines[cur->objnum].side1>=0)
	      {
	         int s;
	         s=Sides[Lines[cur->objnum].side1].sector;
	         if (s>=0)
	         {
	            Sectors[CurObject].floorh=Sectors[s].floorh;
	            Sectors[CurObject].ceilh=Sectors[s].ceilh;
	            strncpy(Sectors[CurObject].floort, Sectors[s].floort, 8);
	            strncpy(Sectors[CurObject].ceilt, Sectors[s].ceilt, 8);
	            Sectors[CurObject].light=Sectors[s].light;
	         }
	         Lines[cur->objnum].side2=NumSides-1;
	         Lines[cur->objnum].flags=4;
	         strncpy(Sides[NumSides-1].tex3, "-", 8);
	         strncpy(Sides[Lines[cur->objnum].side1].tex3, "-", 8);
	      }
	      else
	         Lines[cur->objnum].side1=NumSides-1;
	   }
	   ForgetSelection(&Selected);
	   SelectObject(&Selected, CurObject);
            }
            else
            {
	ForgetSelection(&Selected);
	InsertObject(EditMode, CurObject,GridScale<8? (MAPX(PointerX)): (MAPX(PointerX)+GridScale/2)&~(GridScale-1),
	GridScale<8? (MAPY(PointerY)): (MAPY(PointerY)+GridScale/2)&~(GridScale-1));
	CurObject=GetMaxObjectNum(EditMode);
	if (EditMode==OBJ_LINE)
	{
	if (!Input2Numbers("vert 1", "vert 2",NumVertexes-1,NumVertexes-1,
	&(Lines[CurObject].start), &(Lines[CurObject].end)))
	{ DeleteObject(EditMode, CurObject); CurObject=-1; }
	}
            }
            DragObject=0; StretchSelBox=0; RedrawMap=1;
         }
         if (FakeCursor) DrawPointer();
      }
      scrlock=(bioskey(2)&0x10)==0;
      if (PointerY<8) { PointerY+=7;
	if (MAPY(ScrCenterY)<MapMaxY&&scrlock) { OrigY+=(int)(14.0/Scale); RedrawMap=1; }
      }
      if (PointerY>ScrMaxY-8) { PointerY-=7;
	if (MAPY(ScrCenterY)>MapMinY&&scrlock) { OrigY-=(int)(14.0/Scale); RedrawMap=1; }
      }
      if (PointerX<8) { PointerX+=7;
	if (MAPX(ScrCenterX)>MapMinX&&scrlock) { OrigX-=(int)(14.0/Scale); RedrawMap=1; }
      }
      if (PointerX>ScrMaxX-8) { PointerX-=7;
	if (MAPX(ScrCenterX)<MapMaxX&&scrlock) { OrigX+=(int)(14.0/Scale); RedrawMap=1; }
      } ShowMousePointer(0);
   }
}
void LineAttr2(int m) { if (Sectors[m].tag>0) setcolor(LIGHTGREEN); else if (Sectors[m].special>0) setcolor(LIGHTCYAN); }
void LineAttr(int n) { if (Lines[n].flags&4) setcolor(LIGHTGRAY); else setcolor(WHITE); }
void DrawAttr(int n) { DrawMapLine(Vertexes[Lines[n].start].x,Vertexes[Lines[n].start].y,Vertexes[Lines[n].end].x,Vertexes[Lines[n].end].y); }
void DrawMap(int editmode, int grid)
{
   int n,m;
   cleardevice();
   if (grid>16)
   {
      int mapx0=MAPX(0) & ~(grid-1);
      int mapx1=(MAPX(ScrMaxX)+grid) & ~(grid-1);
      int mapy0=(MAPY(ScrMaxY)-grid) & ~(grid-1);
      int mapy1=MAPY(0) & ~(grid-1);
      setcolor(BLUE);
      for (n=mapx0; n<=mapx1; n+=grid)
         DrawMapLine(n, mapy0, n, mapy1);
      for (n=mapy0; n<=mapy1; n+=grid)
         DrawMapLine(mapx0, n, mapx1, n);
   }

   switch (editmode)
   {
   case OBJ_THING:
      for (n=0; n<NumLines; n++) { LineAttr(n); DrawAttr(n); }
      break;
   case OBJ_VERTEX:
      setcolor(LIGHTGRAY);
      for (n=0; n<NumLines; n++) DrawAttr(n);
      break;
   case OBJ_LINE:
      for (n=0; n<NumLines; n++)
      {
         if (Lines[n].type>0)
         {
	if (Lines[n].tag>0) setcolor(LIGHTMAGENTA);
	else setcolor(LIGHTGREEN);
         }
         else LineAttr(n); DrawAttr(n);
      }
      break;
   case OBJ_SECTOR:
      for (n=0; n<NumLines; n++)
      {
         if ((m=Lines[n].side1)<0) setcolor(RED);
         else { LineAttr(n); LineAttr2(m=Sides[m].sector); if ((m=Lines[n].side2)>=0)
	LineAttr2(m=Sides[m].sector); } DrawAttr(n);
      }
      break;
   }

   if (editmode==OBJ_VERTEX)
   {
      setcolor(LIGHTGREEN);
      for (n=0; n<NumVertexes; n++)
      {
         DrawMapLine(Vertexes[n].x-3, Vertexes[n].y-3, Vertexes[n].x+3, Vertexes[n].y+3);
         DrawMapLine(Vertexes[n].x+3, Vertexes[n].y-3, Vertexes[n].x-3, Vertexes[n].y+3);
      }
   }
   if (editmode==OBJ_THING)
   {
      for (n=0; n<NumThings; n++)
      {
         m=ThingRadius(Things[n].type);
         setcolor(ThingColour(Things[n].type));
         DrawMapLine(Things[n].xpos-m, Things[n].ypos, Things[n].xpos+m, Things[n].ypos);
         DrawMapLine(Things[n].xpos, Things[n].ypos-m, Things[n].xpos, Things[n].ypos+m);
         DrawMapCircle(Things[n].xpos, Things[n].ypos, m);
      }
   }
   else
   {
      setcolor(LIGHTGRAY);
      for (n=0; n<NumThings; n++)
      {
         DrawMapLine(Things[n].xpos-3, Things[n].ypos, Things[n].xpos+3, Things[n].ypos);
         DrawMapLine(Things[n].xpos, Things[n].ypos-3, Things[n].xpos, Things[n].ypos+3);
      }
   }
   DrawScreenBox3D(0, 0, ScrMaxX, 16);
   setcolor(WHITE);
   DrawScreenText(20, 4, "File  Edit  Modes  Misc  Objects  Check  Help");
   DrawScreenText(20, 6, "_     _     _       _    _        _      _");
   DrawScreenBox3D(0, ScrMaxY-11, ScrMaxX, ScrMaxY);
   DrawScreenText(20,ScrMaxY-8,"Mode %ss on %s     Free mem: %lu        Scale: %d/%d     Grid: %d",
ObjectTypeName(editmode),Level->dir.name,coreleft(),Scale>1.0?(int)Scale:1,Scale<1.0?(int)(1.0/Scale+0.5):1,grid);
}

void CenterCoords(int xpos, int ypos)
{ OrigX=xpos;OrigY=ypos;PointerX=ScrCenterX;PointerY=ScrCenterY; }

void GoToObject(int objtype, int objnum)
{
   int xpos, ypos;
   GetObjectCoords(objtype,objnum,&xpos,&ypos);
   CenterCoords(xpos,ypos);
   if (UseMouse) SetMouseCoords(PointerX,PointerY);
}