#include "deu.h"

int val;
void SectorsMenu(int x0, int y0,int objnum, int edit)
{ int n,tag,dummy[30]; char *menustr[30],texname[9];
  for (n=0; n<8; n++) menustr[n]=Memory(60);
  sprintf(menustr[7], edit?"Edit Sector %d":"Sector %d", objnum);
  sprintf(menustr[0], "Floor height:  %d", Sectors[objnum].floorh);
  sprintf(menustr[1], "Ceil height:   %d", Sectors[objnum].ceilh);
  texname[8]='\0'; strncpy(texname, Sectors[objnum].floort, 8);
  sprintf(menustr[2], "Floor texture: %s", texname);
  strncpy(texname, Sectors[objnum].ceilt, 8);
  sprintf(menustr[3], "Ceil texture:  %s", texname);
  sprintf(menustr[4], "Light level:   %d", Sectors[objnum].light);
  sprintf(menustr[5], "Type:  %d %s", Sectors[objnum].special,SectorType(Sectors[objnum].special));
  tag=Sectors[objnum].tag; if(tag) { for(n=0;n<NumLines;n++) if(Lines[n].tag==tag)break; } else n=NumLines;
  sprintf(menustr[6], n<NumLines?"Tag:   %d (%d)":"Tag:   %d",Sectors[objnum].tag,n);
  val=DisplayMenuArray(x0, y0, menustr[7], 7, 0L, menustr, dummy, edit);
  for (n=0; n<8; n++) free(menustr[n]);
}
void SidesMenu(int x0, int y0,int objnum, int edit, int side)
{ int n,dummy[30]; char *menustr[30],texname[9];
  for (n=0; n<7; n++) menustr[n]=Memory(60);
  sprintf(menustr[6], edit?"Edit Side %d":side?"2nd Side %d":"1st Side %d", objnum);
  texname[8]='\0'; strncpy(texname, Sides[objnum].tex3, 8);
  sprintf(menustr[0], "Mid texture: %s", texname);
  strncpy(texname, Sides[objnum].tex1, 8);
  sprintf(menustr[1], "Up texture:  %s", texname);
  strncpy(texname, Sides[objnum].tex2, 8);
  sprintf(menustr[2], "Low texture: %s", texname);
  sprintf(menustr[3], "Xoffset:     %d", Sides[objnum].xoff);
  sprintf(menustr[4], "Yoffset:     %d", Sides[objnum].yoff);
  sprintf(menustr[5], "Sector:      %d", Sides[objnum].sector);
  val=DisplayMenuArray(x0, y0, menustr[6], 6, 0L, menustr, dummy, edit);
  for (n=0; n<7; n++) free(menustr[n]);
}
void ThingsMenu(int x0, int y0, int objnum, int edit)
{ int n,dummy[30]; char *menustr[30];
  for (n=0; n<5; n++) menustr[n]=Memory(60);
  sprintf(menustr[4], edit?"Edit Thing %d":"Thing %d", objnum);
  sprintf(menustr[0], "Type:     %s", ThingName(Things[objnum].type));
  sprintf(menustr[1], "Angle:    %s", AngleName(Things[objnum].angle));
  sprintf(menustr[2], "When:     %s", WhenName(Things[objnum].when));
  sprintf(menustr[3], "Coords:   (%d,%d)", Things[objnum].xpos,Things[objnum].ypos);
  val=DisplayMenuArray(x0, y0, menustr[4], 4, 0L, menustr, dummy,edit);
  for (n=0; n<5; n++) free(menustr[n]);
}
void LinesMenu(int x0, int y0, int objnum, int edit, int s1, int s2)
{ int n,tag,dummy[30]; char *menustr[30];
  for (n=0; n<7; n++) menustr[n]=Memory(60);
  sprintf(menustr[6], edit?"Edit Line %d":"Line %d", objnum);
  sprintf(menustr[0], "Flags: %d %s", Lines[objnum].flags, LineFlagsName(Lines[objnum].flags));
  sprintf(menustr[1], "Type:  %d %s", Lines[objnum].type, LineType(Lines[objnum].type));
  tag=Lines[objnum].tag;
  if (tag) { for (n=0; n<NumSectors; n++) if (Sectors[n].tag==tag) break; } else n=NumSectors;
  sprintf(menustr[2], n<NumSectors?"Tag:   %d (%d)":"Tag:   %d",tag,n);
  sprintf(menustr[3], "Vertexes: (%d,%d)", Lines[objnum].start, Lines[objnum].end);
  sprintf(menustr[4], "1st Side: %d", Lines[objnum].side1);
  sprintf(menustr[5], edit?"2nd Side: %d":"2nd Side: %d Length:%d", Lines[objnum].side2,
  ComputeDist(Vertexes[s2].x-Vertexes[s1].x, Vertexes[s2].y-Vertexes[s1].y));
  val=DisplayMenuArray(x0, y0, menustr[6], 6, 0L, menustr, dummy,edit);
  for (n=0; n<7; n++) free(menustr[n]);
}
void DisplayObjectInfo(int objtype, int objnum)
{
   int n,sd,sd1,sd2,x0; if (objnum<0) return;
   switch (objtype)
   {
   case OBJ_THING: ThingsMenu(0,407,objnum,0); break;
   case OBJ_LINE:
	LinesMenu(0,387,objnum,0,Lines[objnum].start,Lines[objnum].end);
	sd1=Lines[objnum].side1; sd2=Lines[objnum].side2;
	for(n=-1;n<1;n++) { x0=n?440:220;
	if ((sd=n?sd2:sd1)>-1) SidesMenu(x0,387,sd,0,n);
	else { DrawScreenBox3D(x0, 387, x0+218, 467); setcolor(DARKGRAY);
	DrawScreenText(x0+45, 422, n?"(No 2nd Side)":"(No 1st Side)"); }
	} break;
   case OBJ_VERTEX:
	DrawScreenBox3D(0,437,218,467); setcolor(YELLOW);
	DrawScreenText(5,442, "Vertex %d", objnum); setcolor(BLACK);
	DrawScreenText(-1,457, "Coords:   (%d,%d)", Vertexes[objnum].x, Vertexes[objnum].y);
	break;
   case OBJ_SECTOR: SectorsMenu(0, 377, objnum, 0);
   }
}

int DisplayObjMenu(int x0, int y0, int type, char *menutitle, ...)
{
   va_list args; int num=0, objid[30], dummy[30]; char *menustr[30];
   va_start(args,menutitle);
   while ((num<30) && ((objid[num]=va_arg(args, int))>=0))
   {
      menustr[num]=type?LineType(objid[num]):ThingName(objid[num]);
      num++;
   }
   va_end(args);
   val=DisplayMenuArray(x0,y0,menutitle, num, 0L, menustr, dummy,1)-1;
   if (val<0 || val>=num)  return -1;
   return objid[val];
}

char *LineFlag(int linenum, int flagndx)
{
   static char ldstr[9][50];
   if ((Lines[linenum].flags & (0x01<<(flagndx-1)))!=0)
   strcpy(ldstr[flagndx-1],"\04 "); else strcpy(ldstr[flagndx-1], "  ");
   strcat(ldstr[flagndx-1], LineFlagsName(0x01<<(flagndx-1)));
   return ldstr[flagndx-1];
}

void EditObjectsInfo(int x0, int y0, int objtype, SelPtr obj)
{
   char texname[9]; int n,m; SelPtr cur, sdlist;
   if (obj==0L) return;
   switch (objtype)
   {
   case OBJ_THING: ThingsMenu(x0,y0,obj->objnum,1);
      switch (val)
      {
      case 1:
         switch (DisplayMenu(x0+42, y0+34, "Choose Class",
	"Player","Enemy","Weapon","Bonus","Misc","Lights","Deads","Hang bodies",
	"Special",0L))
         {
         case 1:
	val=DisplayObjMenu(x0+84, y0+68, 0, 0L,PLAY1,PLAY2,PLAY3,PLAY4,DMATCH,-1);
	break;
         case 2:
	val=DisplayObjMenu(x0+84, y0+78, 0, 0L,HUMAN,SARGT,DUDE,IMP,SKEL,DEMON,SPECTR,BARON,
	KNIGHT,LSOUL,CACO,PAIN,ARACHN,VILE,MANCUBUS,SS,CYBER,SPIDER,-1);
	break;
         case 3:
	val=DisplayObjMenu(x0+84, y0+88, 0, 0L,SGUN,SSGUN,CGUN,LAUNC,PLASMA,SAW,SHELLS,AMMO,
	ROCKET,CELL,BFG,SHELLBOX,AMMOBOX,ROCKETBOX,CELLPACK,BACKPACK,-1);
	break;
         case 4:
	val=DisplayObjMenu(x0+84, y0+98, 0, 0L,REDCARD,YELCARD,BLUECARD,REDSKULL,YELSKULL,
	BLUESKULL,ARMBONUS,GREENARM,BLUEARM,HLTBONUS,STIMPACK,MEDKIT,SOULSPH,MEGASPH,
	INVIS,MAP,RADSUIT,LITEAMP,BESERK,INVULN,-1);
	break;
         case 5:
	val=DisplayObjMenu(x0+84, y0+108, 0, 0L,BARREL,FUELCAN,TECHCOL,TGREENCOL,TREDCOL,
	SGREENCOL,SREDCOL,COLHEART,COLSKULL,EYE,STUB,GREYTREE,TREE,-1);
	break;
         case 6:
	val=DisplayObjMenu(x0+84, y0+118, 0, 0L,CANDLE,CANDELABR,TALLLAMP,TALLLAMP2,TBLUETORCH,
	TGREENTORCH,TREDTORCH,SBLUETORCH,SGREENTORCH,SREDTORCH,-1);
	break;
         case 7:
	val=DisplayObjMenu(x0+84, y0+128, 0, 0L,DEADPLAY,DEADHUMAN,DEADSARGT,DEADIMP,DEADDEM,
	DEADCACO,BONES,BONES2,POOLBLOOD,SKULLPOLE,HEADSKEWER,PILESKULLS,
	IMPALEDBODY,IMPALEDBODY2,SKULLSFLAMES,-1);
	break;
         case 8:
	val=DisplayObjMenu(x0+84, y0+138, 0, 0L,SWAY,ARMSOUT,ONELEG,TORSO,LEG,SWAY2,ARMSOUT2,
	ONELEG2,TORSO2,LEG2,GARFIELD,DEADVILE1,DVILE2,DVILE3,DVILE4,DVILE5,DVILE6,KEEN,-1);
	break;
         case 9:
	val=DisplayObjMenu(x0+84, y0+138, 0, 0L,TELEPT,SPAWNSRC,SPAWNSPOT,BOSS,-1);
         }
         if (val>=0) { for (cur=obj; cur; cur=cur->next) Things[cur->objnum].type=val; Changed=1; }
         break;
      case 2: n=-1;
         n=DisplayMenu(x0+42, y0+44, "Choose Angle",
	"East","NorthEast","North","NorthWest","West","SouthWest","South","SouthEast",
	0L);
        if(--n>=0) for (cur=obj; cur; cur=cur->next) Things[cur->objnum].angle=n*45;
        Changed=1;  break;
      case 3:
         val=DisplayMenu(x0+42, y0+54, "Choose skill",
	"D12          Easy","D3           Medium","D12, D3      Easy, Medium","D45          Hard",
	"D12, D45     Easy, Hard","D3, D45      Medium, Hard","D12, D3, D45 Easy, Medium, Hard",
	"Change Deaf","Change Multi","Enter decimal",0L);
	if (val>0&&val<10) { for (cur=obj; cur; cur=cur->next)
	if (val<8) Things[cur->objnum].when=(Things[cur->objnum].when & 0x18) | val;
	else if (val<9) Things[cur->objnum].when ^=8; else Things[cur->objnum].when ^=16;
	Changed=1; break; }
	if (val==10) { val=InputIntegerValue(x0+84, y0+158, 1, 31, Things[obj->objnum].when);
	if (val>0) { for (cur=obj; cur; cur=cur->next) Things[cur->objnum].when=val; Changed=1; } }
         break;
      case 4: m=n=0;
         val=Input2Numbers("xpos","ypos", 0, 0, &m, &n);
         if (val)
         {
	m-=Things[obj->objnum].xpos; n-=Things[obj->objnum].ypos;
	for (cur=obj; cur; cur=cur->next)
	Things[cur->objnum].xpos+=m,Things[cur->objnum].ypos+=n;
	Changed=1;
         }
      }
      break;
   case OBJ_VERTEX: m=n=0;
         val=Input2Numbers("xpos", "ypos",0,0,&m,&n);
         if (val)
         {
	m-=Vertexes[obj->objnum].x; n-=Vertexes[obj->objnum].y;
	for (cur=obj; cur; cur=cur->next)
	Vertexes[cur->objnum].x+=m,Vertexes[cur->objnum].y+=n;
	Changed=1; MapChanged=1;
        }
      break;
   case OBJ_LINE:
      switch (DisplayMenu(x0, y0, 0L,"Edit Line",
	(Lines[obj->objnum].side1>=0)?"Edit 1st Side":"Add 1st Side",
	(Lines[obj->objnum].side2>=0)?"Edit 2nd Side":"Add 2nd Side",
	0L))
      {
      case 1: LinesMenu(x0+42,y0+34,obj->objnum,1,0,0);
         switch (val)
         {
         case 1:
	val=DisplayMenu(x0+84, y0+68, "Change flags:",
	LineFlag(obj->objnum, 1),LineFlag(obj->objnum, 2),LineFlag(obj->objnum, 3),
	LineFlag(obj->objnum, 4),LineFlag(obj->objnum, 5),LineFlag(obj->objnum, 6),
	LineFlag(obj->objnum, 7),0L);
	if (val>=1) { for (cur=obj; cur; cur=cur->next)
	Lines[cur->objnum].flags^=1<<(val-1); Changed=1; }
	break;
         case 2:
	switch (DisplayMenu(x0+84, y0+78, "Choose type",
	"None","Doors","Turbo Doors, Floors","Ceils","Floors Raise","Floors Lower",
	"Lifts, Crush","Special","Enter decimal",0L))
	{
	case 1: val=0;
	break;
	case 2:
	val=DisplayObjMenu(x0+126, y0+122, 1, 0L,
1, 26, 27, 28, 63, 29, 90, 4, 31, 32, 34, 33, 61, 103, 50, 86, 2, 46, 42, 75, 3, 76, 16, -1);
	break;
	case 3:
	val=DisplayObjMenu(x0+126, y0+122, 1, 0L,
105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 133, 99, 135, 134, 137, 136, 130, 129, 131, 132, -1);
	break;
	case 4:
	val=DisplayObjMenu(x0+126, y0+132, 1, 0L,
43, 41, 72, 44, 40, 141,-1);
	break;
	case 5:
	val=DisplayObjMenu(x0+126, y0+122, 1, 0L,
69, 18, 140, 20, 22, 95, 47, 5, 14, 30, 93, 59, 66, 67, 15, 92, 58, 96, 64, 101, 91, 24, 65, 94, 55, 56, 128, 119, -1);
	break;
	case 6:
	val=DisplayObjMenu(x0+126, y0+142, 1, 0L,
45, 60, 102, 82, 83, 19, 38, 70, 71, 98, 36, 23, 84, 68, 37, 9, 21, 85, -1);
	break;
	case 7:
	val=DisplayObjMenu(x0+126, y0+152, 1, 0L,
62, 88, 10, 77, 6, 73, 74, 57, 87, 53, 89, 54, 7, 8, 100, 127, 120, 121, 122, 123, -1);
	break;
	case 8:
	val=DisplayObjMenu(x0+126, y0+142, 1, 0L,
281,400,403,48,11,52,51,124,97,39,125,126,81,13,79,138,35,139,12,80,104,78,17, -1);
	break;
	case 9:
	val=InputIntegerValue(x0+126, y0+172, 0, 0, Lines[obj->objnum].type);
	break;
	default: val=-1;
	}
	if (val>=0)
	{
	for (cur=obj; cur; cur=cur->next)
	Lines[cur->objnum].type=val;
	Changed=1;
	}
	break;
         case 3:
	val=InputIntegerValue(x0+84, y0+88, 0, 0, Lines[obj->objnum].tag);
	if (val>=0)
	{
	for (cur=obj; cur; cur=cur->next)
	Lines[cur->objnum].tag=val;
	Changed=1;
	}
	break;
         case 4: m=n=0;
	val=Input2Numbers("vert 1", "vert 2",0,0,&m,&n);
	if (val)
	{
	for (cur=obj; cur; cur=cur->next)
	Lines[cur->objnum].start=m,Lines[cur->objnum].end=n;
	Changed=1; MapChanged=1;
	}
	break;
         case 5:case 6:
	m=InputIntegerValue(x0+84, y0+118, -1, NumSides-1, val==5?Lines[obj->objnum].side1:
	Lines[obj->objnum].side2);
	if (m>=-1)
	{
	for (cur=obj; cur; cur=cur->next)
	if (val==5) Lines[cur->objnum].side1=m;
	else Lines[cur->objnum].side2=m;
	Changed=1; MapChanged=1;
	}
         }
         break;

      case 2:
         if (Lines[obj->objnum].side1>=0)
         {
	objtype=OBJ_SIDE;
	sdlist=0L;
	for (cur=obj; cur; cur=cur->next)
	if (Lines[cur->objnum].side1>=0)
	SelectObject(&sdlist, Lines[cur->objnum].side1);
         }
         else
         {
	for (cur=obj; cur; cur=cur->next)
	if (Lines[cur->objnum].side1==-1)
	{
	InsertObject(OBJ_SIDE, -1, 0, 0);
	Lines[cur->objnum].side1=NumSides-1;
	}
	break;
         }

      case 3:
         if (objtype!=OBJ_SIDE)
         {
	if (Lines[obj->objnum].side2>=0)
	{
	objtype=OBJ_SIDE;
	sdlist=0L;
	for (cur=obj; cur; cur=cur->next)
	if (Lines[cur->objnum].side2>=0)
	SelectObject(&sdlist, Lines[cur->objnum].side2);
	else if (Lines[cur->objnum].side1>=0)
	SelectObject(&sdlist, Lines[cur->objnum].side1);
	}
	else
	{
	for (cur=obj; cur; cur=cur->next)
	if (Lines[cur->objnum].side1==-1)
	{
	InsertObject(OBJ_SIDE, -1, 0, 0);
	Lines[cur->objnum].side1=NumSides-1;
	}
	else if (Lines[cur->objnum].side2==-1)
	{
	n=Lines[cur->objnum].side1;
	InsertObject(OBJ_SIDE, -1, 0, 0);
	strncpy(Sides[NumSides-1].tex3, "-", 8);
	strncpy(Sides[n].tex3, "-", 8);
	Lines[cur->objnum].side2=NumSides-1;
	Lines[cur->objnum].flags=4;
	}
	break;
	}
         } SidesMenu(x0+42,y0+54,sdlist->objnum,1,-1);
         switch (val)
         {
         case 1:case 2:case 3:
	strncpy(texname, val==1?Sides[sdlist->objnum].tex3:val==3?Sides[sdlist->objnum].tex2:
	Sides[sdlist->objnum].tex1, 8);
	ChooseWallTexture(x0+84, y0+88, "Choose texture", NumWTexture, WTexture, texname);
	if (strlen(texname)>0)
	{
	for (cur=sdlist; cur; cur=cur->next)
	if (cur->objnum>=0)
	strncpy(val==1?Sides[cur->objnum].tex3:val==3?Sides[cur->objnum].tex2:
	Sides[cur->objnum].tex1, texname, 8);
	Changed=1;
	}
	break;
         case 4:case 5:
	m=InputIntegerValue(x0+84, y0+118, 0, 0, val==4?Sides[sdlist->objnum].xoff:
	Sides[sdlist->objnum].yoff);
	if (m>=-32700)
	{
	for (cur=sdlist; cur; cur=cur->next)
	if (cur->objnum>=0) { if (val==4) Sides[cur->objnum].xoff=m;
	else Sides[cur->objnum].yoff=m; }
	Changed=1;
	}
	break;
         case 6:
	val=InputIntegerValue(x0+84, y0+138, 0, NumSectors-1, Sides[sdlist->objnum].sector);
	if (val>=0)
	{
	for (cur=sdlist; cur; cur=cur->next)
	if (cur->objnum>=0) Sides[cur->objnum].sector=val;
	Changed=1;
	}
	break;
         }
         ForgetSelection(&sdlist);
         break;

      }
      break;

   case OBJ_SECTOR: SectorsMenu(x0,y0,obj->objnum, 1);
      switch (val)
      {
      case 1:case 2:
         m=InputIntegerValue(x0+42, y0+34, 0, 0, val==1?Sectors[obj->objnum].floorh:
	Sectors[obj->objnum].ceilh);
         if (m>=-32700)
         {
	for (cur=obj; cur; cur=cur->next)
	if (val==1) Sectors[cur->objnum].floorh=m;
	else Sectors[cur->objnum].ceilh=m;
	Changed=1;
         }
         break;
      case 3:case 4:
         strncpy(texname, val==4?Sectors[obj->objnum].ceilt:Sectors[obj->objnum].floort, 8);
         ChooseFloorTexture(x0+42, y0+54, "Choose texture", NumFTexture, FTexture, texname);
         if (strlen(texname)>0)
         {
	for (cur=obj; cur; cur=cur->next)
	strncpy(val==4?Sectors[cur->objnum].ceilt:Sectors[cur->objnum].floort, texname, 8);
	Changed=1;
         }
         break;
      case 5:case 7:
         m=InputIntegerValue(x0+42, y0+74, 0, 255, val==5?Sectors[obj->objnum].light:Sectors[obj->objnum].tag);
         if (m>=0)
         {
	for (cur=obj; cur; cur=cur->next)
	if (val==5) Sectors[cur->objnum].light=m;
	else Sectors[cur->objnum].tag=m;
	Changed=1;
         }
         break;
      case 6:
         val=DisplayMenu(x0+42, y0+84, "Choose type",
	SectorType(0),SectorType(1),SectorType(2),SectorType(3),SectorType(4),SectorType(5),SectorType(7),
	SectorType(8),SectorType(9),SectorType(10),SectorType(11),SectorType(12),SectorType(13),
	SectorType(14),SectorType(16),SectorType(17),"Enter decimal",0L);

	if (val>0&&val<17) { for (cur=obj; cur; cur=cur->next)
	Sectors[cur->objnum].special=val<7?val-1:val<15?val:val+1;
	Changed=1; }
	if (val==17) { val=InputIntegerValue(x0+84, y0+208, 0, 0, Sectors[obj->objnum].special);
	if (val>=0) { for (cur=obj; cur; cur=cur->next) Sectors[cur->objnum].special=val; Changed=1; } }
      }
   }
}

int Input2Numbers(char *name1, char *name2, int v1max, int v2max, int *v1, int *v2)
{
   int  key, maxlen, first, ok, x0;
   char prompt[80];

   sprintf(prompt, "Give the %s and %s for the object:", name1, name2);
   maxlen=strlen(prompt);
   x0=307-4*maxlen;
   DrawScreenBox3D(x0, 202, x0+25+8*maxlen, 277);
   DrawScreenText(x0+10, 228, name1);
   DrawScreenText(x0+180, 228, name2);
   DrawScreenText(x0+15, 260, "0-%-20d0-%d",v1max,v2max);
   setcolor(WHITE);
   DrawScreenText(x0+10, 210, prompt);
   first=1;
   key=0;
   for (;;)
   {
      ok=1;
      DrawScreenBox3D(x0+10, 240, x0+71, 253);
      if (v1max&&(*v1<0 || *v1>v1max))
      {
         setcolor(DARKGRAY);
         ok=0;
      }
      DrawScreenText(x0+14, 243, "%d", *v1);
      DrawScreenBox3D(x0+180, 240, x0+241, 253);
      if (v2max&&(*v2<0 || *v2>v2max))
      {
         setcolor(DARKGRAY);
         ok=0;
      }
      DrawScreenText(x0+184, 243, "%d", *v2);
      if (first) key=InputInteger(x0+10, 240, v1, 0, v1max);
      else key=InputInteger(x0+180, 240, v2, 0, v2max);
      if ((key & 0x00FF)==0x001B) break;
      if ((key & 0x00FF)==0x000D) { if (first) first=0; else if (ok) break; }
	else first=!first;
   }
   return ((key & 0x00FF)==0x000D);
}

void Statistics()
{
   DrawScreenBox3D(195, 195, 430, 280);
   DrawScreenText(215, 215, "Things:  %15d",NumThings);
   DrawScreenText(-1, -1, "Vertices:%15d",NumVertexes);
   DrawScreenText(-1, -1, "Lines:%18d",NumLines);
   DrawScreenText(-1, -1, "Sides:%18d",NumSides);
   DrawScreenText(-1, -1, "Sectors: %15d",NumSectors);
   bioskey(0);
}

void CheckingObjects()
{
   DrawScreenBox3D(234,225,434,243);
   DrawScreenText(244,230,"Checking objs, wait");
}

int CheckFailed(char *prompt1, char *prompt2)
{
   int key,maxlen=40,x0,y0;
   if (strlen(prompt1)>maxlen) maxlen=strlen(prompt1);
   if (prompt2!=0L && strlen(prompt2)>maxlen) maxlen=strlen(prompt2);
   x0=309-4*maxlen; y0=240-(prompt2?36:31);
   DrawScreenBox3D(x0, y0, x0+22+8*maxlen, y0+(prompt2?73:63));
   setcolor(WHITE);
   DrawScreenText(x0+10, y0+18, prompt1);
   if (prompt2!=0L)
      DrawScreenText(x0+10, y0+28, prompt2);
      setcolor(YELLOW);
      DrawScreenText(x0+10, y0+48, "Esc see object, other key continue");
   key=bioskey(0);
   if ((key & 0x00FF)!=0x001B) CheckingObjects();
   return ((key & 0x00FF)==0x001B);
}

void CheckSectors()
{
   int  s,m,n,sd;
   char  msg[80],*ends;

   CheckingObjects();
   ends=Memory(NumVertexes*sizeof(char));
   for (s=0; s<NumSectors; s++)
   {
      for (n=0; n<NumVertexes; n++) ends[n]=0;
      for (n=0; n<NumLines; n++)
      {
         sd=Lines[n].side1;
         if (sd>=0&&Sides[sd].sector==s) ends[Lines[n].start]|=1, ends[Lines[n].end]|=2;
         sd=Lines[n].side2;
         if (sd>=0&&Sides[sd].sector==s) ends[Lines[n].end]|=1, ends[Lines[n].start]|=2;
      }
      for (n=0; n<NumVertexes; n++)
      {
         if (ends[n]==1||ends[n]==2)
         {  for (m=0; m<NumLines; m++) if(Lines[m].end==n&&ends[n]==1||Lines[m].start==n&&ends[n]==2)break;
	sprintf(msg, "Sector %d not closed, see Line %d",s,m);
	if (CheckFailed(msg, 0L))
	{
	GoToObject(OBJ_LINE, m);
	return;
	}
         }
      }
   }
   free(ends);
   for (n=0; n<NumSectors; n++)
   {
      if (Sectors[n].ceilh<Sectors[n].floorh)
      {
	sprintf(msg, "Sector %d has Ceil Lower than floor", n);
	CheckFailed(msg, 0L);
	GoToObject(OBJ_SECTOR, n);
	return;
      }
   }
   for (n=0; n<NumLines; n++)
   {  
      if (Lines[n].side1<0)
      {
	sprintf(msg, "Line %d has no 1st Side", n);
	CheckFailed(msg, 0L);
	GoToObject(OBJ_LINE, n);
	return;
      }
   }
}

void CheckXRef()
{
   int n,m; SelPtr cur; cur=0L;
   for (n=NumLines-1; n>=1; n--)
   { int v1=Lines[n].start, v2=Lines[n].end;
      for (m=n-1; m>=0; m--)
         if ((Lines[n].start==Lines[m].start && Lines[n].end==Lines[m].end)
          ||(Lines[n].start==Lines[m].end && Lines[n].end==Lines[m].start)
          ||(Vertexes[v1].x==Vertexes[v2].x&&Vertexes[v1].y==Vertexes[v2].y))
         { SelectObject(&cur,n); break; }
   }
   if (cur) DeleteObjects(OBJ_LINE, &cur);
   for (n=0; n<NumLines; n++)
   if (Lines[n].side2<0) Lines[n].flags &=~4; else
   Lines[n].flags |=4;
   DelVert(cur);
}

void CheckTextures()
{
   int  n, sd1, sd2, s1, s2;
   char msg1[80], msg2[80];

   CheckingObjects();
   for (n=0; n<NumLines; n++)
   {
      sd1=Lines[n].side1;
      sd2=Lines[n].side2;
      if (sd1>=0) s1=Sides[sd1].sector; else s1=-1;
      if (sd2>=0) s2=Sides[sd2].sector; else s2=-1;
      if (s1>=0&&s2<0&&Sides[sd1].tex3[0]=='-'&&Sides[sd1].tex3[1]=='\0')
      {
	sprintf(msg1, "Line %d, Side %d has no Mid texture", n, sd1);
	sprintf(msg2, "Use texture %s?", MidTexture);
	if (CheckFailed(msg1, msg2))
	{
	GoToObject(OBJ_LINE, n);
	return;
	}
	strncpy(Sides[sd1].tex3, MidTexture, 8);
      }
      if (s1>=0&&s2>=0&&((Sectors[s1].ceilh>Sectors[s2].ceilh && Sides[sd1].tex1[0]=='-' && Sides[sd1].tex1[1]=='\0'||
      Sectors[s1].ceilh<Sectors[s2].ceilh && Sides[sd2].tex1[0]=='-' && Sides[sd2].tex1[1]=='\0')
      && (strncmp(Sectors[s1].ceilt,"F_SKY1",8)||strncmp(Sectors[s2].ceilt,"F_SKY1",8))||
      (Sectors[s1].floorh<Sectors[s2].floorh && Sides[sd1].tex2[0]=='-'&&Sides[sd1].tex2[1]=='\0'||
      Sectors[s2].floorh<Sectors[s1].floorh && Sides[sd2].tex2[0]=='-'&&Sides[sd2].tex2[1]=='\0')))
      {
	sprintf(msg1,Sectors[s1].ceilh>Sectors[s2].ceilh||Sectors[s1].ceilh<Sectors[s2].ceilh?
	"Line %d, Side %d has no Up texture":
	"Line %d, Side %d has no Low texture",n,Sides[sd1].tex2[0]=='-'?sd1:sd2);
	sprintf(msg2,"Use texture %s?",Sectors[s1].ceilh>Sectors[s2].ceilh||
	Sectors[s1].ceilh<Sectors[s2].ceilh?UpTexture:LowTexture);
	if (CheckFailed(msg1, msg2))
	{
	GoToObject(OBJ_LINE, n);
	return;
	}
	strncpy(Sides[Sides[sd1].tex2[0]=='-'?sd1:sd2].tex2,Sectors[s1].ceilh>Sectors[s2].ceilh||
	Sectors[s1].ceilh<Sectors[s2].ceilh?UpTexture:LowTexture,8);
      }
   }
}

int TextureValid(char *name, char **list, int numelems)
{
   int n;
   for (n=0; n<numelems; n++)
   if (! strnicmp(name, list[n], 8)) return 1;
   return 0;
}

void CheckTextureNames()
{
   int  n;
   char msg[80];

   for (n=0; n<NumSectors; n++)
   {
      if (!TextureValid(Sectors[n].ceilt,FTexture,NumFTexture)||!TextureValid(Sectors[n].floort,FTexture,NumFTexture))
      {
         sprintf(msg, "Sector %d, Name %s not flat texture",n,!TextureValid(Sectors[n].ceilt,FTexture,NumFTexture)?
	Sectors[n].ceilt:Sectors[n].floort);
         if (CheckFailed(msg,0L))
         {
	GoToObject(OBJ_SECTOR, n);
	return;
         }
      }
   }
   for (n=0; n<NumSides; n++)
   {
      if (!TextureValid(Sides[n].tex1,WTexture,NumWTexture)||
         !TextureValid(Sides[n].tex2,WTexture,NumWTexture)||
         !TextureValid(Sides[n].tex3,WTexture,NumWTexture))
      {
         sprintf(msg, "Side %d, Name %s not wall texture",!TextureValid(Sides[n].tex1,WTexture,NumWTexture)?
	Sides[n].tex1:!TextureValid(Sides[n].tex2,WTexture,NumWTexture)?Sides[n].tex2:Sides[n].tex3);
         if (CheckFailed(msg,0L))
         {
	GoToObject(OBJ_SIDE, n);
	return;
         }
      }
   }
}

void CheckLevel(int x0, int y0)
{
   switch (DisplayMenu(x0, y0, ((x0==-1)?"Check map":0L),
	"Number of objs",
	"Sectors",
	"Xreferences",
	"missing textures",
	"texture names",
	0L))
   {
   case 1: Statistics(); break;
   case 2: CheckSectors(); break;
   case 3: CheckXRef(); break;
   case 4: CheckTextures(); break;
   case 5: CheckTextureNames();
   }
}

int CheckStartingPos()
{
   int p1=0, t;
   for (t=0; t<NumThings; t++)  if (Things[t].type==PLAY1)  p1=1;
   if (!p1) return Notify(1, "Warning: no player 1, Save?");
   return 1;
}
void AdjustLine()
{
Lines[NumLines-4].start=NumVertexes-4;
Lines[NumLines-4].end=NumVertexes-3;
Lines[NumLines-3].start=NumVertexes-3;
Lines[NumLines-2].start=NumVertexes-2;
}
void InsertStandardObject(int x0, int y0, int xpos, int ypos)
{
   int sector,choice,n,a,b,l,h,xw,yh,m;
   sector=GetCurObject(OBJ_SECTOR, xpos, ypos, xpos, ypos);
      choice=DisplayMenu(x0, y0, ((x0==-1)?"Insert Sectors":0L),
       "Rectangle", "Polygon", "Stairs", 0L);
   switch (choice)
   {
   case 1:
      a=256; b=256;
      if (Input2Numbers("Width", "Height", 8000, 8000, &a, &b))
      {
         if (a<8) a=8; if (b<8) b=8;
         xpos=xpos-a/2; ypos=ypos-b/2;
         InsertObject(OBJ_VERTEX, -1, xpos, ypos);
         InsertObject(OBJ_VERTEX, -1, xpos+a, ypos);
         InsertObject(OBJ_VERTEX, -1, xpos+a, ypos+b);
         InsertObject(OBJ_VERTEX, -1, xpos, ypos+b);
         if (sector<0) InsertObject(OBJ_SECTOR, -1, 0, 0);
         for (n=0; n<4; n++)
         {
	InsertObject(OBJ_LINE, -1, 0, 0);
	Lines[NumLines-1].side1=NumSides;
	InsertObject(OBJ_SIDE, -1, 0, 0);
	if (sector>=0) Sides[NumSides-1].sector=sector;
         }
         if (sector>=0)
         { AdjustLine();
	Lines[NumLines-3].end=NumVertexes-2;
	Lines[NumLines-2].end=NumVertexes-1;
	Lines[NumLines-1].start=NumVertexes-1;
	Lines[NumLines-1].end=NumVertexes-4;
         }
         else
         {
	Lines[NumLines-4].start=NumVertexes-1;
	Lines[NumLines-4].end=NumVertexes-2;
	Lines[NumLines-3].start=NumVertexes-2;
	Lines[NumLines-3].end=NumVertexes-3;
	Lines[NumLines-2].start=NumVertexes-3;
	Lines[NumLines-2].end=NumVertexes-4;
	Lines[NumLines-1].start=NumVertexes-4;
	Lines[NumLines-1].end=NumVertexes-1;
         }
      }
      break;
   case 2:
      a=8; b=256;
      if (Input2Numbers("Number of sides", "Radius", 32, 2000, &a, &b))
      {
         if (a<3) a=3; if (b<8) b=8;
         InsertPolygonVertices(xpos, ypos, a, b);
         if (sector<0) InsertObject(OBJ_SECTOR, -1, 0, 0);
         for (n=0; n<a; n++)
         {
	InsertObject(OBJ_LINE, -1, 0, 0);
	Lines[NumLines-1].side1=NumSides;
	InsertObject(OBJ_SIDE, -1, 0, 0);
	if (sector>=0) Sides[NumSides-1].sector=sector;
         }
         if (sector>=0)
         {
	Lines[NumLines-1].start=NumVertexes-1;
	Lines[NumLines-1].end=NumVertexes-a;
	for (n=2; n<=a; n++)
	{
	Lines[NumLines-n].start=NumVertexes-n;
	Lines[NumLines-n].end=NumVertexes-n+1;
	}
         }
         else
         {
	Lines[NumLines-1].start=NumVertexes-a;
	Lines[NumLines-1].end=NumVertexes-1;
	for (n=2; n<=a; n++)
	{
	Lines[NumLines-n].start=NumVertexes-n+1;
	Lines[NumLines-n].end=NumVertexes-n;
	}
         }
      }
      break;
    case 3:
      a=8; b=24; xw=128; yh=32;
      if (!Input2Numbers("Number Of Steps", "Step Height", 64, 80, &a, &b))
        return;
      if (b<1)b=1; if (a<2)a=2;
          if (!Input2Numbers("Step Width", "Step Depth", 256, 256, &xw, &yh))
	return;
	if (xw<1)  xw=1; if (yh<1)  yh=1;
	xpos=xpos-(xw>> 1); ypos=ypos-yh*a;

      if (sector>=0) { l=Sectors[sector].ceilh; h=Sectors[sector].floorh; }
      else
        {
          l=512; h=0;
          if (!Input2Numbers("Floor Height", "Ceil Height", 0, 0, &h, &l))
	return;
        }

      for (n=0; n<a;)
        {
        if (n==0)
          {
	InsertObject(OBJ_VERTEX, -1, xpos, ypos);
	InsertObject(OBJ_VERTEX, -1, xpos+xw, ypos);
          }
          InsertObject(OBJ_VERTEX, -1, xpos, ypos+yh);
          InsertObject(OBJ_VERTEX, -1, xpos+xw, ypos+yh);
          ypos+=yh;
          InsertObject(OBJ_SECTOR, -1, 0, 0);
	if (sector<0) { if (n!=0) {  l+=b; h+=b;  }  } else h+=b;
          Sectors[NumSectors-1].floorh=h;
          if (sector<0)
	{
	  Sectors[NumSectors-1].ceilh=l;
	  for (m=0; m<4; m++)
	    {
	      if (!((m==0) && (n>0)))
	        {
	          InsertObject(OBJ_LINE, -1, 0, 0);
	          if ((m==3) && (n!=a-1))
		{
		  Lines[NumLines-1].side1=NumSides;
		  Lines[NumLines-1].side2=NumSides+1;
		  Lines[NumLines-1].flags=4;
		  InsertObject(OBJ_SIDE, -1, 0, 0);
		  strncpy(Sides[NumSides-1].tex2, LowTexture, 8);
		  strcpy(Sides[NumSides-1].tex3, "-");
		}
	          else
		Lines[NumLines-1].side1=NumSides;
	          InsertObject(OBJ_SIDE, -1, 0, 0);
	          if ((m==3) && (n!=a-1))
		{
		  Sides[NumSides-1].sector=NumSectors;
		  strncpy(Sides[NumSides-1].tex1, UpTexture, 8);
		  strcpy(Sides[NumSides-1].tex3, "-");
		}
	        }
	    }
	}
          else
	{
	  for (m=0; m<4; m++)
	    {
	      if (!((m<1) && (n>0)))
	        {
	          InsertObject(OBJ_LINE, -1, 0, 0);
	          Lines[NumLines-1].side1=NumSides;
	          Lines[NumLines-1].side2=NumSides+1;
	          InsertObject(OBJ_SIDE, -1, 0, 0);
	          if (m==3)
		{
		  Sides[NumSides-1].sector=NumSectors-1;
		  strcpy(Sides[NumSides-1].tex3, "-");
		  if (n!=a-1) strncpy(Sides[NumSides-1].tex2, LowTexture, 8);
		  InsertObject(OBJ_SIDE, -1, 0, 0);
		    if (n==a-1) {  Sides[NumSides-1].sector=sector;
		    strncpy(Sides[NumSides-1].tex2, MidTexture, 8);
		    }  else
		Sides[NumSides-1].sector=NumSectors;
		}
	          else
		{
		  Sides[NumSides-1].sector=sector;
		  strcpy(Sides[NumSides-1].tex3, "-");
		  strncpy(Sides[NumSides-1].tex2, LowTexture, 8);
		  InsertObject(OBJ_SIDE, -1, 0, 0);
		  Sides[NumSides-1].sector=NumSectors-1;
		}
	          strcpy(Sides[NumSides-1].tex3, "-");
	        }
	    }
	}
          
          if (sector>=0)
	{ AdjustLine();
	Lines[NumLines-3].end=NumVertexes-1;
	Lines[NumLines-2].end=NumVertexes-4;
	Lines[NumLines-4].flags=4;
	Lines[NumLines-3].flags=4;
	Lines[NumLines-2].flags=4;
	Lines[NumLines-1].flags=4;
	}
          else
	{
	  if (n==0)
	    {
	      Lines[NumLines-4].start=NumVertexes-3;
	      Lines[NumLines-4].end=NumVertexes-4;
	    }
	  else
	    {
	      Lines[NumLines-4].start=NumVertexes-4;
	      Lines[NumLines-4].end=NumVertexes-3;
	    }
	Lines[NumLines-3].start=NumVertexes-1;
	Lines[NumLines-3].end=NumVertexes-3;
	Lines[NumLines-2].start=NumVertexes-4;
	Lines[NumLines-2].end=NumVertexes-2;
	}n++;
          Lines[NumLines-1].start=NumVertexes-2;
          Lines[NumLines-1].end=NumVertexes-1;
        }
      break;
   }
}

void MiscOperations(int x0, int y0, int objtype, SelPtr *list)
{
   char msg[80];
   int val, angle, scale;
      val=DisplayMenu(x0, y0, ((x0==-1)?"Misc Operations":0L),
	"Free tag number","Rotate and scale",
	objtype==OBJ_VERTEX?"Merge Vertices":objtype==OBJ_LINE?"Split Line":
	objtype==OBJ_SECTOR?"Merge Sectors":0L,
	objtype==OBJ_LINE?"Flip Line":0L,
	objtype==OBJ_LINE?"Swap Sides":0L,0L);

   if (val>1 && *list==0L) { Notify(0,"must select objs"); return; }
   switch (val)
   {
   case 1:
      sprintf(msg, "Free tag number: %d", FindFreeTag()); Notify(0, msg);
      break;
   case 2:
      if ((objtype==OBJ_THING || objtype==OBJ_VERTEX) && (*list)->next==0L)
      { Notify(0,"must select 2+ objs"); return; }
      angle=0; scale=100;
      if (Input2Numbers("rotate angle ()", "scale (%)", 360, 1000, &angle, &scale))
      RotateAndScaleObjects(objtype, *list, (double) angle*0.0174533, (double) scale*0.01);
      break;
   case 3:
      if (objtype==OBJ_VERTEX) MergeVertices(list);
      if (objtype==OBJ_LINE) SplitLines(*list);
      if (objtype==OBJ_SECTOR) MergeSectors(list);
      break;
   case 4:
      if(objtype==OBJ_LINE) FlipLines(*list, 1);
      break;
   case 5:
      if(objtype==OBJ_LINE) FlipLines(*list, 0);
     }
}