#include "deu.h"

void DisplayMenuText(int x0, int y0, int line, char *text, int highlightnum, int shownumbers)
{
   char h[2];

   if (shownumbers)
   {
      DrawScreenText(x0+26, y0+8+line * 10, "- %s", text);
      setcolor(WHITE);
      if (line<9)
         DrawScreenText(x0+10, y0+8+line * 10, "%d", line+1, text);
      else
         DrawScreenText(x0+10, y0+8+line * 10, "%c", line+56, text);
   }
   else
   {
      if (highlightnum) DrawScreenText(x0+10, y0+8+line * 10, text); else
      { setcolor(DARKGRAY); DrawScreenText(x0+10, y0+8+line * 10, text); }
   }
}

int DisplayMenuArray(int x0, int y0, char *menutitle, int numitems, int *okkeys, char *menustr[30], int highlight[30], int edit)
{
   int  maxlen, line, oldline, ok, key, buttons, oldbuttons;

   if (menutitle) maxlen=strlen(menutitle)-2;
   else  maxlen=1;
   for (line=0; line<numitems; line++)
      if (strlen(menustr[line])>maxlen)
         maxlen=strlen(menustr[line]);

   if (x0<0) x0=(ScrMaxX-maxlen*8-(okkeys?19:53))/2;
   if (y0<0) y0=(ScrMaxY-numitems*10-(menutitle?28:12))/2;
   DrawScreenBox3D(x0, y0, x0+(edit?maxlen*8+(okkeys?19:53):218), y0+numitems*10+(menutitle?20:12));
   setcolor(YELLOW);
   if (menutitle) DrawScreenText(x0+10, y0+6, menutitle);
   for (line=0; line<numitems; line++)
   {
      setcolor(BLACK);
      DisplayMenuText(x0, y0+(menutitle ? 10 : 0), line, menustr[line], highlight[line]||!edit, !okkeys&&edit);
   }
   oldline=-1; line=0; oldbuttons=0; ok=0;
   while (!ok&&edit)
   {
      if (UseMouse)
      {
         GetMouseCoords(&PointerX, &PointerY, &buttons);
         if ((buttons&2)==2)
         {
            line=-1;
            ok=1;
         }
         else if (buttons ==1 && PointerX >= x0 && PointerX <= x0+maxlen * 8+53)
            line=(PointerY-y0-(menutitle?24:8))/10;
         else if (buttons ==0 && oldbuttons ==1)
            ok=1;
         oldbuttons=buttons;
      }
      if (bioskey(1))
      {
         key=bioskey(0);
         if ((key & 0x00FF) ==0x000D) ok=1;
         else if ((key & 0x00FF) ==0x001B)
         {
            line=-1;
            ok=1;
         }
         else if ((key & 0xFF00) ==0x4800)
         {
            if (line>0)
               line--;
            else
               line=numitems-1;
         }
         else if ((key & 0xFF00) ==0x5000)
         {
            if (line<numitems-1)
               line++;
            else
               line=0;
         }
         else if ((key & 0x00FF) >= '1' && (key & 0x00FF) <= '9' && ((key & 0x00FF)-'1')<numitems)
         {
            line=(key & 0x00FF)-'1';
            ok=1;
         }
         else if (okkeys)
         {
            for (line=0; line<numitems; line++)
               if (toupper(key)==okkeys[line])
                  break;
            if (line<numitems)
               ok=1;
            else
               line=oldline;
         }
      }
      if (line!=oldline)
      {
         if (oldline >=0 && oldline<numitems)
         {
            setcolor(BLACK);
            DisplayMenuText(x0, y0+(menutitle ? 10 : 0), oldline, menustr[oldline], highlight[oldline], !okkeys);
         }
         if (line >=0 && line<numitems)
         {
            setcolor(WHITE);
            DisplayMenuText(x0, y0+(menutitle ? 10 : 0), line, menustr[line], highlight[line], !okkeys);
         }
         oldline=line;
      }
   }
   if (line >=0 && line<numitems)
      return (line+1);
   else
      return 0;
}

int DisplayMenu(int x0, int y0, char *menutitle, ...)
{
   va_list args;
   int num, dummy[30];
   char *menustr[30];

   num=0;
   va_start(args, menutitle);
   while ((num<30) && ((menustr[num]=va_arg(args, char *))!=0L))
   num++;
   va_end(args);

   return DisplayMenuArray(x0, y0, menutitle, num, 0L, menustr, dummy,1);
}

int PullDownMenu(int x0, int y0, ...)
{
   va_list args;
   char *menustr[30];
   int num, retnkeys[30], permkeys[30], highlight[30];

   num=0;
   va_start(args, y0);
   while ((num<30) && ((menustr[num]=va_arg(args, char *))!=0L))
   {
     retnkeys[num]=va_arg(args,int);
     permkeys[num]=va_arg(args,int);
     highlight[num]=va_arg(args,int);
     num++;
   }
   va_end(args);

   num=DisplayMenuArray(x0, y0, 0L, num, permkeys, menustr, highlight,1);
   if (num >=1)
      return retnkeys[num-1];
   else
      return 0;
}

int InputInteger(int x0, int y0, int *valp, int minv, int maxv)
{
   int  key, val, neg, ok, firstkey;

   DrawScreenBoxHollow(x0, y0, x0+61, y0+13);
   neg=(*valp<0);
   val=neg ? -(*valp) : *valp;
   firstkey=1;
   for (;;)
   {
      ok=maxv==minv||(neg ? -val : val) >= minv && (neg ? -val : val) <= maxv;
      setcolor(BLACK);
      DrawScreenBox(x0+1, y0+1, x0+60, y0+12);
      if (ok) setcolor(WHITE); else setcolor(LIGHTGRAY);
         DrawScreenText(x0+3, y0+3, neg?"-%d":"%d", val);
      key=bioskey(0);
      if (firstkey && (key & 0x00FF)>' ')
      {
         val=0;
         neg=0;
      }
      firstkey=0;
      if (val<3275 && (key & 0x00FF) >= '0' && (key & 0x00FF) <= '9')
         val=val * 10+(key & 0x00FF)-'0';
      else if (val>0 && (key & 0x00FF)==8) val=val / 10;
      else if (neg && (key & 0x00FF)==8) neg=0;
      else if ((key & 0x00FF)=='-') neg=!neg;
      else if (ok && (key & 0x00FF) ==0x000D) break;
      else if ((key & 0x00FF) ==0x001B) { neg=0; val=-32767; break;
      } else break;
   }
   if (neg) *valp=-val; else *valp=val;
   return key;
}

int InputIntegerValue(int x0, int y0, int minv, int maxv, int defv)
{
   int  val;
   char prompt[80];

   sprintf(prompt, "Enter number between %d and %d:", minv, maxv);
   if (x0<0)
      x0=(ScrMaxX-25-8 * strlen(prompt)) / 2;
   if (y0<0)
      y0=(ScrMaxY-55) / 2;
   DrawScreenBox3D(x0, y0, x0+25+8 * strlen(prompt), y0+55);
   setcolor(WHITE);
   DrawScreenText(x0+10, y0+8, prompt);
   val=defv;
   InputInteger(x0+10, y0+28, &val, minv, maxv);
   return val;
}

void InputNameFromList(int x0, int y0, char *prompt, int listsize, char **list, int listdisp, char *name, int width, int height, void (*hookfunc)(int px1, int py1, char *name))
{
   int  key, n, l, x1, y1, x2, y2, maxlen, ok, firstkey;

   maxlen=listsize<1?12:8;
   l=maxlen*10;
   x1=160; y1=11;
   n=height>65? height+20:listsize<1?50:85;
   if (x0<0) x0=(ScrMaxX-l) / 2;
   if (y0<0) y0=(ScrMaxY-n) / 2;
   x1 += x0; y1 += y0;
   if (x1+width-1<ScrMaxX) x2=x1+width-1;
   else x2=ScrMaxX;
   if (y1+height-1<ScrMaxY) y2=y1+height-1;
   else y2=ScrMaxY;
   DrawScreenBox3D(x0, y0, x0+250-l+width, y0+n);
   DrawScreenBoxHollow(x0+10, y0+28, x0+l, y0+41);
   DrawScreenText(x0+10, y0+8, prompt);
   if (width>0)
   {
      DrawScreenBox(x1, y1, x2+1, y2+1);
      setcolor(DARKGRAY);
      DrawScreenBox(x1-1, y1-1, x2, y2);
   }
   firstkey=1;
   for (;;)
   {
      for (n=0; n<listsize; n++)
         if (strcmp(name, list[n]) <=0)
            break;
      ok=n<listsize ? !strcmp(name, list[n]) : listsize<1? 1:0;
      if (n>listsize-1) n=listsize-1;
      setcolor(LIGHTGRAY); if (maxlen<12)
      DrawScreenBox(x0+88, y0+30, x0+100+7 * maxlen, y0+30+10 * listdisp);
      setcolor(BLACK);
      for (l=0; l<listdisp && n+l<listsize; l++)
         DrawScreenText(x0+88, y0+30+l * 10, list[n+l]);
      DrawScreenBox(x0+11, y0+29, x0+maxlen*10-1, y0+40);
      l=strlen(name);
      if (ok) setcolor(WHITE);
      else setcolor(LIGHTGRAY);
      DrawScreenText(x0+13, y0+31, name);
      if (hookfunc)
      {
         setcolor(BLACK);
         DrawScreenBox(x1, y1, x2, y2);
         hookfunc(x1, y1, name);
      }
      key=bioskey(0);
      if (firstkey && (key & 0x00FF)>' ')
      {
         for (l=0; l <= maxlen; l++)
            name[l]='\0';
         l=0;
      }
      firstkey=0;
      if (l<maxlen && (key & 0x00FF) >= 'a' && (key & 0x00FF) <= 'z')
      {
         name[l]=key & 0x00FF+'A'-'a';
         name[l+1]='\0';
      }
      else if (l<maxlen && (key & 0x00FF)>' ')
      {
         name[l]=key & 0x00FF;
         name[l+1]='\0';
      }
      else if (l>0 && (key & 0x00FF)==8)
         name[l-1]='\0';
      else if (n<listsize-1 && (key & 0xFF00) ==0x5000)
         strcpy(name, list[n+1]);
      else if (n>0 && (key & 0xFF00) ==0x4800)
         strcpy(name, list[n-1]);
      else if (ok && (key & 0x00FF) ==0x000D)
         break;
      else if (n<listsize-listdisp && (key & 0xFF00) ==0x5100) strcpy(name, list[n+listdisp]);
      else if (n >=listdisp && (key & 0xFF00) ==0x4900) strcpy(name, list[n-listdisp]);
      else if ((key & 0x00FF) ==0x001B)
      {
         name[0]='\0';
         break;
      }
   }
}

int Notify(int key, char *prompt1)
{
   DrawScreenBox3D(190,220,480,265);
   setcolor(WHITE);
   DrawScreenText(200,220+(key?8:18),prompt1);
   setcolor(YELLOW);
   if(key) DrawScreenText(-1, 246,"Y confirm, other key cancel");
   key=bioskey(0);
   return ((key & 0x00FF)=='y');
}

void DisplayPic(int x0, int y0, int x1, int y1, char *picname)
{
   MDirPtr dir;
   int junk, x, y, nColumns, nCurrentColumn, fColumnInMemory, i, n;
   unsigned char *lpColumnData, *lpColumn;
   long  *lpNeededOffsets,lCurrentOffset;
   unsigned char bRowStart, bColored;

   dir=FindMasterDir(MasterDir, picname);
   if (dir==0L) return;
   BasicWadSeek(dir->wad, dir->dir.start);
   BasicWadRead(dir->wad, &nColumns, 2L);
   BasicWadRead(dir->wad, &junk, 6L);

   lpColumnData   =Memory(61440L);
   lpNeededOffsets=Memory(nColumns * 4L);

   BasicWadRead(dir->wad, lpNeededOffsets, nColumns * 4L);
   BasicWadSeek(dir->wad, dir->dir.start+lpNeededOffsets[0]);
   BasicWadRead(dir->wad, lpColumnData, 61440L);

   for (nCurrentColumn=0; nCurrentColumn<nColumns; nCurrentColumn++)
   {
      lCurrentOffset =lpNeededOffsets[nCurrentColumn];
      fColumnInMemory=lCurrentOffset >= lpNeededOffsets[0] && lCurrentOffset<(long)(lpNeededOffsets[0]+60928L);
      if (fColumnInMemory)
      {
         lpColumn=&lpColumnData[lCurrentOffset-lpNeededOffsets[0]];
      }
      else
      {
         lpColumn=Memory(512L);
         BasicWadSeek(dir->wad, dir->dir.start+lCurrentOffset);
         BasicWadRead(dir->wad, lpColumn, 512L);
      }

      n=1;
      bRowStart=lpColumn[0];
      while (bRowStart!=255 && n<512L)
      {
         bColored=lpColumn[n];
         n += 2;
         for (i=0; i<bColored; i++)
         {
            x=x0+nCurrentColumn;
            y=y0+bRowStart+i;
            if (x >= x0 && y >= y0 && x <= x1 && y <= y1)
               putpixel(x, y, -lpColumn[i+n]>>4);
         }
         n += bColored+1;
         bRowStart=lpColumn[n++];
      }
      if (!fColumnInMemory)
         free(lpColumn);
   }
   free(lpColumnData);
   free(lpNeededOffsets);
}

void DisplayWallTexture(int x0, int y0, char *texname)
{
   MDirPtr  dir, pdir;
   long *offsets,numtex,texofs;
   int n, xsize, ysize, xofs, yofs, fields, pnameind;
   char  tname[9], picname[9];

   texofs=0;
   dir=FindMasterDir(MasterDir, "TEXTURE1");
   BasicWadSeek(dir->wad, dir->dir.start);
   BasicWadRead(dir->wad, &numtex, 4);
   offsets=Memory(numtex * sizeof(long));
   for (n=0; n<numtex; n++)
      BasicWadRead(dir->wad, &(offsets[n]), 4L);
   for (n=0; n<numtex && !texofs; n++)
   {
      BasicWadSeek(dir->wad, dir->dir.start+offsets[n]);
      BasicWadRead(dir->wad, &tname, 8);
      if (!strnicmp(tname, texname, 8))
         texofs=dir->dir.start+offsets[n];
   }
   free(offsets);
   setcolor(LIGHTGRAY);
   DrawScreenBox(x0-148, y0+40, x0-77, y0+50);

   if (texofs ==0)  return;
   BasicWadSeek(dir->wad, texofs+12L);
   BasicWadRead(dir->wad, &xsize, 2L);
   BasicWadRead(dir->wad, &ysize, 2L);
   BasicWadSeek(dir->wad, texofs+20L);
   BasicWadRead(dir->wad, &fields, 2L);

   setcolor(BLACK);
   DrawScreenText(x0-148, y0+40, "%dx%d", xsize, ysize);

   if (bioskey(1)!=0)  return;

   for (n=0; n<fields; n++)
   {
      BasicWadSeek(dir->wad, texofs+22L+n * 10L);
      BasicWadRead(dir->wad, &xofs, 2L);
      BasicWadRead(dir->wad, &yofs, 2L);
      BasicWadRead(dir->wad, &pnameind, 2L);
      pdir=FindMasterDir(MasterDir, "PNAMES");
      BasicWadSeek(pdir->wad, pdir->dir.start+4L+pnameind * 8L);
      BasicWadRead(pdir->wad, &picname, 8L);
      picname[8]='\0';
      DisplayPic(xofs>0?x0+xofs:x0, yofs>0?y0+yofs:y0, x0+xsize, y0+ysize, strupr(picname));
   }
}
void ChooseFloorTexture(int x0, int y0, char *prompt, int listsize, char **list, char *name)
{ InputNameFromList(x0, y0, prompt, listsize, list, 5, name,0,0,0L); }
void ChooseWallTexture(int x0, int y0, char *prompt, int listsize, char **list, char *name)
{ InputNameFromList(x0, y0, prompt, listsize, list, 11, name, 256, 128, DisplayWallTexture); }