#include "deu.h"

int ComputeIntersection(int *x, int *y, SEPtr seg1, SEPtr seg2)
{
   double x1=Vertexes[seg1->start].x, y1=Vertexes[seg1->start].y, d;
   double dx1=Vertexes[seg1->end].x-Vertexes[seg1->start].x, dy1=Vertexes[seg1->end].y-Vertexes[seg1->start].y;
   double x2=Vertexes[seg2->start].x, y2=Vertexes[seg2->start].y;
   double dx2=Vertexes[seg2->end].x-Vertexes[seg2->start].x, dy2=Vertexes[seg2->end].y-Vertexes[seg2->start].y;
   d=dy1*dx2-dx1*dy2;
   if (d!=0.0)
   {
      x1=y1*dx1-x1*dy1; x2=y2*dx2-x2*dy2;
      *x=(int)((dx1*x2-dx2*x1)/d); *y=(int)((dy1*x2-dy2*x1)/d);
      if(*x>=Vertexes[seg1->start].x-7&&*x<=Vertexes[seg1->start].x+7&&*y>=Vertexes[seg1->start].y-7&&*y<=Vertexes[seg1->start].y+7)
	return 0;
      if(*x>=Vertexes[seg1->end].x-7&&*x<=Vertexes[seg1->end].x+7&&*y>=Vertexes[seg1->end].y-7&&*y<=Vertexes[seg1->end].y+7)
	return 0;
      if(*x>=Vertexes[seg2->start].x-7&&*x<=Vertexes[seg2->start].x+7&&*y>=Vertexes[seg2->start].y-7&&*y<=Vertexes[seg2->start].y+7)
	return 0;
      if(*x>=Vertexes[seg2->end].x-7&&*x<=Vertexes[seg2->end].x+7&&*y>=Vertexes[seg2->end].y-7&&*y<=Vertexes[seg2->end].y+7)
	return 0;
      return 1;
   }
   else return 0;
}

SEPtr FindNodeLine(SEPtr seglist)
{
   int splits, mindiff=32767, num1, num2, dummyx, dummyy;
   SEPtr nodeline, bestnodeline, curseg;
   long x, y, dx, dy, a, b, c, d;
   bestnodeline=0L;
   for (nodeline=seglist; nodeline; nodeline=nodeline->next)
   {
      x=Vertexes[nodeline->start].x; y=Vertexes[nodeline->start].y;
      dx=Vertexes[nodeline->end].x-Vertexes[nodeline->start].x;
      dy=Vertexes[nodeline->end].y-Vertexes[nodeline->start].y;
      if (dx==0 || dy==0) splits=0; else splits=1;
      num1=0; num2=0;
      for (curseg=seglist; curseg; curseg=curseg->next)
      {
	if (curseg==nodeline) { num1++; continue; }
	a=((long) Vertexes[curseg->start].x-x)*dy;
	b=((long) Vertexes[curseg->start].y-y)*dx;
	c=((long) Vertexes[curseg->end].x-x)*dy;
	d=((long) Vertexes[curseg->end].y-y)*dx;
	if ((a!=b)&& (c!=d)&& ((a>b)!=(c>d))&& ComputeIntersection(&dummyx,&dummyy, nodeline, curseg))
	{ splits++; num1++; num2++; }
	else if ((a>b) || ((a==b)&& (c>d))
	|| ((a==b)&& (c==d)&& ((dx>0)==((Vertexes[curseg->end].x-Vertexes[curseg->start].x)>0))&& ((dy>0)==((Vertexes[curseg->end].y-Vertexes[curseg->start].y)>0))))
	num1++; else num2++;
      }
      if (num1>0&& num2>0) { num1=max(num1,num2)+8*splits;
	if (num1<mindiff) { mindiff=num1; bestnodeline=nodeline;	}
      }
   }

   return bestnodeline;
}

void StoreInSegList(SEPtr seg, SEPtr *seglist, SEPtr *slistend, SEPtr other, int x, int y)
{
   if (*seglist) { (*slistend)->next=seg; *slistend=(*slistend)->next; }
   else { *seglist=seg; *slistend=*seglist; }
   (*slistend)->next=0L;
   if (!other) return;
   (*slistend)->start=NumVertexes-1; (*slistend)->end=other->end;
   (*slistend)->angle=other->angle; (*slistend)->line=other->line;
   (*slistend)->flip=other->flip;
   (*slistend)->dist=other->dist + ComputeDist(x-Vertexes[other->start].x, y-Vertexes[other->start].y);
   other->end=NumVertexes-1;
}

void ComputeBoundingBox(SEPtr seglist, int *minx, int *maxx, int *miny, int *maxy)
{
   SEPtr curseg;
   *maxx=-32767; *maxy=-32767; *minx=32767; *miny=32767;
   for (curseg=seglist; curseg; curseg=curseg->next)
   {
      if (Vertexes[curseg->start].x<*minx) *minx=Vertexes[curseg->start].x;
      if (Vertexes[curseg->start].x>*maxx) *maxx=Vertexes[curseg->start].x;
      if (Vertexes[curseg->start].y<*miny) *miny=Vertexes[curseg->start].y;
      if (Vertexes[curseg->start].y>*maxy) *maxy=Vertexes[curseg->start].y;
      if (Vertexes[curseg->end].x<*minx) *minx=Vertexes[curseg->end].x;
      if (Vertexes[curseg->end].x>*maxx) *maxx=Vertexes[curseg->end].x;
      if (Vertexes[curseg->end].y<*miny) *miny=Vertexes[curseg->end].y;
      if (Vertexes[curseg->end].y>*maxy) *maxy=Vertexes[curseg->end].y;
   }
}

int CreateSSector(SEPtr seglist)
{
   NumSSectors++;
   if (SSectors)
   {
      LastSSector->next=Memory(sizeof(struct SSector));
      LastSSector=LastSSector->next;
   }
   else
   {
      SSectors=Memory(sizeof(struct SSector));
      LastSSector=SSectors;
   }
   LastSSector->next=0L;
   LastSSector->first=NumSegs;
   if (Segs==0L) Segs=seglist;
   else LastSeg->next=seglist;
   NumSegs++;
   for (LastSeg=seglist; LastSeg->next; LastSeg=LastSeg->next)
   NumSegs++;
   LastSSector->num=NumSegs-LastSSector->first;
   DrawScreenMeter(125, 128, 530, 148,(float)NumSegs/(float)(NumSides+1));
   return NumSSectors-1;
}

int CreateNodes(NPtr *node_r, int *ssector_r, SEPtr seglist)
{
   NPtr node;
   SEPtr segs1=0L, segs2=0L;
   static SEPtr nodeline, curseg, lastseg1, lastseg2;
   static long a, b, c, d;
   node=Memory(sizeof(struct Node));
   nodeline=FindNodeLine(seglist);
   if (nodeline==0L)
   {
      *node_r=0L;
      *ssector_r=CreateSSector(seglist) | 0x8000;
      return 0;
   }
   node->x=Vertexes[nodeline->start].x;
   node->y=Vertexes[nodeline->start].y;
   node->dx=Vertexes[nodeline->end].x-node->x;
   node->dy=Vertexes[nodeline->end].y-node->y;
   while (seglist)
   {
      curseg=seglist;
      seglist=seglist->next;
      a=(long) (Vertexes[curseg->start].x-node->x)*(long) (node->dy);
      b=(long) (Vertexes[curseg->start].y-node->y)*(long) (node->dx);
      c=(long) (Vertexes[curseg->end].x-node->x)*(long) (node->dy);
      d=(long) (Vertexes[curseg->end].y-node->y)*(long) (node->dx);
      if ((a>b) || ((a==b)&& (c>d))
	  || ((a==b)&& (c==d)&& ((node->dx>0)==((Vertexes[curseg->end].x-Vertexes[curseg->start].x)>0))&& ((node->dy>0)==((Vertexes[curseg->end].y-Vertexes[curseg->start].y)>0))))
      {
	 StoreInSegList(curseg,&segs1,&lastseg1, 0,0,0);
	 if (c<d)
	 {
	    int newx, newy;
	    if (ComputeIntersection(&newx,&newy, nodeline, curseg))
	    {
	       InsertObject(OBJ_VERTEX, -2, newx, newy);
	       StoreInSegList(Memory(sizeof(struct Seg)),&segs2,&lastseg2,lastseg1,newx, newy);
	    }
	 }
      }
      else
      {
	 StoreInSegList(curseg,&segs2,&lastseg2, 0,0,0);
	 if (c>d)
	 {
	    int newx, newy;
	    if (ComputeIntersection(&newx,&newy, nodeline, curseg))
	    {
	       InsertObject(OBJ_VERTEX, -2, newx, newy);
	       StoreInSegList(Memory(sizeof(struct Seg)),&segs1,&lastseg1,lastseg2,newx, newy);
	    }
	 }
      }
   }
   ComputeBoundingBox(segs1,&(node->minx1),&(node->maxx1),&(node->miny1),&(node->maxy1));
   CreateNodes(&(node->node1),&(node->child1), segs1);
   ComputeBoundingBox(segs2,&(node->minx2),&(node->maxx2),&(node->miny2),&(node->maxy2));
   CreateNodes(&(node->node2),&(node->child2), segs2);

   *node_r=node; *ssector_r=0; return 1;
}