#include "deu.h"

int IsSelected(SelPtr list, int objnum)
{
   SelPtr cur;
   for (cur=list; cur; cur=cur->next)
   if (cur->objnum==objnum) return 1;
   return 0;
}
void SelectObject(SelPtr *list, int objnum)
{
   SelPtr cur;
   if (objnum<0)return;
   cur=Memory(sizeof(struct SelectionList));
   cur->next=*list;
   cur->objnum=objnum;
   *list=cur;
}
void UnSelectObject(SelPtr *list, int objnum)
{
   SelPtr cur, prev;
   if (objnum<0)return;
   prev=0L;
   cur=*list;
   while (cur)
   {
      if (cur->objnum==objnum)
      {
         if (prev) prev->next=cur->next;
         else *list=cur->next;
         free(cur);
         if (prev) cur=prev->next;
         else cur=0L;
      }
      else
      {
         prev=cur;
         cur=cur->next;
      }
   }
}
void ForgetSelection(SelPtr *list)
{
   SelPtr cur, prev;
   cur=*list;
   while (cur)
   {
      prev=cur;
      cur=cur->next;
      free(prev);
   }
   *list=0L;
}
int GetMaxObjectNum(int objtype)
{
   switch (objtype)
   {
   case OBJ_THING: return NumThings-1;
   case OBJ_LINE: return NumLines-1;
   case OBJ_VERTEX: return NumVertexes-1;
   case OBJ_SECTOR: return NumSectors-1;
   }
   return -1;
}
int GetCurObject(int objtype, int x0, int y0, int x1, int y1)
{
   int n, cur, curx, lx0, ly0, lx1, ly1, midx, midy, m;
   cur=-1;
   if (x1<x0) { n=x0; x0=x1; x1=n; }
   if (y1<y0) { n=y0; y0=y1; y1=n; }
   switch (objtype)
   {
   case OBJ_THING:
	for (n=0; n<NumThings; n++)
	if (Things[n].xpos>=x0 && Things[n].xpos<=x1 && Things[n].ypos>=y0 && Things[n].ypos<=y1)
	{ cur=n; break; }
	break;
   case OBJ_VERTEX:
	for (n=0; n<NumVertexes; n++)
	if (Vertexes[n].x>=x0 && Vertexes[n].x<=x1 && Vertexes[n].y>=y0 && Vertexes[n].y<=y1)
	{ cur=n; break; }
	break;
   case OBJ_LINE:
	for (n=0; n<NumLines; n++)
	{
	if (IsLineInside(n, x0, y0, x1, y1)) { cur=n; break; }
	}
	break;
   case OBJ_SECTOR:
	curx=MapMaxX+1;
	cur=-1;
	midx=(x0+x1)/2;
	midy=(y0+y1)/2;
	for (n=0; n<NumLines; n++)
	if ((Vertexes[Lines[n].start].y>midy) != (Vertexes[Lines[n].end].y>midy))
	{
	lx0=Vertexes[Lines[n].start].x;
	ly0=Vertexes[Lines[n].start].y;
	lx1=Vertexes[Lines[n].end].x;
	ly1=Vertexes[Lines[n].end].y;
	m=lx0+((midy-ly0) *(lx1-lx0)/(ly1-ly0));
	if (m>=midx && m<curx) { curx=m; cur=n; }
	}
	if (cur>=0)
	{
	if (Vertexes[Lines[cur].start].y>Vertexes[Lines[cur].end].y)
	cur=Lines[cur].side1;
	else cur=Lines[cur].side2;
	if (cur>=0) cur=Sides[cur].sector;
	}
   }
   return cur;
}

SelPtr SelectObjectsInBox(int objtype, int x0, int y0, int x1, int y1)
{
   int n, m; SelPtr list; list=0L;
   if (x1<x0) { n=x0; x0=x1; x1=n; }
   if (y1<y0) { n=y0; y0=y1; y1=n; }
   switch (objtype)
   {
   case OBJ_THING:
	for (n=0; n<NumThings; n++)
	if (Things[n].xpos>=x0 && Things[n].xpos<=x1 && Things[n].ypos>=y0 && Things[n].ypos<=y1)
	SelectObject(&list, n);
	break;
   case OBJ_VERTEX:
	for (n=0; n<NumVertexes; n++)
	if (Vertexes[n].x>=x0 && Vertexes[n].x<=x1 && Vertexes[n].y>=y0 && Vertexes[n].y<=y1)
	SelectObject(&list, n);
	break;
   case OBJ_LINE:
	for (n=0; n<NumLines; n++)
	{
	m=Lines[n].start;
	if (Vertexes[m].x<x0 || Vertexes[m].x>x1 || Vertexes[m].y<y0 || Vertexes[m].y>y1)
	continue;
	m=Lines[n].end;
	if (Vertexes[m].x<x0 || Vertexes[m].x>x1 || Vertexes[m].y<y0 || Vertexes[m].y>y1)
	continue;
	SelectObject(&list, n);
	}
	break;
   case OBJ_SECTOR:
	for (n=0; n<NumSectors; n++) SelectObject(&list, n);
	for (n=0; n<NumLines; n++)
	{
	m=Lines[n].start;
	if (Vertexes[m].x<x0 || Vertexes[m].x>x1 || Vertexes[m].y<y0 || Vertexes[m].y>y1)
	{
	m=Lines[n].side1;
	if (m>=0 && Sides[m].sector>=0)
	UnSelectObject(&list, Sides[m].sector);
	m=Lines[n].side2;
	if (m>=0 && Sides[m].sector>=0)
	UnSelectObject(&list, Sides[m].sector);
	continue;
	}
	m=Lines[n].end;
	if (Vertexes[m].x<x0 || Vertexes[m].x>x1 || Vertexes[m].y<y0 || Vertexes[m].y>y1)
	{
	m=Lines[n].side1;
	if (m>=0 && Sides[m].sector>=0)
	UnSelectObject(&list, Sides[m].sector);
	m=Lines[n].side2;
	if (m>=0 && Sides[m].sector>=0)
	UnSelectObject(&list, Sides[m].sector);
	continue;
	}
	}
   }
   return list;
}

void HighlightObject(int objtype, int objnum, int color)
{
   int  n, m;

   setwritemode(XOR_PUT);
   setcolor(color);
   switch (objtype)
   {
   case OBJ_THING:
	m=(ThingRadius(Things[objnum].type) * 3)/2;
	DrawMapLine(Things[objnum].xpos-m, Things[objnum].ypos-m, Things[objnum].xpos-m, Things[objnum].ypos+m);
	DrawMapLine(Things[objnum].xpos-m, Things[objnum].ypos+m, Things[objnum].xpos+m, Things[objnum].ypos+m);
	DrawMapLine(Things[objnum].xpos+m, Things[objnum].ypos+m, Things[objnum].xpos+m, Things[objnum].ypos-m);
	DrawMapLine(Things[objnum].xpos+m, Things[objnum].ypos-m, Things[objnum].xpos-m, Things[objnum].ypos-m);
	DrawMapArrow(Things[objnum].xpos, Things[objnum].ypos, Things[objnum].angle * 182);
	break;
   case OBJ_LINE:
	n=(Vertexes[Lines[objnum].start].x+Vertexes[Lines[objnum].end].x)/2;
	m=(Vertexes[Lines[objnum].start].y+Vertexes[Lines[objnum].end].y)/2;
	DrawMapLine(n, m, n+(Vertexes[Lines[objnum].end].y-Vertexes[Lines[objnum].start].y)/3, m+(Vertexes[Lines[objnum].start].x-Vertexes[Lines[objnum].end].x)/3);
	setlinestyle(SOLID_LINE, 0, THICK_WIDTH);
	DrawMapVector(Vertexes[Lines[objnum].start].x, Vertexes[Lines[objnum].start].y,
	Vertexes[Lines[objnum].end].x, Vertexes[Lines[objnum].end].y);
	if (color != LIGHTRED && Lines[objnum].tag>0)
	{
	for (m=0; m<NumSectors; m++) if (Sectors[m].tag==Lines[objnum].tag)
	HighlightObject(OBJ_SECTOR, m, LIGHTRED);
	}
	setlinestyle(SOLID_LINE, 0, NORM_WIDTH);
	break;
   case OBJ_VERTEX:
	DrawMapLine(Vertexes[objnum].x-6, Vertexes[objnum].y-6, Vertexes[objnum].x-6, Vertexes[objnum].y+6);
	DrawMapLine(Vertexes[objnum].x-6, Vertexes[objnum].y+6, Vertexes[objnum].x+6, Vertexes[objnum].y+6);
	DrawMapLine(Vertexes[objnum].x+6, Vertexes[objnum].y+6, Vertexes[objnum].x+6, Vertexes[objnum].y-6);
	DrawMapLine(Vertexes[objnum].x+6, Vertexes[objnum].y-6, Vertexes[objnum].x-6, Vertexes[objnum].y-6);
	break;
   case OBJ_SECTOR:
	setlinestyle(SOLID_LINE, 0, THICK_WIDTH);
	for (n=0; n<NumLines; n++)
	if (Sides[Lines[n].side1].sector==objnum || Sides[Lines[n].side2].sector==objnum)
	DrawMapLine(Vertexes[Lines[n].start].x, Vertexes[Lines[n].start].y,
	Vertexes[Lines[n].end].x, Vertexes[Lines[n].end].y);
	if (color != LIGHTRED && Sectors[objnum].tag>0)
	{
	for (m=0; m<NumLines; m++)
	if (Lines[m].tag==Sectors[objnum].tag)
	HighlightObject(OBJ_LINE, m, LIGHTRED);
	}
	setlinestyle(SOLID_LINE, 0, NORM_WIDTH);
   }
   setwritemode(COPY_PUT);
}
void HighlightSelection(int objtype,SelPtr list)
{
   SelPtr cur;
   if (list==0L)  return;
   for (cur=list; cur; cur=cur->next)
   HighlightObject(objtype, cur->objnum, GREEN);
}

void DeleteObject(int objtype, int objnum)
{
   SelPtr list;
   list=0L;
   SelectObject(&list, objnum);
   DeleteObjects(objtype, &list);
}
void DelVert(SelPtr cur)
{ int m,n;
  for (n=0; n<NumVertexes; n++) SelectObject(&cur, n);
   for (n=0; n<NumLines; n++)
   { m=Lines[n].start;
      if (cur && m>=0) UnSelectObject(&cur, m);
      m=Lines[n].end;
      if (cur && m>=0) UnSelectObject(&cur, m);
      continue;
   }
   if (cur) DeleteObjects(OBJ_VERTEX, &cur);
}
int DelVer=1;
void FlipLines(SelPtr obj, int swapvertices);
void DeleteObjects(int objtype, SelPtr *list)
{
   int n,objnum;
   SelPtr cur;

   Changed=1;
   switch (objtype)
   {
   case OBJ_THING:
	while (*list)
	{
	objnum=(*list)->objnum;
	NumThings--;
	if (NumThings>0)
	for (n=objnum; n<NumThings; n++) Things[n]=Things[n+1];
	else free(Things),Things=0L;
	for (cur=(*list)->next; cur; cur=cur->next)
	if (cur->objnum>objnum)
	cur->objnum--;
	UnSelectObject(list, objnum);
	}
	break;
   case OBJ_VERTEX:
	while (*list)
	{
	objnum=(*list)->objnum;
	for (n=0; n<NumLines; n++)
	{
	if (Lines[n].start==objnum || Lines[n].end==objnum)
	DelVer=0,DeleteObject(OBJ_LINE, n--);
	else
	{
	if (Lines[n].start>=objnum) Lines[n].start--;
	if (Lines[n].end>=objnum) Lines[n].end--;
	}
	}
	NumVertexes--;
	if (NumVertexes>0)
	for (n=objnum; n<NumVertexes; n++) Vertexes[n]=Vertexes[n+1];
	else free(Vertexes),Vertexes=0L;
	for (cur=(*list)->next; cur; cur=cur->next)
	if (cur->objnum>objnum) cur->objnum--;
	UnSelectObject(list, objnum);
	}
	break;
   case OBJ_LINE:
	while (*list)
	{
	objnum=(*list)->objnum;
	NumLines--;
	if (NumLines>0)
	for (n=objnum; n<NumLines; n++) Lines[n]=Lines[n+1];
	else free(Lines),Lines=0L;
	for (cur=(*list)->next; cur; cur=cur->next) if (cur->objnum>objnum)
	cur->objnum--;
	UnSelectObject(list, objnum);
	} if(DelVer)DelVert(cur); DelVer=1;
	break;
   case OBJ_SIDE:
	while (*list)
	{
	objnum=(*list)->objnum;
	for (n=0; n<NumLines; n++)
	{
	if (Lines[n].side1==objnum) Lines[n].side1=-1;
	else if (Lines[n].side1>=objnum) Lines[n].side1--;
	if (Lines[n].side2==objnum) Lines[n].side2=-1;
	else if (Lines[n].side2>=objnum) Lines[n].side2--;
	}
	NumSides--;
	if (NumSides>0)
	for (n=objnum; n<NumSides; n++) Sides[n]=Sides[n+1];
	else free(Sides),Sides=0L;
	for (cur=(*list)->next; cur; cur=cur->next)
	if (cur->objnum>objnum) cur->objnum--;
	UnSelectObject(list, objnum);
	}
	MapChanged=1;
	break;
   case OBJ_SECTOR:
	while (*list)
	{
	objnum=(*list)->objnum;
	for (n=0; n<NumSides; n++)
	if (Sides[n].sector==objnum) DeleteObject(OBJ_SIDE, n--);
	else if (Sides[n].sector>objnum) Sides[n].sector--;
	NumSectors--;
	if (NumSectors>0)
	for (n=objnum; n<NumSectors; n++) Sectors[n]=Sectors[n+1];
	else free(Sectors),Sectors=0L;
	for (cur=(*list)->next; cur; cur=cur->next)
	if (cur->objnum>objnum) cur->objnum--;
	UnSelectObject(list, objnum);
	}
	for (n=0; n<NumLines; n++) if (Lines[n].side1<0&&Lines[n].side2<0)
	DeleteObject(OBJ_LINE,n--); else if(Lines[n].side1<0) SelectObject(&cur, n),FlipLines(cur,1);
   }
}

void InsertObject(int objtype, int copyfrom, int xpos, int ypos)
{
   int last;
   Changed=1;
   switch (objtype)
   {
   case OBJ_THING:
	last=NumThings++;
	if (last>0)
	Things=ResizeMemory(Things, NumThings * sizeof(struct Thing));
	else Things=Memory(sizeof(struct Thing));
	Things[last].xpos=xpos;
	Things[last].ypos=ypos;
	Things[last].type=copyfrom>=0?Things[copyfrom].type:1;
	Things[last].angle=copyfrom>=0?Things[copyfrom].angle:90;
	Things[last].when =copyfrom>=0?Things[copyfrom].when:7;
	break;
   case OBJ_VERTEX:
	last=NumVertexes++;
	if (last>0)
	Vertexes=ResizeMemory(Vertexes, NumVertexes * sizeof(struct Vertex));
	else Vertexes=Memory(sizeof(struct Vertex));
	Vertexes[last].x=xpos;
	Vertexes[last].y=ypos;
	if (Vertexes[last].x<MapMinX) MapMinX=Vertexes[last].x;
	if (Vertexes[last].x>MapMaxX) MapMaxX=Vertexes[last].x;
	if (Vertexes[last].y<MapMinY) MapMinY=Vertexes[last].y;
	if (Vertexes[last].y>MapMaxY) MapMaxY=Vertexes[last].y;
	break;
   case OBJ_LINE:
	last=NumLines++;
	if (last>0)
	Lines=ResizeMemory(Lines, NumLines * sizeof(struct Line));
	else Lines=Memory(sizeof(struct Line));
	Lines[last].start=copyfrom>=0?Lines[copyfrom].start:0;
	Lines[last].end=copyfrom>=0?Lines[copyfrom].end:NumVertexes-1;
	Lines[last].flags=copyfrom>=0?Lines[copyfrom].flags:0;
	Lines[last].type=copyfrom>=0?Lines[copyfrom].type:0;
	Lines[last].tag=copyfrom>=0?Lines[copyfrom].tag:0;
	Lines[last].side1=copyfrom>=0?Lines[copyfrom].side1:-1;
	Lines[last].side2=copyfrom>=0?Lines[copyfrom].side2:-1;
	break;
   case OBJ_SIDE:
	last=NumSides++;
	if (last>0)
	Sides=ResizeMemory(Sides, NumSides * sizeof(struct Side));
	else Sides=Memory(sizeof(struct Side));
	Sides[last].xoff=copyfrom>=0?Sides[copyfrom].xoff:0;
	Sides[last].yoff=copyfrom>=0?Sides[copyfrom].yoff:0;
	strncpy(Sides[last].tex1, copyfrom>=0?Sides[copyfrom].tex1:"-", 8);
	strncpy(Sides[last].tex2, copyfrom>=0?Sides[copyfrom].tex2:"-", 8);
	strncpy(Sides[last].tex3, copyfrom>=0?Sides[copyfrom].tex3:MidTexture, 8);
	Sides[last].sector=copyfrom>=0?Sides[copyfrom].sector:NumSectors-1;
	MapChanged=1;
	break;
   case OBJ_SECTOR:
	last=NumSectors++;
	if (last>0)
	Sectors=ResizeMemory(Sectors, NumSectors * sizeof(struct Sector));
	else Sectors=Memory(sizeof(struct Sector));
	Sectors[last].floorh=copyfrom>=0?Sectors[copyfrom].floorh:FloorHeight;
	Sectors[last].ceilh=copyfrom>=0?Sectors[copyfrom].ceilh:CeilHeight;
	strncpy(Sectors[last].floort, copyfrom>=0?Sectors[copyfrom].floort:FloorTexture, 8);
	strncpy(Sectors[last].ceilt, copyfrom>=0?Sectors[copyfrom].ceilt:CeilTexture, 8);
	Sectors[last].light=copyfrom>=0?Sectors[copyfrom].light:255;
	Sectors[last].special=copyfrom>=0?Sectors[copyfrom].special:0;
	Sectors[last].tag=copyfrom>=0?Sectors[copyfrom].tag:0;
   }
}

int IsLineInside(int ldnum, int x0, int y0, int x1, int y1)
{
   int lx0=Vertexes[Lines[ldnum].start].x;
   int ly0=Vertexes[Lines[ldnum].start].y;
   int lx1=Vertexes[Lines[ldnum].end].x;
   int ly1=Vertexes[Lines[ldnum].end].y;
   int i;

   if (lx0>=x0 && lx0<=x1 && ly0>=y0 && ly0<=y1)
      return 1;
   if (lx1>=x0 && lx1<=x1 && ly1>=y0 && ly1<=y1)
      return 1;
   if ((ly0>y0) != (ly1>y0))
   {
      i=lx0+((y0-ly0) *(long)(lx1-lx0)/(ly1-ly0));
      if (i>=x0 && i<=x1) return 1;
   }
   if ((ly0>y1) != (ly1>y1))
   {
      i=lx0+((y1-ly0) *(long)(lx1-lx0)/(ly1-ly0));
      if (i>=x0 && i<=x1) return 1;
   }
   if ((lx0>x0) != (lx1>x0))
   {
      i=ly0+((x0-lx0) *(long)(ly1-ly0)/(lx1-lx0));
      if (i>=y0 && i<=y1) return 1;
   }
   if ((lx0>x1) != (lx1>x1))
   {
      i=ly0+((x1-lx0) *(long)(ly1-ly0)/(lx1-lx0));
      if (i>=y0 && i<=y1) return 1;
   }
   return 0;
}

void CopyObjects(int objtype, SelPtr obj)
{
   int n, m;
   SelPtr cur, list1, list2, ref1, ref2;

   if (obj==0L) return;
   switch (objtype)
   {
      case OBJ_THING:
         for (cur=obj; cur; cur=cur->next)
         {
            InsertObject(OBJ_THING, cur->objnum, Things[cur->objnum].xpos, Things[cur->objnum].ypos);
            cur->objnum=NumThings-1;
         }
         Changed=1;
         break;

      case OBJ_VERTEX:
         for (cur=obj; cur; cur=cur->next)
         {
            InsertObject(OBJ_VERTEX, cur->objnum, Vertexes[cur->objnum].x, Vertexes[cur->objnum].y);
            cur->objnum=NumVertexes-1;
         }
         Changed=1; MapChanged=1;
         break;

      case OBJ_LINE:
         list1=0L; list2=0L;
         for (cur=obj; cur; cur=cur->next)
         {
            InsertObject(OBJ_LINE, cur->objnum, 0, 0);
            cur->objnum=NumLines-1;
            if (!IsSelected(list1, Lines[cur->objnum].start))
            {
               SelectObject(&list1, Lines[cur->objnum].start);
               SelectObject(&list2, Lines[cur->objnum].start);
            }
            if (!IsSelected(list1, Lines[cur->objnum].end))
            {
               SelectObject(&list1, Lines[cur->objnum].end);
               SelectObject(&list2, Lines[cur->objnum].end);
            }
         }
         CopyObjects(OBJ_VERTEX, list2);
         for (ref1=list1, ref2=list2; ref1 && ref2; ref1=ref1->next, ref2=ref2->next)
         {
            for (cur=obj; cur; cur=cur->next)
            {
               if (ref1->objnum==Lines[cur->objnum].start)
                  Lines[cur->objnum].start=ref2->objnum;
               if (ref1->objnum==Lines[cur->objnum].end)
                  Lines[cur->objnum].end=ref2->objnum;
            }
         }
         ForgetSelection(&list1);
         ForgetSelection(&list2);
         break;

      case OBJ_SECTOR:
         list1=0L; list2=0L;
         for (cur=obj; cur; cur=cur->next)
         {
            for (n=0; n<NumLines; n++)
               if ((((m=Lines[n].side1)>=0 && Sides[m].sector==cur->objnum)
                  || ((m=Lines[n].side2)>=0 && Sides[m].sector==cur->objnum))
                 && ! IsSelected(list1, n))
               { SelectObject(&list1, n); SelectObject(&list2, n); }
         }
         CopyObjects(OBJ_LINE, list2);
         for (ref1=list1, ref2=list2; ref1 && ref2; ref1=ref1->next, ref2=ref2->next)
         {
            if ((n=Lines[ref1->objnum].side1)>=0)
            {
               InsertObject(OBJ_SIDE, n, 0, 0);
               n=NumSides-1;
               Lines[ref2->objnum].side1=n;
            }
            if ((m=Lines[ref1->objnum].side2)>=0)
            {
               InsertObject(OBJ_SIDE, m, 0, 0);
               m=NumSides-1;
               Lines[ref2->objnum].side2=m;
            }
            ref1->objnum=n;
            ref2->objnum=m;
         }
         for (cur=obj; cur; cur=cur->next)
         {
            InsertObject(OBJ_SECTOR, cur->objnum, 0, 0);
            for (ref1=list1, ref2=list2; ref1 && ref2; ref1=ref1->next, ref2=ref2->next)
            {
               if (ref1->objnum>=0 && Sides[ref1->objnum].sector==cur->objnum)
                  Sides[ref1->objnum].sector=NumSectors-1;
               if (ref2->objnum>=0 && Sides[ref2->objnum].sector==cur->objnum)
                  Sides[ref2->objnum].sector=NumSectors-1;
            }
            cur->objnum=NumSectors-1;
         }
         ForgetSelection(&list1);
         ForgetSelection(&list2);
   }
}

int MoveObjectsToCoords(int objtype, SelPtr obj, int newx, int newy, int grid)
{
   int n, m, dx, dy;
   SelPtr cur, vertices;
   static int refx, refy;
   if (grid>0)
   {
      newx=(newx+grid/2)&~(grid-1);
      newy=(newy+grid/2)&~(grid-1);
   }
   if (obj==0L) { refx=newx; refy=newy; return 1; }
   dx=newx-refx; dy=newy-refy;
   if (dx==0&&dy==0) return 0;

   switch (objtype)
   {
      case OBJ_THING:
         for (cur=obj; cur; cur=cur->next)
         {
            Things[cur->objnum].xpos+=dx;
            Things[cur->objnum].ypos+=dy;
         }
         refx=newx; refy=newy;
         Changed=1; break;
      case OBJ_VERTEX:
         for (cur=obj; cur; cur=cur->next)
         {
            Vertexes[cur->objnum].x+=dx;
            Vertexes[cur->objnum].y+=dy;
         }
         refx=newx; refy=newy;
         Changed=1; MapChanged=1; break;
      case OBJ_LINE:
         vertices=0L;
         for (cur=obj; cur; cur=cur->next)
         {
            if (!IsSelected(vertices, Lines[cur->objnum].start))
               SelectObject(&vertices, Lines[cur->objnum].start);
            if (!IsSelected(vertices, Lines[cur->objnum].end))
               SelectObject(&vertices, Lines[cur->objnum].end);
         }
         MoveObjectsToCoords(OBJ_VERTEX, vertices, newx, newy, grid);
         ForgetSelection(&vertices);
         break;
      case OBJ_SECTOR:
         vertices=0L;
         for (cur=obj; cur; cur=cur->next)
         {
            for (n=0; n<NumLines; n++)
               if (((m=Lines[n].side1)>=0 && Sides[m].sector==cur->objnum)
                || ((m=Lines[n].side2)>=0 && Sides[m].sector==cur->objnum))
               {
                  if (!IsSelected(vertices, Lines[n].start))
                     SelectObject(&vertices, Lines[n].start);
                  if (!IsSelected(vertices, Lines[n].end))
                     SelectObject(&vertices, Lines[n].end);
               }
         }
         MoveObjectsToCoords(OBJ_VERTEX, vertices, newx, newy, grid);
         ForgetSelection(&vertices);
   }
   return 1;
}
void GetObjectCoords(int objtype, int objnum, int *xpos, int *ypos)
{
   int  n, v1, v2, sd1, sd2;
   long accx, accy, num;

   switch (objtype)
   {
      case OBJ_THING:
         *xpos=Things[objnum].xpos;
         *ypos=Things[objnum].ypos;
         break;
      case OBJ_VERTEX:
         *xpos=Vertexes[objnum].x;
         *ypos=Vertexes[objnum].y;
         break;
      case OBJ_LINE:
         v1=Lines[objnum].start;
         v2=Lines[objnum].end;
         *xpos=(Vertexes[v1].x+Vertexes[v2].x)/2;
         *ypos=(Vertexes[v1].y+Vertexes[v2].y)/2;
         break;
      case OBJ_SECTOR:
         accx=0L; accy=0L; num=0L;
         for (n=0; n<NumLines; n++)
         {
            sd1=Lines[n].side1;
            sd2=Lines[n].side2;
            v1=Lines[n].start;
            v2=Lines[n].end;
            if ((sd1>=0 && Sides[sd1].sector==objnum) || (sd2>=0 && Sides[sd2].sector==objnum))
            {
               accx+=(long) Vertexes[v1].x;
               accy+=(long) Vertexes[v1].y;
               num++;
               accx+=(long) Vertexes[v2].x;
               accy+=(long) Vertexes[v2].y;
               num++;
            }
         }
         if (num>0)
         {
            *xpos=(int) ((accx+num/2L)/num);
            *ypos=(int) ((accy+num/2L)/num);
         }
         else
         {
            *xpos=(MapMinX+MapMaxX)/2;
            *ypos=(MapMinY+MapMaxY)/2;
         }
   }
}
void RotateAndScaleObjects(int objtype, SelPtr obj, double angle, double scale)
{
   int n, m, dx, dy, centerx, centery, accx, accy, num;
   SelPtr cur, vertices;

   if (obj==0L) return;
   switch (objtype)
   {
      case OBJ_THING:
         accx=0L; accy=0L; num=0L;
         for (cur=obj; cur; cur=cur->next)
         {
            accx+=Things[cur->objnum].xpos;
            accy+=Things[cur->objnum].ypos;
            num++;
         }
         centerx=(int) ((accx+num/2L)/num);
         centery=(int) ((accy+num/2L)/num);
         for (cur=obj; cur; cur=cur->next)
         {
            dx=Things[cur->objnum].xpos-centerx;
            dy=Things[cur->objnum].ypos-centery;
            RotateAndScaleCoords(&dx, &dy, angle, scale);
            Things[cur->objnum].xpos=centerx+dx;
            Things[cur->objnum].ypos=centery+dy;
         }
         Changed=1;
         break;
      case OBJ_VERTEX:
         accx=0L; accy=0L; num=0L;
         for (cur=obj; cur; cur=cur->next)
         {
            accx+=Vertexes[cur->objnum].x;
            accy+=Vertexes[cur->objnum].y;
            num++;
         }
         centerx=(int) ((accx+num/2L)/num);
         centery=(int) ((accy+num/2L)/num);
         for (cur=obj; cur; cur=cur->next)
         {
            dx=Vertexes[cur->objnum].x-centerx;
            dy=Vertexes[cur->objnum].y-centery;
            RotateAndScaleCoords(&dx, &dy, angle, scale);
            Vertexes[cur->objnum].x=(centerx+dx+4)&~7;
            Vertexes[cur->objnum].y=(centery+dy+4)&~7;
         }
         Changed=1; MapChanged=1;
         break;
      case OBJ_LINE:
         vertices=0L;
         for (cur=obj; cur; cur=cur->next)
         {
            if (!IsSelected(vertices, Lines[cur->objnum].start))
               SelectObject(&vertices, Lines[cur->objnum].start);
            if (!IsSelected(vertices, Lines[cur->objnum].end))
               SelectObject(&vertices, Lines[cur->objnum].end);
         }
         RotateAndScaleObjects(OBJ_VERTEX, vertices, angle, scale);
         ForgetSelection(&vertices);
         break;
      case OBJ_SECTOR:
         vertices=0L;
         for (cur=obj; cur; cur=cur->next)
         {
            for (n=0; n<NumLines; n++)
               if (((m=Lines[n].side1)>=0 && Sides[m].sector==cur->objnum)
                || ((m=Lines[n].side2)>=0 && Sides[m].sector==cur->objnum))
               {
                  if (!IsSelected(vertices, Lines[n].start))
                     SelectObject(&vertices, Lines[n].start);
                  if (!IsSelected(vertices, Lines[n].end))
                     SelectObject(&vertices, Lines[n].end);
               }
         }
         RotateAndScaleObjects(OBJ_VERTEX, vertices, angle, scale);
         ForgetSelection(&vertices);
   }
}

int FindFreeTag()
{
   int  tag=1, n, ok=0;
   while (!ok)
   {
      ok =1;
      for (n=0; n<NumLines; n++) if (Lines[n].tag==tag) { ok=0; break; }
      if (ok) for (n=0; n<NumSectors; n++) if (Sectors[n].tag==tag) { ok=0; break; }
      tag++;
   }
   return tag-1;
}

void FlipLines(SelPtr obj, int swapvertices)
{
   SelPtr cur; int tmp;
   for (cur=obj; cur; cur=cur->next)
   {
      if (swapvertices)
      {
         tmp=Lines[cur->objnum].end;
         Lines[cur->objnum].end=Lines[cur->objnum].start;
         Lines[cur->objnum].start=tmp;
      }
      tmp=Lines[cur->objnum].side1;
      Lines[cur->objnum].side1=Lines[cur->objnum].side2;
      Lines[cur->objnum].side2=tmp;
   }
   Changed=1; MapChanged=1;
}

void MergeVertices(SelPtr *list)
{
   int v, l;
   v=(*list)->objnum;
   UnSelectObject(list, v);
   for (l=0; l<NumLines; l++)
   {
      if (IsSelected(*list, Lines[l].start))
      {
         if (!IsSelected(*list, Lines[l].end) && Lines[l].end != v)
            Lines[l].start=v;
      }
      else if (IsSelected(*list, Lines[l].end))
      {
         if (Lines[l].start != v) Lines[l].end=v;
      }
   }
   DeleteObjects(OBJ_VERTEX, list);
   Changed=1; MapChanged=1;
}

void SplitLines(SelPtr obj)
{
   SelPtr cur; int vstart, vend, sd;
   for (cur=obj; cur; cur=cur->next)
   {
      vstart=Lines[cur->objnum].start;
      vend=Lines[cur->objnum].end;
      InsertObject(OBJ_VERTEX, -1, (Vertexes[vstart].x+Vertexes[vend].x)/2, (Vertexes[vstart].y+Vertexes[vend].y)/2);
      InsertObject(OBJ_LINE, cur->objnum, 0, 0);
      Lines[cur->objnum].end=NumVertexes-1;
      Lines[NumLines-1].start=NumVertexes-1;
      sd=Lines[cur->objnum].side1;
      if (sd>=0)
      {
         InsertObject(OBJ_SIDE, sd, 0, 0);
         Lines[NumLines-1].side1=NumSides-1;
      }
      sd=Lines[cur->objnum].side2;
      if (sd>=0)
      {
         InsertObject(OBJ_SIDE, sd, 0, 0);
         Lines[NumLines-1].side2=NumSides-1;
      }
   }
   Changed=1; MapChanged=1;
}

void MergeSectors(SelPtr *slist)
{
  SelPtr cur; int n, olds, news;
  news=(*slist)->objnum;
  UnSelectObject(slist, news);
  for (cur=*slist; cur; cur=cur->next)
  {
     olds=cur->objnum;
     for (n=0; n<NumSides; n++)
     {
        if (Sides[n].sector==olds)
           Sides[n].sector=news;
     }
  }
  DeleteObjects(OBJ_SECTOR, slist);
  SelectObject(slist, news);
}
void AutoDivLine(SelPtr *list)
{
   SelPtr ref; int n, refv, sd, oldnumld; ref=*list;
   while (ref)
   {
   refv=ref->objnum; ref=ref->next; oldnumld=NumLines;
   for (n=0; n<oldnumld; n++)
     if (IsLineInside(n, Vertexes[refv].x-3, Vertexes[refv].y-3, Vertexes[refv].x+3, Vertexes[refv].y+3)&&
Lines[n].start!=refv&&Lines[n].end!=refv)
     {
	InsertObject(OBJ_LINE, n, 0, 0); Lines[n].end=refv;
	Lines[NumLines-1].start=refv; sd=Lines[n].side1;
	if (sd>=0)	{ InsertObject(OBJ_SIDE, sd, 0, 0); Lines[NumLines-1].side1=NumSides-1; }
	sd=Lines[n].side2;
	if (sd>=0)	{ InsertObject(OBJ_SIDE, sd, 0, 0); Lines[NumLines-1].side2=NumSides-1; }
	Changed=1; MapChanged=1;
     }
   }
}