// Emacs style mode select   -*- C++ -*-
//-----------------------------------------------------------------------------
//
// $Id:$
//
// Copyright (C) 1993-1996 by id Software, Inc.
//
// This source is available for distribution and/or modification
// only under the terms of the DOOM Source Code License as
// published by id Software. All rights reserved.
//
// The source is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// FITNESS FOR A PARTICULAR PURPOSE. See the DOOM Source Code License
// for more details.
//
// DESCRIPTION:
//   All the global variables that store the internal state.
//   Theoretically speaking, the internal state of the engine
//    should be found by looking at the variables collected
//    here, and every relevant module will have to include
//    this header file.
//   In practice, things are a bit messy.
//
//-----------------------------------------------------------------------------


#ifndef __D_STATE__
#define __D_STATE__

// We need globally shared data structures,
//  for defining the global state variables.
#include "doomdata.h"
#include "d_net.h"
#include "d_stuff.h"
#include "t_bsp.h"

// We need the playr data structure as well.
#include "d_player.h"

#ifdef __GNUG__
#pragma interface
#endif



// ------------------------
// Command line parameters.
//
extern  dboolean	nomonsters;	// checkparm of -nomonsters
extern  dboolean	respawnparm;	// checkparm of -respawn
extern  dboolean	fastparm;	// checkparm of -fast

extern  dboolean	devparm;	// DEBUG: launched with -devparm


// -----------------------------------------------------
// Game Mode - identify IWAD as shareware, retail etc.
//
extern GameMode_t	gamemode;
extern GameMission_t	gamemission;

// Set if homebrew PWAD stuff has been added.
extern  dboolean	modifiedgame;


// -------------------------------------------
// Language.
extern  Language_t   language;


// -------------------------------------------
// Selected skill type, map etc.
//

// Defaults for menu, methinks.
extern  skill_t		startskill;
extern  int			startepisode;
extern	int			startmap;

extern  dboolean	autostart;

// Selected by user.
extern  skill_t		gameskill;
extern  int			gameepisode;
extern  int			gamemap;

// Nightmare mode flag, single player.
extern  dboolean	respawnmonsters;

// Netgame? Only true if >1 player.
extern	dboolean	netgame;
extern	dboolean	netcheat;
extern	dboolean	netkill;

// Flag: true only if started as net deathmatch.
// An enum might handle altdeath/cooperative better.
extern int			deathmatch;

// -------------------------
// Internal parameters for sound rendering.
// These have been taken from the DOS version,
//  but are not (yet) supported with Linux
//  (e.g. no sound volume adjustment with menu.

// These are not used, but should be (menu).
// From m_menu.c:
//  Sound FX volume has default, 0 - 15
//  Music volume has default, 0 - 15
// These are multiplied by 8.
extern int snd_SfxVolume;      // maximum volume for sound
extern int snd_MusicVolume;    // maximum volume for music

// Current music/sfx card - index useless
//  w/o a reference LUT in a sound module.
// Ideally, this would use indices found
//  in: /usr/include/linux/soundcard.h
extern int snd_MusicDevice;
extern int snd_SfxDevice;
// Config file? Same disclaimer as above.
extern int snd_DesiredMusicDevice;
extern int snd_DesiredSfxDevice;


// -------------------------
// Status flags for refresh.
//

// Depending on view size - no status bar?
// Note that there is no way to disable the
//  status bar explicitely.
extern  dboolean statusbaractive;

extern	dboolean	ShowFPS;

extern  dboolean 	automapactive;	// In AutoMap mode?
extern	dboolean	automaponly;
extern  dboolean	menuactive;	// Menu overlayed?
extern  dboolean	paused;		// Game Pause?


extern  dboolean		viewactive;

extern  dboolean		nodrawers;
extern  dboolean		noblit;

extern	int		GammaLevel;
extern	dboolean	InWindow;
extern	int		ViewHeight;
extern	int		ViewWidth;

extern int		validcount;
extern fixed_t		*textureheight;
extern int		*texturetranslation;
extern int		*flattranslation;

extern int		numvertexes;
extern vertex_t		*vertexes;
extern int		numsegs;
extern seg_t		*segs;
extern int		numsectors;
extern sector_t		*sectors;
extern int		numsubsectors;
extern subsector_t	*subsectors;
extern int		numnodes;
extern node_t		*nodes;
extern int		numsides;
extern side_t		*sides;
extern int		numlines;
extern line_t		*lines;

extern int LevelChecksum;

// This one is related to the 3-screen display mode.
// ANG90 = left side, ANG270 = right
//extern  int	viewangleoffset;

// 1'st Player taking events, and displaying.

extern  int	displayplayer;
extern int	consoleplayer;
extern int	NumSplits;

// -------------------------------------
// Scores, rating.
// Statistics on a given map, for intermission.
//
extern  int	totalkills;
extern	int	totalitems;
extern	int	totalsecret;

// Timer, for scores.
extern  int	levelstarttic;	// gametic at level start
extern  int	leveltime;	// tics in game play for par



// --------------------------------------
// DEMO playback/recording related stuff.
// No demo, there is a human player in charge?
// Disable save/end game?
extern  dboolean	usergame;

//?
extern  dboolean	demoplayback;
extern  dboolean	demorecording;

// Quit after playing a demo from cmdline.
extern  dboolean		singledemo;




//?
extern  gamestate_t     gamestate;






//-----------------------------
// Internal parameters, fixed.
// These are set by the engine, and not changed
//  according to user inputs. Partly load from
//  WAD, partly set at startup time.



extern	int		gametic;


// Bookkeeping on players - state.
extern	player_t	players[MAXPLAYERS];

// Alive? Disconnected?
extern  dboolean		playeringame[MAXPLAYERS];


// Player spawn spots for deathmatch.
#define MAX_DM_STARTS   10
extern  mapthing_t      deathmatchstarts[MAX_DM_STARTS];
extern  mapthing_t*	deathmatch_p;

// Player spawn spots.
extern  mapthing_t      playerstarts[MAXPLAYERS];

// Intermission stats.
// Parameters for world map / intermission.
extern  wbstartstruct_t		wminfo;


// LUT of ammunition limits for each kind.
// This doubles with BackPack powerup item.
extern  int		maxammo[NUMAMMO];





//-----------------------------------------
// Internal parameters, used for engine.
//

//ignore user input in not on top
extern dboolean		InBackground;

// File handling stuff.
extern	char		basedefault[1024];
extern  FILE*		debugfile;

// if true, load all graphics at level load
extern  dboolean         precache;


// wipegamestate can be set to -1
//  to force a wipe on the next draw
extern  gamestate_t     wipegamestate;

extern  int             mouseSensitivity;
//?
// debug flag to cancel adaptiveness
extern  dboolean         singletics;

extern  int             bodyqueslot;


// Needed to store the number of the dummy sky flat.
// Used for rendering,
//  as well as tracking projectiles etc.
extern int		skyflatnum;

// Netgame stuff (buffers and pointers, i.e. indices).

//moved doomcom and netbuffer into i_net.h so can't accidentaly clobber in split-screen mode

//don't need to know about localtics, probably broken to to splitscreen anyway...
//extern  ticcmd_t	localcmds[BACKUPTICS];
extern	int		rndindex;

extern	int		maketic;
extern  int		nettics[MAXNETNODES];

extern ticcmd_t	netcmds[MAXPLAYERS][BACKUPTICS];
extern	int		ticdup;

extern dboolean	UsePVS;

#endif
//-----------------------------------------------------------------------------
//
// $Log:$
//
//-----------------------------------------------------------------------------
