// Emacs style mode select   -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id:$
//
// Copyright (C) 1993-1996 by id Software, Inc.
//
// This source is available for distribution and/or modification
// only under the terms of the DOOM Source Code License as
// published by id Software. All rights reserved.
//
// The source is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// FITNESS FOR A PARTICULAR PURPOSE. See the DOOM Source Code License
// for more details.
//
// $Log:$
//
// DESCRIPTION:
//	System interface for sound.
//
//-----------------------------------------------------------------------------

#include <windows.h>
#include <mmsystem.h>
#include "wcedoom.h"
#include "console.h"

static const char
rcsid[] = "$Id: i_unix.c,v 1.5 1997/02/03 22:45:10 b1 Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include <math.h>

//#include <sys/time.h>
//#include <sys/types.h>

//#ifndef LINUX
//#include <sys/filio.h>
//#endif

//#include <fcntl.h>
//#include <unistd.h>
//#include <sys/ioctl.h>

// Linux voxware output.
//#include <linux/soundcard.h>

// Timer stuff. Experimental.
//#include <time.h>
//#include <signal.h>

#include "z_zone.h"

#include "i_system.h"
#include "i_sound.h"
#include "m_argv.h"
#include "m_misc.h"
#include "w_wad.h"

#include "doomdef.h"

#ifdef WAVEOUT

extern windata_t  WinData;

#endif


/*
// UNIX hack, to be removed.
#ifdef SNDSERV
// Separate sound server process.
FILE*	sndserver=0;
char*	sndserver_filename = "./sndserver ";
#elif SNDINTR


// Update all 30 millisecs, approx. 30fps synchronized.
// Linux resolution is allegedly 10 millisecs,
//  scale is microseconds.
#define SOUND_INTERVAL     500

// Get the interrupt. Set duration in millisecs.
int I_SoundSetTimer( int duration_of_tick );
void I_SoundDelTimer( void );
#else
// None?
#endif
*/

// A quick hack to establish a protocol between
// synchronous mix buffer updates and asynchronous
// audio writes. Probably redundant with gametic.
static int flag = 0;

// The number of internal mixing channels,
//  the samples calculated for each mixing step,
//  the size of the 16bit, 2 hardware channel (stereo)
//  mixing buffer, and the samplerate of the raw data.


// Needed for calling the actual sound output.
#define SAMPLECOUNT		512
#define NUM_CHANNELS    8
// It is 2 for 16bit, and 2 for two channels.
#define BUFMUL          4   // wrong - BUFFER is ALREADY 16 bit
#define STEREO          2
#define MIXBUFFERSIZE   (SAMPLECOUNT*STEREO)

#define SAMPLERATE      11025	// Hz
#define SAMPLESIZE      2   	// 16bit

// The actual lengths of all sound effects.
int 		lengths[NUMSFX];

// The actual output device.
int	audio_fd;

// The global mixing buffer.
// Basically, samples from all active internal channels
//  are modifed and added, and stored in the buffer
//  that is submitted to the audio device.
signed short	mixbuffer[MIXBUFFERSIZE];

// Pitch to stepping lookup, unused.
int		        steptable[256];

// Volume lookups.
int		        vol_lookup[128*256];

// An "updated" waveOut channel handler setup

typedef enum { wav_idle, wav_playing } wav_status_t;
typedef enum { bits_8, bits_16 } wav_bits_t;
typedef enum { mono = 1, stereo } wav_channels_t;

typedef struct
   {
    wav_status_t    status;      // Is this channel playing or idle?
    unsigned char  *data;        // Pointer to wav data
    int             start_time;  // Game time sound started (gametic)
    int             length;      // Length of the sound sample
    int             position;    // Current position in sound sample
    int             handle;      // Generated handle returned to high level code
    int             sfxid;       // Internal (hardcoded) sound effect id
    wav_bits_t      bits;        // Sample size flag ( 16 or 8 bit)
    int             speed;       // playback speed value
    wav_channels_t  stereo;      // mono or stereo samples  (for later)
    unsigned int    step;        // pitch stepping factor
    unsigned int    remainder;   // pitch remainder
    int            *lvol;        // left volume lookup table pointer
    int            *rvol;        // right volume lookup table pointer
   }wav_channel_t;

wav_channel_t  wav_channel[NUM_CHANNELS];

// This function clears a "slot" and makes it ready for another sound
void ResetChannel( int slot )
   {
    wav_channel[slot].status = wav_idle;
    wav_channel[slot].data = 0;
    wav_channel[slot].start_time = 0;
    wav_channel[slot].length = 0;
    wav_channel[slot].position = 0;
    wav_channel[slot].handle = -1;
    wav_channel[slot].sfxid = -1;
    wav_channel[slot].bits = bits_8;
    wav_channel[slot].speed = 0;
    wav_channel[slot].stereo = mono;
    wav_channel[slot].step = 0;
    wav_channel[slot].remainder = 0;
    wav_channel[slot].lvol = 0;
    wav_channel[slot].rvol = 0;
   }

#ifdef WAVEOUT

// 64K is > 1 second at 16-bit, 22050 Hz
// 64K is > 2 seconds at 16-bit, 11025 Hz
#define	WAV_BUFFERS				32

#define BUFF_AHEAD              8
#define	WAV_MASK				0x1F
#define	WAV_BUFFER_SIZE			0x0400
#define SECONDARY_BUFFER_SIZE	0x10000

typedef enum {SIS_SUCCESS, SIS_FAILURE, SIS_NOTAVAIL} sndinitstat;

void Com_Printf(char *msg)
   {
    WriteDebug(msg);
   }

void Com_DPrintf(char *msg)
   {
    WriteDebug(msg);
   }

typedef struct
   {
    int            channels;
    int            samples;
    int            samplepos;
    int            samplebits;
    int            submission_chunk;
    int            speed;
    unsigned char *buffer;
   }sound_data_t;

sound_data_t dma;

typedef struct
   {
    int   value;
   }s_khz_t;

s_khz_t s_khz_x = { 11 }, *s_khz = &s_khz_x;

boolean	  wav_init;
boolean	  snd_firsttime = true, snd_isdirect, snd_iswave;
boolean	  primary_format_set;


// starts at 0 for disabled
static int	snd_buffer_count = 0;
static int	sample16;
static int	snd_sent, snd_completed, snd_mixed;
//int         paintedtime;

/* 
 * Global variables. Must be visible to window-procedure function 
 *  so it can unlock and free the data block after it has been played. 
 */ 

HANDLE		   hData;
unsigned char *lpData, *lpData2;
//HPSTR		lpData, lpData2;

HGLOBAL		hWaveHdr;
LPWAVEHDR	lpWaveHdr;

HWAVEOUT    hWaveOut; 

WAVEOUTCAPS	wavecaps;

DWORD	    gSndBufSize;

//MMTIME		mmstarttime;

#endif
//
// Safe ioctl, convenience.
//
void
myioctl
( int	fd,
  int	command,
  int*	arg )
{   
/*    
    int		rc;
    extern int	errno;

    rc = ioctl(fd, command, arg);  
    if (rc < 0)
    {
	fprintf(stderr, "ioctl(dsp,%d,arg) failed\n", command);
	fprintf(stderr, "errno=%d\n", errno);
	exit(-1);
    }
*/
}





//
// This function loads the sound data from the WAD lump,
//  for single sound.
//
void *getsfx( char *sfxname, int *len )
   {
    unsigned char*      sfx;
    unsigned char*      paddedsfx;
    int                 i;
    int                 size;
    int                 paddedsize;
    char                name[20];
    int                 sfxlump;

    
    // Get the sound data from the WAD, allocate lump
    //  in zone memory.
    strcpy(name, "ds");
    strcat(&name[2], sfxname);
    //sprintf(name, "ds%s", sfxname);

    // Now, there is a severe problem with the
    //  sound handling, in it is not (yet/anymore)
    //  gamemode aware. That means, sounds from
    //  DOOM II will be requested even with DOOM
    //  shareware.
    // The sound list is wired into sounds.c,
    //  which sets the external variable.
    // I do not do runtime patches to that
    //  variable. Instead, we will use a
    //  default sound for replacement.
    if ( W_CheckNumForName(name) == -1 )
      sfxlump = W_GetNumForName("dspistol");
    else
      sfxlump = W_GetNumForName(name);
    
    size = W_LumpLength( sfxlump );

    // Debug.
    // fprintf( stderr, "." );
    //fprintf( stderr, " -loading  %s (lump %d, %d bytes)\n",
    //	     sfxname, sfxlump, size );
    //fflush( stderr );
    
    sfx = (unsigned char*)W_CacheLumpNum( sfxlump, PU_STATIC );

    // Pads the sound effect out to the mixing buffer size.
    // The original realloc would interfere with zone memory.
    paddedsize = ((size-8 + (SAMPLECOUNT-1)) / SAMPLECOUNT) * SAMPLECOUNT;

    // Allocate from zone memory.
    paddedsfx = (unsigned char*)Z_Malloc( paddedsize+8, PU_STATIC, 0 );
    // ddt: (unsigned char *) realloc(sfx, paddedsize+8);
    // This should interfere with zone memory handling,
    //  which does not kick in in the soundserver.

    // Now copy and pad.
    memcpy(  paddedsfx, sfx, size );
    for (i=size ; i<paddedsize+8 ; i++)
        paddedsfx[i] = 128;

    // Remove the cached lump.
    Z_Free( sfx );
    
    // Preserve padded length.
    *len = paddedsize;

    // Return allocated padded data.
    return (void *)(paddedsfx + 8);
   }


//
// This function adds a sound to the
//  list of currently active sounds,
//  which is maintained as a given number
//  (eight, usually) of internal channels.
// Returns a handle.
//
int addsfx( int sfxid, int volume, int step, int seperation )
   {
    static unsigned short handlenums = 0;
 
    int		i;
    int		rc = -1;
    
    int		oldest = gametic;
    int		oldestnum = 0;
    int		slot;

    int		rightvol;
    int		leftvol;

    // Chainsaw troubles.
    // Play these sound effects only one at a time.
    if ( sfxid == sfx_sawup || sfxid == sfx_sawidl || sfxid == sfx_sawful ||
         sfxid == sfx_sawhit || sfxid == sfx_stnmov || sfxid == sfx_pistol )
       {
        // Loop all channels, check.
        for (i = 0; i < NUM_CHANNELS; i++)
           {
            if ((wav_channel[i].status == wav_playing) && (wav_channel[i].sfxid == sfxid))
               {
                ResetChannel(i);
                break;
               }
           }
       }

    // Loop all channels to find oldest playing SFX OR an open slot.
    //for (i = 0; (i < NUM_CHANNELS) && (channels[i]); i++)
    for (i = 0; (i < NUM_CHANNELS) && (wav_channel[i].status == wav_playing); i++)
       {
        if (wav_channel[i].start_time < oldest)
           {
            oldestnum = i;
            oldest = wav_channel[i].start_time;
           }
       }

    // Didn't find an open channel.  Let's TAKE one...
    if (i == NUM_CHANNELS)
	    slot = oldestnum;
    else
	    slot = i;

    //cprintf("effect %d using slot %d\n", sfxid, slot);

    // Okay, in the least recent channel, we will handle the new SFX.
    // Set pointer to raw data.
    wav_channel[slot].data = (unsigned char *)S_sfx[sfxid].data;
    // Set up the play length
    wav_channel[slot].length = lengths[sfxid];
    // Set the effect to the beginning
    wav_channel[slot].position = 0;

    // Reset current handle number, limited to 0..100.
    if (!handlenums)
        handlenums = 100;
    // Actually, this just makes sure that handle numbers 0 through 99 aren't used.

    // Assign current handle number.
    // Preserved so sounds could be stopped (unused).
    wav_channel[slot].handle = rc = handlenums++;

    // I'll keep this until I understand the pitch mechanism
    // Set the pitch stepping factor
    wav_channel[slot].step = step;
    // clear the remainder for stepping
    wav_channel[slot].remainder = 0;
    // set the channel start time
    wav_channel[slot].start_time = gametic;

    // Separation, that is, orientation/stereo.
    //  range is: 1 - 256
    seperation += 1;

    // Per left/right channel.
    //  x^2 seperation,
    //  adjust volume properly.
    leftvol = volume - ((volume*seperation*seperation) >> 16); ///(256*256);
    seperation = seperation - 257;
    rightvol = volume - ((volume*seperation*seperation) >> 16);	

    // Sanity check, clamp volume.
    if (rightvol < 0 || rightvol > 127)
        I_Error("rightvol out of bounds");
    
    if (leftvol < 0 || leftvol > 127)
        I_Error("leftvol out of bounds");
    
    // Get the proper lookup table piece for this volume level???
    wav_channel[slot].lvol = &vol_lookup[leftvol*256];
    wav_channel[slot].rvol = &vol_lookup[rightvol*256];

    // Preserve sound SFX id,
    //  e.g. for avoiding duplicates of chainsaw.
    wav_channel[slot].sfxid = sfxid;
    wav_channel[slot].status = wav_playing;

    // Return the generated sound effect "handle"
    return rc;
   }





//
// SFX API
// Note: this was called by S_Init.
// However, whatever they did in the
// old DPMS based DOS version, this
// were simply dummies in the Linux
// version.
// See soundserver initdata().
//
void I_SetChannels()
   {
    // Init internal lookups (raw data, mixing buffer, channels).
    // This function sets up internal lookups used during
    //  the mixing process. 
    int  i, j;
    int *steptablemid = steptable + 128;
  
    // Okay, reset internal mixing channels to zero.
    for (i = 0; i < NUM_CHANNELS; i++)
       {
        ResetChannel(i);
/*
        channels[i] = 0;
*/
       }

  // This table provides step widths for pitch parameters.
  // I fail to see that this is currently used.
  for (i=-128 ; i<128 ; i++)
    steptablemid[i] = (int)(pow(2.0, (i/64.0))*65536.0);
  
  
  // Generates volume lookup tables
  //  which also turn the unsigned samples
  //  into signed samples.
  for (i=0 ; i<128 ; i++)
    for (j=0 ; j<256 ; j++)
      vol_lookup[i*256+j] = (i*(j-128)*256)/127;
}	

 
void I_SetSfxVolume(int volume)
   {
  // Identical to DOS.
  // Basically, this should propagate
  //  the menu/config file setting
  //  to the state variable used in
  //  the mixing.
#ifdef WAVEOUT
    DWORD woVolume;

    woVolume = (((volume+1) *0xFFF) << 16) | ((volume+1) * 0xFFF);
    waveOutSetVolume(hWaveOut, woVolume);
#else
    snd_SfxVolume = volume;
#endif
   }

// MUSIC API - dummy. Some code from DOS version.
void I_SetMusicVolume(int volume)
{
  // Internal state variable.
  snd_MusicVolume = volume;
  // Now set volume on output device.
  // Whatever( snd_MusciVolume );
}


//
// Retrieve the raw data lump index
//  for a given SFX name.
//
int I_GetSfxLumpNum(sfxinfo_t* sfx)
{
    char namebuf[9];
    strcpy(namebuf, "ds");
    strcat(&namebuf[2], sfx->name);
    //sprintf(namebuf, "ds%s", sfx->name);
    return W_GetNumForName(namebuf);
}

//
// Starting a sound means adding it
//  to the current list of active sounds
//  in the internal channels.
// As the SFX info struct contains
//  e.g. a pointer to the raw data,
//  it is ignored.
// As our sound handling does not handle
//  priority, it is ignored.
// Pitching (that is, increased speed of playback)
//  is set, but currently not used by mixing.
//
int I_StartSound( int id, int vol, int sep, int pitch, int priority )
   {
    priority = 0;
  
    id = addsfx( id, vol, steptable[pitch], sep );

    return id;
   }



void I_StopSound (int handle)
   {
   int slot;
  
    for (slot = 0; slot < NUM_CHANNELS; slot++)
       {
        if (wav_channel[slot].handle == handle)
           {
            ResetChannel(slot);
           }
       }
   }


int I_SoundIsPlaying(int handle)
   {
    int slot;

    for (slot = 0; slot < NUM_CHANNELS; slot++)
       {
        // We found the slot with this handle - good
        if (wav_channel[slot].handle == handle)
           {
            if (wav_channel[slot].status == wav_playing)
               {
                return TRUE;
               }
            else
               {
                // should never get here - handle is reset
                return FALSE;
               }
           }
       }
    // Didn't find it so it isn't playing
    return FALSE;
   }



#ifdef WAVEOUT

/*
==============
SNDDMA_GetDMAPos

return the current sample position (in mono samples read)
inside the recirculating dma buffer, so the mixing code will know
how many samples are required to fill it up.
===============
*/
int I_GetDMAPos(void)
   {
//    MMTIME	mmtime;
    int		s;
//    DWORD	dwWrite;

/*
    if (dsound_init) 
       {
        mmtime.wType = TIME_SAMPLES;
        pDSBuf->lpVtbl->GetCurrentPosition(pDSBuf, &mmtime.u.sample, &dwWrite);
        s = mmtime.u.sample - mmstarttime.u.sample;
       }
	else
*/
    if (wav_init)
       {
        s = snd_sent * WAV_BUFFER_SIZE;
       }

    s >>= sample16;
    s &= (dma.samples-1);

    return s;
   }

#endif


//
// This function loops all active (internal) sound
//  channels, retrieves a given number of samples
//  from the raw sound data, modifies it according
//  to the current (internal) channel parameters,
//  mixes the per channel samples into the global
//  mixbuffer, clamping it to the allowed range,
//  and sets up everything for transferring the
//  contents of the mixbuffer to the (two)
//  hardware channels (left and right, that is).
//
// This function currently supports only 16bit.
//
char dbgmsg[256];

void I_UpdateSound( void )
   {
#ifdef SNDINTR
    // Debug. Count buffer misses with interrupt.
    static int             misses = 0;
#endif
  
    // Mix current sound data.
    // Data, from raw sound, for right and left.
    register unsigned int  sample;
    register int           dl;
    register int           dr;
  
    // Mixing channel index.
    int	                  chan;
    int                   i;

    // These are for using the waveOut mixing buffers
    int                   buff_filled, buff_avail;
    int                   sound_pending = 0;
    int                   sampcnt;
    signed short         *buffout;

#ifdef WAVEOUT
    // Is the waveOut stuff working?
    if (!wav_init)
       {
        return;
       }
#endif

    // Look for sounds that need to be played
    for (chan = 0; chan < NUM_CHANNELS; chan++ )
       {
        // BAL - a status variable would be MUCH better (idle v playing)
        // Check if channel is active. (has a data pointer)
        if (wav_channel[chan].status == wav_playing)
           {
            // found one waiting, increase the counter
            sound_pending++;
           }
       }

    // If no sounds to mix then jump out
    if (sound_pending == 0)
       {
        return;
       }

#ifdef WAVEOUT
    // See if any sound buffers have been finished and returned
    CheckSoundBuffers();
#endif

    // Mix sounds into the mixing buffer.
    // Loop over step*SAMPLECOUNT,
    //  that is 512 values for two channels.

    buff_filled = 0;
#ifdef WAVEOUT
    //buff_avail = BUFF_AHEAD-(snd_mixed-snd_completed);
    buff_avail = BUFF_AHEAD-(snd_sent-snd_completed);
    sampcnt = WAV_BUFFER_SIZE/SAMPLESIZE;
#else
    buff_avail = 1;
    sampcnt = 
#endif

// Need another loop here to handle all the buffers and the sound pending flag
    while ((buff_filled < buff_avail) && (sound_pending > 0))
       {
        // Setup the output buffer using one of the waveOut buffers
#ifdef WAVEOUT
        buffout = (short *)lpWaveHdr[(snd_sent+buff_filled)&WAV_MASK].lpData;
#else
        buffout = mixbuffer;
#endif
        memset(buffout, 0, WAV_BUFFER_SIZE);  // clear the buffer section to silence
        for (i = 0; ((i < sampcnt) && (sound_pending > 0)); i += 2)
           {
            // Clear left/right values. 
            dl = dr = 0;

            // Loop through all the channels to find the ones to play
            for ( chan = 0; chan < NUM_CHANNELS; chan++ )
               {
                // Check channel, if active.
                if (wav_channel[chan].status == wav_playing)
                //if (channels[ chan ])
                   { 
                    // Get the raw data from the channel.
                    sample = wav_channel[chan].data[wav_channel[chan].position];
                    //sample = *channels[chan];

                    // Set the channel "stereo" by setting each channel's volume
                    dl += (wav_channel[chan].lvol[sample]<<4);
                    dr += (wav_channel[chan].rvol[sample]<<4);

                    // add to the pitch stepper
                    wav_channel[chan].remainder += wav_channel[chan].step;
                    // take the high word of the value, shift it down and add to the position
                    wav_channel[chan].position += wav_channel[chan].remainder >> 16;
                    // take the high word off the value
                    wav_channel[chan].remainder &= 0xFFFF;

                    // Is this sound finished?
                    if (wav_channel[chan].position >= wav_channel[chan].length)
                       {
                        ResetChannel(chan);
                        sound_pending--;
                       }
                   }
               }
	
            // Clamp to range. Left hardware channel.
            if (dl > 0x7FFF)
               {
                buffout[i] = 0x7FFF;
               }
            else
            if (dl < (short)0x8000)
               {
                buffout[i] = (short)0x8000;
               }
            else
               {
                buffout[i] = dl;
               }
            // Same for right hardware channel.
            if (dr > 0x7FFF)
               {
                buffout[i+1] = 0x7FFF;
               }
            else
            if (dr < (short)0x8000)
               {
                buffout[i+1] = (short)0x8000;
               }
            else
               {
                buffout[i+1] = dr;
               }
           } // this loop modified to be a single waveOut buffer
#ifdef WAVEOUT
        buff_filled++;
        snd_mixed++;
//        paintedtime += WAV_BUFFER_SIZE;
       }
#endif

#ifdef SNDINTR
    // Debug check.
    if ( flag )
    {
      misses += flag;
      flag = 0;
    }
    
    if ( misses > 10 )
    {
      fprintf( stderr, "I_SoundUpdate: missed 10 buffer writes\n");
      misses = 0;
    }
    
    // Increment flag for update.
    flag++;
#endif
}


// 
// This would be used to write out the mixbuffer
//  during each game loop update.
// Updates sound buffer and audio device at runtime. 
// It is called during Timer interrupt with SNDINTR.
// Mixing now done synchronous, and
//  only output be done asynchronous?
//
void I_SubmitSound(void)
   {
    // Write it to DSP device.
// FIXME
    //  write(audio_fd, mixbuffer, SAMPLECOUNT*BUFMUL);
   }


void I_UpdateSoundParams(int handle, int vol, int sep, int pitch)
   {
    // I fail too see that this is used.
    // Would be using the handle to identify
    //  on which channel the sound might be active,
    //  and resetting the channel parameters.
 
    // UNUSED.
    int slot;
    int rightvol, leftvol;

    for (slot = 0; slot < NUM_CHANNELS; slot++)
       {
        if (wav_channel[slot].handle == handle)
           {
            sep += 1;
            // Per left/right channel. x^2 seperation, adjust volume properly.
            leftvol = vol - ((vol*sep*sep) >> 16);
            sep = sep - 257;
            rightvol = vol - ((vol*sep*sep) >> 16);	

            // Sanity check, clamp volume.
            if (rightvol < 0 || rightvol > 127)
                I_Error("rightvol out of bounds");
    
            if (leftvol < 0 || leftvol > 127)
                I_Error("leftvol out of bounds");
    
            // Get the proper lookup table piece for this volume level???
            wav_channel[slot].lvol = &vol_lookup[leftvol*256];
            wav_channel[slot].rvol = &vol_lookup[rightvol*256];
            break;
           }
       }
   }

#ifdef WAVEOUT

/*
==================
FreeSound
==================
*/
void FreeSound (void)
   {
    int   i;

    Com_DPrintf( "Shutting down sound system\n" );

/* no direct sound support in Windows CE (yet)
	if ( pDS )
		DS_DestroyBuffers();
*/

    if ( hWaveOut )
       {
        Com_DPrintf( "...resetting waveOut\n" );
        waveOutReset(hWaveOut);

        if (lpWaveHdr)
           {
            Com_DPrintf( "...unpreparing headers\n" );
            for (i = 0; i < WAV_BUFFERS; i++)
               {
                waveOutUnprepareHeader (hWaveOut, lpWaveHdr+i, sizeof(WAVEHDR));
               }
           }

        Com_DPrintf( "...closing waveOut\n" );
        waveOutClose (hWaveOut);

		//if (hWaveHdr)
        if (lpWaveHdr)
           {
            Com_DPrintf( "...freeing WAV header\n" );
            // These functions are not supported in Windows CE
            //GlobalUnlock(hWaveHdr);
            //GlobalFree(hWaveHdr);
            free(lpWaveHdr);
           }

        if (lpData)
           {
            Com_DPrintf( "...freeing WAV buffer\n" );
            // These functions are not supported in Windows CE
			//GlobalUnlock(hData);
			//GlobalFree(hData);
            free(lpData);
           }

       }

/* No Direct Sound support currently
    if ( pDS )
       {
        Com_DPrintf( "...releasing DS object\n" );
        pDS->lpVtbl->Release( pDS );
       }

    if ( hInstDS )
       {
        Com_DPrintf( "...freeing DSOUND.DLL\n" );
        FreeLibrary( hInstDS );
        hInstDS = NULL;
       }

    pDS = NULL;
    pDSBuf = NULL;
    pDSPBuf = NULL;
*/
    hWaveOut = 0;
    hData = 0;
    hWaveHdr = 0;
    lpData = NULL;
    lpWaveHdr = NULL;
// No direct sound support currently
//	dsound_init = false;
    wav_init = false;
    Com_DPrintf("...sound subsystem shutdown.\n");
   }

#endif


void I_ShutdownSound(void)
   {    
/*  This only works in an interrupt driven environment
    // Wait till all pending sounds are finished.
    boolean done = false;
    int     slot;
  

    // FIXME (below).
    //  fprintf( stderr, "I_ShutdownSound: NOT finishing pending sounds\n");
    //  fflush( stderr );
  
    while ( done  == false)
       {
        for (slot = 0; slot < NUM_CHANNELS && (wav_channel[slot].status != wav_playing); slot++);
    
        if (slot == NUM_CHANNELS)
            done = true;
       }
*/
#ifdef SNDINTR
    I_SoundDelTimer();
#endif
 
    // Cleaning up -releasing the DSP device.
// FIXME
//    close ( audio_fd );

  // Done.
#ifdef WAVEOUT
    FreeSound();
#endif

    return;
   }


#ifdef WAVEOUT

#define SAMPBITS 16

boolean InitWaveOut()
   {
	WAVEFORMATEX  format; 
	int				i;
	HRESULT			hr;

	Com_Printf( "Initializing wave sound\n" );
	con_printf(TEXT("Initializing wave sound\n"));
	
	snd_sent = 0;
	snd_completed = 0;
    snd_mixed = 0;

	dma.channels = 2;
	dma.samplebits = 16;

	if (s_khz->value == 44)
		dma.speed = 44100;
	if (s_khz->value == 22)
		dma.speed = 22050;
	else
		dma.speed = 11025;

	memset (&format, 0, sizeof(format));
	format.wFormatTag       = WAVE_FORMAT_PCM;
	format.nChannels        = dma.channels;
	format.wBitsPerSample   = dma.samplebits;
	format.nSamplesPerSec   = dma.speed;
	format.nBlockAlign      = format.nChannels*format.wBitsPerSample / 8;
	format.cbSize           = 0;
	format.nAvgBytesPerSec  = format.nSamplesPerSec*format.nBlockAlign;
	
	// Open a waveform device for output using window callback.
	Com_DPrintf ("...opening waveform device: ");
	while ((hr = waveOutOpen((LPHWAVEOUT)&hWaveOut, WAVE_MAPPER, 
            &format, 0, 0L, CALLBACK_NULL)) != MMSYSERR_NOERROR)
       {
/*
		if (hr != MMSYSERR_ALLOCATED)
           {
			Com_Printf ("failed\n");
			return false;
           }
*/
        switch(hr)
           {
            case MMSYSERR_ALLOCATED:
                 MessageBox (NULL, TEXT("The sound hardware appears to be in use by another app.\n"), TEXT("Sound not available"), MB_OK);
                 Com_Printf ("hw in use\n" );
                 return false;

            case MMSYSERR_BADDEVICEID:
                 MessageBox (NULL, TEXT("The device identifier for the sound hardware is out of range.\n"), TEXT("Sound not available"), MB_OK);
                 Com_Printf ("Specified device is out of range...\n" );
                 return false;

            case MMSYSERR_NODRIVER:
                 MessageBox (NULL, TEXT("No device drivers is present."),TEXT("Sound not available"), MB_OK);
                 Com_Printf ("No device drivers present...\n" );
                 return false;

            case MMSYSERR_NOMEM:
                 MessageBox (NULL, TEXT("Unable to allocate or lock memory."),TEXT("Sound not available"), MB_OK);
                 Com_Printf ("Unable to allocate or lock memory.\n");
                 return false;

            case WAVERR_BADFORMAT:
                 MessageBox (NULL, TEXT("Attempted to open with an unsupported waveform-audio format."),TEXT("Sound not available"),MB_OK);
                 Com_Printf ("Attempted to open with an unsupported waveform-audio format.\n");
                 return false;

            case WAVERR_SYNC:
                 MessageBox (NULL, TEXT("The device is synchronous but waveOutOpen was called without using the WAVE_ALLOWSYNC flag."),TEXT("Sound not available"),MB_OK);
                 Com_Printf ("The device is synchronous but waveOutOpen was called without using the WAVE_ALLOWSYNC flag.\n");
                 return false;
           }
        if (hr != MMSYSERR_NOERROR)
           {
            Com_Printf("failed -- unknown error\n");
            return false;
           }
       } 
	Com_DPrintf( "ok\n" );

    /* 
	 * Allocate and lock memory for the waveform data. The memory 
	 * for waveform data must be globally allocated with 
	 * GMEM_MOVEABLE and GMEM_SHARE flags. 
	*/ 

	Com_DPrintf ("...allocating waveform buffer: ");
	gSndBufSize = WAV_BUFFERS*WAV_BUFFER_SIZE;
    lpData = malloc(gSndBufSize);
    // Windows CE does not support GlobalAlloc/GlobalLock, etc.
	//hData = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, gSndBufSize); 
	//if (!hData) 
	if (!lpData) 
       {  
		Com_Printf( " failed\n" );
		FreeSound ();
		return false; 
       }
	Com_DPrintf( "ok\n" );

    // Windows CE does not support GlobalAlloc/GlobalLock, etc.
/*
	Com_DPrintf ("...locking waveform buffer: ");
	lpData = GlobalLock(hData);
	if (!lpData)
	{ 
		Com_Printf( " failed\n" );
		FreeSound ();
		return false; 
	} 
	Com_DPrintf( "ok\n" );
*/
	memset (lpData, 0, gSndBufSize);

    /* 
	 * Allocate and lock memory for the header. This memory must 
	 * also be globally allocated with GMEM_MOVEABLE and 
	 * GMEM_SHARE flags. 
	 */ 

	Com_DPrintf ("...allocating waveform header: ");
    // Windows CE does not support GlobalAlloc/GlobalLock, etc.
	//hWaveHdr = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE,(DWORD) sizeof(WAVEHDR) * WAV_BUFFERS);
	lpWaveHdr = malloc((DWORD) sizeof(WAVEHDR) * WAV_BUFFERS);

	//if (hWaveHdr == NULL)
	if (lpWaveHdr == NULL)
       { 
		Com_Printf( "failed\n" );
		FreeSound ();
		return false; 
       } 
	Com_DPrintf( "ok\n" );

    // Windows CE does not support GlobalAlloc/GlobalLock, etc.
/*
	Com_DPrintf ("...locking waveform header: ");
	lpWaveHdr = (LPWAVEHDR) GlobalLock(hWaveHdr); 

	if (lpWaveHdr == NULL)
	{ 
		Com_Printf( "failed\n" );
		FreeSound ();
		return false; 
	}
	Com_DPrintf( "ok\n" );
*/
	memset (lpWaveHdr, 0, sizeof(WAVEHDR) * WAV_BUFFERS);

	// After allocation, set up and prepare headers.
	Com_DPrintf ("...preparing headers: ");
	for (i = 0; i < WAV_BUFFERS; i++)
       {
		lpWaveHdr[i].dwBufferLength = WAV_BUFFER_SIZE; 
		lpWaveHdr[i].lpData = lpData + i*WAV_BUFFER_SIZE;

		if (waveOutPrepareHeader(hWaveOut, lpWaveHdr+i, sizeof(WAVEHDR)) != MMSYSERR_NOERROR)
           {
			Com_Printf ("failed\n");
			FreeSound ();
			return false;
           }
       }
	Com_DPrintf ("ok\n");

	dma.samples = gSndBufSize/(dma.samplebits/8);
	dma.samplepos = 0;
	dma.submission_chunk = 512;
	dma.buffer = (unsigned char *)lpData;
	sample16 = (dma.samplebits/8) - 1;
//    paintedtime = 0;

	wav_init = true;

    for (i = 0; i < NUM_CHANNELS; i++)
       {
        ResetChannel(i);
       }

	return true;
   }

void CheckSoundBuffers(void)
   {
	while (1)
       {
		if ( snd_completed == snd_sent )
           {
			//Com_DPrintf ("Sound overrun\n");
			break;
           }

		if ( ! (lpWaveHdr[ snd_completed & WAV_MASK].dwFlags & WHDR_DONE) )
           {
			break;
           }
		snd_completed++;	// this buffer has been played
       }
   }

void SubmitSoundBuffers(void)
   {
//  LPWAVEHDR	h;
	int			wResult;

	if (!dma.buffer)
		return;

/*  No DirectSound support in WindowsCE (yet)
	// unlock the dsound buffer
	if (pDSBuf)
		pDSBuf->lpVtbl->Unlock(pDSBuf, dma.buffer, locksize, NULL, 0);
*/
	if (!wav_init)
		return;

	//
	// find which sound blocks have completed
	//
/*  Don't think we need to do this here...
	while ((1) && (first == false))
       {
		if ( snd_completed == snd_sent )
           {
			//Com_DPrintf ("Sound overrun\n");
			break;
           }

		if ( ! (lpWaveHdr[ snd_completed & WAV_MASK].dwFlags & WHDR_DONE) )
           {
			break;
           }
		snd_completed++;	// this buffer has been played
       }
*/
//Com_Printf ("completed %i\n", snd_completed);
	//
	// submit a few new sound blocks
    //
    if (snd_sent == snd_completed)
       {
        snd_firsttime = true;
        waveOutPause(hWaveOut);
       }
    while (((snd_sent - snd_completed) >> sample16) < BUFF_AHEAD)
       {
#ifndef _WIN32_WCE
        //cprintf("Writing sound buffer...%d\n", snd_sent);
#endif
        if (snd_mixed <= snd_sent)
           {
            break;
           }
		/* 
		 * Now the data block can be sent to the output device. The 
		 * waveOutWrite function returns immediately and waveform 
		 * data is sent to the output device in the background. 
		 */ 
		wResult = waveOutWrite(hWaveOut, &lpWaveHdr[snd_sent&WAV_MASK], sizeof(WAVEHDR)); 
		snd_sent++;
		if (wResult != MMSYSERR_NOERROR)
           { 
            switch(wResult)
               {
                case MMSYSERR_INVALHANDLE:
			         Com_Printf("Specified device handle is invalid.\n");
                     break;

                case MMSYSERR_NODRIVER:
			         Com_Printf("No device driver is present.\n");
                     break;

                case MMSYSERR_NOMEM:
			         Com_Printf("Unable to allocate or lock memory.\n");
                     break;

                case WAVERR_UNPREPARED:
			         Com_Printf("The data block pointed to by the pwh parameter hasnt been prepared.\n");
                     break;
               }
		    Com_Printf("Failed to write block to device\n");
		    FreeSound();
			return; 
           } 
       }
    if (snd_firsttime == true)
       {
        waveOutRestart(hWaveOut);
        snd_firsttime = false;
       }
   }

DWORD  woFormats[] = { WAVE_FORMAT_1M08,
                       WAVE_FORMAT_1M16,
                       WAVE_FORMAT_1S08,
                       WAVE_FORMAT_1S16,
                       WAVE_FORMAT_2M08,
                       WAVE_FORMAT_2M16,
                       WAVE_FORMAT_2S08,
                       WAVE_FORMAT_2S16,
                       WAVE_FORMAT_4M08,
                       WAVE_FORMAT_4M16,
                       WAVE_FORMAT_4S08,
                       WAVE_FORMAT_4S16 };

unsigned char *woFormDesc[] = { "11.025 kHz, mono, 8-bit\n",
                                "11.025 kHz, mono, 16-bit\n", 
                                "11.025 kHz, stereo, 8-bit\n", 
                                "11.025 kHz, stereo, 16-bit\n", 
                                "22.05 kHz, mono, 8-bit\n", 
                                "22.05 kHz, mono, 16-bit\n", 
                                "22.05 kHz, stereo, 8-bit\n", 
                                "22.05 kHz, stereo, 16-bit\n", 
                                "44.1 kHz, mono, 8-bit\n", 
                                "44.1 kHz, mono, 16-bit\n", 
                                "44.1 kHz, stereo, 8-bit\n", 
                                "44.1 kHz, stereo, 16-bit\n" };

TCHAR msg[1024];

BOOL TestOpenWaveOut()
   {
    WAVEOUTCAPS   woc;
    UINT          nDevId;
    MMRESULT      rc;
    UINT          nMaxDevices = waveOutGetNumDevs();
    int           i;

    if (nMaxDevices == 0)
       {
        WriteDebug("No WaveOut devices.\n");
        return FALSE;
       }

    for (nDevId = 0; nDevId < nMaxDevices; nDevId++)
       {
        rc = waveOutGetDevCaps(nDevId, &woc, sizeof(WAVEOUTCAPS));
        if (rc == MMSYSERR_NOERROR)
           {
            WriteDebug("Supported sound format(s):\n");
            for (i = 0; i < 12; i++)
               {
                if (woc.dwFormats & woFormats[i])
                   {
                    WriteDebug(woFormDesc[i]);
                   }
               }
            break;
           }
        else
           {
            waveOutGetErrorText(rc, msg, 1024);
            MessageBox(WinData.hWnd, msg, TEXT("DOOMCE Error"), MB_OK);
            return FALSE;
           }
       }
    return TRUE;
   }

#endif

void I_InitSound()
   { 
    int i;
  
    // Secure and configure sound device first.
//    fprintf( stderr, "I_InitSound: ");
  
    // Initialize external data (all sounds) at start, keep static.
//    fprintf( stderr, "I_InitSound: ");
  
    for (i = 1; i < NUMSFX; i++)
       { 
        // Alias? Example is the chaingun sound linked to pistol.
        if (!S_sfx[i].link)
           {
            // Load data from WAD file.
            S_sfx[i].data = getsfx( S_sfx[i].name, &lengths[i] );
           }	
        else
           {
            // Previously loaded already?
            S_sfx[i].data = S_sfx[i].link->data;
            lengths[i] = lengths[(S_sfx[i].link - S_sfx)/sizeof(sfxinfo_t)];
           }
       }

//    fprintf( stderr, " pre-cached all sound data\n");
  
    // Now initialize mixbuffer with zero.
    for ( i = 0; i < MIXBUFFERSIZE; i++ )
       {
        mixbuffer[i] = 0;
       }
  
    // Finished initialization.
//    fprintf(stderr, "I_InitSound: sound module ready\n");
#ifdef WAVEOUT
    TestOpenWaveOut();
    InitWaveOut();
#endif
   }




//
// MUSIC API.
// Still no music done.
// Remains. Dummies.
//
void I_InitMusic(void)		{ }
void I_ShutdownMusic(void)	{ }

static int	looping=0;
static int	musicdies=-1;

void I_PlaySong(int handle, int looping)
{
  // UNUSED.
  handle = looping = 0;
  musicdies = gametic + TICRATE*30;
}

void I_PauseSong (int handle)
{
  // UNUSED.
  handle = 0;
}

void I_ResumeSong (int handle)
{
  // UNUSED.
  handle = 0;
}

void I_StopSong(int handle)
{
  // UNUSED.
  handle = 0;
  
  looping = 0;
  musicdies = 0;
}

void I_UnRegisterSong(int handle)
{
  // UNUSED.
  handle = 0;
}

int I_RegisterSong(void* data)
{
  // UNUSED.
  data = NULL;
  
  return 1;
}

// Is the song playing?
int I_QrySongPlaying(int handle)
{
  // UNUSED.
  handle = 0;
  return looping || musicdies > gametic;
}



//
// Experimental stuff.
// A Linux timer interrupt, for asynchronous
//  sound output.
// I ripped this out of the Timer class in
//  our Difference Engine, including a few
//  SUN remains...
//  
#ifdef sun
    typedef     sigset_t        tSigSet;
#else    
    typedef     int             tSigSet;
#endif


// We might use SIGVTALRM and ITIMER_VIRTUAL, if the process
//  time independend timer happens to get lost due to heavy load.
// SIGALRM and ITIMER_REAL doesn't really work well.
// There are issues with profiling as well.

//FIXME
#define ITIMER_REAL 0
#define SIGALRM     0
//FIXME

static int /*__itimer_which*/  itimer = ITIMER_REAL;

static int sig = SIGALRM;

// Interrupt handler.
void I_HandleSoundTimer( int ignore )
{
  // Debug.
  //fprintf( stderr, "%c", '+' ); fflush( stderr );
  
  // Feed sound device if necesary.
  if ( flag )
  {
    // See I_SubmitSound().
    // Write it to DSP device.
// FIXME
    //write(audio_fd, mixbuffer, SAMPLECOUNT*BUFMUL);

    // Reset flag counter.
    flag = 0;
  }
  else
    return;
  
  // UNUSED, but required.
  ignore = 0;
  return;
}

/*
// Get the interrupt. Set duration in millisecs.
int I_SoundSetTimer( int duration_of_tick )
{
  // Needed for gametick clockwork.
  struct itimerval    value;
  struct itimerval    ovalue;
  struct sigaction    act;
  struct sigaction    oact;

  int res;
  
  // This sets to SA_ONESHOT and SA_NOMASK, thus we can not use it.
  //     signal( _sig, handle_SIG_TICK );
  
  // Now we have to change this attribute for repeated calls.
  act.sa_handler = I_HandleSoundTimer;
#ifndef sun    
  //ac	t.sa_mask = _sig;
#endif
  act.sa_flags = SA_RESTART;
  
  sigaction( sig, &act, &oact );

  value.it_interval.tv_sec    = 0;
  value.it_interval.tv_usec   = duration_of_tick;
  value.it_value.tv_sec       = 0;
  value.it_value.tv_usec      = duration_of_tick;

  // Error is -1.
  res = setitimer( itimer, &value, &ovalue );

  // Debug.
  if ( res == -1 )
    fprintf( stderr, "I_SoundSetTimer: interrupt n.a.\n");
  
  return res;
}
*/

// Remove the interrupt. Set duration to zero.
void I_SoundDelTimer()
{
  // Debug.
// FIXME
//  if ( I_SoundSetTimer( 0 ) == -1)
//    fprintf( stderr, "I_SoundDelTimer: failed to remove interrupt. Doh!\n");
}


/*

  FindWritePosition

  Mixsounds

  AddTobuffers

  WriteBuffers

*/