
//
// i_dos.h
//

#ifndef __I_DOS_H__
#define __I_DOS_H__

typedef union {
    struct {
	unsigned long edi;
	unsigned long esi;
	unsigned long ebp;
	unsigned long res;
	unsigned long ebx;
	unsigned long edx;
	unsigned long ecx;
	unsigned long eax;
    } d;
    struct {
	unsigned short di, di_hi;
	unsigned short si, si_hi;
	unsigned short bp, bp_hi;
	unsigned short res, res_hi;
	unsigned short bx, bx_hi;
	unsigned short dx, dx_hi;
	unsigned short cx, cx_hi;
	unsigned short ax, ax_hi;
	unsigned short flags;
	unsigned short es;
	unsigned short ds;
	unsigned short fs;
	unsigned short gs;
	unsigned short ip;
	unsigned short cs;
	unsigned short sp;
	unsigned short ss;
    } x;
    struct {
	unsigned char edi[4];
	unsigned char esi[4];
	unsigned char ebp[4];
	unsigned char res[4];
	unsigned char bl, bh, ebx_b2, ebx_b3;
	unsigned char dl, dh, edx_b2, edx_b3;
	unsigned char cl, ch, ecx_b2, ecx_b3;
	unsigned char al, ah, eax_b2, eax_b3;
    } h;
} regs_t;


unsigned int ptr2real(void *ptr);
void*	     real2ptr(unsigned int real);
void*	     far2ptr(unsigned int farptr);
unsigned int ptr2far(void *ptr);

int dos_int86(int vec);

void *dos_getmemory(int size);
void dos_freememory(void *ptr);

int  dos_lockmem(void *addr, int size);
int  dos_unlockmem(void *addr, int size);

extern regs_t regs;

#endif	// __I_DOS_H__

