//
// Copyright(C) 1999,2007 Simon Howard
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
//

/***************************** FraggleScript ******************************/
                // Copyright(C) 1999 Simon Howard 'Fraggle' //
//
// Functions
//
// functions are stored as variables(see variable.c), the
// value being a pointer to a 'handler' function for the
// function. Arguments are stored in an argc/argv-style list
//
// this module contains all the handler functions for the
// basic FraggleScript Functions.

/* includes ************************/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "main.h"
#include "parse.h"
#include "spec.h"
#include "operator.h"
#include "variable.h"
#include "func.h"

svalue_t evaluate_expression(int start, int stop);
int find_token(int start, int stop, char *value);

        // functions. SF_ means Script Function not, well.. heh, me

        /////////// actually running a function /////////////


/*******************
  FUNCTIONS
 *******************/

// the actual handler functions for the
// functions themselves

// arguments are evaluated and passed to the
// handler functions using 't_argc' and 't_argv'
// in a similar way to the way C does with command
// line options.

// values can be returned from the functions using
// the variable 't_return'

void SF_Print()
{
        int i;

        if(!t_argc) return;

        for(i=0; i<t_argc; i++)
        {
                if(t_argv[i].type == vt_string)
                        printf("%s", t_argv[i].value.s);
                else    // assume int
                        printf("%i", (int)t_argv[i].value.i);
        }
}

        // return a random number from 0 to 255
void SF_Rnd()
{
        t_return.type = vt_int;
        t_return.value.i = rand() % 256;
}

        // looping section. using the rover, find the highest level
        // loop we are currently in and return the section_t for it.

section_t *looping_section()
{
        section_t *best = NULL;         // highest level loop we're in
                                        // that has been found so far
        int n;

                // check thru all the hashchains
        for(n=0; n<SECTIONSLOTS; n++)
        {
           section_t *current = current_script->sections[n];

                // check all the sections in this hashchain
           while(current)
           {
                        // a loop?
                if(current->type == st_loop)
                       // check to see if it's a loop that we're inside
                   if(rover >= current->start && rover <= current->end)
                   {
                        // a higher nesting level than the best one so far?
                      if(!best || (current->start > best->start))
                          best = current;     // save it
                   }
                current = current->next;
           }
        }

        return best;    // return the best one found
}

        // "continue;" in FraggleScript is a function
void SF_Continue()
{
        section_t *section;

        if(!(section = looping_section()) )       // no loop found
        {
                script_error("continue() not in loop");
                return;
        }

        rover = section->end;      // jump to the closing brace
}

void SF_Break()
{
        section_t *section;

        if(!(section = looping_section()) )
        {
                script_error("break() not in loop");
                return;
        }
        rover = section->end+1;   // jump out of the loop
}

void SF_Goto()
{
        if(t_argc != 1)
        {
                script_error("incorrect arguments to goto\n");
                return;
        }

        // check argument is a labelptr

        if(t_argv[0].type != vt_label)
        {
                script_error("goto argument not a label\n");
                return;
        }

        // go there then if everythings fine

        rover = t_argv[0].value.labelptr;
}


void SF_Return()
{
        killscript = true;      // kill the script
}

void SF_Input()
{
        static char inputstr[128];

        gets(inputstr);

        t_return.type = vt_string;
        t_return.value.s = inputstr;
}

void SF_Beep()
{
        printf("\a"); fflush(stdout);
}

void SF_Clock()
{
        t_return.type = vt_int;
        t_return.value.i = (clock()*100)/CLOCKS_PER_SEC;
}

void init_functions()
{

                // add all the functions

        new_function("break", SF_Break);
        new_function("continue", SF_Continue);
        new_function("return", SF_Return);
        new_function("goto", SF_Goto);

        new_function("print", SF_Print);
        new_function("rnd", SF_Rnd);
        new_function("input", SF_Input);
        new_function("beep", SF_Beep);
        new_function("clock", SF_Clock);
}
