//
// Copyright(C) 1999,2007 Simon Howard
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
//

/***************************** FraggleScript ******************************/
                // Copyright(C) 1999 Simon Howard 'Fraggle' //
//
// Main function.
//
// Loads script, runs stuff in parse.c
//
// this is the interface between the real world and fragglescript really,
// this prepares the script and the other modules run it

/* includes ************************/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <time.h>

#include "operator.h"
#include "func.h"
#include "parse.h"
#include "variable.h"
#include "prepro.h"

#define SCRIPTFILE "test.fs"

script_t *script;
char *script_file = SCRIPTFILE;

void load_script(char *s);
void shuffle_rand();

int main(int argc, char *argv[])
{
        printf("*** FraggleScript! ***\n"
               "\n"
               "BETA version: under devel!\n"
               "Copyright (C) 1999 Simon Howard\n\n");

        // check command line
        for(;argc>1; argc--)
                if(!strcmp(argv[argc-1], "-debug")) script_debug = true;
		else script_file = argv[argc-1];

        init_variables();
        init_functions();
        shuffle_rand();        

        load_script(script_file);

                // preprocess the script
        killscript = false;
        preprocess(script);

                // run the script
        if(!killscript)
           parse_script(script);

        if(!killscript)
                printf("\nscript terminated normally\n");
        else
                printf("\nscript killed\n");

        return 0;
}

void error(char *s, ...)
{
        va_list args;
        va_start(args, s);

        printf("\n\n");
        vfprintf(stderr, s, args);

        exit(-1);
}

void load_script(char *s)
{
        FILE *fs;

        fs = fopen(s, "rb");
        if(!fs) error("file unfound!");
	// use this if you want console input
	//    fs = stdin;

        script = malloc(sizeof(script_t));
                    // 5000 max     -- will not be a problem when in SMMU
        script->data = malloc(5000);
        memset(script->data, 0, 5000);

        s = script->data;
        while(!feof(fs))
        {
                fread(s, 1, 1, fs);
                s++;
        }

        script->len = s-script->data;
                 // add a NULL to the end of the script
        script->data[script->len] = 0;
        fclose(fs);
}

void shuffle_rand()
{
        int rngseed;

        rngseed = time(NULL);

        srand(rngseed);
}


