//
// Copyright(C) 1999,2007 Simon Howard
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
//

#ifndef __PARSE_H__
#define __PARSE_H__

#define MAXTOKENS 64
#define TOKENLENGTH 128

#define intvalue(v)     \
        ( (v).type == vt_string ? atoi((v).value.s) : (v).value.i )

typedef struct script_s script_t;
typedef struct svalue_s svalue_t;
typedef struct operator_s operator_t;
typedef enum {false, true} boolean;

struct svalue_s
{
        int type;
        union
        {
                long i;
                char *s;
                char *labelptr; // goto() label
        } value;
};


#include "variable.h"
#include "prepro.h"
#include <stdlib.h>

struct script_s
{
        // script data

        char *data;
        int len;

        // {} sections

        section_t *sections[SECTIONSLOTS];

        // variables:

        svariable_t *variables[VARIABLESLOTS];
};

struct operator_s
{
        char *string;
        svalue_t (*handler)(int, int, int); // left, mid, right
        int direction;
};

enum
{
        forward,
        backward
};

enum
{
        vt_string,
        vt_int,
        vt_function,     // functions are stored as variables
        vt_label,        // labels for goto calls are variables
};

svalue_t evaluate_expression(int start, int stop);
void run_statement();
char *run_line(char *data);
void parse_script(script_t *script);
int find_token(int start, int stop, char *value);
void script_error(char *s, ...);

/******* tokens **********/

typedef enum {
        name,   // a name, eg 'count1' or 'frag'
        number,
        operator,
        string,
        unset,
        bracket_open,
        bracket_close,
        function          // function name
} tokentype_t;

extern char *tokens[MAXTOKENS];
extern tokentype_t tokentype[MAXTOKENS];
extern int num_tokens;
extern script_t *current_script;
extern svalue_t nullvar;
extern int script_debug;
extern char *rover;     // current point reached in parsing
extern char *linestart; // start of the current expression
extern int killscript;

extern section_t *current_section;
extern section_t *prev_section;
extern int bracetype;

#endif
