//
// Copyright(C) 1999,2007 Simon Howard
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
//

/***************************** FraggleScript ******************************/
                // Copyright(C) 1999 Simon Howard 'Fraggle' //
//
// 'Special' stuff
//
// if(), int statements, etc.
//

/* includes ************************/

#include <stdio.h>
#include "parse.h"
#include "main.h"
#include "variable.h"

int find_token(int start, int stop, char *value);

        // ending brace found in parsing
void spec_brace()
{
        if(bracetype != bracket_close)  // only deal with closing } braces
                return;

                        // if() requires nothing to be done
        if(current_section->type == st_if) return;

        if(current_section->type == st_loop)
        {
                rover = current_section->data.data_loop.loopstart;
                return;
        }
}

        // 'if' statement
void spec_if()
{
        int endtoken;
        svalue_t eval;

        if( (endtoken = find_token(0, num_tokens-1, ")")) == -1)
        {
                script_error("parse error in if statement");
                return;
        }

                // 2 to skip past the 'if' and '('
        eval = evaluate_expression(2, endtoken-1);

        if(current_section && bracetype == bracket_open
           && endtoken == num_tokens-1)
        {
                current_section->type = st_if;  // mark as if

                // {} braces
                if(!intvalue(eval))       // skip to end of section
                        rover = current_section->end+1;
        }
        else    // if() without {} braces
                if(intvalue(eval))
                {
                                    // nothing to do ?
                        if(endtoken == num_tokens-1) return;
                        evaluate_expression(endtoken+1, num_tokens-1);
                }
}

void spec_while()      // while() loop
{
        int endtoken;
        svalue_t eval;

        if(!current_section)
        {
                script_error("no {} section given for loop");
                return;
        }

        if( (endtoken = find_token(0, num_tokens-1, ")")) == -1)
        {
                script_error("parse error in loop statement");
                return;
        }

        current_section->type = st_loop;    // mark as loop
        current_section->data.data_loop.loopstart = linestart;

        eval = evaluate_expression(2, endtoken-1);

                      // skip if no longer valid
        if(!intvalue(eval)) rover = current_section->end+1;
}

void spec_for()                 // for() loop
{
        svalue_t eval;
        int start;
        int comma1, comma2;     // token numbers of the seperating commas

        if(!current_section)
        {
                script_error("need {} delimiters for for()");
                return;
        }

        // is a valid section

        current_section->type = st_loop;
        current_section->data.data_loop.loopstart = linestart;

        start = 2;     // skip "for" and "(": start on third token(2)

        // find the seperating commas first

        if( (comma1 = find_token(start,    num_tokens-1, ",")) == -1
         || (comma2 = find_token(comma1+1, num_tokens-1, ",")) == -1)
        {
                script_error("incorrect arguments to if()");
                return;
        }

                     // are we looping back from a previous loop?
        if(current_section == prev_section)
        {
                // do the loop 'action' (third argument)
                evaluate_expression(comma2+1, num_tokens-2);

                // check if we should run the loop again (second argument)
                eval = evaluate_expression(comma1+1, comma2-1);
                if(!intvalue(eval))
                {
                        // stop looping
                        rover = current_section->end + 1;
                }
        }
        else
        {
                // first time: starting the loop
                // just evaluate the starting expression (first arg)
                evaluate_expression(start, comma1-1);
        }
}

/**************************** Variable Creation ****************************/

int newvar_type;

        // called for each individual variable in a statement
        //  newvar_type must be set
void create_variable(int start, int stop)
{
        if(killscript) return;

        if(tokentype[start] != name)
        {
                script_error("invalid name for variable: '%s'",
                                        tokens[start+1]);
                return;
        }

                    // check if already exists, only checking
                    // the current script
        if( variableforname(current_script, tokens[start]) )
                return;  // already one

        new_variable(current_script, tokens[start], newvar_type);

        if(stop != start) evaluate_expression(start, stop);
}

        // divide a statement (without type prefix) into individual
        // variables to be create them using create_variable
void parse_var_line(start)
{
        int starttoken = 1, endtoken;   // start on second token(1)
        
        while(1)
        {
                if(killscript) return;
                endtoken = find_token(starttoken, num_tokens-1, ",");
                if(endtoken == -1) break;
                create_variable(starttoken, endtoken-1);
                starttoken = endtoken+1;  //start next after end of this one
        }
                  // dont forget the last one
        create_variable(starttoken, num_tokens-1);
}

        // these functions merely set newvar_type, strip the prefix
        // from the statement and call parse_var_line

        // int %s.  Create a new integer variable
void spec_int()
{
        newvar_type = vt_int;

        parse_var_line();
}

        // string %s.  Create a new string variable
        // rather similar to spec_int =)
void spec_string()
{
        newvar_type = vt_string;

        parse_var_line();
}
