/* Emacs style mode select   -*- C++ -*-
 *-----------------------------------------------------------------------------
 *
 *
 *  PrBoom a Doom port merged with LxDoom and LSDLDoom
 *  based on BOOM, a modified and improved DOOM engine
 *  Copyright (C) 1999 by
 *  id Software, Chi Hoang, Lee Killough, Jim Flynn, Rand Phares, Ty Halderman
 *  Copyright (C) 1999-2000 by
 *  Jess Haas, Nicolas Kalkhof, Colin Phipps, Florian Schulze
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 *  02111-1307, USA.
 *
 * DESCRIPTION:
 *  Thing frame/state LUT,
 *  generated by multigen utilitiy.
 *  This one is the original DOOM version, preserved.
 *  BOOM changes include commenting and addition of predefined lumps
 *  for providing things that aren't in the IWAD without sending a
 *  separate must-use wad file around with the EXE.
 *
 *-----------------------------------------------------------------------------
 */

#include "doomdef.h"
#include "sounds.h"
#include "m_fixed.h"
#include "p_mobj.h"
#include "w_wad.h"
#include "d_items.h"
#include "d_englsh.h"

/*#ifdef __GNUG__
#pragma implementation "info.h"
#endif
#include "info.h"*/


// ********************************************************************
// Sprite names
// ********************************************************************
// This is the list of sprite 4-character prefixes.  They are searched
// through, with a NULL entry terminating the list.  In DOOM originally
// this NULL entry was missing, and coincidentally the next thing in
// memory was the dummy state_t[] entry that started with zero bytes.
// killough 1/17/98: add an explicit NULL entry.
// NUMSPRITES is an enum from info.h where all these are listed
// as SPR_xxxx

const char *sprnames[NUMSPRITES+1] = {
  "TNT1","PLAY", // invisible sprite                                 phares 3/9/98
  //=====================Strife Sprites========================kaiser
  "PNCH","WAVE","RBPY","TRGT","XBOW","MMIS","RIFG","RIFF","FLMT","FLMF","BLST","BLSF",
  "GREN","GREF","SIGH","SIGF","POW1","POW2","POW3","ZAP1","SPRY","BLOD","PUFY","SHT1",
  "SHT2","GRIN","GRAP","UBAM","BNG2","BNG4","BNG3","FLBE","XPRK","OCLW","CCLW","TEND",
  "MICR","MISS","AROW","ARWP","TORP","THIT","TWAV","MISL","TFOG","IFOG","SHRD","RGIB",
  "MRYS","MRNO","MRST","MRLK","MRBD","MRPN","MRGT","BURN","DISR","PEAS","GIBS","AGRD",
  "ARMR","SACR","TNK1","TNK2","TNK3","TNK4","TNK5","TNK6","NEAL","BEGR","HMN1","LEDR",
  "LEAD","ROB1","PGRD","ROB2","MLDR","ORCL","PRST","PDED","ALN1","AL1P","NODE","MTHD",
  "MNAM","MNAL","MDTH","NEST","PODD","ZAP6","ZOT3","ZAP7","ZOT1","ZAP5","ZOT2","SEWR",
  "SPID","ROB3",
  "RBB3","PRGR","BASE","FRBL","KLAX","TURT","BALL","PSTN","SECR","TARG","RING","EARS",
  "COMM","BOOM","RATT","HOGN","DEAD","SBAN","BOTR","HATR","TOPR","COUP","BUBB","BUBF",
  "BUBC","ASPR","SPDL","TOKN","OTOK","HELT","GUNT","FULL","MEAT","JUNK","FFOT","DIE1",
  "BEAC","ARM1","ARM2","BARW","BART","LAMP","LANT","BARL","BOWL","BRAZ","TRCH","LTRH",
  "LMPC","LOGS","TRHO","WATR","MUGG","FUSL","CRD1","CRD2","TPAS","KY1G","KY2S","KY3B",
  "HAND","CRYS","PRIS","PWR1","PWR2","PWR3","ORAC","GYID","FUBR","WARE","RCRY","BCRY",
  "CHAP","TUNL","BLTK","SECK","MINE","REBL","PROC","ANKH","GOID","STMP","MDKT","COIN",
  "CRED","SACK","CHST","SHD1","MASK","UNIF","OFIC","PMAP","PMUP","BLIT","BBOX","MSSL",
  "ROKT","BRY1","CPAC","PQRL","XQRL","GRN1","GRN2","BKPK","RELC","RIFL","FLAM","BFLM",
  "MMSL","TRPD","GRND","CBOW","SIGL","LITE","CNDL","CLBR","LITS","LITB","LITG","ROK1",
  "ROK2","ROK3","ROK4","LOGG","RUB1","RUB2","RUB3","RUB4","RUB5","RUB6","RUB7","RUB8",
  "CHAN","STAT","DSTA","CRAB","CAGE","TREE","TRE1","BUSH","SHRB","STAK","BAR1","VASE",
  "STOL","POT1","TUB1","ANVL","TLMP","TRAY","APOW","AFED","DRIP","CDRP","SPLH","WTFT",
  "HERT","TELP","MONI","STEL","STLA","STLE","HUGE","STLG",




#ifdef DOGS
  "DOGS", /* killough 7/19/98: Marine's best friend :) */
#endif
  NULL
};

// ********************************************************************
// Function addresses or Code Pointers
// ********************************************************************
// These function addresses are the Code Pointers that have been
// modified for years by Dehacked enthusiasts.  The new BEX format
// allows more extensive changes (see d_deh.c)

// Doesn't work with g++, needs actionf_p1
void A_Light0();
void A_WeaponReady();
void A_Lower();
void A_Raise();
void A_Punch();
void A_ReFire();
void A_Light1();
void A_Light2();
void A_CheckReload();
void A_FireMissile();
void A_Explode();
void A_Pain();
void A_PlayerScream();
void A_Fall();
void A_XScream();
void A_Look();
void A_Chase();
void A_FaceTarget();
void A_Scream();
void A_Die();
void A_Stop();
void A_Detonate();        /* killough 8/9/98: detonate a bomb or other device */
void A_Mushroom();        /* killough 10/98: mushroom effect */
void A_LineEffect();
void A_FireShotgun2();
void A_RemoveElectricBolt();	//kaiser
void A_GunFlashThinker();	//kaiser
void A_ShowElectricBolt();	//kaiser
void A_FireArrowBolt();	//kaiser
void A_BoltAlarm();	//kaiser
void A_FireArrowPoison();	//kaiser
void A_BringUpBolt();	//kaiser
void A_FireRiffle();	//kaiser
void A_Explode2();		//kaiser
void A_FireGrenade();	//kaiser
void A_GrendadeTic();	//kaiser
void A_Explode3();	//kaiser
void A_Rocketpuff();	//kaiser
void A_FireFlameThrower();	//kaiser
void A_FireRaise();		//kaiser
void A_SpawnGrenadeFire();	//kaiser
void A_GPFireTic();	//kaiser
void A_BurnSpread();	//kaiser
void A_TorpedoSound();	//kaiser
void A_FireTorpedo();	//kaiser
void A_TorpedoExplode();	//kaiser
void A_GlassShatter();	//kaiser
void A_SigilSound();	//kaiser
void A_SigilBeginFire();	//kaiser
void A_SigilShock();	//kaiser
void A_SigilTrail();	//kaiser
void A_FireSigilWeapon();	//kaiser
void A_KeepSigilDrawing();	//kaiser
void A_Sigil_E_Action();	//kaiser
void A_Stand();			//kaiser
void A_AgrdAttack();	//kaiser
void A_BodyParts();		//kaiser
void A_Patrol();	//kaiser
void A_Burn();		//kaiser
void A_BurnScream();	//kaiser
void A_DropBurnFlesh();	//kaiser
void A_DropItem();	//kaiser
void A_ShadowOn();		//kaiser
void A_ShadowOff();	//kaiser
void A_PeasAttack();	//kaiser
void A_PeasFall();		//kaiser
void A_ObjectWatch();	//kaiser
void A_Alarm();		//kaiser
void A_ObjectChase();	//kaiser
void A_TurretReFire();	//kaiser
void A_BackSound();	//kaiser
void A_Wander();	//kaiser
void A_BeGone();	//kaiser
void A_AguardPain();	//kaiser
void A_PgrdAttack();	//kaiser
void A_PgrdShoot();	//kaiser
void A_ReavShoot();	//kaiser
void A_ReavAttack();	//kaiser
void A_StalkerThinker();	//kaiser
void A_StalkerDrop();	//kaiser
void A_StalkerAttack();	//kaiser
void A_StalkerSetLook();	//kaiser
void A_StalkerWalk();	//kaiser
void A_BarrelExplode();	//kaiser
void A_ActorRefire();	//kaiser
void A_SentinelAttack();	//kaiser
void A_Levitate();	//kaiser
void A_CrusaderAttack();	//kaiser
void A_CrusaderLeft();	//kaiser
void A_CrusaderRight();	//kaiser
void A_ActorRepeatFire();	//kaiser
void A_ProgrammerAttack();	//kaiser
void A_ProgrammerDie();	//kaiser
void A_ProgrammerGrab();	//kaiser
void A_ProgrammerSpecial();	//kaiser
void A_Sigil_A_Action();	//kaiser
void A_Sigil_A_Attack();	//kaiser
void A_ChainTend();	//kaiser
void A_PriestAttack();	//kaiser
void A_SpectureMelee();	//kaiser
void A_PriestDie();	//kaiser
void A_SpectureAttack();	//kaiser
void A_NodeChunk();	//kaiser
void A_HeadChunk();	//kaiser
void A_BishopAttack();	//kaiser
void A_Seeker();	//kaiser
void A_DropInqArm();	//kaiser
void A_InqShootGun();	//kaiser
void A_InqThinker();	//kaiser
void A_InqGrenade();	//kaiser
void A_InqFlyCheck();	//kaiser
void A_InqTakeOff();	//kaiser
void A_InqFly();	//kaiser
void A_InqGrenadeExplode();	//kaiser
void A_SpectureBReveal();	//kaiser
void A_SpectureDReveal();	//kaiser
void A_SpectureCAttack();	//kaiser
void A_OracleSpecial();	//kaiser
void A_ActorSpecialEvent();	//kaiser
void A_SpectureDAttack();	//kaiser
void A_ZombieInSpecialSector();	//kaiser
void A_SpawnZombie();	//kaiser
void A_SpectureEAttack();	//kaiser
void A_EntityChooseAttack();	//kaiser
void A_EntityBorn();	//kaiser
void A_SubEntitySpawn();	//kaiser
void A_DegninExplode();	//kaiser
void A_QuestExplode();	//kaiser
void A_QuestUpdate1();	//kaiser
void A_CloseShop();	//kaiser
void A_ClearSoundTarget();	//kaiser
void A_CrystalExplode();	//kaiser
void A_CrystalChuck();	//kaiser
void A_AcolyteSpecial();	//kaiser
void A_NewWorldWarp();	//kaiser
void A_TBeacon();

// ********************************************************************
// State or "frame" information
// ********************************************************************
// Each of the states, otherwise known as "frames", is outlined
// here.  The data in each element of the array is the way it is
// initialized, with sprite names identified by their enumerator
// value such as SPR_SHTG.  These correlate to the above sprite
// array so don't change them around unless you understand what
// you're doing.
//
// The commented name beginning with S_ at the end of each line
// is there to help figure out where the next-frame pointer is
// pointing.  These are also additionally identified in info.h
// as enumerated values.  From a change-and-recompile point of
// view this is fairly workable, but it adds a lot to the effort
// when trying to change things externally.  See also the d_deh.c
// parts where frame rewiring is done for more details and the
// extended way a BEX file can handle this.

state_t states[NUMSTATES] = {
  {SPR_PNCH,0,-1,NULL,S_NULL,0,0},  // S_NULL
  {SPR_PNCH,4,0,A_Light0,S_NULL,0,0}, // S_LIGHTDONE
  {SPR_TNT1,0,-1,NULL,S_NULL,0,0},  // S_UNKNOWN
  {SPR_TNT1,1,-1,NULL,S_NULL,0,0},  // S_UNKNOWN2

  //Targeter
  {SPR_TRGT,0,-1,NULL,S_NULL,0,0},
  {SPR_TRGT,1,-1,NULL,S_NULL,0,0},
  {SPR_TRGT,2,-1,NULL,S_NULL,0,0},

  //Srife Weapon 1: Fist Blade - kaiser
  {SPR_PNCH,0,1,A_WeaponReady,S_PUNCH,0,0},
  {SPR_PNCH,0,1,A_Lower,S_PUNCHDOWN,0,0}, 
  {SPR_PNCH,0,1,A_Raise,S_PUNCHUP,0,0},
  {SPR_PNCH,1,4,NULL,S_PUNCH2,0,0},
  {SPR_PNCH,2,4,A_Punch,S_PUNCH3,0,0},
  {SPR_PNCH,3,5,NULL,S_PUNCH4,0,0},
  {SPR_PNCH,2,4,NULL,S_PUNCH5,0,0},
  {SPR_PNCH,1,5,A_ReFire,S_PUNCH,0,0},
  //Puff
  {SPR_POW2,0,4,NULL,S_PUFP2,0,0},
  {SPR_POW2,1,4,NULL,S_PUFP3,0,0},
  {SPR_POW2,2,4,NULL,S_PUFP4,0,0},
  {SPR_POW2,3,4,NULL,S_PUFP5,0,0},
  {SPR_POW2,4,4,NULL,S_NULL,0,0},

  //Srife Weapon 2:	CrossBow	-kaiser
  {SPR_XBOW,0,1,A_WeaponReady,S_XBOW,0,0},
  {SPR_XBOW,0,1,A_Lower,S_XBOWDOWN,0,0},
  {SPR_XBOW,0,1,A_Raise,S_XBOWUP,0,0},
  {SPR_XBOW,0,3,A_GunFlashThinker,S_XBOW2,0,0},
  {SPR_XBOW,1,4,A_FireArrowBolt,S_XBOW3,0,0},
  {SPR_XBOW,2,6,NULL,S_XBOW4,0,0},
  {SPR_XBOW,3,3,NULL,S_XBOW5,0,0},
  {SPR_XBOW,4,5,NULL,S_XBOW6,0,0},
  {SPR_XBOW,5,5,NULL,S_XBOW7,0,0},
  {SPR_XBOW,6,5,A_CheckReload,S_XBOW,0,0},
  {SPR_XBOW,10,5,NULL,S_XBOWFLASH2,0,0},
  {SPR_XBOW,11,5,NULL,S_XBOWFLASH3,0,0},
  {SPR_XBOW,12,5,NULL,S_XBOWFLASH1,0,0},
  //Version 2
  {SPR_XBOW,7,1,A_WeaponReady,S_PXBOW,0,0},
  {SPR_XBOW,7,1,A_Lower,S_PXBOWDOWN,0,0},
  {SPR_XBOW,7,1,A_Raise,S_PXBOWUP,0,0},
  {SPR_XBOW,7,3,NULL,S_PXBOW2,0,0},
  {SPR_XBOW,1,6,A_FireArrowPoison,S_PXBOW3,0,0},
  {SPR_XBOW,2,4,NULL,S_PXBOW4,0,0},
  {SPR_XBOW,3,6,NULL,S_PXBOW5,0,0},
  {SPR_XBOW,4,3,NULL,S_PXBOW6,0,0},
  {SPR_XBOW,8,5,NULL,S_PXBOW7,0,0},
  {SPR_XBOW,9,5,A_CheckReload,S_PXBOW,0,0},	//FIXME
  //Arrow
  {SPR_AROW,0,-1,NULL,S_EAROW1,0,0},	//FIXME
  {SPR_ARWP,0,-1,NULL,S_PAROW1,0,0},	//FIXME
  //ArrowPuff
  {SPR_ZAP1,0,3,NULL,S_ZAP2,0,0},
  {SPR_ZAP1,1,3,A_BoltAlarm,S_ZAP3,0,0},
  {SPR_ZAP1,2,3,NULL,S_ZAP4,0,0},
  {SPR_ZAP1,3,3,NULL,S_ZAP5,0,0},
  {SPR_ZAP1,4,3,NULL,S_ZAP6,0,0},
  {SPR_ZAP1,5,3,NULL,S_ZAP7,0,0},
  {SPR_ZAP1,4,3,NULL,S_ZAP8,0,0},
  {SPR_ZAP1,3,3,NULL,S_ZAP9,0,0},
  {SPR_ZAP1,2,2,NULL,S_ZAP10,0,0},
  {SPR_ZAP1,1,2,NULL,S_ZAP11,0,0},
  {SPR_ZAP1,0,2,NULL,S_NULL,0,0},
  {SPR_ARWP,0,1,NULL,S_NULL,0,0},

  //Strife Weapon 3: Rifle	-kaiser
  {SPR_RIFG,0,1,A_WeaponReady,S_RIFFLE,0,0},
  {SPR_RIFG,1,1,A_Lower,S_RIFFLEDOWN,0,0},
  {SPR_RIFG,0,1,A_Raise,S_RIFFLEUP,0,0}, 
  {SPR_RIFF,0,3,A_FireRiffle,S_RIFFLE2,0,0}, 
  {SPR_RIFF,1,3,A_FireRiffle,S_RIFFLE3,0,0},
  {SPR_RIFG,3,3,A_FireRiffle,S_RIFFLE4,0,0},
  {SPR_RIFG,2,0,A_ReFire,S_RIFFLE5,0,0},
  {SPR_RIFG,1,2,NULL,S_RIFFLE,0,0},
  //Puff
  {SPR_PUFY,32768,4,NULL,S_PUFY2,0,0},
  {SPR_PUFY,1,4,NULL,S_PUFY3,0,0},
  {SPR_PUFY,2,4,NULL,S_PUFY4,0,0},
  {SPR_PUFY,3,4,NULL,S_NULL,0,0},

  //Strife Weapon 4: MiniLauncher	-kaiser
  {SPR_MMIS,0,1,A_WeaponReady,S_MMISSILE,0,0},
  {SPR_MMIS,0,1,A_Lower,S_MMISSILEDOWN,0,0},
  {SPR_MMIS,0,1,A_Raise,S_MMISSILEUP,0,0},
  {SPR_MMIS,0,4,A_FireMissile,S_MMISSILE2,0,0},
  {SPR_MMIS,1,4,A_Light1,S_MMISSILE3,0,0},
  {SPR_MMIS,32769,5,NULL,S_MMISSILE4,0,0},
  {SPR_MMIS,32770,2,A_Light2,S_MMISSILE5,0,0},
  {SPR_MMIS,32771,2,NULL,S_MMISSILE6,0,0},
  {SPR_MMIS,32772,2,A_Light0,S_MMISSILE7,0,0},
  {SPR_MMIS,5,0,A_ReFire,S_MMISSILE,0,0},
  //Rocket
  {SPR_MICR,32768,6,A_Rocketpuff,S_MINIMISSLE,0,0},
  //Puff
  {SPR_MISL,32768,5,A_Explode,S_MISSILE_X2,0,0},
  {SPR_MISL,32769,5,NULL,S_MISSILE_X3,0,0},
  {SPR_MISL,32770,4,NULL,S_MISSILE_X4,0,0},
  {SPR_MISL,32771,2,NULL,S_MISSILE_X5,0,0},
  {SPR_MISL,32772,2,NULL,S_MISSILE_X6,0,0},
  {SPR_MISL,32773,2,NULL,S_MISSILE_X7,0,0},
  {SPR_MISL,32774,2,NULL,S_NULL,0,0},

  //Strife Weapon 5: Grenade Launcher	-kaiser
  {SPR_GREN,0,1,A_WeaponReady,S_SGRENADE,0,0},
  {SPR_GREN,0,1,A_Lower,S_SGRENADEDOWN,0,0},
  {SPR_GREN,0,1,A_Raise,S_SGRENADEUP,0,0},
  {SPR_GREN,0,5,A_FireGrenade,S_SGRENADE2,0,0},
  {SPR_GREN,1,10,NULL,S_SGRENADE3,0,0},
  {SPR_GREN,0,5,A_FireGrenade,S_SGRENADE4,0,0},
  {SPR_GREN,2,10,NULL,S_SGRENADE5,0,0},
  {SPR_GREN,0,10,A_ReFire,S_SGRENADE,0,0},
  {SPR_GREF,32768,5,A_Light1,S_LIGHTDONE,0,0},
  {SPR_GREN,32768,10,A_Light0,S_SGRENADEFLASH3,0,0},
  {SPR_GREF,32769,5,A_Light2,S_LIGHTDONE,0,0},
  //Version 2
  {SPR_GREN,3,1,A_WeaponReady,S_FGRENADE,0,0},
  {SPR_GREN,3,1,A_Lower,S_FGRENADEDOWN,0,0},
  {SPR_GREN,3,1,A_Raise,S_FGRENADEUP,0,0},
  {SPR_GREN,3,5,A_FireGrenade,S_FGRENADE2,0,0},
  {SPR_GREN,4,10,NULL,S_FGRENADE3,0,0},
  {SPR_GREN,3,5,A_FireGrenade,S_FGRENADE4,0,0},
  {SPR_GREN,5,10,NULL,S_FGRENADE5,0,0},
  {SPR_GREN,3,10,A_ReFire,S_FGRENADE,0,0},
  {SPR_GREF,32770,5,A_Light1,S_LIGHTDONE,0,0},
  {SPR_GREN,32770,10,A_Light0,S_FGRENADEFLASH3,0,0},
  {SPR_GREF,32771,5,A_Light2,S_LIGHTDONE,0,0},
  //Grenade
  {SPR_GRAP,0,5,A_GrendadeTic,S_GRENADE_HE_2,0,0},
  {SPR_GRAP,1,5,A_GrendadeTic,S_GRENADE_HE_1,0,0},
  //PGrenade
  {SPR_GRIN,0,5,A_GrendadeTic,S_GRENADE_P_2,0,0},
  {SPR_GRIN,1,5,A_GrendadeTic,S_GRENADE_P_1,0,0},
  //Puff
  {SPR_BNG4,32768,3,A_Explode2,S_GRENADE_HE_X2,0,0},
  {SPR_BNG4,32769,3,NULL,S_GRENADE_HE_X3,0,0},
  {SPR_BNG4,32770,2,NULL,S_GRENADE_HE_X4,0,0},
  {SPR_BNG4,32771,3,NULL,S_GRENADE_HE_X5,0,0},
  {SPR_BNG4,32772,3,NULL,S_GRENADE_HE_X6,0,0},
  {SPR_BNG4,32773,3,NULL,S_GRENADE_HE_X7,0,0},
  {SPR_BNG4,32774,3,NULL,S_GRENADE_HE_X8,0,0},
  {SPR_BNG4,32775,3,NULL,S_GRENADE_HE_X9,0,0},
  {SPR_BNG4,32776,3,NULL,S_GRENADE_HE_X10,0,0},
  {SPR_BNG4,32777,3,NULL,S_GRENADE_HE_X11,0,0},
  {SPR_BNG4,32778,3,NULL,S_GRENADE_HE_X12,0,0},
  {SPR_BNG4,32779,3,NULL,S_GRENADE_HE_X13,0,0},
  {SPR_BNG4,32780,3,NULL,S_GRENADE_HE_X14,0,0},
  {SPR_BNG4,32781,3,NULL,S_NULL,0,0},
  {SPR_BNG3,32768,1,A_SpawnGrenadeFire,S_NULL,0,0},
  //Fire Explosion
  {SPR_BNG3,32769,2,A_Explode2,S_PFLAME2,0,0},
  {SPR_BNG3,32770,2,A_GPFireTic,S_PFLAME3,0,0},	//FIXME
  {SPR_FLBE,32768,2,A_BurnSpread,S_PFLAME4,0,0},
  {SPR_FLBE,32768,2,A_GPFireTic,S_PFLAME5,0,0},
  {SPR_FLBE,32769,2,A_Explode2,S_PFLAME6,0,0},
  {SPR_FLBE,32770,3,A_GPFireTic,S_PFLAME7,0,0},
  {SPR_FLBE,32771,3,A_Explode2,S_PFLAME8,0,0},
  {SPR_FLBE,32772,3,A_GPFireTic,S_PFLAME9,0,0},
  {SPR_FLBE,32773,3,A_BurnSpread,S_PFLAME7,0,0},
  {SPR_FLBE,32774,2,NULL,S_PFLAMEEND2,0,0},
  {SPR_FLBE,32775,2,NULL,S_PFLAMEEND3,0,0},
  {SPR_FLBE,32776,2,NULL,S_PFLAMEEND4,0,0},
  {SPR_FLBE,32777,2,NULL,S_NULL,0,0},


  //Strife Weapon 6: Flame Thrower	-kaiser
  {SPR_FLMT,0,3,A_WeaponReady,S_FLAMEREADY2,0,0},
  {SPR_FLMT,1,3,A_WeaponReady,S_FLAMEREADY1,0,0},
  {SPR_FLMT,0,1,A_Lower,S_FLAMEDOWN,0,0},
  {SPR_FLMT,0,1,A_Raise,S_FLAMEUP,0,0},
  {SPR_FLMF,0,2,NULL,S_FLAME2,0,0},
  {SPR_FLMF,1,2,A_FireFlameThrower,S_FLAME3,0,0},
  {SPR_FLMF,1,3,A_ReFire,S_FLAMEREADY1,0,0},
  //Fireball
  {SPR_FRBL,0,3,NULL,S_FLAMEFX_2,0,0},
  {SPR_FRBL,1,3,NULL,S_FLAMEFX_3,0,0},
  {SPR_FRBL,2,3,NULL,S_FLAMEFX_1,0,0},
  //Puff
  {SPR_FRBL,3,5,A_FireRaise,S_FLAMEFX_X2,0,0},
  {SPR_FRBL,4,5,NULL,S_FLAMEFX_X3,0,0},
  {SPR_FRBL,5,5,NULL,S_FLAMEFX_X4,0,0},
  {SPR_FRBL,6,5,NULL,S_FLAMEFX_X5,0,0},
  {SPR_FRBL,7,5,NULL,S_FLAMEFX_X6,0,0},
  {SPR_FRBL,8,5,NULL,S_NULL,0,0},

  //Strife Weapon 7: Mauler 	-kaiser
  {SPR_BLST,5,5,A_WeaponReady,S_BLASTERA,0,0},
  {SPR_BLST,6,5,A_WeaponReady,S_BLASTERB,0,0},
  {SPR_BLST,7,5,A_WeaponReady,S_BLASTERC,0,0},
  {SPR_BLST,0,5,A_WeaponReady,S_BLASTER,0,0},
  {SPR_BLST,0,1,A_Lower,S_BLASTERDOWN,0,0},
  {SPR_BLST,0,1,A_Raise,S_BLASTERUP,0,0},
  {SPR_BLSF,32768,5,A_FireShotgun2,S_BLASTER2,0,0},
  {SPR_BLST,32769,3,A_Light1,S_BLASTER3,0,0},
  {SPR_BLST,2,2,A_Light2,S_BLASTER4,0,0},
  {SPR_BLST,3,2,NULL,S_BLASTER5,0,0},
  {SPR_BLST,4,2,NULL,S_BLASTER6,0,0},
  {SPR_BLST,0,7,A_Light0,S_BLASTER7,0,0},
  {SPR_BLST,7,7,NULL,S_BLASTER8,0,0},
  {SPR_BLST,6,7,A_CheckReload,S_BLASTER,0,0},
  //Version 2
  {SPR_BLST,8,7,A_WeaponReady,S_XBLASTERA,0,0},
  {SPR_BLST,9,7,A_WeaponReady,S_XBLASTERB,0,0},
  {SPR_BLST,10,7,A_WeaponReady,S_XBLASTERC,0,0},
  {SPR_BLST,11,7,A_WeaponReady,S_XBLASTER,0,0},
  {SPR_BLST,8,1,A_Lower,S_XBLASTERDOWN,0,0},
  {SPR_BLST,8,1,A_Raise,S_XBLASTERUP,0,0},
  {SPR_BLST,8,20,A_TorpedoSound,S_XBLASTER2,0,0},
  {SPR_BLST,9,10,A_Light1,S_XBLASTER3,0,0},
  {SPR_BLSF,32768,10,A_FireTorpedo,S_XBLASTER4,0,0},
  {SPR_BLST,32769,3,A_Light2,S_XBLASTER5,0,0},
  {SPR_BLST,2,2,NULL,S_XBLASTER6,0,0},
  {SPR_BLST,3,2,A_Light0,S_XBLASTER7,0,0},
  {SPR_BLST,4,2,A_ReFire,S_XBLASTER,0,0},
  //Puff
  {SPR_SHT2,0,5,NULL,S_PUFM2,0,0},
  {SPR_SHT2,1,5,NULL,S_PUFM3,0,0},
  {SPR_POW1,0,4,NULL,S_PUFM4,0,0},
  {SPR_POW1,1,4,NULL,S_PUFM5,0,0},
  {SPR_POW1,2,4,NULL,S_PUFM6,0,0},
  {SPR_POW1,3,4,NULL,S_PUFM7,0,0},
  {SPR_POW1,4,4,NULL,S_NULL,0,0},
  {SPR_TORP,32768,4,NULL,S_TORPEDO_2,0,0},
  {SPR_TORP,32769,4,NULL,S_TORPEDO_3,0,0},
  {SPR_TORP,32770,4,NULL,S_TORPEDO_4,0,0},
  {SPR_TORP,32771,4,NULL,S_TORPEDO_1,0,0},
  {SPR_THIT,32768,8,NULL,S_TORPEDO_X2,0,0},
  {SPR_THIT,32769,8,NULL,S_TORPEDO_X3,0,0},
  {SPR_THIT,32770,8,A_TorpedoExplode,S_TORPEDO_X4,0,0},
  {SPR_THIT,32771,8,NULL,S_TORPEDO_X5,0,0},
  {SPR_THIT,32772,8,NULL,S_NULL,0,0},
  //SpreadShot
  {SPR_TWAV,32768,9,NULL,S_TORPEDO_E2,0,0},
  {SPR_TWAV,32769,9,NULL,S_TORPEDO_E3,0,0},
  {SPR_TWAV,32770,9,NULL,S_NULL,0,0},

  //Waving Hands
  {SPR_WAVE,32768,3,NULL,S_WAVE2,0,0},
  {SPR_WAVE,32769,3,NULL,S_WAVE3,0,0},
  {SPR_WAVE,32770,3,NULL,S_WAVE4,0,0},
  {SPR_WAVE,32771,3,NULL,S_WAVE1,0,0},

  //Strife Weapon 8: Sigil
  {SPR_SIGH,32768,1,A_WeaponReady,S_SIGIL,0,0},
  //Versions
  {SPR_SIGH,32769,1,NULL,S_SIGIL_B,0,0},
  {SPR_SIGH,32770,1,NULL,S_SIGIL_C,0,0},
  {SPR_SIGH,32771,1,NULL,S_SIGIL_D,0,0},
  {SPR_SIGH,32772,1,NULL,S_SIGIL_E,0,0},
  //Up/Down
  {SPR_SIGH,32768,1,A_Raise,S_SIGIL_UP,0,0},
  {SPR_SIGH,32768,1,A_Lower,S_SIGIL_DOWN,0,0},
  //Fire
  {SPR_SIGH,32768,18,A_SigilSound,S_SIGIL_2,0,0},
  {SPR_SIGH,32768,3,A_SigilBeginFire,S_SIGIL_3,0,0},
  {SPR_SIGH,0,10,A_FireSigilWeapon,S_SIGIL_4,0,0},
  {SPR_SIGH,0,5,A_GunFlashThinker,S_SIGIL,0,0},
  //FlashState
  {SPR_SIGF,32768,4,A_Light2,S_SIGIL_F2,0,0},
  {SPR_SIGF,32769,6,A_SigilShock,S_SIGIL_F3,0,0},
  {SPR_SIGF,32770,4,A_Light0,S_LIGHTDONE,0,0},

  //Weapons
  {SPR_CBOW,0,-1,NULL,S_NULL,0,0},
  {SPR_RIFL,0,-1,NULL,S_NULL,0,0},
  {SPR_RIFL,1,-1,NULL,S_NULL,0,0},
  {SPR_MMSL,0,-1,NULL,S_NULL,0,0},
  {SPR_GRND,0,-1,NULL,S_NULL,0,0},
  {SPR_FLAM,0,-1,NULL,S_NULL,0,0},
  {SPR_TRPD,0,-1,NULL,S_NULL,0,0},

  //Ammo
  {SPR_BLIT,0,-1,NULL,S_NULL,0,0},
  {SPR_BBOX,0,-1,NULL,S_NULL,0,0},
  {SPR_XQRL,0,-1,NULL,S_NULL,0,0},
  {SPR_PQRL,0,-1,NULL,S_NULL,0,0},
  {SPR_MSSL,0,-1,NULL,S_NULL,0,0},
  {SPR_ROKT,0,-1,NULL,S_NULL,0,0},
  {SPR_GRN1,0,-1,NULL,S_NULL,0,0},
  {SPR_GRN2,0,-1,NULL,S_NULL,0,0},
  {SPR_BRY1,0,6,NULL,S_ACELL2,0,0},
  {SPR_BRY1,1,6,NULL,S_ACELL1,0,0},
  {SPR_CPAC,0,6,NULL,S_APCELL2,0,0},
  {SPR_CPAC,1,6,NULL,S_APCELL1,0,0},

  //Trees
  {SPR_TRE1,0,-1,NULL,S_NULL,0,0},
  {SPR_TREE,0,-1,NULL,S_NULL,0,0},
  {SPR_TREE,1,-1,NULL,S_NULL,0,0},
  {SPR_TREE,2,-1,NULL,S_NULL,0,0},
  {SPR_SHRB,0,-1,NULL,S_NULL,0,0},
  {SPR_BUSH,0,-1,NULL,S_NULL,0,0},
  {SPR_LOGG,0,6,NULL,S_TREE8,0,0},
  {SPR_LOGG,1,6,NULL,S_TREE9,0,0},
  {SPR_LOGG,2,6,NULL,S_TREE10,0,0},
  {SPR_LOGG,3,6,A_Pain,S_TREE7,0,0},

  //Rubble
  {SPR_RUB1,0,-1,NULL,S_NULL,0,0},
  {SPR_RUB2,0,-1,NULL,S_NULL,0,0},
  {SPR_RUB3,0,-1,NULL,S_NULL,0,0},
  {SPR_RUB4,0,-1,NULL,S_NULL,0,0},
  {SPR_RUB5,0,-1,NULL,S_NULL,0,0},
  {SPR_RUB6,0,-1,NULL,S_NULL,0,0},
  {SPR_RUB7,0,-1,NULL,S_NULL,0,0},
  {SPR_RUB8,0,-1,NULL,S_NULL,0,0},

  //Cave
  {SPR_STAK,0,-1,NULL,S_NULL,0,0},
  {SPR_STLG,2,-1,NULL,S_NULL,0,0},
  {SPR_STLG,0,-1,NULL,S_NULL,0,0},
  {SPR_STLG,1,-1,NULL,S_NULL,0,0},
  {SPR_STLG,5,-1,NULL,S_NULL,0,0},
  {SPR_STLG,3,-1,NULL,S_NULL,0,0},
  {SPR_STLG,4,-1,NULL,S_NULL,0,0},

  //rock
  {SPR_ROK1,0,-1,NULL,S_NULL,0,0},
  {SPR_ROK2,0,-1,NULL,S_NULL,0,0},
  {SPR_ROK3,0,-1,NULL,S_NULL,0,0},
  {SPR_ROK4,0,-1,NULL,S_NULL,0,0},

  //pillars
  {SPR_BAR1,0,-1,NULL,S_NULL,0,0},
  {SPR_MONI,0,-1,NULL,S_NULL,0,0},
  {SPR_STEL,0,-1,NULL,S_NULL,0,0},
  {SPR_STLA,0,-1,NULL,S_NULL,0,0},
  {SPR_STLE,0,-1,NULL,S_NULL,0,0},
  {SPR_HUGE,0,4,NULL,S_PILLAR6_2,0,0},
  {SPR_HUGE,1,5,NULL,S_PILLAR6_3,0,0},
  {SPR_HUGE,2,5,NULL,S_PILLAR6_4,0,0},
  {SPR_HUGE,3,5,NULL,S_PILLAR6_1,0,0},
  {SPR_APOW,0,6,A_BackSound,S_PILLAR7,0,0},
  {SPR_STAT,0,-1,NULL,S_NULL,0,0},
  {SPR_DSTA,0,-1,NULL,S_NULL,0,0},
  {SPR_BUBB,0,6,A_BackSound,S_PILLAR10,0,0},
  {SPR_BUBF,0,6,A_BackSound,S_PILLAR11,0,0},
  {SPR_BUBF,0,6,A_BackSound,S_PILLAR12,0,0},
  {SPR_ASPR,0,6,A_BackSound,S_PILLAR13,0,0},

  //biological stuff
  {SPR_SACR,0,-1,NULL,S_NULL,0,0},
  {SPR_HERT,0,15,NULL,S_BIO2_2,0,0},
  {SPR_HERT,1,11,NULL,S_BIO2_3,0,0},
  {SPR_HERT,2,40,NULL,S_BIO2_1,0,0},
  {SPR_TNK1,0,15,NULL,S_BIO3_2,0,0},
  {SPR_TNK1,1,11,NULL,S_BIO3_3,0,0},
  {SPR_TNK1,2,40,NULL,S_BIO3_1,0,0},
  {SPR_TNK2,0,15,NULL,S_BIO4_2,0,0},
  {SPR_TNK2,1,11,NULL,S_BIO4_3,0,0},
  {SPR_TNK2,2,40,NULL,S_BIO4_1,0,0},
  {SPR_TNK3,0,15,NULL,S_BIO5_2,0,0},
  {SPR_TNK3,1,11,NULL,S_BIO5_3,0,0},
  {SPR_TNK3,2,40,NULL,S_BIO5_1,0,0},
  {SPR_TNK4,0,15,NULL,S_BIO6_2,0,0},
  {SPR_TNK4,1,11,NULL,S_BIO6_3,0,0},
  {SPR_TNK4,2,40,NULL,S_BIO6_1,0,0},
  {SPR_TNK5,0,15,NULL,S_BIO7_2,0,0},
  {SPR_TNK5,1,11,NULL,S_BIO7_3,0,0},
  {SPR_TNK5,2,40,NULL,S_BIO7_1,0,0},
  {SPR_TNK6,0,15,NULL,S_BIO8_2,0,0},
  {SPR_TNK6,1,11,NULL,S_BIO8_3,0,0},
  {SPR_TNK6,2,40,NULL,S_BIO8_1,0,0},

  //effects
  {SPR_SHRD,4,1,NULL,S_SHRD_1,0,0},
  {SPR_SHRD,4,1,A_GlassShatter,S_SHRD_2,0,0},
  {SPR_SHRD,4,1,NULL,S_SHRD_3,0,0},
  {SPR_SHRD,4,1,NULL,S_NULL,0,0},
  {SPR_SHRD,3,160,NULL,S_NULL,0,0},
  {SPR_SHRD,4,160,NULL,S_NULL,0,0},
  {SPR_SHRD,5,160,NULL,S_NULL,0,0},
  {SPR_POW3,0,4,NULL,S_POW3_2,0,0},
  {SPR_POW3,1,4,NULL,S_POW3_3,0,0},
  {SPR_POW3,2,4,NULL,S_POW3_4,0,0},
  {SPR_POW3,3,4,NULL,S_POW3_5,0,0},
  {SPR_POW3,4,4,NULL,S_POW3_6,0,0},
  {SPR_POW3,5,4,NULL,S_POW3_7,0,0},
  {SPR_POW3,6,4,NULL,S_POW3_8,0,0},
  {SPR_POW3,7,4,NULL,S_NULL,0,0},

  {SPR_SPRY,0,3,NULL,S_BLOOD_DEATH2,0,0},
  {SPR_SPRY,1,3,NULL,S_BLOOD_DEATH3,0,0},
  {SPR_SPRY,2,3,NULL,S_BLOOD_DEATH4,0,0},
  {SPR_SPRY,3,3,NULL,S_BLOOD_DEATH5,0,0},
  {SPR_SPRY,4,3,NULL,S_BLOOD_DEATH6,0,0},
  {SPR_SPRY,5,3,NULL,S_BLOOD_DEATH7,0,0},
  {SPR_SPRY,6,2,NULL,S_NULL,0,0},

  {SPR_BLOD,2,8,NULL,S_BLOOD2,0,0}, // S_BLOOD1
  {SPR_BLOD,1,8,NULL,S_BLOOD3,0,0}, // S_BLOOD2
  {SPR_BLOD,0,8,NULL,S_NULL,0,0}, // S_BLOOD3
  {SPR_MEAT,0,900,NULL,S_NULL,0,0},//1
  {SPR_MEAT,1,900,NULL,S_NULL,0,0},//2
  {SPR_MEAT,2,900,NULL,S_NULL,0,0},//3
  {SPR_MEAT,3,900,NULL,S_NULL,0,0},//4
  {SPR_MEAT,4,900,NULL,S_NULL,0,0},//5
  {SPR_MEAT,5,900,NULL,S_NULL,0,0},//6
  {SPR_MEAT,6,900,NULL,S_NULL,0,0},//7
  {SPR_MEAT,7,900,NULL,S_NULL,0,0},//8
  {SPR_MEAT,8,900,NULL,S_NULL,0,0},//9
  {SPR_MEAT,9,900,NULL,S_NULL,0,0},//10
  {SPR_MEAT,10,900,NULL,S_NULL,0,0},//11
  {SPR_MEAT,11,900,NULL,S_NULL,0,0},//12
  {SPR_MEAT,12,900,NULL,S_NULL,0,0},//13
  {SPR_MEAT,13,900,NULL,S_NULL,0,0},//14
  {SPR_MEAT,14,900,NULL,S_NULL,0,0},//15
  {SPR_MEAT,15,900,NULL,S_NULL,0,0},//16
  {SPR_MEAT,16,900,NULL,S_NULL,0,0},//17
  {SPR_MEAT,17,900,NULL,S_NULL,0,0},//18
  {SPR_MEAT,18,900,NULL,S_NULL,0,0},//19
  {SPR_MEAT,19,900,NULL,S_NULL,0,0},//20
  {SPR_JUNK,0,900,NULL,S_NULL,0,0},//1
  {SPR_JUNK,1,900,NULL,S_NULL,0,0},//2
  {SPR_JUNK,2,900,NULL,S_NULL,0,0},//3
  {SPR_JUNK,3,900,NULL,S_NULL,0,0},//4
  {SPR_JUNK,4,900,NULL,S_NULL,0,0},//5
  {SPR_JUNK,5,900,NULL,S_NULL,0,0},//6
  {SPR_JUNK,6,900,NULL,S_NULL,0,0},//7
  {SPR_JUNK,7,900,NULL,S_NULL,0,0},//8
  {SPR_JUNK,8,900,NULL,S_NULL,0,0},//9
  {SPR_JUNK,9,900,NULL,S_NULL,0,0},//10
  {SPR_JUNK,10,900,NULL,S_NULL,0,0},//11
  {SPR_JUNK,11,900,NULL,S_NULL,0,0},//12
  {SPR_JUNK,12,900,NULL,S_NULL,0,0},//13
  {SPR_JUNK,13,900,NULL,S_NULL,0,0},//14
  {SPR_JUNK,14,900,NULL,S_NULL,0,0},//15
  {SPR_JUNK,15,900,NULL,S_NULL,0,0},//16
  {SPR_JUNK,16,900,NULL,S_NULL,0,0},//17
  {SPR_JUNK,17,900,NULL,S_NULL,0,0},//18
  {SPR_JUNK,18,900,NULL,S_NULL,0,0},//19
  {SPR_JUNK,19,900,NULL,S_NULL,0,0},//20
  {SPR_BURN,0,3,A_BurnScream,S_BURN_2,0,0},
  {SPR_BURN,1,3,A_DropBurnFlesh,S_BURN_3,0,0},
  {SPR_BURN,2,3,A_Wander,S_BURN_4,0,0},
  {SPR_BURN,3,3,A_Fall,S_BURN_5,0,0},
  {SPR_BURN,4,5,A_DropBurnFlesh,S_BURN_6,0,0},
  {SPR_BURN,5,5,A_Wander,S_BURN_7,0,0},
  {SPR_BURN,6,5,A_Wander,S_BURN_8,0,0},
  {SPR_BURN,7,5,A_Wander,S_BURN_9,0,0},
  {SPR_BURN,8,5,A_DropBurnFlesh,S_BURN_10,0,0},
  {SPR_BURN,9,5,A_Wander,S_BURN_11,0,0},
  {SPR_BURN,10,5,A_Wander,S_BURN_12,0,0},
  {SPR_BURN,11,5,A_Wander,S_BURN_13,0,0},
  {SPR_BURN,12,3,NULL,S_BURN_14,0,0},
  {SPR_BURN,13,3,NULL,S_BURN_15,0,0},
  {SPR_BURN,14,5,NULL,S_BURN_16,0,0},
  {SPR_BURN,15,5,NULL,S_BURN_17,0,0},
  {SPR_BURN,16,5,NULL,S_BURN_18,0,0},
  {SPR_BURN,17,7,NULL,S_BURN_19,0,0},
  {SPR_BURN,18,7,NULL,S_BURN_20,0,0},
  {SPR_BURN,19,7,NULL,S_BURN_21,0,0},
  {SPR_BURN,20,7,NULL,S_BURN_22,0,0},
  {SPR_BURN,21,700,A_DropItem,S_NULL,0,0},

  {SPR_FFOT,0,5,NULL,S_BDROP_2,0,0},
  {SPR_FFOT,1,5,NULL,S_BDROP_3,0,0},
  {SPR_FFOT,2,5,NULL,S_BDROP_4,0,0},
  {SPR_FFOT,3,5,NULL,S_NULL,0,0},

  {SPR_DISR,0,5,A_BeGone,S_DISR_2,0,0},
  {SPR_DISR,1,5,NULL,S_DISR_3,0,0},
  {SPR_DISR,2,5,NULL,S_DISR_4,0,0},
  {SPR_DISR,3,5,A_Fall,S_DISR_5,0,0},
  {SPR_DISR,4,5,NULL,S_DISR_6,0,0},
  {SPR_DISR,5,5,NULL,S_DISR_7,0,0},
  {SPR_DISR,6,4,NULL,S_DISR_8,0,0},
  {SPR_DISR,7,4,NULL,S_DISR_9,0,0},
  {SPR_DISR,8,4,NULL,S_DISR_10,0,0},
  {SPR_DISR,9,4,NULL,S_NULL,0,0},

  //Lights
  {SPR_CAGE,0,-1,NULL,S_NULL,0,0},
  {SPR_CNDL,32768,-1,NULL,S_NULL,0,0},
  {SPR_CLBR,32768,-1,NULL,S_NULL,0,0},
  {SPR_LAMP,0,-1,NULL,S_NULL,0,0},
  {SPR_LANT,0,-1,NULL,S_NULL,0,0},
  {SPR_LMPC,32768,4,NULL,S_LIGHT6_2,0,0},
  {SPR_LMPC,32769,4,NULL,S_LIGHT6_3,0,0},
  {SPR_LMPC,32770,4,NULL,S_LIGHT6_4,0,0},
  {SPR_LMPC,32771,4,NULL,S_LIGHT6_1,0,0},
  {SPR_LOGS,32768,4,NULL,S_LIGHT7_2,0,0},
  {SPR_LOGS,32769,4,NULL,S_LIGHT7_3,0,0},
  {SPR_LOGS,32770,4,NULL,S_LIGHT7_4,0,0},
  {SPR_LOGS,32771,4,NULL,S_LIGHT7_1,0,0},
  {SPR_TRHO,0,-1,NULL,S_NULL,0,0},
  {SPR_TRCH,32768,4,NULL,S_LIGHT9_2,0,0},
  {SPR_TRCH,32769,4,NULL,S_LIGHT9_3,0,0},
  {SPR_TRCH,32770,4,NULL,S_LIGHT9_4,0,0},
  {SPR_TRCH,32771,4,NULL,S_LIGHT9_1,0,0},
  {SPR_BRAZ,32768,4,NULL,S_LIGHT10_2,0,0},
  {SPR_BRAZ,32769,4,NULL,S_LIGHT10_3,0,0},
  {SPR_BRAZ,32770,4,NULL,S_LIGHT10_4,0,0},
  {SPR_BRAZ,32771,4,NULL,S_LIGHT10_1,0,0},
  {SPR_BOWL,32768,4,NULL,S_LIGHT11_2,0,0},
  {SPR_BOWL,32769,4,NULL,S_LIGHT11_3,0,0},
  {SPR_BOWL,32770,4,NULL,S_LIGHT11_4,0,0},
  {SPR_BOWL,32771,4,NULL,S_LIGHT11_1,0,0},
  {SPR_LITG,0,-1,NULL,S_NULL,0,0},
  {SPR_LITB,0,-1,NULL,S_NULL,0,0},
  {SPR_LITS,0,-1,NULL,S_NULL,0,0},
  {SPR_LTRH,32768,4,NULL,S_LIGHT15_2,0,0},
  {SPR_LTRH,32769,4,NULL,S_LIGHT15_3,0,0},
  {SPR_LTRH,32770,4,NULL,S_LIGHT15_4,0,0},
  {SPR_LTRH,32771,4,NULL,S_LIGHT15_1,0,0},
  {SPR_TLMP,1,-1,NULL,S_NULL,0,0},
  {SPR_TLMP,0,-1,NULL,S_NULL,0,0},
  {SPR_LITE,32768,-1,NULL,S_NULL,0,0},
  {SPR_SPDL,32768,5,A_BackSound,S_LIGHT19_2,0,0},
  {SPR_SPDL,32769,5,NULL,S_LIGHT19_3,0,0},
  {SPR_SPDL,32770,5,NULL,S_LIGHT19_1,0,0},

  //Other
  {SPR_KLAX,0,5,A_ObjectWatch,S_MISC_01_1,0,0},
  {SPR_KLAX,1,6,NULL,S_MISC_01_3,0,0},
  {SPR_KLAX,2,60,A_Alarm,S_MISC_01_2,0,0},
  {SPR_CDRP,0,10,NULL,S_MISC_02_2,0,0},
  {SPR_CDRP,1,8,NULL,S_MISC_02_3,0,0},
  {SPR_CDRP,2,8,NULL,S_MISC_02_4,0,0},
  {SPR_CDRP,3,8,NULL,S_MISC_02_1,0,0},
  {SPR_DRIP,0,6,NULL,S_MISC_03_2,0,0},
  {SPR_DRIP,1,4,A_Pain,S_MISC_03_3,0,0},
  {SPR_DRIP,2,4,NULL,S_MISC_03_4,0,0},
  {SPR_DRIP,3,4,NULL,S_MISC_03_5,0,0},
  {SPR_DRIP,4,4,NULL,S_MISC_03_6,0,0},
  {SPR_DRIP,5,4,NULL,S_MISC_03_7,0,0},
  {SPR_DRIP,6,4,NULL,S_MISC_03_8,0,0},
  {SPR_DRIP,7,4,NULL,S_MISC_03_1,0,0},
  {SPR_BARL,32768,4,NULL,S_MISC_04_2,0,0},
  {SPR_BARL,32769,4,NULL,S_MISC_04_3,0,0},
  {SPR_BARL,32770,4,NULL,S_MISC_04_4,0,0},
  {SPR_BARL,32771,4,NULL,S_MISC_04_1,0,0},
  {SPR_BARW,0,-1,NULL,S_NULL,0,0},
  {SPR_BARW,1,2,A_Scream,S_MISC_05_2,0,0},
  {SPR_BARW,2,2,NULL,S_MISC_05_3,0,0},
  {SPR_BARW,3,2,A_Fall,S_MISC_05_4,0,0},
  {SPR_BARW,4,2,NULL,S_MISC_05_5,0,0},
  {SPR_BARW,5,2,NULL,S_MISC_05_6,0,0},
  {SPR_BARW,6,2,NULL,S_MISC_05_7,0,0},
  {SPR_BARW,7,-1,NULL,S_NULL,0,0},
  {SPR_BART,0,-1,NULL,S_NULL,0,0},
  {SPR_BART,1,2,A_Scream,S_MISC_06_2,0,0},
  {SPR_BART,2,2,NULL,S_MISC_06_3,0,0},
  {SPR_BART,3,2,NULL,S_MISC_06_4,0,0},
  {SPR_BART,4,2,A_Fall,S_MISC_06_5,0,0},
  {SPR_BART,5,2,A_BarrelExplode,S_MISC_06_6,0,0},
  {SPR_BART,6,2,NULL,S_MISC_06_7,0,0},
  {SPR_BART,7,2,NULL,S_MISC_06_8,0,0},
  {SPR_BART,8,2,NULL,S_MISC_06_9,0,0},
  {SPR_BART,9,3,NULL,S_MISC_06_10,0,0},
  {SPR_BART,10,3,NULL,S_MISC_06_11,0,0},
  {SPR_BART,11,-1,NULL,S_NULL,0,0},
  {SPR_WTFT,0,4,A_Pain,S_MISC_07_2,0,0},
  {SPR_WTFT,1,4,NULL,S_MISC_07_3,0,0},
  {SPR_WTFT,2,4,NULL,S_MISC_07_4,0,0},
  {SPR_WTFT,3,4,NULL,S_MISC_07_1,0,0},
  {SPR_CRAB,0,-1,NULL,S_NULL,0,0},
  {SPR_VASE,1,-1,NULL,S_NULL,0,0},
  {SPR_VASE,0,-1,NULL,S_NULL,0,0},
  {SPR_MUGG,0,-1,NULL,S_NULL,0,0},
  {SPR_AFED,0,-1,NULL,S_NULL,0,0},
  {SPR_SPLH,0,6,NULL,S_MISC_13_2,0,0},
  {SPR_SPLH,1,4,A_Pain,S_MISC_13_3,0,0},
  {SPR_SPLH,2,4,NULL,S_MISC_13_4,0,0},
  {SPR_SPLH,3,8,NULL,S_MISC_13_5,0,0},
  {SPR_SPLH,4,4,NULL,S_MISC_13_6,0,0},
  {SPR_SPLH,5,4,NULL,S_MISC_13_7,0,0},
  {SPR_SPLH,6,4,NULL,S_MISC_13_8,0,0},
  {SPR_SPLH,7,4,NULL,S_MISC_13_1,0,0},
  {SPR_CHAN,0,-1,NULL,S_NULL,0,0},
  {SPR_HOGN,0,2,A_ZombieInSpecialSector,S_MISC_15,0,0},
  {SPR_HOGN,1,1,A_Pain,S_MISC_15_2,0,0},
  {SPR_HOGN,2,1,NULL,S_MISC_15,0,0},
  {SPR_NEAL,0,15,A_BackSound,S_MISC_16_2,0,0},
  {SPR_NEAL,1,40,NULL,S_MISC_16_1,0,0},
  {SPR_NEAL,0,15,NULL,S_MISC_16_SEE2,0,0},
  {SPR_NEAL,1,40,NULL,S_MISC_16_SEE1,0,0},
  {SPR_NEAL,2,5,A_ShadowOn,S_MISC_16_PAIN2,0,0},
  {SPR_NEAL,1,4,A_Pain,S_MISC_16_PAIN3,0,0},
  {SPR_NEAL,2,5,A_ShadowOff,S_MISC_16_SEE1,0,0},
  {SPR_NEAL,3,5,A_Scream,S_MISC_16_DTH2,0,0},
  {SPR_NEAL,4,5,A_Fall,S_MISC_16_DTH3,0,0},
  {SPR_NEAL,5,6,NULL,S_MISC_16_DTH4,0,0},
  {SPR_NEAL,6,5,NULL,S_MISC_16_DTH5,0,0},
  {SPR_NEAL,7,5,NULL,S_MISC_16_DTH6,0,0},
  {SPR_NEAL,8,6,NULL,S_MISC_16_DTH7,0,0},
  {SPR_NEAL,9,-1,NULL,S_NULL,0,0},
  {SPR_STOL,0,-1,NULL,S_NULL,0,0},
  {SPR_POT1,0,-1,NULL,S_NULL,0,0},
  {SPR_TUB1,0,-1,NULL,S_NULL,0,0},
  {SPR_ANVL,0,-1,NULL,S_NULL,0,0},
  {SPR_TRAY,0,-1,NULL,S_NULL,0,0},
  {SPR_WATR,0,-1,NULL,S_NULL,0,0},
  {SPR_BOTR,0,-1,NULL,S_NULL,0,0},
  {SPR_HATR,0,-1,NULL,S_NULL,0,0},
  {SPR_TOPR,0,-1,NULL,S_NULL,0,0},
  {SPR_SBAN,0,-1,NULL,S_NULL,0,0},
  {SPR_RATT,0,1,A_Look,S_RAT1,0,0},
  {SPR_RATT,0,4,A_Chase,S_RATSEE2,0,0},
  {SPR_RATT,0,4,A_Chase,S_RATSEE3,0,0},
  {SPR_RATT,1,4,A_Chase,S_RATSEE4,0,0},
  {SPR_RATT,1,4,A_Chase,S_RATSEE1,0,0},
  //Guard1
  {SPR_AGRD,0,5,A_Stand,S_AGRD_STND,0,0},
  {SPR_AGRD,1,5,NULL,S_AGRD_STND,0,0},
  {SPR_AGRD,3,5,NULL,S_AGRD_STND,0,0},
  //Patrol
  {SPR_AGRD,0,5,A_Patrol,S_AGRD_WALK2,0,0},
  {SPR_AGRD,1,5,A_Patrol,S_AGRD_WALK3,0,0},
  {SPR_AGRD,2,5,A_Patrol,S_AGRD_WALK4,0,0},
  {SPR_AGRD,3,5,A_Patrol,S_AGRD_WALK5,0,0},
  {SPR_AGRD,0,5,A_Patrol,S_AGRD_WALK6,0,0},
  {SPR_AGRD,1,5,A_Patrol,S_AGRD_WALK7,0,0},
  {SPR_AGRD,2,5,A_Patrol,S_AGRD_WALK8,0,0},
  {SPR_AGRD,3,5,A_Patrol,S_AGRD_STND,0,0},
  //ChasePlayer
  {SPR_AGRD,0,6,A_Chase,S_AGRD_RUN2,0,0},
  {SPR_AGRD,1,6,A_Chase,S_AGRD_RUN3,0,0},
  {SPR_AGRD,2,6,A_Chase,S_AGRD_RUN4,0,0},
  {SPR_AGRD,3,6,A_Chase,S_AGRD_RUN1,0,0},
  //Guard1ATK
  {SPR_AGRD,4,8,A_FaceTarget,S_AGRD_ATK2,0,0},
  {SPR_AGRD,5,4,A_AgrdAttack,S_AGRD_ATK3,0,0},
  {SPR_AGRD,4,4,A_AgrdAttack,S_AGRD_ATK4,0,0},
  {SPR_AGRD,5,6,A_AgrdAttack,S_AGRD_RUN1,0,0},
  //Guard1PAIN
  {SPR_AGRD,14,8,A_Pain,S_AGRD_RUN1,0,0},
  //Guard1DTH
  {SPR_AGRD,6,4,NULL,S_AGRD_DIE2,0,0},
  {SPR_AGRD,7,4,A_Scream, S_AGRD_DIE3,0,0},
  {SPR_AGRD,8,4,NULL, S_AGRD_DIE4,0,0},
  {SPR_AGRD,9,3,NULL, S_AGRD_DIE5,0,0},
  {SPR_AGRD,10,3,A_Fall, S_AGRD_DIE6,0,0},
  {SPR_AGRD,11,3,NULL, S_AGRD_DIE7,0,0},
  {SPR_AGRD,12,3,A_AcolyteSpecial, S_AGRD_DIE8,0,0},	//special
  {SPR_AGRD,13,-1,NULL, S_NULL,0,0},
  //Guard1XDTH
  {SPR_GIBS,0,5,A_Fall,S_AGRD_XDIE2,0,0},
  {SPR_GIBS,1,5,A_XScream,S_AGRD_XDIE3,0,0},
  {SPR_GIBS,2,5,A_BodyParts,S_AGRD_XDIE4,0,0},
  {SPR_GIBS,3,5,A_BodyParts,S_AGRD_XDIE5,0,0},
  {SPR_GIBS,4,5,A_BodyParts,S_AGRD_XDIE6,0,0},
  {SPR_GIBS,5,5,A_BodyParts,S_AGRD_XDIE7,0,0},
  {SPR_GIBS,6,5,A_BodyParts,S_AGRD_XDIE8,0,0},
  {SPR_GIBS,7,5,A_BodyParts,S_AGRD_XDIE9,0,0},
  {SPR_GIBS,8,5,A_BodyParts,S_AGRD_XDIE10,0,0},
  {SPR_GIBS,9,5,A_BodyParts,S_AGRD_XDIE11,0,0},
  {SPR_GIBS,10,5,A_AcolyteSpecial,S_AGRD_XDIE12,0,0},	//special
  {SPR_GIBS,11,-1,NULL,S_NULL,0,0},
  {SPR_AGRD,0,1,A_ShadowOn,S_AGRD_RUN1,0,0},
  {SPR_AGRD,14,4,A_Pain,S_SAGRD_PAIN2,0,0},
  {SPR_AGRD,14,4,A_ShadowOff,S_SAGRD_RUN1,0,0},
  //Becoming
  {SPR_ARMR,0,-1,NULL,S_NULL,0,0},
  {SPR_ARMR,0,-1,NULL,S_NULL,0,0},
  //Inventory
  {SPR_COIN,0,-1,NULL,S_NULL,0,0},
  {SPR_CRED,0,-1,NULL,S_NULL,0,0},
  {SPR_SACK,0,-1,NULL,S_NULL,0,0},
  {SPR_CHST,0,-1,NULL,S_NULL,0,0},
  {SPR_TOKN,0,-1,NULL,S_NULL,0,0},
  {SPR_RELC,0,-1,NULL,S_NULL,0,0},
  {SPR_COMM,0,-1,NULL,S_NULL,0,0},
  {SPR_TARG,0,-1,NULL,S_NULL,0,0},
  {SPR_BKPK,0,-1,NULL,S_NULL,0,0},
  {SPR_STMP,0,-1,NULL,S_NULL,0,0},
  {SPR_MDKT,0,-1,NULL,S_NULL,0,0},
  {SPR_FULL ,0,6,NULL,S_INV_MED3_2,0,0},
  {SPR_FULL ,1,6,NULL,S_INV_MED3_1,0,0},
  {SPR_ARM1,0,-1,NULL,S_NULL,0,0},
  {SPR_ARM2,0,-1,NULL,S_NULL,0,0},
  {SPR_SHD1,0,6,A_ShadowOn,S_INV_SHADOWARMOR2,0,0},
  {SPR_SHD1,0,6,A_ShadowOff,S_INV_SHADOWARMOR,0,0},
  {SPR_MASK,0,-1,NULL,S_NULL,0,0},
  {SPR_PMAP,0,6,NULL,S_INV_SUPERMAP2,0,0},
  {SPR_PMAP,1,6,NULL,S_INV_SUPERMAP1,0,0},
  {SPR_PMUP,0,6,NULL,S_INV_RADAR2,0,0},
  {SPR_PMUP,1,6,NULL,S_INV_RADAR1,0,0},
  //Keys
  {SPR_KY2S,0,-1,NULL,S_NULL,0,0},
  {SPR_KY1G,0,-1,NULL,S_NULL,0,0},
  {SPR_FUBR,0,-1,NULL,S_NULL,0,0},
  {SPR_WARE,0,-1,NULL,S_NULL,0,0},
  {SPR_KY3B,0,-1,NULL,S_NULL,0,0},
  {SPR_CHAP,0,-1,NULL,S_NULL,0,0},
  {SPR_MINE,0,-1,NULL,S_NULL,0,0},
  {SPR_HAND,0,-1,NULL,S_NULL,0,0},
  {SPR_TPAS,0,-1,NULL,S_NULL,0,0},
  {SPR_FUSL,0,-1,NULL,S_NULL,0,0},
  {SPR_GOID,0,-1,NULL,S_NULL,0,0},
  {SPR_ORAC,0,-1,NULL,S_NULL,0,0},
  {SPR_CRD1,0,-1,NULL,S_NULL,0,0},
  {SPR_BLTK,0,-1,NULL,S_NULL,0,0},
  {SPR_PROC,0,-1,NULL,S_NULL,0,0},
  {SPR_RCRY,0,-1,NULL,S_NULL,0,0},
  {SPR_CRD2,0,-1,NULL,S_NULL,0,0},
  {SPR_BCRY,0,-1,NULL,S_NULL,0,0},
  //Quest Keys
  {SPR_REBL,0,-1,NULL,S_NULL,0,0},
  {SPR_PRIS,0,-1,NULL,S_NULL,0,0},
  {SPR_PWR1,0,-1,NULL,S_NULL,0,0},
  {SPR_PWR2,0,-1,NULL,S_NULL,0,0},
  {SPR_PWR3,0,-1,NULL,S_NULL,0,0},
  {SPR_GYID,0,-1,NULL,S_NULL,0,0},
  {SPR_TUNL,0,-1,NULL,S_NULL,0,0},
  {SPR_SECK,0,-1,NULL,S_NULL,0,0},
  {SPR_BLTK,0,-1,NULL,S_NULL,0,0},

  //Quest/Other
  {SPR_SIGL,0,-1,NULL,S_NULL,0,0},
  {SPR_SIGL,1,-1,NULL,S_NULL,0,0},
  {SPR_SIGL,2,-1,NULL,S_NULL,0,0},
  {SPR_SIGL,3,-1,NULL,S_NULL,0,0},
  {SPR_SIGL,4,-1,NULL,S_NULL,0,0},
  {SPR_BEAC,0,-1,NULL,S_NULL,0,0},
  {SPR_BEAC,0,30,NULL,S_BEACON_3,0,0},
  {SPR_BEAC,0,160,A_TBeacon,S_BEACON_2,0,0},
  {SPR_TELP,0,4,NULL,S_TSTAND_2,0,0},
  {SPR_TELP,1,4,NULL,S_TSTAND_3,0,0},
  {SPR_TELP,2,4,NULL,S_TSTAND_4,0,0},
  {SPR_TELP,3,4,NULL,S_TSTAND_1,0,0},
  {SPR_UNIF,0,-1,NULL,S_NULL,0,0},
  {SPR_OFIC,0,-1,NULL,S_NULL,0,0},
  //Peasant
  {SPR_PEAS,0,10,A_Stand,S_PEAS_STND,0,0},
  //Patrol
  {SPR_PEAS,0,5,A_Wander,S_PEAS_WALK2,0,0},
  {SPR_PEAS,0,5,A_Wander,S_PEAS_WALK3,0,0},
  {SPR_PEAS,1,5,A_Wander,S_PEAS_WALK4,0,0},
  {SPR_PEAS,1,5,A_Wander,S_PEAS_WALK5,0,0},
  {SPR_PEAS,2,5,A_Wander,S_PEAS_WALK6,0,0},
  {SPR_PEAS,2,5,A_Wander,S_PEAS_WALK7,0,0},
  {SPR_PEAS,3,5,A_Wander,S_PEAS_WALK8,0,0},
  {SPR_PEAS,3,5,A_Wander,S_PEAS_STND,0,0},
  //PeasantATK
  {SPR_PEAS,4,10,A_FaceTarget,S_PEAS_ATK2,0,0},
  {SPR_PEAS,5,8,A_PeasAttack,S_PEAS_ATK3,0,0},
  {SPR_PEAS,4,8,NULL,S_PEAS_WALK1,0,0},
  //PeasantPAIN
  {SPR_PEAS,14,3,NULL,S_PEAS_PAIN2,0,0},
  {SPR_PEAS,14,3,A_Pain,S_PEAS_ATK1,0,0},
  //PeasantDTH
  {SPR_PEAS,6,6,NULL,S_PEAS_DIE2,0,0},
  {SPR_PEAS,7,5,A_Scream, S_PEAS_DIE3,0,0},
  {SPR_PEAS,8,5,NULL, S_PEAS_DIE4,0,0},
  {SPR_PEAS,9,6,NULL, S_PEAS_DIE5,0,0},
  {SPR_PEAS,10,5,A_Fall, S_PEAS_DIE6,0,0},
  {SPR_PEAS,11,5,NULL, S_PEAS_DIE7,0,0},
  {SPR_PEAS,12,8,NULL, S_PEAS_DIE8,0,0},
  {SPR_PEAS,13,-1,NULL, S_NULL,0,0},
  //PeasantXDTH
  {SPR_GIBS,12,5,A_Fall,S_PEAS_XDIE2,0,0},
  {SPR_GIBS,13,5,A_XScream,S_PEAS_XDIE3,0,0},
  {SPR_GIBS,14,5,A_BodyParts,S_PEAS_XDIE4,0,0},
  {SPR_GIBS,15,4,A_BodyParts,S_PEAS_XDIE5,0,0},
  {SPR_GIBS,16,4,A_BodyParts,S_PEAS_XDIE6,0,0},
  {SPR_GIBS,17,4,A_BodyParts,S_PEAS_XDIE7,0,0},
  {SPR_GIBS,18,4,A_BodyParts,S_PEAS_XDIE8,0,0},
  {SPR_GIBS,19,4,A_BodyParts,S_PEAS_XDIE9,0,0},
  {SPR_GIBS,20,5,A_BodyParts,S_PEAS_XDIE10,0,0},
  {SPR_GIBS,21,-1,NULL,S_NULL,0,0},
  //PeasantCrash
  {SPR_PEAS,6,5,NULL,S_PEAS_CDIE2,0,0},
  {SPR_PEAS,7,10,A_PeasFall,S_PEAS_CDIE3,0,0},
  {SPR_PEAS,8,6,NULL,S_PEAS_CDIE1,0,0},
  {SPR_PEAS,0,10,NULL,S_PEAS_STND,0,0},
  //GunTurret
  {SPR_TURT,0,5,A_Stand,S_TURRET1,0,0},
  {SPR_TURT,0,2,A_ObjectChase,S_TURRET2,0,0},
  {SPR_TURT,1,4,A_FaceTarget,S_TURRET4,0,0},
  {SPR_TURT,3,3,A_AgrdAttack,S_TURRET5,0,0},
  {SPR_TURT,0,4,A_TurretReFire,S_TURRET3,0,0},
  //TurretDeath
  {SPR_BALL,32768,6,A_Scream,S_TURRET7,0,0},
  {SPR_BALL,32769,6,NULL,S_TURRET8,0,0},
  {SPR_BALL,32770,6,NULL,S_TURRET9,0,0},
  {SPR_BALL,32771,6,NULL,S_TURRET10,0,0},
  {SPR_BALL,32772,6,NULL,S_TURRET11,0,0},
  {SPR_TURT,2,-1,NULL,S_NULL,0,0},

   //PGuard1
  {SPR_PGRD,0,5,A_Stand,S_PGRD_STND,0,0},
  {SPR_PGRD,1,5,NULL,S_PGRD_STND,0,0},
  {SPR_PGRD,3,5,NULL,S_PGRD_STND,0,0},
  //Patrol
  {SPR_PGRD,0,3,A_Patrol,S_PGRD_WALK2,0,0},
  {SPR_PGRD,0,3,A_Patrol,S_PGRD_WALK3,0,0},
  {SPR_PGRD,1,3,A_Patrol,S_PGRD_WALK4,0,0},
  {SPR_PGRD,1,3,A_Patrol,S_PGRD_WALK5,0,0},
  {SPR_PGRD,2,3,A_Patrol,S_PGRD_WALK6,0,0},
  {SPR_PGRD,2,3,A_Patrol,S_PGRD_WALK7,0,0},
  {SPR_PGRD,3,3,A_Patrol,S_PGRD_WALK8,0,0},
  {SPR_PGRD,3,3,A_Patrol,S_PGRD_STND,0,0},
  //ChasePlayer
  {SPR_PGRD,0,3,A_Chase,S_PGRD_RUN2,0,0},
  {SPR_PGRD,0,3,A_Chase,S_PGRD_RUN3,0,0},
  {SPR_PGRD,1,3,A_Chase,S_PGRD_RUN4,0,0},
  {SPR_PGRD,1,3,A_Chase,S_PGRD_RUN5,0,0},
  {SPR_PGRD,2,3,A_Chase,S_PGRD_RUN6,0,0},
  {SPR_PGRD,2,3,A_Chase,S_PGRD_RUN7,0,0},
  {SPR_PGRD,3,3,A_Chase,S_PGRD_RUN8,0,0},
  {SPR_PGRD,3,3,A_Chase,S_PGRD_RUN1,0,0},
  //PGuard1ATK
  {SPR_PGRD,4,8,A_FaceTarget,S_PGRD_ATK2,0,0},
  {SPR_PGRD,5,8,A_PgrdAttack,S_PGRD_RUN1,0,0},
  //PGuardAtk2
  {SPR_PGRD,32774,8,A_FaceTarget,S_PGRD_MATK2,0,0},
  {SPR_PGRD,32775,8,A_PgrdShoot,S_PGRD_RUN1,0,0},
  //PGuard1PAIN
  {SPR_PGRD,0,2,A_Pain,S_PGRD_PAIN2,0,0},
  {SPR_PGRD,0,2,NULL,S_PGRD_RUN1,0,0},
  //PGuard1DTH
  {SPR_PGRD,32776,4,A_BodyParts,S_PGRD_DIE2,0,0},
  {SPR_PGRD,32777,4,A_Scream, S_PGRD_DIE3,0,0},
  {SPR_PGRD,32778,4,A_BodyParts, S_PGRD_DIE4,0,0},
  {SPR_PGRD,32779,3,A_Fall, S_PGRD_DIE5,0,0},
  {SPR_PGRD,32780,3,NULL, S_PGRD_DIE6,0,0},
  {SPR_PGRD,32781,3,NULL, S_PGRD_DIE7,0,0},
  {SPR_PGRD,14,4,A_BodyParts, S_PGRD_DIE8,0,0},
  {SPR_PGRD,15,4,NULL, S_PGRD_DIE9,0,0},
  {SPR_PGRD,16,4,NULL, S_PGRD_DIE10,0,0},
  {SPR_PGRD,17,4,NULL, S_PGRD_DIE11,0,0},
  {SPR_PGRD,18,3,NULL, S_PGRD_DIE12,0,0},
  {SPR_PGRD,19,3,NULL, S_PGRD_DIE13,0,0},
  {SPR_PGRD,20,3,NULL, S_PGRD_DIE14,0,0},
  {SPR_PGRD,21,3,NULL, S_PGRD_DIE15,0,0},
  {SPR_PGRD,22,3,NULL, S_PGRD_DIE16,0,0},
  {SPR_PGRD,23,3,NULL, S_PGRD_DIE17,0,0},
  {SPR_PGRD,24,3,NULL, S_PGRD_DIE18,0,0},
  {SPR_PGRD,25,3,NULL, S_PGRD_DIE19,0,0},
  {SPR_PGRD,26,3,NULL, S_PGRD_DIE20,0,0},
  {SPR_PGRD,27,-1,NULL, S_NULL,0,0},

   //Reaver Stand
  {SPR_ROB1,0,10,A_Look,S_ROB1_STND2,0,0},
  {SPR_ROB1,0,10,A_Look,S_ROB1_STND,0,0},
  //Reaver Chase
  {SPR_ROB1,1,3,A_Chase,S_ROB1_RUN2,0,0},
  {SPR_ROB1,1,3,A_Chase,S_ROB1_RUN3,0,0},
  {SPR_ROB1,2,3,A_Chase,S_ROB1_RUN4,0,0},
  {SPR_ROB1,2,3,A_Chase,S_ROB1_RUN5,0,0},
  {SPR_ROB1,3,3,A_Chase,S_ROB1_RUN6,0,0},
  {SPR_ROB1,3,3,A_Chase,S_ROB1_RUN7,0,0},
  {SPR_ROB1,4,3,A_Chase,S_ROB1_RUN8,0,0},
  {SPR_ROB1,4,3,A_Chase,S_ROB1_RUN1,0,0},
  //Reaver Attack
  {SPR_ROB1,5,8,A_FaceTarget,S_ROB1_ATK2,0,0},
  {SPR_ROB1,32774,11,A_ReavShoot,S_ROB1_RUN1,0,0},
  //Reaver Melee
  {SPR_ROB1,7,6,A_FaceTarget,S_ROB1_MATK2,0,0},
  {SPR_ROB1,8,8,A_ReavAttack,S_ROB1_MATK3,0,0},
  {SPR_ROB1,7,6,NULL,S_ROB1_RUN1,0,0},
  //Reaver Pain
  {SPR_ROB1,0,2,NULL,S_ROB1_PAIN2,0,0},
  {SPR_ROB1,0,2,A_Pain,S_ROB1_RUN1,0,0},
  //Reaver Death
  {SPR_ROB1,32777,6,NULL, S_ROB1_DIE2,0,0},
  {SPR_ROB1,32778,6,A_Scream, S_ROB1_DIE3,0,0},
  {SPR_ROB1,32779,5,NULL, S_ROB1_DIE4,0,0},
  {SPR_ROB1,32780,5,A_Fall, S_ROB1_DIE5,0,0},
  {SPR_ROB1,32781,5,NULL, S_ROB1_DIE6,0,0},
  {SPR_ROB1,32782,5,NULL, S_ROB1_DIE7,0,0},
  {SPR_ROB1,32783,5,NULL, S_ROB1_DIE8,0,0},
  {SPR_ROB1,32784,6,NULL, S_ROB1_DIE9,0,0},	//Special
  {SPR_ROB1,32785,-1,NULL, S_NULL,0,0},
  //Reaver XDeath
  {SPR_ROB1,32779,5,A_BodyParts, S_ROB1_XDIE2,0,0},
  {SPR_ROB1,32780,5,A_Scream, S_ROB1_XDIE3,0,0},
  {SPR_ROB1,32781,5,A_BodyParts, S_ROB1_XDIE4,0,0},
  {SPR_ROB1,32782,5,A_Fall, S_ROB1_XDIE5,0,0},
  {SPR_ROB1,32783,5,A_BodyParts, S_ROB1_XDIE6,0,0},
  {SPR_ROB1,32784,5,NULL, S_ROB1_XDIE7,0,0},	//Special
  {SPR_ROB1,32785,-1,NULL, S_NULL,0,0},

  //Stalker
  {SPR_SPID,0,1,A_StalkerSetLook,S_STLK_STND2,0,0},
  {SPR_SPID,0,10,A_Look,S_STLK_STND2,0,0},
  {SPR_SPID,9,10,A_Look,S_STLK_STND3,0,0},
  //Stalker Move
  {SPR_SPID,0,1,A_StalkerThinker,S_STLK_RUN2,0,0},
  {SPR_SPID,0,3,A_Chase,S_STLK_RUN3,0,0},
  {SPR_SPID,1,3,A_Chase,S_STLK_RUN4,0,0},
  {SPR_SPID,1,3,A_Chase,S_STLK_RUN5,0,0},
  {SPR_SPID,2,3,A_StalkerWalk,S_STLK_RUN6,0,0},
  {SPR_SPID,2,3,A_Chase,S_STLK_RUN1,0,0},
  //Floor
  {SPR_SPID,9,3,A_StalkerWalk,S_STLK_FRUN2,0,0},
  {SPR_SPID,9,3,A_Chase,S_STLK_FRUN3,0,0},
  {SPR_SPID,10,3,A_Chase,S_STLK_FRUN4,0,0},
  {SPR_SPID,10,3,A_Chase,S_STLK_FRUN5,0,0},
  {SPR_SPID,11,3,A_StalkerWalk,S_STLK_FRUN6,0,0},
  {SPR_SPID,11,3,A_Chase,S_STLK_FRUN1,0,0},
  //Stalker Attack/Move/Check
  {SPR_SPID,9,3,A_FaceTarget,S_STLK_ATK2,0,0},
  {SPR_SPID,10,3,A_StalkerAttack,S_STLK_FRUN1,0,0},
  {SPR_SPID,2,2,NULL,S_STLK_FALL1,0,0},
  {SPR_SPID,8,3,A_StalkerDrop,S_STLK_FALL2,0,0},
  {SPR_SPID,7,3,NULL,S_STLK_FALL3,0,0},
  {SPR_SPID,6,3,NULL,S_STLK_FALL4,0,0},
  {SPR_SPID,5,3,NULL,S_STLK_FALL5,0,0},
  {SPR_SPID,4,3,NULL,S_STLK_FALL6,0,0},
  {SPR_SPID,3,3,NULL,S_STLK_FRUN1,0,0},
  //Stalker Pain
  {SPR_SPID,11,1,A_Pain,S_STLK_RUN1,0,0},
  {SPR_SPID,11,1,A_Pain,S_STLK_FRUN1,0,0},
  //Stalker Death
  {SPR_SPID,14,4,NULL,S_STLK_DIE2,0,0},
  {SPR_SPID,15,4,A_Scream,S_STLK_DIE3,0,0},
  {SPR_SPID,16,4,NULL,S_STLK_DIE4,0,0},
  {SPR_SPID,17,4,NULL,S_STLK_DIE5,0,0},
  {SPR_SPID,18,4,NULL,S_STLK_DIE6,0,0},
  {SPR_SPID,19,4,NULL,S_STLK_DIE7,0,0},
  {SPR_SPID,20,4,A_Fall,S_STLK_DIE8,0,0},
  {SPR_SPID,21,4,NULL,S_STLK_DIE9,0,0},
  {SPR_SPID,22,4,NULL,S_STLK_DIE10,0,0},
  {SPR_SPID,32791,4,NULL,S_STLK_DIE11,0,0},
  {SPR_SPID,32792,4,NULL,S_STLK_DIE12,0,0},
  {SPR_SPID,32793,4,NULL,S_STLK_DIE13,0,0},
  {SPR_SPID,32794,4,NULL,S_NULL,0,0},

  //Sentinel
  {SPR_SEWR,0,10,A_Look,S_SEWR_STND,0,0},
  //Sentinel Move
  {SPR_SEWR,0,6,A_Levitate,S_SEWR_RUN2,0,0},
  {SPR_SEWR,0,6,A_Chase,S_SEWR_RUN1,0,0},
  //Sentinel Pain
  {SPR_SEWR,3,5,A_Pain,S_SWER_ROUND2,0,0},
  //Sentinel Attack
  {SPR_SEWR,1,4,A_FaceTarget,S_SEWR_ROUND1,0,0},
  //Sentinel Death
  {SPR_SEWR,3,7,A_Scream,S_SEWR_DIE2,0,0},
  {SPR_SEWR,32772,8,A_BodyParts,S_SEWR_DIE3,0,0},
  {SPR_SEWR,32773,5,A_Fall,S_SEWR_DIE4,0,0},
  {SPR_SEWR,32774,4,A_BodyParts,S_SEWR_DIE5,0,0},
  {SPR_SEWR,32775,4,A_BodyParts,S_SEWR_DIE6,0,0},
  {SPR_SEWR,8,4,NULL,S_SEWR_DIE7,0,0},
  {SPR_SEWR,9,5,NULL,S_NULL,0,0},
  //Sentinel Sequence
  {SPR_SEWR,32770,8,A_ActorRefire,S_SWER_ROUND2,0,0},
  {SPR_SEWR,32770,4,A_SentinelAttack,S_SEWR_ROUND1,0,0},
  //Sentinel Missile
  {SPR_SHT1,0,4,NULL,S_L_LASER2,0,0},
  {SPR_SHT1,1,4,NULL,S_L_LASER1,0,0},
  //Sentinel Missile Death
  {SPR_POW1,5,4,NULL,S_L_DTH2,0,0},
  {SPR_POW1,6,4,NULL,S_L_DTH3,0,0},
  {SPR_POW1,7,4,NULL,S_L_DTH4,0,0},
  {SPR_POW1,8,4,NULL,S_L_DTH5,0,0},
  {SPR_POW1,9,4,NULL,S_NULL,0,0},

  //Crusader
  {SPR_ROB2,16,10,A_Look,S_ROB2_STND,0,0},
  //Crusader Chase
  {SPR_ROB2,1,3,A_Chase,S_ROB2_RUN2,0,0},
  {SPR_ROB2,1,3,A_Chase,S_ROB2_RUN3,0,0},
  {SPR_ROB2,2,3,A_Chase,S_ROB2_RUN4,0,0},
  {SPR_ROB2,2,3,A_Chase,S_ROB2_RUN5,0,0},
  {SPR_ROB2,3,3,A_Chase,S_ROB2_RUN6,0,0},
  {SPR_ROB2,3,3,A_Chase,S_ROB2_RUN7,0,0},
  {SPR_ROB2,4,3,A_Chase,S_ROB2_RUN8,0,0},
  {SPR_ROB2,4,3,A_Chase,S_ROB2_RUN1,0,0},
  //Crusader Attack
  {SPR_ROB2,4,3,A_FaceTarget,S_ROB2_ATK2,0,0},
  {SPR_ROB2,32773,2,A_CrusaderAttack,S_ROB2_ATK3,0,0},
  {SPR_ROB2,32772,2,A_CrusaderLeft,S_ROB2_ATK4,0,0},
  {SPR_ROB2,32773,3,A_CrusaderLeft,S_ROB2_ATK5,0,0},
  {SPR_ROB2,32772,2,A_CrusaderLeft,S_ROB2_ATK6,0,0},
  {SPR_ROB2,32773,2,A_CrusaderLeft,S_ROB2_ATK7,0,0},
  {SPR_ROB2,32772,2,A_CrusaderRight,S_ROB2_ATK8,0,0},
  {SPR_ROB2,32773,2,A_CrusaderRight,S_ROB2_ATK9,0,0},
  {SPR_ROB2,5,2,A_CrusaderRight,S_ROB2_ATK10,0,0},
  {SPR_ROB2,3,1,A_ActorRepeatFire,S_ROB2_RUN1,0,0},
  //Crusader Pain
  {SPR_ROB2,3,1,A_Pain,S_ROB2_RUN1,0,0},
  //Crusader Death
  {SPR_ROB2,6,3,A_Scream, S_ROB2_DIE2,0,0},
  {SPR_ROB2,7,5,A_BodyParts, S_ROB2_DIE3,0,0},
  {SPR_ROB2,32776,4,A_BodyParts, S_ROB2_DIE4,0,0},
  {SPR_ROB2,32777,4,A_Explode, S_ROB2_DIE5,0,0},
  {SPR_ROB2,32778,4,A_Fall, S_ROB2_DIE6,0,0},
  {SPR_ROB2,11,4,A_Explode, S_ROB2_DIE7,0,0},
  {SPR_ROB2,12,4,A_BodyParts, S_ROB2_DIE8,0,0},
  {SPR_ROB2,13,4,A_BodyParts, S_ROB2_DIE9,0,0},
  {SPR_ROB2,14,4,A_Explode, S_ROB2_DIE10,0,0},
  {SPR_ROB2,15,-1,A_ActorSpecialEvent, S_NULL,0,0},

  //Programmer
  {SPR_PRGR,0,5,A_Look, S_PRGR_STND2,0,0},
  {SPR_PRGR,0,1,A_Levitate, S_PRGR_STND,0,0},
  //Chase
  {SPR_PRGR,0,160,A_Levitate, S_PRGR_RUN2,0,0},
  {SPR_PRGR,1,5,A_Levitate, S_PRGR_RUN3,0,0},
  {SPR_PRGR,2,5,A_Levitate, S_PRGR_RUN4,0,0},
  {SPR_PRGR,3,5,A_Levitate, S_PRGR_RUN5,0,0},
  {SPR_PRGR,4,2,A_Levitate, S_PRGR_RUN6,0,0},
  {SPR_PRGR,5,2,A_Levitate, S_PRGR_RUN7,0,0},
  {SPR_PRGR,4,3,A_Chase, S_PRGR_RUN8,0,0},
  {SPR_PRGR,5,3,A_Chase, S_PRGR_RUN5,0,0},
  //Pain
  {SPR_PRGR,10,5,A_Pain, S_PRGR_PAIN2,0,0},
  {SPR_PRGR,11,5,A_Levitate, S_PRGR_RUN5,0,0},
  //Melee
  {SPR_PRGR,4,2,A_Levitate, S_PRGR_MEL2,0,0},
  {SPR_PRGR,5,3,A_Levitate, S_PRGR_MEL3,0,0},
  {SPR_PRGR,4,3,A_FaceTarget, S_PRGR_MEL4,0,0},
  {SPR_PRGR,5,4,A_ProgrammerGrab, S_PRGR_RUN5,0,0},
  //Attack
  {SPR_PRGR,6,5,A_FaceTarget, S_PRGR_ATK2,0,0},
  {SPR_PRGR,7,5,A_Levitate, S_PRGR_ATK3,0,0},
  {SPR_PRGR,32776,5,A_FaceTarget, S_PRGR_ATK4,0,0},
  {SPR_PRGR,32777,5,A_ProgrammerAttack, S_PRGR_RUN5,0,0},
  //Death
  {SPR_PRGR,32779,7,A_BodyParts, S_PRGR_DIE2,0,0},
  {SPR_PRGR,32780,7,A_Scream, S_PRGR_DIE3,0,0},
  {SPR_PRGR,32781,7,A_BodyParts, S_PRGR_DIE4,0,0},
  {SPR_PRGR,32782,7,A_Fall, S_PRGR_DIE5,0,0},
  {SPR_PRGR,32783,7,A_BodyParts, S_PRGR_DIE6,0,0},
  {SPR_PRGR,32784,7,A_ProgrammerDie, S_PRGR_DIE7,0,0},
  {SPR_PRGR,32785,7,NULL, S_PRGR_DIE8,0,0},
  {SPR_PRGR,32786,6,NULL, S_PRGR_DIE9,0,0},
  {SPR_PRGR,32787,5,NULL, S_PRGR_DIE10,0,0},
  {SPR_PRGR,32788,5,NULL, S_PRGR_DIE11,0,0},
  {SPR_PRGR,32789,5,NULL, S_PRGR_DIE12,0,0},
  {SPR_PRGR,32790,5,NULL, S_PRGR_DIE13,0,0},
  {SPR_PRGR,32791,32,NULL, S_PRGR_DIE14,0,0},
  {SPR_PRGR,23,-1,A_ProgrammerSpecial, S_NULL,0,0},

  //Programmer's Base
  {SPR_BASE,32768,5,A_NewWorldWarp, S_PBASE2,0,0},	//special
  {SPR_BASE,32769,5,A_NewWorldWarp, S_PBASE3,0,0},
  {SPR_BASE,32770,5,NULL, S_PBASE4,0,0},
  {SPR_BASE,32771,5,NULL, S_PBASE5,0,0},
  {SPR_BASE,4,5,NULL, S_PBASE6,0,0},
  {SPR_BASE,5,5,NULL, S_PBASE7,0,0},
  {SPR_BASE,6,5,NULL, S_PBASE8,0,0},
  {SPR_BASE,7,-1,NULL, S_NULL,0,0},

  //Sigil A Attack
  //Ground
  {SPR_ZAP5,32768,4,A_Sigil_A_Action, S_S_A_GROUND2,0,0},
  {SPR_ZAP5,32769,4,A_Sigil_A_Attack, S_S_A_GROUND3,0,0},
  {SPR_ZAP5,32770,4,A_Sigil_A_Action, S_S_A_GROUND4,0,0},
  {SPR_ZAP5,32771,4,A_Sigil_A_Action, S_S_A_GROUND1,0,0},
  //Zapper
  {SPR_ZOT1,32768,4,NULL,S_S_A_ZAP2,0,0},
  {SPR_ZOT1,32769,4,NULL,S_S_A_ZAP3,0,0},
  {SPR_ZOT1,32770,6,NULL,S_S_A_ZAP4,0,0},
  {SPR_ZOT1,32771,6,NULL,S_S_A_ZAP5,0,0},
  {SPR_ZOT1,32772,6,NULL,S_S_A_ZAP1,0,0},

  //Sigil B Shot
  {SPR_ZAP6,32768,4,NULL, S_S_B_SHOT2,0,0},
  {SPR_ZAP6,32769,4,A_SigilTrail, S_S_B_SHOT3,0,0},
  {SPR_ZAP6,32770,4,A_SigilTrail, S_S_B_SHOT1,0,0},

  //Sigil Trail
  {SPR_ZAP6,32768,5,NULL, S_S_TRAIL2,0,0},
  {SPR_ZAP6,32769,5,NULL, S_S_TRAIL3,0,0},
  {SPR_ZAP6,32770,5,NULL, S_NULL,0,0},

  //Sigil C Shot
  {SPR_ZOT3,32768,4,NULL, S_S_C_SHOT2,0,0},
  {SPR_ZOT3,32769,4,NULL, S_S_C_SHOT3,0,0},
  {SPR_ZOT3,32770,4,NULL, S_S_C_SHOT4,0,0},
  {SPR_ZOT3,32771,4,NULL, S_S_C_SHOT5,0,0},
  {SPR_ZOT3,32772,4,NULL, S_S_C_SHOT1,0,0},

  //Sigil D Shot
  {SPR_ZOT2,32768,4,A_Seeker, S_S_D_SHOT2,0,0},
  {SPR_ZOT2,32769,4,A_Seeker, S_S_D_SHOT3,0,0},
  {SPR_ZOT2,32770,6,A_Seeker, S_S_D_SHOT4,0,0},
  {SPR_ZOT2,32771,6,A_Seeker, S_S_D_SHOT5,0,0},
  {SPR_ZOT2,32772,5,A_Seeker, S_S_D_SHOT1,0,0},

  //Sigil E Shot
  {SPR_ZAP7,32768,4,A_Sigil_E_Action, S_S_E_SHOT2,0,0},
  {SPR_ZAP7,32769,4,A_Sigil_E_Action, S_S_E_SHOT3,0,0},
  {SPR_ZAP7,32770,6,A_Sigil_E_Action, S_S_E_SHOT4,0,0},
  {SPR_ZAP7,32771,6,A_Sigil_E_Action, S_S_E_SHOT5,0,0},
  {SPR_ZAP7,32772,6,A_Sigil_E_Action, S_S_E_SHOT1,0,0},

  //LoreMaster
  {SPR_PRST,0,10,A_Look, S_PRST_STND2,0,0},
  {SPR_PRST,1,10,A_Levitate, S_PRST_STND,0,0},
  //Chase
  {SPR_PRST,0,4,A_Chase, S_PRST_RUN2,0,0},
  {SPR_PRST,0,4,A_Levitate, S_PRST_RUN3,0,0},
  {SPR_PRST,1,4,A_Chase, S_PRST_RUN4,0,0},
  {SPR_PRST,1,4,A_Levitate, S_PRST_RUN5,0,0},
  {SPR_PRST,2,4,A_Chase, S_PRST_RUN6,0,0},
  {SPR_PRST,2,4,A_Levitate, S_PRST_RUN7,0,0},
  {SPR_PRST,3,4,A_Chase, S_PRST_RUN8,0,0},
  {SPR_PRST,3,4,A_Levitate, S_PRST_RUN1,0,0},
  //Melee
  {SPR_PRST,4,4,A_FaceTarget, S_PRST_MEL2,0,0},
  {SPR_PRST,5,4,A_SpectureMelee, S_PRST_MEL3,0,0},
  {SPR_PRST,4,4,A_Levitate, S_PRST_RUN1,0,0},
  //Attack
  {SPR_PRST,4,4,A_FaceTarget, S_PRST_ATK2,0,0},
  {SPR_PRST,5,4,A_PriestAttack, S_PRST_ATK3,0,0},
  {SPR_PRST,4,4,A_Levitate, S_PRST_RUN1,0,0},
  //Death
  {SPR_PDED,0,6,NULL, S_PRST_DIE2,0,0},
  {SPR_PDED,1,6,A_Scream, S_PRST_DIE3,0,0},
  {SPR_PDED,2,6,NULL, S_PRST_DIE4,0,0},
  {SPR_PDED,3,6,A_Fall, S_PRST_DIE5,0,0},
  {SPR_PDED,4,6,NULL, S_PRST_DIE6,0,0},
  {SPR_PDED,5,5,NULL, S_PRST_DIE7,0,0},
  {SPR_PDED,6,5,NULL, S_PRST_DIE8,0,0},
  {SPR_PDED,7,5,NULL, S_PRST_DIE9,0,0},
  {SPR_PDED,8,5,NULL, S_PRST_DIE10,0,0},
  {SPR_PDED,9,5,NULL, S_PRST_DIE11,0,0},
  {SPR_PDED,8,5,NULL, S_PRST_DIE12,0,0},
  {SPR_PDED,9,5,NULL, S_PRST_DIE13,0,0},
  {SPR_PDED,8,5,NULL, S_PRST_DIE14,0,0},
  {SPR_PDED,9,5,NULL, S_PRST_DIE15,0,0},
  {SPR_PDED,10,5,NULL, S_PRST_DIE16,0,0},
  {SPR_PDED,11,5,NULL, S_PRST_DIE17,0,0},
  {SPR_PDED,12,4,NULL, S_PRST_DIE18,0,0},
  {SPR_PDED,13,4,NULL, S_PRST_DIE19,0,0},
  {SPR_PDED,14,4,NULL, S_PRST_DIE20,0,0},
  {SPR_PDED,15,4,NULL, S_PRST_DIE21,0,0},
  {SPR_PDED,16,4,A_PriestDie, S_PRST_DIE22,0,0},
  {SPR_PDED,17,4,NULL, S_PRST_DIE23,0,0},
  {SPR_PDED,18,4,NULL, S_PRST_DIE24,0,0},
  {SPR_PDED,19,-1,NULL, S_NULL,0,0},
  //Priest Missile
  {SPR_OCLW,0,2,A_ChainTend,S_OCLW,0,0},
  {SPR_CCLW,0,6,NULL,S_NULL,0,0},
  {SPR_TEND,0,20,NULL,S_NULL,0,0},

  //Specture
  {SPR_ALN1,0,10,A_Look,S_ALN1_STND2,0,0},
  {SPR_ALN1,1,10,A_Levitate,S_ALN1_STND,0,0},
  //Chase
  {SPR_ALN1,32768,4,A_Chase,S_ALN1_RUN2,0,0},
  {SPR_ALN1,32769,4,A_Chase,S_ALN1_RUN3,0,0},
  {SPR_ALN1,32770,4,A_Levitate,S_ALN1_RUN4,0,0},
  {SPR_ALN1,32771,4,A_Chase,S_ALN1_RUN5,0,0},
  {SPR_ALN1,32772,4,A_Chase,S_ALN1_RUN6,0,0},
  {SPR_ALN1,32773,4,A_Chase,S_ALN1_RUN7,0,0},
  {SPR_ALN1,32774,4,A_Levitate,S_ALN1_RUN8,0,0},
  {SPR_ALN1,32775,4,A_Chase,S_ALN1_RUN9,0,0},
  {SPR_ALN1,32776,4,A_Chase,S_ALN1_RUN10,0,0},
  {SPR_ALN1,32777,4,A_Chase,S_ALN1_RUN11,0,0},
  {SPR_ALN1,32778,4,A_Levitate,S_ALN1_RUN1,0,0},
  //Pain
  {SPR_ALN1,9,2,A_Pain,S_ALN1_RUN1,0,0},
  //Melee
  {SPR_ALN1,32777,4,A_FaceTarget,S_ALN1_MEL2,0,0},
  {SPR_ALN1,32776,4,A_SpectureMelee,S_ALN1_MEL3,0,0},
  {SPR_ALN1,32775,4,NULL,S_ALN1_RUN3,0,0},
  //Attack
  {SPR_ALN1,32777,4,A_FaceTarget,S_ALN1_ATK2,0,0},
  {SPR_ALN1,32776,4,A_ProgrammerAttack,S_ALN1_ATK3,0,0},
  {SPR_ALN1,32775,4,NULL,S_ALN1_RUN11,0,0},
  //Death
  {SPR_AL1P,32768,6,A_NodeChunk,S_ALN1_DIE2,0,0},
  {SPR_AL1P,32769,6,A_Scream,S_ALN1_DIE3,0,0},
  {SPR_AL1P,32770,6,A_NodeChunk,S_ALN1_DIE4,0,0},
  {SPR_AL1P,32771,6,NULL,S_ALN1_DIE5,0,0},
  {SPR_AL1P,32772,6,NULL,S_ALN1_DIE6,0,0},
  {SPR_AL1P,32773,6,A_NodeChunk,S_ALN1_DIE7,0,0},
  {SPR_AL1P,32774,6,NULL,S_ALN1_DIE8,0,0},
  {SPR_AL1P,32775,6,A_NodeChunk,S_ALN1_DIE9,0,0},
  {SPR_AL1P,32776,6,NULL,S_ALN1_DIE10,0,0},
  {SPR_AL1P,32777,6,NULL,S_ALN1_DIE11,0,0},
  {SPR_AL1P,32778,6,NULL,S_ALN1_DIE12,0,0},
  {SPR_AL1P,32779,5,NULL,S_ALN1_DIE13,0,0},
  {SPR_AL1P,32780,5,A_HeadChunk,S_ALN1_DIE14,0,0},
  {SPR_AL1P,32781,5,NULL,S_ALN1_DIE15,0,0},
  {SPR_AL1P,32782,5,NULL,S_ALN1_DIE16,0,0},
  {SPR_AL1P,32783,5,NULL,S_ALN1_DIE17,0,0},
  {SPR_AL1P,32784,5,NULL,S_ALN1_DIE18,0,0},
  {SPR_AL1P,32785,5,A_ActorSpecialEvent,S_NULL,0,0},
  //Versions
  {SPR_ALN1,32777,4,A_FaceTarget,S_ALN1_2_ATK2,0,0},
  {SPR_ALN1,32776,4,A_SpectureAttack,S_ALN1_2_ATK3,0,0},
  {SPR_ALN1,32775,4,NULL,S_ALN1_RUN11,0,0},
  //Version 3
  //Look
  {SPR_ALN1,0,5,A_Levitate,S_ALN3_STND2,0,0},
  {SPR_ALN1,1,5,A_Levitate,S_ALN3_STND3,0,0},
  {SPR_ALN1,2,5,A_Levitate,S_ALN3_STND4,0,0},
  {SPR_ALN1,3,5,A_Levitate,S_ALN3_STND5,0,0},
  {SPR_ALN1,4,5,A_Levitate,S_ALN3_STND6,0,0},
  {SPR_ALN1,5,5,A_Levitate,S_ALN3_STND7,0,0},
  {SPR_ALN1,6,5,A_Levitate,S_ALN3_STND8,0,0},
  {SPR_ALN1,7,5,A_Levitate,S_ALN3_STND9,0,0},
  {SPR_ALN1,8,5,A_Levitate,S_ALN3_STND10,0,0},
  {SPR_ALN1,9,5,A_Levitate,S_ALN3_STND11,0,0},
  {SPR_ALN1,10,5,A_Levitate,S_ALN3_STND,0,0},
  //Version3 Chase
  {SPR_ALN1,0,4,A_Chase,S_ALN3_RUN2,0,0},
  {SPR_ALN1,1,4,A_Chase,S_ALN3_RUN3,0,0},
  {SPR_ALN1,2,4,A_Levitate,S_ALN3_RUN4,0,0},
  {SPR_ALN1,3,4,A_Chase,S_ALN3_RUN5,0,0},
  {SPR_ALN1,4,4,A_Chase,S_ALN3_RUN6,0,0},
  {SPR_ALN1,5,4,A_Chase,S_ALN3_RUN7,0,0},
  {SPR_ALN1,6,4,A_Levitate,S_ALN3_RUN8,0,0},
  {SPR_ALN1,7,4,A_Chase,S_ALN3_RUN9,0,0},
  {SPR_ALN1,8,4,A_Chase,S_ALN3_RUN10,0,0},
  {SPR_ALN1,9,4,A_Chase,S_ALN3_RUN11,0,0},
  {SPR_ALN1,10,4,A_Levitate,S_ALN3_RUN1,0,0},
  //Pain
  {SPR_ALN1,9,2,A_Pain,S_ALN3_RUN1,0,0},
  //Melee
  {SPR_ALN1,9,4,A_FaceTarget,S_ALN3_MEL2,0,0},
  {SPR_ALN1,8,4,A_SpectureMelee,S_ALN3_MEL3,0,0},
  {SPR_ALN1,2,4,NULL,S_ALN3_RUN3,0,0},
  //Attack
  {SPR_ALN1,5,4,A_FaceTarget,S_ALN3_ATK2,0,0},
  {SPR_ALN1,8,4,A_SpectureCAttack,S_ALN3_ATK3,0,0},
  {SPR_ALN1,4,4,NULL,S_ALN3_RUN11,0,0},
  //Version 4
  {SPR_ALN1,5,4,A_FaceTarget,S_ALN4_ATK2,0,0},
  {SPR_ALN1,8,4,A_SpectureDAttack,S_ALN4_ATK3,0,0},
  {SPR_ALN1,4,4,NULL,S_ALN1_RUN11,0,0},
  {SPR_ALN1,5,4,A_FaceTarget,S_ALN5_ATK2,0,0},
  {SPR_ALN1,8,4,A_SpectureEAttack,S_ALN5_ATK3,0,0},
  {SPR_ALN1,4,4,NULL,S_ALN1_RUN11,0,0},
  //Node
  {SPR_NODE,32768,6,NULL,S_NODE2,0,0},
  {SPR_NODE,32769,6,NULL,S_NODE3,0,0},
  {SPR_NODE,32770,6,NULL,S_NODE4,0,0},
  {SPR_NODE,32771,6,NULL,S_NODE5,0,0},
  {SPR_NODE,32772,6,NULL,S_NODE6,0,0},
  {SPR_NODE,32773,6,NULL,S_NODE7,0,0},
  {SPR_NODE,32774,6,NULL,S_NULL,0,0},
  //HeadChunk
  {SPR_MTHD,32768,5,NULL,S_MTHD2,0,0},
  {SPR_MTHD,32769,5,NULL,S_MTHD3,0,0},
  {SPR_MTHD,32770,5,NULL,S_MTHD4,0,0},
  {SPR_MTHD,32771,5,NULL,S_MTHD5,0,0},
  {SPR_MTHD,32772,5,NULL,S_MTHD6,0,0},
  {SPR_MTHD,32773,5,NULL,S_MTHD7,0,0},
  {SPR_MTHD,32774,5,NULL,S_MTHD8,0,0},
  {SPR_MTHD,32775,5,NULL,S_MTHD9,0,0},
  {SPR_MTHD,32776,5,NULL,S_MTHD10,0,0},
  {SPR_MTHD,32777,5,NULL,S_MTHD11,0,0},
  {SPR_MTHD,32778,5,NULL,S_NULL,0,0},

  //Bishop
  {SPR_MLDR,0,10,A_Look,S_MLDR_STND,0,0},
  //Chase
  {SPR_MLDR,0,3,A_Chase,S_MLDR_RUN2,0,0},
  {SPR_MLDR,0,3,A_Chase,S_MLDR_RUN3,0,0},
  {SPR_MLDR,1,3,A_Chase,S_MLDR_RUN4,0,0},
  {SPR_MLDR,1,3,A_Chase,S_MLDR_RUN5,0,0},
  {SPR_MLDR,2,3,A_Chase,S_MLDR_RUN6,0,0},
  {SPR_MLDR,2,3,A_Chase,S_MLDR_RUN7,0,0},
  {SPR_MLDR,3,3,A_Chase,S_MLDR_RUN8,0,0},
  {SPR_MLDR,3,3,A_Chase,S_MLDR_RUN1,0,0},
  //Attack
  {SPR_MLDR,4,3,A_FaceTarget,S_MLDR_ATK2,0,0},
  {SPR_MLDR,32773,2,A_BishopAttack,S_MLDR_RUN1,0,0},
  //Pain
  {SPR_MLDR,3,1,A_Pain,S_MLDR_RUN1,0,0},
  //Death
  {SPR_MLDR,32774,3,NULL,S_MLDR_DIE2,0,0},
  {SPR_MLDR,32775,5,A_Scream,S_MLDR_DIE3,0,0},
  {SPR_MLDR,32776,4,A_BodyParts,S_MLDR_DIE4,0,0},
  {SPR_MLDR,32777,4,A_Explode,S_MLDR_DIE5,0,0},
  {SPR_MLDR,32778,4,NULL,S_MLDR_DIE6,0,0},
  {SPR_MLDR,32779,4,NULL,S_MLDR_DIE7,0,0},
  {SPR_MLDR,32780,4,A_Fall,S_MLDR_DIE8,0,0},
  {SPR_MLDR,32781,4,NULL,S_MLDR_DIE9,0,0},
  {SPR_MLDR,32782,4,A_BodyParts,S_MLDR_DIE10,0,0},
  {SPR_MLDR,32783,4,NULL,S_MLDR_DIE11,0,0},
  {SPR_MLDR,32784,4,A_BodyParts,S_MLDR_DIE12,0,0},
  {SPR_MLDR,32785,4,NULL,S_MLDR_DIE13,0,0},
  {SPR_MLDR,32786,4,A_BodyParts,S_MLDR_DIE14,0,0},
  {SPR_MLDR,32787,4,NULL,S_MLDR_DIE15,0,0},
  {SPR_MLDR,32788,4,A_BodyParts,S_MLDR_DIE16,0,0},
  {SPR_MLDR,21,-1,A_SpectureBReveal,S_NULL,0,0},
  //Missile
  {SPR_MISS,32768,4,A_Rocketpuff,S_SEEKMISSLE2,0,0},
  {SPR_MISS,32769,3,A_Seeker,S_SEEKMISSLE,0,0},

  //Inquisitor
  {SPR_ROB3,0,10,A_Look,S_ROB3_STND2,0,0},
  {SPR_ROB3,1,10,A_Look,S_ROB3_STND,0,0},
  //Chase
  {SPR_ROB3,1,3,A_InqFlyCheck,S_ROB3_RUN2,0,0},
  {SPR_ROB3,1,3,A_Chase,S_ROB3_RUN3,0,0},
  {SPR_ROB3,2,4,A_Chase,S_ROB3_RUN4,0,0},
  {SPR_ROB3,2,4,A_Chase,S_ROB3_RUN5,0,0},
  {SPR_ROB3,3,4,A_Chase,S_ROB3_RUN6,0,0},
  {SPR_ROB3,3,4,A_Chase,S_ROB3_RUN7,0,0},
  {SPR_ROB3,4,3,A_InqFlyCheck,S_ROB3_RUN8,0,0},
  {SPR_ROB3,4,3,A_InqThinker,S_ROB3_RUN1,0,0},
  //Attack
  {SPR_ROB3,0,2,A_InqThinker,S_ROB3_ATK2,0,0},
  {SPR_ROB3,5,6,A_FaceTarget,S_ROB3_ATK3,0,0},
  {SPR_ROB3,32774,8,A_InqShootGun,S_ROB3_ATK4,0,0},
  {SPR_ROB3,6,8,A_InqShootGun,S_ROB3_RUN1,0,0},
  //Attack2
  {SPR_ROB3,10,12,A_FaceTarget,S_ROB3_GREN2,0,0},
  {SPR_ROB3,32777,6,A_InqGrenade,S_ROB3_GREN3,0,0},
  {SPR_ROB3,10,12,NULL,S_ROB3_RUN1,0,0},
  //Fly
  {SPR_ROB3,32775,8,A_InqTakeOff,S_ROB3_FLY2,0,0},
  {SPR_ROB3,32776,4,A_InqFly,S_ROB3_FLY3,0,0},
  {SPR_ROB3,32775,4,A_InqFly,S_ROB3_FLY2,0,0},
  //Death
  {SPR_ROB3,11,4,A_BodyParts,S_ROB3_DIE2,0,0},
  {SPR_ROB3,12,4,A_Scream,S_ROB3_DIE3,0,0},
  {SPR_ROB3,13,4,A_BodyParts,S_ROB3_DIE4,0,0},
  {SPR_ROB3,32782,4,A_Explode2,S_ROB3_DIE5,0,0},
  {SPR_ROB3,32783,4,A_BodyParts,S_ROB3_DIE6,0,0},
  {SPR_ROB3,32784,4,A_Fall,S_ROB3_DIE7,0,0},
  {SPR_ROB3,17,4,A_BodyParts,S_ROB3_DIE8,0,0},
  {SPR_ROB3,18,4,A_BodyParts,S_ROB3_DIE9,0,0},
  {SPR_ROB3,19,4,A_BodyParts,S_ROB3_DIE10,0,0},
  {SPR_ROB3,20,4,A_BodyParts,S_ROB3_DIE11,0,0},
  {SPR_ROB3,21,4,A_BodyParts,S_ROB3_DIE12,0,0},
  {SPR_ROB3,32790,4,A_Explode2,S_ROB3_DIE13,0,0},
  {SPR_ROB3,32791,4,A_BodyParts,S_ROB3_DIE14,0,0},
  {SPR_ROB3,32792,4,A_BodyParts,S_ROB3_DIE15,0,0},
  {SPR_ROB3,25,4,A_BodyParts,S_ROB3_DIE16,0,0},
  {SPR_ROB3,26,4,A_BodyParts,S_ROB3_DIE17,0,0},
  {SPR_ROB3,27,3,A_BodyParts,S_ROB3_DIE18,0,0},
  {SPR_ROB3,32796,3,A_Explode2,S_ROB3_DIE19,0,0},
  {SPR_RBB3,32768,3,A_DropInqArm,S_ROB3_DIE20,0,0},
  {SPR_RBB3,32769,3,A_BodyParts,S_ROB3_DIE21,0,0},
  {SPR_RBB3,2,3,A_BodyParts,S_ROB3_DIE22,0,0},
  {SPR_RBB3,3,3,A_BodyParts,S_ROB3_DIE23,0,0},
  {SPR_RBB3,4,-1,NULL,S_NULL,0,0},	//special
  //Arm
  {SPR_RBB3,32773,5,NULL,S_RBB3_2,0,0},
  {SPR_RBB3,32774,5,NULL,S_RBB3_3,0,0},
  {SPR_RBB3,7,-1,NULL,S_NULL,0,0},
  //Grenade
  {SPR_UBAM,0,3,NULL,S_ROB3GREN2,0,0},	//none for now -kaiser
  {SPR_UBAM,1,3,NULL,S_ROB3GREN1,0,0},
  //Explode
  {SPR_BNG2,32768,4,A_InqGrenadeExplode,S_BNG2_2,0,0},
  {SPR_BNG2,32769,4,NULL,S_BNG2_3,0,0},
  {SPR_BNG2,32770,4,NULL,S_BNG2_4,0,0},
  {SPR_BNG2,32771,4,NULL,S_BNG2_5,0,0},
  {SPR_BNG2,32772,4,NULL,S_BNG2_6,0,0},
  {SPR_BNG2,32773,4,NULL,S_BNG2_7,0,0},
  {SPR_BNG2,32774,4,NULL,S_BNG2_8,0,0},
  {SPR_BNG2,32775,4,NULL,S_BNG2_9,0,0},
  {SPR_BNG2,32776,4,NULL,S_NULL,0,0},

  //Oracle
  {SPR_ORCL,0,-1,NULL,S_NULL,0,0},
  {SPR_ORCL,1,5,NULL,S_ORACLE_3,0,0},
  {SPR_ORCL,2,5,NULL,S_ORACLE_4,0,0},
  {SPR_ORCL,3,5,NULL,S_ORACLE_5,0,0},
  {SPR_ORCL,4,5,NULL,S_ORACLE_6,0,0},
  {SPR_ORCL,5,5,NULL,S_ORACLE_7,0,0},
  {SPR_ORCL,6,5,NULL,S_ORACLE_8,0,0},
  {SPR_ORCL,7,5,NULL,S_ORACLE_9,0,0},
  {SPR_ORCL,8,5,NULL,S_ORACLE_10,0,0},
  {SPR_ORCL,9,5,NULL,S_ORACLE_11,0,0},
  {SPR_ORCL,10,5,NULL,S_ORACLE_12,0,0},
  {SPR_ORCL,11,5,A_Fall,S_ORACLE_13,0,0},
  {SPR_ORCL,12,5,NULL,S_ORACLE_14,0,0},
  {SPR_ORCL,13,5,A_OracleSpecial,S_ORACLE_15,0,0},
  {SPR_ORCL,14,5,NULL,S_ORACLE_16,0,0},
  {SPR_ORCL,15,5,NULL,S_ORACLE_17,0,0},
  {SPR_ORCL,16,-1,NULL,S_NULL,0,0},

  //Macil
  {SPR_LEDR,2,5,A_Stand,S_LEDR_STND,0,0},
  {SPR_LEDR,0,8,NULL,S_LEDR_STND,0,0},
  {SPR_LEDR,1,8,NULL,S_LEDR_STND,0,0},
  //Patrol
  {SPR_LEAD,0,6,A_Patrol,S_LEDR_WALK2,0,0},
  {SPR_LEAD,1,6,A_Patrol,S_LEDR_WALK3,0,0},
  {SPR_LEAD,2,6,A_Patrol,S_LEDR_WALK4,0,0},
  {SPR_LEAD,3,6,A_Patrol,S_LEDR_STND,0,0},
  //Chase
  {SPR_LEAD,0,3,A_Chase,S_LEDR_RUN2,0,0},
  {SPR_LEAD,0,3,A_Chase,S_LEDR_RUN3,0,0},
  {SPR_LEAD,1,3,A_Chase,S_LEDR_RUN4,0,0},
  {SPR_LEAD,1,3,A_Chase,S_LEDR_RUN5,0,0},
  {SPR_LEAD,2,3,A_Chase,S_LEDR_RUN6,0,0},
  {SPR_LEAD,2,3,A_Chase,S_LEDR_RUN7,0,0},
  {SPR_LEAD,3,3,A_Chase,S_LEDR_RUN8,0,0},
  {SPR_LEAD,3,3,A_Chase,S_LEDR_RUN1,0,0},
  //Attack
  {SPR_LEAD,4,2,A_FaceTarget,S_LEDR_ATK2,0,0},
  {SPR_LEAD,5,2,A_AgrdAttack,S_LEDR_ATK3,0,0},
  {SPR_LEAD,4,1,A_ActorRefire,S_LEDR_ATK1,0,0},
  {SPR_LEAD,4,4,A_FaceTarget,S_LEDR_2ATK2,0,0},
  {SPR_LEAD,5,4,A_AgrdAttack,S_LEDR_2ATK3,0,0},
  {SPR_LEAD,4,2,A_ActorRefire,S_LEDR_2ATK1,0,0},
  //Pain
  {SPR_LEAD,24,3,NULL,S_LEDR_PAIN2,0,0},
  {SPR_LEAD,24,3,A_Pain,S_LEDR_RUN1,0,0},
  //Death
  {SPR_LEAD,6,5,NULL,S_LEDR_DTH2,0,0},
  {SPR_LEAD,7,5,A_Scream,S_LEDR_DTH3,0,0},
  {SPR_LEAD,8,4,NULL,S_LEDR_DTH4,0,0},
  {SPR_LEAD,9,4,NULL,S_LEDR_DTH5,0,0},
  {SPR_LEAD,10,3,NULL,S_LEDR_DTH6,0,0},
  {SPR_LEAD,11,3,A_Fall,S_LEDR_DTH7,0,0},
  {SPR_LEAD,12,3,NULL,S_LEDR_DTH8,0,0},
  {SPR_LEAD,13,3,NULL,S_LEDR_DTH9,0,0},
  {SPR_LEAD,14,3,NULL,S_LEDR_DTH10,0,0},
  {SPR_LEAD,15,3,NULL,S_LEDR_DTH11,0,0},
  {SPR_LEAD,16,3,NULL,S_LEDR_DTH12,0,0},
  {SPR_LEAD,17,3,NULL,S_LEDR_DTH13,0,0},
  {SPR_LEAD,18,3,NULL,S_LEDR_DTH14,0,0},
  {SPR_LEAD,19,3,NULL,S_LEDR_DTH15,0,0},
  {SPR_LEAD,20,3,NULL,S_LEDR_DTH16,0,0},
  {SPR_LEAD,21,3,NULL,S_LEDR_DTH17,0,0},
  {SPR_LEAD,22,3,A_SpectureDReveal,S_LEDR_DTH18,0,0},
  {SPR_LEAD,23,-1,NULL,S_NULL,0,0},
  
  //Zombie
  {SPR_PEAS,0,5,A_ZombieInSpecialSector,S_ZMBE_STND,0,0},
  {SPR_AGRD,0,5,A_ZombieInSpecialSector,S_ZMBE_PAIN,0,0},
  //Spawner
  {SPR_PLAY,0,175,A_SpawnZombie,S_ZMBES_STND,0,0},

  //Rebel
  {SPR_HMN1,15,5,A_Stand,S_HMN1_STND,0,0},
  {SPR_HMN1,16,8,NULL,S_HMN1_STND,0,0},
  {SPR_HMN1,17,8,NULL,S_HMN1_STND,0,0},
  //Patrol
  {SPR_HMN1,0,6,A_Patrol,S_HMN1_WALK2,0,0},
  {SPR_HMN1,1,6,A_Patrol,S_HMN1_WALK3,0,0},
  {SPR_HMN1,2,6,A_Patrol,S_HMN1_WALK4,0,0},
  {SPR_HMN1,3,6,A_Patrol,S_HMN1_WALK5,0,0},
  {SPR_HMN1,0,6,A_Patrol,S_HMN1_WALK6,0,0},
  {SPR_HMN1,1,6,A_Patrol,S_HMN1_WALK7,0,0},
  {SPR_HMN1,2,6,A_Patrol,S_HMN1_WALK8,0,0},
  {SPR_HMN1,3,6,A_Patrol,S_HMN1_STND,0,0},
  //Chase
  {SPR_HMN1,0,3,A_Chase,S_HMN1_RUN2,0,0},
  {SPR_HMN1,0,3,A_Chase,S_HMN1_RUN3,0,0},
  {SPR_HMN1,1,3,A_Chase,S_HMN1_RUN4,0,0},
  {SPR_HMN1,1,3,A_Chase,S_HMN1_RUN5,0,0},
  {SPR_HMN1,2,3,A_Chase,S_HMN1_RUN6,0,0},
  {SPR_HMN1,2,3,A_Chase,S_HMN1_RUN7,0,0},
  {SPR_HMN1,3,3,A_Chase,S_HMN1_RUN8,0,0},
  {SPR_HMN1,3,3,A_Chase,S_HMN1_RUN1,0,0},
  //Attack
  {SPR_HMN1,4,10,A_FaceTarget,S_HMN1_ATK2,0,0},
  {SPR_HMN1,32773,10,A_AgrdAttack,S_HMN1_ATK3,0,0},
  {SPR_HMN1,4,10,A_AgrdAttack,S_HMN1_RUN1,0,0},
  //Pain
  {SPR_HMN1,14,3,NULL,S_HMN1_PAIN2,0,0},
  {SPR_HMN1,14,3,A_Pain,S_HMN1_RUN1,0,0},
  //death
  {SPR_HMN1,6,5,NULL,S_HMN1_DTH2,0,0},
  {SPR_HMN1,7,5,A_Scream,S_HMN1_DTH3,0,0},
  {SPR_HMN1,8,3,A_Fall,S_HMN1_DTH4,0,0},
  {SPR_HMN1,9,4,NULL,S_HMN1_DTH5,0,0},
  {SPR_HMN1,10,3,NULL,S_HMN1_DTH6,0,0},
  {SPR_HMN1,11,3,NULL,S_HMN1_DTH7,0,0},
  {SPR_HMN1,12,3,NULL,S_HMN1_DTH8,0,0},
  {SPR_HMN1,13,-1,NULL,S_NULL,0,0},
  //xdeath
  {SPR_RGIB,0,4,NULL,S_HMN1_DTH10,0,0},
  {SPR_RGIB,1,4,A_Scream,S_HMN1_DTH11,0,0},
  {SPR_RGIB,2,3,A_Fall,S_HMN1_DTH12,0,0},
  {SPR_RGIB,3,3,A_BodyParts,S_HMN1_DTH13,0,0},
  {SPR_RGIB,4,3,A_BodyParts,S_HMN1_DTH14,0,0},
  {SPR_RGIB,5,3,A_BodyParts,S_HMN1_DTH15,0,0},
  {SPR_RGIB,6,3,NULL,S_HMN1_DTH16,0,0},
  {SPR_RGIB,7,1400,NULL,S_NULL,0,0},

  //Beggar
  {SPR_BEGR,0,10,A_Look,S_BEGR_STND,0,0},
  //Patrol
  {SPR_BEGR,0,4,A_Wander,S_BEGR_WALK2,0,0},
  {SPR_BEGR,0,4,A_Wander,S_BEGR_WALK3,0,0},
  {SPR_BEGR,1,4,A_Wander,S_BEGR_WALK4,0,0},
  {SPR_BEGR,1,4,A_Wander,S_BEGR_WALK5,0,0},
  {SPR_BEGR,2,4,A_Wander,S_BEGR_WALK6,0,0},
  {SPR_BEGR,2,4,A_Wander,S_BEGR_WALK1,0,0},
  //BEGRantATK
  {SPR_BEGR,3,8,NULL,S_BEGR_ATK2,0,0},
  {SPR_BEGR,4,8,A_PeasAttack,S_BEGR_ATK3,0,0},
  {SPR_BEGR,4,1,A_Chase,S_BEGR_ATK4,0,0},
  {SPR_BEGR,3,8,A_ActorRefire,S_BEGR_ATK1,0,0},
  //BEGRantPAIN
  {SPR_BEGR,0,3,A_Pain,S_BEGR_PAIN2,0,0},
  {SPR_BEGR,0,3,A_Chase,S_BEGR_ATK1,0,0},
  //BEGRantDTH
  {SPR_BEGR,5,4,NULL,S_BEGR_DIE2,0,0},
  {SPR_BEGR,6,4,A_Scream, S_BEGR_DIE3,0,0},
  {SPR_BEGR,7,4,NULL, S_BEGR_DIE4,0,0},
  {SPR_BEGR,8,4,A_Fall, S_BEGR_DIE5,0,0},
  {SPR_BEGR,9,4,NULL, S_BEGR_DIE6,0,0},
  {SPR_BEGR,10,4,NULL, S_BEGR_DIE7,0,0},
  {SPR_BEGR,11,4,NULL, S_BEGR_DIE8,0,0},
  {SPR_BEGR,12,4,NULL, S_BEGR_DIE9,0,0},
  {SPR_BEGR,13,-1,NULL, S_NULL,0,0},
  //BEGRantXDTH
  {SPR_GIBS,5,5,A_BodyParts,S_PEAS_XDIE2,0,0},

  //Final Boss
  {SPR_MNAM,0,100,A_Levitate, S_MNAM_2,0,0},
  {SPR_MNAM,32769,60,A_Levitate, S_MNAM_3,0,0},
  {SPR_MNAM,32770,4,A_Levitate, S_MNAM_4,0,0},
  {SPR_MNAM,32771,4,A_Levitate, S_MNAM_5,0,0},
  {SPR_MNAM,32772,4,A_Levitate, S_MNAM_6,0,0},
  {SPR_MNAM,32773,4,A_Levitate, S_MNAM_7,0,0},
  {SPR_MNAM,32774,4,A_Levitate, S_MNAM_8,0,0},
  {SPR_MNAM,32775,4,A_Levitate, S_MNAM_9,0,0},
  {SPR_MNAM,32776,4,A_Levitate, S_MNAM_10,0,0},
  {SPR_MNAM,32777,4,A_Levitate, S_MNAM_11,0,0},
  {SPR_MNAM,32778,4,A_Levitate, S_MNAM_12,0,0},
  {SPR_MNAM,32779,4,A_Levitate, S_MNAL_STND1,0,0},
  //Look
  {SPR_MNAL,32768,4,A_Look, S_MNAL_STND2,0,0},
  {SPR_MNAL,32769,4,A_Levitate, S_MNAL_STND1,0,0},
  //Chase
  {SPR_MNAL,32768,4,A_Chase, S_MNAL_RUN2,0,0},
  {SPR_MNAL,32769,4,A_Chase, S_MNAL_RUN3,0,0},
  {SPR_MNAL,32770,4,A_Levitate, S_MNAL_RUN4,0,0},
  {SPR_MNAL,32771,4,A_Chase, S_MNAL_RUN5,0,0},
  {SPR_MNAL,32772,4,A_Chase, S_MNAL_RUN6,0,0},
  {SPR_MNAL,32773,4,A_Chase, S_MNAL_RUN7,0,0},
  {SPR_MNAL,32774,4,A_Levitate, S_MNAL_RUN8,0,0},
  {SPR_MNAL,32775,4,A_Chase, S_MNAL_RUN9,0,0},
  {SPR_MNAL,32776,4,A_Chase, S_MNAL_RUN10,0,0},
  {SPR_MNAL,32777,4,A_Chase, S_MNAL_RUN11,0,0},
  {SPR_MNAL,32778,4,A_Levitate, S_MNAL_RUN1,0,0},
  //Melee
  {SPR_MNAL,32777,4,A_FaceTarget,S_MNAL_MEL2,0,0},
  {SPR_MNAL,32776,4,A_SpectureMelee,S_MNAL_MEL3,0,0},
  {SPR_MNAL,32770,4,NULL,S_MNAL_RUN3,0,0},
  //Attack
  {SPR_MNAL,32777,4,A_FaceTarget,S_MNAL_ATK2,0,0},
  {SPR_MNAL,32776,4,A_EntityChooseAttack,S_MNAL_ATK3,0,0},
  {SPR_MNAL,32772,4,NULL,S_MNAL_RUN11,0,0},
  //Pain
  {SPR_MNAL,32777,2,A_Pain,S_MNAL_RUN7,0,0},
  //Death
  {SPR_MNAL,32779,7,A_NodeChunk,S_MNAL_DIE2,0,0},
  {SPR_MNAL,32780,7,A_Scream,S_MNAL_DIE3,0,0},
  {SPR_MNAL,32781,7,A_NodeChunk,S_MNAL_DIE4,0,0},
  {SPR_MNAL,32782,7,A_NodeChunk,S_MNAL_DIE5,0,0},
  {SPR_MNAL,32783,7,A_NodeChunk,S_MNAL_DIE6,0,0},
  {SPR_MNAL,32784,64,A_HeadChunk,S_MNAL_DIE7,0,0},
  {SPR_MNAL,32785,6,A_SubEntitySpawn,S_NULL,0,0},

  //Nest
  {SPR_NEST,0,-1,NULL,S_NULL,0,0},
  //Pod
  {SPR_PODD,0,60,A_Look,S_POD1,0,0},
  {SPR_PODD,0,360,NULL,S_POD3,0,0},
  {SPR_PODD,1,9,A_Fall,S_POD4,0,0},
  {SPR_PODD,2,9,NULL,S_POD5,0,0},
  {SPR_PODD,3,9,A_EntityBorn,S_POD6,0,0},
  {SPR_PODD,4,-1,NULL,S_NULL,0,0},

  //SubEntity
  {SPR_MNAL,32785,10,A_Look,S_SUB_LOOK,0,0},
  //Chase
  {SPR_MNAL,32785,5,A_Levitate,S_SUB_RUN2,0,0},
  {SPR_MNAL,32786,5,A_Chase,S_SUB_RUN3,0,0},
  {SPR_MNAL,32787,5,A_Chase,S_SUB_RUN4,0,0},
  {SPR_MNAL,32788,5,A_Levitate,S_SUB_RUN5,0,0},
  {SPR_MNAL,32789,5,A_Chase,S_SUB_RUN6,0,0},
  {SPR_MNAL,32790,5,A_Levitate,S_SUB_RUN1,0,0},
  //Melee
  {SPR_MNAL,32786,4,A_FaceTarget,S_SUB_MEL2,0,0},
  {SPR_MNAL,32785,4,A_SpectureMelee,S_SUB_MEL3,0,0},
  {SPR_MNAL,32787,4,A_Levitate,S_SUB_RUN2,0,0},
  //Attack
  {SPR_MNAL,32790,4,A_FaceTarget,S_SUB_ATK2,0,0},
  {SPR_MNAL,32788,4,A_SpectureAttack,S_SUB_ATK3,0,0},
  {SPR_MNAL,32789,4,A_Levitate,S_SUB_RUN5,0,0},
  //Pain
  {SPR_MNAL,32785,2,A_Pain,S_SUB_RUN1,0,0},
  //Death
  {SPR_MDTH,32768,3,A_Scream,S_SUB_DIE2,0,0},
  {SPR_MDTH,32769,3,A_BodyParts,S_SUB_DIE3,0,0},
  {SPR_MDTH,32770,3,A_Fall,S_SUB_DIE4,0,0},
  {SPR_MDTH,32771,3,A_BodyParts,S_SUB_DIE5,0,0},
  {SPR_MDTH,32772,3,A_BodyParts,S_SUB_DIE6,0,0},
  {SPR_MDTH,32773,3,A_BodyParts,S_SUB_DIE7,0,0},
  {SPR_MDTH,32774,3,A_BodyParts,S_SUB_DIE8,0,0},
  {SPR_MDTH,32775,3,A_BodyParts,S_SUB_DIE9,0,0},
  {SPR_MDTH,32776,3,A_BodyParts,S_SUB_DIE10,0,0},
  {SPR_MDTH,32777,3,A_BodyParts,S_SUB_DIE11,0,0},
  {SPR_MDTH,32778,3,A_BodyParts,S_SUB_DIE12,0,0},
  {SPR_MDTH,32779,3,A_BodyParts,S_SUB_DIE13,0,0},
  {SPR_MDTH,32780,3,A_BodyParts,S_SUB_DIE14,0,0},
  {SPR_MDTH,32781,3,A_BodyParts,S_SUB_DIE15,0,0},
  {SPR_MDTH,32782,3,A_ActorSpecialEvent,S_NULL,0,0},

  //Ore
  {SPR_XPRK,0,-1,NULL,S_NULL,0,0},
  {SPR_XPRK,0,1,A_DegninExplode,S_MISSILE_X1,0,0},

  //FGuard
  {SPR_TOKN,0,-1,NULL,S_NULL,0,0},
  {SPR_XPRK,0,1,A_DegninExplode,S_NULL,0,0},

  //Gate
  {SPR_PSTN,0,8,NULL,S_PSTN2,0,0},
  {SPR_PSTN,1,8,NULL,S_PSTN1,0,0},
  //death
  {SPR_PSTN,32768,4,A_Scream,S_PSTN_DTH2,0,0},
  {SPR_PSTN,32769,4,A_Fall,S_PSTN_DTH3,0,0},
  {SPR_PSTN,32770,4,A_QuestUpdate1,S_PSTN_DTH4,0,0},
  {SPR_PSTN,32771,4,A_QuestExplode,S_PSTN_DTH5,0,0},
  {SPR_PSTN,32772,4,A_BodyParts,S_PSTN_DTH6,0,0},
  {SPR_PSTN,32773,4,NULL,S_PSTN_DTH7,0,0},
  {SPR_PSTN,32774,4,A_QuestExplode,S_PSTN_DTH8,0,0},
  {SPR_PSTN,32775,4,NULL,S_PSTN_DTH9,0,0},
  {SPR_PSTN,32776,-1,NULL,S_NULL,0,0},

  //Coupling
  {SPR_COUP,0,5,NULL,S_COUP2,0,0},
  {SPR_COUP,1,5,NULL,S_COUP1,0,0},
  {SPR_COUP,2,-1,NULL,S_NULL,0,0},

  //Computer
  {SPR_SECR,32768,4,NULL,S_SECR_2,0,0},
  {SPR_SECR,32769,4,NULL,S_SECR_3,0,0},
  {SPR_SECR,32770,4,NULL,S_SECR_4,0,0},
  {SPR_SECR,32771,4,NULL,S_SECR_1,0,0},
  //death
  {SPR_SECR,32772,5,A_QuestExplode,S_SECR_6,0,0},
  {SPR_SECR,32773,5,A_Fall,S_SECR_7,0,0},
  {SPR_SECR,32774,5,A_QuestUpdate1,S_SECR_8,0,0},
  {SPR_SECR,32775,5,A_BodyParts,S_SECR_9,0,0},
  {SPR_SECR,32776,5,A_QuestExplode,S_SECR_10,0,0},
  {SPR_SECR,9,5,NULL,S_SECR_11,0,0},
  {SPR_SECR,10,5,A_QuestExplode,S_SECR_12,0,0},
  {SPR_SECR,11,5,NULL,S_SECR_13,0,0},
  {SPR_SECR,12,5,A_QuestExplode,S_SECR_14,0,0},
  {SPR_SECR,13,5,NULL,S_SECR_15,0,0},
  {SPR_SECR,14,5,A_QuestExplode,S_SECR_16,0,0},
  {SPR_SECR,15,-1,NULL,S_NULL,0,0},

  //Shopkeeper
  {SPR_MRYS,0,30,NULL,S_SHOP_7,0,0},

  {SPR_MRNO,0,6,NULL,S_SHOP_3,0,0},
  {SPR_MRNO,1,6,NULL,S_SHOP_4,0,0},
  {SPR_MRNO,2,10,NULL,S_SHOP_5,0,0},
  {SPR_MRNO,1,6,NULL,S_SHOP_6,0,0},
  {SPR_MRNO,0,6,NULL,S_SHOP_7,0,0},

  {SPR_MRST,0,10,A_Stand,S_SHOP_7,0,0},

  {SPR_MRLK,0,30,A_BackSound,S_SHOP_7,0,0},
  {SPR_MRLK,1,30,NULL,S_SHOP_7,0,0},

  {SPR_MRBD,0,4,NULL,S_SHOP_11,0,0},
  {SPR_MRBD,1,4,NULL,S_SHOP_12,0,0},
  {SPR_MRBD,2,4,NULL,S_SHOP_13,0,0},
  {SPR_MRBD,3,4,NULL,S_SHOP_14,0,0},
  {SPR_MRBD,4,4,NULL,S_SHOP_15,0,0},
  {SPR_MRBD,3,4,NULL,S_SHOP_16,0,0},
  {SPR_MRBD,2,4,NULL,S_SHOP_17,0,0},
  {SPR_MRBD,1,4,NULL,S_SHOP_18,0,0},
  {SPR_MRBD,0,5,NULL,S_SHOP_19,0,0},
  {SPR_MRBD,5,6,NULL,S_SHOP_7,0,0},

  {SPR_MRPN,0,3,NULL,S_SHOP_21,0,0},
  {SPR_MRPN,1,3,NULL,S_SHOP_22,0,0},
  {SPR_MRPN,2,3,A_Pain,S_SHOP_23,0,0},
  {SPR_MRPN,3,9,NULL,S_SHOP_24,0,0},
  {SPR_MRPN,2,4,A_CloseShop,S_SHOP_25,0,0},
  {SPR_MRPN,1,3,NULL,S_SHOP_26,0,0},
  {SPR_MRPN,0,3,A_ClearSoundTarget,S_SHOP_7,0,0},

  {SPR_MRGT,0,5,NULL,S_SHOP_28,0,0},
  {SPR_MRGT,1,5,NULL,S_SHOP_29,0,0},
  {SPR_MRGT,2,5,NULL,S_SHOP_30,0,0},
  {SPR_MRGT,3,5,NULL,S_SHOP_31,0,0},
  {SPR_MRGT,4,5,NULL,S_SHOP_32,0,0},
  {SPR_MRGT,5,5,NULL,S_SHOP_33,0,0},
  {SPR_MRGT,6,5,NULL,S_SHOP_34,0,0},
  {SPR_MRGT,7,5,NULL,S_SHOP_35,0,0},
  {SPR_MRGT,8,5,NULL,S_SHOP_7,0,0},

  //Misc/Tokens
  {SPR_RING,0,-1,NULL,S_NULL,0,0},
  {SPR_EARS,0,-1,NULL,S_NULL,0,0},
  {SPR_HELT,0,-1,NULL,S_NULL,0,0},
  {SPR_GUNT,0,-1,NULL,S_NULL,0,0},
  {SPR_OTOK,0,-1,NULL,S_NULL,0,0},
  {SPR_BFLM,0,-1,NULL,S_NULL,0,0},

  //Power Crystal
  {SPR_CRYS,0,16,A_BackSound,S_CRYS_2,0,0},
  {SPR_CRYS,1,5,A_BackSound,S_CRYS_3,0,0},
  {SPR_CRYS,2,4,A_BackSound,S_CRYS_4,0,0},
  {SPR_CRYS,3,4,A_BackSound,S_CRYS_5,0,0},
  {SPR_CRYS,4,4,A_BackSound,S_CRYS_6,0,0},
  {SPR_CRYS,5,4,A_BackSound,S_CRYS_1,0,0},

  //Crystal Death
  {SPR_BOOM,32768,1,A_CrystalChuck,S_BOOM_2,0,0},
  {SPR_BOOM,32769,3,A_QuestUpdate1,S_BOOM_3,0,0},
  {SPR_BOOM,32770,2,A_CrystalExplode,S_BOOM_4,0,0},
  {SPR_BOOM,32771,3,A_QuestExplode,S_BOOM_5,0,0},
  {SPR_BOOM,32772,3,NULL,S_BOOM_6,0,0},
  {SPR_BOOM,32773,3,NULL,S_BOOM_7,0,0},
  {SPR_BOOM,32774,3,A_QuestExplode,S_BOOM_8,0,0},
  {SPR_BOOM,32775,1,A_CrystalChuck,S_BOOM_9,0,0},
  {SPR_BOOM,32776,3,NULL,S_BOOM_10,0,0},
  {SPR_BOOM,32777,3,A_QuestExplode,S_BOOM_11,0,0},
  {SPR_BOOM,32778,3,A_QuestExplode,S_BOOM_12,0,0},
  {SPR_BOOM,32779,3,A_QuestExplode,S_BOOM_13,0,0},
  {SPR_BOOM,32780,3,NULL,S_BOOM_14,0,0},
  {SPR_BOOM,32781,3,NULL,S_BOOM_15,0,0},
  {SPR_BOOM,32782,3,A_QuestExplode,S_BOOM_16,0,0},
  {SPR_BOOM,32783,3,NULL,S_BOOM_17,0,0},
  {SPR_BOOM,32784,3,NULL,S_BOOM_18,0,0},
  {SPR_BOOM,32785,3,NULL,S_BOOM_19,0,0},
  {SPR_BOOM,32786,3,NULL,S_BOOM_20,0,0},
  {SPR_BOOM,32787,3,NULL,S_BOOM_21,0,0},
  {SPR_BOOM,32788,3,NULL,S_BOOM_22,0,0},//Unknown for now..
  {SPR_BOOM,32789,3,NULL,S_BOOM_23,0,0},
  {SPR_BOOM,32790,3,NULL,S_BOOM_24,0,0},
  {SPR_BOOM,32791,3,NULL,S_BOOM_25,0,0},
  {SPR_BOOM,32792,3,NULL,S_NULL,0,0},

  {SPR_TFOG,32768,6,NULL,S_TFOG2,0,0}, // S_TFOG
  {SPR_TFOG,32769,6,NULL,S_TFOG02,0,0}, // S_TFOG01
  {SPR_TFOG,32769,6,NULL,S_TFOG2,0,0},  // S_TFOG02
  {SPR_TFOG,32769,6,NULL,S_TFOG3,0,0},  // S_TFOG2
  {SPR_TFOG,32770,6,NULL,S_TFOG4,0,0},  // S_TFOG3
  {SPR_TFOG,32771,6,NULL,S_TFOG5,0,0},  // S_TFOG4
  {SPR_TFOG,32772,6,NULL,S_TFOG6,0,0},  // S_TFOG5
  {SPR_TFOG,32773,6,NULL,S_TFOG7,0,0},  // S_TFOG6
  {SPR_TFOG,32772,6,NULL,S_TFOG8,0,0},  // S_TFOG7
  {SPR_TFOG,32770,6,NULL,S_TFOG9,0,0},  // S_TFOG8
  {SPR_TFOG,32769,6,NULL,S_TFOG10,0,0}, // S_TFOG9
  {SPR_TFOG,32768,6,NULL,S_NULL,0,0}, // S_TFOG10
  {SPR_IFOG,32768,6,NULL,S_IFOG01,0,0}, // S_IFOG
  {SPR_IFOG,32769,6,NULL,S_IFOG02,0,0}, // S_IFOG01
  {SPR_IFOG,32768,6,NULL,S_IFOG2,0,0},  // S_IFOG02
  {SPR_IFOG,32769,6,NULL,S_IFOG3,0,0},  // S_IFOG2
  {SPR_IFOG,32770,6,NULL,S_IFOG4,0,0},  // S_IFOG3
  {SPR_IFOG,32771,6,NULL,S_IFOG5,0,0},  // S_IFOG4
  {SPR_IFOG,32772,6,NULL,S_NULL,0,0}, // S_IFOG5

  {SPR_PLAY,0,-1,NULL,S_NULL,0,0},  // S_PLAY
  {SPR_PLAY,0,4,NULL,S_PLAY_RUN2,0,0},  // S_PLAY_RUN1
  {SPR_PLAY,1,4,NULL,S_PLAY_RUN3,0,0},  // S_PLAY_RUN2
  {SPR_PLAY,2,4,NULL,S_PLAY_RUN4,0,0},  // S_PLAY_RUN3
  {SPR_PLAY,3,4,NULL,S_PLAY_RUN1,0,0},  // S_PLAY_RUN4
  {SPR_PLAY,4,12,NULL,S_PLAY,0,0},  // S_PLAY_ATK1
  {SPR_PLAY,32773,6,NULL,S_PLAY_ATK1,0,0},  // S_PLAY_ATK2
  {SPR_PLAY,16,4,NULL,S_PLAY_PAIN2,0,0}, // S_PLAY_PAIN
  {SPR_PLAY,16,4,A_Pain,S_PLAY,0,0}, // S_PLAY_PAIN2
  {SPR_PLAY,6,10,NULL,S_PLAY_DIE2,0,0}, // S_PLAY_DIE1
  {SPR_PLAY,7,5,A_PlayerScream,S_PLAY_DIE3,0,0}, // S_PLAY_DIE2
  {SPR_PLAY,8,5,A_Fall,S_PLAY_DIE4,0,0}, // S_PLAY_DIE3
  {SPR_PLAY,9,5,NULL,S_PLAY_DIE5,0,0},  // S_PLAY_DIE4
  {SPR_PLAY,10,5,NULL,S_PLAY_DIE6,0,0},  // S_PLAY_DIE5
  {SPR_PLAY,11,5,NULL,S_PLAY_DIE7,0,0},  // S_PLAY_DIE6
  {SPR_PLAY,12,5,NULL,S_PLAY_DIE8,0,0}, // S_PLAY_DIE7
  {SPR_PLAY,13,5,NULL,S_PLAY_DIE9,0,0}, // S_PLAY_DIE8
  {SPR_PLAY,14,5,NULL,S_PLAY_DIE10,0,0}, // S_PLAY_DIE9
  {SPR_PLAY,15,-1,NULL,S_NULL,0,0}, // S_PLAY_DIE10
  {SPR_RGIB,0,5,NULL,S_PLAY_XDIE2,0,0},  // S_PLAY_XDIE1
  {SPR_RGIB,1,5,A_XScream,S_PLAY_XDIE3,0,0}, // S_PLAY_XDIE2
  {SPR_RGIB,2,5,A_Fall,S_PLAY_XDIE4,0,0},  // S_PLAY_XDIE3
  {SPR_RGIB,3,5,NULL,S_PLAY_XDIE5,0,0},  // S_PLAY_XDIE4
  {SPR_RGIB,4,5,NULL,S_PLAY_XDIE6,0,0},  // S_PLAY_XDIE5
  {SPR_RGIB,5,5,NULL,S_PLAY_XDIE7,0,0},  // S_PLAY_XDIE6
  {SPR_RGIB,6,5,NULL,S_PLAY_XDIE8,0,0},  // S_PLAY_XDIE7
  {SPR_RGIB,7,-1,NULL,S_NULL,0,0}, // S_PLAY_XDIE8

  {SPR_DEAD,0,-1,NULL,S_NULL,0,0},

  {SPR_TNT1,0,-1,NULL,S_TNT1,0,0},          // S_TNT1    // phares 3/8/98

  // killough 8/9/98: grenade
  {SPR_MISL,32768,1000,A_Die,S_GRENADE},      // S_GRENADE

  // killough 8/10/98: variable damage explosion
  {SPR_MISL,32769,4,A_Scream,S_DETONATE2},    // S_DETONATE
  {SPR_MISL,32770,6,A_Detonate,S_DETONATE3},  // S_DETONATE2
  {SPR_MISL,32771,10,NULL,S_NULL},            // S_DETONATE3
  {SPR_MISL,32769,8,A_Mushroom,S_MISSILE_X1},  // S_MUSHROOM

  
};

// ********************************************************************
// Object "Thing" definitions
// ********************************************************************
// Now we get to the actual objects and their characteristics.  If
// you've seen Dehacked, much of this is where the Bits are set,
// commented below as "flags", as well as where you wire in which
// frames are the beginning frames for near and far attack, death,
// and such.  Sounds are hooked in here too, as well as how much
// mass, speed and so forth a Thing has.  Everything you ever wanted
// to know...
//
// Like all this other stuff, the MT_* entries are enumerated in info.h
//
// Note that these are all just indices of the elements involved, and
// not real pointers to them.  For example, the player's death sequence
// is S_PLAY_DIE1, which just evaluates to the index in the states[]
// array above, which actually knows what happens then and what the
// sprite looks like, if it makes noise or not, etc.
//
// Additional comments about each of the entries are located in info.h
// next to the mobjinfo_t structure definition.
//
// This goes on for the next 3000+ lines...

mobjinfo_t mobjinfo[NUMMOBJTYPES] = {

	{	0, 10, // MT_FIELDGUARD
    25,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_TOKN_GUARD2,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SHOOTABLE|MF_NOSECTOR|MF_NOALERT,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_PLAYER
    -1,   // doomednum
    S_PLAY,   // spawnstate
    100,    // spawnhealth
    S_PLAY_RUN1,    // seestate
    sfx_None,   // seesound
    0,    // reactiontime
    sfx_None,   // attacksound
    S_PLAY_PAIN,    // painstate
    255,    // painchance
    sfx_plpain,   // painsound
    S_NULL,   // meleestate
    S_PLAY_ATK1,    // missilestate
    S_PLAY_DIE1,    // deathstate
    S_PLAY_XDIE1,   // xdeathstate
    sfx_pldeth,   // deathsound
    0,    // speed
    18*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_DROPOFF|MF_NOTDMATCH,    // flags
    S_NULL    // crashstate
  },

  {	MC_WEAPONSMITH, 10, // MT_SHOPKEEPER_W
    116,   // doomednum
    S_SHOP_7,   // spawnstate
    10000000,   // spawnhealth
    S_SHOP_20,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_SHOP_20,   // painstate
    150,    // painchance
    sfx_pespna,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    5000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_NOTDMATCH|MF_PEASANT,   // flags
    S_NULL    // crashstate
  },

  {	MC_BARKEEP, 10, // MT_SHOPKEEPER_B
    72,   // doomednum
    S_SHOP_7,   // spawnstate
    10000000,   // spawnhealth
    S_SHOP_20,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_SHOP_20,   // painstate
    150,    // painchance
    sfx_ambbar,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    5000,    // mass
    0,    // damage
    sfx_ambppl,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_NOTDMATCH|MTF_SWAP2|MF_PEASANT,   // flags
    S_NULL    // crashstate
  },

  {	MC_ARMORER, 10, // MT_SHOPKEEPER_A
    73,   // doomednum
    S_SHOP_7,   // spawnstate
    10000000,   // spawnhealth
    S_SHOP_20,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_SHOP_20,   // painstate
    150,    // painchance
    sfx_pespna,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    5000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_NOTDMATCH|MTF_SWAP3|MF_PEASANT,   // flags
    S_NULL    // crashstate
  },

  {	MC_MEDIC, 10, // MT_SHOPKEEPER_M
    74,   // doomednum
    S_SHOP_7,   // spawnstate
    10000000,   // spawnhealth
    S_SHOP_20,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_SHOP_20,   // painstate
    150,    // painchance
    sfx_pespna,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    5000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_NOTDMATCH|MTF_SWAP4|MF_PEASANT,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_PEASANT2_A		
    3004,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    4,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_PEASANT2_B		
    130,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    5,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_PEASANT2_C		
    131,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    5,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_PEASANT5_A		
    65,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_TRANSLATION1|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_PEASANT5_B		
    132,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    7,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_TRANSLATION1|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_PEASANT5_C		
    133,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_TRANSLATION1|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_PEASANT4_A		
    66,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MTF_SWAP1|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_PEASANT4_B		
    134,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MTF_SWAP1|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_PEASANT4_C		
    135,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MTF_SWAP1|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_PEASANT6_A		
    67,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_TRANSLATION2|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_PEASANT6_B		
    136,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_TRANSLATION2|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_PEASANT6_C		
    137,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_TRANSLATION2|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_PEASANT3_A		
    172,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    7,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_TRANSLATION|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_PEASANT3_B		
    173,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    7,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_TRANSLATION|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_PEASANT3_C		
    174,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    7,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_TRANSLATION|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_PEASANT8_A		
    175,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MTF_SWAP3|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_PEASANT8_B		
    176,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MTF_SWAP3|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_PEASANT8_C		
    177,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MTF_SWAP3|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_PEASANT7_A		
    178,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MTF_SWAP2|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_PEASANT7_B		
    179,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MTF_SWAP2|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_PEASANT7_C		
    180,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MTF_SWAP2|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_PEASANT1		
    181,   // doomednum
    S_PEAS_STND,    // spawnstate
    31,   // spawnhealth
    S_PEAS_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_PEAS_PAIN,    // painstate
    200,    // painchance
    sfx_pespna,   // painsound
    S_PEAS_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_DIE1,    // deathstate
    S_PEAS_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MTF_SWAP4|MF_PEASANT,   // flags
    S_PEAS_CDIE1   // crashstate
  },

  {	0, 10, // MT_ZOMBIE		
    169,   // doomednum
    S_ZMBE_STND,    // spawnstate
    31,   // spawnhealth
    S_NULL,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_ZMBE_PAIN,    // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,    // meleestate
    S_NULL,    // missilestate
    S_PEAS_XDIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_psdtha,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_TRANSLATION1,   // flags
    S_NULL   // crashstate
  },

{	0, 10, // MT_BECOMING	
    201,   // doomednum
    S_BECOMING_1,    // spawnstate
    61,   // spawnhealth
    S_NULL,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_BECOMING_2,    // painstate
    255,    // painchance
    sfx_None,   // painsound
    0,    // meleestate
    S_NULL,    // missilestate
    S_AGRD_XDIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    7,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    99999,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_NULL   // crashstate
  },

{	0, 10, // MT_ZOMBIESPAWNER		
    170,   // doomednum
    S_ZMBES_STND,    // spawnstate
    20,   // spawnhealth
    S_NULL,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,    // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,    // meleestate
    S_NULL,    // missilestate
    S_NULL,    // deathstate
    S_NULL,   // xdeathstate
    sfx_telept,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SHOOTABLE|MF_NOSECTOR,   // flags
    S_NULL   // crashstate
  },

  {	0, 10, // MT_HUGE_TANK_1	
    209,   // doomednum
    S_BIO3_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_HUGE_TANK_2	
    210,   // doomednum
    S_BIO4_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_HUGE_TANK_3	
    211,   // doomednum
    S_BIO5_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_TANK_4	
    213,   // doomednum
    S_BIO6_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_TANK_5	
    214,   // doomednum
    S_BIO7_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_TANK_6	
    229,   // doomednum
    S_BIO8_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_KNEELINGGUY
    204,   // doomednum
    S_MISC_16_1,   // spawnstate
    51,   // spawnhealth
    S_MISC_16_SEE1,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_MISC_16_PAIN1,   // painstate
    255,    // painchance
    sfx_static,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_MISC_16_DTH1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_static,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    99999,    // mass
    0,    // damage
    sfx_chant,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_NOBLOOD|MF_NOALERT,   // flags
    S_NULL    // crashstate
  },

{	MC_BEGGAR, 10, // MT_BEGGAR1		
    141,   // doomednum
    S_BEGR_STND,    // spawnstate
    20,   // spawnhealth
    S_BEGR_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_BEGR_PAIN,    // painstate
    250,    // painchance
    sfx_pespna,   // painsound
    S_BEGR_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_BEGR_DIE1,    // deathstate
    S_BEGR_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    3,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_PEASANT,   // flags
    S_NULL   // crashstate
  },

  {	MC_BEGGAR, 10, // MT_BEGGAR2		
    155,   // doomednum
    S_BEGR_STND,    // spawnstate
    20,   // spawnhealth
    S_BEGR_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_BEGR_PAIN,    // painstate
    250,    // painchance
    sfx_pespna,   // painsound
    S_BEGR_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_BEGR_DIE1,    // deathstate
    S_BEGR_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    3,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_PEASANT,   // flags
    S_NULL   // crashstate
  },

  {	MC_BEGGAR, 10, // MT_BEGGAR3		
    156,   // doomednum
    S_BEGR_STND,    // spawnstate
    20,   // spawnhealth
    S_BEGR_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_BEGR_PAIN,    // painstate
    250,    // painchance
    sfx_pespna,   // painsound
    S_BEGR_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_BEGR_DIE1,    // deathstate
    S_BEGR_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    3,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_PEASANT,   // flags
    S_NULL   // crashstate
  },

  {	MC_BEGGAR, 10, // MT_BEGGAR4		
    157,   // doomednum
    S_BEGR_STND,    // spawnstate
    20,   // spawnhealth
    S_BEGR_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_BEGR_PAIN,    // painstate
    250,    // painchance
    sfx_pespna,   // painsound
    S_BEGR_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_BEGR_DIE1,    // deathstate
    S_BEGR_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    3,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_PEASANT,   // flags
    S_NULL   // crashstate
  },

  {	MC_BEGGAR, 10, // MT_BEGGAR5	
    158,   // doomednum
    S_BEGR_STND,    // spawnstate
    20,   // spawnhealth
    S_BEGR_WALK1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_meatht,   // attacksound
    S_BEGR_PAIN,    // painstate
    250,    // painchance
    sfx_pespna,   // painsound
    S_BEGR_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_BEGR_DIE1,    // deathstate
    S_BEGR_XDIE1,   // xdeathstate
    sfx_psdtha,   // deathsound
    3,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_PEASANT,   // flags
    S_NULL   // crashstate
  },

{	MC_REBEL, 10, // MT_REBEL1	
    9,   // doomednum
    S_HMN1_STND,    // spawnstate
    60,   // spawnhealth
    S_HMN1_RUN1,    // seestate
    sfx_wpnup,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_HMN1_PAIN1,    // painstate
    250,    // painchance
    sfx_pespna,   // painsound
    0,    // meleestate
    S_HMN1_ATK1,    // missilestate
    S_HMN1_DTH1,    // deathstate
    S_HMN1_DTH9,   // xdeathstate
    sfx_rebdth,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_rebact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_FRIEND,   // flags
    S_NULL   // crashstate
  },

  {	MC_REBEL, 10, // MT_REBEL2	
    144,   // doomednum
    S_HMN1_STND,    // spawnstate
    60,   // spawnhealth
    S_HMN1_RUN1,    // seestate
    sfx_wpnup,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_HMN1_PAIN1,    // painstate
    250,    // painchance
    sfx_pespna,   // painsound
    0,    // meleestate
    S_HMN1_ATK1,    // missilestate
    S_HMN1_DTH1,    // deathstate
    S_HMN1_DTH9,   // xdeathstate
    sfx_rebdth,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_rebact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_FRIEND,   // flags
    S_NULL   // crashstate
  },

  {	MC_REBEL, 10, // MT_REBEL3	
    145,   // doomednum
    S_HMN1_STND,    // spawnstate
    60,   // spawnhealth
    S_HMN1_RUN1,    // seestate
    sfx_wpnup,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_HMN1_PAIN1,    // painstate
    250,    // painchance
    sfx_pespna,   // painsound
    0,    // meleestate
    S_HMN1_ATK1,    // missilestate
    S_HMN1_DTH1,    // deathstate
    S_HMN1_DTH9,   // xdeathstate
    sfx_rebdth,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_rebact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_FRIEND,   // flags
    S_NULL   // crashstate
  },

  {	MC_REBEL, 10, // MT_REBEL4	
    149,   // doomednum
    S_HMN1_STND,    // spawnstate
    60,   // spawnhealth
    S_HMN1_RUN1,    // seestate
    sfx_wpnup,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_HMN1_PAIN1,    // painstate
    250,    // painchance
    sfx_pespna,   // painsound
    0,    // meleestate
    S_HMN1_ATK1,    // missilestate
    S_HMN1_DTH1,    // deathstate
    S_HMN1_DTH9,   // xdeathstate
    sfx_rebdth,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_rebact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_FRIEND,   // flags
    S_NULL   // crashstate
  },

  {	MC_REBEL, 10, // MT_REBEL5
    150,   // doomednum
    S_HMN1_STND,    // spawnstate
    60,   // spawnhealth
    S_HMN1_RUN1,    // seestate
    sfx_wpnup,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_HMN1_PAIN1,    // painstate
    250,    // painchance
    sfx_pespna,   // painsound
    0,    // meleestate
    S_HMN1_ATK1,    // missilestate
    S_HMN1_DTH1,    // deathstate
    S_HMN1_DTH9,   // xdeathstate
    sfx_rebdth,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_rebact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_FRIEND,   // flags
    S_NULL   // crashstate
  },

  {	MC_REBEL, 10, // MT_REBEL6
    151,   // doomednum
    S_HMN1_STND,    // spawnstate
    60,   // spawnhealth
    S_HMN1_RUN1,    // seestate
    sfx_wpnup,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_HMN1_PAIN1,    // painstate
    250,    // painchance
    sfx_pespna,   // painsound
    0,    // meleestate
    S_HMN1_ATK1,    // missilestate
    S_HMN1_DTH1,    // deathstate
    S_HMN1_DTH9,   // xdeathstate
    sfx_rebdth,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_rebact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_FRIEND,   // flags
    S_NULL   // crashstate
  },

{	MC_MACIL, 10, // MT_RLEADER	
    64,   // doomednum
    S_LEDR_STND,    // spawnstate
    95,   // spawnhealth
    S_LEDR_RUN1,    // seestate
    sfx_agrsee,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_LEDR_PAIN1,    // painstate
    150,    // painchance
    sfx_pespna,   // painsound
    0,    // meleestate
    S_LEDR_ATK1,    // missilestate
    S_LEDR_RUN1,    // deathstate
    0,   // xdeathstate
    sfx_None,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_rebact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_NOTDMATCH,   // flags
    S_NULL   // crashstate
  },

  {	MC_MACIL, 10, // MT_RLEADER2	
    200,   // doomednum
    S_LEDR_STND,    // spawnstate
    95,   // spawnhealth
    S_LEDR_RUN1,    // seestate
    sfx_agrsee,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_LEDR_PAIN1,    // painstate
    150,    // painchance
    sfx_pespna,   // painsound
    0,    // meleestate
    S_LEDR_2ATK1,    // missilestate
    S_LEDR_DTH1,    // deathstate
    0,   // xdeathstate
    sfx_slop,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_rebact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_NOTDMATCH|MF_GHOST,   // flags
    S_NULL   // crashstate
  },

  {	0, 10, // MT_MISSILESMOKE
    -1,   // doomednum
    S_PUFY2,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_rflite,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // crashstate
  },

{	0, 10, // MT_REAVER		
    3001,   // doomednum
    S_ROB1_STND,    // spawnstate
    150,   // spawnhealth
    S_ROB1_RUN1,    // seestate
    sfx_revsee,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_ROB1_PAIN,    // painstate
    128,    // painchance
    sfx_reavpn,   // painsound
    S_ROB1_MATK1,    // meleestate
    S_ROB1_ATK1,    // missilestate
    S_ROB1_DIE1,    // deathstate
    S_ROB1_XDIE1,   // xdeathstate
    sfx_revdth,   // deathsound
    12,    // speed
    20*FRACUNIT,    // radius
    60*FRACUNIT,    // height
    500,    // mass
    0,    // damage
    sfx_revact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_NOBLOOD|MF_NOALERT,   // flags
    S_NULL   // crashstate
  },

{	MC_ACOLYTE, 10, // MT_GUARD1		//54	
    3002,   // doomednum
    S_AGRD_STND,    // spawnstate
    70,   // spawnhealth
    S_AGRD_RUN1,    // seestate
    sfx_agrsee,   // seesound
    8,    // reactiontime
    sfx_rifle,   // attacksound
    S_AGRD_PAIN,    // painstate
    150,    // painchance
    sfx_agrdpn,   // painsound
    0,    // meleestate
    S_AGRD_ATK1,    // missilestate
    S_AGRD_DIE1,    // deathstate
    S_AGRD_XDIE1,   // xdeathstate
    sfx_agrdth,   // deathsound
    7,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_agrac1,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_NULL   // crashstate
  },

  {	MC_ACOLYTE, 10, // MT_GUARD2		//54	
    142,   // doomednum
    S_AGRD_STND,    // spawnstate
    70,   // spawnhealth
    S_AGRD_RUN1,    // seestate
    sfx_agrsee,   // seesound
    8,    // reactiontime
    sfx_rifle,   // attacksound
    S_AGRD_PAIN,    // painstate
    150,    // painchance
    sfx_agrdpn,   // painsound
    0,    // meleestate
    S_AGRD_ATK1,    // missilestate
    S_AGRD_DIE1,    // deathstate
    S_AGRD_XDIE1,   // xdeathstate
    sfx_agrdth,   // deathsound
    7,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_agrac2,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_TRANSLATION1,   // flags
    S_NULL   // crashstate
  },

  {	MC_ACOLYTE, 10, // MT_GUARD3		//54	
    143,   // doomednum
    S_AGRD_STND,    // spawnstate
    70,   // spawnhealth
    S_AGRD_RUN1,    // seestate
    sfx_agrsee,   // seesound
    8,    // reactiontime
    sfx_rifle,   // attacksound
    S_AGRD_PAIN,    // painstate
    150,    // painchance
    sfx_agrdpn,   // painsound
    0,    // meleestate
    S_AGRD_ATK1,    // missilestate
    S_AGRD_DIE1,    // deathstate
    S_AGRD_XDIE1,   // xdeathstate
    sfx_agrdth,   // deathsound
    7,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_agrac3,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_TRANSLATION2,   // flags
    S_NULL   // crashstate
  },

  {	MC_ACOLYTE, 10, // MT_GUARD4		//54	
    146,   // doomednum
    S_AGRD_STND,    // spawnstate
    70,   // spawnhealth
    S_AGRD_RUN1,    // seestate
    sfx_agrsee,   // seesound
    8,    // reactiontime
    sfx_rifle,   // attacksound
    S_AGRD_PAIN,    // painstate
    150,    // painchance
    sfx_agrdpn,   // painsound
    0,    // meleestate
    S_AGRD_ATK1,    // missilestate
    S_AGRD_DIE1,    // deathstate
    S_AGRD_XDIE1,   // xdeathstate
    sfx_agrdth,   // deathsound
    7,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_agrac1,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MTF_SWAP1,   // flags
    S_NULL   // crashstate
  },

  {	MC_ACOLYTE, 10, // MT_GUARD5		//54	
    147,   // doomednum
    S_AGRD_STND,    // spawnstate
    70,   // spawnhealth
    S_AGRD_RUN1,    // seestate
    sfx_agrsee,   // seesound
    8,    // reactiontime
    sfx_rifle,   // attacksound
    S_AGRD_PAIN,    // painstate
    150,    // painchance
    sfx_agrdpn,   // painsound
    0,    // meleestate
    S_AGRD_ATK1,    // missilestate
    S_AGRD_DIE1,    // deathstate
    S_AGRD_XDIE1,   // xdeathstate
    sfx_agrdth,   // deathsound
    7,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_agrac2,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_TRANSLATION,   // flags
    S_NULL   // crashstate
  },

  {	MC_ACOLYTE, 10, // MT_GUARD6		//54	
    148,   // doomednum
    S_AGRD_STND,    // spawnstate
    70,   // spawnhealth
    S_AGRD_RUN1,    // seestate
    sfx_agrsee,   // seesound
    8,    // reactiontime
    sfx_rifle,   // attacksound
    S_AGRD_PAIN,    // painstate
    150,    // painchance
    sfx_agrdpn,   // painsound
    0,    // meleestate
    S_AGRD_ATK1,    // missilestate
    S_AGRD_DIE1,    // deathstate
    S_AGRD_XDIE1,   // xdeathstate
    sfx_agrdth,   // deathsound
    7,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_agrac3,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MTF_SWAP2,   // flags
    S_NULL   // crashstate
  },

  {	MC_ACOLYTE, 10, // MT_GUARD7		//54	
    232,   // doomednum
    S_AGRD_STND,    // spawnstate
    60,   // spawnhealth
    S_AGRD_RUN1,    // seestate
    sfx_agrsee,   // seesound
    8,    // reactiontime
    sfx_rifle,   // attacksound
    S_AGRD_PAIN,    // painstate
    150,    // painchance
    sfx_agrdpn,   // painsound
    0,    // meleestate
    S_AGRD_ATK1,    // missilestate
    S_AGRD_DIE1,    // deathstate
    S_AGRD_XDIE1,   // xdeathstate
    sfx_agrdth,   // deathsound
    7,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_agrac3,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MTF_SWAP3,   // flags
    S_NULL   // crashstate
  },

  {	MC_ACOLYTE, 10, // MT_GUARD8		//54	
    231,   // doomednum
    S_AGRD_STND,    // spawnstate
    60,   // spawnhealth
    S_AGRD_RUN1,    // seestate
    sfx_agrsee,   // seesound
    8,    // reactiontime
    sfx_rifle,   // attacksound
    S_AGRD_PAIN,    // painstate
    150,    // painchance
    sfx_agrdpn,   // painsound
    0,    // meleestate
    S_AGRD_ATK1,    // missilestate
    S_AGRD_DIE1,    // deathstate
    S_AGRD_XDIE1,   // xdeathstate
    sfx_agrdth,   // deathsound
    7,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_agrac3,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MTF_SWAP4,   // flags
    S_NULL   // crashstate
  },

  {	MC_ACOLYTE, 10, // MT_SHADOWGUARD		//54	
    58,   // doomednum
    S_AGRD_STND,    // spawnstate
    70,   // spawnhealth
    S_SAGRD_RUN1,    // seestate
    sfx_agrsee,   // seesound
    8,    // reactiontime
    sfx_rifle,   // attacksound
    S_SAGRD_PAIN,    // painstate
    150,    // painchance
    sfx_agrdpn,   // painsound
    0,    // meleestate
    S_AGRD_ATK1,    // missilestate
    S_AGRD_DIE1,    // deathstate
    S_AGRD_XDIE1,   // xdeathstate
    sfx_agrdth,   // deathsound
    7,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_agrac2,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_NULL   // crashstate
  },

{	MC_TEMPLAR, 10, // MT_PGUARD		
    3003,   // doomednum
    S_PGRD_STND,    // spawnstate
    300,   // spawnhealth
    S_PGRD_RUN1,    // seestate
    sfx_pgrsee,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_PGRD_PAIN,    // painstate
    100,    // painchance
    sfx_pgrdpn,   // painsound
    S_PGRD_ATK1,    // meleestate
    S_PGRD_MATK1,    // missilestate
    S_PGRD_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_pgrdth,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    60*FRACUNIT,    // height
    500,    // mass
    0,    // damage
    sfx_pgract,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_NOBLOOD,   // flags
    S_NULL   // crashstate
  },

  {	0, 10, // MT_CRUSADER		
    3005,   // doomednum
    S_ROB2_STND,    // spawnstate
    400,   // spawnhealth
    S_ROB2_RUN1,    // seestate
    sfx_rb2see,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_ROB2_PAIN,    // painstate
    128,    // painchance
    sfx_rb2pn,   // painsound
    S_NULL,    // meleestate
    S_ROB2_ATK1,    // missilestate
    S_ROB2_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_rb2dth,   // deathsound
    8,    // speed
    40*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_rb2act,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_NOBLOOD|MF_NOALERT,   // flags
    S_NULL   // crashstate
  },

{	0, 10, // MT_BISHOP	
    187,   // doomednum
    S_MLDR_STND,    // spawnstate
    500,   // spawnhealth
    S_MLDR_RUN1,    // seestate
    sfx_rb2see,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_MLDR_PAIN,    // painstate
    128,    // painchance
    sfx_rb2pn,   // painsound
    0,    // meleestate
    S_MLDR_ATK1,    // missilestate
    S_MLDR_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_pgrdth,   // deathsound
    8,    // speed
    40*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    500,    // mass
    0,    // damage
    sfx_rb2act,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_NOBLOOD|MF_NOTDMATCH|MF_NOALERT,   // flags
    S_NULL   // crashstate
  },

{	MC_ORACLE, 10, // MT_ORACLE
    199,   // doomednum
    S_ORACLE_1,   // spawnstate
    1,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_ORACLE_2,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    15*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_NOBLOOD|MF_COUNTKILL|MF_NOTDMATCH,   // flags
    S_NULL    // crashstate
  },

{	MC_PRIEST, 10, // MT_PRIEST		
    12,   // doomednum
    S_PRST_STND,    // spawnstate
    800,   // spawnhealth
    S_PRST_RUN1,    // seestate
    sfx_lorsee,   // seesound
    8,    // reactiontime
    sfx_revbld,   // attacksound
    S_PRST_RUN1,    // painstate
    50,    // painchance
    sfx_lorpn,   // painsound
    S_PRST_MEL1,    // meleestate
    S_PRST_ATK1,    // missilestate
    S_PRST_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_slop,   // deathsound
    10,    // speed
    15*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_tend,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_NOBLOOD|MF_NOGRAVITY|MF_FLOAT|MF_NOTDMATCH
	|MF_NOALERT|MF_GIVEQUEST|MF_BOSS,   // flags
    S_NULL   // crashstate
  },

{	0, 10, // MT_SPECTURE_A		
    129,   // doomednum
    S_ALN1_STND,    // spawnstate
    1000,   // spawnhealth
    S_ALN1_RUN1,    // seestate
    sfx_alnsee,   // seesound
    8,    // reactiontime
    sfx_revbld,   // attacksound
    S_ALN1_PAIN,    // painstate
    250,    // painchance
    sfx_alnpn,   // painsound
    S_ALN1_MEL1,    // meleestate
    S_ALN1_ATK1,    // missilestate
    S_ALN1_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_alndth,   // deathsound
    12,    // speed
    64*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    1000,    // mass
    0,    // damage
    sfx_alnact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_NOBLOOD|MF_NOGRAVITY|MF_FLOAT|MF_NOTDMATCH|
	MF_BOSS|MF_GHOST|MF_TRANSLUCENT|MF_NOALERT|MF_GIVEQUEST,   // flags
    S_NULL   // crashstate
  },

  {	0, 10, // MT_NODE
    -1,   // doomednum
    S_NODE1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOCLIP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_SPECTUREHEAD
    -1,   // doomednum
    S_MTHD1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOCLIP,   // flags
    S_NULL    // crashstate
  },

{	0, 10, // MT_SPECTURE_B		
    75,   // doomednum
    S_ALN1_STND,    // spawnstate
    1200,   // spawnhealth
    S_ALN1_RUN1,    // seestate
    sfx_alnsee,   // seesound
    8,    // reactiontime
    sfx_revbld,   // attacksound
    S_ALN1_PAIN,    // painstate
    50,    // painchance
    sfx_alnpn,   // painsound
    S_ALN1_MEL1,    // meleestate
    S_ALN1_2_ATK1,    // missilestate
    S_ALN1_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_alndth,   // deathsound
    21,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    1000,    // mass
    0,    // damage
    sfx_alnact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_NOBLOOD|MF_NOGRAVITY|MF_FLOAT|MF_NOTDMATCH|
	MF_BOSS|MF_GHOST|MF_TRANSLUCENT|MF_NOALERT|MF_GIVEQUEST,   // flags
    S_NULL   // crashstate
  },

{	0, 10, // MT_SPECTURE_C		
    76,   // doomednum
    S_ALN3_STND,    // spawnstate
    1500,   // spawnhealth
    S_ALN3_RUN1,    // seestate
    sfx_alnsee,   // seesound
    8,    // reactiontime
    sfx_revbld,   // attacksound
    S_ALN3_PAIN,    // painstate
    50,    // painchance
    sfx_alnpn,   // painsound
    S_ALN3_MEL1,    // meleestate
    S_ALN3_ATK1,    // missilestate
    S_ALN1_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_alndth,   // deathsound
    23,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    1000,    // mass
    0,    // damage
    sfx_alnact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_NOBLOOD|MF_NOGRAVITY|MF_FLOAT|MF_NOTDMATCH|
	MF_BOSS|MF_GHOST|MF_TRANSLUCENT|MF_NOALERT|MF_GIVEQUEST,   // flags
    S_NULL   // crashstate
  },

{	0, 10, // MT_SPECTURE_D		
    167,   // doomednum
    S_ALN1_STND,    // spawnstate
    1700,   // spawnhealth
    S_ALN1_RUN1,    // seestate
    sfx_alnsee,   // seesound
    8,    // reactiontime
    sfx_revbld,   // attacksound
    S_ALN1_PAIN,    // painstate
    50,    // painchance
    sfx_alnpn,   // painsound
    S_ALN1_MEL1,    // meleestate
    S_ALN4_ATK1,    // missilestate
    S_ALN1_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_alndth,   // deathsound
    24,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    1000,    // mass
    0,    // damage
    sfx_alnact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_NOBLOOD|MF_NOGRAVITY|MF_FLOAT|MF_NOTDMATCH|
	MF_BOSS|MF_GHOST|MF_TRANSLUCENT|MF_NOALERT|MF_GIVEQUEST,   // flags
    S_NULL   // crashstate
  },

{	0, 10, // MT_SPECTURE_E		
    168,   // doomednum
    S_ALN1_STND,    // spawnstate
    2000,   // spawnhealth
    S_ALN1_RUN1,    // seestate
    sfx_alnsee,   // seesound
    8,    // reactiontime
    sfx_revbld,   // attacksound
    S_ALN1_PAIN,    // painstate
    50,    // painchance
    sfx_alnpn,   // painsound
    S_ALN1_MEL1,    // meleestate
    S_ALN5_ATK1,    // missilestate
    S_ALN1_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_alndth,   // deathsound
    26,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    1000,    // mass
    0,    // damage
    sfx_alnact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_NOBLOOD|MF_NOGRAVITY|MF_FLOAT|MF_NOTDMATCH|
	MF_BOSS|MF_GHOST|MF_TRANSLUCENT|MF_NOALERT|MF_GIVEQUEST,   // flags
    S_NULL   // crashstate
  },

{	0, 10, // MT_ENTITY		
    128,   // doomednum
    S_MNAM_1,    // spawnstate
    2500,   // spawnhealth
    S_MNAL_RUN1,    // seestate
    sfx_mnalse,   // seesound
    8,    // reactiontime
    sfx_revbld,   // attacksound
    S_MNAL_PAIN,    // painstate
    255,    // painchance
    sfx_alnpn,   // painsound
    S_MNAL_MEL1,    // meleestate
    S_MNAL_ATK1,    // missilestate
    S_MNAL_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_mnaldt,   // deathsound
    13,    // speed
    130*FRACUNIT,    // radius
    200*FRACUNIT,    // height
    1000,    // mass
    0,    // damage
    sfx_alnact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_NOGRAVITY|MF_FLOAT|MF_NOTDMATCH|
	MF_BOSS|MF_GHOST|MF_TRANSLUCENT|MF_NOALERT|MF_GIVEQUEST,   // flags
    S_NULL   // crashstate
  },

{	0, 10, // MT_SUBENTITY		
    -1,   // doomednum
    S_SUB_LOOK,    // spawnstate
    990,   // spawnhealth
    S_SUB_RUN1,    // seestate
    sfx_alnsee,   // seesound
    8,    // reactiontime
    sfx_revbld,   // attacksound
    S_SUB_PAIN,    // painstate
    255,    // painchance
    sfx_alnpn,   // painsound
    S_SUB_MEL1,    // meleestate
    S_SUB_ATK1,    // missilestate
    S_SUB_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_alndth,   // deathsound
    14,    // speed
    130*FRACUNIT,    // radius
    200*FRACUNIT,    // height
    1000,    // mass
    0,    // damage
    sfx_alnact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_NOGRAVITY|MF_FLOAT|MF_NOTDMATCH|
	MF_BOSS|MF_GHOST|MF_TRANSLUCENT|MF_NOALERT|MF_GIVEQUEST,   // flags
    S_NULL   // crashstate
  },

{	0, 10, // MT_NEST	
    26,   // doomednum
    S_NEST,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    84*FRACUNIT,    // radius
    47*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_NOTDMATCH,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_POD	
    198,   // doomednum
    S_POD1,   // spawnstate
    1000,   // spawnhealth
    S_POD2,   // seestate
    sfx_slop,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    25*FRACUNIT,    // radius
    91*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_NOTDMATCH,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_SIGIL_B_SHOT
    -1,   // doomednum
    S_S_B_SHOT1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_sigil,   // seesound
    8,   // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_ZAP1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_sglhit,   // deathsound
    30*FRACUNIT,    // speed
    8*FRACUNIT,    // radius
    24*FRACUNIT,    // height
    100,    // mass
    70,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_MISSILE|MF_DROPOFF|MF_GHOST,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_SIGIL_SB_SHOT
    -1,   // doomednum
    S_S_B_SHOT1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_sigil,   // seesound
    8,   // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_ZAP1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_sglhit,   // deathsound
    30*FRACUNIT,    // speed
    8*FRACUNIT,    // radius
    24*FRACUNIT,    // height
    100,    // mass
    20,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_MISSILE|MF_DROPOFF|MF_GHOST,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_SIGIL_C_SHOT
    -1,   // doomednum
    S_S_C_SHOT1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_sigil,   // seesound
    8,   // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_ZAP1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_sglhit,   // deathsound
    30*FRACUNIT,    // speed
    8*FRACUNIT,    // radius
    24*FRACUNIT,    // height
    100,    // mass
    70,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_MISSILE|MF_DROPOFF|MF_GHOST,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_SIGIL_SC_SHOT
    -1,   // doomednum
    S_S_C_SHOT1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_sigil,   // seesound
    8,   // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_ZAP1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_sglhit,   // deathsound
    30*FRACUNIT,    // speed
    8*FRACUNIT,    // radius
    24*FRACUNIT,    // height
    100,    // mass
    20,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_MISSILE|MF_DROPOFF|MF_GHOST,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_SIGIL_E_OFFSHOOT
    -1,   // doomednum
    S_S_B_SHOT1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_sigil,   // seesound
    8,   // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_ZAP1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_sglhit,   // deathsound
    30*FRACUNIT,    // speed
    8*FRACUNIT,    // radius
    24*FRACUNIT,    // height
    100,    // mass
    10,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_MISSILE|MF_DROPOFF|MF_GHOST,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_SIGIL_TRAIL
    -1,   // doomednum
    S_S_TRAIL1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,   // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    8*FRACUNIT,    // radius
    24*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_DROPOFF,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_SIGIL_E_SHOT
    -1,   // doomednum
    S_S_E_SHOT1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_sigil,   // seesound
    8,   // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_ZAP1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_sglhit,   // deathsound
    18*FRACUNIT,    // speed
    20*FRACUNIT,    // radius
    40*FRACUNIT,    // height
    100,    // mass
    130,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_MISSILE|MF_DROPOFF|MF_GHOST,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_SIGIL_SE_SHOT
    -1,   // doomednum
    S_S_E_SHOT1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_sigil,   // seesound
    8,   // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_ZAP1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_sglhit,   // deathsound
    18*FRACUNIT,    // speed
    20*FRACUNIT,    // radius
    40*FRACUNIT,    // height
    100,    // mass
    30,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_MISSILE|MF_DROPOFF|MF_GHOST,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_SIGIL_A_ZAP_LEFT
    -1,   // doomednum
    S_S_A_ZAP1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_sigil,   // seesound
    8,   // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_ZAP6,   // deathstate
    S_NULL,   // xdeathstate
    sfx_sglhit,   // deathsound
    22,    // speed
    8*FRACUNIT,    // radius
    24*FRACUNIT,    // height
    100,    // mass
    100,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_MISSILE|MF_DROPOFF|MF_GHOST,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_SIGIL_A_ZAP_RIGHT
    -1,   // doomednum
    S_S_A_ZAP1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_sigil,   // seesound
    8,   // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_ZAP6,   // deathstate
    S_NULL,   // xdeathstate
    sfx_sglhit,   // deathsound
    22,    // speed
    8*FRACUNIT,    // radius
    24*FRACUNIT,    // height
    100,    // mass
    50,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_MISSILE|MF_DROPOFF|MF_GHOST,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_SIGIL_A_GROUND
    -1,   // doomednum
    S_S_A_GROUND1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    70,   // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_ZAP1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    1179648,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_TRANSLUCENT,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_SIGIL_D_SHOT
    -1,   // doomednum
    S_S_D_SHOT1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_sigil,   // seesound
    8,   // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_ZAP1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_sglhit,   // deathsound
    28*FRACUNIT,    // speed
    8*FRACUNIT,    // radius
    24*FRACUNIT,    // height
    100,    // mass
    120,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_MISSILE|MF_DROPOFF|MF_GHOST,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_SIGIL_SD_SHOT
    -1,   // doomednum
    S_S_D_SHOT1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_sigil,   // seesound
    8,   // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_ZAP1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_sglhit,   // deathsound
    28*FRACUNIT,    // speed
    8*FRACUNIT,    // radius
    24*FRACUNIT,    // height
    100,    // mass
    60,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_MISSILE|MF_DROPOFF|MF_GHOST,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_SENTINEL		
    3006,   // doomednum
    S_SEWR_STND,    // spawnstate
    100,   // spawnhealth
    S_SEWR_RUN1,    // seestate
    sfx_sntsee,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_SEWR_PAIN,    // painstate
    255,    // painchance
    sfx_None,   // painsound
    S_NULL,    // meleestate
    S_SEWR_ATK1,    // missilestate
    S_SEWR_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_sntdth,   // deathsound
    7,    // speed
    23*FRACUNIT,    // radius
    53*FRACUNIT,    // height
    300,    // mass
    0,    // damage
    sfx_sntact,   // activesound
	MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_NOBLOOD|MF_SPAWNCEILING|MF_NOGRAVITY|MF_FLOAT
	|MF_NOALERT/*|MF_GIVEQUEST*/,   // flags		-FIXME	-kaiser
    S_NULL   // crashstate
  },

  {	0, 10, // MT_STALKER	
    186,   // doomednum
    S_STLK_STND,    // spawnstate
    80,   // spawnhealth
    S_STLK_RUN1,    // seestate
    sfx_spisit,   // seesound
    8,    // reactiontime
    sfx_spdatk,   // attacksound
    S_STLK_PAIN,    // painstate
    40,    // painchance
    sfx_spdatk,   // painsound
    S_STLK_ATK1,    // meleestate
    S_NULL,    // missilestate
    S_STLK_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_spidth,   // deathsound
    12,    // speed
    31*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_spisit,   // activesound
	MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_NOBLOOD|MF_SPAWNCEILING|MF_NOGRAVITY|MF_DROPOFF
	|MF_NOALERT,   // flags
    S_NULL   // crashstate
  },

  {	0, 10, // MT_INQUISITOR	
    16,   // doomednum
    S_ROB3_STND,    // spawnstate
    1000,   // spawnhealth
    S_ROB3_RUN1,    // seestate
    sfx_inqsee,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,    // painstate
    0,    // painchance
    sfx_None,   // painsound
    0,    // meleestate
    S_ROB3_ATK1,    // missilestate
    S_ROB3_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_inqdth,   // deathsound
    0,    // speed
    40*FRACUNIT,    // radius
    110*FRACUNIT,    // height
    1000,    // mass
    0,    // damage
    sfx_inqact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_NOBLOOD|MF_DROPOFF,   // flags
    S_NULL   // crashstate
  },

  {	0, 10, // MT_INQARM
    -1,   // doomednum
    S_RBB3,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOCLIP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_PROGRAMMER		
    71,   // doomednum
    S_PRGR_STND,    // spawnstate
    1100,   // spawnhealth
    S_PRGR_RUN1,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_revbld,   // attacksound
    S_PRGR_PAIN,    // painstate
    50,    // painchance
    sfx_prgpn,   // painsound
    S_PRGR_MEL1,    // meleestate
    S_PRGR_ATK1,    // missilestate
    S_PRGR_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_rb2dth,   // deathsound
    26,    // speed
    45*FRACUNIT,    // radius
    60*FRACUNIT,    // height
    800,    // mass
    4,    // damage
    sfx_progac,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_NOBLOOD|MF_NOGRAVITY|MF_FLOAT|MF_NOTDMATCH|
	MF_BOSS|MF_GIVEQUEST,   // flags
    S_NULL   // crashstate
  },

  {	0, 10, // MT_PROGRAMMERBASE
    -1,   // doomednum
    S_PBASE1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_DROPOFF,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_HOOKSHOT
    -1,   // doomednum
    S_OCLW,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_chain,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_CCLW,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    20*FRACUNIT,    // speed
    10*FRACUNIT,    // radius
    14*FRACUNIT,    // height
    100,    // mass
    2,    // damage
    sfx_swish,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_CHAINSHOT
    -1,   // doomednum
    S_TEND,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_tend,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    10*FRACUNIT,    // radius
    14*FRACUNIT,    // height
    100,    // mass
    2,    // damage
    sfx_swish,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MINIMISSLE
    -1,   // doomednum
    S_MINIMISSLE,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_rlaunc,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_MISSILE_X1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_mislht,   // deathsound
    20*FRACUNIT,    // speed
    10*FRACUNIT,    // radius
    14*FRACUNIT,   // height
    100,    // mass
    10,   // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_C_MISSILE
    -1,   // doomednum
    S_MINIMISSLE,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_rlaunc,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_MISSILE_X1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_mislht,   // deathsound
    20*FRACUNIT,    // speed
    10*FRACUNIT,    // radius
    14*FRACUNIT,   // height
    100,    // mass
    7,   // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_SEEKMISSILE
    -1,   // doomednum
    S_SEEKMISSLE,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_rlaunc,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_MISSILE_X1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_mislht,   // deathsound
    20*FRACUNIT,    // speed
    10*FRACUNIT,    // radius
    14*FRACUNIT,   // height
    100,    // mass
    10,   // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_ELECARROW
    -1,   // doomednum
    S_EAROW1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_xbow,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_ZAP1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    30*FRACUNIT,    // speed
    10*FRACUNIT,    // radius
    10*FRACUNIT,    // height
    100,    // mass
    10,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,    // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_POISARROW
    -1,   // doomednum
    S_PAROW1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_xbow,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_PZAP1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    30*FRACUNIT,    // speed
    10*FRACUNIT,    // radius
    10*FRACUNIT,    // height
    100,    // mass
    500,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,    // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_R_LASER
    -1,   // doomednum
    S_L_LASER1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_L_DTH5,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    40*FRACUNIT,    // speed
    10*FRACUNIT,    // radius
    8*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_NOGRAVITY|MSF_OBLIVIATE2,    // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_L_LASER
    -1,   // doomednum
    S_L_LASER1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_plasma,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_L_DTH1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    40*FRACUNIT,    // speed
    10*FRACUNIT,    // radius
    8*FRACUNIT,    // height
    100,    // mass
    1,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_NOGRAVITY|MSF_OBLIVIATE2,    // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_HEGRENADE
    -1,   // doomednum
    S_GRENADE_HE_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_phoot,   // seesound
    30,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_GRENADE_HE_X1,   // meleestate
    S_NULL,   // missilestate
    S_GRENADE_HE_X1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_explod,   // deathsound
    15*FRACUNIT,    // speed
    13*FRACUNIT,    // radius
    13*FRACUNIT,   // height
    80,    // mass
    0,   // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_DROPOFF|MF_MISSILE,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_PGRENADE
    -1,   // doomednum
    S_GRENADE_P_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_phoot,   // seesound
    40,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_GRENADE_P_X1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_explod,   // deathsound
    15*FRACUNIT,    // speed
    13*FRACUNIT,    // radius
    13*FRACUNIT,   // height
    80,    // mass
    0,   // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_DROPOFF|MF_MISSILE,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_INQGRENADE
    -1,   // doomednum
    S_ROB3GREN1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_phoot,   // seesound
    15,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_BNG2_1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_explod,   // deathsound
    25*FRACUNIT,    // speed
    13*FRACUNIT,    // radius
    13*FRACUNIT,   // height
    15,    // mass
    0,   // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_DROPOFF|MF_MISSILE,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_PFLAME
    -1,   // doomednum
    S_PFLAME1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    120,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_PFLAMEEND1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_TRANSLUCENT|MF_DROPOFF|MSF_OBLIVIATE, // flags // phares
    S_NULL    // crashstate
  },

  {	0, 10, // MT_TORPEDO
    -1,   // doomednum
    S_TORPEDO_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_protfl,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_TORPEDO_X1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_explod,   // deathsound
    20*FRACUNIT,    // speed
    13*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    1,   // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MSF_OBLIVIATE2,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_TORPEDOSPREAD
    -1,   // doomednum
    S_TORPEDO_E1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_TORPEDO_E3,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    35*FRACUNIT,    // speed
    13*FRACUNIT,    // radius
    13*FRACUNIT,   // height
    100,    // mass
    10,   // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MSF_OBLIVIATE2,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_SFIREBALL
    -1,   // doomednum
    S_FLAMEFX_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_flburn,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_FLAMEFX_X1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    17*FRACUNIT,    // speed
    8*FRACUNIT,    // radius
    11*FRACUNIT,   // height
    10,    // mass
    4,   // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_DROPOFF|MF_MISSILE|MSF_OBLIVIATE,   // flags
    S_NULL    // crashstate
  },

{	0, 10, // MT_C_FLAME
   -1,   // doomednum
    S_FLAMEFX_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_flburn,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_FLAMEFX_X1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    35*FRACUNIT,    // speed
    8*FRACUNIT,    // radius
    11*FRACUNIT,   // height
    10,    // mass
    1,   // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_DROPOFF|MF_MISSILE|MSF_OBLIVIATE,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_STRIFEPUFF3
    -1,   // doomednum
    S_PUFM1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // crashstate
  },

  {	0, 10, // MT_STRIFEPUFF
    -1,   // doomednum
    S_PUFY1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // crashstate
  },

  {	0, 10, // MT_SPARKPUFF
    -1,   // doomednum
    S_POW3_1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // crashstate
  },

  {	0, 10, // MT_BLOOD_DEATH
    -1,   // doomednum
    S_BLOOD_DEATH1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY,    // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_TFOG
    -1,   // doomednum
    S_TFOG,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // crashstate
  },

  {	0, 10, // MT_IFOG
    -1,   // doomednum
    S_IFOG,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // crashstate
  },

  {	0, 10, // MT_TELEPORTMAN
    14,   // doomednum
    S_NULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_01		//122
    24,   // doomednum
    S_MISC_01_1,   // spawnstate
    1000,   // spawnhealth
    S_MISC_01_2,   // seestate
    sfx_None,   // seesound
    60,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_TURRET
    27,   // doomednum
    S_TURRET1,   // spawnstate
    125,   // spawnhealth
    S_TURRET2,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_TURRET3,   // missilestate
    S_TURRET6,   // deathstate
    S_NULL,   // xdeathstate
    sfx_mislht,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SHOOTABLE|MF_COUNTKILL|MF_NOGRAVITY|MF_SPAWNCEILING|MF_NOBLOOD,   //flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_GATE
    45,   // doomednum
    S_PSTN1,   // spawnstate
    100,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_PSTN_DTH1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_explod,   // deathsound
    16,    // speed
    20*FRACUNIT,    // radius
    76*FRACUNIT,    // height
    1000000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_NOALERT|MF_NOBLOOD|MF_GIVEQUEST,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_COMPUTER
    182,   // doomednum
    S_SECR_1,   // spawnstate
    80,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_SECR_5,   // deathstate
    S_NULL,   // xdeathstate
    sfx_explod,   // deathsound
    27,    // speed
    26*FRACUNIT,    // radius
    128*FRACUNIT,    // height
    1000000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_NOALERT|MF_NOBLOOD|MF_GIVEQUEST,   // flags
    S_NULL    // crashstate
  },

  {	MC_MEDPATCH, 20, // MT_INV_MED1
    2011,   // doomednum
    S_INV_MED1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_MEDICALKIT, 15, // MT_INV_MED2
    2012,   // doomednum
    S_INV_MED2,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_SURGERYKIT, 5, // MT_INV_MED3
    83,   // doomednum
    S_INV_MED3_1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_DEGNINORE, 10, // MT_DEGNINORE
    59,   // doomednum
    S_XPRK1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_XPRK2,   // deathstate
    S_NULL,   // xdeathstate
    sfx_explod,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    10,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_SOLID|MF_SHOOTABLE|MF_NOALERT|MF_NOBLOOD,   // flags
    S_NULL    // crashstate
  },

  {	MC_METALARMOR, 3, // MT_INV_ARMOR2
    2019,   // doomednum
    S_INV_ARMOR1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_LEATHERARMOR, 5, // MT_INV_ARMOR1
    2018,   // doomednum
    S_INV_ARMOR2,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_22
    2014,   // doomednum
    S_MISC_22,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_11		//133
    164,   // doomednum
    S_MISC_11,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,   // flags
    S_NULL    // crashstate
  },

  {	MC_BASEKEY, 1, // MT_KEY_BASE
    230,   // doomednum
    S_KEY10,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_GOVSKEY, 1, // MT_GOVSKEY						
    -1,   // doomednum
    S_QKEY1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // crashstate
  },

  {	MC_PASSCARD, 1, // MT_KEY_TRAVEL												
    185,   // doomednum
    S_KEY9,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_IDBADGE, 1, // MT_KEY_ID_BLUE										
    184,   // doomednum
    S_KEY13,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_PRISONKEY, 1, // MT_PRISONKEY									
    -1,   // doomednum
    S_QKEY2,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    11,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH|MF_GIVEQUEST,    // flags
    S_NULL    // crashstate
  },

  {	MC_SEVEREDHAND, 1, // MT_KEY_HAND												
    91,   // doomednum
    S_KEY8,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    12,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_GIVEQUEST,    // flags
    S_NULL    // crashstate
  },

  {	MC_POWER1KEY, 1, // MT_POWER1KEY							
    -1,   // doomednum
    S_QKEY3,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // crashstate
  },

  {	MC_POWER2KEY, 1, // MT_POWER2KEY									
    -1,   // doomednum
    S_QKEY4,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // crashstate
  },

  {	MC_POWER3KEY, 1, // MT_POWER3KEY						
    -1,   // doomednum
    S_QKEY5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // crashstate
  },

  {	MC_GOLDKEY, 1, // MT_KEY_GOLD		
    40,   // doomednum
    S_KEY2,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_IDCARD, 1, // MT_KEY_ID_GOLD						

										

										
    13,   // doomednum
    S_KEY17,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_SILVERKEY, 1, // MT_KEY_SILVER
    38,   // doomednum
    S_KEY1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_ORACLEKEY, 1, // MT_KEY_ORACLE					

										

						
    61,   // doomednum
    S_KEY12,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_MILITARYID, 1, // MT_MILITARYID						

				
    -1,   // doomednum
    S_QKEY6,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // crashstate
  },

  {	MC_ORDERKEY, 1, // MT_KEY_ORDER				
    86,   // doomednum
    S_KEY3,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_WAREHOUSEKEY, 1, // MT_KEY_WAREHOUSE				

	
    166,   // doomednum
    S_KEY4,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_BRASSKEY, 1, // MT_KEY_BRASS						

	
    39,   // doomednum
    S_KEY5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_REDCRYSTALKEY, 1, // MT_KEY_RED_CRYSTAL				

										

										

	
    192,   // doomednum
    S_KEY16,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_BLUECRYSTALKEY, 1, // MT_KEY_BLUE_CRYSTAL				

										

										

			
    193,   // doomednum
    S_KEY18,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_CHAPELKEY, 1, // MT_KEY_CHAPEL						

			
    195,   // doomednum
    S_KEY6,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_CATACOMBKEY, 1, // MT_CATACOMBKEY									
    -1,   // doomednum
    S_QKEY7,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    28,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH|MF_GIVEQUEST,    // flags
    S_NULL    // crashstate
  },

  {	MC_SECURITYKEY, 1, // MT_SECURITYKEY								
    -1,   // doomednum
    S_QKEY8,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // crashstate
  },

  {	MC_COREKEY, 1, // MT_KEY_CORE						

										

			
    236,   // doomednum
    S_KEY11,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_MAULERKEY, 1, // MT_KEY_MAULER					

										

								
    233,   // doomednum
    S_KEY14,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_FACTORYKEY, 1, // MT_KEY_FACTORY					

										

									
    234,   // doomednum
    S_KEY15,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_MINEKEY, 1, // MT_KEY_MINE						

					
    235,   // doomednum
    S_KEY7,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_NEWKEY5, 1, // MT_NEWKEY5									
    -1,   // doomednum
    S_KEY14,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // crashstate
  },

  {	MC_SHADOWARMOR, 2, // MT_INV_SHADOWARMOR
    2024,   // doomednum
    S_INV_SHADOWARMOR,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_ENVIRONMENTALSUIT, 5, // MT_INV_SUIT
    2025,   // doomednum
    S_INV_SUIT,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_GUARDUNIFORM, 1, // MT_QUEST_UNIFORM					
    90,   // doomednum
    S_QUEST6,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    15,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_GIVEQUEST,    // flags
    S_NULL    // crashstate
  },

  {	MC_OFFICERSUNIFORM, 1, // MT_QUEST_GUARD_UNIFORM									
    52,   // doomednum
    S_QUEST7,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_MAP, 1, // MT_INV_SUPERMAP
    2026,   // doomednum
    S_INV_SUPERMAP1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_SCANNER, 1, // MT_INV_RADAR
    2027,   // doomednum
    S_INV_RADAR1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_TELEPORTERBEACON, 1, // MT_BEACON						
    10,   // doomednum
    S_BEACON,    // spawnstate
    5,   // spawnhealth
    S_BEACON_2,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_TARGETER, 5, // MT_INV_TARGETER
    207,   // doomednum
    S_INV_TARGETER,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_COIN, 1, // MT_INV_GOLD1,
    93,   // doomednum
    S_INV_GOLD1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_10GOLD, 1, // MT_INV_GOLD10,
    138,   // doomednum
    S_INV_GOLD10,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_25GOLD, 1, // MT_INV_GOLD25,
    139,   // doomednum
    S_INV_GOLD25,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_50GOLD, 1, // MT_INV_GOLD50,
    140,   // doomednum
    S_INV_GOLD50,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_300GOLD, 1, // MT_INV_GOLD300,
    -1,   // doomednum
    S_INV_GOLD300,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    3,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_GIVEQUEST,    // flags
    S_NULL    // crashstate
  },

  {	MC_RING, 1, // MT_TOKEN_RING
    -1,   // doomednum
    S_RING,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    1,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_GIVEQUEST,   // flags
    S_NULL    // crashstate
  },

  {	MC_OFFERINGCHALICE, 1, // MT_INV_CHALICE
    205,   // doomednum
    S_INV_CHALICE,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    2,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_GIVEQUEST,    // flags
    S_NULL    // crashstate
  },

  {	MC_EAR, 1, // MT_TOKEN_EAR
    -1,   // doomednum
    S_EAR,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    9,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_GIVEQUEST,   // flags
    S_NULL    // crashstate
  },

  {	MC_COMMUNITACTOR, 1, // MT_INV_COMMUNICATOR
    206,   // doomednum
    S_INV_COMMUNICATOR,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_HEGRENADEROUNDS, 10, // MT_AGREN
    152,   // doomednum
    S_AGREN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_PHOSPHORUSGRENADEROUNDS, 10, // MT_APGREN
    153,   // doomednum
    S_APGREN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_CLIPOFBULLETS, 10, // MT_ACLIP
    2007,   // doomednum
    S_ACLIP,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_AMMO, 10, // MT_AAMMOBOX
    2048,   // doomednum
    S_AAMMOBOX,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_MINIMISSILES, 10, // MT_AMINI
    2010,   // doomednum
    S_AMINI,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_CRATEOFMISSILES, 10, // MT_AMINIBOX
    2046,   // doomednum
    S_AMINIBOX,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_ENERGYPOD, 10, // MT_ACELL
    2047,   // doomednum
    S_ACELL1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_ENERGYPACK, 10, // MT_APCELL
    17,   // doomednum
    S_APCELL1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_POISONBOLTS, 10, // MT_APAROW
    115,   // doomednum
    S_APAROW,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_ELECTRICBOLTS, 10, // MT_AAROW
    114,   // doomednum
    S_AAROW,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_AMMOSATCHEL, 10, // MT_INV_SATCHEL
    183,   // doomednum
    S_INV_SATCHEL,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_ASSAULTGUN, 10, // MT_RIFLE
    2002,   // doomednum
    S_ASAULTGUN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_ASSAULTGUN, 10, // MT_RIFLESTAND
    2006,   // doomednum
    S_ASAULTGUN2,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_FLAMETHROWER, 10, // MT_FLAMETHROWER
    2005,   // doomednum
    S_FLAMETHROWERGUN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_FLAMETHROWERPARTS, 10, // MT_TOKEN_FLAME_THROWER_PARTS
    998,   // doomednum
    S_FPARTS,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_MINIMISSILELAUNCHER, 10, // MT_MINIMISSILE
    2003,   // doomednum
    S_MINIMISSILEGUN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_MAULER, 10, // MT_BLASTER
    2004,   // doomednum
    S_BLASTERGUN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_CROSSBOW, 10, // MT_CROSSBOW
    2001,   // doomednum
    S_CROSSBOWGUN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_GRENADELAUNCHER, 10, // MT_GRENADELAUNCHER
    154,   // doomednum
    S_GRENADEGUN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_SIGIL, 10, // MT_SIGIL_A							

										

										

		
    77,   // doomednum
    S_QUEST1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_SIGIL, 10, // MT_SIGIL_B							

										

										

	
    78,   // doomednum
    S_QUEST2,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_SIGIL, 10, // MT_SIGIL_C							

										

										

	
    79,   // doomednum
    S_QUEST3,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_SIGIL, 10, // MT_SIGIL_D							

										

										

	
    80,   // doomednum
    S_QUEST4,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	MC_SIGIL, 10, // MT_SIGIL_E							

										

										

		
    81,   // doomednum
    S_QUEST5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,    // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_POWER_CRYSTAL
    92,   // doomednum
    S_CRYS_1,   // spawnstate
    50,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_BOOM_1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_explod,   // deathsound
    14,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    999999999,    // mass
    0,    // damage
    sfx_reactr,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_NOBLOOD|MF_NOGRAVITY|MF_GIVEQUEST,   // flags
    S_NULL    // crashstate
  },

  {	MC_RATBUDDY, 10, // MT_RAT
    85,   // doomednum
    S_RAT1,   // spawnstate
    5,   // spawnhealth
    S_RATSEE1,   // seestate
    sfx_ratact,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    13,    // speed
    10*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_ratact,   // activesound
    MF_COUNTKILL|MF_NOALERT,	//flags
   S_NULL	//crashstate
},

  {	0, 10, // MT_MISC_05		204
    82,   // doomednum
    S_MISC_05,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_MISC_05_1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_wbrldt,   // deathsound
    0,    // speed
    10*FRACUNIT,    // radius
    32*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_NOBLOOD|MF_NOALERT,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_06		205
    94,   // doomednum
    S_MISC_06,   // spawnstate
    30,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_MISC_06_1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_barexp,   // deathsound
    0,    // speed
    10*FRACUNIT,    // radius
    32*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_NOBLOOD|MF_NOALERT,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_15		//206
    208,   // doomednum
    S_MISC_15,   // spawnstate
    99999999,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_MISC_15_1,   // painstate
    255,    // painchance
    sfx_mtalht,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    12*FRACUNIT,    // radius
    72*FRACUNIT,    // height
    99999999,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_NOBLOOD|MF_NOALERT,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_LIGHT14
    95,   // doomednum
    S_LIGHT14,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    4*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_LIGHT13
    96,   // doomednum
    S_LIGHT13,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    4*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_LIGHT12
    97,   // doomednum
    S_LIGHT12,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    4*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_LIGHT18
    2028,   // doomednum
    S_LIGHT18,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_PILLAR2	
    48,   // doomednum
    S_PILLAR2,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_PILLAR3	
    54,   // doomednum
    S_PILLAR3,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_PILLAR4	
    55,   // doomednum
    S_PILLAR4,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_PILLAR5	
    56,   // doomednum
    S_PILLAR5,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_PILLAR6
    57,   // doomednum
    S_PILLAR6_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_PILLAR7	
    227,   // doomednum
    S_PILLAR7,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    40,    // painchance
    sfx_amaln2,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_amaln2,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_CAVE2	
    98,   // doomednum
    S_CAVE2,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    109*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_CAVE3	
    161,   // doomednum
    S_CAVE3,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    109*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_CAVE4	
    160,   // doomednum
    S_CAVE4,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_CAVE6
    159,   // doomednum
    S_CAVE6,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    109*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_CAVE7	
    162,   // doomednum
    S_CAVE7,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_CAVE5	
    163,   // doomednum
    S_CAVE5,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_LIGHT2
    34,   // doomednum
    S_LIGHT2,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_LIGHT3
    35,   // doomednum
    S_LIGHT3,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    40*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_03		//225
    103,   // doomednum
    S_MISC_03_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_wdrip,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_13		//226
    104,   // doomednum
    S_MISC_13_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_wfall,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_02		//227
    53,   // doomednum
    S_MISC_02_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_07		//228
    112,   // doomednum
    S_MISC_07_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_wriver,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_BIO2	
    113,   // doomednum
    S_BIO2_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_TELEPORTSTAND							
    23,   // doomednum
    S_TSTAND_1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    MF_TRANSLUCENT    // crashstate
  },

  {	0, 10, // MT_DEADTHING1
    22,   // doomednum
    S_ROB2_DIE10,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_DEADTHING2
    15,   // doomednum
    S_PLAY_DIE10,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_DEADTHING3
    18,   // doomednum
    S_PEAS_DIE8,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_DEADTHING4
    21,   // doomednum
    S_AGRD_DIE8,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_DEADTHING5
    20,   // doomednum
    S_ROB1_DIE9,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_DEADTHING6
    19,   // doomednum
    S_PLAY_DIE10,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_BIO1	
    212,   // doomednum
    S_BIO1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_GIBS	
    89,   // doomednum
    S_DEAD_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_04		//239
    70,   // doomednum
    S_MISC_04_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    48*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_LIGHT11
    105,   // doomednum
    S_LIGHT11_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_smfire,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_LIGHT10
    106,   // doomednum
    S_LIGHT10_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_smfire,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    10*FRACUNIT,    // radius
    32*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_LIGHT9
    107,   // doomednum
    S_LIGHT9_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_smfire,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    0*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_LIGHT8
    108,   // doomednum
    S_LIGHT8,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    0*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_14		//224
    109,   // doomednum
    S_MISC_14,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    93*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // crashstate
  },

    {	0, 10, // MT_LIGHT1
    28,   // doomednum
    S_LIGHT1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    3*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_PILLAR8	
    110,   // doomednum
    S_PILLAR8,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_PILLAR9	
    44,   // doomednum
    S_PILLAR9,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_LIGHT15
    111,   // doomednum
    S_LIGHT15_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    4*FRACUNIT,    // radius
    72*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_LIGHT4
    43,   // doomednum
    S_LIGHT4,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    3*FRACUNIT,    // radius
    80*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_LIGHT5
    46,   // doomednum
    S_LIGHT5,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_ROCK1
    99,   // doomednum
    S_ROCK1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    8*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_ROCK2
    100,   // doomednum
    S_ROCK2,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    8*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_ROCK3
    101,   // doomednum
    S_ROCK3,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    8*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_ROCK4
    102,   // doomednum
    S_ROCK4,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    8*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_TREE7
    215,   // doomednum
    S_TREE7,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_wriver,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    109*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_wriver,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_RUBBLE1
    29,   // doomednum
    S_RUB1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    8*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_RUBBLE2
    30,   // doomednum
    S_RUB2,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    8*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_RUBBLE3
    31,   // doomednum
    S_RUB3,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    8*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_RUBBLE4
    32,   // doomednum
    S_RUB4,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    8*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_RUBBLE5
    36,   // doomednum
    S_RUB5,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    8*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_RUBBLE6
    37,   // doomednum
    S_RUB6,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    8*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_RUBBLE7
    41,   // doomednum
    S_RUB7,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    8*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_RUBBLE8
    42,   // doomednum
    S_RUB8,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    8*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_08		//264
    117,   // doomednum
    S_MISC_08,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_LIGHT6
    47,   // doomednum
    S_LIGHT6_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_smfire,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    10*FRACUNIT,    // radius
    72*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_LIGHT7
    50,   // doomednum
    S_LIGHT7_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_smfire,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    10*FRACUNIT,    // radius
    80*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_TREE2	
    51,   // doomednum
    S_TREE2,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    109*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_TREE3
    202,   // doomednum
    S_TREE3,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    109*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_TREE4
    203,   // doomednum
    S_TREE4,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_TREE1
    33,   // doomednum
    S_TREE1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    80*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_TREE6	
    60,   // doomednum
    S_TREE6,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    109*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_TREE5
    62,   // doomednum
    S_TREE5,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    109*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_CAVE1	
    63,   // doomednum
    S_CAVE1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    109*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_PILLAR1	
    69,   // doomednum
    S_PILLAR1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_10		//275
    165,   // doomednum
    S_MISC_10,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    12*FRACUNIT,    // radius
    24*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_09		//276
    188,   // doomednum
    S_MISC_09,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    12*FRACUNIT,    // radius
    32*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_17
    189,   // doomednum
    S_MISC_17,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    6*FRACUNIT,    // radius
    24*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_18
    190,   // doomednum
    S_MISC_18,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_19
    191,   // doomednum
    S_MISC_19,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_20
    194,   // doomednum
    S_MISC_20,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    32*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

 {	0, 10, // MT_LIGHT16
    196,   // doomednum
	S_LIGHT17,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    8*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_LIGHT17
    197,   // doomednum
    S_LIGHT16,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    11*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_21
    68,   // doomednum
    S_MISC_21,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    24*FRACUNIT,    // radius
    40*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_12		//284
    228,   // doomednum
    S_MISC_12,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    12*FRACUNIT,    // radius
    24*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_26
    216,   // doomednum
    S_MISC_26,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    24*FRACUNIT,    // radius
    96*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_23
    217,   // doomednum
    S_MISC_23,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_24
    218,   // doomednum
    S_MISC_24,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MISC_25
    219,   // doomednum
    S_MISC_25,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_COUPLING
    220,   // doomednum
    S_COUP1,   // spawnstate
    40,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    6,    // speed
    17*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    99999999,    // mass
    0,    // damage
    sfx_None,   // activesound
	MF_SOLID|MF_SHOOTABLE|MF_GIVEQUEST|MF_NOBLOOD|MF_NOALERT|MF_DROPPED|MF_NOTDMATCH,    // flags
    S_NULL    // crashstate
  },

  {	MC_BROKENPOWERCOUPLING, 10, // MT_COUPLING_BROKEN
    226,   // doomednum
    S_COUP3,   // spawnstate
    40,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    /*335544440*/ 13,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    1,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_DROPPED|MF_GIVEQUEST,    // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_PILLAR10	
    221,   // doomednum
    S_PILLAR10,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    40,    // painchance
    sfx_amaln5,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_amaln5,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_PILLAR11	
    222,   // doomednum
    S_PILLAR11,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    40,    // painchance
    sfx_amaln6,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_amaln6,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_PILLAR12	
    223,   // doomednum
    S_PILLAR12,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    40,    // painchance
    sfx_amaln4,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_amaln4,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_PILLAR13	
    224,   // doomednum
    S_PILLAR13,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    40,    // painchance
    sfx_amaln3,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_amaln3,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_LIGHT19
    225,   // doomednum
    S_LIGHT19_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_amaln1,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    32*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_amaln1,   // activesound
    MF_SOLID,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MEAT
    -1,   // doomednum
    S_MEAT_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOCLIP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_JUNK
    -1,   // doomednum
    S_JUNK_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOCLIP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_BURNDROP
    -1,   // doomednum
    S_BDROP_1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL    // crashstate
  },

  {	MC_TAMMO, 1, // MT_TOKEN_AMMO
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_BOSS,   // flags
    S_NULL    // crashstate
  },

  {	MC_HEALTH, 1, // MT_TOKEN_HEALTH
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_BOSS,   // flags
    S_NULL    // crashstate
  },

  {	MC_INFO, 100, // MT_TOKEN
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL    // crashstate
  },

  {	MC_ALARM, 100, // MT_TOKEN_ALARM
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_BOSS,   // flags
    S_NULL    // crashstate
  },

  {	0, 100, // MT_TOKEN_DOOR1
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 100, // MT_TOKEN_SHOPCLOSE
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_BOSS,   // flags
    S_NULL    // crashstate
  },

  {	MC_PRISONPASS, 1, // MT_TOKEN_PRISON_PASS
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    10,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_GIVEQUEST,   // flags
    S_NULL    // crashstate
  },

  {	0, 100, // MT_TOKEN_DOOR3
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 100, // MT_TOKEN_STAMINA
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 100, // MT_TOKEN_NEW_ACCURACY
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_REPORT, 10, // MT_TOKEN_REPORT
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_TOUGHNESS, 100, // MT_TOKEN_TOUGHNESS
    -1,   // doomednum
    S_TOUGH,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_ACCURACY, 100, // MT_TOKEN_ACCURACY
    -1,   // doomednum
    S_ACCURACY,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_ORACLEPASS, 1, // MT_TOKEN_ORACLE_PASS
    997,   // doomednum
    S_ORACLEPASS,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    18,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_GIVEQUEST,   // flags
    S_NULL    // crashstate
  },

  {	0, 1, // MT_TOKEN_QUEST1
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 1, // MT_TOKEN_QUEST2
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 1, // MT_TOKEN_QUEST3
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_QUEST4, 1, // MT_TOKEN_QUEST4
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_BOSS,   // flags
    S_NULL    // crashstate
  },

  {	MC_QUEST5, 1, // MT_TOKEN_QUEST5
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_QUEST6, 1, // MT_TOKEN_QUEST6
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 1, // MT_TOKEN_QUEST7
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 1, // MT_TOKEN_QUEST8
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 1, // MT_TOKEN_QUEST9
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 1, // MT_TOKEN_QUEST10
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 1, // MT_TOKEN_QUEST11
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 1, // MT_TOKEN_QUEST12
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 1, // MT_TOKEN_QUEST13
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_BLOWNEDUPCRYSTAL, 1, // MT_TOKEN_CRYSTAL
    995,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 1, // MT_TOKEN_QUEST15
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_BLOWNEDUPGATES, 1, // MT_GATEQUEST
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 1, // MT_TOKEN_QUEST17
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 1, // MT_TOKEN_QUEST18
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 1, // MT_TOKEN_QUEST19
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 1, // MT_TOKEN_QUEST20
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_DEADBISHOP, 1, // MT_TOKEN_BISHOP
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 1, // MT_TOKEN_QUEST22
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_DEADORACLE, 1, // MT_TOKEN_ORACLE
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_DEADMACIL, 1, // MT_TOKEN_MACIL
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	CONVERTER, 1, // MT_TOKEN_QUEST25
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_DEADLOREMASTER, 1, // MT_TOKEN_LOREMASTER
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	MC_BLOWNEDUPCOMPUTER, 1, // MT_SECRQUEST
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 1, // MT_TOKEN_QUEST28
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 1, // MT_TOKEN_QUEST29
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 1, // MT_TOKEN_QUEST30
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 1, // MT_TOKEN_QUEST31
    -1,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 100, // MT_SLIDESHOW
    10000,   // doomednum
    S_TOKN_GUARD1,   // spawnstate
    10,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    2*FRACUNIT,    // radius
    1*FRACUNIT,    // height
    10000000,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_STRIFEPUFF2
    -1,   // doomednum
    S_PUFP1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // crashstate
  },

{	0, 10, // MT_BLOOD
    -1,   // doomednum
    S_BLOOD1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY,    // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_GLASS	
    -1,   // doomednum
    S_SHRD,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_DROPOFF|MF_NOCLIP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_GLASS2	
    -1,   // doomednum
    S_SHRD2,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_DROPOFF|MF_NOCLIP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_GLASS3	
    -1,   // doomednum
    S_SHRD3,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_DROPOFF|MF_NOCLIP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_GLASS4	
    -1,   // doomednum
    S_SHRD4,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    25*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_DROPOFF|MF_NOCLIP,   // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MAPSPOT1
    118,   // doomednum
    S_NULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MAPSPOT2
    119,   // doomednum
    S_NULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MAPSPOT3
    120,   // doomednum
    S_NULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MAPSPOT4
    121,   // doomednum
    S_NULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MAPSPOT5
    122,   // doomednum
    S_NULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MAPSPOT6
    123,   // doomednum
    S_NULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MAPSPOT7
    124,   // doomednum
    S_NULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MAPSPOT8
    125,   // doomednum
    S_NULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MAPSPOT9
    126,   // doomednum
    S_NULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // crashstate
  },

  {	0, 10, // MT_MAPSPOT10
    127,   // doomednum
    S_NULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // crashstate
  },

  //=====================================================================





  // For use with wind and current effects
  {	0, 10, // MT_PUSH                       // phares
    5001,           // doomednum       //   |      //jff 5/11/98 deconflict
    S_TNT1,         // spawnstate      //   V      // with DOSDoom
    1000,           // spawnhealth
    S_NULL,         // seestate
    sfx_None,       // seesound
    8,              // reactiontime
    sfx_None,       // attacksound
    S_NULL,         // painstate
    0,              // painchance
    sfx_None,       // painsound
    S_NULL,         // meleestate
    S_NULL,         // missilestate
    S_NULL,         // deathstate
    S_NULL,         // xdeathstate
    sfx_None,       // deathsound
    0,              // speed
    8,              // radius
    8,              // height
    10,             // mass
    0,              // damage
    sfx_None,       // activesound
    MF_NOBLOCKMAP,  // flags
    S_NULL          // crashstate
  },

  // For use with wind and current effects
  {	0, 10, // MT_PULL
    5002,           // doomednum                   //jff 5/11/98 deconflict
    S_TNT1,         // spawnstate                  // with DOSDoom
    1000,           // spawnhealth
    S_NULL,         // seestate
    sfx_None,       // seesound
    8,              // reactiontime
    sfx_None,       // attacksound
    S_NULL,         // painstate
    0,              // painchance
    sfx_None,       // painsound
    S_NULL,         // meleestate
    S_NULL,         // missilestate
    S_NULL,         // deathstate
    S_NULL,         // xdeathstate
    sfx_None,       // deathsound
    0,              // speed
    8,              // radius
    8,              // height
    10,             // mass
    0,              // damage
    sfx_None,       // activesound
    MF_NOBLOCKMAP,  // flags
    S_NULL          // crashstate
  },
#ifdef DOGS
  {	MC_REBEL, 10, // MT_DOGS	
    888,   // doomednum
    S_HMN1_STND,    // spawnstate
    500,   // spawnhealth
    S_HMN1_RUN1,    // seestate
    sfx_wpnup,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_HMN1_PAIN1,    // painstate
    250,    // painchance
    sfx_pespna,   // painsound
    0,    // meleestate
    S_HMN1_ATK1,    // missilestate
    S_HMN1_DTH1,    // deathstate
    S_HMN1_DTH9,   // xdeathstate
    sfx_rebdth,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_rebact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL|MF_FRIEND,   // flags
    S_NULL   // crashstate
  },
#endif

};

#ifndef NO_PREDEFINED_LUMPS
// ********************************************************************
// Predefined lumps
// ********************************************************************
//kaiser
static const unsigned char life_b[]=
{
	2, 0, 2, 0, 0, 0, 0, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 2, 0, 112, 115,
		0, 255, 0, 2, 0, 112, 115, 0, 255,
};

static const unsigned char life_g[]=
{
	2, 0, 2, 0, 0, 0, 0, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 2, 0, 96, 99,
		0, 255, 0, 2, 0, 96, 99, 0, 255,
};

static const unsigned char life_m[]=
{
	2, 0, 2, 0, 0, 0, 0, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 2, 0, 80, 83,
		0, 255, 0, 2, 0, 80, 83, 0, 255,
};

static const unsigned char life_r[]=
{
	2, 0, 2, 0, 0, 0, 0, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 2, 0, 64, 67,
		0, 255, 0, 2, 0, 64, 67, 0, 255,
};

static const unsigned char s_data[] = {
0xBF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x04,0x03,0x00,0x00,0x2A,0x03,0x00,0x00,
0x50,0x03,0x00,0x00,0x76,0x03,0x00,0x00,0x9C,0x03,0x00,0x00,0xC2,0x03,0x00,0x00,
0xE8,0x03,0x00,0x00,0x0E,0x04,0x00,0x00,0x34,0x04,0x00,0x00,0x5A,0x04,0x00,0x00,
0x80,0x04,0x00,0x00,0xA6,0x04,0x00,0x00,0xCC,0x04,0x00,0x00,0xF2,0x04,0x00,0x00,
0x18,0x05,0x00,0x00,0x41,0x05,0x00,0x00,0x6A,0x05,0x00,0x00,0x90,0x05,0x00,0x00,
0xB6,0x05,0x00,0x00,0xDC,0x05,0x00,0x00,0x02,0x06,0x00,0x00,0x28,0x06,0x00,0x00,
0x4E,0x06,0x00,0x00,0x77,0x06,0x00,0x00,0xA0,0x06,0x00,0x00,0xC9,0x06,0x00,0x00,
0xF2,0x06,0x00,0x00,0x1B,0x07,0x00,0x00,0x44,0x07,0x00,0x00,0x70,0x07,0x00,0x00,
0x96,0x07,0x00,0x00,0xBC,0x07,0x00,0x00,0xE2,0x07,0x00,0x00,0x08,0x08,0x00,0x00,
0x31,0x08,0x00,0x00,0x57,0x08,0x00,0x00,0x7D,0x08,0x00,0x00,0xA3,0x08,0x00,0x00,
0xC9,0x08,0x00,0x00,0xEF,0x08,0x00,0x00,0x15,0x09,0x00,0x00,0x3B,0x09,0x00,0x00,
0x61,0x09,0x00,0x00,0x8A,0x09,0x00,0x00,0xB0,0x09,0x00,0x00,0xD9,0x09,0x00,0x00,
0xFF,0x09,0x00,0x00,0x25,0x0A,0x00,0x00,0x4B,0x0A,0x00,0x00,0x7A,0x0A,0x00,0x00,
0xA0,0x0A,0x00,0x00,0xCF,0x0A,0x00,0x00,0xF5,0x0A,0x00,0x00,0x2A,0x0B,0x00,0x00,
0x50,0x0B,0x00,0x00,0x7F,0x0B,0x00,0x00,0xA5,0x0B,0x00,0x00,0xCB,0x0B,0x00,0x00,
0xF1,0x0B,0x00,0x00,0x17,0x0C,0x00,0x00,0x40,0x0C,0x00,0x00,0x6C,0x0C,0x00,0x00,
0x92,0x0C,0x00,0x00,0xB8,0x0C,0x00,0x00,0xDE,0x0C,0x00,0x00,0x04,0x0D,0x00,0x00,
0x2A,0x0D,0x00,0x00,0x50,0x0D,0x00,0x00,0x76,0x0D,0x00,0x00,0x9C,0x0D,0x00,0x00,
0xC2,0x0D,0x00,0x00,0xE8,0x0D,0x00,0x00,0x0E,0x0E,0x00,0x00,0x34,0x0E,0x00,0x00,
0x5A,0x0E,0x00,0x00,0x80,0x0E,0x00,0x00,0xA6,0x0E,0x00,0x00,0xCC,0x0E,0x00,0x00,
0xF2,0x0E,0x00,0x00,0x18,0x0F,0x00,0x00,0x3E,0x0F,0x00,0x00,0x64,0x0F,0x00,0x00,
0x8A,0x0F,0x00,0x00,0xB0,0x0F,0x00,0x00,0xDC,0x0F,0x00,0x00,0x02,0x10,0x00,0x00,
0x2E,0x10,0x00,0x00,0x54,0x10,0x00,0x00,0x80,0x10,0x00,0x00,0xA6,0x10,0x00,0x00,
0xD5,0x10,0x00,0x00,0xFB,0x10,0x00,0x00,0x21,0x11,0x00,0x00,0x47,0x11,0x00,0x00,
0x6D,0x11,0x00,0x00,0x93,0x11,0x00,0x00,0xB9,0x11,0x00,0x00,0xDF,0x11,0x00,0x00,
0x05,0x12,0x00,0x00,0x2B,0x12,0x00,0x00,0x51,0x12,0x00,0x00,0x77,0x12,0x00,0x00,
0x9D,0x12,0x00,0x00,0xC3,0x12,0x00,0x00,0xE9,0x12,0x00,0x00,0x0F,0x13,0x00,0x00,
0x35,0x13,0x00,0x00,0x5B,0x13,0x00,0x00,0x81,0x13,0x00,0x00,0xA7,0x13,0x00,0x00,
0xD3,0x13,0x00,0x00,0xF9,0x13,0x00,0x00,0x28,0x14,0x00,0x00,0x51,0x14,0x00,0x00,
0x83,0x14,0x00,0x00,0xA9,0x14,0x00,0x00,0xD5,0x14,0x00,0x00,0xFB,0x14,0x00,0x00,
0x21,0x15,0x00,0x00,0x47,0x15,0x00,0x00,0x6D,0x15,0x00,0x00,0x99,0x15,0x00,0x00,
0xBF,0x15,0x00,0x00,0xE5,0x15,0x00,0x00,0x0B,0x16,0x00,0x00,0x31,0x16,0x00,0x00,
0x57,0x16,0x00,0x00,0x7D,0x16,0x00,0x00,0xA3,0x16,0x00,0x00,0xC9,0x16,0x00,0x00,
0xEF,0x16,0x00,0x00,0x15,0x17,0x00,0x00,0x3B,0x17,0x00,0x00,0x61,0x17,0x00,0x00,
0x87,0x17,0x00,0x00,0xAD,0x17,0x00,0x00,0xD3,0x17,0x00,0x00,0xFC,0x17,0x00,0x00,
0x25,0x18,0x00,0x00,0x4B,0x18,0x00,0x00,0x71,0x18,0x00,0x00,0x97,0x18,0x00,0x00,
0xBD,0x18,0x00,0x00,0xE3,0x18,0x00,0x00,0x09,0x19,0x00,0x00,0x35,0x19,0x00,0x00,
0x61,0x19,0x00,0x00,0x8D,0x19,0x00,0x00,0xB3,0x19,0x00,0x00,0xD9,0x19,0x00,0x00,
0x05,0x1A,0x00,0x00,0x31,0x1A,0x00,0x00,0x57,0x1A,0x00,0x00,0x7D,0x1A,0x00,0x00,
0xA3,0x1A,0x00,0x00,0xC9,0x1A,0x00,0x00,0xF2,0x1A,0x00,0x00,0x18,0x1B,0x00,0x00,
0x3E,0x1B,0x00,0x00,0x64,0x1B,0x00,0x00,0x8A,0x1B,0x00,0x00,0xB0,0x1B,0x00,0x00,
0xD6,0x1B,0x00,0x00,0xFC,0x1B,0x00,0x00,0x22,0x1C,0x00,0x00,0x48,0x1C,0x00,0x00,
0x6E,0x1C,0x00,0x00,0x94,0x1C,0x00,0x00,0xBA,0x1C,0x00,0x00,0xE0,0x1C,0x00,0x00,
0x06,0x1D,0x00,0x00,0x2C,0x1D,0x00,0x00,0x52,0x1D,0x00,0x00,0x78,0x1D,0x00,0x00,
0x9E,0x1D,0x00,0x00,0xC7,0x1D,0x00,0x00,0xED,0x1D,0x00,0x00,0x13,0x1E,0x00,0x00,
0x39,0x1E,0x00,0x00,0x5F,0x1E,0x00,0x00,0x85,0x1E,0x00,0x00,0xAB,0x1E,0x00,0x00,
0xD1,0x1E,0x00,0x00,0xF7,0x1E,0x00,0x00,0x20,0x1F,0x00,0x00,0x46,0x1F,0x00,0x00,
0x6C,0x1F,0x00,0x00,0x92,0x1F,0x00,0x00,0xB8,0x1F,0x00,0x00,0xDE,0x1F,0x00,0x00,
0x04,0x20,0x00,0x00,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,
0x00,0x00,0x00,0x00,0x9E,0x9E,0x00,0x00,0x00,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x9E,0x92,0x92,0x9B,0x6F,0x00,0x00,0x92,
0x9C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x92,0x92,
0x92,0x92,0x9C,0x00,0x00,0x92,0x92,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,
0x00,0x00,0x00,0x00,0x92,0x9B,0x9E,0x92,0x92,0x9E,0x9E,0x00,0x92,0x9C,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x92,0x9C,0x6E,0x00,0x92,0x92,
0x9D,0x9C,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,
0x92,0x92,0x9C,0x00,0x00,0x92,0x92,0x92,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x92,0x9E,0x00,0x00,0x9E,0x92,0x92,0x9D,0x9E,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x9E,0x00,0x00,
0x00,0x00,0x9E,0x00,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x6F,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x9A,0x98,0x99,0x9A,0x99,0x9E,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,
0x92,0x92,0x92,0x92,0x92,0x00,0x0B,0x16,0x00,0x6E,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0x00,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,0x93,0x94,0x93,0x92,0x92,0x92,0x00,
0x0C,0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,
0x00,0x00,0x9E,0x00,0x6E,0x9D,0x6E,0x92,0x92,0x9E,0x6F,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x9A,0x98,0x99,0x9A,0x99,0x92,0x93,0x9D,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,
0x92,0x92,0x92,0x93,0x9D,0x6E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,
0x00,0x00,0x00,0x00,0x93,0x94,0x93,0x92,0x93,0x9E,0x9F,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x00,0x9F,0x9D,0x9E,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x6F,0x9F,0x00,0x00,0x00,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x6F,0x00,0x00,0x00,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x14,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x96,0x96,0x6F,0x6F,0x00,0x96,0x6F,0x00,0x00,
0x00,0x00,0x00,0x00,0x6F,0x00,0x15,0x0C,0x00,0x96,0x9D,0x00,0x00,0x00,0x96,0x6E,
0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x06,0x1B,0x00,0x92,0x92,0x96,0x9E,0x00,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,
0x96,0x92,0x92,0x95,0x9E,0x00,0x00,0x92,0x95,0x9F,0x00,0x00,0x00,0x00,0x00,0xFF,
0x00,0x1A,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x95,0x96,0x92,0x9C,0x00,0x92,0x9D,
0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x95,0x96,0x92,0x95,0x6E,0x9F,0x00,0x1B,0x06,
0x00,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x16,0x00,0x00,0x00,0x00,0x00,
0x00,0x92,0x9C,0x6F,0x92,0x9D,0x6E,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0x00,0x92,
0x9C,0x6E,0x00,0x17,0x0A,0x00,0x92,0x96,0x9E,0x6E,0x92,0x9D,0x00,0x00,0x00,0x00,
0x00,0xFF,0x00,0x17,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9D,0x00,0x92,0x96,0x95,
0x92,0x9D,0x6F,0x00,0x00,0x00,0x00,0x00,0x92,0x95,0x9E,0x00,0x00,0x18,0x09,0x00,
0x92,0x96,0x95,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x13,0x00,0x00,0x00,
0x00,0x00,0x00,0x92,0x9D,0x00,0x96,0x92,0x92,0x96,0x9E,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x14,0x0D,0x00,0x92,0x9D,0x00,0x00,0x96,0x92,0x92,0x96,0x9E,0x00,0x00,
0x00,0x00,0x00,0xFF,0x00,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x96,0x6F,0x00,0x6F,
0x96,0x00,0x0B,0x0F,0x00,0x9E,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x96,0x6F,
0x00,0x00,0x6F,0x96,0x00,0x1B,0x06,0x00,0x9E,0x6F,0x00,0x00,0x00,0x00,0x00,0xFF,
0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x6F,0x00,0x00,0x00,0x6F,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6F,0x00,0x00,0x00,0x00,0x6F,0x00,0x6F,0x00,
0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9F,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,
0x00,0x00,0x9E,0x00,0x94,0x9C,0x6E,0x00,0x9F,0x9D,0x6F,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x6F,0x00,0x00,0x94,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,
0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x93,0x94,0x92,0x92,0x92,0x93,0x93,0x92,
0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x94,0x9D,0x00,0x94,0x92,0x92,
0x92,0x9E,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x19,0x00,0x00,0x00,0x00,0x92,0x92,
0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x92,0x9D,0x6F,0x92,0x00,0x1A,0x07,0x00,0x9A,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,
0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x9A,0x98,0x92,0x98,0x99,0x98,0x99,0x9A,0x92,
0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9B,0x6E,0x92,0x9C,0x9D,0x92,
0x9C,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x6F,0x92,
0x9C,0x00,0x6F,0x6F,0x00,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,
0x92,0x93,0x92,0x93,0x92,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,
0x00,0x00,0x00,0x00,0x00,0x92,0x9E,0x00,0x00,0x00,0x00,0x92,0x9D,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x99,0x92,0x92,0x92,0x92,0x92,0x92,0x9C,0x00,0x00,0x00,
0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x99,0x00,0x00,0x00,0x00,
0x00,0x9A,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9A,0x99,0x98,0x99,
0x9A,0x99,0x6E,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x6F,0x6F,0x00,0x00,0x6F,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x6F,0x6F,0x6F,0x6F,0x6F,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,
0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x9A,0x98,0x99,0x9A,0x99,0x98,0x99,0x6F,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9A,0x98,0x99,0x9A,0x99,0x98,0x99,0x6F,0x00,
0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x92,
0x92,0x92,0x92,0x92,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x92,
0x92,0x92,0x92,0x92,0x9E,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,
0x00,0x00,0x00,0x93,0x93,0x92,0x92,0x92,0x93,0x93,0x9D,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x92,0x92,0x93,0x92,0x92,0x93,0x93,0x9D,0x00,0x00,0x00,0x00,0x00,
0xFF,0x00,0x16,0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x99,0x94,0x9C,0x9E,0x00,0x9F,
0x6E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x00,0x17,0x0A,0x00,0x99,0x98,
0x99,0x99,0x6E,0x9F,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,
0x00,0x00,0x9A,0x92,0x9E,0x6E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x92,0x92,0x93,0x93,0x93,0x93,0x6E,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0x00,0x16,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x9D,0x6F,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x00,0x17,0x0A,0x00,0x98,0x99,0x99,
0x98,0x98,0x6F,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,
0x00,0x93,0x94,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x93,0x92,0x92,0x92,0x92,0x92,0x92,0x9E,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,
0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x00,0x9F,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x94,0x93,0x92,0x93,0x93,0x93,0x9D,0x00,
0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6F,0x00,
0x00,0x00,0x00,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9F,0x6E,
0x9D,0x9E,0x6E,0x9F,0x6E,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x05,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x06,0x0F,0x00,0x9E,0x00,0x00,0x00,0x00,0x96,0x6F,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x16,0x02,0x00,0x95,0x96,0x00,0x19,0x08,0x00,
0x96,0x95,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x6F,
0x9F,0x00,0x92,0x9C,0x6E,0x00,0x6F,0x6E,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x92,0x92,0x92,0x92,0x92,0x92,0x95,0x6E,0x00,0x00,0x00,0x00,0x00,0xFF,
0x00,0x08,0x00,0x00,0x00,0x96,0x96,0x6F,0x92,0x95,0x95,0x00,0x09,0x0D,0x00,0x96,
0x95,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x96,0x00,0x17,0x03,0x00,
0x96,0x95,0x96,0x00,0x1B,0x06,0x00,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,
0x21,0x00,0x00,0x00,0x92,0x92,0x9D,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x9C,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6F,0x9F,0x6E,0x6E,0x9F,0x6E,0x92,0x9D,0x00,
0x00,0x00,0x00,0x00,0xFF,0x00,0x02,0x00,0x00,0x00,0x00,0x03,0x03,0x00,0x96,0x9E,
0x96,0x00,0x07,0x03,0x00,0x96,0x95,0x96,0x00,0x0B,0x0A,0x00,0x92,0x9D,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x16,0x02,0x00,0x95,0x96,0x00,0x19,0x08,0x00,
0x96,0x95,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,
0x00,0x6F,0x6F,0x00,0x00,0x6E,0x9F,0x00,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x9D,0x6F,0x00,0x00,0x00,0x00,0xFF,
0x00,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,
0x0A,0x00,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x96,0x00,0x17,0x03,0x00,
0x96,0x95,0x96,0x00,0x1B,0x06,0x00,0x96,0x9E,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,
0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6F,0x00,0x6F,0x6E,0x9F,0x00,0x00,0x6F,0x00,
0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9F,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x9E,
0x00,0x9F,0x9D,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,
0x00,0x00,0x00,0x9F,0x9D,0x93,0x9E,0x9F,0x9D,0x6E,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x93,0x93,0x93,0x93,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x9E,0x94,0x93,0x92,0x92,0x93,0x93,0x92,0x92,
0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x94,0x92,0x92,0x92,0x92,0x92,0x92,
0x9E,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x19,0x00,0x00,0x00,0x00,0x93,0x92,0x92,
0x92,0x92,0x92,0x92,0x92,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,
0x98,0x99,0x92,0x00,0x1A,0x07,0x00,0x9A,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0xFF,
0x00,0x04,0x00,0x00,0x00,0x00,0x92,0x00,0x05,0x03,0x00,0x99,0x9A,0x92,0x00,0x09,
0x18,0x00,0x99,0x9A,0x99,0x6E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9B,
0x6E,0x92,0x9C,0x00,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,
0x00,0x00,0x92,0x9C,0x6F,0x00,0x92,0x9C,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x92,0x92,0x93,0x92,0x9C,0x00,0x92,0x9D,0x00,0x00,0x00,0x00,
0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x92,0x9D,0x00,0x00,0x92,0x9C,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x99,0x92,0x92,0x92,0x9E,0x00,
0x9A,0x9E,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x9A,0x9E,
0x00,0x00,0x9A,0x6E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x9A,0x99,0x98,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x9E,0x00,
0x9E,0x9D,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x92,0x92,0x92,0x92,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x92,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9E,0x00,0x00,0x00,0x00,0x00,0xFF,
0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x9E,
0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9C,0x9E,0x9D,0x9E,0x00,0x9E,0x9D,0x92,0x9C,
0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9C,
0x6E,0x92,0x9B,0x00,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x92,0x92,
0x92,0x92,0x92,0x92,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,
0x00,0x00,0x00,0x00,0x92,0x9B,0x9E,0x92,0x9C,0x00,0x92,0x9D,0x00,0x00,0x00,0x00,
0x00,0x00,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x9C,0x00,0x00,0x00,0x00,
0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x92,0x92,0x9D,0x6F,
0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9C,0x9E,0x00,0x9E,0x9D,0x9E,0x00,
0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,
0x9E,0x92,0x92,0x92,0x9E,0x00,0x00,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x9D,0x6F,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x00,0x00,
0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x6F,0x00,0x00,0x6E,0x9F,0x00,0x6F,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x96,0x6F,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x96,0x00,0x15,0x03,0x00,0x96,0x95,0x96,0x00,0x19,
0x08,0x00,0x96,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x95,0x9E,0x00,0x00,0x00,0x00,0x00,
0x00,0xFF,0x00,0x13,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9D,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x02,0x00,0x95,0x96,0x00,0x17,
0x0A,0x00,0x96,0x95,0x96,0x92,0x95,0x6E,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x6F,0x9F,0x6E,0x6E,0x9F,0x6E,0x6E,0x92,0x92,0x9D,0x00,0x00,
0x00,0x00,0x00,0xFF,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9D,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x96,0x00,0x15,0x03,0x00,0x96,
0x95,0x96,0x00,0x19,0x08,0x00,0x96,0x92,0x95,0x9E,0x00,0x00,0x00,0x00,0x00,0xFF,
0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9C,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x96,0x9E,0x6F,
0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x08,0x0B,0x00,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x14,0x02,0x00,0x95,0x96,0x00,0x17,0x0A,0x00,0x96,0x95,0x96,0x6F,0x6F,0x00,0x00,
0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9F,0x6F,0x00,0x6F,
0x6E,0x9F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x6F,0x00,0x00,0x00,0x00,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x94,0x9D,0x00,0x00,0x00,0x00,0x93,
0x9F,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x9E,0x00,0x92,
0x9B,0x6E,0x00,0x9F,0x9D,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x93,0x93,0x9E,0x92,0x92,0x92,0x93,0x93,0x92,0x92,0x9C,0x00,0x00,0x00,
0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x9D,0x92,0x92,0x92,0x92,0x92,
0x92,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9A,0x99,
0x6E,0x99,0x9A,0x99,0x98,0x99,0x9A,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,
0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6F,0x6F,0x00,0x92,0x9D,0x00,
0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x9A,0x9E,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x9E,0x00,0x9E,0x9D,0x6F,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9E,
0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x92,0x92,0x92,0x92,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9E,0x00,
0x00,0x00,0x00,0x00,0x00,0x92,0x9E,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,
0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x9E,0x00,0x00,0x00,
0x00,0x00,0x00,0x92,0x9C,0x9E,0x9D,0x9E,0x00,0x9E,0x9D,0x92,0x9C,0x00,0x00,0x00,
0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9C,0x9E,0x9D,0x9E,
0x00,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x92,0x92,0x92,0x92,0x92,
0x92,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,
0x00,0x92,0x9B,0x6F,0x00,0x00,0x9E,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x92,
0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,
0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x9E,0x00,0x00,0x92,0x92,0x9C,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x9C,0x9E,0x00,0x9E,0x9D,0x9E,0x00,0x92,0x9D,0x00,
0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x92,0x9D,
0x6F,0x00,0x92,0x9D,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x9E,0x00,0x00,0x00,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x00,0x00,0x00,0x00,0x00,
0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9F,0x6F,0x00,0x6F,0x6E,0x9F,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6F,
0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x06,0x02,0x00,0x95,0x96,0x00,0x09,0x18,0x00,0x96,0x95,0x96,0x6F,0x00,0x00,0x00,
0x00,0x00,0x00,0x96,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x96,0x6F,0x00,0x00,0x00,
0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x92,0x92,0x92,
0x92,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9D,0x6F,0x6E,0x9F,0x00,0x6F,
0x6E,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x06,0x00,0x00,0x00,0x00,0x00,
0x00,0x96,0x00,0x07,0x03,0x00,0x92,0x95,0x95,0x00,0x0B,0x0D,0x00,0x96,0x9E,0x00,
0x00,0x00,0x00,0x00,0x00,0x92,0x95,0x96,0x95,0x96,0x00,0x19,0x08,0x00,0x96,0x95,
0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,
0x6F,0x96,0x00,0x08,0x19,0x00,0x9D,0x6E,0x00,0x6F,0x6F,0x00,0x00,0x00,0x00,0x00,
0x00,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,
0xFF,0x00,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x0D,0x00,0x92,0x9E,0x6F,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x02,0x00,0x95,0x96,
0x00,0x17,0x03,0x00,0x96,0x95,0x96,0x00,0x1B,0x06,0x00,0x92,0x9D,0x00,0x00,0x00,
0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x9C,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9F,0x6F,0x00,0x6F,0x6E,0x9F,
0x00,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x06,0x00,0x00,0x00,0x00,0x00,
0x00,0x96,0x00,0x07,0x14,0x00,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x05,0x00,0x9E,0x00,
0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x6F,0x00,0x6F,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x9E,0x9E,0x00,0x9F,0x9D,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x93,0x93,0x93,0x93,0x92,0x9D,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6F,0x00,0x00,0x94,0x92,0x9D,
0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x94,
0x92,0x92,0x92,0x92,0x92,0x92,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x94,
0x9D,0x00,0x94,0x92,0x92,0x92,0x9E,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x09,0x00,
0x00,0x00,0x00,0x00,0x00,0x92,0x98,0x99,0x92,0x00,0x0A,0x0F,0x00,0x9A,0x92,0x9D,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9D,0x6F,0x92,0x00,0x1A,0x07,0x00,
0x9A,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,
0x00,0x92,0x9B,0x6E,0x92,0x9C,0x00,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x92,0x9B,0x6E,0x92,0x9C,0x9D,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,
0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x93,0x92,0x9C,0x00,0x92,0x9D,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x93,0x92,0x93,0x92,0x92,0x9D,0x00,
0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x99,0x92,0x92,
0x92,0x9E,0x00,0x9A,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x99,0x92,0x92,
0x92,0x92,0x92,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x9A,0x99,0x98,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x9A,0x99,0x98,0x99,0x9A,0x99,0x6E,0x00,0x00,0x00,0x00,0x00,
0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6F,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6F,0x6F,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x9C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x9C,0x9E,0x00,0x9E,0x9D,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x00,0x00,0x92,0x92,0x9C,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x9E,0x00,0x00,0x00,
0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9D,0x00,0x92,0x92,
0x92,0x92,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x92,0x92,0x92,
0x92,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,
0x00,0x92,0x9C,0x00,0x92,0x9B,0x6F,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x9E,0x9E,0x92,0x9B,0x9E,0x00,0x9E,0x9F,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,
0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9B,0x9E,0x92,0x9C,0x9D,0x92,0x9D,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9E,0x9E,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x92,
0x92,0x92,0x92,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x9C,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,
0x00,0x00,0x00,0x9E,0x92,0x92,0x92,0x92,0x92,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x92,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x9D,0x9E,0x00,0x9E,
0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x00,0x9E,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x6F,0x6F,0x00,0x00,0x6F,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,
0x00,0x00,0x00,0x00,0x00,0x9A,0x9E,0x6F,0x00,0x00,0x6F,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x9A,0x98,0x99,0x9A,0x99,0x98,0x99,0x6F,0x00,0x00,0x00,
0x00,0x00,0xFF,0x00,0x06,0x00,0x00,0x00,0x00,0x99,0x9A,0x92,0x00,0x07,0x1A,0x00,
0x99,0x9A,0x99,0x98,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,
0x92,0x92,0x92,0x92,0x92,0x9E,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x0B,0x00,0x00,
0x00,0x00,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x00,0x0C,0x15,0x00,0x6F,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x93,0x93,0x92,0x92,0x92,0x93,0x93,0x9D,0x00,
0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x94,0x92,0x92,0x93,0x93,
0x92,0x92,0x93,0x92,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x99,0x94,
0x9C,0x9E,0x00,0x9F,0x6E,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,
0x00,0x00,0x9E,0x92,0x9C,0x9F,0x9D,0x6E,0x00,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x9A,0x92,0x9E,0x6E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9D,0x00,0x00,0x00,0x00,0x92,
0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x9D,0x6F,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x93,
0x9F,0x00,0x00,0x00,0x00,0x94,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x93,
0x94,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,
0x00,0x00,0x00,0x00,0x00,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x6F,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x9E,0x00,0x9F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6F,0x9F,0x00,0x6F,
0x6E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6F,0x9F,0x00,0x6F,
0x6E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x08,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x96,0x96,0x00,0x09,0x0F,0x00,0x96,0x95,0x9E,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x96,0x96,0x00,0x19,0x08,0x00,0x96,0x95,0x9E,0x00,0x00,
0x00,0x00,0x00,0x00,0xFF,0x00,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x0F,
0x00,0x92,0x92,0x92,0x92,0x92,0x95,0x6E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x16,0x0B,0x00,0x92,0x92,0x92,0x92,0x92,0x95,0x6E,0x00,0x00,0x00,0x00,0x00,
0xFF,0x00,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x95,0x96,0x92,0x95,0x00,0x0B,
0x0F,0x00,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x95,0x96,0x92,
0x95,0x00,0x1B,0x06,0x00,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,
0x00,0x00,0x00,0x00,0x00,0x92,0x9C,0x6E,0x92,0x9C,0x00,0x92,0x9D,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x92,0x9C,0x6E,0x92,0x9C,0x00,0x92,0x9D,0x00,0x00,0x00,
0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x95,0x96,0x92,0x9C,
0x00,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x95,0x96,0x92,0x9C,
0x00,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x0B,0x00,0x00,0x00,0x00,0x00,
0x00,0x96,0x92,0x92,0x92,0x9D,0x00,0x00,0x0C,0x0F,0x00,0x9E,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x96,0x92,0x92,0x92,0x9D,0x00,0x00,0x1C,0x05,0x00,0x9E,0x00,
0x00,0x00,0x00,0x00,0xFF,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x6F,0x00,0x07,
0x0F,0x00,0x96,0x95,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x6F,0x00,0x17,0x0A,0x00,0x96,0x95,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6E,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6E,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x9E,0x9E,0x00,0x9F,0x9D,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x93,0x93,0x93,0x93,0x92,0x9D,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x6F,0x00,0x00,0x94,0x92,0x9D,0x00,0x00,0x00,0x00,
0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x94,0x92,0x92,0x92,0x92,
0x92,0x92,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x94,0x9D,0x00,0x94,0x92,
0x92,0x92,0x9E,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x19,0x00,0x00,0x00,0x00,0x00,
0x00,0x92,0x98,0x99,0x98,0x99,0x9A,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x92,0x9D,0x6F,0x92,0x00,0x1A,0x07,0x00,0x9A,0x92,0x9D,0x00,0x00,0x00,0x00,
0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x9E,0x00,0x92,0x9B,0x6E,0x6F,0x6E,0x9D,
0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9B,0x6E,0x92,0x9C,0x9D,
0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x93,0x94,
0x92,0x92,0x92,0x93,0x93,0x92,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x92,0x92,0x93,0x92,0x93,0x92,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,
0x00,0x00,0x00,0x00,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x9C,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x99,0x92,0x92,0x92,0x92,0x92,0x92,0x9C,0x00,0x00,
0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x9A,0x98,0x99,0x9A,0x99,0x98,
0x99,0x9A,0x99,0x6E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9A,0x99,0x98,
0x99,0x9A,0x99,0x6E,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,
0x00,0x6F,0x6F,0x00,0x00,0x6F,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x6F,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x00,
0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x9E,0x00,0x00,
0x00,0x00,0x00,0x00,0x92,0x9E,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x92,0x9C,0x9E,0x9D,0x9E,0x00,0x9E,0x9D,0x92,0x9C,0x00,0x00,0x00,0x00,
0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,
0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,
0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x9C,0x9E,0x00,0x9E,0x9D,0x9E,0x00,0x92,0x9D,0x00,0x00,
0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x00,0x00,0x00,0x00,0x00,0xFF,
0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6F,0x6F,0x00,0x00,0x6F,0x6F,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x99,0x9A,0x99,0x98,
0x99,0x9A,0x99,0x98,0x99,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,
0x00,0x00,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x9E,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x94,0x92,0x92,0x93,0x93,0x92,0x92,0x93,
0x92,0x9C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x9E,
0x92,0x9C,0x6E,0x9D,0x6E,0x6F,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x06,
0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x00,0x07,0x1A,0x00,0x99,0x9A,0x99,0x98,0x92,
0x9C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x93,
0x92,0x92,0x92,0x92,0x92,0x93,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,
0x00,0x00,0x00,0x00,0x00,0x9E,0x94,0x93,0x92,0x93,0x93,0x9D,0x6F,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6F,0x9D,0x9E,
0x00,0x9F,0x00,0x00,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x9E,0x9E,0x00,0x6F,0x9D,0x6F,0x00,0x00,0x93,0x6E,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,
0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x94,0x92,0x93,0x93,0x93,0x92,0x9D,0x00,0x00,
0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x92,
0x92,0x92,0x92,0x92,0x9E,0x00,0x92,0x9D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,
0x00,0x00,0x00,0x99,0x9A,0x99,0x98,0x99,0x9A,0x92,0x9D,0x93,0x92,0x9C,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x9E,0x9E,0x6F,0x6E,0x9D,0x92,
0x93,0x92,0x99,0x9E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x0D,0x00,0x00,0x00,0x00,0x00,0x00,0x94,
0x92,0x93,0x93,0x93,0x92,0x92,0x92,0x00,0x0E,0x13,0x00,0x6F,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x92,0x92,0x92,0x92,0x92,0x98,0x98,
0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x99,0x9A,
0x99,0x98,0x99,0x9A,0x9E,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6F,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x21,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xFF,0x00,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF
};

const lumpinfo_t predefined_lumps[]=
{
  { "LIFE_B",  sizeof life_b,  life_b},
  { "LIFE_G",  sizeof life_g,  life_g},
  { "LIFE_M",  sizeof life_m,  life_m},
  { "LIFE_R",  sizeof life_r,  life_r},
  { "XKXSXVX", sizeof s_data,  s_data},	//ignore this

};

// Calculate how many of them there are
const size_t num_predefined_lumps =
  sizeof predefined_lumps / sizeof *predefined_lumps;
#endif

