/* Emacs style mode select   -*- C++ -*-
 *-----------------------------------------------------------------------------
 *
 * $Id: info.h,v 1.4.2.1 2002/07/20 18:08:35 proff_fs Exp $
 *
 *  PrBoom a Doom port merged with LxDoom and LSDLDoom
 *  based on BOOM, a modified and improved DOOM engine
 *  Copyright (C) 1999 by
 *  id Software, Chi Hoang, Lee Killough, Jim Flynn, Rand Phares, Ty Halderman
 *  Copyright (C) 1999-2000 by
 *  Jess Haas, Nicolas Kalkhof, Colin Phipps, Florian Schulze
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 *  02111-1307, USA.
 *
 * DESCRIPTION:
 *      Thing frame/state LUT,
 *      generated by multigen utilitiy.
 *      This one is the original DOOM version, preserved.
 *
 *-----------------------------------------------------------------------------*/

#ifndef __INFO__
#define __INFO__

/* Needed for action function pointer handling. */
#include "d_think.h"

/********************************************************************
 * Sprite name enumeration - must match info.c                      *
 ********************************************************************/
typedef enum
{
  SPR_TNT1, /* add invisible sprite              phares 3/8/98 */

  //============Strife Sprites==============Kaiser
  SPR_PLAY,
  SPR_PNCH,
  SPR_WAVE,
  SPR_RBPY,
  SPR_TRGT,
  SPR_XBOW,
  SPR_MMIS,
  SPR_RIFG,
  SPR_RIFF,
  SPR_FLMT,
  SPR_FLMF,
  SPR_BLST,
  SPR_BLSF,
  SPR_GREN,
  SPR_GREF,
  SPR_SIGH,
  SPR_SIGF,
  SPR_POW1,
  SPR_POW2,
  SPR_POW3,
  SPR_ZAP1,
  SPR_SPRY,
  SPR_BLOD,
  SPR_PUFY,
  SPR_SHT1,
  SPR_SHT2,
  SPR_GRIN,
  SPR_GRAP,
  SPR_UBAM,
  SPR_BNG2,
  SPR_BNG4,
  SPR_BNG3,
  SPR_FLBE,
  SPR_XPRK,
  SPR_OCLW,
  SPR_CCLW,
  SPR_TEND,
  SPR_MICR,
  SPR_MISS,
  SPR_AROW,
  SPR_ARWP,
  SPR_TORP,
  SPR_THIT,
  SPR_TWAV,
  SPR_MISL,
  SPR_TFOG,
  SPR_IFOG,
  SPR_SHRD,
  SPR_RGIB,
  SPR_MRYS,
  SPR_MRNO,
  SPR_MRST,
  SPR_MRLK,
  SPR_MRBD,
  SPR_MRPN,
  SPR_MRGT,
  SPR_BURN,
  SPR_DISR,
  SPR_PEAS,
  SPR_GIBS,
  SPR_AGRD,
  SPR_ARMR,
  SPR_SACR,
  SPR_TNK1,
  SPR_TNK2,
  SPR_TNK3,
  SPR_TNK4,
  SPR_TNK5,
  SPR_TNK6,
  SPR_NEAL,
  SPR_BEGR,
  SPR_HMN1,
  SPR_LEDR,
  SPR_LEAD,
  SPR_ROB1,
  SPR_PGRD,
  SPR_ROB2,
  SPR_MLDR,
  SPR_ORCL,
  SPR_PRST,
  SPR_PDED,
  SPR_ALN1,
  SPR_AL1P,
  SPR_NODE,
  SPR_MTHD,
  SPR_MNAM,
  SPR_MNAL,
  SPR_MDTH,
  SPR_NEST,
  SPR_PODD,
  SPR_ZAP6,
  SPR_ZOT3,
  SPR_ZAP7,
  SPR_ZOT1,
  SPR_ZAP5,
  SPR_ZOT2,
  SPR_SEWR,
  SPR_SPID,
  SPR_ROB3,
  SPR_RBB3,
  SPR_PRGR,
  SPR_BASE,
  SPR_FRBL,
  SPR_KLAX,
  SPR_TURT,
  SPR_BALL,
  SPR_PSTN,
  SPR_SECR,
  SPR_TARG,
  SPR_RING,
  SPR_EARS,
  SPR_COMM,
  SPR_BOOM,
  SPR_RATT,
  SPR_HOGN,
  SPR_DEAD,
  SPR_SBAN,
  SPR_BOTR,
  SPR_HATR,
  SPR_TOPR,
  SPR_COUP,
  SPR_BUBB,
  SPR_BUBF,
  SPR_BUBC,
  SPR_ASPR,
  SPR_SPDL,
  SPR_TOKN,
  SPR_OTOK,
  SPR_HELT,
  SPR_GUNT,
  SPR_FULL,
  SPR_MEAT,
  SPR_JUNK,
  SPR_FFOT,
  SPR_DIE1,
  SPR_BEAC,
  SPR_ARM1,
  SPR_ARM2,
  SPR_BARW,
  SPR_BART,
  SPR_LAMP,
  SPR_LANT,
  SPR_BARL,
  SPR_BOWL,
  SPR_BRAZ,
  SPR_TRCH,
  SPR_LTRH,
  SPR_LMPC,
  SPR_LOGS,
  SPR_TRHO,
  SPR_WATR,
  SPR_MUGG,
  SPR_FUSL,
  SPR_CRD1,
  SPR_CRD2,
  SPR_TPAS,
  SPR_KY1G,
  SPR_KY2S,
  SPR_KY3B,
  SPR_HAND,
  SPR_CRYS,
  SPR_PRIS,
  SPR_PWR1,
  SPR_PWR2,
  SPR_PWR3,
  SPR_ORAC,
  SPR_GYID,
  SPR_FUBR,
  SPR_WARE,
  SPR_RCRY,
  SPR_BCRY,
  SPR_CHAP,
  SPR_TUNL,
  SPR_BLTK,
  SPR_SECK,
  SPR_MINE,
  SPR_REBL,
  SPR_PROC,
  SPR_ANKH,
  SPR_GOID,
  SPR_STMP,
  SPR_MDKT,
  SPR_COIN,
  SPR_CRED,
  SPR_SACK,
  SPR_CHST,
  SPR_SHD1,
  SPR_MASK,
  SPR_UNIF,
  SPR_OFIC,
  SPR_PMAP,
  SPR_PMUP,
  SPR_BLIT,
  SPR_BBOX,
  SPR_MSSL,
  SPR_ROKT,
  SPR_BRY1,
  SPR_CPAC,
  SPR_PQRL,
  SPR_XQRL,
  SPR_GRN1,
  SPR_GRN2,
  SPR_BKPK,
  SPR_RELC,
  SPR_RIFL,
  SPR_FLAM,
  SPR_BFLM,
  SPR_MMSL,
  SPR_TRPD,
  SPR_GRND,
  SPR_CBOW,
  SPR_SIGL,
  SPR_LITE,
  SPR_CNDL,
  SPR_CLBR,
  SPR_LITS,
  SPR_LITB,
  SPR_LITG,
  SPR_ROK1,
  SPR_ROK2,
  SPR_ROK3,
  SPR_ROK4,
  SPR_LOGG,
  SPR_RUB1,
  SPR_RUB2,
  SPR_RUB3,
  SPR_RUB4,
  SPR_RUB5,
  SPR_RUB6,
  SPR_RUB7,
  SPR_RUB8,
  SPR_CHAN,
  SPR_STAT,
  SPR_DSTA,
  SPR_CRAB,
  SPR_CAGE,
  SPR_TREE,
  SPR_TRE1,
  SPR_BUSH,
  SPR_SHRB,
  SPR_STAK,
  SPR_BAR1,
  SPR_VASE,
  SPR_STOL,
  SPR_POT1,
  SPR_TUB1,
  SPR_ANVL,
  SPR_TLMP,
  SPR_TRAY,
  SPR_APOW,
  SPR_AFED,
  SPR_DRIP,
  SPR_CDRP,
  SPR_SPLH,
  SPR_WTFT,
  SPR_HERT,
  SPR_TELP,
  SPR_MONI,
  SPR_STEL,
  SPR_STLA,
  SPR_STLE,
  SPR_HUGE,
  SPR_STLG,


#ifdef DOGS
  SPR_DOGS, /* killough 7/19/98: Marine's best friend :) */
#endif

  NUMSPRITES  /* counter of how many there are */

} spritenum_t;

/********************************************************************
 * States (frames) enumeration -- must match info.c                 *
 ********************************************************************/

typedef enum
{
  S_NULL,
  S_LIGHTDONE,
  S_UNKNOWN,	//kaiser
  S_UNKNOWN2,

  //Targeter
  S_TARGETER1,
  S_TARGETER2,
  S_TARGETER3,

  //weapon 1 - kaiser
  S_PUNCH,
  S_PUNCHDOWN,
  S_PUNCHUP,
  S_PUNCH1,
  S_PUNCH2,
  S_PUNCH3,
  S_PUNCH4,
  S_PUNCH5,
  S_PUFP1,
  S_PUFP2,
  S_PUFP3,
  S_PUFP4,
  S_PUFP5,

  //weapon 2 - kaiser
  S_XBOW,
  S_XBOWDOWN,
  S_XBOWUP,
  S_XBOW1,
  S_XBOW2,
  S_XBOW3,
  S_XBOW4,
  S_XBOW5,
  S_XBOW6,
  S_XBOW7,
  S_XBOWFLASH1,
  S_XBOWFLASH2,
  S_XBOWFLASH3,
  S_PXBOW,
  S_PXBOWDOWN,
  S_PXBOWUP,
  S_PXBOW1,
  S_PXBOW2,
  S_PXBOW3,
  S_PXBOW4,
  S_PXBOW5,
  S_PXBOW6,
  S_PXBOW7,
  S_EAROW1,
  S_PAROW1,
  S_ZAP1,
  S_ZAP2,
  S_ZAP3,
  S_ZAP4,
  S_ZAP5,
  S_ZAP6,
  S_ZAP7,
  S_ZAP8,
  S_ZAP9,
  S_ZAP10,
  S_ZAP11,
  S_PZAP1,

  //weapon 3 - kaiser
  S_RIFFLE,
  S_RIFFLEDOWN,
  S_RIFFLEUP,
  S_RIFFLE1,
  S_RIFFLE2,
  S_RIFFLE3,
  S_RIFFLE4,
  S_RIFFLE5,
  S_PUFY1,
  S_PUFY2,
  S_PUFY3,
  S_PUFY4,

  //weapon 4 - kaiser
  S_MMISSILE,
  S_MMISSILEDOWN,
  S_MMISSILEUP,
  S_MMISSILE1,
  S_MMISSILE2,
  S_MMISSILE3,
  S_MMISSILE4,
  S_MMISSILE5,
  S_MMISSILE6,
  S_MMISSILE7,
  S_MINIMISSLE,
  S_MISSILE_X1,
  S_MISSILE_X2,
  S_MISSILE_X3,
  S_MISSILE_X4,
  S_MISSILE_X5,
  S_MISSILE_X6,
  S_MISSILE_X7,

  //weapon 5 - kaiser
  S_SGRENADE,
  S_SGRENADEDOWN,
  S_SGRENADEUP,
  S_SGRENADE1,
  S_SGRENADE2,
  S_SGRENADE3,
  S_SGRENADE4,
  S_SGRENADE5,
  S_SGRENADEFLASH1,
  S_SGRENADEFLASH2,
  S_SGRENADEFLASH3,
  S_FGRENADE,
  S_FGRENADEDOWN,
  S_FGRENADEUP,
  S_FGRENADE1,
  S_FGRENADE2,
  S_FGRENADE3,
  S_FGRENADE4,
  S_FGRENADE5,
  S_FGRENADEFLASH1,
  S_FGRENADEFLASH2,
  S_FGRENADEFLASH3,
  S_GRENADE_HE_1,
  S_GRENADE_HE_2,
  S_GRENADE_P_1,
  S_GRENADE_P_2,
  S_GRENADE_HE_X1,
  S_GRENADE_HE_X2,
  S_GRENADE_HE_X3,
  S_GRENADE_HE_X4,
  S_GRENADE_HE_X5,
  S_GRENADE_HE_X6,
  S_GRENADE_HE_X7,
  S_GRENADE_HE_X8,
  S_GRENADE_HE_X9,
  S_GRENADE_HE_X10,
  S_GRENADE_HE_X11,
  S_GRENADE_HE_X12,
  S_GRENADE_HE_X13,
  S_GRENADE_HE_X14,
  S_GRENADE_P_X1,
  S_PFLAME1,
  S_PFLAME2,
  S_PFLAME3,
  S_PFLAME4,
  S_PFLAME5,
  S_PFLAME6,
  S_PFLAME7,
  S_PFLAME8,
  S_PFLAME9,
  S_PFLAMEEND1,
  S_PFLAMEEND2,
  S_PFLAMEEND3,
  S_PFLAMEEND4,


  //weapon 6 - kaiser
  S_FLAMEREADY1,
  S_FLAMEREADY2,
  S_FLAMEDOWN,
  S_FLAMEUP,
  S_FLAME1,
  S_FLAME2,
  S_FLAME3,
  S_FLAMEFX_1,
  S_FLAMEFX_2,
  S_FLAMEFX_3,
  S_FLAMEFX_X1,
  S_FLAMEFX_X2,
  S_FLAMEFX_X3,
  S_FLAMEFX_X4,
  S_FLAMEFX_X5,
  S_FLAMEFX_X6,

  //weapon 7 - kaiser
  S_BLASTER,
  S_BLASTERA,
  S_BLASTERB,
  S_BLASTERC,
  S_BLASTERDOWN,
  S_BLASTERUP,
  S_BLASTER1,
  S_BLASTER2,
  S_BLASTER3,
  S_BLASTER4,
  S_BLASTER5,
  S_BLASTER6,
  S_BLASTER7,
  S_BLASTER8,
  S_XBLASTER,
  S_XBLASTERA,
  S_XBLASTERB,
  S_XBLASTERC,
  S_XBLASTERDOWN,
  S_XBLASTERUP,
  S_XBLASTER1,
  S_XBLASTER2,
  S_XBLASTER3,
  S_XBLASTER4,
  S_XBLASTER5,
  S_XBLASTER6,
  S_XBLASTER7,
  S_PUFM1,
  S_PUFM2,
  S_PUFM3,
  S_PUFM4,
  S_PUFM5,
  S_PUFM6,
  S_PUFM7,
  S_TORPEDO_1,
  S_TORPEDO_2,
  S_TORPEDO_3,
  S_TORPEDO_4,
  S_TORPEDO_X1,
  S_TORPEDO_X2,
  S_TORPEDO_X3,
  S_TORPEDO_X4,
  S_TORPEDO_X5,
  S_TORPEDO_E1,
  S_TORPEDO_E2,
  S_TORPEDO_E3,

  //Waving Hands
  S_WAVE1,
  S_WAVE2,
  S_WAVE3,
  S_WAVE4,

  //Sigil
  S_SIGIL,
  S_SIGIL_B,
  S_SIGIL_C,
  S_SIGIL_D,
  S_SIGIL_E,
  S_SIGIL_UP,
  S_SIGIL_DOWN,
  S_SIGIL_1,
  S_SIGIL_2,
  S_SIGIL_3,
  S_SIGIL_4,
  S_SIGIL_F1,
  S_SIGIL_F2,
  S_SIGIL_F3,

  //weapon items
  S_CROSSBOWGUN,
  S_ASAULTGUN,
  S_ASAULTGUN2,
  S_MINIMISSILEGUN,
  S_GRENADEGUN,
  S_FLAMETHROWERGUN,
  S_BLASTERGUN,
  //ammo items
  S_ACLIP,
  S_AAMMOBOX,
  S_AAROW,
  S_APAROW,
  S_AMINI,
  S_AMINIBOX,
  S_AGREN,
  S_APGREN,
  S_ACELL1,
  S_ACELL2,
  S_APCELL1,
  S_APCELL2,
  //trees
  S_TREE1,
  S_TREE2,
  S_TREE3,
  S_TREE4,
  S_TREE5,
  S_TREE6,
  S_TREE7,
  S_TREE8,
  S_TREE9,
  S_TREE10,
  //rubble
  S_RUB1,
  S_RUB2,
  S_RUB3,
  S_RUB4,
  S_RUB5,
  S_RUB6,
  S_RUB7,
  S_RUB8,
  //cave
  S_CAVE1,
  S_CAVE2,
  S_CAVE3,
  S_CAVE4,
  S_CAVE5,
  S_CAVE6,
  S_CAVE7,
  //rocks
  S_ROCK1,
  S_ROCK2,
  S_ROCK3,
  S_ROCK4,
  //pillars
  S_PILLAR1,
  S_PILLAR2,
  S_PILLAR3,
  S_PILLAR4,
  S_PILLAR5,
  S_PILLAR6_1,
  S_PILLAR6_2,
  S_PILLAR6_3,
  S_PILLAR6_4,
  S_PILLAR7,
  S_PILLAR8,
  S_PILLAR9,
  S_PILLAR10,
  S_PILLAR11,
  S_PILLAR12,
  S_PILLAR13,
  //biological
  S_BIO1,
  S_BIO2_1,
  S_BIO2_2,
  S_BIO2_3,
  S_BIO3_1,
  S_BIO3_2,
  S_BIO3_3,
  S_BIO4_1,
  S_BIO4_2,
  S_BIO4_3,
  S_BIO5_1,
  S_BIO5_2,
  S_BIO5_3,
  S_BIO6_1,
  S_BIO6_2,
  S_BIO6_3,
  S_BIO7_1,
  S_BIO7_2,
  S_BIO7_3,
  S_BIO8_1,
  S_BIO8_2,
  S_BIO8_3,
  //Effects
  S_SHRD,
  S_SHRD_1,
  S_SHRD_2,
  S_SHRD_3,
  S_SHRD2,
  S_SHRD3,
  S_SHRD4,
  S_POW3_1,
  S_POW3_2,
  S_POW3_3,
  S_POW3_4,
  S_POW3_5,
  S_POW3_6,
  S_POW3_7,
  S_POW3_8,

  S_BLOOD_DEATH1,
  S_BLOOD_DEATH2,
  S_BLOOD_DEATH3,
  S_BLOOD_DEATH4,
  S_BLOOD_DEATH5,
  S_BLOOD_DEATH6,
  S_BLOOD_DEATH7,

  S_BLOOD1,
  S_BLOOD2,
  S_BLOOD3,
  S_MEAT_1,
  S_MEAT_2,
  S_MEAT_3,
  S_MEAT_4,
  S_MEAT_5,
  S_MEAT_6,
  S_MEAT_7,
  S_MEAT_8,
  S_MEAT_9,
  S_MEAT_10,
  S_MEAT_11,
  S_MEAT_12,
  S_MEAT_13,
  S_MEAT_14,
  S_MEAT_15,
  S_MEAT_16,
  S_MEAT_17,
  S_MEAT_18,
  S_MEAT_19,
  S_MEAT_20,
  S_JUNK_1,
  S_JUNK_2,
  S_JUNK_3,
  S_JUNK_4,
  S_JUNK_5,
  S_JUNK_6,
  S_JUNK_7,
  S_JUNK_8,
  S_JUNK_9,
  S_JUNK_10,
  S_JUNK_11,
  S_JUNK_12,
  S_JUNK_13,
  S_JUNK_14,
  S_JUNK_15,
  S_JUNK_16,
  S_JUNK_17,
  S_JUNK_18,
  S_JUNK_19,
  S_JUNK_20,
  S_BURN_1,
  S_BURN_2,
  S_BURN_3,
  S_BURN_4,
  S_BURN_5,
  S_BURN_6,
  S_BURN_7,
  S_BURN_8,
  S_BURN_9,
  S_BURN_10,
  S_BURN_11,
  S_BURN_12,
  S_BURN_13,
  S_BURN_14,
  S_BURN_15,
  S_BURN_16,
  S_BURN_17,
  S_BURN_18,
  S_BURN_19,
  S_BURN_20,
  S_BURN_21,
  S_BURN_22,
  S_BDROP_1,
  S_BDROP_2,
  S_BDROP_3,
  S_BDROP_4,
  S_DISR_1,
  S_DISR_2,
  S_DISR_3,
  S_DISR_4,
  S_DISR_5,
  S_DISR_6,
  S_DISR_7,
  S_DISR_8,
  S_DISR_9,
  S_DISR_10,
  //Lights
  S_LIGHT1,
  S_LIGHT2,
  S_LIGHT3,
  S_LIGHT4,
  S_LIGHT5,
  S_LIGHT6_1,
  S_LIGHT6_2,
  S_LIGHT6_3,
  S_LIGHT6_4,
  S_LIGHT7_1,
  S_LIGHT7_2,
  S_LIGHT7_3,
  S_LIGHT7_4,
  S_LIGHT8,
  S_LIGHT9_1,
  S_LIGHT9_2,
  S_LIGHT9_3,
  S_LIGHT9_4,
  S_LIGHT10_1,
  S_LIGHT10_2,
  S_LIGHT10_3,
  S_LIGHT10_4,
  S_LIGHT11_1,
  S_LIGHT11_2,
  S_LIGHT11_3,
  S_LIGHT11_4,
  S_LIGHT12,
  S_LIGHT13,
  S_LIGHT14,
  S_LIGHT15_1,
  S_LIGHT15_2,
  S_LIGHT15_3,
  S_LIGHT15_4,
  S_LIGHT16,
  S_LIGHT17,
  S_LIGHT18,
  S_LIGHT19_1,
  S_LIGHT19_2,
  S_LIGHT19_3,
  //Other
  S_MISC_01_1,
  S_MISC_01_2,
  S_MISC_01_3,
  S_MISC_02_1,
  S_MISC_02_2,
  S_MISC_02_3,
  S_MISC_02_4,
  S_MISC_03_1,
  S_MISC_03_2,
  S_MISC_03_3,
  S_MISC_03_4,
  S_MISC_03_5,
  S_MISC_03_6,
  S_MISC_03_7,
  S_MISC_03_8,
  S_MISC_04_1,
  S_MISC_04_2,
  S_MISC_04_3,
  S_MISC_04_4,
  S_MISC_05,
  S_MISC_05_1,
  S_MISC_05_2,
  S_MISC_05_3,
  S_MISC_05_4,
  S_MISC_05_5,
  S_MISC_05_6,
  S_MISC_05_7,
  S_MISC_06,
  S_MISC_06_1,
  S_MISC_06_2,
  S_MISC_06_3,
  S_MISC_06_4,
  S_MISC_06_5,
  S_MISC_06_6,
  S_MISC_06_7,
  S_MISC_06_8,
  S_MISC_06_9,
  S_MISC_06_10,
  S_MISC_06_11,
  S_MISC_07_1,
  S_MISC_07_2,
  S_MISC_07_3,
  S_MISC_07_4,
  S_MISC_08,
  S_MISC_09,
  S_MISC_10,
  S_MISC_11,
  S_MISC_12,
  S_MISC_13_1,
  S_MISC_13_2,
  S_MISC_13_3,
  S_MISC_13_4,
  S_MISC_13_5,
  S_MISC_13_6,
  S_MISC_13_7,
  S_MISC_13_8,
  S_MISC_14,
  S_MISC_15,
  S_MISC_15_1,
  S_MISC_15_2,
  S_MISC_16_1,
  S_MISC_16_2,
  S_MISC_16_SEE1,
  S_MISC_16_SEE2,
  S_MISC_16_PAIN1,
  S_MISC_16_PAIN2,
  S_MISC_16_PAIN3,
  S_MISC_16_DTH1,
  S_MISC_16_DTH2,
  S_MISC_16_DTH3,
  S_MISC_16_DTH4,
  S_MISC_16_DTH5,
  S_MISC_16_DTH6,
  S_MISC_16_DTH7,
  S_MISC_17,
  S_MISC_18,
  S_MISC_19,
  S_MISC_20,
  S_MISC_21,
  S_MISC_22,
  S_MISC_23,
  S_MISC_24,
  S_MISC_25,
  S_MISC_26,
  S_RAT1,
  S_RATSEE1,
  S_RATSEE2,
  S_RATSEE3,
  S_RATSEE4,
  //Guard1
  S_AGRD_STND,
  S_AGRD_STND2,
  S_AGRD_STND3,
  S_AGRD_WALK1,
  S_AGRD_WALK2,
  S_AGRD_WALK3,
  S_AGRD_WALK4,
  S_AGRD_WALK5,
  S_AGRD_WALK6,
  S_AGRD_WALK7,
  S_AGRD_WALK8,
  S_AGRD_RUN1,
  S_AGRD_RUN2,
  S_AGRD_RUN3,
  S_AGRD_RUN4,
  S_AGRD_ATK1,
  S_AGRD_ATK2,
  S_AGRD_ATK3,
  S_AGRD_ATK4,
  S_AGRD_PAIN,
  S_AGRD_DIE1,
  S_AGRD_DIE2,
  S_AGRD_DIE3,
  S_AGRD_DIE4,
  S_AGRD_DIE5,
  S_AGRD_DIE6,
  S_AGRD_DIE7,
  S_AGRD_DIE8,
  S_AGRD_XDIE1,
  S_AGRD_XDIE2,
  S_AGRD_XDIE3,
  S_AGRD_XDIE4,
  S_AGRD_XDIE5,
  S_AGRD_XDIE6,
  S_AGRD_XDIE7,
  S_AGRD_XDIE8,
  S_AGRD_XDIE9,
  S_AGRD_XDIE10,
  S_AGRD_XDIE11,
  S_AGRD_XDIE12,
  S_SAGRD_RUN1,
  S_SAGRD_PAIN,
  S_SAGRD_PAIN2,
  S_BECOMING_1,
  S_BECOMING_2,
  //Inventory
  S_INV_GOLD1,
  S_INV_GOLD10,
  S_INV_GOLD25,
  S_INV_GOLD50,
  S_INV_GOLD300,
  S_INV_CHALICE,
  S_INV_COMMUNICATOR,
  S_INV_TARGETER,
  S_INV_SATCHEL,
  S_INV_MED1,
  S_INV_MED2,
  S_INV_MED3_1,
  S_INV_MED3_2,
  S_INV_ARMOR1,
  S_INV_ARMOR2,
  S_INV_SHADOWARMOR,
  S_INV_SHADOWARMOR2,
  S_INV_SUIT,
  S_INV_SUPERMAP1,
  S_INV_SUPERMAP2,
  S_INV_RADAR1,
  S_INV_RADAR2,
  //Keys
  S_KEY1,
  S_KEY2,
  S_KEY3,
  S_KEY4,
  S_KEY5,
  S_KEY6,
  S_KEY7,
  S_KEY8,
  S_KEY9,
  S_KEY10,
  S_KEY11,
  S_KEY12,
  S_KEY13,
  S_KEY14,
  S_KEY15,
  S_KEY16,
  S_KEY17,
  S_KEY18,
  //Quest Keys
  S_QKEY1,
  S_QKEY2,
  S_QKEY3,
  S_QKEY4,
  S_QKEY5,
  S_QKEY6,
  S_QKEY7,
  S_QKEY8,
  S_QKEY9,
  //Quest
  S_QUEST1,
  S_QUEST2,
  S_QUEST3,
  S_QUEST4,
  S_QUEST5,
  S_BEACON,
  S_BEACON_2,
  S_BEACON_3,
  S_TSTAND_1,
  S_TSTAND_2,
  S_TSTAND_3,
  S_TSTAND_4,
  S_QUEST6,
  S_QUEST7,
  //Peasant
  S_PEAS_STND,
  S_PEAS_WALK1,
  S_PEAS_WALK2,
  S_PEAS_WALK3,
  S_PEAS_WALK4,
  S_PEAS_WALK5,
  S_PEAS_WALK6,
  S_PEAS_WALK7,
  S_PEAS_WALK8,
  S_PEAS_ATK1,
  S_PEAS_ATK2,
  S_PEAS_ATK3,
  S_PEAS_PAIN,
  S_PEAS_PAIN2,
  S_PEAS_DIE1,
  S_PEAS_DIE2,
  S_PEAS_DIE3,
  S_PEAS_DIE4,
  S_PEAS_DIE5,
  S_PEAS_DIE6,
  S_PEAS_DIE7,
  S_PEAS_DIE8,
  S_PEAS_XDIE1,
  S_PEAS_XDIE2,
  S_PEAS_XDIE3,
  S_PEAS_XDIE4,
  S_PEAS_XDIE5,
  S_PEAS_XDIE6,
  S_PEAS_XDIE7,
  S_PEAS_XDIE8,
  S_PEAS_XDIE9,
  S_PEAS_XDIE10,
  S_PEAS_CDIE1,
  S_PEAS_CDIE2,
  S_PEAS_CDIE3,
  S_PEAS_LOOK,
  //Turret
  S_TURRET1,
  S_TURRET2,
  S_TURRET3,
  S_TURRET4,
  S_TURRET5,
  S_TURRET6,
  S_TURRET7,
  S_TURRET8,
  S_TURRET9,
  S_TURRET10,
  S_TURRET11,
  //Pguard
  S_PGRD_STND,
  S_PGRD_STND2,
  S_PGRD_STND3,
  S_PGRD_WALK1,
  S_PGRD_WALK2,
  S_PGRD_WALK3,
  S_PGRD_WALK4,
  S_PGRD_WALK5,
  S_PGRD_WALK6,
  S_PGRD_WALK7,
  S_PGRD_WALK8,
  S_PGRD_RUN1,
  S_PGRD_RUN2,
  S_PGRD_RUN3,
  S_PGRD_RUN4,
  S_PGRD_RUN5,
  S_PGRD_RUN6,
  S_PGRD_RUN7,
  S_PGRD_RUN8,
  S_PGRD_ATK1,
  S_PGRD_ATK2,
  S_PGRD_MATK1,
  S_PGRD_MATK2,
  S_PGRD_PAIN,
  S_PGRD_PAIN2,
  S_PGRD_DIE1,
  S_PGRD_DIE2,
  S_PGRD_DIE3,
  S_PGRD_DIE4,
  S_PGRD_DIE5,
  S_PGRD_DIE6,
  S_PGRD_DIE7,
  S_PGRD_DIE8,
  S_PGRD_DIE9,
  S_PGRD_DIE10,
  S_PGRD_DIE11,
  S_PGRD_DIE12,
  S_PGRD_DIE13,
  S_PGRD_DIE14,
  S_PGRD_DIE15,
  S_PGRD_DIE16,
  S_PGRD_DIE17,
  S_PGRD_DIE18,
  S_PGRD_DIE19,
  S_PGRD_DIE20,
  //Reaver
  S_ROB1_STND,
  S_ROB1_STND2,
  S_ROB1_RUN1,
  S_ROB1_RUN2,
  S_ROB1_RUN3,
  S_ROB1_RUN4,
  S_ROB1_RUN5,
  S_ROB1_RUN6,
  S_ROB1_RUN7,
  S_ROB1_RUN8,
  S_ROB1_ATK1,
  S_ROB1_ATK2,
  S_ROB1_MATK1,
  S_ROB1_MATK2,
  S_ROB1_MATK3,
  S_ROB1_PAIN,
  S_ROB1_PAIN2,
  S_ROB1_DIE1,
  S_ROB1_DIE2,
  S_ROB1_DIE3,
  S_ROB1_DIE4,
  S_ROB1_DIE5,
  S_ROB1_DIE6,
  S_ROB1_DIE7,
  S_ROB1_DIE8,
  S_ROB1_DIE9,
  S_ROB1_XDIE1,
  S_ROB1_XDIE2,
  S_ROB1_XDIE3,
  S_ROB1_XDIE4,
  S_ROB1_XDIE5,
  S_ROB1_XDIE6,
  S_ROB1_XDIE7,
  //Stalker
  S_STLK_STND,
  S_STLK_STND2,
  S_STLK_STND3,
  S_STLK_RUN1,
  S_STLK_RUN2,
  S_STLK_RUN3,
  S_STLK_RUN4,
  S_STLK_RUN5,
  S_STLK_RUN6,
  S_STLK_FRUN1,
  S_STLK_FRUN2,
  S_STLK_FRUN3,
  S_STLK_FRUN4,
  S_STLK_FRUN5,
  S_STLK_FRUN6,
  S_STLK_ATK1,
  S_STLK_ATK2,
  S_STLK_FALL,
  S_STLK_FALL1,
  S_STLK_FALL2,
  S_STLK_FALL3,
  S_STLK_FALL4,
  S_STLK_FALL5,
  S_STLK_FALL6,
  S_STLK_PAIN,
  S_STLK_PAIN2,
  S_STLK_DIE1,
  S_STLK_DIE2,
  S_STLK_DIE3,
  S_STLK_DIE4,
  S_STLK_DIE5,
  S_STLK_DIE6,
  S_STLK_DIE7,
  S_STLK_DIE8,
  S_STLK_DIE9,
  S_STLK_DIE10,
  S_STLK_DIE11,
  S_STLK_DIE12,
  S_STLK_DIE13,
  //SewerThingy
  S_SEWR_STND,
  S_SEWR_RUN1,
  S_SEWR_RUN2,
  S_SEWR_PAIN,
  S_SEWR_ATK1,
  S_SEWR_DIE1,
  S_SEWR_DIE2,
  S_SEWR_DIE3,
  S_SEWR_DIE4,
  S_SEWR_DIE5,
  S_SEWR_DIE6,
  S_SEWR_DIE7,
  S_SEWR_ROUND1,
  S_SWER_ROUND2,
  //SewerLaserThingy
  S_L_LASER1,
  S_L_LASER2,
  S_L_DTH1,
  S_L_DTH2,
  S_L_DTH3,
  S_L_DTH4,
  S_L_DTH5,
  //Crusader
  S_ROB2_STND,
  S_ROB2_RUN1,
  S_ROB2_RUN2,
  S_ROB2_RUN3,
  S_ROB2_RUN4,
  S_ROB2_RUN5,
  S_ROB2_RUN6,
  S_ROB2_RUN7,
  S_ROB2_RUN8,
  S_ROB2_ATK1,
  S_ROB2_ATK2,
  S_ROB2_ATK3,
  S_ROB2_ATK4,
  S_ROB2_ATK5,
  S_ROB2_ATK6,
  S_ROB2_ATK7,
  S_ROB2_ATK8,
  S_ROB2_ATK9,
  S_ROB2_ATK10,
  S_ROB2_PAIN,
  S_ROB2_DIE1,
  S_ROB2_DIE2,
  S_ROB2_DIE3,
  S_ROB2_DIE4,
  S_ROB2_DIE5,
  S_ROB2_DIE6,
  S_ROB2_DIE7,
  S_ROB2_DIE8,
  S_ROB2_DIE9,
  S_ROB2_DIE10,
  //Programmer
  S_PRGR_STND,
  S_PRGR_STND2,
  S_PRGR_RUN1,
  S_PRGR_RUN2,
  S_PRGR_RUN3,
  S_PRGR_RUN4,
  S_PRGR_RUN5,
  S_PRGR_RUN6,
  S_PRGR_RUN7,
  S_PRGR_RUN8,
  S_PRGR_PAIN,
  S_PRGR_PAIN2,
  S_PRGR_MEL1,
  S_PRGR_MEL2,
  S_PRGR_MEL3,
  S_PRGR_MEL4,
  S_PRGR_ATK1,
  S_PRGR_ATK2,
  S_PRGR_ATK3,
  S_PRGR_ATK4,
  S_PRGR_DIE1,
  S_PRGR_DIE2,
  S_PRGR_DIE3,
  S_PRGR_DIE4,
  S_PRGR_DIE5,
  S_PRGR_DIE6,
  S_PRGR_DIE7,
  S_PRGR_DIE8,
  S_PRGR_DIE9,
  S_PRGR_DIE10,
  S_PRGR_DIE11,
  S_PRGR_DIE12,
  S_PRGR_DIE13,
  S_PRGR_DIE14,
  //Programmer Base
  S_PBASE1,
  S_PBASE2,
  S_PBASE3,
  S_PBASE4,
  S_PBASE5,
  S_PBASE6,
  S_PBASE7,
  S_PBASE8,

  //Sigil A Ground
  S_S_A_GROUND1,
  S_S_A_GROUND2,
  S_S_A_GROUND3,
  S_S_A_GROUND4,
  //Sigil A Zap
  S_S_A_ZAP1,
  S_S_A_ZAP2,
  S_S_A_ZAP3,
  S_S_A_ZAP4,
  S_S_A_ZAP5,
  //Sigil B Shot
  S_S_B_SHOT1,
  S_S_B_SHOT2,
  S_S_B_SHOT3,
  //Sigil Trail
  S_S_TRAIL1,
  S_S_TRAIL2,
  S_S_TRAIL3,
  //Sigil C Shot
  S_S_C_SHOT1,
  S_S_C_SHOT2,
  S_S_C_SHOT3,
  S_S_C_SHOT4,
  S_S_C_SHOT5,
  //Sigil D Shot
  S_S_D_SHOT1,
  S_S_D_SHOT2,
  S_S_D_SHOT3,
  S_S_D_SHOT4,
  S_S_D_SHOT5,
  //Sigil E Shot
  S_S_E_SHOT1,
  S_S_E_SHOT2,
  S_S_E_SHOT3,
  S_S_E_SHOT4,
  S_S_E_SHOT5,

  //LoreMaster
  S_PRST_STND,
  S_PRST_STND2,
  S_PRST_RUN1,
  S_PRST_RUN2,
  S_PRST_RUN3,
  S_PRST_RUN4,
  S_PRST_RUN5,
  S_PRST_RUN6,
  S_PRST_RUN7,
  S_PRST_RUN8,
  S_PRST_MEL1,
  S_PRST_MEL2,
  S_PRST_MEL3,
  S_PRST_ATK1,
  S_PRST_ATK2,
  S_PRST_ATK3,
  S_PRST_DIE1,
  S_PRST_DIE2,
  S_PRST_DIE3,
  S_PRST_DIE4,
  S_PRST_DIE5,
  S_PRST_DIE6,
  S_PRST_DIE7,
  S_PRST_DIE8,
  S_PRST_DIE9,
  S_PRST_DIE10,
  S_PRST_DIE11,
  S_PRST_DIE12,
  S_PRST_DIE13,
  S_PRST_DIE14,
  S_PRST_DIE15,
  S_PRST_DIE16,
  S_PRST_DIE17,
  S_PRST_DIE18,
  S_PRST_DIE19,
  S_PRST_DIE20,
  S_PRST_DIE21,
  S_PRST_DIE22,
  S_PRST_DIE23,
  S_PRST_DIE24,
  //Priest Missile
  S_OCLW,
  S_CCLW,
  S_TEND,
  //Specture
  S_ALN1_STND,
  S_ALN1_STND2,
  S_ALN1_RUN1,
  S_ALN1_RUN2,
  S_ALN1_RUN3,
  S_ALN1_RUN4,
  S_ALN1_RUN5,
  S_ALN1_RUN6,
  S_ALN1_RUN7,
  S_ALN1_RUN8,
  S_ALN1_RUN9,
  S_ALN1_RUN10,
  S_ALN1_RUN11,
  S_ALN1_PAIN,
  S_ALN1_MEL1,
  S_ALN1_MEL2,
  S_ALN1_MEL3,
  S_ALN1_ATK1,
  S_ALN1_ATK2,
  S_ALN1_ATK3,
  S_ALN1_DIE1,
  S_ALN1_DIE2,
  S_ALN1_DIE3,
  S_ALN1_DIE4,
  S_ALN1_DIE5,
  S_ALN1_DIE6,
  S_ALN1_DIE7,
  S_ALN1_DIE8,
  S_ALN1_DIE9,
  S_ALN1_DIE10,
  S_ALN1_DIE11,
  S_ALN1_DIE12,
  S_ALN1_DIE13,
  S_ALN1_DIE14,
  S_ALN1_DIE15,
  S_ALN1_DIE16,
  S_ALN1_DIE17,
  S_ALN1_DIE18,
  //Versions
  S_ALN1_2_ATK1,
  S_ALN1_2_ATK2,
  S_ALN1_2_ATK3,
  //Version3
  S_ALN3_STND,
  S_ALN3_STND2,
  S_ALN3_STND3,
  S_ALN3_STND4,
  S_ALN3_STND5,
  S_ALN3_STND6,
  S_ALN3_STND7,
  S_ALN3_STND8,
  S_ALN3_STND9,
  S_ALN3_STND10,
  S_ALN3_STND11,
  S_ALN3_RUN1,
  S_ALN3_RUN2,
  S_ALN3_RUN3,
  S_ALN3_RUN4,
  S_ALN3_RUN5,
  S_ALN3_RUN6,
  S_ALN3_RUN7,
  S_ALN3_RUN8,
  S_ALN3_RUN9,
  S_ALN3_RUN10,
  S_ALN3_RUN11,
  S_ALN3_PAIN,
  S_ALN3_MEL1,
  S_ALN3_MEL2,
  S_ALN3_MEL3,
  S_ALN3_ATK1,
  S_ALN3_ATK2,
  S_ALN3_ATK3,
  S_ALN4_ATK1,
  S_ALN4_ATK2,
  S_ALN4_ATK3,
  S_ALN5_ATK1,
  S_ALN5_ATK2,
  S_ALN5_ATK3,
  //Node
  S_NODE1,
  S_NODE2,
  S_NODE3,
  S_NODE4,
  S_NODE5,
  S_NODE6,
  S_NODE7,
  //Head
  S_MTHD1,
  S_MTHD2,
  S_MTHD3,
  S_MTHD4,
  S_MTHD5,
  S_MTHD6,
  S_MTHD7,
  S_MTHD8,
  S_MTHD9,
  S_MTHD10,
  S_MTHD11,

  //Bishop
  S_MLDR_STND,
  S_MLDR_RUN1,
  S_MLDR_RUN2,
  S_MLDR_RUN3,
  S_MLDR_RUN4,
  S_MLDR_RUN5,
  S_MLDR_RUN6,
  S_MLDR_RUN7,
  S_MLDR_RUN8,
  S_MLDR_ATK1,
  S_MLDR_ATK2,
  S_MLDR_PAIN,
  S_MLDR_DIE1,
  S_MLDR_DIE2,
  S_MLDR_DIE3,
  S_MLDR_DIE4,
  S_MLDR_DIE5,
  S_MLDR_DIE6,
  S_MLDR_DIE7,
  S_MLDR_DIE8,
  S_MLDR_DIE9,
  S_MLDR_DIE10,
  S_MLDR_DIE11,
  S_MLDR_DIE12,
  S_MLDR_DIE13,
  S_MLDR_DIE14,
  S_MLDR_DIE15,
  S_MLDR_DIE16,
  //Missile
  S_SEEKMISSLE,
  S_SEEKMISSLE2,

  //Inquisitor
  S_ROB3_STND,
  S_ROB3_STND2,
  S_ROB3_RUN1,
  S_ROB3_RUN2,
  S_ROB3_RUN3,
  S_ROB3_RUN4,
  S_ROB3_RUN5,
  S_ROB3_RUN6,
  S_ROB3_RUN7,
  S_ROB3_RUN8,
  S_ROB3_ATK1,
  S_ROB3_ATK2,
  S_ROB3_ATK3,
  S_ROB3_ATK4,
  S_ROB3_GREN1,
  S_ROB3_GREN2,
  S_ROB3_GREN3,
  S_ROB3_FLY1,
  S_ROB3_FLY2,
  S_ROB3_FLY3,
  S_ROB3_DIE1,
  S_ROB3_DIE2,
  S_ROB3_DIE3,
  S_ROB3_DIE4,
  S_ROB3_DIE5,
  S_ROB3_DIE6,
  S_ROB3_DIE7,
  S_ROB3_DIE8,
  S_ROB3_DIE9,
  S_ROB3_DIE10,
  S_ROB3_DIE11,
  S_ROB3_DIE12,
  S_ROB3_DIE13,
  S_ROB3_DIE14,
  S_ROB3_DIE15,
  S_ROB3_DIE16,
  S_ROB3_DIE17,
  S_ROB3_DIE18,
  S_ROB3_DIE19,
  S_ROB3_DIE20,
  S_ROB3_DIE21,
  S_ROB3_DIE22,
  S_ROB3_DIE23,
  //Arm
  S_RBB3,
  S_RBB3_2,
  S_RBB3_3,
  //Grenade
  S_ROB3GREN1,
  S_ROB3GREN2,
  //Explode
  S_BNG2_1,
  S_BNG2_2,
  S_BNG2_3,
  S_BNG2_4,
  S_BNG2_5,
  S_BNG2_6,
  S_BNG2_7,
  S_BNG2_8,
  S_BNG2_9,
  
  //Oracle
  S_ORACLE_1,
  S_ORACLE_2,
  S_ORACLE_3,
  S_ORACLE_4,
  S_ORACLE_5,
  S_ORACLE_6,
  S_ORACLE_7,
  S_ORACLE_8,
  S_ORACLE_9,
  S_ORACLE_10,
  S_ORACLE_11,
  S_ORACLE_12,
  S_ORACLE_13,
  S_ORACLE_14,
  S_ORACLE_15,
  S_ORACLE_16,
  S_ORACLE_17,

  //Macil
  S_LEDR_STND,
  S_LEDR_STNDA,
  S_LEDR_STNDB,
  S_LEDR_WALK1,
  S_LEDR_WALK2,
  S_LEDR_WALK3,
  S_LEDR_WALK4,
  S_LEDR_RUN1,
  S_LEDR_RUN2,
  S_LEDR_RUN3,
  S_LEDR_RUN4,
  S_LEDR_RUN5,
  S_LEDR_RUN6,
  S_LEDR_RUN7,
  S_LEDR_RUN8,
  S_LEDR_ATK1,
  S_LEDR_ATK2,
  S_LEDR_ATK3,
  S_LEDR_2ATK1,
  S_LEDR_2ATK2,
  S_LEDR_2ATK3,
  S_LEDR_PAIN1,
  S_LEDR_PAIN2,
  S_LEDR_DTH1,
  S_LEDR_DTH2,
  S_LEDR_DTH3,
  S_LEDR_DTH4,
  S_LEDR_DTH5,
  S_LEDR_DTH6,
  S_LEDR_DTH7,
  S_LEDR_DTH8,
  S_LEDR_DTH9,
  S_LEDR_DTH10,
  S_LEDR_DTH11,
  S_LEDR_DTH12,
  S_LEDR_DTH13,
  S_LEDR_DTH14,
  S_LEDR_DTH15,
  S_LEDR_DTH16,
  S_LEDR_DTH17,
  S_LEDR_DTH18,
  //Zombie
  S_ZMBE_STND,
  S_ZMBE_PAIN,
  S_ZMBES_STND,

  //Rebel
  S_HMN1_STND,
  S_HMN1_STNDA,
  S_HMN1_STNDB,
  S_HMN1_WALK1,
  S_HMN1_WALK2,
  S_HMN1_WALK3,
  S_HMN1_WALK4,
  S_HMN1_WALK5,
  S_HMN1_WALK6,
  S_HMN1_WALK7,
  S_HMN1_WALK8,
  S_HMN1_RUN1,
  S_HMN1_RUN2,
  S_HMN1_RUN3,
  S_HMN1_RUN4,
  S_HMN1_RUN5,
  S_HMN1_RUN6,
  S_HMN1_RUN7,
  S_HMN1_RUN8,
  S_HMN1_ATK1,
  S_HMN1_ATK2,
  S_HMN1_ATK3,
  S_HMN1_PAIN1,
  S_HMN1_PAIN2,
  S_HMN1_DTH1,
  S_HMN1_DTH2,
  S_HMN1_DTH3,
  S_HMN1_DTH4,
  S_HMN1_DTH5,
  S_HMN1_DTH6,
  S_HMN1_DTH7,
  S_HMN1_DTH8,
  S_HMN1_DTH9,
  S_HMN1_DTH10,
  S_HMN1_DTH11,
  S_HMN1_DTH12,
  S_HMN1_DTH13,
  S_HMN1_DTH14,
  S_HMN1_DTH15,
  S_HMN1_DTH16,

  //Beggar
  S_BEGR_STND,
  S_BEGR_WALK1,
  S_BEGR_WALK2,
  S_BEGR_WALK3,
  S_BEGR_WALK4,
  S_BEGR_WALK5,
  S_BEGR_WALK6,
  S_BEGR_ATK1,
  S_BEGR_ATK2,
  S_BEGR_ATK3,
  S_BEGR_ATK4,
  S_BEGR_PAIN,
  S_BEGR_PAIN2,
  S_BEGR_DIE1,
  S_BEGR_DIE2,
  S_BEGR_DIE3,
  S_BEGR_DIE4,
  S_BEGR_DIE5,
  S_BEGR_DIE6,
  S_BEGR_DIE7,
  S_BEGR_DIE8,
  S_BEGR_DIE9,
  S_BEGR_XDIE1,

  //Entity
  S_MNAM_1,
  S_MNAM_2,
  S_MNAM_3,
  S_MNAM_4,
  S_MNAM_5,
  S_MNAM_6,
  S_MNAM_7,
  S_MNAM_8,
  S_MNAM_9,
  S_MNAM_10,
  S_MNAM_11,
  S_MNAM_12,
  S_MNAL_STND1,
  S_MNAL_STND2,
  S_MNAL_RUN1,
  S_MNAL_RUN2,
  S_MNAL_RUN3,
  S_MNAL_RUN4,
  S_MNAL_RUN5,
  S_MNAL_RUN6,
  S_MNAL_RUN7,
  S_MNAL_RUN8,
  S_MNAL_RUN9,
  S_MNAL_RUN10,
  S_MNAL_RUN11,
  S_MNAL_MEL1,
  S_MNAL_MEL2,
  S_MNAL_MEL3,
  S_MNAL_ATK1,
  S_MNAL_ATK2,
  S_MNAL_ATK3,
  S_MNAL_PAIN,
  S_MNAL_DIE1,
  S_MNAL_DIE2,
  S_MNAL_DIE3,
  S_MNAL_DIE4,
  S_MNAL_DIE5,
  S_MNAL_DIE6,
  S_MNAL_DIE7,
  //Nest
  S_NEST,
  //Pod
  S_POD1,
  S_POD2,
  S_POD3,
  S_POD4,
  S_POD5,
  S_POD6,
  //SubEntity
  S_SUB_LOOK,
  S_SUB_RUN1,
  S_SUB_RUN2,
  S_SUB_RUN3,
  S_SUB_RUN4,
  S_SUB_RUN5,
  S_SUB_RUN6,
  S_SUB_MEL1,
  S_SUB_MEL2,
  S_SUB_MEL3,
  S_SUB_ATK1,
  S_SUB_ATK2,
  S_SUB_ATK3,
  S_SUB_PAIN,
  S_SUB_DIE1,
  S_SUB_DIE2,
  S_SUB_DIE3,
  S_SUB_DIE4,
  S_SUB_DIE5,
  S_SUB_DIE6,
  S_SUB_DIE7,
  S_SUB_DIE8,
  S_SUB_DIE9,
  S_SUB_DIE10,
  S_SUB_DIE11,
  S_SUB_DIE12,
  S_SUB_DIE13,
  S_SUB_DIE14,
  S_SUB_DIE15,

  //Ore
  S_XPRK1,
  S_XPRK2,

  //Field Guard
  S_TOKN_GUARD1,
  S_TOKN_GUARD2,

  //Gate
  S_PSTN1,
  S_PSTN2,
  S_PSTN_DTH1,
  S_PSTN_DTH2,
  S_PSTN_DTH3,
  S_PSTN_DTH4,
  S_PSTN_DTH5,
  S_PSTN_DTH6,
  S_PSTN_DTH7,
  S_PSTN_DTH8,
  S_PSTN_DTH9,

  //Coupling
  S_COUP1,
  S_COUP2,
  S_COUP3,

  //Computer
  S_SECR_1,
  S_SECR_2,
  S_SECR_3,
  S_SECR_4,
  S_SECR_5,
  S_SECR_6,
  S_SECR_7,
  S_SECR_8,
  S_SECR_9,
  S_SECR_10,
  S_SECR_11,
  S_SECR_12,
  S_SECR_13,
  S_SECR_14,
  S_SECR_15,
  S_SECR_16,

  //Shopkeeper
  S_SHOP_1,
  S_SHOP_2,
  S_SHOP_3,
  S_SHOP_4,
  S_SHOP_5,
  S_SHOP_6,
  S_SHOP_7,
  S_SHOP_8,
  S_SHOP_9,
  S_SHOP_10,
  S_SHOP_11,
  S_SHOP_12,
  S_SHOP_13,
  S_SHOP_14,
  S_SHOP_15,
  S_SHOP_16,
  S_SHOP_17,
  S_SHOP_18,
  S_SHOP_19,
  S_SHOP_20,
  S_SHOP_21,
  S_SHOP_22,
  S_SHOP_23,
  S_SHOP_24,
  S_SHOP_25,
  S_SHOP_26,
  S_SHOP_27,
  S_SHOP_28,
  S_SHOP_29,
  S_SHOP_30,
  S_SHOP_31,
  S_SHOP_32,
  S_SHOP_33,
  S_SHOP_34,
  S_SHOP_35,

  S_RING,
  S_EAR,
  S_TOUGH,
  S_ACCURACY,
  S_ORACLEPASS,
  S_FPARTS,

  S_CRYS_1,
  S_CRYS_2,
  S_CRYS_3,
  S_CRYS_4,
  S_CRYS_5,
  S_CRYS_6,

  S_BOOM_1,
  S_BOOM_2,
  S_BOOM_3,
  S_BOOM_4,
  S_BOOM_5,
  S_BOOM_6,
  S_BOOM_7,
  S_BOOM_8,
  S_BOOM_9,
  S_BOOM_10,
  S_BOOM_11,
  S_BOOM_12,
  S_BOOM_13,
  S_BOOM_14,
  S_BOOM_15,
  S_BOOM_16,
  S_BOOM_17,
  S_BOOM_18,
  S_BOOM_19,
  S_BOOM_20,
  S_BOOM_21,
  S_BOOM_22,
  S_BOOM_23,
  S_BOOM_24,
  S_BOOM_25,

  S_TFOG,
  S_TFOG01,
  S_TFOG02,
  S_TFOG2,
  S_TFOG3,
  S_TFOG4,
  S_TFOG5,
  S_TFOG6,
  S_TFOG7,
  S_TFOG8,
  S_TFOG9,
  S_TFOG10,
  S_IFOG,
  S_IFOG01,
  S_IFOG02,
  S_IFOG2,
  S_IFOG3,
  S_IFOG4,
  S_IFOG5,

  S_PLAY,
  S_PLAY_RUN1,
  S_PLAY_RUN2,
  S_PLAY_RUN3,
  S_PLAY_RUN4,
  S_PLAY_ATK1,
  S_PLAY_ATK2,
  S_PLAY_PAIN,
  S_PLAY_PAIN2,
  S_PLAY_DIE1,
  S_PLAY_DIE2,
  S_PLAY_DIE3,
  S_PLAY_DIE4,
  S_PLAY_DIE5,
  S_PLAY_DIE6,
  S_PLAY_DIE7,
  S_PLAY_DIE8,
  S_PLAY_DIE9,
  S_PLAY_DIE10,
  S_PLAY_XDIE1,
  S_PLAY_XDIE2,
  S_PLAY_XDIE3,
  S_PLAY_XDIE4,
  S_PLAY_XDIE5,
  S_PLAY_XDIE6,
  S_PLAY_XDIE7,
  S_PLAY_XDIE8,

  S_DEAD_1,

  S_TNT1, /* add state for invisible sprite          phares 3/8/98  */

  S_GRENADE,   /* killough 8/9/98: grenade launcher */
  S_DETONATE,  /* killough 8/9/98: detonation of objects */
  S_DETONATE2,
  S_DETONATE3,

#ifdef DOGS
  S_DOGS_STND,      /* killough 7/19/98: Marine's best friend :) */
  S_DOGS_STND2,
  S_DOGS_RUN1,
  S_DOGS_RUN2,
  S_DOGS_RUN3,
  S_DOGS_RUN4,
  S_DOGS_RUN5,
  S_DOGS_RUN6,
  S_DOGS_RUN7,
  S_DOGS_RUN8,
  S_DOGS_ATK1,
  S_DOGS_ATK2,
  S_DOGS_ATK3,
  S_DOGS_PAIN,
  S_DOGS_PAIN2,
  S_DOGS_DIE1,
  S_DOGS_DIE2,
  S_DOGS_DIE3,
  S_DOGS_DIE4,
  S_DOGS_DIE5,
  S_DOGS_DIE6,
  S_DOGS_RAISE1,
  S_DOGS_RAISE2,
  S_DOGS_RAISE3,
  S_DOGS_RAISE4,
  S_DOGS_RAISE5,
  S_DOGS_RAISE6,
#endif

  S_MUSHROOM,  /* killough 10/98: mushroom explosion effect */


  //==================Strife Frame States===================Kaiser

  NUMSTATES  /* Counter of how many there are */

} statenum_t;

/********************************************************************
 * Definition of the state (frames) structure                       *
 ********************************************************************/

typedef struct
{
  spritenum_t sprite;       /* sprite number to show                       */
  long        frame;        /* which frame/subframe of the sprite is shown */
  long        tics;         /* number of gametics this frame should last   */
  actionf_t   action;       /* code pointer to function for action if any  */
  statenum_t  nextstate;    /* linked list pointer to next state or zero   */
  long        misc1, misc2; /* apparently never used in DOOM               */
} state_t;

/* these are in info.c */
extern state_t  states[NUMSTATES];
extern const char *sprnames[]; /* 1/17/98 killough - CPhipps - const */

/********************************************************************
 * Thing enumeration -- must match info.c                           *
 ********************************************************************
 * Note that many of these are generically named for the ornamentals
 */

typedef enum {
  MT_FIELDGUARD,//0
  MT_PLAYER,//1
  MT_SHOPKEEPER_W,//2
  MT_SHOPKEEPER_B,//3
  MT_SHOPKEEPER_A,//4
  MT_SHOPKEEPER_M,//5
  MT_PEASANT2_A,//6
  MT_PEASANT2_B,//7
  MT_PEASANT2_C,//8
  MT_PEASANT5_A,//9
  MT_PEASANT5_B,//10
  MT_PEASANT5_C,//11
  MT_PEASANT4_A,//12
  MT_PEASANT4_B,//13
  MT_PEASANT4_C,//14
  MT_PEASANT6_A,//15
  MT_PEASANT6_B,//16
  MT_PEASANT6_C,//17
  MT_PEASANT3_A,//18
  MT_PEASANT3_B,//19
  MT_PEASANT3_C,//20
  MT_PEASANT8_A,//21
  MT_PEASANT8_B,//22
  MT_PEASANT8_C,//23
  MT_PEASANT7_A,//24
  MT_PEASANT7_B,//25
  MT_PEASANT7_C,//26
  MT_PEASANT1,//27
  MT_ZOMBIE,//28
  MT_BECOMING,//29
  MT_ZOMBIESPAWNER,//30
  MT_HUGE_TANK_1,//31
  MT_HUGE_TANK_2,//32
  MT_HUGE_TANK_3,//33
  MT_TANK_4,//34
  MT_TANK_5,//35
  MT_TANK_6,//36
  MT_KNEELING_GUY,//37
  MT_BEGGAR1,//38
  MT_BEGGAR2,//39
  MT_BEGGAR3,//40
  MT_BEGGAR4,//41
  MT_BEGGAR5,//42
  MT_REBEL1,//43
  MT_REBEL2,//44
  MT_REBEL3,//45
  MT_REBEL4,//46
  MT_REBEL5,//47
  MT_REBEL6,//48
  MT_RLEADER,//49
  MT_RLEADER2,//50
  MT_MISSILESMOKE,//51
  MT_REAVER,//52
  MT_GUARD1,//53
  MT_GUARD2,//54
  MT_GUARD3,//55
  MT_GUARD4,//56
  MT_GUARD5,//57
  MT_GUARD6,//58
  MT_GUARD7,//59
  MT_GUARD8,//60
  MT_SHADOWGUARD,//61
  MT_PGUARD,//62
  MT_CRUSADER,//63
  MT_BISHOP,//64
  MT_ORACLE,//65
  MT_PRIEST,//66
  MT_SPECTURE_A,//67
  MT_NODE,//68
  MT_SPECTUREHEAD,//69
  MT_SPECTURE_B,//70
  MT_SPECTURE_C,//71
  MT_SPECTURE_D,//72
  MT_SPECTURE_E,//73
  MT_ENTITY,//74
  MT_SUBENTITY,//75
  MT_NEST,//76
  MT_POD,//77
  MT_SIGIL_B_SHOT,
  MT_SIGIL_SB_SHOT,
  MT_SIGIL_C_SHOT,
  MT_SIGIL_SC_SHOT,
  MT_SIGIL_E_OFFSHOOT,
  MT_SIGIL_TRAIL,
  MT_SIGIL_E_SHOT,
  MT_SIGIL_SE_SHOT,
  MT_SIGIL_A_ZAP_LEFT,
  MT_SIGIL_A_ZAP_RIGHT,
  MT_SIGIL_A_GROUND,
  MT_SIGIL_D_SHOT,
  MT_SIGIL_SD_SHOT,
  MT_SENTINEL,
  MT_STALKER,
  MT_INQUISITOR,
  MT_INQARM,
  MT_PROGRAMMER,
  MT_PROGRAMMERBASE,
  MT_HOOKSHOT,
  MT_CHAINSHOT,
  MT_MINIMISSLE,
  MT_C_MISSILE,
  MT_SEEKMISSILE,
  MT_ELECARROW,
  MT_POISARROW,
  MT_R_LASER,
  MT_L_LASER,
  MT_HEGRENADE,
  MT_PGRENADE,
  MT_INQGRENADE,
  MT_PFLAME,
  MT_TORPEDO,
  MT_TORPEDOSPREAD,
  MT_SFIREBALL,
  MT_C_FLAME,
  MT_STRIFEPUFF3,
  MT_STRIFEPUFF,
  MT_SPARKPUFF,
  MT_BLOOD_DEATH,
  MT_TFOG,
  MT_IFOG,
  MT_TELEPORTMAN,
  MT_MISC_01,
  MT_TURRET,
  MT_GATE,
  MT_COMPUTER,
  MT_INV_MED1,
  MT_INV_MED2,
  MT_INV_MED3,
  MT_DEGNINORE,
  MT_INV_ARMOR2,
  MT_INV_ARMOR1,
  MT_MISC_22,	//WATER_BOTTLE
  MT_MISC_11,	//MUG
  MT_KEY_BASE,
  MT_GOVSKEY,
  MT_KEY_TRAVEL,
  MT_KEY_ID_BLUE,
  MT_PRISONKEY,
  MT_KEY_HAND,
  MT_POWER1KEY,
  MT_POWER2KEY,
  MT_POWER3KEY,
  MT_KEY_GOLD,
  MT_KEY_ID_GOLD,
  MT_KEY_SILVER,
  MT_KEY_ORACLE,
  MT_MILITARYID,
  MT_KEY_ORDER,
  MT_KEY_WAREHOUSE,
  MT_KEY_BRASS,
  MT_KEY_RED_CRYSTAL,
  MT_KEY_BLUE_CRYSTAL,
  MT_KEY_CHAPEL,
  MT_CATACOMBKEY,
  MT_SECURITYKEY,
  MT_KEY_CORE,
  MT_KEY_MAULER,
  MT_KEY_FACTORY,
  MT_KEY_MINE,
  MT_NEWKEY5,
  MT_INV_SHADOWARMOR,
  MT_INV_SUIT,
  MT_QUEST_UNIFORM,
  MT_QUEST_GUARD_UNIFORM,
  MT_INV_SUPERMAP,
  MT_INV_RADAR,
  MT_BEACON,
  MT_INV_TARGETER,
  MT_INV_GOLD1,	//  MT_MONY_1
  MT_INV_GOLD10,
  MT_INV_GOLD25,
  MT_INV_GOLD50,
  MT_INV_GOLD300,
  MT_TOKEN_RING,
  MT_INV_CHALICE,
  MT_TOKEN_EAR,
  MT_INV_COMMUNICATOR,
  MT_AGREN,
  MT_APGREN,
  MT_ACLIP,
  MT_AAMMOBOX,
  MT_AMINI,
  MT_AMINIBOX,
  MT_ACELL,
  MT_APCELL,
  MT_APAROW,
  MT_AAROW,
  MT_INV_SATCHEL,
  MT_RIFLE,	//  MT_PULSE
  MT_RIFLESTAND,
  MT_FLAMETHROWER,
  MT_TOKEN_FLAME_THROWER_PARTS,
  MT_MINIMISSILE,
  MT_BLASTER,
  MT_CROSSBOW,
  MT_GRENADELAUNCHER,
  MT_SIGIL_A,
  MT_SIGIL_B,
  MT_SIGIL_C,
  MT_SIGIL_D,
  MT_SIGIL_E,
  MT_POWER_CRYSTAL,
  MT_RAT,
  MT_MISC_05,	//WBARREL
  MT_MISC_06,	//EBARREL
  MT_MISC_15,	//PRACTICE_TARGET
  MT_LIGHT14,	//SILVER_LIGHT
  MT_LIGHT13,	//BRASS_LIGHT
  MT_LIGHT12,	//GOLD_LIGHT
  MT_LIGHT18,	//GLOBE_LIGHT
  MT_PILLAR2,	//TECH_PILLIAR
  MT_PILLAR3,	//AZTEC_PILLAR
  MT_PILLAR4,	//AZTEC_DAMAGED
  MT_PILLAR5,	//AZTEC_RUINED
  MT_PILLAR6,	//HUGE_TECH_PILLAR
  MT_PILLAR7,	//ALIEN_PILLAR
  MT_CAVE2,	//STALACTITE
  MT_CAVE3,	//SMALL_STALACTITE
  MT_CAVE4,	//STALACMITE
  MT_CAVE6,	//PILLAR_TOP
  MT_CAVE7,	//PILLAR_BOTTOM
  MT_CAVE5,	//STALACMITE_SMALL
  MT_LIGHT2,	//CANDLE
  MT_LIGHT3, //CANDELABRA
  MT_MISC_03,	//FLOOR_WATER_DRIP
  MT_MISC_13,	//WATERFALL_SPLASH
  MT_MISC_02,	//CEILING_WATER_DRIP
  MT_MISC_07,	//FOUNTAIN
  MT_BIO2,		//HEARTS_IN_TANK
  MT_TELEPORTSTAND,
  MT_DEADTHING1,
  MT_DEADTHING2,
  MT_DEADTHING3,
  MT_DEADTHING4,
  MT_DEADTHING5,
  MT_DEADTHING6,
  MT_BIO1,		//SACRIFICED_GUY
  MT_GIBS,		//NEW THING THING#ID is 89
  MT_MISC_04,	//BURNING_BARREL
  MT_LIGHT11,	//BOWL
  MT_LIGHT10,	//BRAZIER
  MT_LIGHT9,	//SMALL_TORCH
  MT_LIGHT8,	//UNLIT_TORCH
  MT_MISC_14,	//CHAIN_CEILING
  MT_LIGHT1,	//CAGE_LIGHT
  MT_PILLAR8,	//STATUE
  MT_PILLAR9,	//STATUE_DEAD
  MT_LIGHT15,	//MEDIUM_TORCH
  MT_LIGHT4,	//OUT_LAMP
  MT_LIGHT5, //POLE_LIGHT
  MT_ROCK1,
  MT_ROCK2,
  MT_ROCK3,
  MT_ROCK4,
  MT_TREE7,	//STICK
  MT_RUBBLE1,
  MT_RUBBLE2,
  MT_RUBBLE3,
  MT_RUBBLE4,
  MT_RUBBLE5,
  MT_RUBBLE6,
  MT_RUBBLE7,
  MT_RUBBLE8,
  MT_MISC_08,	//CRAB
  MT_LIGHT6,	//LARGE_TORCH
  MT_LIGHT7, //HUGE_TORCH
  MT_TREE2,
  MT_TREE3,
  MT_TREE4,
  MT_TREE1,
  MT_TREE6,
  MT_TREE5,
  MT_CAVE1,
  MT_PILLAR1,
  MT_MISC_10,	//POT
  MT_MISC_09,	//PITCHER
  MT_MISC_17,	//STOOL
  MT_MISC_18,	//METAL_POT
  MT_MISC_19,	//TUB
  MT_MISC_20,	//ANVIL
  MT_LIGHT16,	//SILVER_TECH_LAMP
  MT_LIGHT17,	//BRASS_TECH_LAMP
  MT_MISC_21,	//TRAY
  MT_MISC_12,	//FILLER
  MT_MISC_26,	//BANNER
  MT_MISC_23,	//BOOTS
  MT_MISC_24,	//HELMET
  MT_MISC_25,	//SHIRT
  MT_COUPLING,
  MT_COUPLING_BROKEN,
  MT_PILLAR10,	//BUBBLEPILLAR
  MT_PILLAR11,	//BUBBLEPILLAR_FLOOR
  MT_PILLAR12,	//BUBBLEPILLAR_CEILING
  MT_PILLAR13,	//ASP_CLIMBER
  MT_LIGHT19,	//SPIDER_LIGHT
  MT_MEAT,
  MT_JUNK,
  MT_BURNDROP,
  MT_TOKEN_AMMO,
  MT_TOKEN_HEALTH,
  MT_TOKEN,
  MT_TOKEN_ALARM,
  MT_TOKEN_DOOR1,
  MT_TOKEN_SHOPCLOSE,
  MT_TOKEN_PRISON_PASS,
  MT_TOKEN_DOOR3,
  MT_TOKEN_STAMINA,
  MT_TOKEN_NEW_ACCURACY,
  MT_TOKEN_REPORT,
  MT_TOKEN_TOUGHNESS,
  MT_TOKEN_ACCURACY,
  MT_TOKEN_ORACLE_PASS,
  MT_TOKEN_QUEST1,
  MT_TOKEN_QUEST2,
  MT_TOKEN_QUEST3,
  MT_TOKEN_QUEST4,
  MT_TOKEN_QUEST5,
  MT_TOKEN_QUEST6,
  MT_TOKEN_QUEST7,
  MT_TOKEN_QUEST8,
  MT_TOKEN_QUEST9,
  MT_TOKEN_QUEST10,
  MT_TOKEN_QUEST11,
  MT_TOKEN_QUEST12,
  MT_TOKEN_QUEST13,
  MT_TOKEN_CRYSTAL,
  MT_TOKEN_QUEST15,
  MT_GATEQUEST,
  MT_TOKEN_QUEST17,
  MT_TOKEN_QUEST18,
  MT_TOKEN_QUEST19,
  MT_TOKEN_QUEST20,
  MT_TOKEN_BISHOP,
  MT_TOKEN_QUEST22,
  MT_TOKEN_ORACLE,
  MT_TOKEN_MACIL,
  MT_TOKEN_QUEST25,
  MT_TOKEN_LOREMASTER,
  MT_SECRQUEST,
  MT_TOKEN_QUEST28,
  MT_TOKEN_QUEST29,
  MT_TOKEN_QUEST30,
  MT_TOKEN_QUEST31,
  MT_SLIDESHOW,
  
  //SvStrife things
  MT_STRIFEPUFF2,
  MT_BLOOD,
  MT_GLASS,
  MT_GLASS2,
  MT_GLASS3,
  MT_GLASS4,
  MT_MAPSPOT1,
  MT_MAPSPOT2,
  MT_MAPSPOT3,
  MT_MAPSPOT4,
  MT_MAPSPOT5,
  MT_MAPSPOT6,
  MT_MAPSPOT7,
  MT_MAPSPOT8,
  MT_MAPSPOT9,
  MT_MAPSPOT10,
  MT_PUSH,
  MT_PULL,

#ifdef DOGS
  MT_DOGS,
#endif

  NUMMOBJTYPES  // Counter of how many there are
} mobjtype_t;

/********************************************************************
 * Definition of the Thing structure
 ********************************************************************/
/* Note that these are only indices to the state, sound, etc. arrays
 * and not actual pointers.  Most can be set to zero if the action or
 * sound doesn't apply (like lamps generally don't attack or whistle).
 */

typedef struct
{
  char *stringname;	//stringname for items etc. - kaiser
  int inv_amount;	//amount of this item	-kaiser
  int doomednum;    /* Thing number used in id's editor, and now
       probably by every other editor too */
  int spawnstate;   /* The state (frame) index when this Thing is
           first created */
  int spawnhealth;  /* The initial hit points for this Thing */
  int seestate;     /* The state when it sees you or wakes up */
  int seesound;     /* The sound it makes when waking */
  int reactiontime; /* How many tics it waits after it wakes up
           before it will start to attack, in normal
           skills (halved for nightmare) */
  int attacksound;  /* The sound it makes when it attacks */
  int painstate;    /* The state to indicate pain */
  int painchance;   /* A number that is checked against a random
           number 0-255 to see if the Thing is supposed
           to go to its painstate or not.  Note this
           has absolutely nothing to do with the chance
           it will get hurt, just the chance of it
           reacting visibly. */
  int painsound;    /* The sound it emits when it feels pain */
  int meleestate;   /* Melee==close attack */
  int missilestate; /* What states to use when it's in the air, if
           in fact it is ever used as a missile */
  int deathstate;   /* What state begins the death sequence */
  int xdeathstate;  /* What state begins the horrible death sequence
           like when a rocket takes out a trooper */
  int deathsound;   /* The death sound.  See also A_Scream() in
           p_enemy.c for some tweaking that goes on
           for certain monsters */
  int speed;        /* How fast it moves.  Too fast and it can miss
           collision logic. */
  int radius;       /* An often incorrect radius */
  int height;       /* An often incorrect height, used only to see
           if a monster can enter a sector */
  int mass;         /* How much an impact will move it.  Cacodemons
           seem to retreat when shot because they have
           very little mass and are moved by impact */
  int damage;       /* If this is a missile, how much does it hurt? */
  int activesound;  /* What sound it makes wandering around, once
           in a while.  Chance is 3/256 it will. */
  uint_64_t flags;  /* Bit masks for lots of things.  See p_mobj.h */
  int crashstate;   // Used for Peasants only -kaiser
} mobjinfo_t;

/* See p_mobj_h for addition more technical info */
extern mobjinfo_t mobjinfo[NUMMOBJTYPES];

#endif
