/*Splash.c	- cheaply emulates the long forgotten Strife loading screen  :) */

#ifdef _WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#ifdef _MSC_VER
#include <io.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include "splash.h"
#include "i_main.h"
#include "doomtype.h"
#include "w_wad.h"
#include "lprintf.h"

/*I don't know much about API programming in Visual C so instead of wasting the time
to learn it, I just copied the console function from lprintf.h*/

HWND splash_hWnd=0;
char szSplashName[] = "SplashWinClass";
char *LastSph = NULL;
LONG SplshWidth, SplshHeight;
char Lines[(80+2)*25+1];

extern void I_uSleep(unsigned long usecs);
void FinishSplashWin(void);

static CALLBACK SplashWndProc(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
    return(DefWindowProc(hwnd,iMsg,wParam,lParam));
}

int Init_SplashWin(void)
{
    HDC splashDC;
    WNDCLASS splashWndClass;
    RECT cRect;
    int width,height;
    int scr_width,scr_height;
    HINSTANCE hInstance;
	const byte *startUp;
	const byte *palette = W_CacheLumpName("PLAYPAL");	//needed to define color of pixels
	int i, k, lumpSize, x = 1, y = 0, cycle = 0;
	char *animZap[2] = {"STRTLZ1", "STRTLZ2"};
	char *animPeas[4] = {"STRTPA1", "STRTPB1", "STRTPC1", "STRTPD1"};
	startUp =  W_CacheLumpName("STARTUP0");	//background with strife logo

    if (splash_hWnd)
      return TRUE;
    hInstance = GetModuleHandle(NULL);
    /* Register the frame class */
    splashWndClass.style         = CS_OWNDC;
    splashWndClass.lpfnWndProc   = (WNDPROC)SplashWndProc;
    splashWndClass.cbClsExtra    = 0;
    splashWndClass.cbWndExtra    = 0;
    splashWndClass.hInstance     = hInstance;
    splashWndClass.hIcon         = LoadIcon (hInstance, IDI_WINLOGO);
    splashWndClass.hCursor       = LoadCursor (NULL,IDC_ARROW);
    splashWndClass.hbrBackground = (HBRUSH)GetStockObject (BLACK_BRUSH);
    splashWndClass.lpszMenuName  = szSplashName;
    splashWndClass.lpszClassName = szSplashName;

    if (!RegisterClass(&splashWndClass))
        return FALSE;

    width=100;
    height=100;
	SplshWidth = 7;
	SplshHeight = 18;
    splash_hWnd = CreateWindow(szSplashName, "SvStrife Splash Screen",
             WS_CAPTION | WS_POPUP,
             0, 0, 320, 200,
             NULL, NULL, hInstance, NULL);
    splashDC=GetDC(splash_hWnd);
    GetClientRect(splash_hWnd, &cRect);
    width += (SplshWidth * 80) - cRect.right;
    height += (SplshHeight * 25) - cRect.bottom;
    // proff 11/09/98: Added code for centering console
    scr_width = GetSystemMetrics(SM_CXFULLSCREEN);
    scr_height = GetSystemMetrics(SM_CYFULLSCREEN);
    MoveWindow(splash_hWnd, (scr_width-width)/2, (scr_height-height)/2, width, height, TRUE);
    GetClientRect(splash_hWnd, &cRect);
    SetBkColor(splashDC, RGB(0,0,0));
    SetBkMode(splashDC, OPAQUE);
    ReleaseDC(splash_hWnd,splashDC);
    ShowWindow(splash_hWnd, SW_SHOW);
    UpdateWindow(splash_hWnd);

	//draw splash graphics
	//do background
	lumpSize = W_LumpLength(W_GetNumForName("STARTUP0"));
	for(i = 0; i < lumpSize; i++)
	{
		SetPixel(splashDC, x, y, PALETTERGB(palette[startUp[i] * 3],
			palette[(startUp[i] * 3) + 1], palette[(startUp[i] * 3) + 2]));
		x++;
		if((x % 320) == 0)
		{
			y++;
			x = 0;
		}
	}
	//do sentry
	y = 248; x = 0;
	startUp = W_CacheLumpName("STRTBOT");
	lumpSize = W_LumpLength(W_GetNumForName("STRTBOT"));
	for(i = 0; i < lumpSize; i++)
	{
		SetPixel(splashDC, x, y, PALETTERGB(palette[startUp[i] * 3],
			palette[(startUp[i] * 3) + 1], palette[(startUp[i] * 3) + 2]));
		x++;
		if((x % 48) == 0)
		{
			y++;
			x = 0;
		}
	}
	/*animation stuff goes here*/
	//abuse I_uSleep at all costs
	for(k = 64; k < 64 + (16*14); k += 16)
	{
		//do zapper
		y = 256; x = k;
		startUp = W_CacheLumpName(animZap[k % 32 == 0 ? 0 : 1]);
		lumpSize = W_LumpLength(W_GetNumForName(animZap[k % 32 == 0 ? 0 : 1]));
		for(i = 0; i < lumpSize; i++)
		{
			SetPixel(splashDC, x, y, PALETTERGB(palette[startUp[i] * 3],
				palette[(startUp[i] * 3) + 1], palette[(startUp[i] * 3) + 2]));
			x++;
			if((x % 16) == 0)
			{
				y++;
				x = k;
			}
		
		}
		//do peasant
		lumpSize = W_LumpLength(W_GetNumForName(animPeas[cycle]));
		startUp = W_CacheLumpName(animPeas[cycle]);
		x = 288;
		y = 240;
		for(i = 0; i < lumpSize; i++)
		{
			SetPixel(splashDC, x, y, PALETTERGB(palette[startUp[i] * 3],
				palette[(startUp[i] * 3) + 1], palette[(startUp[i] * 3) + 2]));
			x++;
			k % 80 == 0 ? cycle++ : cycle + 0;
			if(cycle >= 3)
				cycle = 0;
			if((x % 32) == 0)
			{
				y++;
				x = 288;
			}
		}
		I_uSleep(40000);
		//clear zap pixel
		y = 256; x = k;
		for(i = 0; i < lumpSize; i++)
		{
			SetPixel(splashDC, x, y, 0);
			x++;
			if((x % 16) == 0)
			{
				y++;
				x = k;
			}
		
		}
	}
    return TRUE;
}

void FinishSplashWin(void)
{
  if (splash_hWnd)
    DestroyWindow(splash_hWnd);
  UnregisterClass(szSplashName,GetModuleHandle(NULL));
  splash_hWnd=0;
}