// DeHackEd version 3.0a
// Written by Greg Lewis, gregl@umich.edu
// If you release any versions of this code, please include
// the author in the credits.  Give credit where credit is due!

// Function prototypes for print.cpp
void Printcodep(void);
void Printframe(void);
void Printhelp(void);
int  Printinputwindow(char *buffer, char *prompt, EInptype type, int length,
							 char firstchar = 0);
void Printintro(void);
void Printmisc(void);
void Printmisccheat(void);
void Printmiscmisc(void);
void Printmiscweapon(void);
void Printoptions(void);
void Printsound(void);
void Printsprite(void);
void Printtext(void);
void Printtextintro(void);
void Printtextstring(EBool leavewindow);
void Printthing(void);
void Printthingbits(void);
void Printthingframe(void);
void Printthinginfo(void);
void Printthingmisc(void);
void Printthingsound(void);
EBool Printwindow(char *message, int type);

// This is an offset to be used for computing the text stuff.
long toff[NUMVERS] = {129044L, 129044L, 129044L, 129284L, 129380L};

// Functions from screen.cpp
extern void CPrintfXY(int x, int y, char *string, ...);
extern void CPutsXY(int x, int y, char *string);
extern void Drawframe(int type, unsigned char attr, int left, int top,
							 int right, int bot);
extern void Getwindow(int x1, int y1, int x2, int y2);
extern void Putwindow(void);

// Variables from dehacked.cpp
extern ERedraw redraw;						//	Current redraw state
extern EModes  mode;							//	The mode we start in
extern EVersions version;   	         // The Doom version we're using
extern char thingorder[THING_FIELDS];
extern char doomexe[80];					// Doom.exe file name
extern char doomwad[80];					// Doom.wad file name
extern char patchdir[80];					// Patch file directory
extern EBool batch;							// If we're running in batch mode
extern ScreenSet *Modeptr;					// Pointer to Data for the current mode

extern long (*thingdata )[THING_FIELDS];
extern long (*framedata )[FRAME_FIELDS];
extern long (*weapondata)[WEAPON_FIELDS];
extern long (*sounddata )[SOUND_FIELDS];
extern long *spritedata;
extern char *textdata;
extern long *codepdata;
extern char *cheatdata;
extern long *ammodata;
extern long *miscdata;
extern struct sb_conf dev;
extern int codepoff[448][5];
extern int cheatinfo[17][2];

// All data on objects
extern DataSet Data[NUMDATA];

// Functions from dehacked.cpp
extern void AbortProg(char *func);

// Functions from misc.cpp
extern void Cheatconvert(char *string, char *cheat, int length);
extern void Getframename(int framenum, char *string);
extern void Getsoundname(int soundnum, char *string);
extern void Getspritename(int spritenum, char *string);
extern void Highlightname(char *name);

// Variables from sb_regs.c
extern int SB_DMA_CHAN;

// Functions from input.h
extern int Getinput(int promptlen, char *string, int maxlen, int type, int x1,
						  char firstchar = 0);
extern EBool Waitforevent(EBool eatevent);

// Names for the different types of data... used in loading patches.
// Must be one word only.
char *datanames[NUMDATA] = {"Thing",   	//	#defined to be... 0
									 "Frame",		// 1
									 "Weapon",		// 2
									 "Sound", 	  	// 3
									 "Sprite",		// 4
									 "Text",   		// 5
									 "Pointer", 	// 6
									 "Cheat", 		// 7
									 "Ammo",			// 8
									 "Misc"};		// 9

// Name for all the fields of all the data types... whew...
char *thingfields[23] = {"ID #",
								 "Initial frame",
								 "Hit points",
								 "First moving frame",
								 "Alert sound",
								 "Reaction time",
								 "Attack sound",
								 "Injury frame",
								 "Pain chance",
								 "Pain sound",
								 "Close attack frame",
								 "Far attack frame",
								 "Death frame",
								 "Exploding frame",
								 "Death sound",
								 "Speed",
								 "Width",
								 "Height",
								 "Mass",
								 "Missile damage",
								 "Action sound",
								 "Bits",
								 "Respawn frame"};
char *soundfields[9] = {"Offset",
								"Zero/One",
								"Value",
								"Zero 1",
								"Neg. One 1",
								"Neg. One 2",
								"Zero 2",
								"Zero 3",
								"Zero 4"};
char *framefields[7] = {"Sprite number",
								"Sprite subnumber",
								"Duration",
								"Action pointer",
								"Next frame",
								"Unknown 1",
								"Unknown 2"};
char *weaponfields[6] = {"Ammo type",
								 "Deselect frame",
								 "Select frame",
								 "Bobbing frame",
								 "Shooting frame",
								 "Firing frame"};
char *fullwepfields[8] = {"Ammo number",
								  "Init. max ammo",
								  "Ammo per item",
								  "Deselect frame",
								  "Select frame",
								  "Bobbing frame",
								  "Shooting frame",
								  "Firing frame"};
char *cheatfields[17] = {"Change music",
								 "Chainsaw",
								 "God mode",
								 "Ammo & Keys",
								 "Ammo",
								 "No Clipping 1",
								 "No Clipping 2",
								 "Invincibility",
								 "Berserk",
								 "Invisibility",
								 "Radiation Suit",
								 "Auto-map",
								 "Lite-Amp Goggles",
								 "BEHOLD menu",
								 "Level Warp",
								 "Player Position",
								 "Map cheat"};
char *miscfields[16] = {"Initial Health",
								"Initial Bullets",
								"Max Health",
								"Max Armor",
								"Green Armor Class",
								"Blue Armor Class",
								"Max Soulsphere",
								"Soulsphere Health",
								"Megasphere Health",
								"God Mode Health",
								"IDFA Armor",
								"IDFA Armor Class",
								"IDKFA Armor",
								"IDKFA Armor Class",
								"BFG Cells/Shot",
								"Monsters Infight"};

// Here are names for all of the types of Ammo, types of Weapons, and
// types of Things.
char *ammolist[6] = {"Bullets",
							"Shells",
							"Cells",
							"Rockets",
							"Not Used",
							"Unlimited"};

char *weaponlist[9]={"Fists",
							"Pistol",
							"Shotgun",
							"Chaingun",
							"Rocket Launcher",
							"Plasma Gun",
							"BFG 9000",
							"Chainsaw",
							"Super Shotgun"};

char namelist[138][18] = {"Player",
							  "Trooper",
							  "Sargeant",
							  "Archvile",
							  "Archvile Attack",
							  "Revenant",
							  "Revenant Fireball",
							  "Fireball Trail",
							  "Mancubus",
							  "Mancubus Fireball",
							  "Chaingun Sargeant",

							  "Imp",
							  "Demon",
							  "Spectre",
							  "Cacodemon",
							  "Baron of Hell",
							  "Baron Fireball",
							  "Hell Knight",
							  "Lost Soul",
							  "Spiderdemon",
							  "Arachnotron",

							  "Cyberdemon",
							  "Pain Elemental",
							  "SS Nazi",
							  "Commander Keen",
							  "Big Brain",
							  "Demon Spawner",
							  "Demon Spawn Spot",
							  "Demon Spawn Cube",
							  "Demon Spawn Fire",
							  "Barrel",

							  "Imp Fireball",
							  "Caco Fireball",
							  "Rocket (in air)",
							  "Plasma Bullet",
							  "BFG Shot",
							  "Arach. Fireball",
							  "Bullet Puff",
							  "Blood Splat",
							  "Teleport Flash",
							  "Item Respawn Fog",

							  "Teleport Exit",
							  "BFG Hit",
							  "Green Armor",
							  "Blue Armor",
							  "Health Potion",
							  "Armor Helmet",
							  "Blue Keycard",
							  "Red Keycard",
							  "Yellow Keycard",
							  "Yellow Skull Key",

							  "Red Skull Key",
							  "Blue Skull Key",
							  "Stim Pack",
							  "Medical Kit",
							  "Soul Sphere",
							  "Invulnerability",
							  "Berserk Sphere",
							  "Blur Sphere",
							  "Radiation Suit",
							  "Computer Map",

							  "Lite Amp. Visor",
							  "Mega Sphere",
							  "Ammo Clip",
							  "Box of Ammo",
							  "Rocket",
							  "Box of Rockets",
							  "Energy Cell",
							  "Energy Pack",
							  "Shells",
							  "Box of Shells",

							  "Backpack",
							  "BFG 9000",
							  "Chaingun",
							  "Chainsaw",
							  "Rocket Launcher",
							  "Plasma Gun",
							  "Shotgun",
							  "Super Shotgun",
							  "Tall Lamp",
							  "Tall Lamp 2",

							  "Short Lamp",
							  "Tall Gr. Pillar",
							  "Short Gr. Pillar",
							  "Tall Red Pillar",
							  "Short Red Pillar",
							  "Pillar w/Skull",
							  "Pillar w/Heart",
							  "Eye in Symbol",
							  "Flaming Skulls",
							  "Grey Tree",

							  "Tall Blue Torch",
							  "Tall Green Torch",
							  "Tall Red Torch",
							  "Small Blue Torch",
							  "Small Gr. Torch",
							  "Small Red Torch",
							  "Brown Stub",
							  "Technical Column",
							  "Candle",
							  "Candelabra",

							  "Swaying Body",
							  "Hanging Arms Out",
							  "One-legged Body",
							  "Hanging Torso",
							  "Hanging Leg",
							  "Hanging Arms Out2",
							  "Hanging Torso 2",
							  "One-legged Body 2",
							  "Hanging Leg 2",
							  "Swaying Body 2",

							  "Dead Cacodemon",
							  "Dead Marine",
							  "Dead Trooper",
							  "Dead Demon",
							  "Dead Lost Soul",
							  "Dead Imp",
							  "Dead Sargeant",
							  "Guts and Bones",
							  "Guts and Bones 2",
							  "Skewered Heads",

							  "Pool of Blood",
							  "Pole with Skull",
							  "Pile of Skulls",
							  "Impaled Body",
							  "Twitching Body",
							  "Large Tree",
							  "Flaming Barrel",
							  "Hanging Body 1",
							  "Hanging Body 2",
							  "Hanging Body 3",

							  "Hanging Body 4",
							  "Hanging Body 5",
							  "Hanging Body 6",
							  "Pool Of Blood 1",
							  "Pool Of Blood 2",
							  "Brains",
							  "Clipboard"};

