/* dhdiff.c 2.0 by Paul Falstad
 * warning: this code is a real hack
 */

#include <stdio.h>
#include <stdlib.h>

int new = 0;

char *tattr[] = {
    "thing no", "first frame", "toughness", "moving frame",
    "alert sound", "reaction time", "attack sound", "injury frame",
    "pain chance", "pain sound", "close attack frame", "distance attack frame",
    "death frame", "explode frame", "death sound", "speed",
    "hsize", "height", "mass", "missile damage",
    "act sound", "bits", "respawn frame"
};

char *ammo1[] = {
    "pistol", "shotgun", "launcher", "plasma"
};

char *ammo2[] = {
    "punch", "pistol", "shotgun", "chaingun", "launcher",
    "plasma", "bfg", "chainsaw", "super-shotgun"
};

char *ammoattr[] = {
    "ammo type", "bob frame 1", "bob frame 2", "bob frame 3",
    "shoot frame", "firing frame"
};

char *fattr[] = {
    "sprite no", "sprite subno", "duration", "code ptr",
    "next frame", "?2", "?3"
};

char *tnames[103] = {
    "Player",
    "Imp",
    "Trooper",
    "Sargeant",
    "Demon",
    "Spector",
    "Cacodemon",
    "Lost Soul",
    "Baron",
    "Spider Boss",
    "Cyberdemon",
    "Barrel",
    "Imp Fireball",
    "Caco Fireball",
    "Baron Fireball",
    "Rocket",
    "Plasma Bullet",
    "BFG Shot",
    "Bullet Puffs",
    "Blood Splats",
    "Teleport Flash",
    "Teleport Exit",
    "BFG Hit",
    "Green Armor",
    "Blue Armor",
    "Health Potion",
    "Armor Helmet",
    "Blue Keycard",
    "Red Keycard",
    "Yellow Keycard",
    "Yellow Skull Key",
    "Red Skull Key",
    "Blue Skull Key",
    "Stim Pack",
    "Medical Kit",
    "Soul Sphere",
    "Invulnerability",
    "Berserk Sphere",
    "Blur Sphere",
    "Radiation Suit",
    "Computer Map",
    "Lite Amp. Goggles",
    "Ammo Clip",
    "Box of Ammo",
    "Rocket",
    "Box of Rockets",
    "Energy Cell",
    "Energy Pack",
    "Shells",
    "Box of Shells",
    "Backpack",
    "BFG9000",
    "Chaingun",
    "Chainsaw",
    "Rocket Launcher",
    "Plasma Gun",
    "Shotgun",
    "Lamp",
    "Tall Green Pillar",
    "Short Green Pillar",
    "Tall Red Pillar",
    "Short Red Pillar",
    "Red Pillar w/Skull",
    "Pillar w/Heart",
    "Eye in Symbol",
    "Flaming Skulls",
    "Grey Tree",
    "Tall Blue Torch",
    "Tall Green Torch",
    "Tall Red Torch",
    "Short Blue Torch",
    "Short Green Torch",
    "Short Red Torch",
    "Brown Stub",
    "Technical Column",
    "Candle",
    "Candelabra",
    "Swaying Body",
    "Hanging Arms Out",
    "One-legged Body",
    "Hanging Torso",
    "Hanging Leg",
    "Hanging Arms Out 2",
    "Hanging Torso 2",
    "One-legged Body 2",
    "Hanging Leg 2",
    "Swaying Body 2",
    "Dead Cacodemon",
    "Dead Marine",
    "Dead Trooper",
    "Dead Demon",
    "Dead Lost Soul",
    "Dead Imp",
    "Dead Sargeant",
    "Guts and Bones",
    "Guts and Bones 2",
    "Skewered Heads",
    "Pool of Blood",
    "Pole with Skull",
    "Pile of Skulls",
    "Impaled Body",
    "Twitching Body",
    "Large Tree",
};

char *tnames2[137] = {
    "Player",
    "Trooper",
    "Sargeant",
    "Archvile",
    "Vile Attack",
    "Revenant",
    "Revenant Fireball",
    "Fireball Trail",
    "Mancubus",
    "Mancubus Fireball",
    "Chaingun Sargeant",
    "Imp",
    "Demon",
    "Spectre",
    "Cacodemon",
    "Baron of Hell",
    "Baron Fireball",
    "Hell Knight",
    "Lost Soul",
    "Spiderdemon",
    "Arachnotron",
    "Cyberdemon",
    "Pain Elemental",
    "SS Nazi",
    "Commander Keen",
    "Big Brain",
    "SS Nazi",
    "Demon Spawn Spot",
    "Demon Spawn Cube",
    "Demon Spawn Fire",
    "Barrel",
    "Imp Fireball",
    "Caco Fireball",
    "Rocket (in air)",
    "Plasma Bullet",
    "BFG Shot",
    "Arach. Fireball",
    "Bullet Puff",
    "Blood Splat",
    "Teleport Flash",
    "Item Respawn Fog",
    "Teleport Exit",
    "BFG Hit",
    "Green Armor",
    "Blue Armor",
    "Health Potion",
    "Armor Helmet",
    "Blue Keycard",
    "Red Keycard",
    "Yellow Keycard",
    "Yellow Skull Key",
    "Red Skull Key",
    "Blue Skull Key",
    "Stim Pack",
    "Medical Kit",
    "Soul Sphere",
    "Invulnerability",
    "Berserk Sphere",
    "Blur Sphere",
    "Radiation Suit",
    "Computer Map",
    "Lite Amp. Visor",
    "Mega Sphere",
    "Ammo Clip",
    "Box of Ammo",
    "Rocket",
    "Box of Rockets",
    "Energy Cell",
    "Energy Pack",
    "Shells",
    "Box of Shells",
    "Backpack",
    "BFG9000",
    "Chaingun",
    "Chainsaw",
    "Rocket Launcher",
    "Plasma Gun",
    "Shotgun",
    "Super Shotgun",
    "Tall Lamp",
    "Tall Lamp 2",
    "Short Lamp",
    "Tall Gr. Pillar",
    "Short Gr. Pillar",
    "Tall Red Pillar",
    "Short Red Pillar",
    "Pillar w/Skull",
    "Pillar w/Heart",
    "Eye in Symbol",
    "Flaming Skulls",
    "Grey Tree",
    "Tall Blue Torch",
    "Tall Green Torch",
    "Tall Red Torch",
    "Small Blue Torch",
    "Small Gr. Torch",
    "Small Red Torch",
    "Brown Stub",
    "Technical Column",
    "Candle",
    "Candelabra",
    "Swaying Body",
    "Hanging Arms Out",
    "One-legged Body",
    "Hanging Torso",
    "Hanging Leg",
    "Hanging Arms Out2",
    "Hanging Torso 2",
    "One-legged Body 2",
    "Hanging Leg 2",
    "Swaying Body 2",
    "Dead Cacodemon",
    "Dead Marine",
    "Dead Trooper",
    "Dead Demon",
    "Dead Lost Soul",
    "Dead Imp",
    "Dead Sargeant",
    "Guts and Bones",
    "Guts and Bones 2",
    "Skewered Heads",
    "Pool of Blood",
    "Pole with Skull",
    "Pile of Skulls",
    "Impaled Body",
    "Twitching Body",
    "Large Tree",
    "Fuel Can",
    "Hanging Body 1",
    "Hanging Body 2",
    "Hanging Body 3",
    "Hanging Body 4",
    "Hanging Body 5",
    "Hanging Body 6",
    "Pool Of Blood 1",
    "Pool Of Blood 2",
    "Pool Of Brains"
};

char *bitattr[] = {
    "Gettable Thing",
    "Obstacle",
    "Shootable Thing",
    "Total Invis.",
    "Automatics",
    "Unknown",
    "In Pain",
    "Unknown",
    "Hangs from ceil",
    "Not-on-ground",
    "Proj/players",
    "Can get stuff",
    "No Clipping",
    "Unknown",
    "Float Monsters",
    "Semi-No Clip.",
    "Projectiles",
    "Disappearing Weapon",
    "Partial Invis.",
    "Bleeds (vs. puffs)",
    "Sliding Helpless",
    "Unknown",
    "Counts for Kill %",
    "Counts for Item %",
    "Running",
    "Not in DMatch",
    "Color 1",
    "Color 2",
    "Unknown",
    "Unknown",
    "Unknown",
    "Unknown",
};

char *old_sprs[] = {
	"TROO", "SHTG", "PUNG", "PISG", "PISF", "SHTF", "CHGG", "CHGF",
	"MISG", "MISF", "SAWG", "PLSG", "PLSF", "BFGG", "BFGF", "BLUD",
	"PUFF", "BAL1", "BAL2", "BAL7", "PLSS", "PLSE", "MISL", "BFS1",
	"BFE1", "BFE2", "PLAY", "POSS", "SPOS", "SARG", "HEAD", "BOSS",
	"SKUL", "SPID", "CYBR", "TFOG", "ARM1", "ARM2", "BAR1", "BEXP",
	"BON1", "BON2", "BKEY", "RKEY", "YKEY", "BSKU", "RSKU", "YSKU",
	"STIM", "MEDI", "SOUL", "PINV", "PSTR", "PINS", "SUIT", "PMAP",
	"PVIS", "CLIP", "AMMO", "ROCK", "BROK", "CELL", "CELP", "SHEL",
	"SBOX", "BPAK", "BFUG", "MGUN", "CSAW", "LAUN", "PLAS", "SHOT",
	"COLU", "SMT2", "GOR1", "POL2", "POL5", "POL4", "POL3", "POL1",
	"POL6", "GOR2", "GOR3", "GOR4", "GOR5", "SMIT", "COL1", "COL2",
	"COL3", "COL4", "CAND", "CBRA", "COL6", "TRE1", "TRE2", "ELEC",
	"CEYE", "FSKU", "COL5", "TBLU", "TGRN", "TRED", "SMBT", "SMGT",
	"SMRT"
};

#define HEADER_2_0 ('P'|('a'<<8))

#define THING_VAL_COUNT ((new) ? 23 : 22)
#define THING_COUNT ((new) ? 137 : 103)
#define TNAMES ((new) ? tnames2 : tnames)
#define FRAME_COUNT ((new) ? 966 : 512)

struct sstate {
    char *str;
    int size;
};
typedef struct sstate sstate;

void
sstate_init(sstate *ss)
{
    ss->str = malloc(ss->size = 100);
}

int
getstr(sstate *ss, FILE *in)
{
    int len = 0;

    while (fread(ss->str+len, 1, 4, in)) {
	char *p = ss->str+len;
	if (!(p[0] && p[1] && p[2] && p[3]))
	    return 1;
	len += 4;
	if (len >= ss->size)
	    ss->str = realloc(ss->str, ss->size *= 2);
    }
    return 0;
}

void
get_str_by_ptr(char *buf, long *off, FILE *in)
{
    long foff = ftell(in);

    *off -= 0x1f814;
    fseek(in, *off+0xad2e, SEEK_SET);
    fread(buf, 12, 1, in);
    fseek(in, foff, SEEK_SET);
}

char *
get_spr_name(char *buf, int spr, FILE *in)
{
    long foff = ftell(in);
    long soff;

    if (!new)
	return old_sprs[spr];
    fseek(in, spr*4+0xab06, SEEK_SET);
    fread(&soff, sizeof soff, 1, in);
    fseek(in, foff, SEEK_SET);
    get_str_by_ptr(buf, &soff, in);
    return buf;
}

main(ac, av)
int ac;
char **av;
{
    FILE *in1, *in2;
    short x;
    long tbuf1[23], tbuf2[23];
    long fbuf1[7], fbuf2[7];
    int i, j;
    sstate sstate1;
    sstate sstate2;

    if (ac < 3) {
	fprintf(stderr, "dhdiff v2.0 by Paul Falstad\nusage: dhdiff file1.deh file2.deh\n");
	exit(1);
    }
    memset(tbuf1, 0, sizeof tbuf1);
    memset(tbuf2, 0, sizeof tbuf2);
    sstate_init(&sstate1);
    sstate_init(&sstate2);
    in1 = fopen(av[1], "rb");
    if (!in1) {
	fprintf(stderr, "dhdiff: can't open %s: %s\n", av[1],
	    strerror(errno));
	exit(1);
    }
    in2 = fopen(av[2], "rb");
    if (!in2) {
	fprintf(stderr, "dhdiff: can't open %s: %s\n", av[2],
	    strerror(errno));
	exit(1);
    }
    fread(&x, 1, sizeof x, in1);
    if (x == HEADER_2_0) {
	/* this is a DEH 2.0 header... skip it. */
	char buf[28-2];
	int c;
	
	fread(buf, 1, sizeof buf, in1);
	c = getc(in1);
	c = getc(in1);
	if (c != 4) {
	    fprintf(stderr, "don't understand format of %s\n", av[1]);
	    exit(1);
	}
	new = 1;
    }
    fread(&x, 1, sizeof x, in2);
    if (new) {
	char buf[28-2+2];
	if (x != HEADER_2_0) {
	    fprintf(stderr, "patch files are from different versions of dehacked\n");
	    exit(1);
	}
	fread(buf, 1, sizeof buf, in2);
    } else if (x == HEADER_2_0) {
	fprintf(stderr,
	    "patch files are from different versions of dehacked\n");
	exit(1);
    }
    for (i = 0; i != THING_COUNT; i++) {
	fread(tbuf1, THING_VAL_COUNT, sizeof *tbuf1, in1);
	fread(tbuf2, THING_VAL_COUNT, sizeof *tbuf2, in2);
	if (memcmp(tbuf1, tbuf2, sizeof tbuf1)) {
	    printf("%s (thing %d) differences:\n", TNAMES[i], i+1);
	    for (j = 0; j != THING_VAL_COUNT; j++) {
		if (j == 21) {
		    int k;
		    long o1, o2;
		    long b1 = tbuf1[21];
		    long b2 = tbuf2[21];
		    unsigned long b = 1;
		    for (k = 0; k != 32; k++, b<<=1) {
			if ((o1 = (b1 & b)) != (o2 = (b2 & b)))
			    printf("  %s (bit %d) (%d -> %d)\n",
				bitattr[k], k, !!o1, !!o2);
		    }
		} else if (tbuf1[j] != tbuf2[j])
		    printf("  %s (%ld -> %ld)\n", tattr[j],
			tbuf1[j], tbuf2[j]);
	    }
	}
    }
    for (i = 0; i != 8+6*(new ? 9 : 8); i++) {
	long x1, x2;
	fread(&x1, 4, 1, in1);
	fread(&x2, 4, 1, in2);
	if (x1 != x2) {
	    if (i < 4)
		printf("%s ammo capacity differs: (%ld -> %ld)\n", ammo1[i&3],
		    x1, x2);
	    else if (i < 8)
		printf("%s ammo item size differs: (%ld -> %ld)\n", ammo1[i&3],
		    x1, x2);
	    else
		printf("%s %s differs: (%ld -> %ld)\n",
		    ammo2[(i-8)/6], ammoattr[(i-8)%6],
		    x1, x2);
	}
    }
    for (i = 0; i != FRAME_COUNT; i++) {
	fread(fbuf1, 1, sizeof fbuf1, in1);
	fread(fbuf2, 1, sizeof fbuf2, in2);
	if (feof(in1) || feof(in2))
	    break;
	if (memcmp(fbuf1, fbuf2, sizeof fbuf1)) {
	    char spname1[12], spname2[12];
	    printf("frame %d differences:\n", i);
	    if ((fbuf1[1] & 0x8000) != (fbuf2[1] & 0x8000))     
		printf("  full brightness (%d -> %d)\n",
		    (fbuf1[1] & 0x8000) != 0,
		    (fbuf2[1] & 0x8000) != 0);
	    fbuf1[1] &= ~0x8000;
	    fbuf2[1] &= ~0x8000;
	    for (j = 0; j != 7; j++) {
		if (fbuf1[j] != fbuf2[j]) {
		    if (!j)
			printf("  %s (%s -> %s)\n",
			    fattr[j], get_spr_name(spname1, fbuf1[j], in1),
			    get_spr_name(spname2, fbuf2[j], in2));
		    else
			printf("  %s (%ld -> %ld)\n", fattr[j],
			    fbuf1[j], fbuf2[j]);
		}
	    }
	}
    }
    if (!new)
	exit(0);
    for (i = 0; i != 107; i++) {
	long sbuf1[9], sbuf2[9];
	fread(sbuf1, 1, sizeof sbuf1, in1);
	fread(sbuf2, 1, sizeof sbuf2, in2);
	if (!memcmp(sbuf1, sbuf2, sizeof sbuf1))
	    continue;
	printf("sound %d differences:\n", i+1);
	if (sbuf1[0] != sbuf2[0]) {
	    char snbuf1[12], snbuf2[12];
	    get_str_by_ptr(snbuf1, &sbuf1[0], in1);
	    get_str_by_ptr(snbuf2, &sbuf2[0], in2);
	    printf("  name (%ld (%s) -> %ld (%s))\n",
		sbuf1[0], snbuf1, sbuf2[0], snbuf2);
	}
	if (sbuf1[1] != sbuf2[1])
	    printf("  0/1 (%ld -> %ld)\n", sbuf1[1], sbuf2[1]);
	if (sbuf1[2] != sbuf2[2])
	    printf("  value (%ld -> %ld)\n", sbuf1[2], sbuf2[2]);
    }
    for (i = 0; i != 138; i++) {
	long s1, s2;
	char sbuf1[12], sbuf2[12];
	fread(&s1, 1, sizeof s1, in1);
	fread(&s2, 1, sizeof s2, in2);
	if (s1 == s2) continue;
	get_str_by_ptr(sbuf1, &s1, in1);
	get_str_by_ptr(sbuf2, &s2, in2);
	printf("sprite pointer %d differs (%ld (%s) -> %ld (%s))\n",
	    i, s1, sbuf1, s2, sbuf2);
    }
    while (getstr(&sstate1, in1) && getstr(&sstate2, in2)) {
	if (strcmp(sstate1.str, sstate2.str))
	    printf("string differs:\n  \"%s\" ->\n  \"%s\"\n",
		sstate1.str, sstate2.str);
    }
}
