VERSION 2.00
Begin Form EdtGraph 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Graphic"
   ClientHeight    =   5775
   ClientLeft      =   510
   ClientTop       =   915
   ClientWidth     =   8880
   ClipControls    =   0   'False
   Height          =   6150
   Icon            =   EDTGRAPH.FRX:0000
   Left            =   465
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   5775
   ScaleWidth      =   8880
   Top             =   585
   Width           =   8970
   Begin Frame PicFrame 
      BackColor       =   &H00C0C0C0&
      ClipControls    =   0   'False
      Height          =   3195
      HelpContextID   =   4010
      Left            =   1740
      TabIndex        =   23
      Top             =   0
      Width           =   5415
      Begin PictureBox GraphPic 
         BackColor       =   &H00FFFF00&
         BorderStyle     =   0  'None
         Height          =   2955
         Left            =   60
         ScaleHeight     =   2955
         ScaleWidth      =   5295
         TabIndex        =   24
         Top             =   120
         Width           =   5295
      End
   End
   Begin CommandButton Cmd 
      Caption         =   "Rename"
      Height          =   315
      HelpContextID   =   4050
      Index           =   1
      Left            =   240
      TabIndex        =   22
      Top             =   4860
      Width           =   1035
   End
   Begin CommandButton CmdDir 
      Caption         =   "Change Directory"
      Height          =   315
      Left            =   7020
      TabIndex        =   21
      Top             =   5340
      Width           =   1695
   End
   Begin FileListBox Gallery 
      Height          =   1590
      Left            =   7020
      Pattern         =   "*.bmp"
      TabIndex        =   20
      Top             =   3660
      Width           =   1695
   End
   Begin CommandButton Cmd 
      Caption         =   "Import"
      Height          =   315
      HelpContextID   =   4040
      Index           =   2
      Left            =   240
      TabIndex        =   19
      Top             =   4020
      Width           =   1035
   End
   Begin ListBox EntryName 
      BackColor       =   &H00808080&
      Height          =   2955
      HelpContextID   =   4045
      Left            =   120
      TabIndex        =   18
      Top             =   960
      Width           =   1515
   End
   Begin CommandButton CmdSave 
      BackColor       =   &H00808080&
      Caption         =   "Save"
      Height          =   315
      HelpContextID   =   4070
      Left            =   180
      TabIndex        =   17
      Top             =   540
      Width           =   1155
   End
   Begin SSCheck ERepeat 
      Caption         =   "Repeat previous entry"
      Font3D          =   0  'None
      Height          =   195
      HelpContextID   =   4000
      Left            =   6660
      TabIndex        =   15
      Top             =   3300
      Width           =   2175
   End
   Begin SSFrame FrameOfs 
      Alignment       =   2  'Center
      Caption         =   "Picture Offset"
      Font3D          =   0  'None
      ForeColor       =   &H00000000&
      Height          =   3075
      Left            =   7200
      TabIndex        =   9
      Top             =   60
      Width           =   1575
      Begin VScrollBar SetOfsY 
         Height          =   1035
         HelpContextID   =   4080
         LargeChange     =   10
         Left            =   1200
         Max             =   200
         Min             =   -200
         TabIndex        =   25
         Top             =   360
         Width           =   255
      End
      Begin CommandButton CmdApply 
         Caption         =   "Apply"
         Height          =   375
         Left            =   180
         TabIndex        =   16
         Top             =   2580
         Width           =   975
      End
      Begin HScrollBar SetOfsX 
         Height          =   240
         HelpContextID   =   4080
         LargeChange     =   10
         Left            =   120
         Max             =   -320
         Min             =   320
         TabIndex        =   13
         Top             =   360
         Width           =   1035
      End
      Begin SSOption EOffs 
         Caption         =   "Marine Face"
         Font3D          =   0  'None
         Height          =   195
         HelpContextID   =   4080
         Index           =   2
         Left            =   120
         TabIndex        =   12
         Top             =   2220
         Width           =   1395
      End
      Begin SSOption EOffs 
         Caption         =   "Normal"
         Font3D          =   0  'None
         Height          =   195
         HelpContextID   =   4080
         Index           =   1
         Left            =   120
         TabIndex        =   11
         Top             =   1920
         Width           =   975
      End
      Begin SSOption EOffs 
         Caption         =   "No offsets"
         Font3D          =   0  'None
         Height          =   195
         HelpContextID   =   4080
         Index           =   0
         Left            =   120
         TabIndex        =   10
         Top             =   1620
         Width           =   1335
      End
      Begin Label Info 
         BackStyle       =   0  'Transparent
         Caption         =   "Y="
         Height          =   195
         Index           =   1
         Left            =   180
         TabIndex        =   4
         Top             =   1020
         Width           =   255
      End
      Begin Label Info 
         BackStyle       =   0  'Transparent
         Caption         =   "X="
         Height          =   195
         Index           =   0
         Left            =   180
         TabIndex        =   7
         Top             =   720
         Width           =   315
      End
      Begin Label ShowOfsY 
         AutoSize        =   -1  'True
         Caption         =   "0"
         Height          =   195
         Left            =   600
         TabIndex        =   8
         Top             =   1020
         Width           =   120
      End
      Begin Label ShowOfsX 
         AutoSize        =   -1  'True
         Caption         =   "0"
         Height          =   195
         Left            =   600
         TabIndex        =   14
         Top             =   720
         Width           =   135
      End
   End
   Begin CommandButton Cmd 
      Caption         =   "Add"
      Height          =   315
      HelpContextID   =   4020
      Index           =   0
      Left            =   240
      TabIndex        =   6
      Top             =   4440
      Width           =   1035
   End
   Begin ListBox GrphLst 
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Courier"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1980
      Left            =   1800
      TabIndex        =   5
      Top             =   3300
      Width           =   4755
   End
   Begin ComboBox Ident 
      Height          =   300
      HelpContextID   =   4060
      Left            =   1800
      TabIndex        =   3
      TabStop         =   0   'False
      Text            =   "HELP Ident"
      Top             =   5400
      Width           =   4755
   End
   Begin CommandButton Exit 
      BackColor       =   &H00808080&
      Caption         =   "Quit"
      Height          =   315
      Left            =   180
      TabIndex        =   0
      Top             =   120
      Width           =   1155
   End
   Begin Image CmdForget 
      Height          =   480
      Left            =   480
      Picture         =   EDTGRAPH.FRX:0302
      Top             =   5220
      Width           =   480
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   10
      X1              =   720
      X2              =   1560
      Y1              =   5400
      Y2              =   5400
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   9
      X1              =   1620
      X2              =   1440
      Y1              =   4200
      Y2              =   4260
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   8
      X1              =   1440
      X2              =   1620
      Y1              =   4140
      Y2              =   4200
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   5
      X1              =   840
      X2              =   2160
      Y1              =   4200
      Y2              =   4200
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   2
      X1              =   780
      X2              =   2100
      Y1              =   5040
      Y2              =   5040
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   1
      X1              =   720
      X2              =   2040
      Y1              =   4620
      Y2              =   4620
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   0
      X1              =   7920
      X2              =   7920
      Y1              =   5040
      Y2              =   5460
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   6
      X1              =   6240
      X2              =   7320
      Y1              =   4080
      Y2              =   4080
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   4
      X1              =   780
      X2              =   780
      Y1              =   3600
      Y2              =   4200
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   3
      X1              =   1560
      X2              =   1560
      Y1              =   5040
      Y2              =   5400
   End
   Begin Label WadInfo 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "wadinfo.txt"
      ForeColor       =   &H000000FF&
      Height          =   195
      Left            =   900
      TabIndex        =   2
      Top             =   5520
      Visible         =   0   'False
      Width           =   915
   End
   Begin Label WorkDirec 
      Alignment       =   2  'Center
      BackColor       =   &H00808080&
      BackStyle       =   0  'Transparent
      Caption         =   "work dir"
      ForeColor       =   &H000000FF&
      Height          =   195
      Left            =   0
      TabIndex        =   1
      Top             =   5520
      Visible         =   0   'False
      Width           =   795
   End
   Begin Line Line 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   7
      X1              =   4020
      X2              =   4020
      Y1              =   5040
      Y2              =   5400
   End
End
Option Explicit
Dim ListDirty As Integer

Dim GraphFileNam As String

Sub Cmd_Click (Index As Integer)
   Dim file$, file2$
   Dim nam$, entry$
   Dim X%, Y%, repeat%

  Select Case Index
    Case 0 'new
      If Not Tutor("add a new graphic to the list. The entry name is taken from the drop box.") Then Exit Sub
      entry = HelpGetName(Ident, True)
      If Len(entry) <= 0 Then Exit Sub
      file = ChooseFile(".", "*.bmp", True, "Select a new graphic file (.BMP)")
      If Not DIRexistFile(file) Then
        nam = ""
        repeat = True
      Else
        repeat = False
        nam = FileName(file)
        file2 = MakeFileName(WorkDirec.Caption, nam)
        Call EditCopyFile(file, file2)
        nam = FileRoot(file)
      End If
      nam = EntryMake(entry, 0, 0, nam, repeat)
      If Len(nam) <= 0 Then Exit Sub
      GrphLst.ListIndex = ListInsert(GrphLst, nam$)
      ListDirty = True
    Case 1 'rename
      If Not Tutor("rename a graphic using a name taken from the drop box.") Then Exit Sub
      If GrphLst.ListIndex < 0 Then Exit Sub
      entry = EntryGet(X, Y, nam, repeat, GrphLst.Text)
      entry = HelpGetName(Ident, True)
      If Len(entry) <= 0 Then Exit Sub
      nam = EntryMake(entry, X, Y, nam, repeat)
      If Len(nam) <= 0 Then Exit Sub
      GrphLst.List(GrphLst.ListIndex) = nam
       ListDirty = True
    Case 2 'import
      If EntryName.ListIndex < 0 Then Exit Sub
      entry$ = EntryName.Text
      Dim ofx%, ofy%
      If Not WADexportName(WorkDirec.Caption, entry$, ofx%, ofy%) Then Exit Sub
      nam = EntryMake(entry$, ofx%, ofy%, entry$, False)
      If Len(nam) <= 0 Then Exit Sub
      GrphLst.ListIndex = ListInsert(GrphLst, nam$)
      ListDirty = True
  End Select
End Sub

Sub CmdApply_Click ()
  If Not Tutor("validate the changes to the offsets.") Then Exit Sub
  If GrphLst.ListIndex < 0 Then Exit Sub
  Dim entry As String
  Dim nam As String
  Dim X As Integer
  Dim Y As Integer
  Dim repeat As Integer
  entry = EntryGet(X, Y, nam, repeat, GrphLst.Text)
  X = SetOfsX.Value
  Y = SetOfsY.Value
  GrphLst.List(GrphLst.ListIndex) = EntryMake(entry, X, Y, nam, repeat)
   ListDirty = True
End Sub

Sub CmdDir_Click ()
  Gallery.Path = ChooseDir(Gallery.Path, "Indicate the directory of your graphics files (.BMP)")
End Sub

Sub CmdForget_Click ()
  Call EntryDelete(GrphLst, WorkDirec.Caption, ".BMP")
  ListDirty = True
End Sub

Sub CmdSave_Click ()
  If Not Tutor("save the modifications") Then Exit Sub
  If Not ListDirty Then Exit Sub
  Call SectionWrite(GrphLst, WadInfo.Caption, "GRAPHICS")
  ListDirty = False
End Sub

Sub EntryName_Click ()
   If EntryName.ListIndex < 0 Then Exit Sub
   Call WADshowName(GraphPic, EntryName.Text)
   Call HelpMatch(Ident, EntryName.Text)
End Sub

Sub EntryName_KeyPress (KeyAscii As Integer)
  KeyAscii = WADnameSeek(EntryName, KeyAscii)
End Sub

Sub EOffs_Click (Index As Integer, Value As Integer)
   Dim szx, szy As Integer
   Select Case Index
    Case 0
      SetOfsX.Value = 0
      SetOfsY.Value = 0
    Case 1
      szx = GraphPic.Width / Screen.TwipsPerPixelX
      szy = GraphPic.Height / Screen.TwipsPerPixelY
      SetOfsX.Value = szx / 2
      SetOfsY.Value = szy - 5
    Case 2
      SetOfsX.Value = 0
      SetOfsY.Value = -2
  End Select
End Sub

Sub ERepeat_Click (Value As Integer)
  If GrphLst.ListIndex <= 0 Then Exit Sub
  Dim nam$, entry$
  Dim X%, Y%, repeat%
  entry = EntryGet(X, Y, nam, repeat, GrphLst.Text)
  If repeat = Value Then Exit Sub
  repeat = Value
  GrphLst.List(GrphLst.ListIndex) = EntryMake(entry, X, Y, nam, repeat)
  ListDirty = True
End Sub

Sub Exit_Click ()
  Unload Me
End Sub

Sub Form_Load ()
  ListDirty = False
  GraphFileNam = ""
End Sub

Sub Form_Unload (Cancel As Integer)
  If Not ListDirty Then Exit Sub
  If QueryOk("Save file " & WadInfo.Caption & " ?") Then Call CmdSave_Click
End Sub

Sub FrameOfs_DblClick ()
  Call Infos("Positive offsets displace the graphic, Negative ones place it in reference to a 320x200 screen.")
End Sub

Sub Gallery_Click ()
  If Gallery.ListIndex < 0 Then Exit Sub
  Call Display(GraphPic, GraphFileNam, Gallery.FileName)
End Sub

Sub GraphPic_DblClick ()
  Call EditBmpFile(GraphFileNam)
End Sub

Sub GrphLst_Click ()
   If GrphLst.ListIndex < 0 Then Exit Sub
   Dim nam$, entry$
   Dim X%, Y%, repeat%
   entry = EntryGet(X, Y, nam, repeat, GrphLst.Text)
   'set value
   If X <> INVALID Then SetOfsX.Value = X
   If X <> INVALID Then SetOfsY.Value = Y
   ERepeat.Value = 0
   If repeat Then ERepeat.Value = 1
   'load file if exists
   Dim filenam As String
   filenam = MakeFileName(WorkDirec.Caption, nam & ".bmp")
   If repeat Then filenam = ""
   Call Display(GraphPic, GraphFileNam, filenam)
   Call HelpMatch(Ident, entry)
End Sub

Sub GrphLst_DblClick ()
   If GrphLst.ListIndex < 0 Then Exit Sub
   Dim nam$, entry$
   Dim X%, Y%, repeat%
   entry = EntryGet(X, Y, nam, repeat, GrphLst.Text)
   If repeat Then Exit Sub
   Dim file$
   file = MakeFileName(WorkDirec.Caption, nam & ".bmp")
   Call EditBmpFile(file)
End Sub

Sub GrphLst_KeyDown (KeyCode As Integer, Shift As Integer)
  Select Case KeyCode
    Case KEY_DELETE
      Call EntryDelete(GrphLst, WorkDirec.Caption, ".BMP")
      ListDirty = True
  End Select
End Sub

Sub Ident_Change ()
  Call HelpCheckSelect(Ident)
End Sub

Sub Ident_KeyDown (KeyCode As Integer, Shift As Integer)
   If KeyCode = KEY_DELETE Then KeyCode = 0
End Sub

Sub Ident_KeyPress (KeyAscii As Integer)
  KeyAscii = HelpKeyPress(Ident, KeyAscii)
End Sub

Sub SetOfsX_Change ()
 ShowOfsX.Caption = SetOfsX.Value
End Sub

Sub SetOfsY_Change ()
  ShowOfsY.Caption = SetOfsY.Value
End Sub

Sub WadInfo_Change ()
   'ident
  Select Case typeIWAD()
   Case 10, 11 'doom
   HelpD Ident, "TITLEPIC", "startup screen"
   HelpD Ident, "HELP1", "help screen"
   HelpD Ident, "HELP2", "help screen"
   HelpD Ident, "VICTORY2", "victory screen"
   Case 12 'doom2
   HelpD Ident, "WIMAP?", "end level maps"
   HelpD Ident, "INTERPIC", "Doom2 end level pic"
   Case 20, 21, 22'heretic
   HelpD Ident, "MAPE1", "End screen Ep1"
   HelpD Ident, "MAPE2", "End screen Ep2"
   HelpD Ident, "MAPE3", "End screen Ep3"
   HelpD Ident, "BARBACK", "Back of Status bar"
   HelpD Ident, "CHAINBAC", "Back of Chain"
   HelpD Ident, "CHAIN", "Life Chain"
   HelpD Ident, "LIFEGEM?", "Life Gem"
   HelpD Ident, "ARTIBOX", "Box of Artifacts"
   HelpD Ident, "USEARTI?", "Artifact used (A-E)"
   HelpD Ident, "STATBAR", "Status bar"
   HelpD Ident, "INVBAR", "Inventory bar"
   HelpD Ident, "BKEYICON", "Blue key"
   HelpD Ident, "GKEYICON", "Green key"
   HelpD Ident, "YKEYICON", "Yellow key"
   HelpD Ident, "IN?", "Big numbers [0-9]"
   HelpD Ident, "SMALLIN?", "Tiny numbers [0-9]"
   HelpD Ident, "INAMGLD", "Elf Wand"
   HelpD Ident, "INAMBOW", "Crossbow"
   HelpD Ident, "INAMBST", "DragonClaw"
   HelpD Ident, "INAMRAM", "HellStaff"
   HelpD Ident, "INAMPNX", "Phoenix"
   HelpD Ident, "INAMLOB", "Mace"
   HelpD Ident, "LIFEBAR", "Life bar"
   HelpD Ident, "SPINBK??", "Tome of power [0-15]"
   HelpD Ident, "SPFLY??", "Wings of Wrath [0-15]"
   HelpD Ident, "M_HTIC", "Heretic"
   HelpD Ident, "M_SKL??", "Skull [00-17]"
   HelpD Ident, "FONTA??", "Small fonts [00-59]"
   HelpD Ident, "FONTB??", "Big fonts [00-58]"
   HelpD Ident, "ADVISOR", "Advisory (sux!)"
   HelpD Ident, "", ""
   HelpD Ident, "TITLE", "SPECIAL"
   HelpD Ident, "HELP1", "SPECIAL"
   HelpD Ident, "HELP2", "SPECIAL"
   HelpD Ident, "E2END", "SPECIAL (bad palet)"
   HelpD Ident, "FINAL1", "SPECIAL"
   HelpD Ident, "FINAL2", "SPECIAL"
   HelpD Ident, "", ""
  End Select
  Select Case typeIWAD()
   Case 10, 11, 12'doom2
   Call HelpD(Ident, "CREDIT", "game authors")
   Call HelpD(Ident, "PFUB?", "final scenes [1-2]")
   Call HelpD(Ident, "END?", "End text with bullet holes [0-5]")
   Call HelpD(Ident, "AMMNUM?", "Grey digits for ammo count [0-9]")
   Call HelpD(Ident, "STBAR", "Drawing of status Bar")
   Call HelpD(Ident, "STGNUM?", "Small grey digits [0-9]")
   Call HelpD(Ident, "STTNUM?", "Big red digits [0-9]")
   Call HelpD(Ident, "STYSNUM?", "Tiny yellow digits [0-9]")
   Call HelpD(Ident, "STKEYS?", "Normal and Skull keys [1-6]")
   Call HelpD(Ident, "STARMS", "Weapon table")
   Call HelpD(Ident, "STCFN0??", "DOOM fonts [00-39]")
   Call HelpD(Ident, "STFB?", "blackout [0-3]")
   Call HelpD(Ident, "STPB?", "blackout [0-3]")
   Call HelpD(Ident, "STFST?1", "Marine normal [0-4]")
   Call HelpD(Ident, "STFST?0", "Marine peeks left [0-4]")
   Call HelpD(Ident, "STFST?2", "Marine peeks right [0-4]")
   Call HelpD(Ident, "STFTL?0", "Marine hit left [0-4]")
   Call HelpD(Ident, "STFTR?0", "Marine hit right [0-4]")
   Call HelpD(Ident, "STFOUCH?", "Marine hurt [0-4]")
   Call HelpD(Ident, "STFEVL?", "Marine grins [0-4]")
   Call HelpD(Ident, "STFKILL?", "Marine dying [0-4]")
   Call HelpD(Ident, "STFDEAD0", "Marine dead")
   Call HelpD(Ident, "STFGOD0", "Marine invulnerable")
   Call HelpD(Ident, "ST??????", "status bar item")
   Call HelpD(Ident, "M_DOOM", "DOOM logo")
   Call HelpD(Ident, "M_SKULL?", "Pointer [1-2]")
   Call HelpD(Ident, "BRDR_???", "Border")
   Call HelpD(Ident, "WI??????", "End level data")
   Call HelpD(Ident, "CWILEV??", "Doom2 level names [00-31]")
   Case 20, 21, 22'heretic
   Call HelpD(Ident, "FONTA??", "Small fonts")
   Call HelpD(Ident, "FONTB??", "Big fonts")
  End Select
  Call HelpD(Ident, "M_ENDGAM", "End of game message")
  Call HelpD(Ident, "M_PAUSE", "Pause message")
  Call HelpD(Ident, "M_??????", "Menu items")
  Call HelpD(Ident, "????????", "New Graphic")
  Call HelpMatch(Ident, "--------")'set to ????
  'load list
  ListDirty = False
  'read section
  Call SectionRead(GrphLst, WadInfo.Caption, "GRAPHICS", 0)
End Sub

