VERSION 2.00
Begin Form WinTex 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Windoze shell for DeuTex"
   ClientHeight    =   5775
   ClientLeft      =   405
   ClientTop       =   960
   ClientWidth     =   8910
   ClipControls    =   0   'False
   Height          =   6435
   HelpContextID   =   1
   Icon            =   WINTEX.FRX:0000
   Left            =   360
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   5775
   ScaleWidth      =   8910
   Top             =   345
   Width           =   9000
   Begin SSFrame FrameSWad 
      Caption         =   "WAD to examine"
      ForeColor       =   &H00000000&
      Height          =   2295
      Left            =   3120
      TabIndex        =   11
      Top             =   1140
      Width           =   4215
      Begin DriveListBox DTxSDriv 
         Height          =   315
         HelpContextID   =   70
         Left            =   2040
         TabIndex        =   14
         TabStop         =   0   'False
         Top             =   1860
         Width           =   2055
      End
      Begin FileListBox DTxSWad 
         Height          =   1785
         HelpContextID   =   70
         Left            =   120
         Pattern         =   "*.wad"
         TabIndex        =   12
         TabStop         =   0   'False
         Top             =   360
         Width           =   1815
      End
      Begin DirListBox DTxSDir 
         Height          =   1605
         HelpContextID   =   70
         Left            =   2040
         TabIndex        =   13
         TabStop         =   0   'False
         Top             =   180
         Width           =   2055
      End
   End
   Begin CommandButton Cmd 
      Caption         =   "Contents"
      Height          =   375
      HelpContextID   =   1000
      Index           =   2
      Left            =   1680
      TabIndex        =   46
      Top             =   1080
      Width           =   1155
   End
   Begin SSFrame FrameTrg 
      Caption         =   "WAD to build or modify"
      ForeColor       =   &H00000000&
      Height          =   795
      Left            =   3120
      TabIndex        =   41
      Top             =   4860
      Width           =   4215
      Begin CommandButton CmdInfo 
         Caption         =   "Change"
         Height          =   315
         HelpContextID   =   80
         Index           =   3
         Left            =   3180
         TabIndex        =   43
         Top             =   300
         Width           =   915
      End
      Begin Label DTxTWad 
         Alignment       =   2  'Center
         BackColor       =   &H00808080&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "DeuTexTWad"
         Height          =   255
         Left            =   120
         TabIndex        =   42
         Top             =   360
         Width           =   2955
      End
   End
   Begin SSFrame FrameDm 
      Caption         =   "Doom Directory"
      ForeColor       =   &H00000000&
      Height          =   975
      Left            =   3120
      TabIndex        =   44
      Top             =   60
      Width           =   4215
      Begin SSCheck LockDoom 
         Caption         =   "Don't modify game files"
         Height          =   255
         HelpContextID   =   90
         Left            =   120
         TabIndex        =   16
         TabStop         =   0   'False
         Top             =   660
         Value           =   -1  'True
         Width           =   2295
      End
      Begin CommandButton CmdInfo 
         Caption         =   "Change"
         Height          =   315
         HelpContextID   =   90
         Index           =   1
         Left            =   3240
         TabIndex        =   40
         Top             =   300
         Width           =   915
      End
      Begin Label DTxDoom 
         Alignment       =   2  'Center
         BackColor       =   &H00808080&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "DeuTexDoom"
         Height          =   255
         Left            =   120
         TabIndex        =   45
         Top             =   360
         Width           =   2955
      End
   End
   Begin SSFrame FrameWork 
      Caption         =   "Working Directory"
      ForeColor       =   &H00000000&
      Height          =   1095
      Left            =   3120
      TabIndex        =   36
      Top             =   3600
      Width           =   4215
      Begin TextBox WadInf 
         BackColor       =   &H00808080&
         Height          =   285
         Left            =   2040
         TabIndex        =   6
         Text            =   "wadinfo"
         Top             =   660
         Width           =   1035
      End
      Begin CommandButton CmdInfo 
         Caption         =   "Change"
         Height          =   315
         HelpContextID   =   60
         Index           =   2
         Left            =   3180
         TabIndex        =   38
         Top             =   240
         Width           =   915
      End
      Begin CommandButton CmdInfo 
         Caption         =   "Infos"
         Height          =   315
         HelpContextID   =   50
         Index           =   0
         Left            =   3180
         TabIndex        =   39
         Top             =   660
         Width           =   915
      End
      Begin Label Info 
         Alignment       =   2  'Center
         Caption         =   "Wad Informations:"
         ForeColor       =   &H00800000&
         Height          =   255
         Index           =   3
         Left            =   360
         TabIndex        =   8
         Top             =   720
         Width           =   1635
      End
      Begin Label DTxData 
         Alignment       =   2  'Center
         BackColor       =   &H00808080&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "DeuTexData"
         Height          =   255
         Left            =   120
         TabIndex        =   37
         Top             =   300
         Width           =   2955
      End
   End
   Begin SSFrame FrameSel 
      Caption         =   "Select Types"
      ForeColor       =   &H00000000&
      Height          =   3795
      Left            =   120
      TabIndex        =   23
      Top             =   1860
      Width           =   1335
      Begin CommandButton CmdSel 
         Caption         =   "Texture&&Flat"
         Height          =   375
         HelpContextID   =   1400
         Index           =   2
         Left            =   60
         TabIndex        =   35
         Top             =   3360
         Width           =   1215
      End
      Begin CommandButton CmdSel 
         Caption         =   "none"
         Height          =   375
         HelpContextID   =   1400
         Index           =   0
         Left            =   660
         TabIndex        =   34
         Top             =   2940
         Width           =   615
      End
      Begin CommandButton CmdSel 
         Caption         =   "all"
         Height          =   375
         HelpContextID   =   1400
         Index           =   1
         Left            =   60
         TabIndex        =   33
         Top             =   2940
         Width           =   555
      End
      Begin SSCheck CheckSel 
         Caption         =   "Musics"
         Height          =   315
         HelpContextID   =   1400
         Index           =   8
         Left            =   180
         TabIndex        =   32
         Top             =   2580
         Value           =   -1  'True
         Width           =   1035
      End
      Begin SSCheck CheckSel 
         Caption         =   "Flats"
         Height          =   315
         HelpContextID   =   1400
         Index           =   7
         Left            =   180
         TabIndex        =   31
         Top             =   1680
         Value           =   -1  'True
         Width           =   1035
      End
      Begin SSCheck CheckSel 
         Caption         =   "Patches"
         Height          =   315
         HelpContextID   =   1400
         Index           =   6
         Left            =   180
         TabIndex        =   30
         Top             =   1440
         Value           =   -1  'True
         Width           =   1035
      End
      Begin SSCheck CheckSel 
         Caption         =   "Sprites"
         Height          =   315
         HelpContextID   =   1400
         Index           =   5
         Left            =   180
         TabIndex        =   29
         Top             =   2100
         Value           =   -1  'True
         Width           =   1095
      End
      Begin SSCheck CheckSel 
         Caption         =   "Graphics"
         Height          =   315
         HelpContextID   =   1400
         Index           =   4
         Left            =   180
         TabIndex        =   28
         Top             =   540
         Value           =   -1  'True
         Width           =   1095
      End
      Begin SSCheck CheckSel 
         Caption         =   "Textures"
         Height          =   315
         HelpContextID   =   1400
         Index           =   3
         Left            =   180
         TabIndex        =   27
         Top             =   1200
         Value           =   -1  'True
         Width           =   1035
      End
      Begin SSCheck CheckSel 
         Caption         =   "Sounds"
         Height          =   315
         HelpContextID   =   1400
         Index           =   2
         Left            =   180
         TabIndex        =   26
         Top             =   2340
         Value           =   -1  'True
         Width           =   1035
      End
      Begin SSCheck CheckSel 
         Caption         =   "Lumps"
         Height          =   315
         HelpContextID   =   1400
         Index           =   1
         Left            =   180
         TabIndex        =   25
         TabStop         =   0   'False
         Top             =   300
         Value           =   -1  'True
         Width           =   1035
      End
      Begin SSCheck CheckSel 
         Caption         =   "Levels"
         Height          =   315
         HelpContextID   =   1400
         Index           =   0
         Left            =   180
         TabIndex        =   24
         Top             =   960
         Value           =   -1  'True
         Width           =   975
      End
   End
   Begin CommandButton CmdAppF 
      Caption         =   "Add Flats"
      Height          =   375
      HelpContextID   =   1300
      Left            =   7620
      TabIndex        =   9
      Top             =   3840
      Width           =   1155
   End
   Begin CommandButton Cmd 
      Caption         =   "Restore"
      Height          =   375
      HelpContextID   =   1300
      Index           =   7
      Left            =   7620
      TabIndex        =   21
      Top             =   5280
      Width           =   1155
   End
   Begin CommandButton Cmd 
      Caption         =   "Check"
      Height          =   375
      HelpContextID   =   1000
      Index           =   6
      Left            =   1680
      TabIndex        =   20
      Top             =   5280
      Width           =   1155
   End
   Begin CommandButton Cmd 
      Caption         =   "Identify"
      Height          =   375
      HelpContextID   =   1000
      Index           =   4
      Left            =   1680
      TabIndex        =   19
      Top             =   300
      Width           =   1155
   End
   Begin CommandButton Cmd 
      Caption         =   "Merge"
      Height          =   375
      HelpContextID   =   1300
      Index           =   1
      Left            =   7620
      TabIndex        =   18
      Top             =   1080
      Width           =   1155
   End
   Begin CommandButton Cmd 
      Caption         =   "Restore"
      Height          =   375
      HelpContextID   =   1300
      Index           =   0
      Left            =   7620
      TabIndex        =   17
      Top             =   300
      Width           =   1155
   End
   Begin CommandButton CmdAppS 
      Caption         =   "Add Sprites"
      Height          =   375
      HelpContextID   =   1300
      Left            =   7620
      TabIndex        =   2
      Top             =   4440
      Width           =   1155
   End
   Begin CommandButton CmdJoin 
      Caption         =   "Join "
      Height          =   375
      HelpContextID   =   1300
      Left            =   7560
      TabIndex        =   4
      Top             =   3180
      Width           =   1155
   End
   Begin CommandButton CmdExtract 
      Caption         =   "Extract"
      Height          =   375
      HelpContextID   =   1100
      Left            =   1680
      TabIndex        =   5
      Top             =   3180
      Width           =   1155
   End
   Begin Timer DeuTexTime 
      Enabled         =   0   'False
      Left            =   1680
      Top             =   3780
   End
   Begin CommandButton CmdBuild 
      Caption         =   "Create"
      Height          =   375
      HelpContextID   =   1200
      Left            =   1680
      TabIndex        =   0
      Top             =   4440
      Width           =   1155
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   6
      X1              =   7260
      X2              =   8220
      Y1              =   2940
      Y2              =   2940
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   4
      X1              =   2280
      X2              =   2280
      Y1              =   1680
      Y2              =   540
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   1
      X1              =   8220
      X2              =   7320
      Y1              =   1680
      Y2              =   1680
   End
   Begin Label Info 
      Caption         =   "MERGING"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00800000&
      Height          =   315
      Index           =   6
      Left            =   7500
      TabIndex        =   10
      Top             =   2100
      Width           =   1275
   End
   Begin Label Info 
      Caption         =   "EDITING"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00800000&
      Height          =   315
      Index           =   5
      Left            =   1680
      TabIndex        =   15
      Top             =   2100
      Width           =   1155
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   18
      X1              =   2760
      X2              =   2580
      Y1              =   3900
      Y2              =   3960
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   17
      X1              =   2580
      X2              =   2760
      Y1              =   5040
      Y2              =   5100
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   16
      X1              =   7860
      X2              =   7680
      Y1              =   780
      Y2              =   840
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   13
      X1              =   8160
      X2              =   7260
      Y1              =   5460
      Y2              =   5460
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   11
      X1              =   2280
      X2              =   2280
      Y1              =   5100
      Y2              =   4200
   End
   Begin Label Info 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      BackStyle       =   0  'Transparent
      Caption         =   "Click here for HELP!"
      ForeColor       =   &H00FF0000&
      Height          =   435
      Index           =   1
      Left            =   300
      TabIndex        =   22
      Top             =   1200
      Width           =   975
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   12
      X1              =   7920
      X2              =   7740
      Y1              =   5040
      Y2              =   5100
   End
   Begin Label Info 
      Alignment       =   2  'Center
      Caption         =   "by"
      ForeColor       =   &H00000000&
      Height          =   255
      Index           =   2
      Left            =   300
      TabIndex        =   3
      Top             =   660
      Width           =   315
   End
   Begin Label Info 
      Caption         =   "WinTex 3.4"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00000000&
      Height          =   315
      Index           =   0
      Left            =   120
      TabIndex        =   7
      Top             =   120
      Width           =   1395
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   34
      X1              =   7740
      X2              =   7920
      Y1              =   5100
      Y2              =   5160
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   33
      X1              =   8220
      X2              =   8220
      Y1              =   2940
      Y2              =   5100
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   30
      X1              =   8220
      X2              =   7260
      Y1              =   840
      Y2              =   840
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   29
      X1              =   7860
      X2              =   7680
      Y1              =   900
      Y2              =   840
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   23
      X1              =   3180
      X2              =   2280
      Y1              =   5100
      Y2              =   5100
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   22
      X1              =   8220
      X2              =   7260
      Y1              =   5100
      Y2              =   5100
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   21
      X1              =   2760
      X2              =   2580
      Y1              =   5100
      Y2              =   5160
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   20
      X1              =   2760
      X2              =   2580
      Y1              =   3900
      Y2              =   3840
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   2
      X1              =   2280
      X2              =   3180
      Y1              =   4200
      Y2              =   4200
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   9
      X1              =   7260
      X2              =   7860
      Y1              =   480
      Y2              =   480
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   8
      X1              =   3180
      X2              =   2280
      Y1              =   1680
      Y2              =   1680
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   5
      X1              =   2340
      X2              =   3180
      Y1              =   5460
      Y2              =   5460
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   3
      X1              =   3180
      X2              =   2280
      Y1              =   3900
      Y2              =   3900
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   0
      X1              =   8220
      X2              =   8220
      Y1              =   840
      Y2              =   1680
   End
   Begin Image Sleep 
      BorderStyle     =   1  'Fixed Single
      Height          =   510
      Index           =   0
      Left            =   780
      Picture         =   WINTEX.FRX:0302
      Top             =   540
      Width           =   510
   End
   Begin Label DeuTexRun 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "DeuTex at work!"
      ForeColor       =   &H00000080&
      Height          =   255
      Left            =   60
      TabIndex        =   1
      Top             =   1260
      Visible         =   0   'False
      Width           =   1515
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   32
      X1              =   2280
      X2              =   3180
      Y1              =   2940
      Y2              =   2940
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      Index           =   10
      X1              =   2280
      X2              =   2280
      Y1              =   2940
      Y2              =   3900
   End
   Begin Menu M_Files 
      Caption         =   "&Files"
      Begin Menu M_SetPwad 
         Caption         =   "Select Target &PWAD."
         HelpContextID   =   80
      End
      Begin Menu M_SetData 
         Caption         =   "Select &Working Dir."
         HelpContextID   =   60
      End
      Begin Menu M_SetDoom 
         Caption         =   "Select &Doom Dir."
         HelpContextID   =   90
      End
      Begin Menu M_SetDeh 
         Caption         =   "Select EXE Patch"
      End
      Begin Menu M_ini 
         Caption         =   "&Edit wintex.ini"
         HelpContextID   =   11
      End
      Begin Menu M_Deutex 
         Caption         =   "DeuTex command line"
      End
      Begin Menu M_Quit 
         Caption         =   "&Quit"
      End
   End
   Begin Menu M_0004 
      Caption         =   "&Edit"
      Begin Menu M_Edit 
         Caption         =   "Levels"
         HelpContextID   =   100
         Index           =   0
      End
      Begin Menu M_Edit 
         Caption         =   "Lumps"
         HelpContextID   =   200
         Index           =   1
      End
      Begin Menu M_Edit 
         Caption         =   "Sounds"
         HelpContextID   =   300
         Index           =   2
      End
      Begin Menu M_Edit 
         Caption         =   "Texture1"
         HelpContextID   =   400
         Index           =   3
      End
      Begin Menu M_Edit 
         Caption         =   "Graphics"
         HelpContextID   =   500
         Index           =   4
      End
      Begin Menu M_Edit 
         Caption         =   "Sprites"
         HelpContextID   =   600
         Index           =   5
      End
      Begin Menu M_Edit 
         Caption         =   "Patches"
         HelpContextID   =   700
         Index           =   6
      End
      Begin Menu M_Edit 
         Caption         =   "Flats"
         HelpContextID   =   800
         Index           =   7
      End
      Begin Menu M_Edit 
         Caption         =   "Musics"
         HelpContextID   =   900
         Index           =   8
      End
      Begin Menu M_Edit 
         Caption         =   "Texture2"
         HelpContextID   =   400
         Index           =   9
      End
   End
   Begin Menu M_0003 
      Caption         =   "&Show"
      HelpContextID   =   1000
      Begin Menu M_Contents 
         Caption         =   "&Directory of WAD"
         HelpContextID   =   1020
      End
      Begin Menu M_ListDir 
         Caption         =   "&Identify entries"
         HelpContextID   =   1010
      End
      Begin Menu M_000C 
         Caption         =   "-"
      End
      Begin Menu M_View 
         Caption         =   "Show Sounds"
         HelpContextID   =   1900
         Index           =   0
      End
      Begin Menu M_View 
         Caption         =   "Show Graphics"
         HelpContextID   =   1900
         Index           =   1
      End
      Begin Menu M_View 
         Caption         =   "Show Sprites"
         HelpContextID   =   1900
         Index           =   2
      End
      Begin Menu M_View 
         Caption         =   "Show Patches"
         HelpContextID   =   1900
         Index           =   3
      End
      Begin Menu M_View 
         Caption         =   "Show Flats"
         HelpContextID   =   1900
         Index           =   4
      End
      Begin Menu M_0008 
         Caption         =   "-"
      End
      Begin Menu M_Unused 
         Caption         =   "Show &Wasted Space"
         HelpContextID   =   1030
      End
      Begin Menu M_usedtex 
         Caption         =   "Show &Used Textures"
         HelpContextID   =   1040
      End
      Begin Menu M_Check 
         Caption         =   "Check &WAD"
      End
      Begin Menu M_CheckT 
         Caption         =   "Check &Built WAD"
      End
   End
   Begin Menu M_See 
      Caption         =   "E&xtract"
      HelpContextID   =   1100
      Begin Menu M_Extract 
         Caption         =   "&Extract WAD Entries"
      End
      Begin Menu M_0007 
         Caption         =   "-"
      End
      Begin Menu M_NWT 
         Caption         =   "Use &NewWadTool"
      End
      Begin Menu M_WT 
         Caption         =   "Use &WadTool"
      End
   End
   Begin Menu M_Build 
      Caption         =   "&Build"
      HelpContextID   =   1200
      Begin Menu M_BuildP 
         Caption         =   "Build &PWAD"
      End
      Begin Menu M_BuildI 
         Caption         =   "Build &IWAD"
      End
      Begin Menu M_Check2 
         Caption         =   "&Check WAD"
      End
      Begin Menu M_000E 
         Caption         =   "-"
      End
      Begin Menu M_MAKEFILE 
         Caption         =   "Make &Project File"
         HelpContextID   =   1210
      End
      Begin Menu M_Install 
         Caption         =   "Make &Install File"
         HelpContextID   =   1220
      End
      Begin Menu M_000D 
         Caption         =   "-"
      End
      Begin Menu M_Dhe 
         Caption         =   "Call EXE Editor"
      End
      Begin Menu M_EditDeh 
         Caption         =   "Edit EXE Patch"
      End
   End
   Begin Menu M_0002 
      Caption         =   "&Merge"
      HelpContextID   =   1300
      Begin Menu M_Merge 
         Caption         =   "&Merge PWAD into main WAD"
      End
      Begin Menu M_RestoreI 
         Caption         =   "&Restore main WAD"
      End
      Begin Menu M_0001 
         Caption         =   "-"
      End
      Begin Menu M_Join 
         Caption         =   "&Merge PWAD into PWAD"
      End
      Begin Menu M_AppS 
         Caption         =   "Add all &Sprites"
      End
      Begin Menu M_AppF 
         Caption         =   "Add all &Flats"
      End
      Begin Menu M_App 
         Caption         =   "&Add all Sprites&&Flats"
      End
      Begin Menu M_RestoreP 
         Caption         =   "Restore &PWAD"
      End
   End
   Begin Menu M_Options 
      Caption         =   "&Options"
      HelpContextID   =   1500
      WindowList      =   -1  'True
      Begin Menu M_Transp 
         Caption         =   "&Transparency"
         HelpContextID   =   99
      End
      Begin Menu M_0009 
         Caption         =   "-"
      End
      Begin Menu M_Picture 
         Caption         =   "&BMP picture"
         Index           =   0
      End
      Begin Menu M_Picture 
         Caption         =   "&GIF  picture"
         Index           =   1
      End
      Begin Menu M_Picture 
         Caption         =   "&PPM picture"
         Index           =   2
      End
      Begin Menu M_0000 
         Caption         =   "-"
         Index           =   0
      End
      Begin Menu M_Sound 
         Caption         =   "&WAV sound"
         Index           =   0
      End
      Begin Menu M_Sound 
         Caption         =   "&AU sound"
         Index           =   1
      End
      Begin Menu M_Sound 
         Caption         =   "&VOC sound"
         Index           =   2
      End
   End
   Begin Menu M_0006 
      Caption         =   "&Help"
      Begin Menu M_About 
         Caption         =   "&About"
      End
      Begin Menu M_Author 
         Caption         =   "A&uthor"
      End
      Begin Menu M_Register 
         Caption         =   "&Register"
      End
      Begin Menu M_000B 
         Caption         =   "-"
      End
      Begin Menu M_Help 
         Caption         =   "&Help Contents"
      End
      Begin Menu M_Helpnh 
         Caption         =   "&Using Help"
      End
      Begin Menu M_000A 
         Caption         =   "-"
      End
      Begin Menu M_Tutor 
         Caption         =   "&Tutorial mode"
      End
   End
End
Option Explicit


'handle to deutex application
'to check if it is still running
Dim DeuTexHandle As Integer
'deutex command
Dim DeuTexCommand As String
Dim DeuTexLastCmd As String
'OPTIONS
Dim DeuTexPicture As String
Dim DeuTexSound As String
Dim DeuTexColR%
Dim DeuTexColG%
Dim DeuTexColB%
Dim DeuTexSelect%
'DIRECTORIES
Dim DeuTexDoom As String        'doom directory
Dim DeuTexData As String        'work directory
Dim DeuTexTwad As String        'target pwad
Dim DeuTexSwad As String        'source pwad
Dim DeuTexWadInfo As String     'wadinfo
Dim DehackPatch As String       'dehacked patch
Dim DeuTexDirWad As String      'wad dir

Function Byte2Str (ByVal num%) As String
   If num < 0 Or num >= 256 Then Exit Function
   Byte2Str = Chr$(Int(num / 16) + 64) & Chr$(Int(num And 15) + 64)
End Function

Sub CheckSel_Click (Index As Integer, Value As Integer)
 Dim i%, SelectB%
 SelectB = 0
 For i = 8 To 0 Step -1
    SelectB = SelectB * 2
    If CheckSel(i).Value Then SelectB = SelectB + 1
 Next i
 DeuTexSelect = SelectB
End Sub

Sub Cmd_Click (Index As Integer)
  Select Case Index
  Case 0
   Call M_RestoreI_Click
  Case 2
   Call M_Contents_Click
  Case 1
   Call M_Merge_Click
  Case 4
   Call M_ListDir_Click
  Case 5
   Call M_Unused_Click
  Case 6
   Call M_CheckT_Click
  Case 7
   Call M_RestoreP_Click
  End Select
End Sub

Sub CmdAppF_Click ()
   Call M_AppF_Click
End Sub

Sub CmdAppS_Click ()
  Call M_AppS_Click
End Sub

Sub CmdBuild_Click ()
  Call M_BuildP_Click
End Sub

Sub CmdExtract_Click ()
  Call M_Extract_Click
End Sub

Sub CmdInfo_Click (Index As Integer)
   Select Case Index
     Case 0:
       Call EditTextFile(DeuTexWadInfo)
     Case 1:
       M_SetDoom_Click
     Case 2:
       M_SetData_Click
     Case 3:
       M_SetPwad_Click
   End Select
End Sub

Sub CmdJoin_Click ()
   Call M_Join_Click
End Sub

Sub CmdSel_Click (Index As Integer)
   Dim i%
   Select Case Index
     Case 0
       For i = 0 To 8
         CheckSel(i).Value = False
       Next i
     Case 1   'all
       For i = 0 To 8
         CheckSel(i).Value = True
       Next i
     Case 2
       If Not Tutor("select only the entries you need to create a custom Texture and Flat WAD for use with your level editors.") Then Exit Sub
       For i = 0 To 8
         CheckSel(i).Value = False
       Next i
       CheckSel(3).Value = True 'texture
       CheckSel(6).Value = True 'patch
       CheckSel(7).Value = True 'flat
     Case 3 'only flats    no sprites
       For i = 0 To 8
         CheckSel(i).Value = True
       Next i
       CheckSel(5).Value = False 'no sprites
     Case 4 'only sprites  no flats
       For i = 0 To 8
         CheckSel(i).Value = True
       Next i
       CheckSel(7).Value = False 'no flats
   End Select
End Sub

Sub Deutex (cmd$, ByVal merging%)
 ' call DeuTex
 ' beware that command lines above 128 char will crash SHELL
 ' merging = true if commands = merge/join/app/restor

 'checks
   If DeuTexHandle <> 0 Then
     Call Crash("DeuTex is already running.")
     Exit Sub
   End If
 'init run loop
   Info(1).Visible = False
   DeuTexRun.Visible = False
 'DEUTEX file name
 'DOOM
 'DIRECTORY
'command line
   Dim color$
   'DeuTexColor = "-rgb " & DeuTexColR & " " & DeuTexColG & " " & DeuTexColB
   color$ = Byte2Str(DeuTexColR) & Byte2Str(DeuTexColG) & Byte2Str(DeuTexColB)
   Dim exec As String
   'doom data select color   -out -v3
   If merging% Then
     exec = DeuTexCommand & " -wim "
     exec = exec & DeuTexDoom & " " & DeuTexSelect
   Else
     exec = DeuTexCommand & " -win"
     exec = exec & " " & DeuTexDoom & " " & DeuTexData
     exec = exec & " " & LCase$(Left$(WadInf.Text, 8))
     exec = exec & " " & DeuTexSelect & " " & color$
     exec = exec & " " & DeuTexPicture & " " & DeuTexSound
   End If
   'command
   exec = exec & " " & cmd
   DeuTexLastCmd = exec
   If Len(exec) > 127 Then
     Crash ("The command line of DeuTex is too big for DOS (try using shorter paths).")
     Exit Sub
   End If
   'EXECUTE COMMAND
   DeuTexHandle = Shell(exec, 7)
   'Flashing
   DeuTexTime.Interval = 250 '1/4 second
   DeuTexTime.Enabled = True
End Sub

Sub DeuTexEnds ()
  DeuTexRun.Visible = False
  Info(1).Visible = True
  DeuTexHandle = 0  'not running anymore
  Dim file As String
  'warnings and errors
  file = "error.txt"
  If DIRexistFile(file) Then
    If FileLen(file) > 0 Then
      Dim errors As String
      Open file For Input As #1
      Do
        Line Input #1, errors
        If errors Like "Error: [*][*][*] * [*][*][*]" Then
          errors = Mid$(errors, 11, Len(errors) - 13)
          Call Crash(errors)
        ElseIf errors Like "Warning: [*][*] * [*][*]" Then
          errors = Mid$(errors, 12, Len(errors) - 13)
          If MsgBox(errors, 1 + 48, "Warning") = 2 Then Exit Do
        ElseIf errors Like "Bug: [*][*][*] * [*][*][*]" Then
          errors = "Please report that bug:" & Chr$(10) & Mid$(errors, 10, Len(errors) - 12)
          If MsgBox(errors, 1 + 48, "DeuTex Bug") = 2 Then Exit Do
        End If
        DoEvents
      Loop While Not EOF(1)
      Close #1
      Kill file
    End If
  End If
  'output
  file = "output.txt"
  If DIRexistFile(file) Then
     If FileLen(file) > 0 Then EditTextFile (file)
     Kill file
  End If
  DTxSDir.Refresh
  DTxSWad.Refresh
End Sub

Sub DeuTexTime_Timer ()
   If GetModuleUsage(DeuTexHandle) <= 0 Then
     'DeuTex was canceled
     DeuTexTime.Enabled = False
     Call DeuTexEnds
   Else
     'DeuTex is still running
     Call Running
   End If
End Sub

Sub DTxData_Change ()
  If Not DIRexistDir(DTxData.Caption) Then
    DTxData.Caption = "."
    Exit Sub
  End If
  DeuTexData = DTxData.Caption
  DeuTexWadInfo = MakeFileName(DeuTexData, WadInf.Text & ".txt")
  DehackPatch = MakeFileName(DeuTexData, "custom.deh")
  Dim res As Integer
  Call INIputValue("Directory", "Data", DeuTexData, False)
  ' Read batch file
  Dim bat$
  bat$ = MakeFileName(DeuTexData, "make.bat")
  If Not DIRexistFile(bat$) Then Exit Sub
  Dim doom$, color$, pwad$
  Call ProjectRead(doom$, color$, pwad$, bat$)
  If Len(doom$) > 0 Then
    If DIRexistDir(doom$) Then DTxDoom.Caption = doom$
  End If
  If Len(pwad$) > 0 Then DTxTWad.Caption = pwad$
  If Len(color$) > 0 Then
    'nothing
  End If
End Sub

Sub DTxData_DblClick ()
  Call M_SetData_Click
End Sub

Sub DTxDoom_Change ()
    DeuTexDoom = DTxDoom.Caption
    If Not DIRexistDir(DTxDoom.Caption) Then
        FrameDm.Caption = "Bad Doom directory"
        Exit Sub
    End If
    Static version(10) As String
    '             IWAD----EXE-----TYPE"
    version(0) = "DOOM1   DOOM      11"
    version(1) = "DOOM    DOOM      10"
    version(2) = "DOOM2   DOOM2     12"
    version(3) = "HERETIC1HERETIC   21"
    version(4) = "HERETIC HERETIC   20"
    version(5) = "HERETIC2HERETIC2  22"
    Dim file, exec As String
    Dim n%, typ%
    For n = 0 To 10
      If n >= UBound(version) Then
        FrameDm.Caption = "No Doom files"
        Call InitIWAD("", "", 0)
        Exit Sub
      End If
      file = MakeFileName(DeuTexDoom, Trim$(Left$(version(n), 8)) & ".WAD")
      exec = MakeFileName(DeuTexDoom, Trim$(Mid$(version(n), 8 + 1, 8)) & ".EXE")
      typ = Val(Mid$(version(n), 16 + 1, 4))
      If DIRexistFile(file) Then Exit For
    Next n
    FrameDm.Caption = Trim$(Left$(version(n), 8)) & " directory"
    Dim res As Integer
    Call INIputValue("Directory", "Doom", DeuTexDoom, False)
    'signal IWAD
    Call InitIWAD(file, exec, typ)
End Sub

Sub DTxDoom_DblClick ()
   Call M_SetDoom_Click
End Sub

Sub DTxSDir_Change ()
  DTxSWad.Path = DTxSDir.Path
  DeuTexDirWad = DTxSDir.Path
  Call INIputValue("Directory", "Wads", DeuTexDirWad, False)
  Call ChooseSetDefault(DeuTexDirWad)
  If DTxSWad.ListCount > 0 Then DTxSWad.ListIndex = 0
End Sub

Sub DTxSDriv_Change ()
    Dim old$
    old$ = DTxSDir.Path
    On Error GoTo hell40
    DTxSDir.Path = DTxSDriv.Drive
    Exit Sub
hell40:
    DTxSDir.Path = old$
    Resume Next
End Sub

Sub DTxSWad_Click ()
  If DTxSWad.ListIndex < 0 Then Exit Sub
  Dim file As String
  file = MakeFileName(DTxSWad.Path, DTxSWad.List(DTxSWad.ListIndex))
  If DIRexistFile(file) Then
        DeuTexSwad = file
  End If
End Sub

Sub DTxSWad_KeyDown (KeyCode As Integer, Shift As Integer)
 If KeyCode = KEY_DELETE Then
    If DTxSWad.ListIndex >= 0 Then
      Dim file As String
      file = MakeFileName(DTxSWad.Path, DTxSWad.List(DTxSWad.ListIndex))
      EditDeleteFile (file)
      DTxSWad.Refresh
    End If
 End If
End Sub

Sub DTxTWad_Change ()
  DeuTexTwad = DTxTWad.Caption
  Call INIputValue("Settings", "Target", DeuTexTwad, False)
  'signal the file TWAD to the Edit module
  Call InitTWAD(DeuTexTwad)
End Sub

Sub DTxTWad_DblClick ()
   Call M_SetPwad_Click
End Sub

Sub Form_Load ()

  'don't accept two instances
  If App.PrevInstance Then Unload Me
  'change dir to deutex directory, for DLLs
  Call WinTexInit
 'DeuTex status
  DeuTexTime.Enabled = False
  DeuTexHandle = 0 'not running
  DeuTexCommand = "deutex"
  DeuTexLastCmd = ""
  DeuTexColR = 0
  DeuTexColG = 255
  DeuTexColB = 255
  DeuTexSelect = 511   'all bytes 1
  'DeuTexSwad = ""       'source pwad
  'DeuTexDirWad = ""    'wad dir
  'DeuTexWadInfo = ""    'wadinfo
  'Directory Protections
  Call LockDoom_Click(True)
  'environement variable DOOMWADDIR
  Dim res As String
  'read .INI file
  If INIgetValue("Settings", "Warned") <> "ok" Then
    Load AboutInfo
    AboutInfo.Show 1
    Call INIputValue("Settings", "Warned", "ok", False)
  End If
  'colors
  res = INIgetValue("Transparent", "Red")
  If Len(res) > 0 Then DeuTexColR = Val(res)
  res = INIgetValue("Transparent", "Green")
  If Len(res) > 0 Then DeuTexColG = Val(res)
  res = INIgetValue("Transparent", "Blue")
  If Len(res) > 0 Then DeuTexColB = Val(res)
  'temporary
  
  'DIRECTORIES AND FILES
  res = INIgetValue("Directory", "Doom")
  If Not DIRexistDir(res) Then
    res = Environ$("DOOMWADDIR")
    If Not DIRexistDir(res) Then res = "."
  End If
  DTxDoom.Caption = res
  res = INIgetValue("Directory", "WadInfo")
  If Len(res) < 2 Then res = "wadinfo"
  WadInf.Text = res
  res = INIgetValue("Directory", "Wads")
  If Not DIRexistDir(res) Then res = "."
  DTxSDir.Path = res
  res = INIgetValue("Settings", "Target")
  If Len(res) <= 0 Then res = "default.wad"
  DTxTWad.Caption = res
  res = INIgetValue("Directory", "Data")
  If Not DIRexistDir(res) Then res = "."
  DTxData.Caption = res
  'PICTURE TYPE
  res = UCase$(INIgetValue("Settings", "PicType"))
  Select Case res
    Case "GIF"
      Call M_Picture_Click(1)
    Case "PPM"
      Call M_Picture_Click(2)
    Case Else
      Call M_Picture_Click(0)
  End Select
  'SOUNDS TYPE
  res = UCase$(INIgetValue("Settings", "SoundType"))
  Select Case res
    Case "AU"
      Call M_Sound_Click(1)
    Case "VOC"
      Call M_Sound_Click(2)
    Case Else
      Call M_Sound_Click(0)
  End Select
  res = INIgetValue("Extern", "DeuTex")
  If Len(res) > 0 Then
     DeuTexCommand = res
  Else
     Call INIputValue("Extern", "DeuTex", DeuTexCommand, False)
  End If
End Sub

Sub FrameDm_DblClick ()
   Call Infos("This panel indicates where the main WAD of DOOM, DOOM2 or HERETIC is situated.")
End Sub

Sub FrameSel_DblClick ()
   Call Infos("This panels selects which entry types are to be extracted or built into the PWADs")
End Sub

Sub FrameSWad_DblClick ()
   Call Infos("Choose here an existing WAD you want to examine, merge into another WAD, or decompose into BMP, WAV and TXT files")
End Sub

Sub FrameTrg_DblClick ()
   Call Infos("This panel indicates the name of the WAD you want to build with DeuTex." & Chr$(10) & "Note that it's also the WAD where you should put your new textures and flats before calling the levels editors.")
End Sub

Sub FrameWork_DblClick ()
   Call Infos("This panel indicates directory where to store all sort of data files concerning the WAD you want to build." & Chr$(10) & "The actual data is put in set of subdirectories.")
End Sub

Sub Info_Click (Index As Integer)
   Select Case Index
     Case 0
       Call Infos("WinTex! A Windoze(tm) shell for DeuTex, DeuSF and all the great DOOM and HERETIC utilities.")
     Case 1
       Call Infos("Press F1 for in-context help." & Chr$(10) & "Click on BLUE texts, for more information." & Chr$(10) & "Double Click on frames, to know what they are used for.")
     Case 3
       Call Infos("This is the name of the WAD Information file, a text file that describe the contents of the PWAD you want to build.")
     Case 5
       Call Infos("The left half of screen deals with extracting data from WAD, and rebuilding WAD from data extracted or provided by you (use the Edit menu).")
     Case 6
       Call Infos("This right half of screen deals with the merging or the completion of already existing WADs.")
   End Select
End Sub

Sub InvoqueEditor (Frm As Form, ByVal subd$, ByVal texu%, ByVal typ%)
' Load a form and let it grab the focus
'  This form must contain WorkDirec and WadInfo
'  as an indication of the location of files
'
' texu = FALSE, 1 = TEXTURE1, 2=TEXTURE2
' typ = entry type
  Dim direc$, WadInf$
  direc = DeuTexData
  WadInf = DeuTexWadInfo
  If Not DIRexistDir(direc) Then Exit Sub
  'If Not DIRexistFile(wadinf) Then Exit Sub
  Dim fulld$
 fulld$ = MakeFileName(direc$, subd$)
 If Not DIRexistDir(direc$) Then Exit Sub
 If Not DIRexistDir(fulld$) Then MkDir fulld$
 If Not DIRexistDir(fulld$) Then Exit Sub
 '
 ' Get the list of old entries and prepare
 ' All forms have an EntryNum Scroller (V or H)
 ' and an EntryName listbox[4] or label
 '
 Load Frm
 '
 ' not for levels and lumps
 '
 Select Case typ%
    Case 1'nothing
    Case 0, 2, 3, 4, 5, 6, 7, 8, 9'edit
     Dim res%
     Screen.MousePointer = 11 'wait
     res% = WADinit(Frm.EntryName, typ%, "", DeuTexColR, DeuTexColG, DeuTexColB)
     Screen.MousePointer = 0  'end wait
     If Not res% Then
       Unload Frm
       Crash ("Can't load WAD entries")
       Exit Sub
     End If
 End Select
 Select Case texu%
   Case 1
     Frm.Which.Caption = "1"
   Case 2
     Frm.Which.Caption = "2"
   Case False
 End Select
 '
 ' Declare work directory and wadinfo file
 ' all editor forms have a wadinfo and workdirec label.
 '
 Frm.WorkDirec.Caption = fulld$
 Frm.WadInfo.Caption = WadInf$
 '
 ' start editor
 '
 Me.Hide      ' hide WinTex
 Frm.Show 1   ' show editing frame
 Call WADexit ' editing is finished, forget wad
 Me.Show      ' show WinTex
End Sub

Sub InvoqueViewer (ByVal typ%)
' Load a viewer form and let it grab the focus
' typ = entry type
 If Not DIRexistFile(DeuTexSwad) Then
    Call Crash("No source WAD")
    Exit Sub
 End If
 'load WAD, directory and colors
 Load Viewer
 Dim res%
 Screen.MousePointer = 11 'wait
 res% = WADinit(Viewer.EntryName, typ%, DeuTexSwad, DeuTexColR, DeuTexColG, DeuTexColB)
 Screen.MousePointer = 0  'end wait
 If Not res% Then Exit Sub
 Viewer.WorkDirec.Caption = DTxSDir.Path
 Select Case typ%
   Case 2 'sounds
     Viewer.PicB.Visible = False
     Viewer.Caption = "Play sounds"
   Case 4, 5, 6, 7, 8
     Viewer.PicB.Visible = True
     Viewer.Caption = "View picture"
 End Select
 'wait
 'Screen.MousePointer = 11 'wait
 'Viewer.WorkDirec = "load"  'load EntryName
 'Screen.MousePointer = 0  'end wait
 Me.Hide       ' hide WinTex
 Viewer.Show 1 ' show viewing frame
 Call WADexit  ' editing is finished, forget wad
 Me.Show       ' show WinTex
End Sub

Sub LockDoom_Click (Value As Integer)
 If Value Then
  cmd(1).Enabled = False
  cmd(0).Enabled = False
  M_RestoreI.Enabled = False
  M_Merge.Enabled = False
 Else
  cmd(1).Enabled = True
  cmd(0).Enabled = True
  M_RestoreI.Enabled = True
  M_Merge.Enabled = True
 If Not Tutor("authorise modifications to your main WAD (main game file).") Then Exit Sub
 End If
End Sub

Sub M_About_Click ()
  Load AboutInfo
  AboutInfo.Show 1
  Unload AboutInfo
End Sub

Sub M_App_Click ()
  If Not Tutor("complete the WAD [" & DeuTexTwad & "] with all the sprites and flats in the main WAD.") Then Exit Sub
  If Not DIRexistFile(DeuTexTwad) Then
    Call Crash("No source WAD")
    Exit Sub
  End If
  Call CmdSel_Click(1) 'all
  Call Deutex("-app " & DeuTexTwad, True)
End Sub

Sub M_AppF_Click ()
  If Not Tutor("completes the WAD [" & DeuTexTwad & "] with all the flats in the main WAD." & Chr$(10) & " If your WAD contains custom Floors&Ceilings, this is absolutely needed before playing.") Then Exit Sub
  If Not DIRexistFile(DeuTexTwad) Then
    Call Crash("No source WAD")
    Exit Sub
  End If
  Call CmdSel_Click(3) 'no sprites
  Call Deutex("-app " & DeuTexTwad, True)
End Sub

Sub M_AppS_Click ()
  If Not Tutor("completes the WAD [" & DeuTexTwad & "] with all the sprites in the main WAD." & Chr$(10) & " If your WAD contains custom Sprites, this is absolutely needed before playing.") Then Exit Sub
  If Not DIRexistFile(DeuTexTwad) Then
    Call Crash("No source WAD")
    Exit Sub
  End If
  Call CmdSel_Click(4) 'no flats
  Call Deutex("-app " & DeuTexTwad, True)
End Sub

Sub M_Author_Click ()
  Load AuthorInfo
  AuthorInfo.Show 1
  Unload AuthorInfo
End Sub

Sub M_BuildI_Click ()
  If Not Tutor("build a WAD, using the same conventions as in a main WAD (IWAD). Only Gurus shall use this.") Then Exit Sub
  'build PWAD
  If DIRexistFile(DeuTexTwad) Then
    If Not QueryCancel("Delete Old PWAD?") Then Exit Sub
    Kill DeuTexTwad
  End If
  If Not DIRexistFile(DeuTexWadInfo) Then
    Call Crash("No Wad creation directive")
    Exit Sub
  End If
  Dim cmd As String
  cmd = "-iwad  -make " & DeuTexTwad
  Call Deutex(cmd, False)
End Sub

Sub M_BuildP_Click ()
  If Not Tutor("build a PWAD [" & DeuTexTwad & "], from the data available in your Working Directory." & Chr$(10) & "The Wad structure is described in file [" & DeuTexWadInfo & "].") Then Exit Sub
  'build PWAD
  If DIRexistFile(DeuTexTwad) Then
    If Not QueryCancel("Delete Old PWAD?") Then Exit Sub
    Kill DeuTexTwad
  End If
  If Not DIRexistFile(DeuTexWadInfo) Then
    Call Crash("No Wad creation directive")
    Exit Sub
  End If
  Dim cmd As String
  cmd = "-make " & DeuTexTwad
  Call Deutex(cmd, False)
End Sub

Sub M_Check_Click ()
  If Not Tutor("checks the WAD  [" & DeuTexSwad & "].") Then Exit Sub
  If Not DIRexistFile(DeuTexSwad) Then
    Call Crash("No Source WAD")
    Exit Sub
  End If
  Call Deutex("-check " & DeuTexSwad, False)
End Sub

Sub M_Check2_Click ()
  If Not Tutor("Check the PWAD you just built. Will catch only some of the errors.") Then Exit Sub
  If Not DIRexistFile(DeuTexTwad) Then
    Call Crash("No target WAD")
    Exit Sub
  End If
  Dim cmd As String
  cmd = "-check " & DeuTexTwad
  Call Deutex(cmd, False)
End Sub

Sub M_CheckT_Click ()
  If Not Tutor("checks the WAD  [" & DeuTexTwad & "] that you just built.") Then Exit Sub
  If Not DIRexistFile(DeuTexTwad) Then
    Call Crash("No Target WAD")
    Exit Sub
  End If
  Dim cmd As String
  cmd = "-check " & DeuTexTwad
  Call Deutex(cmd, False)
End Sub

Sub M_Contents_Click ()
  If Not Tutor("list the directory of WAD [" & DeuTexSwad & "], giving the name and size of the WAD  entries.") Then Exit Sub
  Load ListDir
  ListDir.WadFile.Caption = DeuTexSwad
  ListDir.Show 1
End Sub

Sub M_Deutex_Click ()
  If Not Tutor("Display last command send to DeuTex, for reference.") Then Exit Sub
  Call Infos("Last DeuTex Command: " & Chr$(10) & DeuTexLastCmd)
End Sub

Sub M_Dhe_Click ()
  If Not Tutor("call DEHACKED(DOOM) or HHE(HERETIC) to edit the executable. Warning: this is not easy!") Then Exit Sub
  Call CallDeHackEd(DehackPatch, False)
End Sub

Sub M_Edit_Click (Index As Integer)
  'Find Wadinfo.txt and check it
  If DeuTexHandle <> 0 Then
     Call Crash("DeuTex is running. Wait for command completion.")
     Exit Sub
  End If
  Select Case Index
  Case 0 'Levels
    Call InvoqueEditor(EdtLevel, "levels", False, 1)
  Case 1 'Lumps
    Call InvoqueEditor(EdtLump, "lumps", False, 0)
  Case 2 'Sounds
    Call InvoqueEditor(EdtSound, "sounds", False, 2)
  Case 3 'Textures
    Call InvoqueEditor(EdtTextu, "textures", 1, 7)
  Case 4 'Graphics
    Call InvoqueEditor(EdtGraph, "graphics", False, 4)
  Case 5 'Sprites
    Call InvoqueEditor(EdtSprit, "sprites", False, 5)
  Case 6 'Patches
    Call InvoqueEditor(EdtPatch, "patches", False, 6)
  Case 7 'Flats
    Call InvoqueEditor(EdtFlat, "flats", False, 8)
  Case 8 'Musics
    Call InvoqueEditor(EdtMusic, "musics", False, 3)
  Case 9 'Texture2
    Call InvoqueEditor(EdtTextu, "textures", 2, 7)
  End Select
End Sub

Sub M_EditDeh_Click ()
  If Not Tutor("let you view your EXE patch as text file.") Then Exit Sub
  Call EditTextFile(DehackPatch)
End Sub

Sub M_Extract_Click ()
  If Not Tutor("extract data from a WAD file and store it into the working directory.") Then Exit Sub
  If Not DIRexistFile(DeuTexSwad) Then
    Call Crash("No source WAD")
    Exit Sub
  End If
  Dim cmd As String
  cmd = "-o "
  If DIRexistFile(DeuTexWadInfo) Then
     If Not QueryOk("Modify the WAD description file " & DeuTexWadInfo & " ?") Then Exit Sub
     If QueryOk("Preserve existing data file?") Then cmd = ""
  End If
  cmd = cmd & "-extract " & DeuTexSwad
  Call Deutex(cmd, False)
End Sub

Sub M_help_Click ()
  Call WinTexHelp(-1)
End Sub

Sub M_Helpnh_Click ()
   Call WinTexHelp(-3)
End Sub

Sub M_ini_Click ()
  If Not Tutor("edit the WINTEX.INI files, where all settings and external tools are described.") Then Exit Sub
  Call INIedit
End Sub

Sub M_Install_Click ()
  If Not Tutor("create an INSTALL.BAT file, that can install your WAD." & Chr$(10) & "You can then distribute it with your WAD, DEUSF.EXE and DEHACKED.EXE or HHE.EXE.") Then Exit Sub
  Call EditInstallBat(DeuTexData, DeuTexTwad, DehackPatch)
End Sub

Sub M_Join_Click ()
  If Not Tutor("merges the WAD [" & DeuTexSwad & "] into the WAD [" & DeuTexTwad & "].") Then Exit Sub
  If Not DIRexistFile(DeuTexSwad) Then
    Call Crash("No source WAD")
    Exit Sub
  End If
  If Not DIRexistFile(DeuTexTwad) Then
    Call Crash("No target WAD")
    Exit Sub
  End If
  Call CmdSel_Click(1) 'all
  Call Deutex("-join " & DeuTexTwad & " " & DeuTexSwad, True)
End Sub

Sub M_ListDir_Click ()
  If Not Tutor("list the contents of WAD  [" & DeuTexSwad & "] with name, size and identification.") Then Exit Sub
  If Not DIRexistFile(DeuTexSwad) Then
    Call Crash("No source WAD")
    Exit Sub
  End If
  Call Deutex("-wadir " & DeuTexSwad, False)
End Sub

Sub M_MAKEFILE_Click ()
  If Not Tutor("create Makefile [" & DeuTexData & "\make.bat]." & Chr$(10) & "It will store info on your project, and can be used to rebuild your WAD without the need of WinTex.") Then Exit Sub
  Dim color$
  color$ = DeuTexColR & " " & DeuTexColG & " " & DeuTexColB
  Call ProjectMake(DeuTexData, color$, DeuTexWadInfo, DeuTexTwad)
  If Not Tutor("Before you use MAKE.BAT make sure that DEUTEX.EXE is in C:\DOS (or any directory in your PATH)") Then Exit Sub
End Sub

Sub M_Merge_Click ()
  If Not Tutor("merge the WAD " & DeuTexSwad & " into your main WAD." & Chr$(10) & "This can be usefull if your level editor doesn't accept external textures and flats.") Then Exit Sub
  If Not DIRexistFile(DeuTexSwad) Then
    Call Crash("No source WAD")
    Exit Sub
  End If
  Call CmdSel_Click(1) 'all
  Call Deutex("-merge " & DeuTexSwad, True)
End Sub

Sub M_NWT_Click ()
  If Not Tutor("call an NWT (NewWadTool) to let you browse WADs.") Then Exit Sub
  If Not DIRexistFile(DeuTexSwad) Then
    Call Crash("No source WAD")
    Exit Sub
  End If
  Call CallNWT(DeuTexSwad)
End Sub

Sub M_Picture_Click (Index As Integer)
  Dim c As Integer
  For c = 0 To 2
    M_Picture(c).Checked = False
  Next c
  M_Picture(Index).Checked = True
  Select Case (Index)
    Case 0
        DeuTexPicture = "-bmp"
        Call INIputValue("Settings", "PicType", "BMP", False)
    Case 1
        DeuTexPicture = "-gif"
        Call INIputValue("Settings", "PicType", "GIF", False)
    Case 2
        DeuTexPicture = "-ppm"
        Call INIputValue("Settings", "PicType", "PPM", False)
  End Select
  If Index <> 0 Then Call Infos("WinTex can only display BMP files")
End Sub

Sub M_Quit_Click ()
  Unload Me
End Sub

Sub M_Register_Click ()
  Load RegsInfo
  RegsInfo.Show 1
  Unload RegsInfo
End Sub

Sub M_RestoreI_Click ()
  If Not Tutor("restore the main WAD to it's previous state.") Then Exit Sub
  Call Deutex("-res", True)
End Sub

Sub M_RestoreP_Click ()
  If Not Tutor("restores the WAD [" & DeuTexTwad & "] to it's previous state.") Then Exit Sub
  If Not DIRexistFile(DeuTexTwad) Then
    Call Crash("No target WAD")
    Exit Sub
  End If
 Call Deutex("-res " & DeuTexTwad, True)
End Sub

Sub M_SetData_Click ()
  If Not Tutor("select the working directory, where all the PWAD data is to be stored.") Then Exit Sub
  DTxData.Caption = ChooseDir(DeuTexData, "Choose a directory for your project's data files")
  DTxSDir.Refresh
  DTxSWad.Refresh
End Sub

Sub M_SetDeh_Click ()
  If Not Tutor("select the name of your EXE patch. It will be used when creating the installation file.") Then Exit Sub
  Dim pat$
  Select Case typeIWAD()
    Case 10, 11, 12'doom, doom2: dehacked
     pat$ = ChooseFile(DehackPatch, "*.deh", True, "Select a name for Dehacked file (.DHE)")
     If Not pat$ Like "*.deh" Then Exit Sub
    Case 20, 21, 22'heretic: hhe
     pat$ = ChooseFile(DehackPatch, "*.hhe", True, "Select a name for HHE file (.HHE)")
     If Not pat$ Like "*.hhe" Then Exit Sub
  End Select
  DehackPatch = pat$
End Sub

Sub M_SetDoom_Click ()
  If Not Tutor("select the directory of the DOOM, DOOM2 or HERETIC main files.") Then Exit Sub
  DTxDoom.Caption = ChooseDir(DeuTexDoom, "Indicate the directory of DOOM, DOOM2 or HERETIC")
  DTxSDir.Refresh
  DTxSWad.Refresh
End Sub

Sub M_SetPwad_Click ()
  If Not Tutor("select the PWAD that is to be built or modified.") Then Exit Sub
  Dim file$
  If DIRexistFile(DeuTexTwad) Then
    file$ = DeuTexTwad
  Else
    file$ = MakeFileName(DeuTexData, "default.wad")
  End If
  DTxTWad.Caption = ChooseFile(file$, "*.wad", False, "Select a name for the WAD to be built")
  Select Case typeIWAD()
    Case 20, 21, 22   'HERETIC
    If Not LCase$(FileRoot(DTxTWad.Caption)) Like "h*" Then
      Call Infos("PWADs meant to run with HERETIC should have a name begining with 'H'")
    End If
  End Select
End Sub

Sub M_Sound_Click (Index As Integer)
  Dim c As Integer
  For c = 0 To 2
    M_Sound(c).Checked = False
  Next c
  M_Sound(Index).Checked = True
  Select Case (Index)
    Case 0
        DeuTexSound = "-wav"
        Call INIputValue("Settings", "SoundType", "WAV", False)
    Case 1
        DeuTexSound = "-au"
        Call INIputValue("Settings", "SoundType", "AU", False)
    Case 2
        DeuTexSound = "-voc"
        Call INIputValue("Settings", "SoundType", "VOC", False)
  End Select
  If Index <> 0 Then Call Infos("WinTex can only play WAV files")
End Sub

Sub M_Transp_Click ()
   If Not Tutor("set the color that represents transparent areas in your pictures.") Then Exit Sub
   Load Transp
   Transp.ColScroll(0).Value = DeuTexColR
   Transp.ColScroll(1).Value = DeuTexColG
   Transp.ColScroll(2).Value = DeuTexColB
   Transp.Show 1
   DeuTexColR = Transp.ColScroll(0).Value
   DeuTexColG = Transp.ColScroll(1).Value
   DeuTexColB = Transp.ColScroll(2).Value
   Unload Transp
   Call INIputValue("Transparent", "Red", Str$(DeuTexColR), False)
   Call INIputValue("Transparent", "Green", Str$(DeuTexColG), False)
   Call INIputValue("Transparent", "Blue", Str$(DeuTexColB), False)
End Sub

Sub M_Tutor_Click ()
   Call TutorInit(1)
End Sub

Sub M_Unused_Click ()
  If Not Tutor("show the bytes wasted in WAD  [" & DeuTexSwad & "].") Then Exit Sub
  If Not DIRexistFile(DeuTexSwad) Then
    Call Crash("No source WAD")
    Exit Sub
  End If
 Call Deutex("-unu " & DeuTexSwad, False)
End Sub

Sub M_usedtex_Click ()
  If Not Tutor("list the textures actually used in the levels of WAD [" & DeuTexSwad & "]") Then Exit Sub
  If Not DIRexistFile(DeuTexSwad) Then
    Call Crash("No source WAD")
    Exit Sub
  End If
 Call Deutex("-use " & DeuTexSwad, False)
End Sub

Sub M_View_Click (Index As Integer)
  Dim typ%
  Select Case Index
    Case 0 'sounds
      typ% = 2
    Case 1 'all graphics
      typ% = 4
    Case 2 'sprites
      typ% = 5
    Case 3 'patches
      typ% = 6
    Case 4 'flats
      typ% = 8
  End Select
  InvoqueViewer (typ%)
End Sub

Sub M_WT_Click ()
  If Not Tutor("call WT2 (WadTool2) to let you browse WADs. (this is only courtesy to WT)") Then Exit Sub
  If Not DIRexistFile(DeuTexSwad) Then
    Call Crash("No source WAD")
    Exit Sub
  End If
  Call CallWT(DeuTexSwad)
End Sub

Static Sub Running ()
 DeuTexRun.Visible = Not (DeuTexRun.Visible)
End Sub

Sub Sleep_Click (Index As Integer)
   Call M_Author_Click
End Sub

Sub WadInf_Change ()
  Dim i%
  i% = InStr(WadInf.Text, ".")
  If i% > 0 Then WadInf.Text = Left$(WadInf.Text, i% - 1)
  WadInf.Text = Left$(WadInf.Text, 8)
  If Len(WadInf.Text) < 1 Then WadInf.Text = "wadinfo"
  DeuTexWadInfo = MakeFileName(DeuTexData, WadInf.Text & ".txt")
  Call INIputValue("Directory", "WadInfo", WadInf.Text, False)
End Sub

