// opcode.h
// (c) Luc Cluitmans 1995

#ifndef _opcode_h_
#define _opcode_h_

#include "bastypes.h"
#include "wadentry.h"

typedef struct tagScriptInfo ScriptInfo;

enum
{
    WINT_SPECIAL,
    WINT_JUMP,
    WINT_CONDJUMPTRUE,
    WINT_CONDJUMPFALSE,
    WINT_CASE,
    WINT_BUILTIN,
    WINT_KEYWORD,
    WINT_INFIXA, // associative infix operator
    WINT_INFIXB, // nonassociative infix operator
    WINT_COMPARE, // comparison (nonassociative infix operator)
    WINT_CONSTANT,
    WINT_DROP,
    WINT_LOCALVAR,
    WINT_MAPVAR,
    WINT_WORLDVAR,
    
    WINT_ASSIGNLOCAL,
    WINT_ASSIGNMAP,
    WINT_ASSIGNWORLD,
    WINT_MODIFYLOCAL,
    WINT_MODIFYMAP,
    WINT_MODIFYWORLD,

    // printing functions:
    WINT_BEGINPRINT,
    WINT_ENDPRINT,
    WINT_ENDPRINTBOLD,
    WINT_PRINTSTR,
    WINT_PRINTNUM,
    WINT_PRINTCHR,
    
    WINT_SWITCH  // WINT_JUMP can change to this
};

#define OFFSET_LOCAL 0
#define OFFSET_MAP 1
#define OFFSET_WORLD 2

typedef struct tagOpcode
{
    char    *szName;
    WORD    wCnt; // dword count of command
    WORD    wArgCnt; // number of stack arguments taken
    WORD    wPushCnt; // number of arguments pushed
    WORD    wInterpretation; // one of the WINT_xxx values

    // type info:
    //  '0' - untyped
    //  's' - string constant
    //  'T' - thing id
    //  't' - thing type
    //  'S' - special name
    //  'f' - SIDE_FRONT/SIDE_BACK
    //  'F' - LINE_FRONT/LINE_BACK
    //  'g' - game type
    //  'G' - game skill
    //  'b' - ON/OFF
    //  'B  - TRUE/FALSE
    //  'x' - TEXTURE_TOP-TEXTURE_BOTTOM
    //  'k' - key
    //  'n' - sectorsound
    //  'm' - Map
    //  'p' - Puzzle item
    
    char    cRes; // result type
    char    *cArgs; // argument types (either direct or stack)
                    // Can be empty if not relevant or irregular
} Opcode;

// -------------------------------------------------------

// in opcode.c:
BOOL PrintBehavior(ScriptInfo *scr);
BOOL PrintScript(ScriptInfo *psi, int iIdx);
    // returns FALSE on success or TRUE on failure
    // use GetStringBuffer to retrieve error string
void PrintExpression(ScriptInfo *psi, WORD wExpIdx, BOOL bNeedParen);

void PrintConstant(ScriptInfo *psi, DWORD dwValue, char cType);

WORD PrintArgs(ScriptInfo *psi, WORD wExpFrom, WORD wExpMax,
                      WORD wNumArgs, char *lead, BOOL bNeedParen);
    // prints wNumArgs arguments of the expression at index wExpMax.
    // Searching for arguments starts at wExpFrom and can continue
    // to at most wExpMax. 'lead' is printed before the first argument,
    // the interargument separator is fixed to ", ".
    // Returns the number after the last instruction printed (pass to
    // next call of PrintArgs as wExpFrom parameter).
    // 'bNeedParen' sets the 'need parenthesis' flag for infix
    // operators

BOOL PrintGlobalVars(ScriptInfo *psi);
    // Prints a list of all world and map variables used
    // in all scripts of the given behavior.
    // (leaves *psi in LS_BEHAVIOR mode)
    // Returns TRUE on error (retrieve message with GetStringBuffer)

BOOL ScanStringVars(ScriptInfo *psi, WORD wVarType);
    // Scans for variables that are used as string variables.
    // Note: World variables can never be used as string
    // variables.
    // 'wVarType' should be OFFSET_MAP or OFFSET_LOCAL.
    // Returns TRUE on error (retrieve message with GetStringBuffer)

typedef struct tagInstruction Instruction;
WORD LocalVarCnt(Instruction *lpis, WORD wInstCnt);
    // returns maximum local variable number

// -------------------------------------------------------

// In tab_opc.c:
extern Opcode opcodes[];
int OpcodeCount(void);  // returns size of opcode array


// -------------------------------------------------------
#define VERSIONSTRING "DEACC (version 1.1)"

#endif
