// statment.c

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "wadentry.h"
#include "opcode.h"
#include "instruct.h"
#include "statment.h"
#include "specials.h"
#include "goutput.h"
#include "script.h"

int GetStatements(ScriptInfo *psi)
    // return FALSE if ok or TRUE if error. In case of
    // error, retrieve the error message with
    // GetStringBuffer();
{
    WORD wI, wS, wS2, wContinue, wStatCnt, wInstCnt;
    Statement *lpstat;
    Instruction *lpis;
    WORD wArgArr[7];
    
    // sanity check
    if(psi->iLoadLevel != LS_INSTRUCTIONS)
    {
        AccumulateString("Phase Error");
        return(TRUE);
    }
    
    // get statement count
    for(wI=0, wS=0; wI<psi->wCntInst; wI++)
    {
        if(psi->lpis[wI].wXLevel==0) wS++;
    }
    wStatCnt = psi->wCntStat = wS;
    wInstCnt = psi->wCntInst;
    lpis = psi->lpis;

    // allocate memory
    psi->lpstat = lpstat = calloc(wStatCnt, sizeof(Statement));
    if(!lpstat)
    {
        AccumulateString("FATAL: out of memory\n");
        return(TRUE);
    }
    
    // fill basic statement information
    for(wI=0, wS=0; wI<wInstCnt && wS<wStatCnt; wS++, wI++)
    {
        lpstat[wS].wStart = wI;
        lpstat[wS].iLabel = lpis[wI].iLabel;
        // find end of statement
        while(wI<wInstCnt && lpis[wI].wXLevel>0) wI++;
        if(wI>=wInstCnt)
        {
            ClearStringBuffer();
            AccumulateString("FATAL: Unexpected end of instruction list");
            free(lpstat);
            psi->lpstat = NULL;
            return(TRUE);
        }
        lpstat[wS].wLead = wI;
        
        lpstat[wS].wJumpType = JT_NONE;
        if(lpis[wI].wInterpretation==WINT_JUMP ||
           lpis[wI].wInterpretation==WINT_CONDJUMPTRUE ||
           lpis[wI].wInterpretation==WINT_CONDJUMPFALSE ||
           lpis[wI].wInterpretation==WINT_CASE ||
           lpis[wI].wInterpretation==WINT_SWITCH)
        {
            lpstat[wS].wJumpType = JT_UNKNOWN;
        }
        
        // special type info trap for switches:
        if(lpis[wI].wInterpretation==WINT_SWITCH)
        {
            ArgumentArray(psi, wI, wArgArr);
            if(wArgArr[0]!=0xFFFF)
            {
                lpis[wI].cType = opcodes[lpis[wArgArr[0]].lpdw[0]].cRes;
            }
        }
        
        lpstat[wS].wJump = 0xFFFF; // find these later
        lpstat[wS].wDoCnt = 0;
        lpstat[wS].wBreak = 0xFFFF;
        lpstat[wS].wStartLoop = 0xFFFF;
    }
    if(wI!=wInstCnt || wS!=wStatCnt)
    {
        ClearStringBuffer();
        AccumulateString("FATAL: Sync lost (%d!=%d || %d!=%d)",
                         wI, wInstCnt, wS, wStatCnt);
        free(lpstat);
        psi->lpstat = NULL;
        return(TRUE);
    }
    
    // find jump targets
    for(wS=0; wS<wStatCnt; wS++)
    {
        if(lpstat[wS].wJumpType!=JT_NONE)
        {
            // linear search...
            wI = lpis[lpstat[wS].wLead].wJump;
            for(wS2=0; wS2<wStatCnt; wS2++)
            {
                if(lpstat[wS2].wStart == wI)
                {
                    break;
                }
            }
            if(wS2>=wStatCnt)
            {
                ClearStringBuffer();
                AccumulateString("FATAL: Jump target not found");
                free(lpstat);
                psi->lpstat = NULL;
                return(TRUE);
            }
            lpstat[wS].wJump = wS2;
        }
    }
    
    // find jump types
    for(wS=0; wS<wStatCnt; wS++)
    {
        // skip jumps that already got a type
        if(lpstat[wS].wJumpType!=JT_UNKNOWN) continue;

        // sanity check
        if(lpis[lpstat[wS].wLead].wInterpretation == WINT_CASE)
        {
            ClearStringBuffer();
            AccumulateString("FATAL: case without switch");
            free(lpstat);
            psi->lpstat = NULL;
            return(TRUE);
        }
        
        // (1) find switch, case and default
        if(lpis[lpstat[wS].wLead].wInterpretation == WINT_SWITCH)
        {
            // set JT_SWITCH
            lpstat[wS].wJumpType = JT_SWITCH;
            lpstat[wS].wStartLoop = wS;
            
            // find break adress and set JT_CASE labels
            for(wS2=lpstat[wS].wJump;
                wS2<wStatCnt && lpis[lpstat[wS2].wLead].wInterpretation==WINT_CASE;
                wS2++)
            {
                lpstat[wS2].wJumpType = JT_CASE;
            }
            if(wS2>=wStatCnt-1)
            {
                ClearStringBuffer();
                AccumulateString("FATAL: case table never ends");
                free(lpstat);
                psi->lpstat = NULL;
                return(TRUE);
            }
            if(lpis[lpstat[wS2].wLead].wInterpretation!=WINT_DROP)
            {
                ClearStringBuffer();
                AccumulateString("FATAL: case table does not end with DROP");
                free(lpstat);
                psi->lpstat = NULL;
                return(TRUE);
            }
            wS2++; // skip drop
            // is there a default?
            if(lpstat[wS2].iLabel>0)
            {
                lpstat[wS].wBreak = wS2;
            }
            else if(lpis[lpstat[wS2].wLead].wInterpretation!=WINT_JUMP)
            {
                ClearStringBuffer();
                AccumulateString("FATAL: malformed 'default' part of case table");
                free(lpstat);
                psi->lpstat = NULL;
                return(TRUE);
            }
            else
            {
                lpstat[wS2].wJumpType = JT_DEFAULT;
                lpstat[wS].wBreak = ++wS2;
            }
            
            // update breaks
            for(wS2=wS; wS2<lpstat[wS].wJump; wS2++)
            {
                if(lpis[lpstat[wS2].wLead].wInterpretation==WINT_JUMP
                   && lpstat[wS2].wJump == lpstat[wS].wBreak)
                {
                    lpstat[wS2].wJumpType = JT_SWITCHBREAK;
                }
            }
            
            // find terminating break
            wS2 = lpstat[wS].wJump-1;
            if(lpis[lpstat[wS2].wLead].wInterpretation == WINT_JUMP
               && lpstat[wS2].wJumpType == JT_SWITCHBREAK)
            {
                lpstat[wS2].wJumpType = JT_TERMINATOR;
            }
        }
        
        // (2) find 'until(){}' and 'do{}while();' and breaks/continues
        if(lpis[lpstat[wS].wLead].wInterpretation == WINT_CONDJUMPTRUE)
        {
            if(lpstat[wS].wJump<=wS) // jump_if backward: do{}while();
            {
                lpstat[lpstat[wS].wJump].wDoCnt++;
                lpstat[wS].wJumpType = JT_DOWHILE;
                lpstat[wS].wBreak = wS+1;
                lpstat[wS].wStartLoop = lpstat[wS].wJump;
                wContinue = wS;
            }
            else // jump_if forward: until(){};
            {
                lpstat[wS].wJumpType = JT_UNTIL;
                lpstat[wS].wBreak = lpstat[wS].wJump;
                lpstat[wS].wStartLoop = wS;
                wContinue = wS;
                // check if lpstat[lpstat[wS].wJump-1] is valid end-of-loop
                wS2= lpstat[wS].wJump-1;
                if(lpis[lpstat[wS2].wLead].wInterpretation != WINT_JUMP ||
                   lpstat[wS2].wJump != wS)
                {
                    ClearStringBuffer();
                    AccumulateString("FATAL: until(..){} not terminated");
                    free(lpstat);
                    psi->lpstat = NULL;
                    return(TRUE);
                }
                lpstat[wS2].wJumpType = JT_ENDUNTIL;
            }
            // update breaks/continues
            for(wS2=lpstat[wS].wStartLoop;
                wS2<lpstat[wS].wBreak;
                wS2++)
            {
                if(lpis[lpstat[wS2].wLead].wInterpretation == WINT_JUMP)
                {
                    // remember existing jump type
                    // The following operation may correct existing breaks/continues
                    wI = lpstat[wS2].wJumpType;
                    if(lpstat[wS2].wJump == wContinue)
                    {
                        if(wI==JT_UNKNOWN || wI==JT_CONTINUE || wI==JT_BREAK)
                        {
                            lpstat[wS2].wJump = JT_CONTINUE;
                        }
                    }
                    else if(lpstat[wS2].wJump == lpstat[wS].wBreak)
                    {
                        if(wI==JT_UNKNOWN || wI==JT_CONTINUE || wI==JT_BREAK)
                        {
                            lpstat[wS2].wJump = JT_BREAK;
                        }
                    }
                }
            }
        }
        
        // (3) find 'do{}until()' and 'while(){}' and if(){}else{} and if(){} and
        // more breaks/continues
        if(lpis[lpstat[wS].wLead].wInterpretation == WINT_CONDJUMPFALSE)
        {
            if(lpstat[wS].wJump<=wS) // jump_if_not backward: do{}until();
            {
                lpstat[lpstat[wS].wJump].wDoCnt++;
                lpstat[wS].wJumpType = JT_DOUNTIL;
                lpstat[wS].wBreak = wS+1;
                lpstat[wS].wStartLoop = lpstat[wS].wJump;
                wContinue = wS;
            }
            else // jump_if_not forward: while(){}, if, if-else
            {
                // check statement before jump target
                wS2= lpstat[wS].wJump-1;
                if(lpis[lpstat[wS2].wLead].wInterpretation != WINT_JUMP)
                {
                    // single IF
                    lpstat[wS].wJumpType = JT_IF;
                    lpstat[wS].wBreak = lpstat[wS].wJump;
                    lpstat[wS].wStartLoop = wS;
                    wContinue = 0xFFFF;
                }
                else
                {
                    if(lpstat[wS2].wJump==wS) // while
                    {
                        lpstat[wS].wJumpType = JT_WHILE;
                        lpstat[wS2].wJumpType = JT_ENDWHILE;
                        lpstat[wS].wBreak = lpstat[wS].wJump;
                        lpstat[wS].wStartLoop = wS;
                        wContinue = wS;
                    }
                    else if(lpstat[wS2].wJump<=wS2)
                    {
                        // disguised IF...
                        lpstat[wS].wJumpType = JT_IF;
                        lpstat[wS].wBreak = lpstat[wS].wJump;
                        lpstat[wS].wStartLoop = wS;
                        wContinue = 0xFFFF;
                    }
                    else // if-else
                    {
                        lpstat[wS].wJumpType = JT_IFELSE;
                        lpstat[wS2].wJumpType = JT_ELSE; // overwriting CONTINUE is ok!!
                        lpstat[wS].wBreak = lpstat[wS2].wJump;
                        lpstat[wS].wStartLoop = wS;
                        wContinue = 0xFFFF;
                    }
                }
            }
            // update breaks/continues
            if(wContinue!=0xFFFF)
            {
                for(wS2=lpstat[wS].wStartLoop;
                    wS2<lpstat[wS].wBreak;
                    wS2++)
                {
                    if(lpis[lpstat[wS2].wLead].wInterpretation == WINT_JUMP)
                    {
                        // remember existing jump type
                        // The following operation may correct existing breaks/continues
                        wI = lpstat[wS2].wJumpType;
                        if(lpstat[wS2].wJump == wContinue)
                        {
                            if(wI==JT_UNKNOWN || wI==JT_CONTINUE || wI==JT_BREAK)
                            {
                                lpstat[wS2].wJump = JT_CONTINUE;
                            }
                        }
                        else if(lpstat[wS2].wJump == lpstat[wS].wBreak)
                        {
                            if(wI==JT_UNKNOWN || wI==JT_CONTINUE || wI==JT_BREAK)
                            {
                                lpstat[wS2].wJump = JT_BREAK;
                            }
                        }
                    }
                }
            }
        }

    }

    // take a look on types in comparisons
    for(wI=0; wI<psi->wCntInst; wI++)
    {
        if(psi->lpis[wI].wInterpretation == WINT_COMPARE)
        {
            ArgumentArray(psi, wI, wArgArr);
            if(wArgArr[0]!=0xFFFF && wArgArr[1]!=0xFFFF)
            {
                if(opcodes[lpis[wArgArr[0]].lpdw[0]].cRes != 0)
                {
                    lpis[wArgArr[1]].cType = opcodes[lpis[wArgArr[0]].lpdw[0]].cRes;
                }
                if(opcodes[lpis[wArgArr[1]].lpdw[0]].cRes != 0)
                {
                    lpis[wArgArr[0]].cType = opcodes[lpis[wArgArr[1]].lpdw[0]].cRes;
                }
            }
        }
    }
    
    psi->iLoadLevel = LS_STATEMENTS;

    // check local vars
    if(psi->pwLVarType)
    {
        free(psi->pwLVarType);
        psi->pwLVarType = NULL;
    }
    psi->wLVarCnt = LocalVarCnt(psi->lpis, psi->wCntInst);
    if(psi->wLVarCnt>0)
    {
        psi->pwLVarType = calloc(psi->wLVarCnt, sizeof(WORD));
        if(!psi->pwLVarType)
        {
            AccumulateString("Out of memory");
            return(TRUE);
        }
        if(ScanStringVars(psi, OFFSET_LOCAL))
        {
            return(TRUE);
        }
    }
    
    // take a look on types in mapvar/localvar assignments
    for(wI=0; wI<psi->wCntInst; wI++)
    {
        if(psi->lpis[wI].wInterpretation == WINT_ASSIGNMAP)
        {
            if(lpis[wI].lpdw[1]<psi->wMVarCnt &&
               (psi->pwMVarType[lpis[wI].lpdw[1]]&VAR_USEDASSTRING))
            {
                ArgumentArray(psi, wI, wArgArr);
                lpis[wArgArr[0]].cType = 's';
            }
        }
        if(psi->lpis[wI].wInterpretation == WINT_ASSIGNLOCAL)
        {
            if(lpis[wI].lpdw[1]<psi->wLVarCnt &&
               (psi->pwLVarType[lpis[wI].lpdw[1]]&VAR_USEDASSTRING))
            {
                ArgumentArray(psi, wI, wArgArr);
                lpis[wArgArr[0]].cType = 's';
            }
        }
    }
    
    return(FALSE);
}

// EOF
