// Opcode table functions

#include "opcode.h"

Opcode opcodes[] =
{
    // opcodes that should not appear in the final output are prefixed with '$'
    {"$nop",            0,  0,  0,  WINT_BUILTIN,       '0',    ""},
    {"terminate",       0,  0,  0,  WINT_KEYWORD,       '0',    ""},
    {"suspend",         0,  0,  0,  WINT_KEYWORD,       '0',    ""},
    {"$push",           1,  0,  1,  WINT_CONSTANT,      '0',    ""},
    {"$spec1 ",         1,  1,  0,  WINT_SPECIAL,       '0',    ""},
    {"$spec2 ",         1,  2,  0,  WINT_SPECIAL,       '0',    ""},
    {"$spec3 ",         1,  3,  0,  WINT_SPECIAL,       '0',    ""},
    {"$spec4 ",         1,  4,  0,  WINT_SPECIAL,       '0',    ""},
    {"$spec5 ",         1,  5,  0,  WINT_SPECIAL,       '0',    ""},
    {"$spec1 ",         2,  0,  0,  WINT_SPECIAL,       '0',    ""},
    {"$spec2 ",         3,  0,  0,  WINT_SPECIAL,       '0',    ""},
    {"$spec3 ",         4,  0,  0,  WINT_SPECIAL,       '0',    ""},
    {"$spec4 ",         5,  0,  0,  WINT_SPECIAL,       '0',    ""},
    {"$spec5 ",         6,  0,  0,  WINT_SPECIAL,       '0',    ""},
    {"+",               0,  2,  1,  WINT_INFIXA,        '0',    ""},
    {"-",               0,  2,  1,  WINT_INFIXB,        '0',    ""},
    {"*",               0,  2,  1,  WINT_INFIXA,        '0',    ""},
    {"/",               0,  2,  1,  WINT_INFIXB,        '0',    ""},
    {"%",               0,  2,  1,  WINT_INFIXB,        '0',    ""},
    {" == ",            0,  2,  1,  WINT_COMPARE,       '0',    ""},
    {" != ",            0,  2,  1,  WINT_COMPARE,       '0',    ""},
    {" < ",             0,  2,  1,  WINT_COMPARE,       '0',    ""},
    {" > ",             0,  2,  1,  WINT_COMPARE,       '0',    ""},
    {" <= ",            0,  2,  1,  WINT_COMPARE,       '0',    ""},
    {" >= ",            0,  2,  1,  WINT_COMPARE,       '0',    ""},
    {"=",               1,  1,  0,  WINT_ASSIGNLOCAL,   '0',    ""},
    {"=",               1,  1,  0,  WINT_ASSIGNMAP,     '0',    ""},
    {"=",               1,  1,  0,  WINT_ASSIGNWORLD,   '0',    ""},
    {"$push var",       1,  0,  1,  WINT_LOCALVAR,      '0',    ""},
    {"$push map",       1,  0,  1,  WINT_MAPVAR,        '0',    ""},
    {"$push world",     1,  0,  1,  WINT_WORLDVAR,      '0',    ""},
    {"+=",              1,  1,  0,  WINT_ASSIGNLOCAL,   '0',    ""},
    {"+=",              1,  1,  0,  WINT_ASSIGNMAP,     '0',    ""},
    {"+=",              1,  1,  0,  WINT_ASSIGNWORLD,   '0',    ""},
    {"-=",              1,  1,  0,  WINT_ASSIGNLOCAL,   '0',    ""},
    {"-=",              1,  1,  0,  WINT_ASSIGNMAP,     '0',    ""},
    {"-=",              1,  1,  0,  WINT_ASSIGNWORLD,   '0',    ""},
    {"*=",              1,  1,  0,  WINT_ASSIGNLOCAL,   '0',    ""},
    {"*=",              1,  1,  0,  WINT_ASSIGNMAP,     '0',    ""},
    {"*=",              1,  1,  0,  WINT_ASSIGNWORLD,   '0',    ""},
    {"/=",              1,  1,  0,  WINT_ASSIGNLOCAL,   '0',    ""},
    {"/=",              1,  1,  0,  WINT_ASSIGNMAP,     '0',    ""},
    {"/=",              1,  1,  0,  WINT_ASSIGNWORLD,   '0',    ""},
    {"%=",              1,  1,  0,  WINT_ASSIGNLOCAL,   '0',    ""},
    {"%=",              1,  1,  0,  WINT_ASSIGNMAP,     '0',    ""},
    {"%=",              1,  1,  0,  WINT_ASSIGNWORLD,   '0',    ""},
    {"++",              1,  0,  0,  WINT_MODIFYLOCAL,   '0',    ""},
    {"++",              1,  0,  0,  WINT_MODIFYMAP,     '0',    ""},
    {"++",              1,  0,  0,  WINT_MODIFYWORLD,   '0',    ""},
    {"--",              1,  0,  0,  WINT_MODIFYLOCAL,   '0',    ""},
    {"--",              1,  0,  0,  WINT_MODIFYMAP,     '0',    ""},
    {"--",              1,  0,  0,  WINT_MODIFYWORLD,   '0',    ""},
    {"$jump",           1,  0,  0,  WINT_JUMP,          '0',    ""},
    {"$jump_if",        1,  1,  0,  WINT_CONDJUMPTRUE,  '0',    ""},
    {"$drop",           0,  1,  0,  WINT_DROP,          '0',    ""},
    {"delay",           0,  1,  0,  WINT_BUILTIN,       '0',    ""},
    {"delay",           1,  0,  0,  WINT_BUILTIN,       '0',    ""},
    {"random",          0,  2,  1,  WINT_BUILTIN,       '0',    ""},
    {"random",          2,  0,  1,  WINT_BUILTIN,       '0',    ""},
    {"thingcount",      0,  2,  1,  WINT_BUILTIN,       '0',    "tT"},
    {"thingcount",      2,  0,  1,  WINT_BUILTIN,       '0',    ""},
    {"tagwait",         0,  1,  0,  WINT_BUILTIN,       '0',    ""},
    {"tagwait",         1,  0,  0,  WINT_BUILTIN,       '0',    ""},
    {"polywait",        0,  1,  0,  WINT_BUILTIN,       '0',    ""},
    {"polywait",        1,  0,  0,  WINT_BUILTIN,       '0',    ""},
    {"changefloor",     0,  2,  0,  WINT_BUILTIN,       '0',    "0s"},
    {"changefloor",     2,  0,  0,  WINT_BUILTIN,       '0',    "0s"},
    {"changeceiling",   0,  2,  0,  WINT_BUILTIN,       '0',    "0s"},
    {"changeceiling",   2,  0,  0,  WINT_BUILTIN,       '0',    "0s"},
    {"restart",         0,  0,  0,  WINT_KEYWORD,       '0',    ""},
    {" && ",            0,  2,  1,  WINT_INFIXA,        '0',    ""},
    {" || ",            0,  2,  1,  WINT_INFIXA,        '0',    ""},
    {"&",               0,  2,  1,  WINT_INFIXA,        '0',    ""},
    {"|",               0,  2,  1,  WINT_INFIXA,        '0',    ""},
    {"^",               0,  2,  1,  WINT_INFIXA,        '0',    ""},
    {"!",               0,  1,  1,  WINT_BUILTIN,       '0',    ""},
    {"<<",              0,  2,  1,  WINT_INFIXB,        '0',    ""},
    {">>",              0,  2,  1,  WINT_INFIXB,        '0',    ""},
    {"-",               0,  1,  1,  WINT_BUILTIN,       '0',    ""},
    {"$jump_if_not",    1,  1,  0,  WINT_CONDJUMPFALSE, '0',    ""},
    {"lineside",        0,  0,  1,  WINT_BUILTIN,       'F',    ""},
    {"scriptwait",      0,  1,  0,  WINT_BUILTIN,       '0',    ""},
    {"scriptwait",      1,  0,  0,  WINT_BUILTIN,       '0',    ""},
    {"clearlinespecial",0,  0,  0,  WINT_BUILTIN,       '0',    ""},
    {"$case_jump",      2,  1,  1,  WINT_CASE,          '0',    ""},
    {"$beginprint",     0,  0,  0,  WINT_BEGINPRINT,    '0',    ""},
    {"$endprint",       0,  0,  0,  WINT_ENDPRINT,      '0',    ""},
    {"$printstring",    0,  1,  0,  WINT_PRINTSTR,      '0',    "s"},
    {"$printnum",       0,  1,  0,  WINT_PRINTNUM,      '0',    ""},
    {"$printchar",      0,  1,  0,  WINT_PRINTCHR,      '0',    ""},
    {"playercount",     0,  0,  1,  WINT_BUILTIN,       '0',    ""},
    {"gametype",        0,  0,  1,  WINT_BUILTIN,       'g',    ""},
    {"gameskill",       0,  0,  1,  WINT_BUILTIN,       'G',    ""},
    {"timer",           0,  0,  1,  WINT_BUILTIN,       '0',    ""},
    {"sectorsound",     0,  2,  0,  WINT_BUILTIN,       '0',    "s0"},
    {"ambientsound",    0,  2,  0,  WINT_BUILTIN,       '0',    "s0"},
    {"soundsequence",   0,  1,  0,  WINT_BUILTIN,       '0',    "s"},
    {"setlinetexture",  0,  4,  0,  WINT_BUILTIN,       '0',    "0fxs"},
    {"setlineblocking", 0,  2,  0,  WINT_BUILTIN,       '0',    "0b"},
    {"setlinespecial",  0,  7,  0,  WINT_BUILTIN,       '0',    "0S000000"},
    {"thingsound",      0,  3,  0,  WINT_BUILTIN,       '0',    "Ts0"},
    {"$endprintbold",   0,  0,  0,  WINT_ENDPRINTBOLD,  '0',    ""}
};


int OpcodeCount(void)
{
    return(sizeof(opcodes)/sizeof(opcodes[0]));
}

// EOF
