/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'U'

#include "lbwintex.h"
#include "lbcommon.h"
#include <stdlib.h>

#include "lbwad.h"
#include "lbdispl.h"
#include "lbsound.h"
#include "lbtext.h"

#include "lbwaddef.h"
#include "lbdoom.h"
#include "lbwaddir.h"
#include "lbwadir.h"
#include "lblumps.h"
#include "lbduke.h"


/****************************************************\
*
*
* Duke ART
*
*
\****************************************************/
#if (DLLFORDUKE)
/*
** ART Directory Iterator
*/
struct ARTDIR
{ pInt8  Dir;
  Int32 Start;
  Int32 Size;
  Int16 SzX;
  Int16 SzY;
  Int16 Entry;
};
typedef struct ARTDIR PTR *pARTDIR;

static Int16 WADartDirInit(pARTDIR Dir, pWADDEF This, Int16 Entry)
{
  Dir->Dir=WADreadEntryPartI(This, Entry, 0x0, 0x410);
  if(Dir->Dir==NULL)
  { return -1;}
  Dir->Entry=-1;
  Dir->Start=0x810;
  Dir->Size=0;
  Dir->SzX=0;
  Dir->SzY=0;
  return 1;
}
static Int16 WADartDirNext(pARTDIR Dir)
{
  Int16 n;
  n= Dir->Entry+1;
  if((n<0)||(n>=256))
  { return -1; }/*last*/
  Dir->Entry = n;
  Dir->Start += Dir->Size;
  n = n* sizeof(Int16);
  Dir->SzX = *((pInt16)(&(Dir->Dir[0x010+n])));
  Dir->SzY = *((pInt16)(&(Dir->Dir[0x210+n])));
  Dir->Size = ((Int32)Dir->SzX)*((Int32)Dir->SzY);
  return Dir->Entry;
}
static void WADartDirFree(pARTDIR Dir)
{
  Free(Dir->Dir);
  Dir->Dir=NULL;
  /*do not reset Start, Size, SzX, SzY*/
}

/*
** List ART directory
*/
Int16 WADartDirList(pWADDEF This, Int16 Entry, pWINDOZE Wnd)
{
  TXTOBJ Txt;
  struct ARTDIR Dir;
  Int8 Name[16];
  /**/
  if(This==NULL){return BAD_PARM;}
  /*
  ** read directory lump
  */
  if(WADartDirInit(&Dir,This,Entry)<0)
  { return BAD_ENTRY ;}
  /**/
  if(TXTinitWnd(&Txt,NORMALISELEN,Wnd)<0)
  { WADartDirFree(&Dir); return ERR_BUG; }
  /*
  ** List directory
  */
  while(WADartDirNext(&Dir)>=0)
  { /*
	 ** skip void entry
	 */
	 if((Dir.SzX<=0)||(Dir.SzY<=0)) continue;
	 /*
	 ** Print
	 */
	 Strcpy(Name,"Art ");
	 StrcatNum(Name,Dir.SzX,10);
	 Strcat(Name,"x");
	 StrcatNum(Name,Dir.SzY,10);
	 if(TXTprintName(&Txt, Dir.Entry, Name,sizeof(Name))<0)
	 { break; }
  }
  /**/
  WADartDirFree(&Dir);
  /**/
  TXTfree(&Txt);
  /**/
  return 1;
}
/*
** Get ART picture from directory
*/
Int16 WADartToBmp(pWADDEF This, pBMPOBJ Bmp, Int16 Entry, Int16 Art)
{
  pInt8 Lmp=NULL;
  Int16 SzX,SzY,res;
  struct ARTDIR Dir;
  /**/
  if(This==NULL)
  { return BAD_ENTRY;}
  if((Art<0)||(Art>=256))
  { ERRfault(BAD_PARM); return BAD_ENTRY;}
  /*
  ** read directory lump
  */
  if(WADartDirInit(&Dir,This,Entry)<0)
  { return BAD_ENTRY;}
  /*
  ** Search directory
  */
  while(WADartDirNext(&Dir)>=0)
  { /* skip void entry */
	 if((Dir.SzX<=0)||(Dir.SzY<=0)) continue;
	 /* find entry */
	 if(Dir.Entry>= Art) break;
  }
  /*
  ** Read picture entry (Start,Size)
  */
  SzX=Dir.SzX;
  SzY=Dir.SzY;
  if(Dir.Size>0)
  { Lmp=WADreadEntryPartI(This, Entry, Dir.Start, Dir.Size);}
  WADartDirFree(&Dir);
  if(Lmp==NULL)
  { return BAD_ENTRY;}
  /**/
  res=BMPinitDukePic(Bmp,Lmp, SzX, SzY);
  Free(Lmp);
  return res;
}

#endif /*DLLFORDUKE*/

